"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateManager = void 0;
var _integration_reader = require("./integration_reader");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class TemplateManager {
  constructor(readers) {
    _defineProperty(this, "readers", void 0);
    this.readers = readers;
  }
  async getIntegrationList() {
    const lists = await Promise.all(this.readers.map(reader => this.getReaderIntegrationList(reader)));
    const flattened = lists.flat();

    // If there are collisions by name, prioritize earlier readers over later ones.
    const seen = new Set();
    return flattened.filter(item => {
      if (seen.has(item.name)) {
        return false;
      }
      seen.add(item.name);
      return true;
    });
  }
  async getReaderIntegrationList(reader) {
    const folders = await reader.findIntegrations();
    if (!folders.ok) {
      return [];
    }
    const integrations = await Promise.all(folders.value.map(integrationName => this.getReaderIntegration(reader, integrationName)));
    return integrations.filter(x => x !== null);
  }
  async getIntegration(integrationName) {
    const maybeIntegrations = await Promise.all(this.readers.map(reader => this.getReaderIntegration(reader, integrationName)));
    for (const maybeIntegration of maybeIntegrations) {
      if (maybeIntegration !== null) {
        return maybeIntegration;
      }
    }
    return null;
  }
  async getReaderIntegration(reader, integrationName) {
    if ((await reader.getDirectoryType(integrationName)) !== 'integration') {
      return null;
    }
    const integ = new _integration_reader.IntegrationReader(integrationName, reader.join(integrationName));
    const checkResult = await integ.getConfig();
    if (!checkResult.ok) {
      return null;
    }
    return integ;
  }
}
exports.TemplateManager = TemplateManager;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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