/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.keycloak.client.cli.config.RealmConfigData;
import org.keycloak.client.cli.util.ConfigUtil;
import org.keycloak.client.cli.util.IoUtil;
import org.keycloak.client.cli.util.OsUtil;
import org.keycloak.client.registration.cli.KcRegMain;
import org.keycloak.client.registration.cli.commands.AbstractAuthOptionsCmd;
import picocli.CommandLine;

@CommandLine.Command(name="registration-token", description={"[--server SERVER] --realm REALM --client CLIENT [--delete | TOKEN] [ARGUMENTS]"})
public class ConfigRegistrationTokenCmd
extends AbstractAuthOptionsCmd {
    @CommandLine.Option(names={"-d", "--delete"}, description={"Indicates that initial access token should be removed"})
    private boolean delete;
    @CommandLine.Parameters(arity="0..1")
    private String token;

    @Override
    protected boolean nothingToDo() {
        return super.nothingToDo() && this.token == null && !this.delete;
    }

    @Override
    protected void process() {
        if (this.server == null) {
            throw new IllegalArgumentException("Required option not specified: --server");
        }
        if (this.realm == null) {
            throw new IllegalArgumentException("Required option not specified: --realm");
        }
        if (this.clientId == null) {
            throw new IllegalArgumentException("Required option not specified: --client");
        }
        this.checkUnsupportedOptions("--user", this.user, "--password", this.password, "--secret", this.secret, "--keystore", this.keystore, "--storepass", this.storePass, "--keypass", this.keyPass, "--alias", this.alias, "--truststore", this.trustStore, "--trustpass", this.keyPass, "--no-config", ConfigRegistrationTokenCmd.booleanOptionForCheck(this.noconfig));
        if (!this.delete && this.token == null) {
            this.token = IoUtil.readSecret("Enter Registration Access Token: ");
        }
        String registrationToken = this.token;
        ConfigUtil.saveMergeConfig(config -> {
            RealmConfigData rdata = config.getRealmConfigData(this.server, this.realm);
            if (this.delete) {
                if (rdata != null) {
                    rdata.getClients().remove(this.clientId);
                }
            } else {
                config.ensureRealmConfigData(this.server, this.realm).getClients().put(this.clientId, registrationToken);
            }
        });
    }

    @Override
    protected String help() {
        return ConfigRegistrationTokenCmd.usage();
    }

    public static String usage() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + KcRegMain.CMD + " config registration-token --server SERVER --realm REALM --client CLIENT [--delete | TOKEN] [ARGUMENTS]");
        out.println();
        out.println("Command to configure a registration access token to be used with 'kcreg get / update / delete' commands. Even if an ");
        out.println("authenticated session exists as a result of '" + KcRegMain.CMD + " config credentials' its access token will not be used - registration");
        out.println("access token will be used instead.");
        out.println();
        out.println("Arguments:");
        out.println();
        out.println("  Global options:");
        out.println("    -x                      Print full stack trace when exiting with error");
        out.println("    --config                Path to the config file (" + KcRegMain.DEFAULT_CONFIG_FILE_STRING + " by default)");
        out.println();
        out.println("  Command specific options:");
        out.println("    --server SERVER         Server endpoint url (e.g. 'http://localhost:8080')");
        out.println("    --realm REALM           Realm name to use");
        out.println("    --client CLIENT         ClientId of client whose token to set");
        out.println("    -d, --delete            Indicates that registration access token should be removed");
        out.println("    TOKEN                   Registration access token (prompted for if not specified, unless -d is used)");
        out.println();
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Specify registration access token for server, and realm. Token is passed via env variable:");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " config registration-token --server http://localhost:9080 --realm master --client my_client " + OsUtil.OS_ARCH.envVar("TOKEN"));
        out.println();
        out.println("Remove registration access token:");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " config registration-token --server http://localhost:9080 --realm master --client my_client --delete");
        out.println();
        out.println();
        out.println("Use '" + KcRegMain.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

