/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.permission;

import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DefaultEvaluation;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.provider.permission.AbstractPermissionProvider;

public class ResourcePolicyProvider
extends AbstractPermissionProvider {
    private static final Logger logger = Logger.getLogger(ResourcePolicyProvider.class);

    @Override
    public void evaluate(Evaluation evaluation) {
        logger.debugv("Resource policy {} evaluating using parent class", (Object)evaluation.getPolicy().getName());
        DefaultEvaluation defaultEvaluation = (DefaultEvaluation)DefaultEvaluation.class.cast(evaluation);
        Map decisionCache = defaultEvaluation.getDecisionCache();
        Policy policy = defaultEvaluation.getParentPolicy();
        Map decisions = decisionCache.computeIfAbsent(policy, p -> new HashMap());
        ResourcePermission permission = evaluation.getPermission();
        Decision.Effect effect = (Decision.Effect)decisions.get(permission.getResource());
        if (effect != null) {
            defaultEvaluation.setEffect(effect);
            return;
        }
        super.evaluate(evaluation);
        decisions.put(permission.getResource(), defaultEvaluation.getEffect());
    }
}

