/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AdminClientRegisteredContext;
import org.keycloak.services.clientpolicy.context.AdminClientUpdatedContext;
import org.keycloak.services.clientpolicy.context.SamlAuthnRequestContext;
import org.keycloak.services.clientpolicy.context.SamlLogoutRequestContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SamlSignatureEnforcerExecutor
implements ClientPolicyExecutorProvider<ClientPolicyExecutorConfigurationRepresentation> {
    public SamlSignatureEnforcerExecutor(KeycloakSession session) {
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTERED: {
                this.confirmSignaturesAreForcedRegister(((AdminClientRegisteredContext)context).getTargetClient());
                break;
            }
            case UPDATED: {
                this.confirmSignaturesAreForcedRegister(((AdminClientUpdatedContext)context).getTargetClient());
                break;
            }
            case SAML_AUTHN_REQUEST: {
                this.confirmSignaturesAreForced(((SamlAuthnRequestContext)context).getClient(), "invalid_request");
                break;
            }
            case SAML_LOGOUT_REQUEST: {
                this.confirmSignaturesAreForced(((SamlLogoutRequestContext)context).getClient(), "invalid_request");
            }
        }
    }

    public String getProviderId() {
        return "saml-signature-enforcer";
    }

    private boolean signaturesAreForced(boolean clientSignature, boolean serverSignature, boolean assertionSignature) {
        return clientSignature && (serverSignature || assertionSignature);
    }

    private void confirmSignaturesAreForcedRegister(ClientModel client) throws ClientPolicyException {
        if ("saml".equals(client.getProtocol())) {
            this.confirmSignaturesAreForced(client, "invalid_client_metadata");
        }
    }

    private void confirmSignaturesAreForced(ClientModel client, String error) throws ClientPolicyException {
        SamlClient samlClient = new SamlClient(client);
        if (!this.signaturesAreForced(samlClient.requiresClientSignature(), samlClient.requiresRealmSignature(), samlClient.requiresAssertionSignature())) {
            throw new ClientPolicyException(error, "Signatures not ensured for the client. Ensure Client signature required and Sign documents or Sign assertions are ON");
        }
    }
}

