.TH XGOBAN 6  "15 May 1992"
.SH NAME
xgoban - X11 files editor for the game of go / 
interface to gnugo and wally
.SH SYNOPSIS
.B xgoban 
[ 
.B \-toolkitoptions ...
]
[ 
.B \-options ... 
]
[ \fIfilename\fP ]
.SH DESCRIPTION
.PP
\fIxgoban\fP works under 3 major modes : Edit, Play and Mail.
.LP
In Edit mode, the \fIxgoban\fP program displays a go board and allows 
the user to edit go files. 
It can read and write files with the Smart-Go format. 
When started in Edit mode, \fIxgoban\fP shows 2 windows : one for the
board and the other to display comments.
The title of the comment window is set to the name of current node if
there is one.
The title of the board is set to the name of the current game.
.LP
In Play mode, \fIxgoban\fP can be used to play against go
programs (currently supported : wally and gnugo) or against human opponent.
The game can also be saved with the Smart-Go format.
When started in Play mode, the program can switch to Edit mode and thus
allows the user to edit the played game.
There is no comment window in this mode.
.LP
Mail mode is designed to be used in combination with the \fImailgo\fP
script from Adrian Mariano.
.SH OPTIONS
\fIxgoban\fP accepts all of the standard toolkit command line options as
well as the following :
.TP 8
.B \-size \fIsize\fP
This option specifies the size of the goban : \fIsize\fP must range between
2 and 19. It can be used in Play or Edit mode. The default size is 19.
.TP 8
.B \-handicap \fIhandicap\fP
In Play mode, this option specifies the number of handicap stones that 
are to be put on the goban before the game starts. 
Legal values for \fIhandicap\fP depend on the size of the board and on
the playing program. 
Whitin Edit mode, a first node is created and handicap stones are put 
under the AddBlack property.
.TP 8
.B \-black \fIblackplayer\fP
This options indicates the name of the black player. \fIxgoban\fP 
is started within Play mode and \fIblackplayer\fP is added on the root 
node under the PlayerBlack property. 
\fIxgoban\fP recognize 2 program names : gnugo and wally.
When \fIblackplayer\fP is one of them, an attempt is made to run the
corresponding program (which must be found using the current environment variable
PATH).
.TP 8
.B \-white \fIwhiteplayer\fP
This option is the same as -black, but for the white player.
.TP 8
.B \-path \fIpath\fP
This option specifies the path where files are searched before loading them.
A \fIpath\fp is a comma separated list of directories.
.TP 8
.B \-pointSize \fIsize\fP
This option specifies the size in pixels for a small square of the board.
.TP 8
.B \-nonumber
This option turns off the automatic numbering facility.
.TP 8
.B \-silent
.br
This option turns off the bell.
.B \-beep \fIvolume\fP
.br
This option specifies the volume of the bell when it is not turned off.
Legal values range between -100 and 100. 
I am not sure it will work on all keyboards ...
Default value is 0. 
.TP 8
.B \-versatile
This option turns off strong verification of the tree : see below.
This also turns off the automatic numbering facility.
.TP 8
.B \-help
.br
Displays a list of allowed options.
\fIxgoban\fP is not started.
.TP 8
.B [ \-mail | \-m ] \fImailfile\fP
Start \fIxgoban\fP in Mail mode. A file should be specified with 
\fIfilename\fP argument. This file is read, and \fIxgoban\fP automatically
moves to the end of the main variation. 
When you quit \fIxgoban\fP, the game tree will be saved to
\fImailfile\fP. The exit value will be 0 if a move has been made
and 1 otherwise. This option has been designed to work with the
\fImailgo\fP script from Adrian Mariano (adrian@u.washington.edu).
\-m option is for compatibility with \fImgt\fP.
.TP 8
.B [ \-short | \-s ]
This option forces \fIxgoban\fP to save files in short mode : only
uppercase letters of keywords are printed, and there is no carriage
return. \-s option is for compatibility with \fImgt\fP.
.TP 8
.B -stipple<x>
These options set the backgroundPixmap ressource of the Goban widget
to predefined gray pixmaps (<x> must be one of 1, 2 or 3). 
You may like it if you use a black and white
display. This is an idea of Stephen Coffin.
.LP
One of \-white, \-black option starts \fIxgoban\fP in Play mode.
Default is Edit mode.
.SH OPERATIONS
.B 
When used in Edit mode, \fIxgoban\fP allows the user to edit go files.
Commands are entered form the keyboard or from the mouse. 
Most of the window that are poped down contain a Confirm (or Yes) an a 
Cancel (or No) button. 
Escape key is associated with the Cancel button, while Return
Key is associated with the Confirm button.
.LP
When an action is not allowed (because the mode your are in)
you will hear a beep. Of course you hear nothing if you turned
the bell off.
.LP
First are commands that can be used to only view a file :
.LP
.TP 8
> 
Moves to next node along the tree and displays its properties.
.LP
.TP 8
<
Hides properties of current node and moves to previous node 
along the tree.
.LP
.TP 8
}
Goes down along the tree until a commented node or a variation node
is seen. 
.LP
.TP 8
{
Goes up along the tree until a commented node or the top of the tree
is seen. 
.LP
.TP 8
]
Goes down along the tree until a variation node or the bottom of the
tree is seen. 
.LP
.TP 8
[
Goes up along the tree until a variation node or the top of the tree
is seen. 
.LP
.TP 8
?
Pops down a short help window.
.LP
.TP 8
q
Exits from the program.
.LP
.TP 8
l
Loads a file.
.LP
.TP 8
s
Saves the current tree to a file.
.LP
.TP 8
i
Pops down a window that contains some properties of the current event
(GameName, PlayerWhite, WhiteRank, WhiteSpecies ... and GameComment)
You can change these properties or just view them.
.LP
.TP 8
A-Z
When there are some variations, an uppercase letter is displayed on each
point corresponding to each possible move.
The A-Z keys can be used to select the corresponding node.
See also Btn2 action
.LP
.TP 8
Btn1
When there are variations and the mouse points at a marked point (with
uppercase letter), selects the corresponding node.
Otherwise it is the same as key `>'.
.LP
.TP 8
Btn2
It can arise that not all variations can be marked with an uppercase
letter : if a variation is a diagram (having AddBlack, AddWhite or AddEmpty
property), if there is variations on the same level
with differently colored move (Black and White), or if there is a pass move. 
In this case, the cursor will be gray.
Pressing the middle button pops up a menu where all variations are listed.
You can choose the one you want to display
.LP
.TP 8
Btn3
Same as key `<'.
.LP
Following commands can be used to change a tree :
.LP
.TP 8
v
Enters the View sub-mode and allows the user to select a partial view of the
board. A VieW property is then attached to the node.
.LP
.TP 8
z
Enters the Size sub-mode and allows the user to set the size of the board.
SiZe property can only be change at Event node (see below) and the board
is cleared.
.LP
.TP 8
w
Set the PLayer property to white for the current node.
The next move will be a white stone.
.LP
.TP 8
b
Set the PLayer property to black for the current node.
The next move will a black stone.
.LP
.TP 8
n
Prompt a dialog to edit the name of current node.
.LP
.TP 8
a
If the current node is a diagram,
Enters the Diagram sub-mode and allows the user to edit the diagram.
.LP
.TP 8
Shift Btn1
Adds a move after the current node. 
The new node is created with property
White or Black according to the color of the last move. 
The mouse must point on the intersection where you want to put the stone.
.LP
.TP 8
Shift Btn3
Deletes the current node and all its sub-nodes.
.LP
.TP 8
Ctrl Shift Btn1
Makes a variation move.
The color is the same as the PLayer property of previous node.
The mouse must point on the intersection where you want to put a the stone.
.LP
.TP 8
Ctrl Shift P
Makes a variation move which is a pass move.
The color is the same as the PLayer property of previous node.
.LP
.TP 8
Ctrl Shift Btn2
Makes a variation diagram.
It enters in the Diagram sub-mode (see below) to allow the user to put stones on 
the diagram.
.LP
.TP 8
Ctrl Btn1
Puts a letter (downcase) on the mouse pointed intersection.
.LP
.TP 8
Ctrl Btn2
Puts a triangle mark on the mouse pointed intersection.
.LP
.TP 8
Ctrl Btn3
Remove any letter or mark from the mouse pointed intersection.
.LP
There are sub-modes of Edit mode that can be Diagram, View or Size.
Whitin these sub-modes, actions are changed.
The Diagram sub-mode is signaled by a `point' cursor, while the View and
Size sub-modes are signalled by the `upper-left-corner' cursor.
.LP
.TP 8
Escape
.br
Quit the Diagram, Size or View sub-mode.
.LP
.TP 8
Btn1
Within Diagram sub-mode : puts a black stone on the mouse pointed intersection.
.LP
.TP 8
Btn2
Within Diagram sub-mode : puts a white stone on the mouse pointed intersection.
.LP
.TP 8
Btn3
Within Diagram sub-mode : removes any stone from the mouse pointed intersection.
.LP
.TP 8
Btn1 Press
Within View or Size sub-mode : start draging a rectangle to select the view
or the size.
.LP
.TP 8
Btn1 Motion
Within View or Size sub-mode : drags the rectangle.
.LP
.TP 8
Btn1 Release
Within View or Size sub-mode : stop draging the rectangle and add a VieW or SiZe 
property to the current node.
.SH GAME TREE
Game trees that can be made are slightly different from Smart-Go format.
I wanted them to be closer to a `real' game. 
.LP
Node are either of type Diagram (they have AddBlack, AddWhite or AddEmpty property)
or of type Move (they have Black or White property).
Only a Diagram can have the PLayer property (default is PLayer[B]), which
can be set only if the diagram does not have a successor.
A file is a collection of Event nodes, which are of type Diagram.
A node can have one or more successors (in which case, successors are variations).
If a node has only one successor, that successor can only be of type Move.
If a node is of type Move, the color of any successor can only be the opposite
of its color.
If a node is of type Diagram, the color of any successor is the same as the PLayer
property of the diagram.
.LP
However, I noticed that most of the avaible game record doesn't match these restrictions.
\fIxgoban\fP can read such unrestricted files but not edit them and create new 
unrestricted nodes.
Thus I added a \-versatile option that turns off strong verification for accepted colors
of nodes.
When you specify \-versatile option, you can change the PLayer property even at Move nodes
or at any node that already have a successor.
.SH RESOURCES
Resources can be set via xrdb or in the .Xdefault file. 
Default resources are as follow :
.sp
.nf
.ta .5i
	XGoban*size : 19
	XGoban*handicap : 0
	XGoban*path : "."
	XGoban*pointSize : 26
	XGoban*autonum : True
	XGoban*beep : True
	XGoban*versatile : False
.fi
.LP
You can change the board color if you want. Remember that the board background
shouldn't be black : thus, on a black and white display the only valid background 
is white.
.sp
.nf
.ta .5i
	XGoban*goban.background : tan1
	XGoban*goban.foreground : black
.fi
.LP
But everything else can be black on a white background if you like it :
.sp
.nf
.ta .5i
	XGoban*background  : black
	XGoban*foreground  : white
	XGoban*borderColor : white
.fi
.LP
You can also control the geometry of windows :
.sp
.nf
.ta .5i
	XGoban.geometry         : 500x500+30+30
	XGoban.comment.geometry : 500x200+30+580
.fi
.LP
You can change the translation table for the goban Widget (see xgoban.c for the
default translation table). You must be carefull by doing this because of multiple
modes. Some action work only in a specified mode, and you can bind them to the same
event if they don't work in the same mode. But don't bind two actions working in the
same mode with the same event ... you may have trouble.
A good way to change the translation table is just to change the left part (name of
events) and to leave the right part (action) as it is.
To change the translation table see a doc on X Toolkit and modify your .Xdefaults
accordly.
.SH EXAMPLES
.PD 0
.TP 5
To read and edit the file 001_001.s :
.B xgoban 001_001.s
.TP 5
To play black against gnugo with 5 handicap stones :
.B xgoban -handicap 5 -white gnugo 
.TP 5
To play white against wally :
.B xgoban -black wally 
.TP 5
To make wally play against gnugo :
.B xgoban -black wally -white gnugo
.PD
.SH BUGS
.LP
When read, a file is supposed to be syntacticaly correct.
This is normally the case, when you didn't create this file by hand ...
.LP
File names are limited to 512 bytes.
.LP
\-pointSize option doesn't work with smaller size than 19x19.
The board size is calculated as if it were a 19x19 board, and 
then the board size is changed whitin the same square.
.LP
Resign is not supported in Play mode, and you can't use the counting
features of gnugo or wally.
.LP
Once you edit a file, you can't start editing another one without quiting
\fIxgoban\fP. You can also delete all top nodes but beware from erasing you
previous file with the save command.
.SH SEE ALSO
\fImgt\fP from Greg Hale.
.br
\fImailgo\fP from Adrian Mariano.
.LP
\fImgt\fP, \fImailgo\fP and game records 
are available at milton.u.washington.edu.
.SH AUTHORS
Antoine Dumesnil de Maricourt (dumesnil@etca.fr)
