/****************************************************************************************************************
 *
 *  Copyright (c) 1992 by Antoine Dumesnil de Maricourt. All rights reserved.
 *
 *  This program is distributed in the hope that it will be useful.
 *  Use and copying of this software and preparation of derivative works
 *  based upon this software are permitted, so long as the following
 *  conditions are met:
 *       o credit to the authors is acknowledged following current
 *         academic behaviour
 *       o no fees or compensation are charged for use, copies, or
 *         access to this software
 *       o this copyright notice is included intact.
 *  This software is made available AS IS, and no warranty is made about 
 *  the software or its performance. 
 * 
 *  Bug descriptions, use reports, comments or suggestions are welcome.
 *  Send them to    dumesnil@etca.fr   or to:
 *       
 *       Antoine de Maricourt
 *       ETCA CREA-SP
 *       16 bis, avenue Prieur de la Cote d'Or
 *       94114 Arcueil Cedex
 *       France
 */

#ifndef _xgoban_h_
#define _xgoban_h_

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "sg.h"
#include "Goban.h"

typedef enum { Human, Wally, Gnugo } Player;
typedef enum { EditMode, DiagramMode, SizeMode, ViewMode, PlayMode, MailMode } Mode;

#define ApplicationName           "XGoban"

#define LoadDialog                2
#define EditDialog                3
#define SaveBeforeQuitDialog      5
#define SaveAsAndQuitDialog       6
#define ReallyQuitDialog          7
#define SaveBeforeLoadDialog      8
#define SaveAsAndLoadDialog       9
#define SaveAsDialog              10
#define CantSaveRetryDialog       11
#define CantLoadRetryDialog       12
#define HelpDialog                13

#define PlayerNodeErrorWarning    14
#define MemoryErrorDialog         15
#define CantOpenFileDialog        16
#define IllegalMoveDialog         17
#define SuicideMoveDialog         18
#define KoMoveDialog              19
#define BadHandicapWarning        20
#define RemainingStonesWarning    21
#define ReadOnlyWarning           22
#define DiagramBadNodeWarning     23
#define SizeBadNodeWarning        24
#define ReallyDeleteDialog        25
#define PlayerMoveErrorWarning    26
#define WallyWhitePlayWarning     27
#define WallyBadSizeWarning       28
#define WallyBadHandicapWarning   29
#define StopGameDialog            30
#define RemoveStonesDialog        31
#define BlackPassDialog           32
#define WhitePassDialog           33
#define NodeNameDialog            34
#define MailNoMoveDialog          35
#define MailConfirmMoveDialog     36
#define StopGameBeforeQuitDialog  37  

#define ReplaceNodeDialog         40

#define BadHandicapMsg            " Don't know how to place \n    handicap stones      \n  for this size of board "
#define RemainingStonesMsg        "  Don't know how to place  \n remaining handicap stones "
#define PlayerNodeErrorMsg        " Player can be changed only \n  at Event or Diagram node  "
#define PlayerMoveErrorMsg        " Following  move is already \n done : can't change Player "
#define IllegalMoveMsg            " This move is illegal "
#define KoMoveMsg                 " You can't retake the \n        ko now        "
#define SuicideMoveMsg            " Suicide is not allowed "
#define DiagramBadNodeMsg         " Diagram can't be edited \n      at Move node       "
#define SizeBadNodeMsg            " Goban can be resized \n  only at Event node  "
#define CantOpenFileMsg           " Can't open file "
#define WallyWhitePlayMsg         " Wally only plays black "
#define WallyBadSizeMsg           " Wally plays on a 9x9, \n 13x13 or 19x19 board  "
#define WallyBadHandicapMsg       " Wally plays with no or \n   9 handicap stones    "
#define BlackPassMsg              " Black passes "
#define WhitePassMsg              " White passes "

#define LoadFileMsg               "Load file :"
#define SaveFileMsg               "Save file :"
#define EditFileMsg               "Edit file ?"
#define ReplaceNodeMsg            "Replace current node ?"
#define ReallyQuitMsg             "Really quit ?"
#define ReallyDeleteMsg           "Really delete current node ?"
#define SaveFileBeforeMsg         "Save file before ?"
#define StopGameMsg               "Stop current game ?"
#define RemoveStonesMsg           "Remove further moves ?"
#define NodeNameMsg               "Enter node name :"
#define MailNoMoveMsg             "No move done : really quit ?"
#define MailConfirmMoveMsg        "Confirm your move ?"

#define YesLabel                  "Yes"
#define NoLabel                   "No"
#define CancelLabel               "Cancel"
#define SaveLabel                 "Save"
#define LoadLabel                 "Load"
#define EditLabel                 "Edit"
#define QuitLabel                 "Quit"
#define ReplaceLabel              "Replace"
#define OkLabel                   "Ok"
#define DeleteLabel               "Delete"
#define RemoveLabel               "Remove"
#define StopLabel                 "Stop"
#define ConfirmLabel              "Confirm"

#define ReadOnlyMsg               " File is read-only "
#define MemoryErrorMsg            " Memory error "

#define UsageString               "\
XGoban version 1.0\n\n\
Usage : \n\
   xgoban [ <toolkit options> ... ] [ <options> ... ] [ <file> ]  \n\n\
where options include : \n\
   -help                         print out this message  \n\
   -size         <size>          set goban size          \n\
   -handicap     <handicap>      setup handicap stones   \n\
   -path         <path>          path for smart-go files \n\
   -pointSize    <pointSize>     size of points in pixels\n\
   -silent                       turn off bell           \n\
   -nonum                        turn off auto numbering \n\
   -versatile                    turn off strict moves   \n\
   -black        <blackPlayer>   black player            \n\
   -white        <whitePlayer>   white player            \n\
   [-short | -s]                 short save mode         \n\
   [-mail  | -m] <filename>      mail mode               \n\
\n"

#define HelpString                "\n\
               XGoban 1.0    by  A. de Maricourt  (c) 1992                    \n\
\n\
\n\
   a      : Append stones to diagram       Bt1    : select variation          \n\
   b      : Black to play                           or move forward           \n\
   d      : select Diagram                 Bt2    : select diagram            \n\
   e      : Edit current file              Bt3    : move backward             \n\
   l      : Load file                                                         \n\
   p      : Pass                           S-Bt1  : make next move            \n\
   q      : Quit                           S-Bt3  : delete move               \n\
   s      : Save                                                              \n\
   v      : View                           CS-Bt1 : make variation move       \n\
   w      : White to play                  CS-Bt2 : make variation diagram    \n\
   z      : siZe                                                              \n\
   >      : move forward                   C-Bt1  : add letter                \n\
   <      : move backward                  C-Bt2  : add mark                  \n\
   }      : next comment                   C-Bt3  : delete letter             \n\
   {      : previous comment                                                  \n\
   ]      : next variation branch        diagram editing :                    \n\
   [      : previous variation branch      Bt1    : add black stone           \n\
   ?      : help                           Bt2    : add white stone           \n\
   i      : event Informations             Bt3    : remove stone              \n\
   CS-P   : make variation pass            Esc    : diagram done              \n\
 \n\
                   Press any key or click to dismiss ...      \n\
\n"

#define Max(x,y)                  ((x)>(y)?(x):(y))
#define Min(x,y)                  ((x)>(y)?(y):(x))
#define Abs(x)                    ((x)>0?(x):-(x))

extern Widget      w_toplevel;
extern Widget      w_goban;
extern Widget      w_menu;
extern Widget      c_toplevel;
extern Widget      c_comment;
extern Widget      w_second_toplevel;
extern Widget      w_second_form;
extern Widget      w_second_goban;

extern SG_NodePtr  tree;
extern SG_NodePtr  current_node;
extern SG_NodePtr  mail_node;

extern Mode        current_mode;

extern Player      black_player;
extern Player      white_player;
extern int         handicap;
extern int         board_size;
extern int         second_player;

extern Boolean     edit;
extern Boolean     modified;
extern int         beep;
extern Boolean     autonum;
extern Boolean     strict;
extern Boolean     short_print;

extern char        file_name[512];
extern char        mail_file_name[512];
extern char       *path;

extern Boolean     delete_confirm;

extern void             PopupDialog      ();
extern void             makeDialogWindow ();
extern void             makeEventWindow  ();

extern void             CenterWindow    ();
extern Boolean          LoadFile        ();
extern Boolean          SaveFile        ();
extern void             ShowCursor      ();


extern void             ShowTmpProperty ();
extern void             HideTmpProperty ();
extern void             ShowProperty    ();
extern void             HideProperty    ();

extern void             Edit            ();

extern int              Play            ();
extern void             Unplay          ();
extern void             StartDiagram    ();
extern void             AddStone        ();
extern unsigned char   *EndDiagram      ();

extern void             signalMove      ();
extern void             stopGame        ();
extern void             startGame       ();


#define RedisplayBoard() { GbRedisplayBoard (w_goban); if (w_second_goban != NULL) GbRedisplayBoard (w_second_goban); }
#endif
