/****************************************************************************************************************
 *
 *  Copyright (c) 1992 by Antoine Dumesnil de Maricourt. All rights reserved.
 *
 *  This program is distributed in the hope that it will be useful.
 *  Use and copying of this software and preparation of derivative works
 *  based upon this software are permitted, so long as the following
 *  conditions are met:
 *       o credit to the authors is acknowledged following current
 *         academic behaviour
 *       o no fees or compensation are charged for use, copies, or
 *         access to this software
 *       o this copyright notice is included intact.
 *  This software is made available AS IS, and no warranty is made about 
 *  the software or its performance. 
 * 
 *  Bug descriptions, use reports, comments or suggestions are welcome.
 *  Send them to    dumesnil@etca.fr   or to:
 *       
 *       Antoine de Maricourt
 *       ETCA CREA-SP
 *       16 bis, avenue Prieur de la Cote d'Or
 *       94114 Arcueil Cedex
 *       France
 */

#ifndef _GobanP_h
#define _GobanP_h

#include "Goban.h"

/* include superclass private header file */
#include <X11/CoreP.h>

/* define unique representation types not found in <X11/StringDefs.h> */

#define XtRGobanResource "GobanResource"

typedef struct {
    int empty;
} GobanClassPart;

typedef struct _GobanClassRec {
    CoreClassPart	core_class;
    GobanClassPart	goban_class;
} GobanClassRec;

extern GobanClassRec gobanClassRec;

typedef struct {
  unsigned int free  : 1;
  unsigned int black : 1;
  unsigned int mark1 : 8;
  unsigned int mark2 : 8;
  unsigned int num   : 10;
} PointState;

typedef struct {
    /* resources */

  Boolean       auto_redisplay;
  Position      bottom;
  int           cursor;
  XFontStruct  *font;
  Pixel         foreground;
  Dimension     game_size;
  Position      left;
  Boolean       display_coordinates;
  Dimension     point_size;
  Position      right;
  Position      top;

    /* private state */

  PointState    points[20][20];
  Position      x_offset;
  Position      y_offset;

  Pixmap        black_stone;
  Pixmap        board;
  Pixmap        gray_stone;
  Pixmap        mouse_mask;
  Pixmap        picture;
  Pixmap        white_stone;

  GC            background_gc;
  GC            foreground_gc;
  GC            black_fg_gc;
  GC            black_bg_gc;
  GC            black_bd_gc;
  GC            white_fg_gc;
  GC            white_bg_gc;
  GC            white_bd_gc;
  GC            copy_gc;

  Cursor        black_cursor;
  Cursor        gray_cursor;
  Cursor        white_cursor;
  Cursor        font_cursor;

  Pixel         white_bg;
  Pixel         white_fg;
  Pixel         white_bd;
  Pixel         black_bg;
  Pixel         black_fg;
  Pixel         black_bd;
} GobanPart;

typedef struct _GobanRec {
    CorePart    core;
    GobanPart	goban;
} GobanRec;

#define Min(x,y)      ((x) > (y) ? (y) : (x))
#define Max(x,y)      ((x) > (y) ? (x) : (y))

#endif /* _GobanP_h */
