/*
**                      Softwarepraktikum iMaze
**                              1993/94
**                Joerg Czeranski    Hans-Ulrich Kiel
**
** Datei: global.h
**
** Kommentar:
**  globale Typ- und Funktion-Definitionen
*/


#include <sys/types.h> /* fuer u_int... */

static char sccsid_global[] = "@(#)global.h	1.8 5/17/94";


/* zusaetzliche Grundfunktionen */
#define min(x,y) ((x) < (y) ? (x) : (y))
#define max(x,y) ((x) > (y) ? (x) : (y))
#define sqr(x) ((x) * (x))

/* char mit Vorzeichen */
#ifdef __STDC__
#define s_char signed char
#else
#define s_char char
#endif

/* Ausmasse der globalen Sinus- und Cosinus-Tabelle;
   TRIGANZ muss 2er-Potenz sein */
#ifndef TRIGANZ
#define TRIGANZ 1024
#endif

#define TRIGFAKTOR 65536

/* Codes fuer den Parameter runden bei wurzel */
#define W_ABRUNDEN -1
#define W_RUNDEN    0
#define W_AUFRUNDEN 1


/* Cosinus/Sinus in Schritten von 360/TRIGANZ Grad;
   gespeichert als Integerwerte: sin*TRIGFAKTOR */
extern int costab[TRIGANZ], sintab[TRIGANZ];

/* Arcustangens von -1 bis 1 in Schritten von 2/TRIGANZ;
   gespeichert als Indizes fuer costab/sintab */
extern int atantab[TRIGANZ + 1];


/* Prototypen fuer globale portable Funktionen */

#ifdef __STDC__

long zufall(void);
void zufall_init(unsigned long startwert);
long wurzel(unsigned long x, int runden);

#else

long zufall();
void zufall_init();
long wurzel();

#endif
