namespace eval NSToolbar {

# NSToolbar::NSToolbar --
#
#	Object constructor called by NSObject::New().
#
# Arguments:
#	arg1					about arg1
#
# Results:
#	What happened.

proc NSToolbar {oop size parent} {

	global NSToolbar

	set frame $parent.toolbar$oop
	set NSToolbar($oop,frame) $frame
	set NSToolbar($oop,size) $size
	set NSToolbar($oop,count) 0

    frame $frame \
        -borderwidth 0 -relief flat
    frame $frame.divider1 \
        -borderwidth 1 -height 2 -relief groove

    pack $frame -expand yes -fill x -side top
    pack $frame.divider1 \
        -expand yes -fill x -side top

	bindtags $frame [concat [bindtags $frame] ToolbarBindtags($frame)]
	bind ToolbarBindtags($frame) <Destroy> "NSObject::Delete NSToolbar $oop"
}

# NSToolbar::AddTool --
#
#	Add a new "button" to the right of all others.
#
# Arguments:
#	arg1					about arg1
#
# Results:
#	What happened.

proc AddTool {oop image command} {

	global NSToolbar

	set frame $NSToolbar($oop,frame)
	set size $NSToolbar($oop,size)
	set count [incr NSToolbar($oop,count)]
	set label $frame.tool$count

    label $label \
        -anchor center -relief flat -borderwidth 2 -image $image -height $size -width $size

	NSButtonLabel::ButtonLabel $label $command

    pack $label \
        -anchor center -expand no -padx 2 -pady 2 -side left

	return $count
}

# NSToolbar::GetTool --
#
#	Return the full window pathname of the given "button".
#
# Arguments:
#	oop					OOP ID. See above.
#	index					1-based index of tool.
#
# Results:
#	What happened.

proc GetTool {oop index} {

	global NSToolbar

	set frame $NSToolbar($oop,frame)
	return $frame.tool$index	
}

# namespace eval NSToolbar
}
