/* ring/amulet buying is acting odd */

/* File: borg-ben.c */

/* Purpose: one brain for the Borg (see "borg.c") -BEN- */

#include "angband.h"



#ifdef AUTO_PLAY

#include "borg.h"
#define BLOWS
/* MJC -- cheat to see whether to or not to get stat potions */
/* Allows use of maximize mode :) */
#define CHEAT_BASE_STATS

/*
 * See "borg.h" for general information.
 *
 * This file provides support for the "Borg", an "automatic" Angband player.
 *
 * The initialization routine grabs the "Term_xtra()" hook of the main "Term",
 * allowing the Borg to notice when the game is asking for keypresses, and to
 * send its own keys to the keypress queue, while still allowing (occasional)
 * keys to be accepted from the user.  The keys from the user should probably
 * be single keycodes, to prevent interlace with the Borg keypresses.  Note
 * that the initialization function is invoked by the special "wizard command"
 * "^A$" which is usually available in wizard mode.
 *
 * Once the Borg has been initialized, the user can choose to start
 * the Borg or ask it questions via the "borg_mode() key" ("^Z"), which
 * invokes the "borg_mode()" function, which allows the user to do things
 * to the borg, including restart ("z"), resume ("r"), plus various queries.
 *
 * You may "stop" the Borg by entering wizard mode (using the "^W" command).
 * You should probably make a macro from some key to "\e\e\e\e\e^W", so that
 * you can kill the Borg if it gets stuck in a loop.
 *
 * The Borg is only supposed to "know" what is visible on the screen, which
 * it learns by using the "term.c" screen access function "Term_what()", and
 * the cursor location function "Term_locate()", and a hack to access the
 * cursor visibility using "Term_show/hide_cursor()".  It is only allowed to
 * send keypresses to the "Term" like a normal user, by using the standard
 * "Term_keypress()" routine.  It only thinks and sends keys when it catches
 * a request to "Term_xtra(TERM_XTRA_EVENT)", which the "term.c" file uses
 * to wait for a keypress (or other event) from the user.
 *
 * That is, if if were not for the "cheats" currently used (see below).
 *
 *
 * Must be careful of:
 *   Level changing (intentionally or accidentally)
 *   Gold (or objects) embedded in walls (need to tunnel)
 *   Objects with ',' or '$' symbols (look like monsters)
 *   Mimic monsters (look like objects) or invisible monsters
 *   Traps (disarm), Doors (open/bash), Rubble (tunnel)
 *   Stores (enter via movement, exit via escape)
 *   Stores (limited commands, such as no "throw" command)
 *   Must discard junk before trying to pick up more junk
 *   Must be very careful not to run out of food/light
 *   Should use "identify" cleverly to obtain knowledge/money
 *   Do not attempt to throw away cursed artifacts (oops)
 *   Do not sell junk or cursed/damaged items to any stores
 *   Do not attempt to buy something with insufficient funds
 *   Use the non-optimal stairs if stuck on a level
 *   Make sure that every important grid is in a room
 *   Use "flow" code for all tasks for consistency
 *   Weird objects ("Mace of Disruption"/"Scythe of Slicing")
 *   Do not try to read scrolls when blind or confused
 *   Attempt to heal when "confused", "blind", etc
 *   Occasionally remove both rings (to rearrange them)
 *   Make sure to "wear" items in order of "goodness"
 *   This will allow the "ring removal hack" to work
 *   Notice "failure" when using rod/staff of perceptions
 *   Do not fire at monsters that may have changed location
 *   Search for secret doors if stuck on a level (spastic)
 *   Earthquake (or destruction) of already mapped grids
 *   Collect monsters/objects left behind or seen from afar
 *
 * Should be careful of:
 *   Do not throw away cursed artifacts (non-warrior types)
 *   If wounded, must run away from monsters, then rest
 *   Invisible monsters causing damage while trying to rest
 *   Try to use a shovel/pick to help with tunnelling
 *   Becoming "afraid" (attacking takes a turn for no effect)
 *   Becoming "blind" (map may be no longer valid)
 *   Out of depth player ghosts (in the town)
 *   Be VERY careful not to access illegal locations!
 *   Extremely long object descriptions (no room for inscriptions)
 *   In particular, consider artifact dragon scale mail and such
 *   Attempt to actually walk to the end of all corridors
 *   This will allow the "search" routines to work effectively
 *   As a hack, we could only build corridors from touched grids
 *   Attempt to "track" monsters who flee down corridors
 *   We will not fire missiles at magic mushrooms when afraid (!)
 *   Consider using the "x" symbol for obnoxious monsters
 *   When totally surrounded by monsters, try to escape rooms
 *
 * Memory usage (out of date):
 *   Total: 300K total
 *   Largest chunk: 42K
 *   Rooms: (200*70/8)*24 = 42K
 *   Each row of Grids: 200*16 = 3K
 *   All rows of Grids: 70*3K = 210K
 *   Inventory: 36*132 = 5K
 *   Shops: 8*24*132 = 24K
 *
 * Note that there is minimal memory use by static variables compared
 * to the code itself, and compared to allocated memory.
 *
 * Currently, the auto-player "cheats" in a few situations.  Oops.
 *
 * The "big" cheat is that we "build" an inventory listing without
 * parsing the screen.  This is mainly for efficiency, and to prevent
 * constant screen flashing, since we do know how to parse the store.
 *
 * Consider parsing the "choice" window for inventory/equipment.
 *
 * Cheats that are significant, and possibly unavoidable:
 *   Knowledge of when we are being asked for a keypress.
 *   Note that this could be avoided by LONG timeouts/delays
 *
 * Cheats "required" by implementation, but not signifant:
 *   Direct access to the "keypress queue" (sending keys)
 *   Direct access to the cursor visibility (this is silly)
 *   Direct use of the "current screen image" (parsing screen)
 *   Note that this includes distinguishing white/black spaces
 *
 * Cheats that could be "overcome" trivially:
 *   Direct modification of the "current options"
 *
 * Cheats that could be avoided by duplicating code:
 *   Direct access to the "r_list" and "k_list" arrays
 *   Direct access to the "v_list" and "ego_name" arrays
 *
 * Cheats that save a lot of "time", but are "optional":
 *   Direct extraction of "w_x" and "w_y" (cheat_panel)
 *   Direct extraction of inventory/equipment (cheat_inven)
 *
 * Cheats that the Borg would love:
 *   Unique attr/char codes for every monster and object
 *   Ring of See invisible, Ring of Free Action, Helm of Seeing
 *   Use of "x" for mushroom monsters (magic mushrooms!)
 *
 * Simple ways to make the Borg more effective:
 *   Choose a male fighter (maximize strength)
 *   Roll for high strength (this is very important)
 *   Roll for 18 or 18/50 constitution (high hitpoints)
 *   Roll for high dexterity (may yield multiple attacks)
 *   Do not play a human or dunadin (no infravision)
 *   Choose a dwarf (resist blindness)
 *   Choose a high elf (see invisible)
 *   Choose a gnome (free action)
 */



static int enchant_to = 9;      /* MJC -- enchant to this */

static int shop_num = 7;        /* Most recent shop index */

static int last_visit = 0;      /* Last purchase visit */

static int goal = 0;            /* Current "goal" */

static int goal_rising = 0;     /* Currently fleeing to town */

static int stair_less;          /* Use the next "up" staircase */
static int stair_more;          /* Use the next "down" staircase */

static int count_floor;         /* Number of floor grids */
static int count_less;          /* Number of stairs (up) */
static int count_more;          /* Number of stairs (down) */
static int count_kill;          /* Number of monsters */
static int count_take;          /* Number of objects */

static s32b attention;          /* Attention this level deserves */

#ifndef FRITS
static s32b c_t;                /* Current time */

#else
/* global */ s32b c_t;          /* Current time */
#endif /* FRITS */

/* EAW -- speed counter, light stuff */
static s32b last_speed;         /* last time speed potion quaffed */
static s32b last_artifact_light; /* last time artifact light lit */
static bool room_was_lit = FALSE; /* flag for being in a room */
static bool do_force_up = FALSE;    /* flag for forcing him up when in trouble */
static bool do_was_almost_dead = FALSE; /* get him back to town pronto */
static char desc_last_junked[80];    /* check for junked cursed artifacts */
/* global */ bool do_multiple_players = FALSE;

static bool cheat_inven = TRUE; /* Cheat to get "inven/equip" */

static bool cheat_panel = TRUE; /* Cheat to get "panel" */

static bool panic_death = TRUE; /* Panic before Death */

static bool panic_stuff = TRUE; /* Panic before Junking Stuff */

/* EAW -- stuff for reading WoR in town */
static bool read_in_town = FALSE; /* Sometimes ok to read in town */

static s32b auto_began = 0L;    /* When this level began */

static s32b auto_shock = 0L;    /* When last "shocked" */

static s32b auto_recall = 0L;   /* When we read word of recall */






/*
 * Quick determination if a symbol is in one of those arrays
 */
static bool *auto_is_kill;
static bool *auto_is_take;



/*
 * Some kinds -- required items
 */
static int kind_food_ration = 21;
static int kind_potion_serious = 240;
static int kind_potion_critical = 241;
static int kind_scroll_recall = 220;
static int kind_scroll_teleport = 186;
static int kind_scroll_identify = 176;
static int kind_flask = 348;
static int kind_torch = 346;
static int kind_lantern = 347;

/* EAW -- other potions */
static int kind_potion_healing = 242;
static int kind_potion_speed = 249;

/* MJC -- restore mana, *healing*, life potions */
static int kind_potion_restore_mana = 266;
static int kind_potion_star_healing = 419;
static int kind_potion_life = 420;

/* MJC -- satisfy hunger scrolls */
static int kind_scroll_satisfy_hunger = 210;

/*
 * Some kinds -- increase stat potions
 */
static int kind_potion_add_str = 225;
static int kind_potion_add_int = 228;
static int kind_potion_add_wis = 231;
static int kind_potion_add_dex = 251;
static int kind_potion_add_con = 243;
static int kind_potion_add_chr = 234;

/*
 * Some kinds -- restore stat potions
 * Mushrooms too -- MJC
 */
static int kind_potion_fix_str = 227;
static int kind_potion_fix_int = 230;
static int kind_potion_fix_wis = 233;
static int kind_potion_fix_dex = 252;
static int kind_potion_fix_con = 253;
static int kind_potion_fix_chr = 236;
static int kind_mushroom_restoring = 12;
static int kind_mushroom_fix_con = 11;

/*
 * Some kinds -- miscellaneous
 */
static int kind_potion_fix_exp = 260;
static int kind_staff_teleport = 303;
static int kind_staff_identify = 326;
static int kind_rod_identify = 372;

/*
 * Some kinds -- various enchantment scrolls
 */
static int kind_enchant_to_hit = 173;
static int kind_enchant_to_dam = 174;
static int kind_enchant_to_ac = 175;

/*
 * Some kinds -- various missiles
 */
static int kind_missile_shot = 83;
static int kind_missile_arrow = 78;
static int kind_missile_bolt = 80;

/*
 * Variable kinds -- preferred missile type
 */
static int kind_missile = 83;


#ifdef FRITS
/* global */ int kind_magic_books[9] = {
    330,        /* Magic for Beginners */
    331,        /* Conjurings and Tricks */
    332,        /* Incantations and Illusions */
    333,        /* Sorcery and Evocations */

    379,        /* Resistance of Scarabtarices */
    380,        /* Mordenkainen's Escapes */
    381,        /* Kelek's Grimoire of Power */
    382,        /* Tenser's Transformations */
    383         /* Raal's Tome of Destruction */
};
/* global */ int kind_prayer_books[9] = {
    334,        /* Beginners Handbook */
    335,        /* Words of Wisdom */
    336,        /* Chants and Blessings */
    337,        /* Exorcism and Dispelling */

    384,        /* Ethereal Openings */
    385,        /* Godly Insights */
    386,        /* Purifications and Healing */
    387,        /* Holy Infusions */
    388         /* Wrath of God */
};

/* not really useful but hey */
/* rings etc. that don't have the flag EASY_KNOWN
   like ring of slaying, ring of speed etc. */
static int kind_ring_speed = 136;
static int kind_ring_str = 132;
static int kind_ring_dex = 133;
static int kind_ring_con = 134;
static int kind_ring_int = 135;
static int kind_ring_search = 137;
static int kind_ring_dam = 151;
static int kind_ring_hit = 152;
static int kind_ring_prot = 153;
static int kind_ring_slaying = 162;
static int kind_amulet_wis = 163;
static int kind_amulet_cha = 164;
static int kind_amulet_search = 165;
static int kind_amulet_magi = 171;
#endif /* FRITS */

#ifndef FRITS
/*
 * Hack -- Actual number of each "item kind".
 */
static byte kind_have[MAX_K_IDX];

/*
 * Hack -- Desired number of each "item kind".
 */
static byte kind_need[MAX_K_IDX];
#else
/* global */ byte kind_have[MAX_K_IDX];
/* global */ byte kind_need[MAX_K_IDX];
#endif /* FRITS */


/*
 * Hack -- scrolls that should always be read if possible
 */
static int kind_force_scrolls[] = {
    189,        /* magic mapping */
    194,        /* trap detection */
    197,        /* door/stair detection */
    198,        /* acquirement */
    199,        /* star-acquirement */
    209,        /* protection from evil */
    0
};

/*
 * MJC - Hack - list for town
 */
static int kind_force_scrolls_town[] = {
    0
};


/*
 * Hack -- potions that should always be quaffed if possible
 */
/* EAW -- rearranged a few, added 419, 420, 422 */
/* MJC -- with *healing* and life handling, they no longer go here */
static int kind_force_potions[] = {
    225,        /* strength */
    228,        /* intelligence */
    231,        /* wisdom */
    251,        /* dexterity */
    243,        /* constitution */
    234,        /* charisma */
    256,        /* enlightenment */
    244,        /* experience */     
    418,        /* augmentation */
    422,        /* star-enlightenment */
    0
};

/*
 * MJC - Hack - list for town
 */
static int kind_force_potions_town[] = {
    225,        /* strength */
    228,        /* intelligence */
    231,        /* wisdom */
    251,        /* dexterity */
    243,        /* constitution */
    234,        /* charisma */
    244,        /* experience */     
    418,        /* augmentation */
    422,        /* star-enlightenment */
    0
};

/* EAW -- crap to be junked without being identified */
static int kind_crap_items[] = {
	30,     /* Broken Dagger */      
	47,     /* Broken Sword */
	101,    /* Robe */
	102,    /* Filty Rag */
	110,    /* Rusty Chain Mail */
	0
};


/*
 * Hack -- scrolls that should be read rather than discarded
 */
static int kind_allow_scrolls[] = {
    180,        /* remove curse */
    181,        /* light */
    188,        /* monster confusion */
    189,        /* magic mapping */
    190,        /* rune of protection */
    191,        /* star-remove-curse */
    192,        /* treasure detection */
    193,        /* object detection */
    194,        /* trap detection */
    197,        /* door/stair detection */
    198,        /* acquirement */
    199,        /* star-acquirement */
    201,        /* detect invisible */
    204,        /* trap/door destruction */
    209,        /* protection from evil */
    210,        /* satisfy hunger */
    211,        /* dispel undead */
    217,        /* blessing */
    218,        /* holy chant */
    219,        /* holy prayer */
    0
};

/*
 * Hack -- potions that should be quaffed rather than discarded
 */
static int kind_allow_potions[] = {
    222,        /* slime mold juice */
    223,        /* apple juice */
    224,        /* water */
    225,        /* strength */
    227,        /* restore strength */
    228,        /* intelligence */
    230,        /* restore intelligence */
    231,        /* wisdom */
    233,        /* restore wisdom */
    234,        /* charisma */
    236,        /* restore charisma */
    237,        /* cure light wounds */
    240,        /* cure serious wounds */
    241,        /* cure critical wounds */
    242,        /* healing */
    243,        /* constitution */
    244,        /* experience */
    249,        /* speed */
    251,        /* dexterity */
    252,        /* restore dexterity */
    253,        /* restore constitution */
    256,        /* enlightenment */
    257,        /* heroism */
    258,        /* beserk strength */
    259,        /* boldness */
    260,        /* restore life levels */
    261,        /* resist fire */
    262,        /* resist cold */
    263,        /* detect invisible */
    264,        /* slow poison */
    265,        /* neutralize poison */
    266,        /* restore mana */
    267,        /* infravision */
    418,        /* augmentation */
    419,        /* star-healing */
    420,        /* life */
    0
};


/*
 * State variables extracted from the screen
 */

#ifndef FRITS
static bool do_weak;
static bool do_hungry;

static bool do_blind;
static bool do_afraid;
static bool do_confused;
static bool do_poisoned;

static bool do_add_str;
static bool do_add_int;
static bool do_add_wis;
static bool do_add_dex;
static bool do_add_con;
static bool do_add_chr;

static bool do_fix_str;
static bool do_fix_int;
static bool do_fix_wis;
static bool do_fix_dex;
static bool do_fix_con;
static bool do_fix_chr;

static bool do_fix_exp;
/* EAW -- need seperate flag for fix level */
static bool do_fix_lev;

static int auto_level;          /* Current player level */
static int old_level = 0;       /* EAW -- Previous player level */
static int old_auto_stat_int = 0;    /* EAW -- Previous player INT */
static int old_auto_stat_wis = 0;    /* EAW -- Previous player WIS */

static int auto_curhp;          /* Current hitpoints */
static int auto_maxhp;          /* Maximum hitpoints */

/* EAW -- color of mana */
static byte mana_color;         /* color of mana */

static s32b auto_gold;          /* Current "gold" */

static int auto_stat_str;       /* Current strength */
static int auto_stat_int;       /* Current intelligence */
static int auto_stat_wis;       /* Current wisdom */
static int auto_stat_dex;       /* Current dexterity */
static int auto_stat_con;       /* Current constitution */
static int auto_stat_chr;       /* Current charisma */

static int auto_depth = -1;     /* Current dungeon "level" */

#else /* FRITS */
/* We want these variables reachable by 'sub-borgs',
   like borg-ew.c and borg-frits.c */

/* global */ bool do_weak;
/* global */ bool do_hungry;

/* global */ bool do_blind;
/* global */ bool do_afraid;
/* global */ bool do_confused;
/* global */ bool do_poisoned;

/* global */ bool do_add_str;
/* global */ bool do_add_int;
/* global */ bool do_add_wis;
/* global */ bool do_add_dex;
/* global */ bool do_add_con;
/* global */ bool do_add_chr;

/* global */ bool do_fix_str;
/* global */ bool do_fix_int;
/* global */ bool do_fix_wis;
/* global */ bool do_fix_dex;
/* global */ bool do_fix_con;
/* global */ bool do_fix_chr;

/* global */ bool do_fix_exp;
/* global */ bool do_fix_lev;           /* EAW -- need seperate flag */

/* global */ int auto_level;            /* Current player level */
/* global */ int old_level = 0;         /* EAW -- Previous player level */
/* global */ int old_auto_stat_int = 0;     /* EAW -- Previous player INT */
/* global */ int old_auto_stat_wis = 0;     /* EAW -- Previous player WIS */


/* global */ int auto_curhp;            /* Current hitpoints */
/* global */ int auto_maxhp;            /* Maximum hitpoints */

/* EAW -- color of mana */
/* global */ byte mana_color;           /* color of mana */        

/* global */ s32b auto_gold;            /* Current "gold" */

/* global */ int auto_stat_str; /* Current strength */
/* global */ int auto_stat_int; /* Current intelligence */
/* global */ int auto_stat_wis; /* Current wisdom */
/* global */ int auto_stat_dex; /* Current dexterity */
/* global */ int auto_stat_con; /* Current constitution */
/* global */ int auto_stat_chr; /* Current charisma */

/* global */ int auto_depth = -1;       /* Current dungeon "level" */

/* these are new */
/* global */ int auto_pclass;           /* player class */
/* global */ int auto_sclass;           /* player spellcasting class */

/* global */ int auto_curmana;          /* Current manapoints */

/* global */ bool borg_dont_need_identify = FALSE;      /* spellcaster */
/* global */ bool borg_dont_need_food = FALSE;          /* spellcaster */
#endif /* FRITS */




/*
 * MJC -- Calculates the highest level (approx.) the borg should go to.
 *
 * XXX cheats badly
 */
static int borg_deepest_level(void)
{
    int result;

    result = auto_maxhp * 3 / 40;
    if (auto_level == 50) result = 100;
    if (!p_ptr->resist_disen) result = MIN(40, result);
    return (result);
}

/*
 * MJC -- Hack -- save the game
 */
static void borg_save_game(void)
{
    /* Get out of everything (stores, prompts, etc.) */
    borg_keypress(ESCAPE);
    borg_keypress(ESCAPE);

    /* Save it! */
    borg_keypress('^');
    borg_keypress('S');
}

/*
 * Hack -- set the options the way we like them
 */
static void borg_play_options(void)
{
    /* The Borg uses the original keypress codes */
    rogue_like_commands = FALSE;

    /* Use color to identify monsters and such */
    use_color = TRUE;

    /* Pick up items when stepped on */
    always_pickup = TRUE;

    /* Require explicit target request */
    use_old_target = FALSE;

    /* Do NOT query "throw" commands */
    always_throw = TRUE;

    /* Do NOT query "pick up" commands */
    carry_query_flag = FALSE;

    /* Do NOT query "various" commands */
    other_query_flag = FALSE;

    /* Require explicit repeat commands */
    always_repeat = FALSE;

    /* Do not get confused by extra info */
    plain_descriptions = TRUE;

    /* Maximize space for information */
    show_inven_weight = FALSE;
    show_equip_weight = FALSE;
    show_store_weight = FALSE;

    /* Buy/Sell without haggling */
    no_haggle_flag = TRUE;

    /* Maximize screen info */
    fresh_before = TRUE;
    fresh_after = TRUE;

    /* Read the level directly (not in feet) */
    depth_in_feet = FALSE;

    /* Use the health bar (later) */
    show_health_bar = TRUE;

    /* Do not let equippy chars confuse the health bar */
    equippy_chars = FALSE;

    /* XXX Hack -- notice "command" mode */
    hilite_player = FALSE;

    /* XXX XXX Mega-Hack -- use "preserve" mode */
    p_ptr->preserve = TRUE;
}


#if 0

/*
 * Hack -- take a note later
 */
static void borg_tell(cptr what)
{
    cptr s;

    /* Hack -- self note */
    borg_keypress(':');
    for (s = what; *s; s++) borg_keypress(*s);
    borg_keypress('\n');
}

#endif



/*
 * Count the number of items of the given kind
 */
static bool borg_amount(int k)
{
    int i, n = 0;

    /* Scan the pack */
    for (i = 0; i < INVEN_PACK; i++) {

	auto_item *item = &auto_items[i];

	/* Notice end of inventory */
	if (!item->iqty) break;

	/* Require that kind */
	if (item->kind != k) continue;

	/* Count items */
	n += item->iqty;
    }

    /* Result */
    return (n);
}


/*
 * Hack -- perform an action on an item of the given "kind"
 * Hack -- by choosing the "last" pile, we prefer discounted items
 */
static int borg_choose(int k)
{
    int i, n = -1;

    /* Nothing available */
    if (kind_have[k] <= 0) return (-1);
    
    /* Scan the pack */
    for (i = 0; i < INVEN_PACK; i++) {

	auto_item *item = &auto_items[i];

	/* Notice end of inventory */
	if (!item->iqty) break;

	/* Require that kind */
	if (item->kind != k) continue;

	/* Save the last "best" index (smallest pile) */
	if ((n < 0) || (item->iqty <= auto_items[n].iqty)) n = i;
    }

    /* Result */
    return (n);
}



/*
 * Hack -- perform an action on an item of the given "kind"
 */
static bool borg_action(char c, int k)
{
    int i;

    /* Choose a usable item */
    i = borg_choose(k);

    /* Nothing to use */
    if (i < 0) return (FALSE);

    /* Hack -- Cannot read when blind/confused */
    if ((c == 'r') && (do_blind || do_confused)) return (FALSE);

    /* Log the message */
    if (auto_fff) {
	borg_info(format("Action '%c' on item %s.", c, auto_items[i].desc));
    }

    /* Perform the action */
    borg_keypress(c);
    borg_keypress('a' + i);

    /* Success */
    return (TRUE);
}



/*
 * Hack -- perform an action on an item of the given "kind"
 * Hack -- only accept items with a non-zero "pval" code
 * Hack -- by choosing the first pile, we prefer "high charges"
 * This tends to result in "piles" of items with equal charges
 * This may also induce occasional "dropping" of items :-)
 */
 /* EAW -- MJC noticed that it should return int, not bool */
static int borg_choose_pval(int k)
{
    int i, n = -1;

    /* Nothing available */
    if (kind_have[k] <= 0) return (-1);
    
    /* Scan the pack */
    for (i = 0; i < INVEN_PACK; i++) {

	auto_item *item = &auto_items[i];

	/* Notice end of inventory */
	if (!item->iqty) break;

	/* Require that kind */
	if (item->kind != k) continue;

	/* Hack -- Require non-zero "pval" */
	if (item->pval == 0) continue;

	/* Save the first "best" index (smallest pile) */
	if ((n < 0) || (item->iqty < auto_items[n].iqty)) n = i;
    }

    /* Result */
    return (n);
}



/*
 * Hack -- perform an action on an item of the given "kind"
 * Hack -- only accept items with a positive "pval"
 */
static bool borg_action_pval(char c, int k)
{
    int i;

    /* Choose a usable item */
    i = borg_choose_pval(k);

    /* Nothing to use */
    if (i < 0) return (FALSE);

    /* Hack -- Cannot read when blind/confused */
    if ((c == 'r') && (do_blind || do_confused)) return (FALSE);

    /* Log the message */
    if (auto_fff) {
	borg_info(format("Action '%c' on item %s.", c, auto_items[i].desc));
    }

    /* Perform the action */
    borg_keypress(c);
    borg_keypress('a' + i);

    /* Success */
    return (TRUE);
}

/*
 * MJC -- try to use healing, *healing*, life potions
 * Smallest ones first
 */
static bool borg_do_potion_heal(void)
{
    if (borg_action('q', kind_potion_healing)) return (TRUE);
    if (borg_action('q', kind_potion_star_healing)) return (TRUE);
    if (borg_action('q', kind_potion_life)) return (TRUE);
    return (FALSE);
}

/*
 * MJC -- try to use healing, *healing*, life potions
 * Biggest ones first
 */
static bool borg_do_major_potion_heal(void)
{
    if (borg_action('q', kind_potion_life)) return (TRUE);
    if (borg_action('q', kind_potion_star_healing)) return (TRUE);
    if (borg_action('q', kind_potion_healing)) return (TRUE);
    return (FALSE);
}

/*
 * MJC -- count total healing, *healing*, life potions
 */
static bool borg_count_healing(void)
{
    return (kind_have[kind_potion_healing] +
	kind_have[kind_potion_star_healing] + kind_have[kind_potion_life]);
}

/*
 * Decide whether to "inspect" a grid
 * Assume the given grid is NOT a wall
 */
static bool borg_inspect()
{
    int         i, wall = 0, supp = 0, diag = 0;

    char        cc[8];


    /* Hack -- Never inspect the town */
    if (auto_depth == 0) return (FALSE);

    /* Hack -- This grid is fully inspected */
    if (pg->xtra > 20) return (FALSE);

    /* Tweak -- only search occasionally */
    if (rand_int(50) != 0) return (FALSE);


    /* Examine adjacent grids */
    for (i = 0; i < 8; i++) {

	/* Extract the location */
	int xx = c_x + ddx[ddd[i]];
	int yy = c_y + ddy[ddd[i]];

	/* Obtain the grid */
	auto_grid *ag = grid(xx, yy);

	/* Require knowledge */
	if (ag->o_c == ' ') return (FALSE);

	/* Extract the symbol */
	cc[i] = ag->o_c;
    }


    /* Count possible door locations */
    for (i = 0; i < 4; i++) if (cc[i] == '#') wall++;

    /* Hack -- no possible doors */
    if (!wall) return (FALSE);


    /* Count supporting evidence for secret doors */
    for (i = 0; i < 4; i++) {
	if ((cc[i] == '#') || (cc[i] == '%')) supp++;
	else if ((cc[i] == '+') || (cc[i] == '\'')) supp++;
    }

    /* Count supporting evidence for secret doors */
    for (i = 4; i < 8; i++) {
	if ((cc[i] == '#') || (cc[i] == '%')) diag++;
    }

    /* Hack -- Examine "suspicious" walls */
    if (((diag >= 4) && (supp >= 3)) ||
	((diag >= 4) && (rand_int(30) == 0)) ||
	((diag >= 2) && (rand_int(900) == 0))) {

	/* Take note */
	borg_note("Searching...");

	/* Remember the search */
	if (pg->xtra < 100) pg->xtra += 9;

	/* Search a little */
	borg_keypress('0');
	borg_keypress('9');
	borg_keypress('s');

	/* Success */
	return (TRUE);
    }


    /* Assume no suspicions */
    return (FALSE);
}





#if 0

/*
 * Send a command to inscribe item number "i" with the inscription "str".
 */
static void borg_send_inscribe(int i, cptr str)
{
    cptr s;

    /* The "inscribe" command */
    char c1 = '{', c2 = '}';

    /* Label it */
    borg_keypress(c1);

    /* Hack -- allow "equipment" labelling */
    if (i >= INVEN_WIELD) {
	borg_keypress('/');
	i -= INVEN_WIELD;
    }

    /* Choose the item */
    borg_keypress('a' + i);

    /* Send the label */
    for (s = str; *s; s++) borg_keypress(*s);

    /* End the inscription */
    borg_keypress('\n');
}

#endif



/*
 * Hack -- determine if an item is "armor"
 */
static bool borg_item_is_armour(auto_item *item)
{
    /* Check for armor */
    if ((item->tval == TV_DRAG_ARMOR) ||
	(item->tval == TV_HARD_ARMOR) ||
	(item->tval == TV_SOFT_ARMOR) ||
	(item->tval == TV_SHIELD) ||
	(item->tval == TV_CROWN) ||
	(item->tval == TV_HELM) ||
	(item->tval == TV_CLOAK) ||
	(item->tval == TV_GLOVES) ||
	(item->tval == TV_BOOTS)) {

	/* Yep */
	return (TRUE);
    }

    /* Nope */
    return (FALSE);
}


/*
 * Hack -- determine if an item is a "weapon"
 */
static bool borg_item_is_weapon(auto_item *item)
{
    /* Check for weapon */
    if ((item->tval == TV_SWORD) ||
	(item->tval == TV_HAFTED) ||
	(item->tval == TV_POLEARM) ||
	(item->tval == TV_DIGGING) ||
	(item->tval == TV_BOW) ||
	(item->tval == TV_BOLT) ||
	(item->tval == TV_ARROW) ||
	(item->tval == TV_SHOT)) {

	/* Yep */
	return (TRUE);
    }

    /* Nope */
    return (FALSE);
}





/* EAW -- This whole routine is different than Ben's */
/*
 * Estimate the "power" of an item.
 *
 * Make a heuristic guess at the "power" of an item in "gold"
 *
 * We assume that the given item is "aware" and "known" (or "average").
 * We also assume that the given item is "acceptable" (not worthless).
 *
 * Note -- This is used both for "wearing" items and for "buying" them.
 */
static s32b item_power(auto_item *item)
{
#ifdef BLOWS
    /* EAW -- check worn weapon type, used in blows calc */
    auto_item *item2;
#endif /* BLOWS */
    
    s32b value;

#ifdef FRITS
#ifdef BLOWS
    int blows;  /* # of blows with this weapon */
#endif /* BLOWS */
    int weight; /* weapon weight */
#endif /* FRITS */


    /* Mega-Hack -- Never wear unknowns */
    if (!item->kind) return (0L);
    
    /* never wear good stuff unidentfied */
    if ((streq(item->note, "{average}")) ||
	(streq(item->note, "{good}")) ||
	(streq(item->note, "{blessed}")) ||
	(streq(item->note, "{excellent}")) ||
	(streq(item->note, "{special}")) ||
	(streq(item->note, "{terrible}"))) {

	return (0L);
    }

    /* EAW -- make Calris very valuable, con and res-disenchant VERY 
	      important to the borg */
    if (item->name1 == ART_CALRIS) return (250000);
    /* EAW -- Thorin is more useful to him than Anarion */
    if (item->name1 == ART_THORIN) return (200000);

    /* Extract the base value */
    value = k_list[item->kind].cost;
    

    /* Use the base value of artifacts */
    if (item->name1) value = v_list[item->name1].cost;

    /* Never wear "crap" */
    if (value <= 0L) return (0L);

    /* Never wear bad items */
    if (item->name2 >= EGO_MIN_WORTHLESS) return (0L);
    
    /* Mega-Hack -- bonus for ego-items */
    /* if (item->name2) value += 1000L; */
    /* EAW -- try to factor in pval a little */
    if (item->name2) value += item->pval * 100;
    
    
    /* Base Armour */
    if ((item->tval == TV_SHIELD) ||
	(item->tval == TV_SOFT_ARMOR) ||
	(item->tval == TV_HARD_ARMOR) ||
	(item->tval == TV_DRAG_ARMOR)) {

	/* EAW -- if mana user, don't wear the following unless ego or
	   artifact to save on weight: */
	   
	if (auto_pclass != PCLASS_WARRIOR) {
	      /* Metal Scale Mail --> Ribbed Plate, Double Chain Mail */  
	   if ((item->kind >= 108 && item->kind <= 117) || item->kind == 121 ||
	      /* Large shields */
	      item->kind == 129 || item->kind == 131) {
		if (!item->name1 && !item->name2) return (0);
	   }
	}

	/* Check the base armor */
	/* MJC -- not 10x as important */
      /* value += (item->ac * 250L); */
	/* EAW -- No, this takes into account enchantability! */
	value += (item->ac * 1000L);

	/* Check the bonuses */
	value += (item->to_a * 100L);

	/* Hack -- Check the other bonuses */
	value += (item->to_h * 3L);
	value += (item->to_d * 30L);

	/* Mega-Hack -- Desire resistance */
	if (item->name2 == EGO_ELVENKIND) value += 8000L;
	else if (item->name2 == EGO_RESIST) value += 5000L;
	else if (item->name2 == EGO_RESIST_A) value += 3000L;
	else if (item->name2 == EGO_RESIST_F) value += 1000L;
	else if (item->name2 == EGO_RESIST_C) value += 100L;
	else if (item->name2 == EGO_RESIST_E) value += 100L;
    }

    /* Other Armour */
    if ((item->tval == TV_BOOTS) ||
	(item->tval == TV_GLOVES) ||
	(item->tval == TV_CLOAK) ||
	(item->tval == TV_HELM)) {
	
	/* EAW -- if mana user, don't wear the following unless ego or
	   artifact to save on weight: */
	   /* Iron helm */
	if (auto_pclass != PCLASS_WARRIOR && item->kind == 96) {
		if (!item->name1 && !item->name2) return (0);
	}

	/* EAW -- gloves bad for spellcasters */
	if (auto_sclass == SCLASS_MAGE && item->tval == TV_GLOVES) {
		if (item->name2 != EGO_AGILITY &&
		    item->name2 != EGO_FREE_ACTION &&
		    !(item->name1 && value >= 30000)) return(0L);
	}
	
	/* Check the base armor */
	/* MJC -- not as important */
	/* value += (item->ac * 250L); */
	/* EAW -- No, this takes into account enchantability! */
	value += (item->ac * 1000L);


	/* Check the bonuses */
	value += (item->to_a * 100L);

	/* Hack -- Check the other bonuses */
	value += (item->to_h * 15L);
	value += (item->to_d * 100L);

	/* Mega-Hack -- Desire some boots */
	if (item->name2 == EGO_SPEED) value += 500000L;

	/* Mega-Hack -- Desire some cloaks */
	else if (item->name2 == EGO_AMAN) value += 5000L;

	/* Mega-Hack -- Desire some helms/crowns */
	else if (item->name2 == EGO_MAGI) value += 5000L;
	else if (item->name2 == EGO_REGENERATION) value += 3000L;
	else if (item->name2 == EGO_SEEING) value += 1000L;

	/* EAW -- rank gloves */
	else if (item->name2 == EGO_AGILITY) value += 4000 + item->pval * 1000;
	else if (item->name2 == EGO_POWER) value += 9000;
	else if (item->name2 == EGO_SLAYING) value += 8000;

	/* Mega-Hack -- Desire all ego-items */
	else if (item->name2) value += 500L;
    }

    /* Normal Weapons (never use diggers) */
    else if ((item->tval == TV_HAFTED) ||
	     (item->tval == TV_SWORD) ||
	     (item->tval == TV_POLEARM)) {

	/* Avoid negative bonuses */
/*        if (item->to_h < 0) return (0L);  */
	if (item->to_d < 0) return (0L);

#ifdef FRITS
	
	/* MEGA_HACK direct access to k_list */
	/* EAW -- check for artifacts! */
	if (item->name1) weight = v_list[item->name1].weight;
	else weight=k_list[item->kind].weight;
/* This is the *WRONG LIST* for artifacts; must be v_list */

	/* priests and mages are a bit wimpier than your standard warrior! */
	/* I lost 2 paladin-borgs with STR 16 fighting with a *lance* */
	/* HACK */
	if (weight > 15 * auto_stat_str) 
	   /* value -= (weight - 15 * auto_stat_str) * weight; */
	   /* EAW -- still not good enough, just make it 0 :( */
	   return (0);
	
	/* MEGA_HACK should code this in honestly */
      /* EAW -- infiniate loop problems if weapon boosts DEX or STR */
      /* MJC -- nothing wrong with HAs */
      
#ifdef BLOWS
      item2 = &auto_items[INVEN_WIELD];
      if (item != item2 && item2->name1 || item2->name2 == EGO_WEST)
		blows = 1;
      else {
	blows=attack_blows(weight);
	if (item != item2 && item2->name2 == EGO_ATTACKS)
		blows -= item2->pval;
      }

#endif /* BLOWS */        
	/* priests get a penalty for non-hafted */
	/* EAW -- no penalty for {blessed}, factor in blows */          
	/* MJC -- {blessed} not blessed, only (Blessed) */
	if ((auto_pclass==PCLASS_PRIEST)&&(item->tval!=TV_HAFTED) && 
	    (item->name2 != EGO_BLESS_BLADE) && (item->name2 != EGO_HA)) {
	 /* Check artifacts too */
	 if (!(item->name1 && (v_list[item->name1].flags3 & TR3_BLESSED))) {  
	   
	   /* EAW -- -2 not -1 bonus */
	   value -= 
#ifdef BLOWS 
      blows *
#endif /* BLOWS */
	   (300L + 2000L); /* -2 to-hit, -2 to-dam (non-enchantable) */
	 }
	}

#endif /* FRITS */

	/* Wow, it's an artifact, be more picky in evaluating base damage */
	if (item->name1) value += 
#ifdef BLOWS
				  blows *
#endif /* BLOWS */
				  (item->dd + item->dd * item->ds) * 50L;


	/* Check the max damage for normal weapons */
	else value += 
#ifdef BLOWS
		      blows *
#endif /* BLOWS */
		      ((item->dd * item->ds) * 500L);
	
	/* Check the bonuses */
	value += 
#ifdef BLOWS
		 blows *
#endif /* BLOWS */
		 (item->to_h * 15L);
	value += 
#ifdef BLOWS
		 blows *
#endif /* BLOWS */
		 (item->to_d * 100L);
	
	/* Mega-Hack -- desire some ego-items */
	/* EAW -- changed rough estimate of EGO_ATTACKS value */
#ifdef BLOWS
	if (item->name2 == EGO_ATTACKS) value += 500L;
#else
	if (item->name2 == EGO_ATTACKS) value += item->pval * value;
#endif /* BLOWS */
	else if (item->name2 == EGO_WEST) value += 8000L;
	else if (item->name2 == EGO_HA) value += 3000L;
	else if (item->name2 == EGO_DF) value += 3000L;
	else if (item->name2 == EGO_FT) value += 2000L;
	else if (item->name2 == EGO_FB) value += 2000L;
	else if (item->name2) value += 500L;

	/* MJC -- artifacts get bonuses based on some flags */
	if (item->name1) {
	    int f1, f2, f3;

	    f1 = v_list[item->name1].flags1;
	    f2 = v_list[item->name1].flags2;
	    f3 = v_list[item->name1].flags3;
	    if (f1 & TR1_KILL_DRAGON) value += 2000L;
	    if (f1 & TR1_BRAND_ELEC) value += 3000L;
	    if (f1 & TR1_BRAND_FIRE) value += 1500L;
	    if (f1 & TR1_BRAND_COLD) value += 1500L;
	    if (f2 & TR2_FREE_ACT) value += 500L;
	}
    }

    /* Missile Launchers */
    else if (item->tval == TV_BOW) {

	/* Avoid negative bonuses */
	if (item->to_h < 0) return (0L);
	if (item->to_d < 0) return (0L);

	/* Mega-Hack -- Check the sval */
     /*   value += (item->sval * 1000L);   */

	/* Check the bonuses */
	value += (item->to_h * 10L);
	value += (item->to_d * 100L);

	/* take multiplier into account! */
	value += item->dd * 1000L;
	
	/* Mega-Hack -- desire certain ego-items */
      /*  if (item->name2 == EGO_EXTRA_MIGHT) value += 5000L; */
	/* EAW */      
	if (item->name2 == EGO_EXTRA_SHOTS) value *= 2;
    }

    /* Rings/Amulets */
    else if ((item->tval == TV_AMULET) || (item->tval == TV_RING)) {

	/* Avoid negative bonuses */
	if (item->to_h < 0) return (0L);
	if (item->to_d < 0) return (0L);
	if (item->to_a < 0) return (0L);
	if (item->pval < 0) return (0L);
	
	/* EAW -- prefer Accuracy, Damage, Slaying over all others */
	if (item->kind == kind_ring_hit) value += 16000;
	if (item->kind == kind_ring_dam) value += 17000;
	if (item->kind == kind_ring_slaying) value += 18000;

	/* EAW -- These amulets suck compared to others */
	if (item->kind == kind_amulet_cha || item->kind == kind_amulet_search)
		value -= 500;


	/* Hack -- Give credit for bonuses */
	value += ((item->to_h + 5 * item->to_d + item->to_a + item->pval) * 100L);

#ifdef FRITS
	if (item->kind==kind_ring_speed) value+=item->pval*20000;
#endif /* FRITS */
    }


    /* Lite */
    else if (item->tval == TV_LITE) {

	/* Prefer usable lites */
	if (item->pval) value += 10000L;
    }
    
    
    /* Flasks */
    else if (item->tval == TV_FLASK) {

	/* Buy flasks for lanterns */
	value += 2000L;
    }

    /* Food */
    else if (item->tval == TV_FOOD) {

	/* Buy normal food */
	if (item->kind == kind_food_ration) 
#ifdef FRITS
	/* magic users don't need food */
	if (! borg_can_cast_dinner_spell())
#endif /* FRITS */
	   value += 50000L;
    }
    
    /* Scrolls */
    else if (item->tval == TV_SCROLL) {

	/* Hack -- prefer certain items */
	if (item->kind == kind_scroll_teleport) value += 3000L;
	if (item->kind == kind_scroll_identify) 
#ifdef FRITS
	/* magic users don't need identify */
	/* EAW -- Never chuck these if you can help it! */
/*        if (! borg_can_cast_identify_spell()) */
#endif /* FRITS */
	   value += 5000L;
	if (item->kind == kind_scroll_recall) value += 6000L;
    }
    
    /* Potions */
    else if (item->tval == TV_POTION) {

	/* Hack -- prefer certain items */
	if (item->kind == kind_potion_critical ||
	    item->kind == kind_potion_healing ||
	    item->kind == kind_potion_star_healing ||
	    item->kind == kind_potion_life ||
	    item->kind == kind_potion_restore_mana ||
	    item->kind == kind_potion_speed) value += 5000L;
	
	/* EAW -- Fix Exp 1st!!!!!!! */
	else if (item->kind == kind_potion_fix_exp && do_fix_exp)
		value += 20000L;
	
	/* EAW -- Fix stats 2nd !!!!!!!!!!!!! */
	else if (item->kind == kind_potion_fix_str && do_fix_str)
		value += 10000L;
	else if (item->kind == kind_potion_fix_int && do_fix_int)
		value += 10000L;
	else if (item->kind == kind_potion_fix_wis && do_fix_wis)
		value += 10000L;
	else if (item->kind == kind_potion_fix_dex && do_fix_dex)
		value += 10000L;
	else if (item->kind == kind_potion_fix_con && do_fix_con)
		value += 10000L;
	else if (item->kind == kind_potion_fix_chr && do_fix_chr)
		value += 10000L;


#ifdef FRITS
       /* gain stat potions *** HACK *** assume first 6 of kind_force_potions */
	  if ((item->kind == kind_force_potions[0]) &&
	     (auto_stat_str < 18+75)) value += 300000;
	  if ((item->kind == kind_force_potions[1]) &&
	     (auto_stat_int < 18+75) && (auto_sclass==SCLASS_MAGE)) value += 300000;
	  if ((item->kind == kind_force_potions[2]) &&
	     (auto_stat_wis < 18+75) && (auto_sclass==SCLASS_PRIEST)) value += 300000;
	  if ((item->kind == kind_force_potions[3]) &&
	     (auto_stat_dex < 18+75)) value += 300000;
	  if ((item->kind == kind_force_potions[4]) &&
	     (auto_stat_con < 18+75)) value += 300000;
	  if ((item->kind == kind_force_potions[5]) &&
	     (auto_stat_chr < 18+75)) value += 300000;
#endif /* FRITS */
    }
	
#ifdef FRITS
    /* Books */
    else if ( ((item->tval == TV_MAGIC_BOOK) && (auto_sclass==SCLASS_MAGE)) ||
	      ((item->tval == TV_PRAYER_BOOK) && (auto_sclass==SCLASS_PRIEST)) )
	value += 100000L;       /* VERY necessary */
#endif /* FRITS */
    
    /* Return the value */
    return (value);
}




/*
 * Determine how much it is "worth" to bring an object back to town
 * This function analyzes a single instance of the given item.
 *
 * Note that we make heavy use of the "borg_item_value()" routine, which
 * is pretty accurate, but is misleading for unaware or unidentified items,
 * and for items with "convenient" side effects, such as missiles or staffs
 * of perceptions, and for items which can easily "stack" with other items.
 *
 * This routine is used to determine how much gold the Borg will get for
 * holding onto an item until he can sell it in a shop.  This is NOT used
 * to determine which item is best to buy or wield/wear, see "item_power()".
 *
 * This function currently assumes that "borg_item_value()" is "correct",
 * which is a large assumption, since certain items have "hidden" cost
 * components, such as weapons of slay undead which also hold life.
 *
 * Hack -- we add "heuristic" bonuses to various items which have
 * "implicit" value to the Borg.  This is cute but a little dangerous.
 */
static s32b item_worth(auto_item *item)
{
    s32b value;


    /* Extract the base value */
    value = borg_item_value(item);

    /* Worthless item */
    if (value <= 0L) return (0L);


    /* Mega-Hack -- fake value for non-aware items */
    if (!item->kind) return (auto_depth * 100 + 50 + value);


    /* Hack -- staffs of identify can be used */
    if (item->kind == kind_staff_identify) value += item->pval * 200L;

    /* Hack -- staffs of teleport can be used */
    if (item->kind == kind_staff_teleport) value += item->pval * 200L;


    /* Return the value */
    return (value);
}



/*
 * Determine if an item can be sold in the current store
 */
static bool borg_good_sell(auto_item *item)
{
    int tval = item->tval;
    int i;

    /* EAW -- keep good weapons which are currently too heavy in home */
    int weight;

    /* EAW -- store good weapons which are currently too heavy */
	/* MEGA_HACK direct access to k_list */
	/* EAW -- check for artifacts! */
	if (item->name1) weight = v_list[item->name1].weight;
	else weight=k_list[item->kind].weight;
/* This is the *WRONG LIST* for artifacts; must be v_list */

	/* priests and mages are a bit wimpier than your standard warrior! */
	/* I lost 2 paladin-borgs with STR 16 fighting with a *lance* */
	/* HACK -- Frits */
	if (weight > 15 * auto_stat_str && item_worth(item) >= 3500) { 
	
		/* Save them in the home */
		if (shop_num == 7) return (TRUE);

		/* Never sell them */
		return (FALSE);
	}
		


    /* Hack -- artifacts */
    if (item->name1) {

	/* Save them in the home */
	if (shop_num == 7) return (TRUE);

	/* Never sell them */
	return (FALSE);
    }

#ifdef FRITS
	/* EAW -- I've changed this around a bunch */
    if ((auto_sclass==SCLASS_MAGE)&&(item->tval==TV_MAGIC_BOOK)) {
       for(i=0;i<9;i++) {
	  if (item->kind==kind_magic_books[i]) {
	     /* sell lower 4 in magic shop */
	     if (shop_num == 5 && i < 4 &&
		kind_have[kind_magic_books[i]] > 2) return(TRUE);
	     /* sell higher 4 to home */
	     if (shop_num == 7 && i >= 4 &&
		kind_have[kind_magic_books[i]] > 1) return(TRUE);
	     
	     /* never sell them */
	     return(FALSE);
	  }
       }
    }
    if ((auto_sclass==SCLASS_PRIEST)&&(item->tval==TV_PRAYER_BOOK)) {
       for(i=0;i<9;i++) 
       {
	  if (item->kind==kind_prayer_books[i]) {
	     /* sell lower 4 to temple */ 
	     if (shop_num == 3 && i < 4 &&
		kind_have[kind_prayer_books[i]] > 2) return(TRUE);
	     /* sell higher 4 to home */
	     if (shop_num == 7 && i >= 4 &&
		kind_have[kind_prayer_books[i]] > 1) return(TRUE);
	     
	     /* never sell them */
	     return(FALSE);
	  }
       }
    }

#endif /* FRITS */

    /* MJC -- don't get in buy/sell loops with these potions/scrolls */
    if (tval == TV_POTION) {
	for (i = 0; kind_force_potions[i]; i++) {
	    if (item->kind == kind_force_potions[i]) return (FALSE);
	}
    }
    if (tval == TV_SCROLL) {
	for (i = 0; kind_force_scrolls[i]; i++) {
	    if (item->kind == kind_force_scrolls[i]) return (FALSE);
	}
    }

    /* Switch on the store */
    switch (shop_num + 1) {

      /* General Store */
      case 1:

	/* Analyze the type */
	switch (tval) {
	  case TV_DIGGING:
	  case TV_CLOAK:
	  case TV_FOOD:
	  case TV_FLASK:
	  case TV_LITE:
	  case TV_SPIKE:
	    return (TRUE);
	}
	break;

      /* Armoury */
      case 2:

	/* Analyze the type */
	switch (tval) {
	  case TV_BOOTS:
	  case TV_GLOVES:
	  case TV_HELM:
	  case TV_CROWN:
	  case TV_SHIELD:
	  case TV_SOFT_ARMOR:
	  case TV_HARD_ARMOR:
	  case TV_DRAG_ARMOR:
	    return (TRUE);
	}
	break;

      /* Weapon Shop */
      case 3:

	/* Analyze the type */
	switch (tval) {
	  case TV_SHOT:
	  case TV_BOLT:
	  case TV_ARROW:
	  case TV_BOW:
#ifndef FRITS
	  case TV_HAFTED:
#endif /* FRITS */
	  case TV_POLEARM:
	  case TV_SWORD:
	    return (TRUE);
	}
	break;

      /* Temple */
      case 4:

	/* Analyze the type */
	switch (tval) {
	  case TV_HAFTED:
	  case TV_SCROLL:
	  case TV_POTION:
	  case TV_PRAYER_BOOK:
	    return (TRUE);
	}
	break;

      /* Alchemist */
      case 5:

	/* Analyze the type */
	switch (tval) {
	  case TV_SCROLL:
	  case TV_POTION:
	    return (TRUE);
	}
	break;

      /* Magic Shop */
      case 6:

	/* Analyze the type */
	switch (tval) {
	  case TV_MAGIC_BOOK:
	  case TV_AMULET:
	  case TV_RING:
	  case TV_STAFF:
	  case TV_WAND:
	  case TV_ROD:
	    return (TRUE);
	}
	break;
    }

    /* Assume not */
    return (FALSE);
}




/*
 * Determine if the Borg is running out of crucial supplies.
 * This routine is used to invoke word of recall (if possible)
 */
static bool borg_restock()
{
    auto_item *item = &auto_items[INVEN_LITE];

    /* Running out of food */
    if (kind_have[kind_food_ration] < 5 &&
	!borg_can_cast_dinner_spell()) return (TRUE);

    /* Totally out of light */
    if (item->iqty == 0) return (TRUE);

    /* Running out of flasks for lanterns */
    if ((item->kind == kind_lantern) && (kind_have[kind_flask] < 5)) return (TRUE);

    /* Running out of torches */
    if ((item->kind == kind_torch) && (kind_have[kind_torch] < 5)) return (TRUE);

    /* Assume happy */
    return (FALSE);
}


/*
 * Determine if an item should be bought
 */
static bool borg_good_buy(auto_item *ware)
{
    int i, slot;

    auto_item *worn = NULL;


    /* Never buy "weird" stuff */
    if (!ware->kind) return (FALSE);


    /* Determine where the item would be worn */
    slot = borg_wield_slot(ware);

    /* Extract the item currently in that slot */
    if (slot >= 0) worn = &auto_items[slot];


    /* Use the "shopping list" */
    if (kind_need[ware->kind]) {

	/* Check the pile */
	if (borg_amount(ware->kind) < kind_need[ware->kind]) {
	    return (TRUE);
	}
    }
    

    /* Process Torches */
    if (ware->kind == kind_torch) {

	/* Never use the black market */
	if (shop_num == 6) return (FALSE);

	/* Hack -- Artifact lites are the best */
	if (worn->name1) return (FALSE);

	/* Hack -- Torches are defeated by (fueled) lanterns */
	if (worn->kind == kind_lantern) {
	    if (kind_have[kind_flask] >= 10) return (FALSE);
	}

	/* Always have at least 20 torches */
	if (kind_have[kind_torch] < 20) return (TRUE);
    }

    /* Process Lanterns */
    else if (ware->kind == kind_lantern) {

	/* Never use the black market */
	if (shop_num == 6) return (FALSE);

	/* Hack -- Artifact lites are the best */
	if (worn->name1) return (FALSE);

	/* Never buy a lantern when wielding one already */
	if (worn->kind == kind_lantern) return (FALSE);

	/* Always buy at least 1 lantern */
	if (kind_have[kind_lantern] < 1) return (TRUE);
    }


    /* Missiles */
    else if ((ware->tval == TV_SHOT) ||
	     (ware->tval == TV_ARROW) ||
	     (ware->tval == TV_BOLT)) {

	/* Never use the black market */
	if (shop_num == 6) return (FALSE);

	/* Never buy expensive missiles */
	if (ware->cost > 50) return (FALSE);

	/* Never buy incorrect missiles */
	if (ware->kind != kind_missile) return (FALSE);

	/* Never buy too many missiles */
	if (kind_have[kind_missile] >= 50) return (FALSE);
	
	/* Buy missiles */
	return (TRUE);
    }

    /* EAW -- Process amulets and rings */
    else if ((ware->tval == TV_AMULET) || (ware->tval == TV_RING)) {

	if (item_power(ware) > item_power(worn)) {
		return (TRUE);
	}
	
	/* hack for right hand ring */
	if (ware->tval == TV_RING &&
	    item_power(ware) > item_power(&auto_items[INVEN_RIGHT])) {

	    return (TRUE);
	}
	
	return (FALSE);
    }


    /* Process Equipment */
    else if (slot >= 0) {

	/* Always use something */
	/* EAW -- BAD, buys 0 value stuff, like gloves for mages */
      /* if (!worn->iqty) return (TRUE); */

	/* Hack -- Always buy the best we can afford */
	if (item_power(ware) > item_power(worn)) return (TRUE);
    }

    /* EAW -- buy cool potions, skip 1st 7 force_potions */
    else if (ware->tval == TV_POTION) {
	for (i = 7; kind_force_potions[i]; i++)
		if (ware->kind == kind_force_potions[i])
			return (TRUE);
    }

    /* Assume useless */
    return (FALSE);
}


/*
 * Hack -- determine what to do with an item
 */
static bool borg_notice_aux(auto_item *item)
{
    int i, slot;

    /* EAW -- save desc */
    char desc[80];

    auto_item *worn = NULL;

    bool res = FALSE;


    /* Clear the flags */
    item->wear = item->cash = item->junk = item->test = FALSE;

    /* EAW -- checked desc versus last junked to see if he's junking an
	      artifact and put a stop to it! */

    if (!item->able && strcmp(desc_last_junked, item->desc) == 0) {
	borg_note("junking cursed artifact?!");
	item->cash = FALSE;
	item->test = TRUE;
	return(res);
    }

    /* EAW -- don't identify crappy items, sell them */    
    for (i = 0; kind_crap_items[i]; i++) {
	if (item->kind == kind_crap_items[i]) {
		if (!streq(item->note, "{cursed}")) {
			item->junk = FALSE;
			item->cash = TRUE;
		}
		else {
			item->junk = TRUE;
			item->cash = FALSE;
		}
		return (res);
	}
    }

    /* EAW -- Hack -- allows selling of cursed artifacts to home */
    if (item->name1 && item_power(item) <= 0) {
	item->junk = FALSE;
	item->cash = TRUE;
	return (res);
    }

    /* Throw away "junk" and "spikes" */
    /* EAW -- take Calris into account */
    if ((item_worth(item) <= 0 && item_power(item) < 100000) ||
	(item->tval == TV_SPIKE)) {

	/* This is junk */
	item->junk = TRUE;

	/* Do not sell this */
	item->cash = FALSE;

	/* All done */
	return (res);
    }


    /* Hack -- Assume we will sell it */
    item->cash = TRUE;


    /* Check the "shopping list" */
    if (kind_need[item->kind]) {
    
	/* Hack -- Do not sell items we "need" */
	if (kind_have[item->kind] <= kind_need[item->kind]) {
	    item->cash = FALSE;
	}
    }
    

    /* Process scrolls */
    if (item->tval == TV_SCROLL) {

	/* Hack -- Identify "interesting" items */
	if (!item->kind && (auto_depth > 5)) {
	    item->test = TRUE;
	    item->cash = FALSE;
	}
    }


    /* Process potions */
    else if (item->tval == TV_POTION) {

	/* Hack -- Identify "interesting" items */
	if (!item->kind && (auto_depth > 5)) {
	    item->test = TRUE;
	    item->cash = FALSE;
	}
    }


    /* Process rods */
    else if (item->tval == TV_ROD) {

	/* Always identify rods */
	if (!item->kind) {
	    item->test = TRUE;
	    item->cash = FALSE;
	}
    }


    /* Process wands/staffs */
    else if ((item->tval == TV_WAND) || (item->tval == TV_STAFF)) {

	/* Identify type and charges */
	if (!item->kind || !item->able) {
	    item->test = TRUE;
	    item->cash = FALSE;
	}
    }


    /* Mega-Hack -- Junk chests */
    else if (item->tval == TV_CHEST) {

	/* Hack -- Throw it away */
	item->junk = TRUE;
	item->cash = FALSE;
    }


    /* Keep some food */
    else if (item->tval == TV_FOOD) {

	/* Hack -- Identify "interesting" items */
	if (!item->kind) {
	    item->test = TRUE;
	    item->cash = FALSE;
	}
    }


    /* Keep flasks (unless unnecessary) */
    else if (item->tval == TV_FLASK) {

	/* Hack -- assume we will keep it */
	item->cash = FALSE;

	/* Hack -- Artifact lites need no fuel */
	if (auto_items[INVEN_LITE].name1) item->cash = TRUE;
    }

    /* EAW -- removed Frits code for spell books, redundant and messed up */

    /* Hack -- skip "non-wearables" */
    if (item->tval < TV_MIN_WEAR) return (res);
    if (item->tval > TV_MAX_WEAR) return (res);


    /* See what slot that item could go in */
    slot = borg_wield_slot(item);

    /* Extract the item currently in that slot */
    if (slot >= 0) worn = &auto_items[slot];


    /* Note -- Assume we will not sell it */
    item->cash = FALSE;


    /* Process rings */
    if (item->tval == TV_RING) {

	/* Hack -- identify items */
	if (!item->kind || !item->able) {
	    item->test = TRUE;
	}

	/* Wear most powerful items */
	else if (item_power(item) > item_power(worn)) {
	    item->wear = TRUE;
	}
	
	/* EAW -- hack for right hand */
	else if (item->tval == TV_RING
		 && item_power(item) > item_power(&auto_items[INVEN_RIGHT])) {
		
		/* make sure not in a store */
		borg_keypress(ESCAPE);

		/* take off right ring if there is one */
		if (&auto_items[INVEN_RIGHT] > 0) {
			borg_keypress(' ');
			borg_keypress('d');
			borg_keypress('/');
			borg_keypress('d');
			borg_keypress(' '); 
		}

		item->wear = TRUE;
	}


	/* Sell everything else */
	else {
	    item->cash = TRUE;
	}

	/* All done */
	return (res);
    }


    /* Process amulets */
    if (item->tval == TV_AMULET) {

	/* Hack -- identify items */
	if (!item->kind || !item->able) {
	    item->test = TRUE;
	}

	/* Wear most powerful items */
	else if (item_power(item) > item_power(worn)) {
	    item->wear = TRUE;
	}

	/* Sell everything else */
	else {
	    item->cash = TRUE;
	}

	/* All done */
	return (res);
    }


    /* Process Lite's */
    if (item->tval == TV_LITE) {

	/* Hack -- identify lites */
	if (!item->kind || !item->able) {
	    item->test = TRUE;
	}

	/* Hack -- Replace missing lites */
	else if (!worn->iqty) {
	    item->wear = TRUE;
	}

	/* Hack -- Sell "empty" Lites */
	else if (!item->pval) {
	    item->cash = TRUE;
	}

	/* Hack -- replace empty lites */
	else if (!worn->pval) {
	    item->wear = TRUE;
	}

	/* Hack -- Heuristic test */
	else if (item_power(item) > item_power(worn)) {
	    item->wear = TRUE;
	}

	/* Hack -- Keep a single artifact lite */
	else if (worn->name1) {
	    item->cash = TRUE;
	}

	/* Notice "junky" torches */
	else if (item->kind == kind_torch) {

	    /* Lantern plus fuel pre-empts torches */
	    if (worn->kind == kind_lantern) {
		if (kind_have[kind_flask] > 10) {
		    item->cash = TRUE;
		}
	    }

	    /* Sell "excess" torches */
	    else if (kind_have[kind_torch] > 30) {
		item->cash = TRUE;
	    }
	}

	/* Notice "extra" lanterns */
	else if (item->kind == kind_lantern) {

	    /* Already wielding a lantern */
	    if (worn->kind == kind_lantern) {
		item->cash = TRUE;
	    }

	    /* Already carrying a lantern */
	    else if (kind_have[kind_lantern] > 1) {
		item->cash = TRUE;
	    }
	}

	/* All done */
	return (res);
    }


    /* Identify "good" items */
    if (!item->able &&
	((streq(item->note, "{good}")) ||
	 (streq(item->note, "{blessed}")) ||
	 (streq(item->note, "{excellent}")) ||
	 (streq(item->note, "{special}")) ||
	 (streq(item->note, "{terrible}")) ||
	 (streq(item->note, "{uncursed}")))) {

	/* Test this */
	item->test = TRUE;

	/* All done */
	return (res);
    }

#ifdef FRITS
    /* Identify rings of speed etc; won't give feelings */
    if ((item->tval==TV_RING) && (item->kind) && (!item->able)) {
       if ( (item->kind == kind_ring_speed) || 
	    (item->kind == kind_ring_slaying) ) 
	 item->test = TRUE;
    }
#endif /* FRITS */

    /* Hack -- Wait for feelings */
    if (!item->able) {

#ifdef FRITS
/* Some classes, like Mages and Priests, have to wait *ages* to identify
   stuff since their 'auto-identify' doesn't kick in so easily. 
   therefore this hack... besides, they get the identify spell (eventually) */
       if ( ((auto_pclass==PCLASS_MAGE)||(auto_pclass==PCLASS_PRIEST)||(auto_pclass==PCLASS_RANGER)) &&
	    (rand_int(100)==0) )
	  item->test = TRUE;
#endif /* FRITS */

	/* All done */
	return (res);
    }


    /* Analyze missiles */
    if ((item->tval == TV_SHOT) ||
	(item->tval == TV_ARROW) ||
	(item->tval == TV_BOLT)) {

	/* Sell invalid missiles */
	if (item->kind != kind_missile) {
	    item->cash = TRUE;
	}

	/* Hack -- sell big piles of missiles */
	else if (item->iqty > 50) {
	    item->cash = TRUE;
	}

	/* All done */
	return (res);
    }

/* EAW -- BAD, will wear 0 value stuff, like gloves for mages, etc. */
    /* Wear something */
/*    if (!worn->iqty) {
*/
    /* Wear it */
/*    item->wear = TRUE;
    }
*/
    /* Wear the "best" equipment */
    if (item_power(item) > item_power(worn)) {

	/* Wear it */
	item->wear = TRUE;
    }

    /* Sell the rest */
    else {

	/* Sell it */
	item->cash = TRUE;
    }


    /* Success */
    return (res);
}



/*
 * Examine the inventory
 */
static void borg_notice(void)
{
    int i, k, n;


    /* Assume we have nothing */
    C_WIPE(&kind_have, MAX_K_IDX, byte);
    
    /* Assume we need nothing */
    C_WIPE(&kind_need, MAX_K_IDX, byte);


    /* Count "amount" of each item kind in pack */
    for (i = 0; i < INVEN_PACK; i++) {

	auto_item *item = &auto_items[i];

	/* Notice end of inventory */
	if (!item->iqty) break;

	/* Obtain quantity */
	n = kind_have[item->kind] + item->iqty;
	
	/* Maintain count (max out at 255) */
	kind_have[item->kind] = ((n < 255) ? n : 255);
    }
	

    /* Choose a missile type */
    if (TRUE) {
    
	/* Access the bow (if any) */
	auto_item *worn = &auto_items[INVEN_BOW];

	/* Default ammo */
	kind_missile = kind_missile_shot;
	
	/* Access the "proper" ammo kind (ignore "seeker" ammo) */
	if (worn->sval == SV_SHORT_BOW) kind_missile = kind_missile_arrow;
	if (worn->sval == SV_LONG_BOW)  kind_missile = kind_missile_arrow;
	if (worn->sval == SV_LIGHT_XBOW) kind_missile = kind_missile_bolt;
	if (worn->sval == SV_HEAVY_XBOW) kind_missile = kind_missile_bolt;
    }


    /* Collect food */
    kind_need[kind_food_ration] = 30;
    

    /* Collect Flasks for lanterns */
    if (auto_items[INVEN_LITE].kind == kind_lantern) {
	kind_need[kind_flask] = 30;
    }


    /* Collect scrolls of identify */
    kind_need[kind_scroll_identify] = 40;

    /* Collect scrolls of teleport */
    kind_need[kind_scroll_teleport] = 20;

    /* Collect scrolls of recall */
    kind_need[kind_scroll_recall] = 5;


    /* Collect potions of cure critical wounds */
    /* EAW -- take # healing into account */
    /* MJC -- other heals too */
    if (borg_count_healing() > 10)
	kind_need[kind_potion_critical] = 10;
    else
	kind_need[kind_potion_critical] = 20;

    /* Collect potions of cure serious wounds */
    kind_need[kind_potion_serious] = 10;

    /* EAW -- Collect potions of healing */
    kind_need[kind_potion_healing] = 20;

    /* EAW -- Collect potions of speed */
    kind_need[kind_potion_speed] = 15;

    /* MJC -- Collect really cool potions */ /* EAW -- not for warriors */
    if (auto_pclass != PCLASS_WARRIOR)
	kind_need[kind_potion_restore_mana] = 10;
    kind_need[kind_potion_star_healing] = 5;
    kind_need[kind_potion_life] = 5;

    /* Desire Stat Potions (if useful) */
    kind_need[kind_potion_add_str] = (do_add_str) ? 1 : 0;
    kind_need[kind_potion_add_int] = (do_add_int) ? 1 : 0;
    kind_need[kind_potion_add_wis] = (do_add_wis) ? 1 : 0;
    kind_need[kind_potion_add_dex] = (do_add_dex) ? 1 : 0;
    kind_need[kind_potion_add_con] = (do_add_con) ? 1 : 0;
    kind_need[kind_potion_add_chr] = (do_add_chr) ? 1 : 0;

    /* Desire Stat Restoration Potions (if needed) */
    kind_need[kind_potion_fix_str] = (do_fix_str) ? 1 : 0;
    kind_need[kind_potion_fix_int] = (do_fix_int) ? 1 : 0;
    kind_need[kind_potion_fix_wis] = (do_fix_wis) ? 1 : 0;
    kind_need[kind_potion_fix_dex] = (do_fix_dex) ? 1 : 0;
    kind_need[kind_potion_fix_con] = (do_fix_con) ? 1 : 0;
    kind_need[kind_potion_fix_chr] = (do_fix_chr) ? 1 : 0;


    /* Desire Experience Restoration Potions (if needed) */
    kind_need[kind_potion_fix_exp] = (do_fix_exp) ? 1 : 0;

#ifdef FRITS
    /* Spellcasters need their books */
    if (auto_sclass==SCLASS_MAGE) {
       /* EAW -- seperate out higher books, just 1 needed */
       for (i=0;i<4;i++)
	  kind_need[kind_magic_books[i]] = 2;
       while (i < 9) { 
	  kind_need[kind_magic_books[i]] = 1;
	  i++;
       }
    }
    if (auto_sclass==SCLASS_PRIEST) {
       for (i=0;i<4;i++)
	  kind_need[kind_prayer_books[i]] = 2;
       while (i < 9) {
	  kind_need[kind_prayer_books[i]] = 1;
	  i++;
       }
    }
#endif /* FRITS */

    /* Look for equipment that needs enchanting */
    for (i = INVEN_WIELD; i <= INVEN_FEET; i++) {

	auto_item *item = &auto_items[i];

	/* Skip non-items */
	if (!item->iqty) continue;

	/* Enchant all armour */
	if (borg_item_is_armour(item) && (item->to_a < enchant_to) &&
	    item->able) {
	kind_need[kind_enchant_to_ac] += (enchant_to - item->to_a);
	}

	/* Enchant all weapons (to damage) */
	if (borg_item_is_weapon(item) && (item->to_d < enchant_to) &&
	    item->able) {
	    kind_need[kind_enchant_to_dam] += (enchant_to - item->to_d);
	}

	/* Enchant all weapons (to hit) */
	if (borg_item_is_weapon(item) && (item->to_h < enchant_to) &&
	    item->able) {
	    kind_need[kind_enchant_to_hit] += (enchant_to - item->to_h);
	}
    }


    /* Mega-Hack -- Assume "average" equals "known" */
    for (i = 0; i < INVEN_TOTAL; i++) {

	auto_item *item = &auto_items[i];

	/* Skip "empty" items */
	if (!item->iqty) continue;

	/* Skip "known" items */
	if (item->able) continue;
	
	/* Assume "average" items are "known" */
	if (streq(item->note, "{average}")) item->able = TRUE;
    }



    /* Analyze the inventory */
    for (i = 0; i < INVEN_PACK; i++) {

	auto_item *item = &auto_items[i];

	/* Notice end of inventory */
	if (!item->iqty) break;

	/* Decide what to do with it */
	(void)borg_notice_aux(item);
    }
}



/*
 * Look at the screen and update the borg
 *
 * Uses the "panel" info (w_x, w_y) obtained earlier
 *
 * Note that the "c_t" variable corresponds *roughly* to player turns,
 * except that resting and "repeated" commands count as a single turn,
 * and "free" moves (including "illegal" moves, such as attempted moves
 * into walls, or tunneling into monsters) are counted as turns.
 */
static void borg_update()
{
    int n, x, y, dx, dy, lev = auto_depth;

    auto_grid *ag;
    auto_room *ar;

    byte t_a;

    cptr s;

    char buf[128];

    byte old_attr[SCREEN_HGT][SCREEN_WID];
    char old_char[SCREEN_HGT][SCREEN_WID];


    /* Increase the "time" */
    c_t++;


    /* Clear all the "state flags" */
    do_weak = do_hungry = FALSE;
    do_blind = do_confused = do_afraid = do_poisoned = FALSE;
    do_add_str = do_add_int = do_add_wis = FALSE;
    do_add_dex = do_add_con = do_add_chr = FALSE;
    do_fix_str = do_fix_int = do_fix_wis = FALSE;
    do_fix_dex = do_fix_con = do_fix_chr = FALSE;
    do_fix_exp = FALSE; do_fix_lev = FALSE; /* EAW -- seperate for level */


    /* Extract current level */
    if (0 == borg_what_text(6, ROW_LEVEL, -6, &t_a, buf)) {
	auto_level = atoi(buf);
    }

    /* Extract current hitpoints */
    if (0 == borg_what_text(6, ROW_CURHP, -6, &t_a, buf)) {
	auto_curhp = atoi(buf);
    }

    /* Extract maximum hitpoints */
    if (0 == borg_what_text(6, ROW_MAXHP, -6, &t_a, buf)) {
	auto_maxhp = atoi(buf);
    }
    /* Extract maximum hitpoints */
    if (0 == borg_what_text(6, ROW_MANA, -6, &t_a, buf)) {
	mana_color = t_a;
    }


    /* Extract current gold */
    if (0 == borg_what_text(COL_GOLD, ROW_GOLD, -9, &t_a, buf)) {
	auto_gold = atol(buf);
    }



    /* Check for hunger */
    if (0 == borg_what_text(COL_HUNGRY, ROW_HUNGRY, 6, &t_a, buf)) {
	if (streq(buf, "Hungry")) do_hungry = TRUE;
	if (streq(buf, "Weak  ")) do_weak = TRUE;
    }

    /* Check for blind */
    if (0 == borg_what_text(COL_BLIND, ROW_HUNGRY, 5, &t_a, buf)) {
	if (streq(buf, "Blind")) do_blind = TRUE;
    }

    /* Check for confused */
    if (0 == borg_what_text(COL_CONFUSED, ROW_HUNGRY, 8, &t_a, buf)) {
	if (streq(buf, "Confused")) do_confused = TRUE;
    }

    /* Check for afraid */
    if (0 == borg_what_text(COL_AFRAID, ROW_HUNGRY, 6, &t_a, buf)) {
	if (streq(buf, "Afraid")) do_afraid = TRUE;
    }

    /* Check for poisoned */
    if (0 == borg_what_text(COL_POISONED, ROW_HUNGRY, 8, &t_a, buf)) {
	if (streq(buf, "Poisoned")) do_poisoned = TRUE;
    }
    
    /* EAW -- let's check the screen for study */
    if (0 == borg_what_text(COL_STUDY, ROW_HUNGRY, 5, &t_a, buf)) {
	if (streq(buf, "Study")) do_gain_spells = TRUE;
    }
    
    /* Obtain actual stats */
    if (0 == borg_what_text(COL_STAT, ROW_STAT+0, 6, &t_a, buf)) {
	if (buf[5] == '*') auto_stat_str = 18 + 220;
	else if (buf[2] == '/') auto_stat_str = 18 + atoi(buf+3);
	else if (buf[3] == '/') auto_stat_str = 18 + atoi(buf+4);
	else auto_stat_str = atoi(buf);
    }
    /* EAW -- keep track of old int */
    if (0 == borg_what_text(COL_STAT, ROW_STAT+1, 6, &t_a, buf)) {
	if (buf[5] == '*') auto_stat_int = 18 + 220;
	else if (buf[2] == '/') auto_stat_int = 18 + atoi(buf+3);
	else if (buf[3] == '/') auto_stat_int = 18 + atoi(buf+4);
	else auto_stat_int = atoi(buf);
    }
    /* EAW -- keep track of old wis */
    if (0 == borg_what_text(COL_STAT, ROW_STAT+2, 6, &t_a, buf)) {
	if (buf[5] == '*') auto_stat_wis = 18 + 220;
	else if (buf[2] == '/') auto_stat_wis = 18 + atoi(buf+3);
	else if (buf[3] == '/') auto_stat_wis = 18 + atoi(buf+4);
	else auto_stat_wis = atoi(buf);
    }
    if (0 == borg_what_text(COL_STAT, ROW_STAT+3, 6, &t_a, buf)) {
	if (buf[5] == '*') auto_stat_dex = 18 + 220;
	else if (buf[2] == '/') auto_stat_dex = 18 + atoi(buf+3);
	else if (buf[3] == '/') auto_stat_dex = 18 + atoi(buf+4);
	else auto_stat_dex = atoi(buf);
    }
    if (0 == borg_what_text(COL_STAT, ROW_STAT+4, 6, &t_a, buf)) {
	if (buf[5] == '*') auto_stat_con = 18 + 220;
	else if (buf[2] == '/') auto_stat_con = 18 + atoi(buf+3);
	else if (buf[3] == '/') auto_stat_con = 18 + atoi(buf+4);
	else auto_stat_con = atoi(buf);
    }
    if (0 == borg_what_text(COL_STAT, ROW_STAT+5, 6, &t_a, buf)) {
	if (buf[5] == '*') auto_stat_chr = 18 + 220;
	else if (buf[2] == '/') auto_stat_chr = 18 + atoi(buf+3);
	else if (buf[3] == '/') auto_stat_chr = 18 + atoi(buf+4);
	else auto_stat_chr = atoi(buf);
    }

    /* Check for non-maximal stats */
    /* MJC -- added cheat */
    /* Not cheating badly because I could write a routine, but why? */
    /* EAW -- added in % 10 test to cover item bonuses */
#ifndef CHEAT_BASE_STATS
    if ((auto_stat_str < 118) ||
	(auto_stat_str - 18) % 10 != 0) do_add_str = TRUE;
    if ((auto_stat_int < 118) ||
	(auto_stat_int - 18) % 10 != 0) do_add_int = TRUE;
    if ((auto_stat_wis < 118) || 
	(auto_stat_wis - 18) % 10 != 0) do_add_wis = TRUE;
    if ((auto_stat_dex < 118) ||
	(auto_stat_dex - 18) % 10 != 0) do_add_dex = TRUE;
    if ((auto_stat_con < 118) ||
	(auto_stat_con - 18) % 10 != 0) do_add_con = TRUE;
    if ((auto_stat_chr < 118) ||
	(auto_stat_chr - 18) % 10 != 0) do_add_chr = TRUE;
#else
    if (p_ptr->cur_stat[A_STR] < 118) do_add_str = TRUE;
    if (p_ptr->cur_stat[A_INT] < 118) do_add_int = TRUE;
    if (p_ptr->cur_stat[A_WIS] < 118) do_add_wis = TRUE;
    if (p_ptr->cur_stat[A_DEX] < 118) do_add_dex = TRUE;
    if (p_ptr->cur_stat[A_CON] < 118) do_add_con = TRUE;
    if (p_ptr->cur_stat[A_CHR] < 118) do_add_chr = TRUE;
#endif

    /* Check for drained stats */
    if (0 == borg_what_text(0, ROW_STAT+0, 3, &t_a, buf)) {
	if (islower(buf[2])) do_fix_str = TRUE;
    }
    if (0 == borg_what_text(0, ROW_STAT+1, 3, &t_a, buf)) {
	if (islower(buf[2])) do_fix_int = TRUE;
    }
    if (0 == borg_what_text(0, ROW_STAT+2, 3, &t_a, buf)) {
	if (islower(buf[2])) do_fix_wis = TRUE;
    }
    if (0 == borg_what_text(0, ROW_STAT+3, 3, &t_a, buf)) {
	if (islower(buf[2])) do_fix_dex = TRUE;
    }
    if (0 == borg_what_text(0, ROW_STAT+4, 3, &t_a, buf)) {
	if (islower(buf[2])) do_fix_con = TRUE;
    }
    if (0 == borg_what_text(0, ROW_STAT+5, 3, &t_a, buf)) {
	if (islower(buf[2])) do_fix_chr = TRUE;
    }

    /* Check for drained experience */ /* EAW -- drained level too */
    if (0 == borg_what_text(0, ROW_EXP, 3, &t_a, buf)) {
	if (islower(buf[2])) {
    
		/* Check for drained experience */
		if (0 == borg_what_text(0, ROW_EXP - 1, 3, &t_a, buf)) {
			if (islower(buf[2])) {
				do_fix_lev = TRUE;
				do_force_up = TRUE;
			}
		}
		do_fix_exp = TRUE;
	}
    }

    /* Extract the "current dungeon level" */
    if (0 == borg_what_text(70, 23, -7, &t_a, buf)) {
	for (s = buf; *s && !isdigit(*s); s++);
	lev = atoi(s);
    }

#ifdef FRITS
    /* Extract auto_pclass */
    if (0==borg_what_text(0,2,-10,&t_a,buf)) {
       if (!strncmp(buf,"Warrior",7))
       {
	  auto_pclass=PCLASS_WARRIOR;
	  auto_sclass=SCLASS_NONE;
       } else if (!strncmp(buf,"Mage",4))
       {
	  auto_pclass=PCLASS_MAGE;
	  auto_sclass=SCLASS_MAGE;
       } else if (!strncmp(buf,"Priest",6))
       {
	  auto_pclass=PCLASS_PRIEST;
	  auto_sclass=SCLASS_PRIEST;
       } else if (!strncmp(buf,"Rogue",5))
       {
	  auto_pclass=PCLASS_ROGUE;
	  auto_sclass=SCLASS_MAGE;
       } else if (!strncmp(buf,"Ranger",6))
       {
	  auto_pclass=PCLASS_RANGER;
	  auto_sclass=SCLASS_MAGE;
       } else if (!strncmp(buf,"Paladin",7))
       {
	  auto_pclass=PCLASS_PALADIN;
	  auto_sclass=SCLASS_PRIEST;
       } 
    }
#endif /* FRITS */

    /* Notice changes in the level */
    if (auto_depth != lev) {
    
	/* EAW -- reset flag for lighting room */
	room_was_lit = FALSE;

	/* EAW -- flag for forcing him to go back up if he was in trouble */
	do_force_up = FALSE;
	do_was_almost_dead = FALSE;

	/* EAW -- Hack -- always browse books on new level, may have picked up
			  missing ones and arrays need to be updated */
	do_browse_books = TRUE;
			  
	/* Restart the clock */
	c_t = 10000L;

	/* Start a new level */
	auto_began = c_t;

	/* Shocking */
	auto_shock = c_t;

	/* No goal yet */
	goal = 0;

	/* Do not use any stairs */
	stair_less = stair_more = FALSE;

	/* Hack -- cannot rise past town */
	if (!lev) goal_rising = FALSE;

	/* Hack -- town is "boring" */
	if (!lev) attention = 0L;

	/* No known grids yet */
	count_floor = count_less = count_more = 0;

	/* Nothing to chase yet */
	count_kill = count_take = 0;

	/* No word of recall yet */
	auto_recall = 0L;

	/* Nothing bought yet */
	last_visit = 0;

	/* Wipe the old "map" arrays */
	borg_forget_map();

	/* Save the new level */
	auto_depth = lev;

	/* Hack -- Clear the key buffer */
	borg_flush();

	/* Hack -- Verify options */
	borg_play_options();
    }
  
#ifdef FRITS
    /* Extract current manapoints */
    if (0 == borg_what_text(6, ROW_MANA, -6, &t_a, buf)) {
	auto_curmana = atoi(buf);
    }
#endif /* FRITS */

    /* Memorize the "current" (66x22 grid) map sector */
    for (dy = 0; dy < SCREEN_HGT; dy++) {
	for (dx = 0; dx < SCREEN_WID; dx++) {

	    /* Obtain the map location */
	    x = w_x + dx;
	    y = w_y + dy;

	    /* Get the auto_grid */
	    ag = grid(x, y);

	    /* Save the current knowledge */
	    old_attr[dy][dx] = ag->o_a;
	    old_char[dy][dx] = ag->o_c;
	}
    }


    /* Analyze the map */
    borg_update_map();

    /* Paranoia -- catch failure */
    if (!pg || !auto_active) return;

    /* Update the view */
    borg_update_view();



    /* Make "fake" rooms for all viewable unknown grids */
    for (n = 0; n < view_n; n++) {

	/* Access the location */
	y = view_y[n];
	x = view_x[n];

	/* Access the grid */
	ag = grid(x,y);

	/* Skip walls */
	if (ag->info & BORG_WALL) continue;

	/* Skip "known" grids */
	if (ag->o_c != ' ') continue;

	/* Make "fake" rooms as needed */
	if (!ag->room) {

	    auto_room *ar;

	    /* Get a new room */
	    ar = borg_free_room();

	    /* Initialize the room */
	    ar->x = ar->x1 = ar->x2 = x;
	    ar->y = ar->y1 = ar->y2 = y;

	    /* Save the room */
	    ag->room = ar->self;
	}
    }


    /* Analyze the current (66x22 grid) map sector */
    for (dy = 0; dy < SCREEN_HGT; dy++) {
	for (dx = 0; dx < SCREEN_WID; dx++) {

	    /* Obtain the map location */
	    x = w_x + dx;
	    y = w_y + dy;

	    /* Get the auto_grid */
	    ag = grid(x, y);

	    /* Skip unknown grids */
	    if (ag->o_c == ' ') continue;

	    /* Notice first "knowledge" */
	    if (old_char[dy][dx] == ' ') {

		/* We are shocked */
		auto_shock = c_t;
	    }

	    /* Count certain "changes" */
	    if (ag->o_c != old_char[dy][dx]) {

		/* Lost old "floor" grids */
		if (old_char[dy][dx] == '.') count_floor--;

		/* Lost old "permanent" landmarks */
		if (old_char[dy][dx] == '<') count_less--;
		if (old_char[dy][dx] == '>') count_more--;

		/* Lost old "temporary" info */
		if (auto_is_kill[(byte)(old_char[dy][dx])]) count_kill--;
		if (auto_is_take[(byte)(old_char[dy][dx])]) count_take--;

		/* Found new "floor" grids */           
		if (ag->o_c == '.') count_floor++;

		/* Found new "permanent" landmarks */
		if (ag->o_c == '<') count_less++;
		if (ag->o_c == '>') count_more++;

		/* Lost old "temporary" info */
		if (auto_is_kill[(byte)(ag->o_c)]) count_kill++;
		if (auto_is_take[(byte)(ag->o_c)]) count_take++;
	    }


	    /* Clear all "broken" rooms */
	    if ((ag->o_c == '#') || (ag->o_c == '%')) {

		/* Clear all rooms containing walls */
		if (ag->room) {

		    /* Clear all rooms containing walls */
		    if (borg_clear_room(x, y)) goal = 0;
		}
	    }

	    /* Create "fake" rooms as needed */
	    else {

		/* Mega-Hack -- super-fake rooms */
		if (!ag->room) {

		    /* Acquire a new room */
		    ar = borg_free_room();

		    /* Initialize the room */
		    ar->x = ar->x1 = ar->x2 = x;
		    ar->y = ar->y1 = ar->y2 = y;

		    /* Save the room */
		    ag->room = ar->self;
		}       
	    }


	    /* Skip non-viewable grids */
	    if (!(ag->info & BORG_VIEW)) continue;

	    /* Hack -- Notice all (viewable) changes */
	    if ((ag->o_c != old_char[dy][dx]) ||
		(ag->o_a != old_attr[dy][dx])) {

		/* Important -- Cancel goals */
		goal = 0;
	    }
	}
    }   


    /* Paranoia -- require a self room */
    if (!pg->room) {

	/* Acquire a new room */
	ar = borg_free_room();

	/* Initialize the room */
	ar->x = ar->x1 = ar->x2 = c_x;
	ar->y = ar->y1 = ar->y2 = c_y;

	/* Save the room */
	pg->room = ar->self;
    }

    /* Build a "bigger" room around the player */
    if (borg_build_room(c_x, c_y)) goal = 0;

    /* Mark all the "containing rooms" as visited. */
    for (ar = room(1,c_x,c_y); ar; ar = room(0,0,0)) {

	/* Note the visit */
	ar->when = c_t;
    }

    /* Hack -- Count visits to this grid */
    /* if (pg->visits < 100) pg->visits++; */
}

/*
 * Attempt to eat something edible
 * Slime Molds and Elvish Waybread
 */
static bool borg_eat_food_any(void)
{
    int i;

    /* MJC -- try scrolls of satisfy hunger */
    if (borg_action('r', kind_scroll_satisfy_hunger)) return (TRUE);

    /* Scan the inventory */
    for (i = 0; i < INVEN_PACK; i++) {

	auto_item *item = &auto_items[i];

	/* Notice end of inventory */
	if (!item->iqty) break;

	/* Skip unknown food */
	if (!item->kind) continue;

	/* Skip normal food rations */
	if (item->kind == kind_food_ration) continue;

	/* Skip non-food */
	if (item->tval != TV_FOOD) continue;

	/* Eat "acceptable" food */
	if (item->sval >= SV_FOOD_MIN_FOOD) {

	    /* Eat something of that type */
	    if (borg_action('E', item->kind)) return (TRUE);
	}
    }

    /* Nothing */
    return (FALSE);
}

/*
 * Read a scroll of recall if not in town and allowed
 */
static bool borg_recall(void)
{
    /* EAW -- Sometimes in town */
    if (auto_depth == 0 && read_in_town == FALSE) return (FALSE);

    /* Only read recall once per level */
    if (auto_recall) return (FALSE);

    /* Cannot read any scrolls */
    if (do_blind || do_confused) return (FALSE);

    /* Try to read a scroll of recall */
    if (borg_action('r', kind_scroll_recall)) {

	/* Remember when */
	auto_recall = c_t;

	/* MJC - save game */
	borg_save_game();

	/* Success */
	return (TRUE);
    }

    /* Nothing */
    return (FALSE);
}



/*
 * Count the monsters touching a location
 * Assumes the location is not an outer wall
 */
static int borg_count_monsters(int x0, int y0)
{
    int i, d, x, y, n = 0;

    auto_grid *ag;

    /* Look around */
    for (i = 0; i < 8; i++) {

	/* Access the grid */
	d = ddd[i];
	x = x0 + ddx[d];
	y = y0 + ddy[d];
	ag = grid(x, y);

	/* Look for monsters (efficiently) */
	if (auto_is_kill[(byte)(ag->o_c)]) n++;
    }

    /* Return the count */
    return (n);
}



/* EAW --
 * Count the non-walls for light area determination
 * Assumes the location is not an outer wall
 */
static int borg_count_non_walls(int x0, int y0)
{
    int i, d, x, y, n = 0;

    auto_grid *ag;

    /* Look around */
    for (i = 0; i < 8; i++) {

	/* Access the grid */
	d = ddd[i];
	x = x0 + ddx[d];
	y = y0 + ddy[d];
	ag = grid(x, y);

	/* Look for non walls */
	if (ag->o_c != '#' && ag->o_c != '%' && ag->o_c != ' ') n++;
    }

    /* Return the count */
    return (n);
}



/* EAW -- light a room */
static bool borg_light_room(void) {

    auto_item *item;
    char desc[80];
    long time;

    if (borg_count_non_walls(c_x, c_y) >= 6) { 
	if (!room_was_lit && auto_depth) {
		item = &auto_items[INVEN_LITE];
		
		if (item->name1) {
		
		    if (item->name1 == ART_GALADRIEL) time = 18;
		    else if (item->name1 == ART_ELENDIL) time = 95;
		    else if (item->name1 == ART_THRAIN) time = 190;
		    
		    if (*item->desc != 'a' &&
			c_t - last_artifact_light > time) {
			borg_keypress('A');
			borg_keypress('f');
			last_artifact_light = c_t;
			if (item->name1 != ART_ELENDIL) room_was_lit = TRUE; 
			return (TRUE);
		    }
		}
		if (borg_cast_light_area_spell()) {
			room_was_lit = TRUE;
			return (TRUE);
		}
	}
    }
return (FALSE);
}



/*
 * Use things in a useful manner
 * Attempt healing, refueling, eating, etc.
 */
static bool borg_use_things(void)
{
    auto_item *item = &auto_items[INVEN_LITE];
    
    /* EAW -- stuff for spells */
    char book, spell;

    /* Panic -- avoid possible death */
    if (panic_death &&
       (auto_curhp < 100) &&
       (auto_curhp < auto_maxhp / 4)) {
       
       /* EAW -- try to cope with it, mainly for priests/paladins */
       do_force_up = TRUE;
       do_was_almost_dead = TRUE;
       if (!(do_blind | do_confused) && 
	 !(!borg_count_monsters(c_x, c_y) || do_poisoned)) {
	     if (borg_action('r', kind_scroll_teleport)) return (TRUE); 
       }
       if (borg_cast_teleport_spell()) {
	   if (!borg_do_potion_heal()) { 
	       if (auto_sclass == SCLASS_PRIEST) borg_cast_spell('d','c');
	    /*   else {
		   borg_keypress('R');
		   borg_keypress('*');
		   borg_keypress('\n');
	       }   */
	   }
	   return (TRUE);
       }
       if (borg_do_potion_heal() ||
	   (auto_sclass == SCLASS_PRIEST && borg_cast_spell('d','c')))
	   return (TRUE);

       borg_oops("Almost dead.");
       return (TRUE);
    }

    /* Hack -- attempt to escape */ /* EAW -- factor in healing */
    if ((auto_curhp < auto_maxhp / 2) && (rand_int(4) == 0)) {
	if ((kind_have[kind_potion_critical] < 5) &&
	     borg_count_healing() < 3 &&
	     borg_recall()) return (TRUE);
    }
    
    /* EAW -- XXX XXX XXX Hack -- attempt to teleport to safety */
    if (borg_count_monsters(c_x, c_y) && auto_curhp < auto_maxhp / 3) {

	/* Read scrolls of teleport (low failure rate) */
	if (borg_action('r', kind_scroll_teleport)) return (TRUE);

	/* Mega-Hack -- Use (charged) staffs of teleport */
	if (borg_action_pval('u', kind_staff_teleport)) return (TRUE);
    }

    /* EAW -- teleport/portal to be cautious, continue on */
    if (borg_count_monsters(c_x, c_y) && auto_curhp < auto_maxhp / 2) {
	if (auto_sclass == SCLASS_MAGE && !borg_cast_spell('b','f'))
		borg_cast_spell('a','c');
	if (auto_sclass == SCLASS_PRIEST) borg_cast_spell('b','b');
    }

    /* MJC -- Hack -- Need *BIG* heal */
    if ((auto_curhp < auto_maxhp / 4) && (auto_maxhp - auto_curhp >= 400)) {
	/* Try big healing potions */
	if (borg_do_major_potion_heal()) return (TRUE);
	/* Try priest healing spells */
	if (auto_sclass == SCLASS_PRIEST && borg_cast_spell('g','c')) 
		return (TRUE);
    }
    
    /* EAW -- Hack -- Try a healing potion */
    if (auto_curhp < auto_maxhp / 3) {
	if (borg_do_potion_heal()) return (TRUE);
    }

    /* EAW -- cast healing spell if auto_curhp < 1/2 */
    if (auto_curhp < auto_maxhp / 2 || auto_maxhp - auto_curhp >= 300) {
	if (auto_sclass == SCLASS_PRIEST && borg_cast_spell('d','c'))
		return (TRUE);
    }

    /* EAW -- Try to speed up, not until last one wears off */
    if (auto_curhp < 3 * auto_maxhp / 4 && c_t - last_speed >= 30) {
	if (borg_action('q', kind_potion_speed)) {
		last_speed = c_t;
		return (TRUE);
	}
    }

    /* Hack -- heal when wounded */
    if ((auto_curhp < auto_maxhp / 2) && (rand_int(4) == 0)) {
	if (borg_action('q', kind_potion_critical)) return (TRUE);
	if (borg_action('q', kind_potion_serious)) return (TRUE);
    }

    /* Hack -- heal when blind/confused */
    if ((do_blind || do_confused) && (rand_int(4) == 0)) {
	if (borg_action('q', kind_potion_serious)) return (TRUE);
	if (borg_action('q', kind_potion_critical)) return (TRUE);
    }

    /* MJC -- use potions of restore mana at 10% */
    /* Cheats to determine maxmana, since not on screen */
    if (auto_curmana < p_ptr->mana / 10) {
	/* Hack -- try not to waste them */
	if ((borg_count_monsters(c_x, c_y) > 0) && (auto_level > 25)) {
	    if (borg_action('q', kind_potion_restore_mana)) return (TRUE);
	}
    }


    /* Eat or abort */
    if (do_hungry || do_weak) {

	/* Attempt to eat something edible */
	if (borg_eat_food_any()) return (TRUE);

#ifdef FRITS
	/* last resort? if all 30 food rations are gone, continuing
	 might not be a wise thing to do.. */
	if ((borg_cast_dinner_spell()==TRUE))
	   return(TRUE);
#endif /* FRITS */
	
	/* Attempt to eat food rations */
	if (borg_action('E', kind_food_ration)) return (TRUE);

	/* Mega-Hack -- Flee to town for food */
	if (borg_recall()) return (TRUE);
    }

    /* Refuel current torch */
    if ((item->kind == kind_torch) && (item->pval < 1000)) {

	/* Try to wield a lantern */
	if (borg_action('w', kind_lantern)) return (TRUE);

	/* Try to refuel the torch */
	if (borg_action('F', kind_torch)) return (TRUE);
    }


    /* Refuel current lantern */
    if ((item->kind == kind_lantern) && (item->pval < 5000)) {

	/* Try to refill the lantern */
	if (borg_action('F', kind_flask)) return (TRUE);
    }

    /* EAW -- notice level changes, check for forgotten ones */
    if (auto_level != old_level) {
	/* Turn off magic until forgotten spells are checked */
	if (auto_level < old_level) {
		for (book = 'a'; book <= 'i'; book++) {
			for (spell = 'a'; spell <= 'i'; spell++) {
				spells_known[book - 'a'][spell - 'a'] = FALSE;
				spells_untried[book - 'a'][spell - 'a'] = FALSE;
			}
		}
	}
	old_level = auto_level;  
	do_browse_books = TRUE;
	borg_can_gain_spell();
	known_spells = 0;
    }

    /* EAW -- check spells when spell stat changes, learn new, forget, etc. */
    if (auto_sclass == SCLASS_MAGE &&
	auto_stat_int != old_auto_stat_int) {
	  
	  /* Turn off magic until forgotten spells are checked */
	  if (auto_stat_int < old_auto_stat_int) {
		for (book = 'a'; book <= 'i'; book++) {
			for (spell = 'a'; spell <= 'i'; spell++) {
				spells_known[book - 'a'][spell - 'a'] = FALSE;
				spells_untried[book - 'a'][spell - 'a'] = FALSE;  
			}
		}
	  }
		
		old_auto_stat_int = auto_stat_int;
		do_browse_books = TRUE;
		borg_can_gain_spell();
		known_spells = 0;
    }
    if (auto_sclass == SCLASS_PRIEST &&
	auto_stat_wis != old_auto_stat_wis) {
	  
	  /* Turn off magic until forgotten spells */
	  if (auto_stat_wis < old_auto_stat_wis) {
		for (book = 'a'; book <= 'i'; book++) {
			for (spell = 'a'; spell <= 'i'; spell++) {
				spells_known[book - 'a'][spell - 'a'] = FALSE;
				spells_untried[book - 'a'][spell - 'a'] = FALSE;  
			}
		}
	  }
	  
		old_auto_stat_wis = auto_stat_wis;
		do_browse_books = TRUE;
		borg_can_gain_spell();
		known_spells = 0;
    }

    /* Uh oh, last scroll.  Better get back to town! */
    if (kind_have[kind_scroll_recall] == 1 && auto_depth >= 5) borg_recall(); 
    
    /* Nothing to do */
    return (FALSE);
}

					  
/*
 * Use things in a useful, but non-essential, manner
 */
static bool borg_use_others(void)
{
    int i, j, b, a;
    
    int num_armour = 0, num_weapon = 0;

    int num_damaged_stats = 0;
    
    /* EAW -- Stuff for casting untried for exp */
    char book, spell;
    
    /* EAW -- light a room, hopefully */
    if (borg_light_room()) return (TRUE);    

#ifdef FRITS
    /* suppose we're a priest/paladin and out of restore potions */
    /* this routine does nothing if not needed */
    /* otherwise, tries to cure poison, fear, stat drain etc. */
    /* maybe this isn't the right place for it though.. */
    if (borg_cast_healing_spell()==TRUE) return(TRUE);
#endif /* FRITS */
    
    /* Quaff experience restoration potion */
    if (do_fix_exp && borg_action('q', kind_potion_fix_exp)) return (TRUE);


    /* MJC -- count damaged stats */
    if (do_fix_str) num_damaged_stats++;
    if (do_fix_int) num_damaged_stats++;
    if (do_fix_wis) num_damaged_stats++;
    if (do_fix_dex) num_damaged_stats++;
    if (do_fix_con) num_damaged_stats++;
    if (do_fix_chr) num_damaged_stats++;

    /* MJC -- if >=3 damaged, eat mushroom of restoring */
    if (num_damaged_stats >= 3) {
	if (borg_action('E', kind_mushroom_restoring)) return (TRUE);
    }
    
    /* Quaff stat restoration potions */
    /* MJC -- mushroom of restore con too */
    if (do_fix_con && borg_action('E', kind_mushroom_fix_con)) return (TRUE);
    if (do_fix_str && borg_action('q', kind_potion_fix_str)) return (TRUE);
    if (do_fix_int && borg_action('q', kind_potion_fix_int)) return (TRUE);
    if (do_fix_wis && borg_action('q', kind_potion_fix_wis)) return (TRUE);
    if (do_fix_dex && borg_action('q', kind_potion_fix_dex)) return (TRUE);
    if (do_fix_con && borg_action('q', kind_potion_fix_con)) return (TRUE);
    if (do_fix_chr && borg_action('q', kind_potion_fix_chr)) return (TRUE);


    /* Quaff "useful" potions/scrolls */
    for (i = 0; i < INVEN_PACK; i++) {

	auto_item *item = &auto_items[i];

	/* Notice end of inventory */
	if (!item->iqty) break;

	/* MJC - different list in town */
	if (auto_depth == 0) {
	    for (j = 0; kind_force_potions_town[j]; j++) {
		/* Skip non-matches */
		if (item->kind != kind_force_potions_town[j]) continue;

		/* Try quaffing each potion */
		/* EAW -- put in a few ESCAPES for *Enlightenment* */
		if (borg_action('q', item->kind)) {
		    borg_keypress(ESCAPE);
		    borg_keypress(ESCAPE);
		    borg_keypress(ESCAPE);
		    return (TRUE);
		}
	    }
	}

	
	/* Check list of potions */
	else {
	    for (j = 0; kind_force_potions[j]; j++) {

		/* Skip non-matches */
		if (item->kind != kind_force_potions[j]) continue;

		/* Try quaffing each potion */
		/* EAW -- put in a few ESCAPES for *Enlightenment* */
		if (borg_action('q', item->kind)) {
		    borg_keypress(ESCAPE);
		    borg_keypress(ESCAPE);
		    borg_keypress(ESCAPE);
		    return (TRUE);
		}
	    }
	}

	/* Hack -- check Blind/Confused */
	if (do_blind || do_confused) continue;

	/* MJC - different list in town */

	if (auto_depth == 0) {
	    for (j = 0; kind_force_scrolls_town[j]; j++) {

		/* Skip non-matches */
		if (item->kind != kind_force_scrolls_town[j]) continue;

		/* Try reading each scroll */
		if (borg_action('r', item->kind)) return (TRUE);
	    }
	}

	/* Check list of scrolls */
	else {
	    for (j = 0; kind_force_scrolls[j]; j++) {

		/* Skip non-matches */
		if (item->kind != kind_force_scrolls[j]) continue;

		/* Try reading each scroll */
		if (borg_action('r', item->kind)) return (TRUE);
	    }
	}
    }

#ifdef FRITS
    /* this seems like a good time to cast haste, protection etc. spells */
    if (rand_int(20)==0) {
    if (borg_cast_preventive_spell()==TRUE) return(TRUE);
    }
#endif /* FRITS */

#ifdef FRITS
	/* find some traps/doors */
    /* MJC - don't waste time in town */
    if ((rand_int(10) == 0) && (auto_depth > 0)) {
       if (borg_cast_detection_spell()==TRUE) 
	  return(TRUE);
    }
#endif /* FRITS */

    /* Hack -- blind/confused -- no scrolls */
    if (do_blind || do_confused) return (FALSE);

    /* EAW -- cast untried for exp */  
    if (rand_int(100) == 0 && !(do_blind | do_confused)) {
      for (book = 'a'; book <= 'i'; book++) {
	for (spell = 'a'; spell <= 'i'; spell++) {
		if (mana_color == 13 &&
		    spells_untried[book - 'a'][spell - 'a'] == TRUE) {
			if (borg_cast_spell(book, spell)) {
				borg_keypress('*');
				borg_keypress('t');
				borg_keypress(ESCAPE);
				borg_note ("Activating borg_think_browse()");
				do_browse_books = TRUE;
				return(TRUE);
			}
		}
	}
      }
    }

    /* No enchantment scrolls */
    i = 0;

    /* Count enchantment scrolls */
    i += kind_have[kind_enchant_to_ac];
    i += kind_have[kind_enchant_to_hit];
    i += kind_have[kind_enchant_to_dam];

    /* No enchantment scrolls */ /* EAW -- take spell into account too */
    if (!i && !(auto_sclass == SCLASS_PRIEST && (borg_can_cast('h','d') ||
		borg_can_cast('h','e')))) return (FALSE);


    /* Mega-Hack -- count armour/weapons in pack (see below) */
    for (i = 0; i < INVEN_PACK; i++) {

	auto_item *item = &auto_items[i];

	/* Notice end of inventory */
	if (!item->iqty) break;

	/* Count armour */
	if (borg_item_is_armour(item)) num_armour++;

	/* Count weapons */
	if (borg_item_is_weapon(item)) num_weapon++;
    }

    /* Look for a weapon that needs enchanting */
    for (b = 0, a = 99, i = INVEN_WIELD; i <= INVEN_BOW; i++) {

	auto_item *item = &auto_items[i];

	/* Skip non-items */
	if (!item->iqty) continue;

	/* Skip non-identified */
	if (!item->able) continue;
	
	/* Find the least enchanted item */
	if (item->to_h > a) continue;

	/* Save the info */
	b = i; a = item->to_h;
    }

    /* Ugly way to keep him from enchanting past 10 very often */
    if (mana_color != 13 || (a > 9 && rand_int(100))) a = 15;

    /* Enchant that item if "possible" */
    if (b && a < 15 && (borg_action('r', kind_enchant_to_hit) ||
	(auto_sclass == SCLASS_PRIEST && borg_cast_spell('h','d')))) {

	/* Choose from equipment */
	if (num_weapon) borg_keypress('/');

	/* Choose that item */
	borg_keypress('a' + b - INVEN_WIELD);

	/* Save his ass in case the spell failed */
	borg_keypress(ESCAPE);

	/* Success */
	return (TRUE);
    }


    /* Look for a weapon that needs enchanting */
    for (b = 0, a = 99, i = INVEN_WIELD; i <= INVEN_BOW; i++) {

	auto_item *item = &auto_items[i];

	/* Skip non-items */
	if (!item->iqty) continue;

	/* Skip non-identified */
	if (!item->able) continue;
	
	/* Find the least enchanted item */
	if (item->to_d > a) continue;

	/* Save the info */
	b = i; a = item->to_d;
    }
    
    /* Ugly way to keep him from enchanting past 10 very often */
    if (mana_color != 13 || (a > 9 && rand_int(100))) a = 15;
    
    if (b && a < 15 && (borg_action('r', kind_enchant_to_dam) ||
	(auto_sclass == SCLASS_PRIEST && borg_cast_spell('h','d')))) {

	/* Choose from equipment */
	if (num_weapon) borg_keypress('/');

	/* Choose that item */
	borg_keypress('a' + b - INVEN_WIELD);
	
	/* Save his ass in case the spell failed */
	borg_keypress(ESCAPE);
	
	/* Success */
	return (TRUE);
    }
    
    /* Look for armor that needs enchanting */
    for (b = 0, a = 99, i = INVEN_BODY; i <= INVEN_FEET; i++) {

	auto_item *item = &auto_items[i];

	/* Skip non-items */
	if (!item->iqty) continue;

	/* Skip non-identified */
	if (!item->able) continue;
	
	/* Find the least enchanted item */
	if (item->to_a > a) continue;

	/* Save the info */
	b = i; a = item->to_a;
    }
    
    /* Ugly way to keep him from enchanting past 10 very often */
    if (mana_color != 13 || (a > 9 && rand_int(100))) a = 15;

    /* Enchant that item if "possible" */
    if (b && a < 15 && (borg_action('r', kind_enchant_to_ac) ||
	(auto_sclass == SCLASS_PRIEST && borg_cast_spell('h','e')))) {

	/* Choose from equipment */
	if (num_armour) borg_keypress('/');

	/* Choose that item */
	borg_keypress('a' + b - INVEN_WIELD);

	/* Save his ass in case the spell failed */
	borg_keypress(ESCAPE);

	/* Success */
	return (TRUE);
    }

    /* EAW -- Look for weapon in inventory that needs enchanting */
    for (b = 0, a = 99, i = 0; i < INVEN_PACK; i++) {

	auto_item *item = &auto_items[i];

	/* Skip non-items */
	if (!item->iqty) continue;

	/* Skip non-identified */
	if (!item->able) continue;

	/* Skip non-weapons */
	if (!borg_item_is_weapon(item)) continue;

	/* Only these are to be done out of town */
	if (auto_depth && item->kind != kind_missile) continue;
				      
	if (item->to_h + item->to_d > a) continue;

	/* Save the info */
	b = i; a = item->to_h + item->to_d;
    }

    /* Ugly way to keep him from enchanting past +10,+10 very often */
    if ((auto_depth && mana_color != 13) ||
	(a > 20 && rand_int(100))) a = 30;

    /* Enchant that item if "possible" */
    if (b && a < 30 && (auto_sclass == SCLASS_PRIEST && borg_cast_spell('h','d'))) {

	/* Choose that item */
	borg_keypress('a' + b);

	/* Save his ass in case the spell failed */
	borg_keypress(ESCAPE);

	/* Success */
	return (TRUE);
    }

    /* EAW -- only do this in town */

    if (auto_depth) return (FALSE);

    /* EAW -- Look for armor in inventory that needs enchanting */
    for (b = 0, a = 99, i = 0; i < INVEN_PACK; i++) {

	auto_item *item = &auto_items[i];

	/* Skip non-items */
	if (!item->iqty) continue;
    
	/* Skip non-identified */
	if (!item->able) continue;

	if (!borg_item_is_armour(item)) continue;
					  
	/* Find the least enchanted item */
	if (item->to_a > a) continue;

	/* Save the info */
	b = i; a = item->to_a;
    }

    /* Ugly way to keep him from enchanting past 10 very often */
    if (a > 9 && rand_int(100)) a = 15;

    /* Enchant that item if "possible" */
    if (b && a < 15 && (auto_sclass == SCLASS_PRIEST &&
	borg_cast_spell('h','e'))) {

	/* Choose that item */
	borg_keypress('a' + b);
	
	/* Save his ass in case the spell failed */
	borg_keypress(ESCAPE);
	
	/* Success */
	return (TRUE);
    }

    /* Nothing to do */
    return (FALSE);
}


/*
 * Destroy everything we know we don't want
 */
static bool borg_throw_junk(void)
{
    int i, j;


    /* Quaff harmless "junk" potions/scrolls */
    for (i = 0; i < INVEN_PACK; i++) {

	auto_item *item = &auto_items[i];

	/* Notice end of inventory */
	if (!item->iqty) break;

	/* Only "discard" junk */
	if (!item->junk) continue;

	/* Check list of "allowable" potions */
	for (j = 0; kind_allow_potions[j]; j++) {

	    /* Skip non-matches */
	    if (item->kind != kind_allow_potions[j]) continue;

	    /* Quaff junk */
	    borg_info(format("Quaffing junk (%s).", item->desc));

	    /* Try quaffing each potion */
	    if (borg_action('q', item->kind)) return (TRUE);
	}

	/* Hack -- check Blind/Confused */
	if (do_blind || do_confused) continue;

	/* Check list of "allowable" scrolls */
	for (j = 0; kind_allow_scrolls[j]; j++) {

	    /* Skip non-matches */
	    if (item->kind != kind_allow_scrolls[j]) continue;

	    /* Read junk */
	    borg_info(format("Reading junk (%s).", item->desc));

	    /* Try reading each scroll */
	    if (borg_action('r', item->kind)) return (TRUE);
	}
    }


    /* Throw away "junk" */
    for (i = 0; i < INVEN_PACK; i++) {

	auto_item *item = &auto_items[i];

	/* Notice end of inventory */
	if (!item->iqty) break;

	/* EAW -- Don't mess with artifacts! */
	if (item->name1 || streq(item->note, "{terrible}")) continue;

	/* Throw junk */
	if (item->junk) {

	    /* Throw away junk */
	    borg_info(format("Trashing junk (%s).", item->desc));

	    /* Throw it at myself */
	    borg_keypress('f');
	    borg_keypress('a' + i);
	    borg_keypress('*');
	    borg_keypress('p');
	    borg_keypress('t');

	    if (streq(item->note, "{cursed}")) {

		/* Save the item description for later checking */
		strcpy(desc_last_junked, item->desc);
	    }

	    /* Did something */
	    return (TRUE);
	}
    }


    /* Nothing to destroy */
    return (FALSE);
}



/*
 * Make sure we have at least one free inventory slot.
 * This will fail if every slot holds "essentials" (food, lite,
 * word of recall, teleport, identify, healing potions, etc) or
 * "holders" (unidentified items).
 */
static bool borg_free_space(void)
{
    int i, k;

    s32b cost, limit = 999999L;

    auto_item *item, *junk;


    /* We have plenty of space */
    if (!auto_items[INVEN_PACK-1].iqty) return (FALSE);


    /* Nothing to junk yet */
    junk = NULL;

    /* Find something to trash */
    for (i = 0; i < INVEN_PACK; i++) {

	item = &auto_items[i];

	/* Stop at end of inventory */
	if (!item->iqty) break;

	/* EAW -- junk missiles if really hard up */
	if (!junk && (item->tval == TV_SHOT ||
	     item->tval == TV_ARROW ||
	     item->tval == TV_BOLT)) {
	     item->cash = TRUE;
	}
	/* Skip non-sell items */
	else if (!item->cash) continue;

	/* Evaluate the slot */
	cost = item_worth(item) * item->iqty;

	/* EAW -- skip artifacts */
	if (item->name1 || streq(item->note, "{terrible}")) continue;

	/* Skip expensive items */
	if (junk && (cost > limit)) continue;

	/* Track cheapest item */
	junk = item;
	limit = cost;
    }

    /* Throw something away */
    if (junk) {

	/* Debug */
	borg_note(format("Junking %ld gold", limit));

	/* Hack -- Mark it as junk */
	junk->junk = TRUE;

	/* Try to throw away the junk */
	if (borg_throw_junk()) return (TRUE);
    }


    /* Mega-Hack -- try to give "feelings" a chance */
    if (rand_int(100) != 0) return (FALSE);
	
    /* Mega-Hack -- get very desperate */
    
    /* EAW -- Head home if can't identify */
    if (!borg_can_cast_identify_spell() && !kind_have[kind_scroll_identify])
	borg_recall();
    
    for (i = 0; i < INVEN_PACK; i++) {

	item = &auto_items[i];

	/* Stop at end of inventory */
	if (!item->iqty) break;

	/* Find the smallest pile of these items */
	k = borg_choose(item->kind);

	/* Do not throw away the best (or only) pile */ 
	if (i == k) continue;

	/* EAW -- Don't chuck really cool stuff, might be just taken off! */
	if (item->name1 || streq(item->note, "{excellent}") || 
	    streq(item->note, "{special}") ||
	    streq(item->note, "{blessed}") ||
	    streq(item->note, "{terrible}")) continue;

	/* EAW -- Don't chuck VERY expensive stuff */
	if (cost >= 100000) continue;
	
	/* Debug */
	borg_note(format("Discarding %s!", item->desc));

	/* Hack -- Mark it as junk */
	item->junk = TRUE;

	/* Try to throw away the junk */
	if (borg_throw_junk()) return (TRUE);   
    }


    /* Oops */
/*    if (panic_stuff) {

	borg_oops("Too much stuff.");
	return (FALSE);
    } */
    
    /* Nothing to junk yet */
    junk = NULL;

    /* Find something to trash */
    for (i = 0; i < INVEN_PACK; i++) {

	item = &auto_items[i];

	/* Stop at end of inventory */
	if (!item->iqty) break;

	/* Hack -- Skip identified items */
	if (item->able) continue;

	/* Evaluate the slot */
	cost = item_worth(item) * item->iqty;
	
	/* EAW -- Don't chuck really cool stuff, might be just taken off! */
	if (item->name1 || streq(item->note, "{excellent}") || 
	    streq(item->note, "{special}") ||
	    streq(item->note, "{blessed}") ||
	    streq(item->note, "{terrible}")) continue;

	/* EAW -- Don't chuck VERY expensive stuff */
	if (cost >= 100000) continue;
	
	/* Skip expensive items */
	if (junk && (cost > limit)) continue;

	/* Track cheapest item */
	junk = item;
	limit = cost;
    }

    /* Throw something away */
    if (junk) {

	/* Debug */
	borg_note(format("Desperately junking %ld+ gold!", limit));

	/* Hack -- Mark it as junk */
	junk->junk = TRUE;

	/* Try to throw away the junk */
	if (borg_throw_junk()) return (TRUE);
    }

    /* Oops */
    borg_oops("Too much stuff.");
    
    /* Failure */
    return (FALSE);
}


/*
 * Count the number of items worth "selling"
 * This determines the choice of stairs.
 */
static int borg_count_sell(void)
{
    int i, k = 0;
    s32b greed, worth;

    /* Calculate "greed" factor */
    greed = auto_gold / 100L;

    /* Throw away "junk" */
    for (i = 0; i < INVEN_PACK; i++) {

	auto_item *item = &auto_items[i];

	/* Skip non-items */
	if (!item->iqty) continue;      

	/* Skip "junk" items */
	if (item->junk) continue;

	/* Skip known "cheap" items */
	if (item->kind && item->cash && item->able) {

	    /* Guess at the item value */
	    worth = item_worth(item) * item->iqty;

	    /* Do not bother with "cheap" items */
	    if (worth < greed) continue;
	}

	/* Skip "average" "cheap" items */
	if (item->kind && item->cash && streq(item->note, "{average}")) {

	    /* Guess at the item value */
	    worth = item_worth(item) * item->iqty;

	    /* Do not bother with "cheap" items */
	    if (worth < greed) continue;
	}

	/* Count remaining items */
	/* EAW -- only count ones you're GOING TO SELL
	   Good if you are carrying around lots of good
	   stuff which you AREN'T going to sell but is keeping you from
	   diving, like books, healing potions, teleport scrolls, etc. */
	if (item->cash && item_worth(item) > greed)

	k++;
    }


    /* Count them */
    return (k);
}




/*
 * Identify items if possible
 *
 * Note that "borg_parse()" will "cancel" the identification if it
 * detects a "You failed..." message.  This is VERY important!!!
 * Otherwise the "identify" might induce bizarre actions by sending
 * the "index" of an item as a command.
 */
static bool borg_test_stuff(void)
{
    int i;


    /* Look for an item to identify */
    for (i = 0; i < INVEN_PACK; i++) {

	/* Notice end of inventory */
	if (!auto_items[i].iqty) break;

	/* Skip tested items */
	if (!auto_items[i].test) continue;

/* EAW -- moved this to be tried first */
#ifdef FRITS
	/* try spells */
	if (borg_cast_identify_spell('a'+i)==TRUE) return(TRUE);
#endif /* FRITS */

	/* Use a Rod of Perceptions or a Staff of Perceptions */
	if (borg_action_pval('z', kind_rod_identify) ||
	    borg_action_pval('u', kind_staff_identify)) {

	    /* Log -- may be cancelled */
	    borg_info(format("Identifying %s.", auto_items[i].desc));

	    /* Identify the item */
	    borg_keypress('a' + i);

	    /* Success */
	    return (TRUE);
	}

	/* Blind or confused */
	if (do_blind || do_confused) return (FALSE);

	/* Attempt to read a scroll of identify */
	if (borg_action('r', kind_scroll_identify)) {

	    /* Log */
	    borg_info(format("Identifying %s.", auto_items[i].desc));

	    /* Identify the item */
	    borg_keypress('a' + i);

	    /* Success */
	    return (TRUE);
	}
    }

    /* Nothing to do */
    return (FALSE);
}

/* EAW -- new function */
static bool borg_test_equip(void)
{
    int i;
    
    borg_note("Entering borg_test_equip()");
    
    /* Look for an item to identify */
    for (i = INVEN_WIELD; i < INVEN_TOTAL; i++) {

	/* Notice (nothing) slots */
	if (!auto_items[i].iqty) continue;

	/* Skip tested items */
	if (auto_items[i].able) continue;

	/* Use a Rod of Perceptions or a Staff of Perceptions */
	if (borg_action_pval('z', kind_rod_identify) ||
	    borg_action_pval('u', kind_staff_identify)) {

	    /* Log -- may be cancelled */
	    borg_note(format("Identifying %s.", auto_items[i].desc));

	    /* Identify the item */
	    borg_keypress('/');
	    borg_keypress('a' + i - INVEN_WIELD);

	    /* Success */
	    return (TRUE);
	}

	/* Blind or confused */
	if (do_blind || do_confused) return (FALSE);

	/* Attempt to read a scroll of identify */
	if (borg_action('r', kind_scroll_identify)) {

	    /* Log */
	    borg_note(format("Identifying %s.", auto_items[i].desc));

	    /* Identify the item */
	    borg_keypress('/');
	    borg_keypress('a' + i - INVEN_WIELD);

	    /* Success */
	    return (TRUE);
	}
    }


    /* Nothing to do */
    return (FALSE);
}


/*
 * Maintain a "useful" inventory
 */
static bool borg_wear_stuff(void)
{
    int i, b_i = -1;
    int slot;

    s32b p, b_p = 0L;

    /* Wear stuff (top down) */
    for (i = 0; i < INVEN_PACK; i++) {

	auto_item *item = &auto_items[i];

	/* Notice end of inventory */
	if (!item->iqty) break;

	/* Skip "unknown" items */
	if (!item->wear) continue;

	/* Acquire the "power" */
	p = item_power(item);

	/* Skip bad items */
	if ((b_i >= 0) && (p < b_p)) continue;

	/* Maintain the best */
	b_i = i; b_p = p;
    }

    /* Wear the "best" item */
    if (b_i >= 0) {

	auto_item *item = &auto_items[b_i];

	slot = borg_wield_slot(item);  

	/* MJC -- avoid crash if slot empty */
	if (auto_items[slot].iqty) {
	    /* EAW -- Don't mess with worn cursed stuff! */
	    if (streq(auto_items[slot].note, "{cursed}")) return(FALSE);
	}
	
	/* Log */ /* EAW -- note it instead */
	borg_note(format("Wearing %s.", item->desc));

	/* Wear it */
	borg_keypress('w');
	borg_keypress('a' + b_i);

	/* EAW -- Debug statement */
	borg_note(format("Power: %d", b_p));
	borg_note(format("Power of old thing: %d",
		item_power(&auto_items[slot])));

	/* Did something */
	return (TRUE);
    }


    /* Nothing to do */
    return (FALSE);
}







/*
 * Process a "goto" goal, return "TRUE" if goal is still okay.
 */
static bool borg_play_step(int x, int y)
{
    auto_grid *ag;

    int dir;


    /* We have arrived */
    if ((c_x == x) && (c_y == y)) return (FALSE);

    /* Get a direction (may be a wall there) */
    dir = borg_goto_dir(c_x, c_y, x, y);

    /* We are confused */
    if ((dir == 0) || (dir == 5)) return (FALSE);


    /* Access the grid we are stepping on */
    ag = grid(c_x + ddx[dir], c_y + ddy[dir]);


    /* Must "disarm" traps */
    if (ag->o_c == '^') {
	borg_info("Disarming a trap.");
	borg_keypress('D');
    }

    /* Occasionally "bash" doors */
    else if ((ag->o_c == '+') && (rand_int(10) == 0)) {
	borg_info("Bashing a door.");
	borg_keypress('B');
    }

    /* Must "open" (or "bash") doors */
    else if (ag->o_c == '+') {
	borg_info("Opening a door.");
	borg_keypress('0');
	borg_keypress('9');
	borg_keypress('o');
    }

    /* Tunnel through rubble */
    else if (ag->o_c == ':') {
	borg_info("Digging rubble.");
	
	/* EAW -- try a spell if you can */
	if(!borg_cast_tunnel_spell()) {
		borg_keypress('0');
		borg_keypress('9');
		borg_keypress('9');
		borg_keypress('T');
	}
    }

    /* Mega-Hack -- eventually give up digging walls */
    else if (((ag->o_c == '#') || (ag->o_c == '%')) && (rand_int(100) == 0)) {
	return (FALSE);
    }

    /* Tunnel through walls (or give up) */
    else if ((ag->o_c == '#') || (ag->o_c == '%')) {
	borg_info("Digging a wall.");
	
	/* EAW -- try a spell if you can */
	if(!borg_cast_tunnel_spell()) {
		borg_keypress('0');
		borg_keypress('9');
		borg_keypress('9');
		borg_keypress('T');
	}
    }

    /* XXX Hack -- Occasionally, tunnel for gold */
    else if (((ag->o_c == '$') || (ag->o_c == '*')) && (rand_int(10) == 0)) {
	borg_info("Digging for treasure.");
	
	/* EAW -- try a spell if you can */
	if(!borg_cast_tunnel_spell()) {
		borg_keypress('0');
		borg_keypress('9');
		borg_keypress('9');
		borg_keypress('T');
	}
    }

    /* XXX XXX XXX Hack -- Occasionally, tunnel anyway */
    else if (rand_int(1000) == 0) {
	borg_info("Digging for fun.");
	
	/* EAW -- try a spell if you can */
	if(!borg_cast_tunnel_spell()) {
		borg_keypress('0');
		borg_keypress('9');
		borg_keypress('9');
		borg_keypress('T');
	}
    }


    /* Walk (or tunnel or open or bash) in that direction */
    borg_keypress('0' + dir);


    /* Mega-Hack -- prepare to take stairs if desired */
    if (stair_less && (ag->o_c == '<')) borg_keypress('<');
    if (stair_more && (ag->o_c == '>')) borg_keypress('>');

    /* MJC - save if going up or down */
    if (stair_less && (ag->o_c == '<')) borg_save_game();
    if (stair_more && (ag->o_c == '>')) borg_save_game();

    /* Did something */
    return (TRUE);
}



/*
 * Choose a missile to fire
 */
 /* EAW -- MJC noticed that it should return int, not bool */
static int borg_choose_missile(void)
{
    int i, n = -1;

    /* Scan the pack */
    for (i = 0; i < INVEN_PACK; i++) {

	auto_item *item = &auto_items[i];

	/* Notice end of inventory */
	if (!item->iqty) break;

	/* Skip bad missiles */
	if (item->kind != kind_missile) continue;

	/* Skip un-identified missiles */
	if (!item->able) continue;

	/* Find the smallest pile */
	if ((n < 0) || (item->iqty < auto_items[n].iqty)) n = i;
    }

    /* Use that missile */
    if (n >= 0) return (n);


    /* Use any missile */
    for (i = 0; i < INVEN_PACK; i++) {

	auto_item *item = &auto_items[i];

	/* Notice end of inventory */
	if (!item->iqty) break;

	/* Acceptable missiles */
	if ((item->tval == TV_BOLT) ||
	    (item->tval == TV_ARROW) ||
	    (item->tval == TV_SHOT)) {

	    /* Skip un-identified missiles */
	    if (!item->able) continue;

	    /* Find the smallest pile */
	    if ((n < 0) || (item->iqty < auto_items[n].iqty)) n = i;
	}
    }

    /* Use that missile */
    if (n >= 0) return (n);
    

    /* Nothing to fire */
    return (-1);
}




/*
 * Take a step towards the current goal location
 * Return TRUE if this goal is still "okay".
 * Otherwise, cancel the goal and return FALSE.
 */
static bool borg_play_old_goal(void)
{
    auto_room *ar;


    /* Flow towards the goal */
    if (goal) {

	int x = c_x, y = c_y, best = 999;

	/* See "borg_flow_cost(c_x, c_y)" */
	for (ar = room(1,c_x,c_y); ar; ar = room(0,0,0)) {

	    int dx = ar->x - c_x;
	    int dy = ar->y - c_y;

	    int ax = ABS(dx);
	    int ay = ABS(dy);

	    /* Calculate the cost */
	    int cost = ar->cost + MAX(ax, ay);

	    /* Skip icky costs */       
	    if (cost >= best) continue;

	    /* Note the best so far */
	    x = ar->x; y = ar->y; best = cost;
	}

	/* Attempt to take one step in the path */
	if (borg_play_step(x, y)) return (TRUE);
    }

    /* Cancel goals */
    goal = 0;

    /* Nothing to do */
    return (FALSE);
}



/*
 * Determine if a grid touches unknown grids
 */
static bool borg_interesting(int x1, int y1)
{
    int i, x, y;

    auto_grid *ag;

    /* Scan all eight neighbors */
    for (i = 0; i < 8; i++) {

	/* Get the location */
	x = x1 + ddx[ddd[i]];
	y = y1 + ddy[ddd[i]];

	/* Get the grid */
	ag = grid(x, y);

	/* Unknown grids are interesting */     
	if (ag->o_c == ' ') return (TRUE);

	/* Known walls are boring */
	if (ag->info & BORG_WALL) continue;

	/* Unroomed grids are interesting */
	if (!ag->room) return (TRUE);
    }

    /* Assume not */
    return (FALSE);
}







/*
 * Prepare to "flow" towards monsters to "kill"
 */
static bool borg_flow_kill()
{
    int i, x, y;

    auto_grid *ag;


    /* Nothing found */
    seen_n = 0;

    /* Look for something to kill */
    for (i = 0; i < view_n; i++) {

	/* Access the "view grid" */
	y = view_y[i];
	x = view_x[i];

	/* Get the auto_grid */
	ag = grid(x, y);

	/* Skip the player grid */
	if (ag == pg) continue;

	/* Skip unknown grids */
	if (ag->o_c == ' ') continue;

	/* Notice monsters (efficiently) */
	if (auto_is_kill[(byte)(ag->o_c)]) {

	    /* Remember it */
	    if (seen_n < SEEN_MAX) {
		seen_x[seen_n] = x;
		seen_y[seen_n] = y;
		seen_n++;
	    }
	}
    }

    /* Nothing to kill */
    if (!seen_n) return (FALSE);


    /* Clear the flow codes */
    borg_flow_clear();

    /* Look for something to kill */
    for (i = 0; i < seen_n; i++) {

	/* Enqueue the grid */
	borg_flow_enqueue_grid(seen_x[i], seen_y[i]);
    }

    /* Clear the seen array */
    seen_n = 0;

    /* Spread the flow a little */
    borg_flow_spread(TRUE);

    /* Extract the "best" cost */
    i = borg_flow_cost(c_x, c_y);

    /* No good path */
    if (i >= 999) return (FALSE);

    /* Note */
    borg_info(format("Flowing toward monsters, at cost %d", i));

    /* Set the "goal" */
    goal = GOAL_KILL;

    /* Success */
    return (TRUE);
}


/*
 * Prepare to "flow" towards objects to "take"
 */
static bool borg_flow_take()
{
    int i, x, y;

    auto_grid *ag;


    /* Nothing yet */
    seen_n = 0;

    /* Look for something to take */
    for (i = 0; i < view_n; i++) {

	/* Access the "view grid" */
	y = view_y[i];
	x = view_x[i];

	/* Get the auto_grid */
	ag = grid(x, y);

	/* Skip the player grid */
	if (ag == pg) continue;

	/* Skip unknown grids */
	if (ag->o_c == ' ') continue;

	/* Notice objects (efficiently) */
	if (auto_is_take[(byte)(ag->o_c)]) {

	    /* Remember it */
	    if (seen_n < SEEN_MAX) {
		seen_x[seen_n] = x;
		seen_y[seen_n] = y;
		seen_n++;
	    }
	}
    }

    /* Nothing to take */
    if (!seen_n) return (FALSE);


    /* Clear the flow codes */
    borg_flow_clear();

    /* Look for something to take */
    for (i = 0; i < seen_n; i++) {

	/* Enqueue the grid */
	borg_flow_enqueue_grid(seen_x[i], seen_y[i]);
    }

    /* Clear the seen array */
    seen_n = 0;

    /* Spread the flow (a little) */
    borg_flow_spread(TRUE);

    /* Extract the "best" cost */
    i = borg_flow_cost(c_x, c_y);

    /* No good path */
    if (i >= 999) return (FALSE);

    /* Note */
    borg_info(format("Flowing toward objects, at cost %d", i));

    /* Set the "goal" */
    goal = GOAL_TAKE;

    /* Success */
    return (TRUE);
}


/*
 * Prepare to "flow" towards "dark" or "unknown" grids
 */
static bool borg_flow_dark()
{
    int i, x, y;

    auto_grid *ag;


    /* Nothing yet */
    seen_n = 0;

    /* Look for something unknown */
    for (i = 0; i < view_n; i++) {

	/* Access the "view grid" */
	y = view_y[i];
	x = view_x[i];

	/* Get the auto_grid */
	ag = grid(x, y);

	/* Skip the player grid */
	if (ag == pg) continue;

	/* Skip unknown grids */
	if (ag->o_c == ' ') continue;

	/* Cannot explore walls */
	if (ag->info & BORG_WALL) continue;

	/* Notice interesting grids */
	if (borg_interesting(x, y)) {

	    /* Remember it */
	    if (seen_n < SEEN_MAX) {
		seen_x[seen_n] = x;
		seen_y[seen_n] = y;
		seen_n++;
	    }
	}
    }

    /* Nothing dark */
    if (!seen_n) return (FALSE);


    /* Clear the flow codes */
    borg_flow_clear();

    /* Enqueue useful grids */
    for (i = 0; i < seen_n; i++) {

	/* Enqueue the grid */
	borg_flow_enqueue_grid(seen_x[i], seen_y[i]);
    }

    /* Clear the seen array */
    seen_n = 0;

    /* Spread the flow (a little) */
    borg_flow_spread(TRUE);

    /* Extract the "best" cost */
    i = borg_flow_cost(c_x, c_y);

    /* No good path */
    if (i >= 999) return (FALSE);

    /* Note */
    borg_info(format("Flowing toward unknown grids, at cost %d", i));

    /* Set the "goal" */
    goal = GOAL_DARK;

    /* Success */
    return (TRUE);
}


/*
 * Prepare to "flow" towards "interesting" things
 */
static bool borg_flow_explore(void)
{
    int x, y, i;

    auto_grid *ag;


    /* Nothing yet */
    seen_n = 0;

    /* Examine every legal grid */
    for (y = 1; y < AUTO_MAX_Y-1; y++) {
	for (x = 1; x < AUTO_MAX_X-1; x++) {

	    /* Get the grid */
	    ag = grid(x, y);

	    /* Skip current location */
	    if (pg == ag) continue;

	    /* Skip stuff */
	    if (ag->o_c == ' ') continue;
	    if (!ag->room) continue;

	    /* Cannot explore walls */
	    if (ag->info & BORG_WALL) continue;

	    /* Only examine "interesting" grids */
	    if (!borg_interesting(x, y)) continue;

	    /* Remember it */
	    if (seen_n < SEEN_MAX) {
		seen_x[seen_n] = x;
		seen_y[seen_n] = y;
		seen_n++;
	    }
	}
    }

    /* Nothing useful */
    if (!seen_n) return (FALSE);


    /* Clear the flow codes */
    borg_flow_clear();

    /* Enqueue useful grids */
    for (i = 0; i < seen_n; i++) {

	/* Enqueue the grid */
	borg_flow_enqueue_grid(seen_x[i], seen_y[i]);
    }

    /* Clear the seen array */
    seen_n = 0;

    /* Spread the flow (a little) */
    borg_flow_spread(TRUE);

    /* Extract the "best" cost */
    i = borg_flow_cost(c_x, c_y);

    /* No good path */
    if (i >= 999) return (FALSE);

    /* Note */
    borg_note(format("Chasing unknowns, at cost %d", i));

    /* Set the "goal" */
    goal = GOAL_DARK;

    /* Success */
    return (TRUE);
}


/*
 * Prepare to "flow" towards "old" monsters
 */
static bool borg_flow_kill_any(void)
{
    int i, x, y;

    auto_grid *ag;


    /* Efficiency -- Nothing to kill */
    if (!count_kill) return (FALSE);


    /* Nothing yet */
    seen_n = 0;

    /* Examine every legal grid */
    for (y = 1; y < AUTO_MAX_Y-1; y++) {
	for (x = 1; x < AUTO_MAX_X-1; x++) {

	    /* Get the grid */
	    ag = grid(x, y);

	    /* Skip current location */
	    if (pg == ag) continue;

	    /* Skip stuff */
	    if (ag->o_c == ' ') continue;
	    if (!ag->room) continue;

	    /* Skip non-monsters (efficiently) */
	    if (!auto_is_kill[(byte)(ag->o_c)]) continue;

	    /* Remember it */
	    if (seen_n < SEEN_MAX) {
		seen_x[seen_n] = x;
		seen_y[seen_n] = y;
		seen_n++;
	    }
	}
    }

    /* Nothing useful */
    if (!seen_n) return (FALSE);


    /* Clear the flow codes */
    borg_flow_clear();

    /* Enqueue useful grids */
    for (i = 0; i < seen_n; i++) {

	/* Enqueue the grid */
	borg_flow_enqueue_grid(seen_x[i], seen_y[i]);
    }

    /* Clear the "seen" array */
    seen_n = 0;

    /* Spread the flow (a little) */
    borg_flow_spread(TRUE);

    /* Extract the "best" cost */
    i = borg_flow_cost(c_x, c_y);

    /* No good path */
    if (i >= 999) return (FALSE);

    /* Note */
    borg_note(format("Chasing monsters, at cost %d", i));

    /* Set the "goal" */
    goal = GOAL_KILL;

    /* Success */
    return (TRUE);
}


/*
 * Prepare to "flow" towards "old" objects
 */
static bool borg_flow_take_any(void)
{
    int i, x, y;

    auto_grid *ag;


    /* Efficiency -- Nothing to take */
    if (!count_take) return (FALSE);


    /* Nothing yet */
    seen_n = 0;

    /* Examine every legal grid */
    for (y = 1; y < AUTO_MAX_Y-1; y++) {
	for (x = 1; x < AUTO_MAX_X-1; x++) {

	    /* Get the grid */
	    ag = grid(x, y);

	    /* Skip current location */
	    if (pg == ag) continue;

	    /* Skip stuff */
	    if (ag->o_c == ' ') continue;
	    if (!ag->room) continue;

	    /* Skip non-objects (efficiently) */
	    if (!auto_is_take[(byte)(ag->o_c)]) continue;

	    /* Remember it */
	    if (seen_n < SEEN_MAX) {
		seen_x[seen_n] = x;
		seen_y[seen_n] = y;
		seen_n++;
	    }
	}
    }

    /* Nothing useful */
    if (!seen_n) return (FALSE);


    /* Clear the flow codes */
    borg_flow_clear();

    /* Enqueue useful grids */
    for (i = 0; i < seen_n; i++) {

	/* Enqueue the grid */
	borg_flow_enqueue_grid(seen_x[i], seen_y[i]);
    }

    /* Clear the "seen" array */
    seen_n = 0;

    /* Spread the flow (a little) */
    borg_flow_spread(TRUE);

    /* Extract the "best" cost */
    i = borg_flow_cost(c_x, c_y);

    /* No good path */
    if (i >= 999) return (FALSE);

    /* Note */
    borg_note(format("Chasing objects, at cost %d", i));

    /* Set the "goal" */
    goal = GOAL_TAKE;

    /* Success */
    return (TRUE);
}





/*
 * Prepare to "flow" towards "interesting" things
 */
static bool borg_flow_symbol(char what)
{
    int i, x, y;

    auto_grid *ag;


    /* Nothing yet */
    seen_n = 0;

    /* Examine every legal grid */
    for (y = 1; y < AUTO_MAX_Y-1; y++) {
	for (x = 1; x < AUTO_MAX_X-1; x++) {

	    /* Get the grid */
	    ag = grid(x, y);

	    /* Skip current location */
	    if (pg == ag) continue;

	    /* Skip stuff */
	    if (ag->o_c == ' ') continue;
	    if (!ag->room) continue;

	    /* Skip incorrect symbols */
	    if (ag->o_c != what) continue;

	    /* Remember it */
	    if (seen_n < SEEN_MAX) {
		seen_x[seen_n] = x;
		seen_y[seen_n] = y;
		seen_n++;
	    }
	}
    }

    /* Nothing useful */
    if (!seen_n) return (FALSE);


    /* Clear the flow codes */
    borg_flow_clear();

    /* Enqueue useful grids */
    for (i = 0; i < seen_n; i++) {

	/* Enqueue the grid */
	borg_flow_enqueue_grid(seen_x[i], seen_y[i]);
    }

    /* Clear the "seen" array */
    seen_n = 0;

    /* Spread the flow (a little) */
    borg_flow_spread(TRUE);

    /* Extract the "best" cost */
    i = borg_flow_cost(c_x, c_y);

    /* No good path */
    if (i >= 999) return (FALSE);

    /* Note */
    borg_note(format("Chasing symbols (%c), at cost %d", what, i));

    /* Set the "goal" */
    goal = GOAL_XTRA;

    /* Success */
    return (TRUE);
}





/*
 * Go shopping in the town (do stores in order)
 */
static bool borg_flow_shop(void)
{
    int i, n = -1, v = 99;

    /* Must be in town */
    if (auto_depth) return (FALSE);

    /* Visit the oldest shop */
    for (i = 0; i < 8; i++) {

	/* Skip recent shops */
	if ((n >= 0) && (auto_shops[i].visit >= v)) continue;

	/* Save this shop */
	n = i; v = auto_shops[i].visit;
    }

    /* Plenty of visits */
    if (v >= last_visit + 2) return (FALSE);

    /* Try and visit it */
    if (borg_flow_symbol('1' + n)) return (TRUE);

    /* Failure */
    return (FALSE);
}




/*
 * Walk around the dungeon looking for monsters
 */
static bool borg_flow_revisit(void)
{
    int x, y, i;

    auto_room *ar;

    int r_n = -1;
    s32b r_age = 0L;

    s32b age;


    /* First find the reachable spaces */
    borg_flow_reverse();

    /* Re-visit "old" rooms */
    for (i = 1; i < auto_room_max; i++) {

	/* Access the "room" */
	ar = &auto_rooms[i];

	/* Skip "dead" rooms */
	if (ar->free) continue;

	/* Skip "unreachable" rooms */
	if (ar->cost >= 999) continue;

	/* Hack -- skip "boring" rooms */
	/* if ((ar->x1 == ar->x2) || (ar->y1 == ar->y2)) continue; */

	/* Reward "age" and "distance" and "luck" */
	age = (c_t - ar->when) + (ar->cost / 2);

	/* Skip "recent" rooms */
	if ((r_n >= 0) && (age < r_age)) continue;

	/* Save the index, and the age */
	r_n = i; r_age = age;
    }

    /* Clear the flow codes */
    borg_flow_clear();

    /* Hack -- No rooms to visit (!) */
    if (r_n < 0) return (FALSE);

    /* Get the room */
    ar = &auto_rooms[r_n];

    /* Visit a random grid of that room */
    x = rand_range(ar->x1, ar->x2);
    y = rand_range(ar->y1, ar->y2);

    /* Enqueue the room */
    borg_flow_enqueue_grid(x, y);

    /* Spread the flow */
    borg_flow_spread(TRUE);

    /* Extract the "best" cost */
    i = borg_flow_cost(c_x, c_y);

    /* No good path */
    if (i >= 999) return (FALSE);

    /* Note */
    borg_note(format("Revisiting (%d, %d) with age %ld, at cost %d",
		     x, y, r_age, i));

    /* Set the "goal" */
    goal = GOAL_XTRA;

    /* Success */
    return (TRUE);
}


/*
 * Heuristic -- Help locate secret doors (see below)
 *
 * Determine the "likelihood" of a secret door touching "(x,y)",
 * which is "d" grids away from the player.
 *
 * Assume grid is legal, non-wall, and reachable.
 * Assume grid neighbors are legal and known.
 */
static int borg_secrecy(int x, int y, int d)
{
    int         i, v;
    int         wall = 0, supp = 0, diag = 0;

    char        cc[8];

    auto_grid   *ag;


    /* No secret doors in town */
    if (auto_depth == 0) return (0);


    /* Get the central grid */
    ag = grid(x, y);

    /* Tweak -- Limit total searches */
    if (ag->xtra > 50) return (0);


    /* Extract adjacent locations */
    for (i = 0; i < 8; i++) {

	/* Extract the location */
	int xx = x + ddx[ddd[i]];
	int yy = y + ddy[ddd[i]];

	/* Get the grid */
	cc[i] = grid(xx,yy)->o_c;
    }


    /* Count possible door locations */
    for (i = 0; i < 4; i++) if (cc[i] == '#') wall++;

    /* No possible secret doors */
    if (wall <= 0) return (0);


    /* Count supporting evidence for secret doors */
    for (i = 0; i < 4; i++) {
	if ((cc[i] == '#') || (cc[i] == '%')) supp++;
	else if ((cc[i] == '+') || (cc[i] == '\'')) supp++;
    }

    /* Count supporting evidence for secret doors */
    for (i = 4; i < 8; i++) {
	if ((cc[i] == '#') || (cc[i] == '%')) diag++;
    }


    /* Tweak -- Reward walls, punish visitation and distance */
    v = (supp * 300) + (diag * 100) - (ag->xtra * 20) - (d * 1);

    /* Result */
    return (v);
}



/*
 * Search carefully for secret doors and such
 */
static bool borg_flow_spastic(void)
{
    int i, x, y, v;
    int g_x = c_x, g_y = c_y, g_v = -1;

    int boredom;

    auto_room *ar;


    /* Hack -- Tweak -- Determine boredom */
    boredom = count_floor - 500;
    if (boredom < 200) boredom = 200;
    if (boredom > 800) boredom = 800;

    /* Tweak -- Search based on dungeon knowledge */
    if (c_t - auto_shock < boredom) return (FALSE);


    /* Hack -- first find the reachable spaces */
    borg_flow_reverse();

    /* Scan the entire map */
    for (y = 1; y < AUTO_MAX_Y-1; y++) {
	for (x = 1; x < AUTO_MAX_X-1; x++) {

	    auto_grid *ag = grid(x, y);

	    /* Skip stuff */
	    if (ag->o_c == ' ') continue;
	    if (!ag->room) continue;

	    /* Cannot search inside walls */
	    if (ag->info & BORG_WALL) continue;

	    /* Scan the rooms */
	    for (ar = room(1,x,y); ar; ar = room(0,0,0)) {

		/* Skip "unreachable" rooms */
		if (ar->cost >= 999) continue;

		/* Get the "searchability" */
		v = borg_secrecy(x, y, ar->cost);

		/* The grid is not searchable */
		if (v <= 0) continue;

		/* Skip non-perfect grids */
		if ((g_v >= 0) && (v < g_v)) continue;

		/* Save the data */
		g_v = v; g_x = x; g_y = y;
	    }
	}
    }

    /* Clear the flow codes */
    borg_flow_clear();

    /* Hack -- Nothing found */
    if (g_v < 0) return (FALSE);


    /* We have arrived */
    if ((c_x == g_x) && (c_y == g_y)) {

	/* Take note */
	borg_note("Spastic Searching...");

	/* Tweak -- Remember the search */
	if (pg->xtra < 100) pg->xtra += 9;

	/* Tweak -- Search a little */
	borg_keypress('0');
	borg_keypress('9');
	borg_keypress('s');

	/* Success */
	return (TRUE);
    }


    /* Enqueue the grid */
    borg_flow_enqueue_grid(g_x, g_y);

    /* Spread the flow a little */
    borg_flow_spread(TRUE);

    /* Extract the "best" cost */
    i = borg_flow_cost(c_x, c_y);

    /* No good path */
    if (i >= 999) return (FALSE);

    /* Note */
    borg_note(format("Spastic twitch towards (%d,%d)", g_x, g_y));

    /* Set the "goal" */
    goal = GOAL_XTRA;

    /* Success */
    return (TRUE);
}





/*
 * Given a location, attempt to determine what type of monster is
 * at that location.  Use type "0" for "no known monster".
 *
 * This guess can be improved by the judicious use of a specialized
 * "attr/char" mapping, especially for unique monsters.  Note that
 * we cheat by directly accessing the attr/char tables.
 *
 * We will never correctly identify player ghosts
 * We will usually fail to identify multi-hued monsters
 * We will usually fail for very out of depth monsters
 * We will attempt to err on the side of caution
 *
 * We treat the "town" level specially, and unless a player ghost
 * appears in town, our guess will always be correct.
 */
static int guess_monster(int x, int y)
{
    int i;

    auto_grid *ag = grid(x, y);


    /* Efficiency */
    if (ag->o_c == ' ') return (0);
    if (ag->o_c == '.') return (0);
    if (ag->o_c == '#') return (0);


    /* Special treatment of "town" monsters */
    if (auto_depth <= 0) {

	/* Hack -- Find the first "acceptable" monster */
	for (i = 1; i < MAX_R_IDX-1; i++) {

	    monster_race *r_ptr = &r_list[i];
	    monster_lore *l_ptr = &l_list[i];

	    if (r_ptr->level) break;

	    if (ag->o_c != l_ptr->l_char) continue;
	    if (ag->o_a != l_ptr->l_attr) continue;

	    return (i);
	}
    }

    /* Guess what monster it might be */
    else {

	/* Hack -- Find the highest "acceptable" monster */
	for (i = (MAX_R_IDX-1) - 1; i > 0; i--) {

	    monster_race *r_ptr = &r_list[i];
	    monster_lore *l_ptr = &l_list[i];

	    if (r_ptr->level > auto_depth + 5) continue;

	    /* MJC - dead uniques */
	    if (l_ptr->max_num == 0) continue;

	    if (ag->o_c != l_ptr->l_char) continue;
	    if (ag->o_a != l_ptr->l_attr) continue;

	    return (i);
	}
    }


    /* Oops */
    return (0);
}



/*
 * Target a location
 */
static bool borg_target(int x, int y)
{
    int x1, y1, x2, y2;

    /* Hack -- Cannot target off-screen location */
    if ((x < w_x) || (x >= w_x + SCREEN_WID)) return (FALSE);
    if ((y < w_y) || (y >= w_y + SCREEN_HGT)) return (FALSE);

    /* Log */
    borg_info("Targetting a location.");

    /* Target the location */
    borg_keypress('*');
    borg_keypress('p');

    /* Determine "path" */
    x1 = c_x; y1 = c_y; x2 = x; y2 = y;

    /* Move to the location */
    for ( ; y1 < y2; y1++) borg_keypress('2');
    for ( ; y1 > y2; y1--) borg_keypress('8');
    for ( ; x1 < x2; x1++) borg_keypress('6');
    for ( ; x1 > x2; x1--) borg_keypress('4');

    /* Select the target */
    borg_keypress('t');

    /* Success */
    return (TRUE);
}



/*
 * Attempt to fire at monsters
 */
static bool borg_play_fire(void)
{
    int i, k, r;

    int f_x = c_x, f_y = c_y, f_d = 999;
    
    /* EAW -- stuff for hardest ranged guy */
    int g_r = -1, g_x, g_y;

    /* Look for something to kill */
    for (i = 0; i < view_n; i++) {

	/* Access the "view grid" */
	int y = view_y[i];
	int x = view_x[i];

	/* Get the auto_grid */
	auto_grid *ag = grid(x, y);

	/* Assume no monster */
	bool kill = FALSE;

	/* Skip the player grid */
	if (ag == pg) continue;

	/* Skip unknown grids */
	if (ag->o_c == ' ') continue;

	/* Cannot shoot into walls */
	if (ag->info & BORG_WALL) continue;

	/* Should not shoot at "dark" grids */
	if (!(ag->info & BORG_OKAY)) continue;

	/* Notice monsters (efficiently) */
	if (auto_is_kill[(byte)(ag->o_c)]) kill = TRUE;

	/* XXX XXX XXX Mega-Hack -- hit mushrooms sometimes */
	if ((ag->o_c == ',') && (rand_int(10) == 0)) kill = TRUE;

	/* Skip non-monsters */
	if (!kill) continue;

	/* Must have "missile line of sight" */
	if (!borg_projectable(c_x, c_y, x, y)) continue;

	/* Check distance */
	k = distance(c_y, c_x, y, x);

	/* Must be within range */
	if (k > 10) continue;

	/* Must not be adjacent (unless afraid) */
	if (!do_afraid && (k <= 1)) continue;

	/* Skip far away monsters */
	if (k > f_d) continue;

	/* Save the distance */
	f_d = k; f_x = x; f_y = y;
	
	/* EAW -- Guess the monster */
	r = guess_monster(x, y);

	/* EAW -- Mega-Hack -- Use the "hardest" monster */
	if (r < g_r) continue;
    
	/* EAW -- Save the info */
	g_r = r, g_x = x, g_y = y;
    }

    /* Hack -- try firing missiles */
    if (f_d >= 999) return (FALSE);


    /* Only a one in five chance (unless afraid) */
    /* EAW -- move this logic to borg_attack() so he will always fire at 
	      a monster if there isn't one next to him */
 /*   if (!do_afraid && (rand_int(5) != 0)) return (FALSE);    */

    /* Target the monster (if possible) */
    /* EAW -- target the hardest monster */
    if (!borg_target(g_x, g_y)) return (FALSE);

    /* Acquire monster type */
    r = guess_monster(g_x, g_y);

#ifdef FRITS
 /*   if (rand_int(3)) {   */
    if (borg_cast_aggressive_spell()==TRUE) 
       return(TRUE);
/*    }          */
#endif /* FRITS */
    
    /* EAW -- moved these two to AFTER targeting to accomodate spells */
    /* Find a "missile" */
    i = borg_choose_missile();

    /* Nothing to fire */
    if (i < 0) return (FALSE);


    /* Note */
    borg_note(format("Launching (%s).", r_list[r].name));

    /* Fire at the target */
    borg_keypress('f');
    borg_keypress('a' + i);
    borg_keypress('t');


    /* Success */
    return (TRUE);
}



/*
 * Hack -- be cautious
 */
static int borg_caution(void)
{
    int x, y, i, d, k, o_n, g_n, g_d = -1;

    auto_grid *ag;


    /* Look around */
    o_n = borg_count_monsters(c_x, c_y);

    /* Require an adjacent monster */
    if (o_n < 1) return (FALSE);

    /* XXX XXX XXX Hack -- attempt to teleport to safety */
    if (auto_curhp < auto_maxhp / 3) {

	/* Read scrolls of teleport (low failure rate) */
	if (borg_action('r', kind_scroll_teleport)) return (TRUE);

	/* Mega-Hack -- Use (charged) staffs of teleport */
	if (borg_action_pval('u', kind_staff_teleport)) return (TRUE);
    
#ifdef FRITS
	if (borg_cast_teleport_spell()==TRUE) return(TRUE);
#endif /* FRITS */
    
    }

    /* EAW -- changed 'small' from 1 to 2 */
    /* Ignore small numbers of monsters */
    if (o_n < 3) return (FALSE);

    /* XXX XXX XXX Hack -- attempt to teleport to safety */
    if (auto_curhp < auto_maxhp / 2 && borg_count_healing() < 1) {

	/* Mega-Hack -- Use (charged) staffs of teleport */
	if (borg_action_pval('u', kind_staff_teleport)) return (TRUE);

	/* Read scrolls of teleport */
	if (borg_action('r', kind_scroll_teleport)) return (TRUE);
    }

    /* Goal minimum */
    g_n = o_n;

    /* Attempt to find a better grid */
    for (i = 0; i < 8; i++) {

	/* Access the grid */
	d = ddd[i];
	x = c_x + ddx[d];
	y = c_y + ddy[d];
	ag = grid(x, y);

	/* Skip walls (!) */
	if (ag->info & BORG_WALL) continue;
	
	/* Skip unknown grids */
	if (ag->o_c == ' ') continue;

	/* Skip monsters (efficiently) */
	if (auto_is_kill[(byte)(ag->o_c)]) continue;

	/* Hack -- Skip traps */
	if (ag->o_c == '^') continue;

	/* Mega-Hack -- Skip stores */
	if (isdigit(ag->o_c)) continue;

	/* Count the monsters */
	k = borg_count_monsters(x, y);

	/* Require fewer monsters */
	if (k >= g_n) continue;

	/* Save the info */
	g_n = k; g_d = d;
    }

    /* Nowhere to run */
    if (g_d < 0) return (FALSE);


    /* Only be cautious occasionally */
    if (rand_int(3) != 0) return (FALSE);

    /* Note */
    borg_note(format("Caution (%d > %d).", o_n, g_n));

    /* Hack -- Flee! */
    borg_keypress('0' + g_d);

    /* Success */
    return (TRUE);
}


/*
 * Attack monsters (unless afraid)
 */
static int borg_attack(void)
{
    int i, r, n = 0, g_d = -1, g_r = -1;

    /* Check adjacent grids */
    for (i = 0; i < 8; i++) {

	/* Direction */
	int d = ddd[i];

	/* Location */
	int x = c_x + ddx[d];
	int y = c_y + ddy[d];

	/* Grid */
	auto_grid *ag = grid(x, y);

	/* Skip non-monsters (efficiently) */
	if (!auto_is_kill[(byte)(ag->o_c)]) continue;

	/* Count monsters */
	n++;

	/* Guess the monster */
	r = guess_monster(x, y);

	/* Mega-Hack -- Use the "hardest" monster */
	if ((g_d >= 0) && (r < g_r)) continue;

	/* Save the info */
	g_d = d; g_r = r;
    }

    /* Nothing to attack */
    if (!n) return (FALSE);

    /* Do not attack when afraid */ /* EAW -- try spell */
    if (do_afraid && !borg_play_fire()) {
	borg_note(format("Fearing (%s).", r_list[g_r].name));
	return (FALSE);
    }

    /* Mention monster */
    if (n > 1) borg_note(format("Selecting (%s).", r_list[g_r].name));
    else borg_note(format("Attacking (%s).", r_list[g_r].name));

    /* EAW -- range attack him every now and then, not while hallucinating */
    if (rand_int(5) == 0 && !p_ptr->image && borg_play_fire()) return (TRUE);

    /* Hack -- Attack! */
    borg_keypress('0' + g_d);

    /* Success */
    return (TRUE);
}



/*
 * Help the Borg decide if it should flee back to town
 * This function analyzes the inventory for "essential" items
 * It could also verify adequate "resistance" and other stuff
 * If "bored" is true then we have fully explored the current level
 * Proper use of stores requires "waiting" for them to "restock"
 * Note that this "waiting" must be done in the dungeon (level 1)
 */
static bool borg_leave_level_aux(bool bored)
{
    auto_item *item = &auto_items[INVEN_LITE];

    /* EAW -- counter */
    byte i;

    /* Consider the appropriate level */
    int depth = bored ? (auto_depth + 1) : auto_depth;

    /* EAW -- he was in major trouble, but is ok now, but should still go
	      back to town, not dive even deeper */
    
    /* EAW -- Hack -- try to keep him from diving too deep */
    /* MJC -- use function */
    if (bored && auto_depth >= borg_deepest_level()) return (TRUE);
    
    /* EAW -- force him to go back to town if I think he should */
    if (bored && do_force_up) return (TRUE);

    /* EAW -- he almost died, get his ass back to town! */
    if (do_was_almost_dead) return (TRUE);

    /*** Stair scumming ***/

    /* Mega-Hack -- give stores a chance to restock */
    /* MJC -- Mega-Hack -- depth 2 instead */
    if ((auto_depth <= 2) && !bored) return (FALSE);


    /*** Essential Items ***/

    /* Require all lower books if down deep enough */
    if (bored && auto_depth >= 20) {
	if (auto_sclass == SCLASS_MAGE) {
		for (i = 0; i < 4; i++) {
			if (!kind_have[kind_magic_books[i]]) return (TRUE);
		}
	}
	if (auto_sclass == SCLASS_PRIEST) {
		for (i = 0; i < 4; i++) {
			if (!kind_have[kind_prayer_books[i]]) return (TRUE);
		}
	}
    }

    /* Require Food Rations */
    if (kind_have[kind_food_ration] < 10 &&
	!borg_can_cast_dinner_spell()) return (TRUE);

    /* Require Lite and/or fuel */
    if (item->iqty == 0) return (TRUE);
    if ((item->kind == kind_torch) && (kind_have[kind_torch] < 10)) return (TRUE);
    if ((item->kind == kind_lantern) && (kind_have[kind_flask] < 10)) return (TRUE);


    /*** Useful Items ***/

    /* Scrolls of Identify */
    if (kind_have[kind_scroll_identify] < 5) return (TRUE);
/*    if (bored && (kind_have[kind_scroll_identify] < 10)) return (TRUE); */

    /* Scrolls of Word of Recall */
    if ((depth >= 2) && (kind_have[kind_scroll_recall] < 1)) return (TRUE);
    if ((depth >= 5) && (kind_have[kind_scroll_recall] < 2)) return (TRUE);
/*
    if ((depth >= 5) && bored && (kind_have[kind_scroll_recall] < 3)) return (TRUE);
*/
    /* Potions of Cure Serious Wounds */
    /* EAW -- I don't really care about these for higher levels */
/*    
    if ((depth >= 3) && (kind_have[kind_potion_serious] < 2)) return (TRUE);
    if ((depth >= 3) && bored && (kind_have[kind_potion_serious] < 5)) return (TRUE);
*/
    /* Potions of Cure Critical Wounds */
    
    if ((depth >= 5) && (kind_have[kind_potion_critical] < 5)) return (TRUE);
    if ((depth >= 5) && bored && (kind_have[kind_potion_critical] < 10)) return (TRUE);


    /* Stay here */
    return (FALSE);
}



/*
 * Leave the level if necessary (or bored)
 */
static bool borg_leave_level(bool bored)
{
    int k, g = 0;
    int i;              /* EAW -- counter for resting */

    /* Cancel stair requests */
    stair_less = stair_more = FALSE;


    /* Hack -- already leaving */
    if (auto_recall) return (FALSE);

    /* Count sellable items */
    k = borg_count_sell();


    /* Power-dive */
    if (auto_depth && (auto_level > auto_depth * 2)) g = 1;

    /* Dive when bored */
    if (auto_depth && bored && (c_t - auto_shock > 1000L)) g = 1;

    /* Mega-Hack -- Do not leave a level until "bored" */
    if (c_t - auto_began < attention) g = 0;

    /* Do not dive when "full" of items */
  /*  if (g && (k >= 18)) g = 0; */

    /* EAW -- Do not dive when "full" of items */
    if (g && (k >= 14 - nrbooks)) g = 0;
    

    /* Hack -- do not dive when drained */
/*    if (do_fix_exp) g = 0; */
    /* EAW -- do not dive when level drained */
    if (do_fix_lev && auto_depth >= 5) g = 0;

    /* Return to town (immediately) if we are worried */
    if (borg_leave_level_aux(bored)) goal_rising = TRUE;

    /* Return to town to sell stuff */
  /*  if (bored && (k >= 18)) goal_rising = TRUE; */

    /* EAW -- Return to town to sell stuff */
    if (bored && (k >= 14 - nrbooks)) goal_rising = TRUE;
    
    /* Hack -- return to town to restore experience */
/*    if (bored && do_fix_exp) goal_rising = TRUE; */
    /* EAW -- return to town to restore level */
    if (bored && do_fix_lev && auto_depth >= 5) goal_rising = TRUE;

    /* Never rise from town */
    if (auto_depth == 0) goal_rising = FALSE;

    /* Return to town */
    if (goal_rising) g = -1;


    /* Bored and in town, go down */
    if (bored && (auto_depth == 0)) g = 1;


    /* Use random stairs when really bored */
    if (auto_depth && bored && (c_t - auto_shock > 3000L)) {

	/* Use random stairs */
	g = (rand_int(100) < 50) ? -1 : 1;
    }


    /* Go Up */
    if (g < 0) {

	/* Hack -- use scroll of recall if able */
	/* MJC -- >0 scrolls, not >3 */
	if (goal_rising && (auto_depth > 5) && (kind_have[kind_scroll_recall] > 0)) {
	    if (borg_recall()) return (TRUE);
	}

	/* Attempt to use stairs */
	if (count_less && borg_flow_symbol('<')) {
	    borg_note("Returning to town.");
	    stair_less = TRUE;
	    if (borg_play_old_goal()) return (TRUE);
	}

	/* Cannot find any stairs, try word of recall */
	if (goal_rising && bored) {
	    if (borg_recall()) return (TRUE);
	}
    }


    /* Go Down */
    if (g > 0) {
	
	/* EAW -- read one in town if ready for deep dive */
	if (!auto_depth && kind_have[kind_scroll_recall] > 4 &&
	   borg_leave_level_aux(bored) == FALSE &&
	   kind_have[kind_scroll_teleport] >= 2 &&
	   kind_have[kind_scroll_identify] >= 30 &&
	   kind_have[kind_potion_critical] >= 10 &&
	   /* kind_have[kind_potion_serious] >= 10 && */
	   kind_have[kind_potion_healing] >= 2 &&
	   do_fix_exp == FALSE &&
	   ((auto_sclass == SCLASS_MAGE &&
	   kind_have[kind_magic_books[0]] == kind_need[kind_magic_books[0]] &&
	   kind_have[kind_magic_books[1]] == kind_need[kind_magic_books[1]] &&
	   kind_have[kind_magic_books[2]] == kind_need[kind_magic_books[2]] &&
	   kind_have[kind_magic_books[3]] == kind_need[kind_magic_books[3]])||
	    (auto_sclass == SCLASS_PRIEST &&
	   kind_have[kind_prayer_books[0]] == kind_need[kind_prayer_books[0]]&&
	   kind_have[kind_prayer_books[1]] == kind_need[kind_prayer_books[1]]&&
	   kind_have[kind_prayer_books[2]] == kind_need[kind_prayer_books[2]]&&
	   kind_have[kind_prayer_books[3]] == kind_need[kind_prayer_books[3]]
	   ))) {

	   read_in_town = TRUE;
	   if (borg_recall()) {
		   
	       read_in_town = FALSE;
	       borg_keypress(' ');      

	       /* waste as much time as possible so scroll should take */

	       for (i = 0; i < 20; i++) {
		    borg_keypress('R');
		    borg_keypress('1');
		    borg_keypress('\n');
	       }
		   
	       goal = 0;
	       room_was_lit = FALSE;
	       
	       return (TRUE);
	   }
	}


	/* Attempt to use those stairs */
	if (count_more && borg_flow_symbol('>')) {
	    borg_note("Diving into the dungeon.");
	    stair_more = TRUE;
	    if (borg_play_old_goal()) return (TRUE);
	}
    }


    /* Failure */
    return (FALSE);
}






/*
 * Buy items from the current store
 */
static bool borg_think_store_buy(void)
{
    int k, n;
    s32b p;

    int b_k = -1, b_n = -1;
    s32b b_p = 0L;


    /* XXX Hack -- notice "full" inventory */
    if (auto_items[INVEN_PACK-1].iqty) return (FALSE);


    /* Visit everyone before buying anything */
    for (k = 0; k < 8; k++) {

	/* Make sure we visited that shop */
	if (!auto_shops[k].visit) return (FALSE);
    }

    /* Check each store */
    for (k = 0; k < 8; k++) {
    
	auto_shop *shop = &auto_shops[k];

	/* Buy stuff */
	for (n = 0; n < 24; n++) {

	    auto_item *ware = &shop->ware[n];

	    /* Notice end of shop inventory */
	    if (!ware->iqty) break;

	    /* We must have "sufficient" cash */ /* EAW -- just the price */
	    if (auto_gold < ware->cost) continue;
				      
	    /* Only buy useful stuff */
	    if (!borg_good_buy(ware)) continue;

	    /* Extract the worth of this item */
	    p = item_power(ware);                          
							    
	    /* Hack -- notice the "best" thing */
	    if ((b_n >= 0) && (p < b_p)) continue;

	    /* Save the item and worth */
	    b_k = k; b_n = n; b_p = p;
	}
    }

    /* Buy the "best" item, if any, if in this store */
    if ((b_n >= 0) && (shop_num == b_k)) {

	auto_shop *shop = &auto_shops[shop_num];
	auto_item *ware = &shop->ware[b_n];

	/* Minor Hack -- Go to the correct page */
	if ((b_n / 12) != auto_shops[shop_num].page) borg_keypress(' ');

	/* Log */
	borg_info(format("Buying %s.", auto_shops[shop_num].ware[b_n].desc));

	/* Buy an item */
	borg_keypress('p');

	/* Buy the desired item */
	borg_keypress('a' + (b_n % 12));

	/* Hack -- Buy a single item */
	if (ware->iqty > 1) borg_keypress('\n');

	/* Hack -- Accept the price */
	borg_keypress('\n');
	borg_keypress('\n');
	borg_keypress('\n');
	borg_keypress('\n');

	/* Hack -- Note visit index */
	if (last_visit < shop->visit) last_visit = shop->visit;

	/* Success */
	return (TRUE);
    }


    /* Nothing to buy */
    return (FALSE);
}


/*
 * Sell items to the current store
 */
static bool borg_think_store_sell(void)
{
    int i, p;

    int b_n = -1, b_p = 0L;


    /* XXX Hack -- notice "full" store */
    if (auto_shops[shop_num].ware[23].iqty) return (FALSE);


    /* Sell stuff */
    for (i = 0; i < INVEN_PACK; i++) {

	auto_item *item = &auto_items[i];

	/* Notice end of inventory */
	if (!item->iqty) break;

	/* Consider "cash" items */
	if (!item->cash) continue;

	/* Do not try to make "bad" sales */
	if (!borg_good_sell(item)) continue;

	/* Extract the worth of this item */
	p = item_worth(item);

	/* Hack -- notice the "best" thing */
	if ((b_n >= 0) && (p < b_p)) continue;

	/* Save the item and worth */
	b_n = i; b_p = p;
    }

    /* Sell the most expensive item (if any) */
    if (b_n >= 0) {

	auto_item *item = &auto_items[b_n];

	/* Log */
	borg_info(format("Selling %s.", auto_items[b_n].desc));

	/* Sell that item */
	borg_keypress('s');
	borg_keypress('a' + b_n);

	/* Hack -- Sell a single item */
	if (item->iqty > 1) borg_keypress('\n');

	/* Hack -- Accept the price */
	borg_keypress('\n');
	borg_keypress('\n');
	borg_keypress('\n');
	borg_keypress('\n');

	/* Success */
	return (TRUE);
    }


    /* Assume not */
    return (FALSE);
}


/*
 * Deal with being in a store
 */
static bool borg_think_store(void)
{
    int i, n;

    byte t_a;

    char /* p1 = '(', */ p2 = ')';

    char desc[80];
    char cost[10];

    char buf[256];


    /* Hack -- make sure both pages are seen */
    static int browse = TRUE;

    /* What store did I *think* I was in */
    static int old_store = 0;

    /* How many pages did I *think* there were */
    static int old_more = 0;


    /* Hack -- reset page/more */
    auto_shops[shop_num].page = 0;
    auto_shops[shop_num].more = 0;


    /* React to new stores */
    if (old_store != shop_num) {

	/* Clear all the items */
	for (i = 0; i < 24; i++) {

	    /* XXX Wipe the ware */
	    WIPE(&auto_shops[shop_num].ware[i], auto_item);
	}

	/* Save the store */
	old_store = shop_num;
    }


    /* Extract the "page", if any */
    if ((0 == borg_what_text(20, 5, 8, &t_a, buf)) &&
	(prefix(buf, "(Page "))) /* --)-- */ {

	/* Take note of the page */
	auto_shops[shop_num].more = 1;
	auto_shops[shop_num].page = (buf[6] - '0') - 1;
    }

    /* React to disappearing pages */
    if (old_more != auto_shops[shop_num].more) {

	/* Clear the second page */
	for (i = 12; i < 24; i++) {

	    /* XXX Wipe the ware */
	    WIPE(&auto_shops[shop_num].ware[i], auto_item);
	}

	/* Save the new one */
	old_more = auto_shops[shop_num].more;
    }


    /* Extract the current gold (unless in home) */
    if (0 == borg_what_text(68, 19, -9, &t_a, buf)) {

	/* Ignore this "field" in the home */
	if (shop_num != 7) auto_gold = atol(buf);
    }


    /* Parse the store (or home) inventory */
    for (i = 0; i < 12; i++) {

	/* Default to "empty" */
	desc[0] = '\0';
	cost[0] = '\0';

	/* Verify "intro" to the item */
	if ((0 == borg_what_text(0, i + 6, 3, &t_a, buf)) &&
	    (buf[0] == 'a' + i) && (buf[1] == p2) && (buf[2] == ' ')) {

	    /* Extract the item description */
	    if (0 != borg_what_text(3, i + 6, -65, &t_a, desc)) desc[0] = '\0';

	    /* XXX Make sure trailing spaces get stripped */

	    /* Extract the item cost */
	    if (0 != borg_what_text(68, i + 6, -9, &t_a, cost)) cost[0] = '\0';

	    /* Hack -- forget the cost in the home */
	    if (shop_num == 7) cost[0] = '\0';
	}

	/* Extract actual index */
	n = auto_shops[shop_num].page * 12 + i;

	/* Ignore "unchanged" descriptions */
	if (streq(desc, auto_shops[shop_num].ware[n].desc)) continue;

	/* Analyze it (including the cost) */
	borg_item_analyze(&auto_shops[shop_num].ware[n], desc, cost);
    }


    /* Hack -- browse as needed */
    if (auto_shops[shop_num].more && browse) {
	borg_keypress(' ');
	browse = FALSE;
	return (TRUE);
    }

    /* Hack -- must browse later */
    browse = TRUE;


    /* Complete and Total Hack */
    if (rand_int(1000) == 0) {

	bool done = FALSE;

	/* Take off the left ring */
	if (auto_items[INVEN_LEFT].iqty) {
	    borg_keypress('t');
	    borg_keypress('c');
	    done = TRUE;
	}

	/* Take off the right ring */
	if (auto_items[INVEN_RIGHT].iqty) {
	    borg_keypress('t');
	    borg_keypress('d');
	    done = TRUE;
	}

	/* Success */
	if (done) return (TRUE);
    }


    /* Examine the inventory */
    borg_notice();

    /* Wear things */
    if (borg_wear_stuff()) return (TRUE);

    /* Try to sell stuff */
    if (borg_think_store_sell()) return (TRUE);

    /* Try to buy stuff */
    if (borg_think_store_buy()) return (TRUE);


    /* Count the successful visits */
    auto_shops[shop_num].visit++;


    /* Leave the store */
    borg_keypress(ESCAPE);

    /* Done */
    return (TRUE);
}



/*
 * Perform an action in the dungeon
 *
 * Return TRUE if a "meaningful" action was performed
 * Otherwise, return FALSE so we will be called again
 *
 * Strategy:
 *   Make sure we are happy with our "status" (see above)
 *   Attack and kill visible monsters, if near enough
 *   Open doors, disarm traps, tunnel through rubble
 *   Pick up (or tunnel to) gold and useful objects
 *   Explore "interesting" grids, to expand the map
 *   Explore the dungeon and revisit old grids
 */
static bool borg_think_dungeon(void)
{
    /* EAW -- just in case */
  /*  borg_keypress(ESCAPE);
    borg_keypress(ESCAPE);
    borg_keypress(ESCAPE);
    borg_keypress(ESCAPE);
  */  
    /* Examine the screen */
    borg_update();

    /* MJC -- if >1000000 gold, enchant stuff to +10 */
    if (auto_gold > 1000000) {
	enchant_to = 10;
    }
    else {
	enchant_to = 9;
    }

    /* Analyze the inventory */
    borg_notice();

    /* EAW -- Reset light room flag if and only if in hallway */
    if (borg_count_non_walls(c_x, c_y) == 2) room_was_lit = FALSE;

    /* Paranoia -- catch death */
    if (!pg || !auto_active) return (TRUE);

    /* MJC -- hunger oops here, not in borg_use_things() */
    /* Hack -- Do NOT starve to death */
    if (panic_death && do_weak) {

	borg_oops("Starving.");
	return (TRUE);
    }

    /* Wear things that need to be worn */
    if (borg_wear_stuff()) return (TRUE);

    /* Use things */
    if (borg_use_things()) return (TRUE);

    /* Flee to the town when low on crucial supplies */
    if (borg_restock() && borg_recall()) return (TRUE);

    /* Flee the level after a long time */
    if ((c_t - auto_began > 50000L) && borg_recall()) return (TRUE);
    
    /* EAW -- deal with seeing himself */    
    if (do_multiple_players) {
	borg_keypress(ESCAPE);
	borg_keypress(ESCAPE);
	borg_keypress(ESCAPE);
	borg_keypress(ESCAPE);
	borg_keypress('5');
	do_multiple_players = FALSE;
	return(TRUE);
    }
    
    /*** Deal with monsters ***/

    /* Apply a tiny bit of chaos */
    if (rand_int(1000) == 0) {
	borg_keypress('0' + randint(9));
	return (TRUE);
    }

    /* Try not to get surrounded by monsters */
    if (borg_caution()) return (TRUE);

    /* EAW -- deal with hallucinations */
    if (p_ptr->image) {
	borg_keypress(ESCAPE);
	borg_keypress(ESCAPE);
	borg_keypress(ESCAPE);
	borg_keypress(ESCAPE);
	if (!rand_int(20)) borg_keypress('5');
    }

    /* Attack neighboring monsters */
    if (borg_attack()) return (TRUE);
    
    /* EAW -- deal with hallucinations even more */
    if (p_ptr->image) {
	return(TRUE);
    }
    
    /* Fire at nearby monsters */ /* EAW -- not adjacent */
    if (borg_play_fire()) return (TRUE);

    /* Continue flowing towards monsters */
    if (goal == GOAL_KILL) {
	if (borg_play_old_goal()) return (TRUE);
    }

    /* Apply a tiny amount of chaos */
    if (rand_int(200) == 0) {
	borg_keypress('0' + randint(9));
	return (TRUE);
    }

    /* Rest occasionally if damaged */
    /* EAW -- take mana into account too */
    if (((auto_curhp < auto_maxhp) || (mana_color != 13)) &&
	(rand_int(10) == 0)) {

	/* Take note */
	borg_note("Resting...");

	/* Rest until done */
	borg_keypress('R');
	borg_keypress('&');
	borg_keypress('\n');

	/* Done */
	return (TRUE);
    }

    /* Start a new one */
    if (borg_flow_kill()) {
	if (borg_play_old_goal()) return (TRUE);
    }


    /*** Deal with inventory objects ***/

    /* Use other things */
    if (borg_use_others()) return (TRUE);

    /* Identify unknown things */
    if (borg_test_stuff()) return (TRUE);

    /* EAW -- Identify unknown equipment */
    if (rand_int(100) == 0) {
	if (borg_test_equip()) return(TRUE);
    }

    /* Throw away junk */
    if (borg_throw_junk()) return (TRUE);

    /* Acquire free space */
    if (borg_free_space()) return (TRUE);


    /*** Flow towards objects ***/

    /* Hack -- beware of blindness and confusion */
    if ((do_blind || do_confused) && (rand_int(2) == 0)) {

	/* Take note */
	borg_note("Resting...");

	/* Rest until done */
	borg_keypress('R');
	borg_keypress('&');
	borg_keypress('\n');

	/* Done */
	return (TRUE);
    }
    
    /* Continue flowing to objects */
    if (goal == GOAL_TAKE) {
	if (borg_play_old_goal()) return (TRUE);
    }

    /* Rest occasionally, EAW -- take mana into account too */
    if (((auto_curhp < auto_maxhp) || (mana_color != 13)) &&
	(rand_int(2) == 0)) {

	/* Take note */
	borg_note("Resting...");

	/* Rest until done */
	borg_keypress('R');
	borg_keypress('&');
	borg_keypress('\n');

	/* Done */
	return (TRUE);
    }
     
    /* Start a new one */
    if (borg_flow_take()) {
	if (borg_play_old_goal()) return (TRUE);
    }


    /*** Exploration ***/

    /* Hack -- Search intersections for doors */
    if (borg_inspect()) return (TRUE);

    /* Continue flowing (explore) */
    if (goal == GOAL_DARK) {
	if (borg_play_old_goal()) return (TRUE);
    }

    /* Continue flowing (see below) */
    if (goal == GOAL_XTRA) {
	if (borg_play_old_goal()) return (TRUE);
    }


    /*** Try grids that are farther away ***/

    /* Chase old monsters */
    if (borg_flow_kill_any()) {
	if (borg_play_old_goal()) return (TRUE);
    }

    /* Chase old objects */
    if (borg_flow_take_any()) {
	if (borg_play_old_goal()) return (TRUE);
    }


    /*** Wander around ***/

    /* Hack -- occasionally update the "free room" list */
    /* if (rand_int(100) == 0) borg_free_room_update(); */

    /* Leave the level (if needed) */
    if (borg_leave_level(FALSE)) return (TRUE);

    /* Explore nearby interesting grids */
    if (borg_flow_dark()) {
	if (borg_play_old_goal()) return (TRUE);
    }

    /* Explore interesting grids */
    if (borg_flow_explore()) {
	if (borg_play_old_goal()) return (TRUE);
    }

    /* Hack -- Visit the shops */
    if (borg_flow_shop()) {
	if (borg_play_old_goal()) return (TRUE);
    }

#ifdef FRITS
    /* This seems like a good time to find out which spells I know! */
    borg_note("Check spells (maybe)");
    if ((do_gain_spells==TRUE) || (rand_int(20*auto_level)==0))
    {
       do_browse_books=TRUE;
       /* EAW -- Don't do if blind or confused! */
       if(!(do_blind | do_confused) && borg_can_gain_spell()==TRUE) 
       {
	 borg_note("DEBUG point (can_gain_spell was TRUE)");
	 return(TRUE);
       } else {
	 borg_note("DEBUG point (can_gain_spell was FALSE)");
       }
    }

#endif /* FRITS */

    /* Leave the level (if possible) */
    if (borg_leave_level(TRUE)) return (TRUE);

    /* Search for secret doors */
    if (borg_flow_spastic()) {
	if (borg_play_old_goal()) return (TRUE);
    }

    /* Re-visit old rooms */
    if (borg_flow_revisit()) {
	if (borg_play_old_goal()) return (TRUE);
    }


    /*** Oops ***/

    /* This is a bad thing */
    borg_note("Twitchy!");

    /* Try searching */
    if (rand_int(10) == 0) {

	/* Take note */
	borg_note("Searching...");

	/* Remember the search */
	if (pg->xtra < 100) pg->xtra += 9;

	/* Search */
	borg_keypress('0');
	borg_keypress('9');
	borg_keypress('s');

	/* Success */
	return (TRUE);
    }

    /* Mega-Hack -- Occasional tunnel */
    if (rand_int(100) == 0) {

	/* Tunnel a lot */
	borg_keypress('0');
	borg_keypress('9');
	borg_keypress('9');
	borg_keypress('T');

	/* In a legal direction */
	borg_keypress('0' + ddd[rand_int(8)]);
    }

    /* Move (or tunnel) */
    borg_keypress('0' + randint(9));

    /* We did something */
    return (TRUE);
}


/*
 * Think about the world and perform an action
 * Check inventory/equipment once per turn
 * Process "store" modes when necessary
 *
 * Note that the non-cheating "inventory" and "equipment" parsers
 * will get confused by a "weird" situation involving an ant ("a")
 * on line one of the screen, near the left, next to a shield, of
 * the same color, and using --(-- the ")" symbol, directly to the
 * right of the ant.  This is very rare, but perhaps not completely
 * impossible.  I ignore this situation.  :-)
 */
static bool borg_think(void)
{
    int i;

    byte t_a;

    char /* p1 = '(', */ p2 = ')';

    char buf[128];

    static bool do_inven = TRUE;
    static bool do_equip = TRUE;

    static bool do_panel = TRUE;


    /*** Process inventory/equipment ***/

    /* Cheat */
    if (cheat_inven) {

	/* Extract the inventory */
	for (i = 0; i < INVEN_TOTAL; i++) {

	    char buf[256];

	    /* Default to "nothing" */
	    buf[0] = '\0';

	    /* XXX XXX Extract a real item */
	    if (inventory[i].tval) {
		objdes(buf, &inventory[i], 3);
		buf[75] = '\0';
	    }

	    /* Ignore "unchanged" items */
	    if (streq(buf, auto_items[i].desc)) continue;

	    /* Analyze the item (no price) */
	    borg_item_analyze(&auto_items[i], buf, "");
	}

	/* No need to get the data */
	do_inven = do_equip = FALSE;
    }


    /* Hack -- Check for "inventory" mode */
    if ((0 == borg_what_text(0, 0, 10, &t_a, buf)) &&
       (streq(buf, "Equipment "))) {

	int row, col;

	bool done = FALSE;

	/* Find the column */
	for (col = 0; col < 55; col++) {

	    /* Look for first prefix */
	    if ((0 == borg_what_text_hack(col, 1, 3, &t_a, buf)) &&
		(buf[0] == 'a') && (buf[1] == p2) && (buf[2] == ' ')) {

		break;
	    }
	}

	/* Extract the inventory */
	for (i = INVEN_WIELD; i < INVEN_TOTAL; i++) {

	    /* Access the row */
	    row = i - INVEN_WIELD;

	    /* Attempt to get some text */
	    if (!done &&
		(0 == borg_what_text_hack(col, row+1, 3, &t_a, buf)) &&
		(buf[0] == 'a' + row) && (buf[1] == p2) && (buf[2] == ' ') &&
		(0 == borg_what_text(col+19, row+1, -80, &t_a, buf)) &&
		(buf[0] && (buf[0] != ' '))) {
		/* XXX Strip final spaces */
	    }

	    /* Default to "nothing" */
	    else {
		buf[0] = '\0';
		done = TRUE;
	    }

	    /* Use the nice "show_empty_slots" flag */
	    if (streq(buf, "(nothing)")) strcpy(buf, "");

	    /* Ignore "unchanged" items */
	    if (streq(buf, auto_items[i].desc)) continue;

	    /* Analyze the item (no price) */
	    borg_item_analyze(&auto_items[i], buf, "");
	}

	/* Hack -- leave this mode */
	borg_keypress(ESCAPE);

	/* Done */
	return (TRUE);
    }


    /* Hack -- Check for "inventory" mode */
    if ((0 == borg_what_text(0, 0, 10, &t_a, buf)) &&
       (streq(buf, "Inventory "))) {

	int row, col;

	bool done = FALSE;

	/* Find the column */
	for (col = 0; col < 55; col++) {

	    /* Look for first prefix */
	    if ((0 == borg_what_text_hack(col, 1, 3, &t_a, buf)) &&
		(buf[0] == 'a') && (buf[1] == p2) && (buf[2] == ' ')) {

		break;
	    }
	}

	/* Extract the inventory */
	for (i = 0; i < INVEN_PACK; i++) {

	    /* Access the row */
	    row = i;

	    /* Attempt to get some text */
	    if (!done &&
		(0 == borg_what_text_hack(col, row+1, 3, &t_a, buf)) &&
		(buf[0] == 'a' + row) && (buf[1] == p2) && (buf[2] == ' ') &&
		(0 == borg_what_text(col+3, row+1, -80, &t_a, buf)) &&
		(buf[0] && (buf[0] != ' '))) {
		/* XXX Strip final spaces */
	    }

	    /* Default to "nothing" */
	    else {
		buf[0] = '\0';
		done = TRUE;
	    }

	    /* Use the nice "show_empty_slots" flag */
	    /* if (streq(buf, "(nothing)")) strcpy(buf, ""); */

	    /* Ignore "unchanged" items */
	    if (streq(buf, auto_items[i].desc)) continue;

	    /* Analyze the item (no price) */
	    borg_item_analyze(&auto_items[i], buf, "");
	}

	/* Hack -- leave this mode */
	borg_keypress(ESCAPE);

	/* Done */
	return (TRUE);
    }


    /* Check equipment */
    if (do_equip) {
	do_equip = FALSE;
	borg_keypress('e');
	return (TRUE);
    }

    /* Check inventory */
    if (do_inven) {
	do_inven = FALSE;
	borg_keypress('i');
	return (TRUE);
    }



    /*** Handle stores ***/

    /* Hack -- Check for being in a store */
    if ((0 == borg_what_text(3, 5, 16, &t_a, buf)) &&
       (streq(buf, "Item Description"))) {

	/* Assume the Home */
	shop_num = 7;

	/* Extract the "store" name */
	if (0 == borg_what_text(50, 3, -20, &t_a, buf)) {

	    int i;

	    /* Check the store names */
	    for (i = 0; i < 7; i++) {
		cptr name = k_list[OBJ_STORE_LIST+i].name;
		if (streq(buf, name)) shop_num = i;
	    }
	}

#if 0
	/* Note the store */
	borg_note(format("Inside store '%d' (%s)", shop_num + 1,
			 k_list[OBJ_STORE_LIST+shop_num].name));
#endif

	/* Hack -- Check inventory/equipment again later */
	do_inven = do_equip = TRUE;

	/* Process the store */
	return (borg_think_store());
    }


    /*** Determine panel ***/

    /* Hack -- cheat */
    if (cheat_panel) {

	/* Cheat */
	w_y = panel_row * (SCREEN_HGT / 2);
	w_x = panel_col * (SCREEN_WID / 2);

	/* Done */
	do_panel = FALSE;
    }

    /* Hack -- Check for "sector" mode */
    if ((0 == borg_what_text(0, 0, 16, &t_a, buf)) &&
       (prefix(buf, "Map sector "))) {

	/* Hack -- get the panel info */
	w_y = (buf[12] - '0') * (SCREEN_HGT / 2);
	w_x = (buf[14] - '0') * (SCREEN_WID / 2);

	/* Leave panel mode */
	borg_keypress(ESCAPE);

	/* Done */
	return (TRUE);
    }

    /* Check equipment */
    if (do_panel) {
	do_panel = FALSE;
	borg_keypress('L');
	return (TRUE);
    }

#ifdef FRITS
    /* Am I browsing my spellbooks? */
    if ((0==borg_what_text(COL_SPELLINFO,ROW_SPELLBOOK,-12,&t_a,buf)) && 
       (streq(buf,"Lv Mana Fail"))) {
       borg_think_browse();
       return(TRUE);
    }

    /* Do I want to browse them? */
/*    borg_note(format("browse? %c nrbooks %d current %d",(do_browse_books?'y':'n'),nrbooks,current_book)); */
    if ((do_browse_books) && (nrbooks!=0) && !(do_blind | do_confused)) {
       /* don't know whether this is necessary */
     /* do_browse_books=FALSE; */
       borg_keypress('b');
       borg_keypress('a'+current_book);
       return(TRUE);
    }
#endif /* FRITS */

    /*** Re-activate Tests ***/

    /* Check inventory/equipment again later */
    do_inven = do_equip = TRUE;

    /* Check panel again later */
    do_panel = TRUE;

#ifdef FRITS
    /* Check spellbooks later, but NOT SO BLOODY OFTEN NEEDED */
/*    do_browse_books=FALSE;  */
#endif /* FRITS */

    /*** Actually Do Something ***/

    /* Repeat until done */
    while (auto_active) {

	/* Do domething */
	if (borg_think_dungeon()) break;
    }

    /* Assume success */
    return (TRUE);
}



/*
 * Hack -- Parse a message from the world
 *
 * Note that detecting failures is EXTREMELY important, to prevent
 * bizarre situations after failing to use a staff of perceptions,
 * which would otherwise go ahead and send the "item index" which
 * might be a legal command (such as "a" for "aim").
 *
 * Currently, nothing else must be parsed, though some interesting
 * possibilities suggest themselves... :-)
 */
static void borg_parse(char *msg)
{
    /* Log (if needed) */
    if (auto_fff) borg_info(format("Msg <%s>", msg));


    /* Detect various "failures" */
    if (prefix(msg, "You failed ")) {

	/* Mega-Hack -- flush the key-buffer */
	borg_flush();
    }

 #if 0

    /* Hit somebody */
    else if (prefix(msg, "You hit ")) {

	/* XXX Determine identity */
    }

    /* Miss somebody */
    else if (prefix(msg, "You miss ")) {

	/* XXX Determine identity */
    }

    /* Hack -- detect word of recall */
    else if (prefix(msg, "The air about you becomes charged.")) {

	/* Note the time */
	auto_recall = c_t;
    }

    /* Hack -- detect word of recall */
    else if (prefix(msg, "A tension leaves the air around you.")) {

	/* Hack -- Oops */
	auto_recall = 0;
    }

    /* Word of recall fizzles out */
    else if (prefix(msg, "You feel tension leave the air.")) {

	/* Note the time */
	auto_recall = 0;
    }

    /* Word of recall kicks in */
    else if (prefix(msg, "You feel yourself yanked ")) {

	/* Note the time */
	auto_recall = 0;
    }

#endif

    /* Feelings */
    else if (prefix(msg, "You feel there is something special")) {

	/* Hang around */
	attention = 2000L;
    }

    /* Feelings */
    else if (prefix(msg, "You have a superb feeling")) {

	/* Hang around */
	attention = 2000L;
    }

    /* Feelings */
    else if (prefix(msg, "You have an excellent feeling")) {

	/* Hang around */
	attention = 1500L;
    }

    /* Feelings */
    else if (prefix(msg, "You have a very good feeling")) {

	/* Hang around */
	attention = 1000L;
    }

    /* Feelings */
    else if (prefix(msg, "You have a good feeling")) {

	/* Hang around */
	attention = 500L;
    }

    /* Feelings */
    else if (prefix(msg, "You feel strangely lucky")) {

	/* Stair scum */
	attention = 200L;
    }

    /* Feelings */
    else if (prefix(msg, "You feel your luck is turning")) {

	/* Stair scum */
	attention = 200L;
    }

    /* Feelings */
    else if (prefix(msg, "You like the look of this place")) {

	/* Stair scum */
	attention = 200L;
    }

    /* Feelings */
    else if (prefix(msg, "This level can't be all bad")) {

	/* Stair scum */
	attention = 200L;
    }

    /* Feelings */
    else if (prefix(msg, "What a boring place")) {

	/* Stair scum */
	attention = 200L;
    }

    /* Feelings */
    else if (prefix(msg, "Looks like any other level")) {

	/* Stair scum */
	attention = 200L;
    }
}







/*
 * Maintain the "old" hook
 */
static errr (*Term_xtra_hook_old)(int n, int v) = NULL;


/*
 * Our own hook.  Allow thinking when no keys ready.
 */
static errr Term_xtra_borg(int n, int v)
{
    /* Hack -- Notice "NOISE" events (errors) */
    /* EAW -- BAD, keeps some of MY stuff from working, like when an untried 
       recharge spell is tried, '*' is hit, then 't' gives a beep */
/*    if (n == TERM_XTRA_NOISE) { */

	/* Hack -- Give a message and stop thinking */
/*        if (auto_active) borg_oops("Caught request for noise.");
    } */

    /* Hack -- The Borg pre-empts keypresses */
    while (auto_active && (n == TERM_XTRA_EVENT)) {

	int i, x, y;
	byte t_a;
	char buf[128];

	errr res = 0;

	bool visible;

	static inside = 0;


	/* Paranoia -- require main window */
	if (Term != term_screen) {
	    borg_oops("Bizarre request!");
	    break;
	}


	/* Paranoia -- prevent recursion */
	if (inside) {
	    borg_oops("Bizarre recursion!");
	    break;
	}


	/* XXX XXX XXX Mega-Hack -- Check the user */
	res = (*Term_xtra_hook_old)(TERM_XTRA_CHECK, v);


	/* Note that the cursor visibility determines whether the */
	/* game is asking us for a "command" or for some other key. */
	/* XXX XXX This requires that "hilite_player" be FALSE. */


	/* Hack -- Extract the cursor visibility */
	visible = (!Term_hide_cursor());
	if (visible) Term_show_cursor();


	/* XXX XXX XXX Mega-Hack -- Catch "-more-" messages */
	/* If the cursor is visible... */
	/* And the cursor is on the top line... */
	/* And there is text before the cursor... */
	/* And that text is "-more-" */
	if (visible &&
	    (0 == Term_locate(&x, &y)) && (y == 0) && (x >= 6) &&
	    (0 == borg_what_text(x-6, y, 6, &t_a, buf)) &&
	    (streq(buf, "-more-"))) {

	    int col = 0;

	    /* Get each message */
	    while ((0 == borg_what_text(col, 0, -80, &t_a, buf)) &&
		   (t_a == TERM_WHITE) && (buf[0] && (buf[0] != ' '))) {

		/* Advance the column */
		col += strlen(buf) + 1;

		/* Parse */
		borg_parse(buf);
	    }

	    /* Hack -- Clear the message */
	    Term_keypress(' ');

	    /* Done */
	    return (0);
	}

	/* XXX XXX XXX Mega-Hack -- catch normal messages */
	/* If the cursor is NOT visible... */
	/* And there is text on the first line... */
	if (!visible &&
	    (borg_what_text(0, 0, 1, &t_a, buf) == 0) &&
	    (t_a == TERM_WHITE) && (buf[0] && (buf[0] != ' '))) {

	    int col = 0;

	    /* Get each message */
	    while ((0 == borg_what_text(col, 0, -80, &t_a, buf)) &&
		   (t_a == TERM_WHITE) && (buf[0] && (buf[0] != ' '))) {

		/* Advance the column */
		col += strlen(buf) + 1;

		/* Parse */
		borg_parse(buf);
	    }

	    /* Hack -- Clear the message */
	    Term_keypress(' ');

	    /* Done */
	    return (0);
	}


	/* Check for a Borg keypress */
	i = borg_inkey();

	/* Take the next keypress */
	if (i) {

	    /* Enqueue the keypress */
	    Term_keypress(i);

	    /* Success */
	    return (0);
	}


	/* Wizard mode kills the Borg */
	if (wizard) auto_active = FALSE;


	/* Inside */
	inside++;

	/* Think until done */
	while (auto_active) {

	    /* Actually think */
	    if (borg_think()) break;
	}

	/* Outside */
	inside--;
    }


    /* Hack -- Usually just pass the call through */
    return ((*Term_xtra_hook_old)(n, v));
}




/*
 * Initialize the Borg
 */
void borg_init(void)
{
    int i;

    /* Only initialize once */
    if (auto_ready) return;

    /* Message */
    msg_print("Initializing the Borg...");

    /* Hack -- flush it */
    Term_fresh();

    /* Remember the "normal" event scanner */
    Term_xtra_hook_old = Term->xtra_hook;

    /* Cheat -- drop a hook into the "event scanner" */
    Term->xtra_hook = Term_xtra_borg;

    /* Make some arrays */
    C_MAKE(auto_is_take, 128, bool);
    C_MAKE(auto_is_kill, 128, bool);

    /* Optimize "strchr()" calls */
    for (i = 0; i < 128; i++) {

	/* Optimize "strchr(auto_str_take, ag->o_c)" */
	if (strchr("^+:;$*?!_-\\|/\"=~{([])},", i)) auto_is_take[i] = TRUE;

	/* Optimize "strchr(auto_str_kill, ag->o_c)" */
	else if (isalpha(i) || (i == '&')) auto_is_kill[i] = TRUE;
    }

#ifdef FRITS
    /* change it's name */
    borg_keypress('C');
    borg_keypress('c');
    borg_keypress('P'); borg_keypress('a'); borg_keypress('r');
    borg_keypress('s'); borg_keypress('i'); borg_keypress('v');
    borg_keypress('a'); borg_keypress('l'); borg_keypress(' ');
    borg_keypress('v'); borg_keypress('2'); borg_keypress('.');
    borg_keypress('0'); borg_keypress('\n'); borg_keypress(ESCAPE);
#endif /* FRITS */

    /* Init the other arrays */
    borg_init_arrays();

    /* Done initialization */
    msg_print("done.");

    /* Now it is ready */
    auto_ready = TRUE;
}


/*
 * Hack -- interact with the Borg.  Includes "initialization" call.
 */
void borg_mode(void)
{
    char cmd;


    /* Not initialized? */
    if (!auto_ready) return;

    /* Currently active? */
    if (auto_active) return;


    /* Get a special command */
    if (!get_com("Borg command: ", &cmd)) return;


    /* Command: Resume */
    if (cmd == 'r') {

	/* Activate (see below) */
	auto_active = TRUE;
    }

    /* Command: Restart -- use an "illegal" level */
    else if (cmd == 'z') {

	/* Activate (see below) */
	auto_active = TRUE;

	/* Hack -- restart the level */
	auto_depth = -1;
    }


    /* Start a new log file */
    else if (cmd == 'f') {

	char buf[1024];

	/* Close the log file */
	if (auto_fff) fclose(auto_fff);

	/* Make a new log file name */
	prt("Borg Log: ", 0, 0);

	/* Hack -- drop permissions */
	safe_setuid_drop();

	/* Get the name and open the log file */
	if (askfor(buf, 70)) auto_fff = fopen(buf, "w");

	/* Hack -- grab permissions */
	safe_setuid_grab();

	/* Failure */
	if (!auto_fff) msg_print("Cannot open that file.");
    }


    /* Command: toggle "cheat" for "inven"/"equip" */
    else if (cmd == 'i') {
	cheat_inven = !cheat_inven;
	msg_print(format("Borg -- cheat_inven is now %d.", cheat_inven));
    }

    /* Command: toggle "cheat" for "panel" */
    else if (cmd == 'p') {
	cheat_panel = !cheat_panel;
	msg_print(format("Borg -- cheat_panel is now %d.", cheat_panel));
    }


    /* Command: toggle "panic_death" */
    else if (cmd == 'd') {
	panic_death = !panic_death;
	msg_print(format("Borg -- panic_death is now %d.", panic_death));
    }

    /* Command: toggle "panic_stuff" */
    else if (cmd == 'j') {
	panic_stuff = !panic_stuff;
	msg_print(format("Borg -- panic_stuff is now %d.", panic_stuff));
    }


    /* Command: Show all Rooms (Containers) */
    else if (cmd == 's') {

	int k, x, y, xx, yy;

	int w_y = panel_row * (SCREEN_HGT / 2);
	int w_x = panel_col * (SCREEN_WID / 2);

	auto_room *ar;

	/* Examine all the rooms */
	for (y = w_y; y < w_y + SCREEN_HGT; y++) {
	    for (x = w_x; x < w_x + SCREEN_WID; x++) {

		/* Scan the rooms */
		for (ar = room(1,x,y); ar; ar = room(0,0,0)) {

		    /* Skip done rooms */
		    if ((ar->y1 < y) && (y > w_y)) continue;
		    if ((ar->x1 < x) && (x > w_x)) continue;

		    /* Hack -- hilite the room -- count draws */
		    for (yy = ar->y1; yy <= ar->y2; yy++) {     
			for (xx = ar->x1; xx <= ar->x2; xx++) { 
			    byte a = TERM_RED;
			    char c = '*';
			    if (grid(xx,yy)->info & BORG_VIEW) a = TERM_YELLOW;
			    if (grid(xx,yy)->o_c == ' ') c = '?';
			    mh_print_rel(c, a, 0, yy, xx);
			}
		    }

		    /* Describe and wait */
		    Term_putstr(0, 0, -1, TERM_WHITE,
				format("Room %d (%dx%d). ", ar->self,
				(1 + ar->x2 - ar->x1), (1 + ar->y2 - ar->y1)));

		    /* Get a key */
		    k = inkey();

		    /* Hack -- hilite the room -- count draws */
		    for (yy = ar->y1; yy <= ar->y2; yy++) {     
			for (xx = ar->x1; xx <= ar->x2; xx++) { 
			    lite_spot(yy, xx);
			}
		    }

		    /* Erase the prompt */
		    Term_erase(0, 0, 80-1, 0);

		    /* Flush the erase */
		    Term_fresh();

		    /* Leave the outer loop */
		    if (k == ESCAPE) x = y = 999;

		    /* Leave this loop */
		    if (k == ESCAPE) break;
		}
	    }
	}
    }

    /* Command: Rooms (Containers) */
    else if (cmd == 'c') {

	int n, w, h;

	auto_room *ar;

	int used = 0, n_1x1 = 0, n_1xN = 0, n_Nx1 = 0;
	int n_2x2 = 0, n_2xN = 0, n_Nx2 = 0, n_NxN = 0;

	/* Examine all the rooms */
	for (n = 0; n < AUTO_ROOMS; n++) {

	    /* Access the n'th room */
	    ar = &auto_rooms[n];

	    /* Skip "dead" rooms */
	    if (ar->free) continue;

	    /* Count the "used" rooms */
	    used++;

	    /* Extract the "size" */
	    w = 1 + ar->x2 - ar->x1;
	    h = 1 + ar->y2 - ar->y1;

	    /* Count the "singles" */
	    if ((w == 1) && (h == 1)) n_1x1++;
	    else if (w == 1) n_1xN++;
	    else if (h == 1) n_Nx1++;
	    else if ((w == 2) && (h == 2)) n_2x2++;
	    else if (w == 2) n_2xN++;
	    else if (h == 2) n_Nx2++;
	    else n_NxN++;
	}


	/* Display some info */ 
	msg_print(format("Rooms: %d/%d used.", used, auto_room_max));
	msg_print(format("Corridors: 1xN (%d), Nx1 (%d)", n_1xN, n_Nx1));
	msg_print(format("Thickies: 2x2 (%d), 2xN (%d), Nx2 (%d)",
			 n_2x2, n_2xN, n_Nx2));
	msg_print(format("Singles: %d.  Normals: %d.", n_1x1, n_NxN));
	msg_print(NULL);
    }

    /* Command: Grid Info */
    else if (cmd == 'g') {

	int x, y, n;

	auto_grid *ag;
	auto_room *ar;

	int tg = 0;
	int tr = 0;

	int cc[8];

	/* Count the crossing factors */
	cc[0] = cc[1] = cc[2] = cc[3] = cc[4] = cc[5] = cc[6] = cc[7] = 0;

	/* Total explored grids */
	for (y = 0; y < AUTO_MAX_Y; y++) {
	    for (x = 0; x < AUTO_MAX_X; x++) {

		/* Get the grid */
		ag = grid(x, y);

		/* Skip unknown grids */
		if (ag->o_c == ' ') continue;

		/* Count them */
		tg++;

		/* Count the rooms this grid is in */
		for (n = 0, ar = room(1,x,y); ar && (n<7); ar = room(0,0,0)) n++;

		/* Hack -- Mention some locations */
		if ((n > 1) && !cc[n]) {
		    msg_print(format("The grid at %d,%d is in %d rooms.", x, y, n));
		}

		/* Count them */
		if (n) tr++;

		/* Count the number of grids in that many rooms */
		cc[n]++;
	    }
	}

	/* Display some info */ 
	msg_print(format("Grids: %d known, %d in rooms.", tg, tr));
	msg_print(format("Roomies: %d, %d, %d, %d, %d, %d, %d, %d.",
			 cc[0], cc[1], cc[2], cc[3],
			 cc[4], cc[5], cc[6], cc[7]));
	msg_print(NULL);
    }


    /* Mega-Hack -- Activate Borg */
    if (auto_active) {

	/* Mega-Hack -- Turn off wizard mode */
	wizard = FALSE;

	/* Mega-Hack -- Redraw Everything */
	do_cmd_redraw();

	/* Mega-Hack -- Flush the borg key-queue */
	borg_flush();

	/* Mega-Hack -- make sure we are okay */
	borg_keypress(ESCAPE);
	borg_keypress(ESCAPE);
	borg_keypress(ESCAPE);
	borg_keypress(ESCAPE);

	/* Start a new level */
	if (auto_depth < 0) {

	    /* Mega-Hack -- ask for a feeling */
	    borg_keypress('^');
	    borg_keypress('F');
	}
    }
}


#endif

