#!/bin/csh -f
## ###################################################################### ##
##         Copyright IBM Corporation 1988,1991 - All Rights Reserved      ##
##        For full copyright information see:'andrew/config/COPYRITE'     ##
## ###################################################################### ##
# $Disclaimer: This software is part of version 6.1 of the 
# Andrew User Interface System and is 
# the property of IBM, Carnegie Mellon University, 
# and the other copyright holders.  The source 
# code of this version is for the sole use of 
# the individual named in ./config/allsys.h.  
# This source code is not to be redistributed.  
# Binary object code compiled or derived from 
# these sources is not to be distributed to non-
# members.  Members may have additional 
# distribution rights granted by prior written 
# permission of Carnegie Mellon University.
# 
# IBM, CARNEGIE MELLON UNIVERSITY, 
# AND THE OTHER COPYRIGHT HOLDERS
#  DISCLAIM ALL WARRANTIES WITH 
# REGARD TO THIS SOFTWARE, INCLUDING 
# ALL IMPLIED WARRANTIES OF MERCHANT-
# ABILITY AND FITNESS. IN 
# NO EVENT SHALL  IBM, CARNEGIE 
# MELLON UNIVERSITY, OR ANY OTHER 
# COPYRIGHT HOLDER BE LIABLE FOR 
# ANY SPECIAL, INDIRECT OR CONSE-
# QUENTIAL DAMAGES OR ANY DAMAGES 
# WHATSOEVER RESULTING FROM LOSS OF
# USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR
# OTHER TORTIOUS ACTION, ARISING OUT 
# OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.
#  $


################################################
set nonomatch
################################################
################################################
if ( $#argv < 3 || $#argv > 4) then
	echo 'usage: depends ${DEPEND} ${CLASS} ${INCLUDES} [${DEFINES}]'
	exit(1)
endif
################################################
set DEPEND=$1
set CLASS=$2
set INCLUDES="$3"
if ($#argv == 4) then
set DEFINES="$4"
else
set DEFINES=" "
endif

################################################
set CHFILES=`/bin/ls *.ch` 
set CFILES=`/bin/ls *.c`
if ( "$#CFILES" == 0 && "$#CHFILES" == 0 ) then
	echo "No Dependencies to Check...continuing...."
	exit(0)
endif
################################################
set TMP_MKFILE=/tmp/Dep1_$$
set CH_DEPENDS=/tmp/Dep2_$$
set C_DEPENDS=/tmp/Dep3_$$
set DEPENDS=.depends
################################################
mv Makefile Makefile.BAK
sed -n -e '1,/##### DEPENDENCY LINE - DO NOT DELETE #####/p' Makefile.BAK > Makefile
################################################
echo >! ${CH_DEPENDS}
if ( "$#CHFILES" != 0) then
	foreach i (${CHFILES})
		${CLASS} -M ${INCLUDES} ${i} | egrep : | egrep -v ":.*:" >> $CH_DEPENDS
		wait
	end
	cat Makefile ${CH_DEPENDS} >> ${TMP_MKFILE}
	set IHFILES=`echo ${CHFILES} | sed -e 's;\.ch;.ih;g'`
	make -f ${TMP_MKFILE} ${IHFILES} INCLUDES="${INCLUDES}"
endif
################################################
echo >! ${C_DEPENDS}
if ( "$#CFILES" != 0) then
	${DEPEND} -s "##### DEPENDENCY LINE - DO NOT DELETE #####" -- ${DEFINES} -- ${INCLUDES} -f ${C_DEPENDS} *.c
endif

sed -e 's/##### DEPENDENCY LINE - DO NOT DELETE #####//g' ${CH_DEPENDS} ${C_DEPENDS} >> Makefile

foreach i ( ${C_DEPENDS} ${CH_DEPENDS} ${TMP_MKFILE} )
    rm -f $i $i.bak
end
rm -f ${DEPENDS}.bak
