/*
    Copyright (C) 2000 - 2001 Kai Heitkamp, kai@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include <qvariant.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qprogressbar.h>
#include <qpushbutton.h>
#include <qtextedit.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

#include <klocale.h>

#include "imgprocout.h"

static const char* const imgprocout_image0_data[] = {
"32 32 37 1",
". c None",
"# c #000000",
"a c #000400",
"b c #080808",
"c c #101010",
"d c #101410",
"e c #181c18",
"f c #202020",
"g c #292829",
"h c #292c29",
"s c #313031",
"i c #313431",
"j c #393839",
"k c #414039",
"l c #414441",
"m c #4a4c4a",
"n c #525052",
"o c #5a5952",
"t c #5a595a",
"q c #5a5d5a",
"x c #838183",
"v c #a4a1a4",
"y c #bdbabd",
"w c #c5c2c5",
"u c #dedede",
"I c #e6e2de",
"H c #e6e2e6",
"G c #e6e6e6",
"F c #eeeae6",
"E c #eeeaee",
"D c #eeeeee",
"C c #f6f2ee",
"B c #f6f2f6",
"A c #f6f6f6",
"z c #fffaf6",
"r c #fffaff",
"p c #ffffff",
"....######abcdefghijklmno.......",
"....#ppppppppppppppppppmpq......",
"....#ppppppppppppprrrrrlppq.....",
"....#pppppppppprrrrrrrrkpppo....",
"....#pppstustsvpwxsstrryklmn....",
"....#pppppprrrrrrrrrzzAAyyym....",
"....#ppppprrrrrrrzAAAAAAAAAl....",
"....#ppp#vtAxvAxtv#Avx#tAAAk....",
"....#pprrrrrrAAAAAAAAAAAAAAj....",
"....#prrvt#tp#vpx#tvp#tpABBi....",
"....#rrrrrAAAAAAAABBBBBBBBBh....",
"....#rrr#txBvx#tBt#B#Bx#BBBg....",
"....#rrrAAAAAABBBBBBBCCCCCCf....",
"....#rrAAAAAABBBBBCCDDDDDDDe....",
"....#rAAvt#xt#vDt#xvD#vtDDDd....",
"....#zAAAABBBBBCDDDDDDDDDDDc....",
"....#AAA#tBx#tDv#xD#D#tDDEEb....",
"....#AAAABBBBCDDDDDDEEEEEEEa....",
"....#AAAstxBtsvBwxsstvEEEEE#....",
"....#AAABBBCDDDDDEEEEEFFFFF#....",
"....#AABBBCDDDDDEEEEFFFGGGG#....",
"....#AAB#vtxDvxxtv#Gvx#tGGG#....",
"....#ABBBCDDDDEEEEFGGGGGGGG#....",
"....#ABBstvDtssEstuxstGGGGG#....",
"....#ABBBDDDDEEEFFGGGGGHHHH#....",
"....#BBB#txDvx#tFt##txHvHHH#....",
"....#BBBCDDDDEEFFGGGGHHHIII#....",
"....#BBBCDDDDEEFGGGGHHHIIII#....",
"....#BBBCDDDEEEFGGGGHHIIuuu#....",
"....#BBBCDDDEEEFGGGGHHIIuuu#....",
"....#BBBCDDDEEEFGGGGHHIIuuu#....",
"....########################...."};

static const char* const imgprocout_image1_data[] = {
"397 24 134 2",
"#U c #00007b",
"#T c #00047b",
"#R c #00087b",
"#S c #080483",
"#Q c #080883",
"#6 c #080c7b",
"#N c #080c83",
"#5 c #08107b",
"#M c #081083",
"#P c #100c8b",
"#L c #101083",
"#O c #10108b",
"#J c #101483",
"#K c #10148b",
"#G c #101883",
"#I c #10188b",
"ad c #101c83",
"#F c #101c8b",
"ac c #10208b",
"#H c #18188b",
"#E c #181c8b",
"#C c #18208b",
"#D c #182094",
"#z c #18248b",
"#A c #182494",
"#4 c #18288b",
"#y c #20248b",
"#B c #202494",
"#x c #20288b",
"#w c #202894",
"#t c #202c94",
"#r c #203094",
"#8 c #20309c",
"#q c #203494",
"#v c #292c94",
"#u c #292c9c",
"#s c #29309c",
"#o c #293494",
"#p c #29349c",
"ab c #293894",
"#n c #29389c",
"#l c #293c9c",
"#i c #29409c",
"#k c #313c9c",
"#m c #313ca4",
"#h c #31409c",
"#j c #3140a4",
"#f c #31449c",
"#g c #3144a4",
"#e c #31489c",
"#d c #3148a4",
"#c c #3948a4",
"#b c #394ca4",
"#a c #394cac",
"#. c #3950a4",
".9 c #3950ac",
"#3 c #3955a4",
".8 c #3955ac",
"aa c #3959ac",
"## c #4150ac",
".7 c #4155ac",
"#2 c #4159a4",
".6 c #4159ac",
"#1 c #415da4",
".4 c #415dac",
"#7 c #415db4",
".2 c #4161ac",
".5 c #4a5dac",
".1 c #4a61ac",
".3 c #4a61b4",
".Z c #4a65ac",
".0 c #4a65b4",
"#0 c #4a69ac",
".X c #4a69b4",
".W c #5269b4",
".Y c #5269bd",
".V c #526db4",
".T c #526dbd",
".R c #5271b4",
".U c #5271bd",
".Q c #5275b4",
"#Z c #5279b4",
"a# c #5279bd",
".S c #5a71bd",
".P c #5a75bd",
".O c #5a79bd",
".L c #5a7dbd",
".M c #5a7dc5",
"#Y c #5a81bd",
".N c #627dc5",
".K c #6281bd",
".J c #6281c5",
".H c #6285c5",
".F c #6289c5",
".E c #628dc5",
"#X c #6a85c5",
".I c #6a85cd",
".G c #6a89cd",
".D c #6a8dcd",
".B c #6a91c5",
".C c #6a91cd",
".A c #6a95cd",
".y c #6a99cd",
".z c #7395cd",
".w c #7399cd",
".x c #7399d5",
".u c #739dcd",
".v c #739dd5",
".t c #73a1cd",
".r c #73a1d5",
"#W c #73a5cd",
".q c #73a5d5",
".s c #7ba1d5",
".p c #7ba5d5",
".o c #7baad5",
".n c #7baed5",
"#V c #7bb2d5",
".m c #83aede",
"a. c #83b2d5",
".l c #83b2de",
".j c #83b6de",
".g c #83bade",
".k c #8bb6de",
".i c #8bbade",
".h c #8bbae6",
".e c #8bbede",
".f c #8bbee6",
".d c #8bc2de",
".c c #8bc2e6",
"#9 c #8bc6e6",
".b c #94c2e6",
".# c #94c6e6",
".a c #94c6ee",
"Qt c #94caee",
"Qt.#Qt.#.a.#.a.#.a.b.#.c.#.c.b.c.b.d.b.d.b.e.c.e.f.e.f.g.f.g.f.g.h.i.h.j.h.j.h.j.k.j.j.l.j.l.j.l.l.l.l.m.l.m.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.r.u.v.u.v.w.v.w.x.y.x.z.x.A.x.A.z.A.z.A.A.B.A.B.C.B.C.D.C.D.C.D.D.E.D.E.D.F.D.F.F.F.G.H.G.H.I.H.H.H.H.J.H.K.J.K.J.L.J.M.J.L.J.L.N.L.M.O.L.O.L.O.O.O.O.P.O.P.O.P.P.Q.P.Q.P.R.P.R.R.R.S.T.U.V.T.V.T.V.T.W.T.X.Y.X.W.X.W.X.W.Z.W.0.0.Z.0.1.0.2.3.2.3.2.1.4.1.4.5.4.4.4.4.6.4.6.6.6.6.6.7.7.7.8.7.9.7#..7#..7#.###..9#.#a#b#a#b#a#c#b#c#b#c#b#d#c#d#c#e#c#f#d#f#g#f#g#f#g#h#g#i#j#i#j#i#j#k#j#l#m#l#m#l#k#n#l#n#n#n#n#n#n#o#n#o#n#o#p#q#p#r#p#r#s#r#r#t#u#t#v#t#v#w#t#w#w#w#w#x#w#y#w#z#w#A#w#z#B#z#B#z#A#C#A#C#D#C#C#C#C#E#C#F#E#F#E#F#E#G#E#G#H#G#I#G#H#J#I#J#K#J#J#L#J#L#J#M#L#M#L#N#O#N#O#N#P#N#N#Q#N#Q#N#R#Q#R#Q#R#Q#S#S#T#S#U#T#U#U#U#U#U#U",
".#.a.#.#.#.#.c.#.c.#.c.b.c.b.d.c.d.c.d.d.e.f.e.f.g.f.g.f.g.h.g.i.j.h.j.i.j.k.j.j.l.j.l.j.l.l#V.l.m.l.n.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.o.o.p.o#W.p.r.p.t.q.r.r.t.r.u.s.u.t.u.v.u.v.w.v.y.u.y.x.y.w.A.w.A.z.A.z.A.A.C.A.B.C.B.C.E.B.D.C.E.D.E.D.E.D.F.D.F.F.F.F.H.F.H#X.H.H.H.H.J.H.J.H#Y.J#Y.J.L.K.L.J.L.M.L.M.L.L.O.L.O.O.O.O#Z.O.P.O.Q.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.X.T.X.W.X.W.X.W.0.X#0.W.Z.X.Z.0.2.0.2.0.2.3.2.3.4.1.4.5#1.4.4.4#2.4.6.4.6.6.6.6#3.6.8.7#3.7#..7#..7#.###.#.#.#.#b#.#b#b#b#b#c#b#d#b#d#c#e#c#e#c#f#d#f#g#f#f#f#f#i#f#i#g#i#h#i#j#l#h#l#m#l#k#l#k#n#l#n#n#n#n#n#n#q#n#o#n#q#o#q#p#q#o#r#p#r#r#r#r#t#r#t#v#t#t#w#t#x#t#x#w#4#w#z#w#z#x#z#B#z#A#z#A#C#A#C#C#C#C#C#C#F#C#F#E#F#E#F#E#G#E#G#I#G#G#G#G#J#G#J#I#J#J#J#J#M#J#M#L#5#L#5#L#6#M#N#O#N#N#N#N#R#N#R#Q#R#Q#R#Q#T#Q#T#S#T#T#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.#.c.a.c.#.c.b.c.b.d.b.d.c.e.c.e.f.e.f.i.f.g.f.g.h.g.h.j.h.j.h.j.j.j.k.l.j.l.j.l.l.l.l.m.l.n.l.m.m.n.m.o.m.o.m.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.s.u.v.u.v.w.v.y.x.w.x.A.x.A.w.A.z.A.z.A.z.C.A.B.C.B.C.D.C.D.C.E.D.D.D.E.D.F.D.F.F.F.G.H.G.H#X.H#X.H.H.J.H.J.J#Y.J.L.J.L.J.L.J.L.N.L.L.O.M.O.L.O.O.O.O.P.O.P.O.Q.P.P.P.Q.P.R.P.R.R.R.U.T.S.T.T.V.T.V.T.X.T.X.W.X.W.X.W.X.W.Z.X.Z.0.Z.0.1.0.3.3.2.3.2.1.4.1.4.5.4.5.4.4.6#7.6.6.6.6.6.7.7.7.7.7#..7.9.7#..7#.###.###.#a#b#a#b#b#c#b#c#b#d#b#d#c#e#c#d#d#f#c#f#g#f#g#f#g#h#g#h#j#i#j#i#j#l#j#l#m#l#m#l#l#n#k#n#n#n#n#n#n#o#n#o#n#q#p#o#p#r#p#r#s#r#8#t#v#t#u#t#v#w#v#w#w#x#w#x#w#z#w#y#w#A#w#A#B#z#B#z#A#C#A#C#C#C#C#C#C#E#C#E#E#F#E#F#E#G#E#G#I#G#I#G#H#J#H#J#K#J#J#L#J#M#J#M#L#5#L#N#L#N#O#N#N#N#N#Q#N#Q#N#Q#Q#R#Q#R#Q#T#S#T#S#U#S#U#U#U#U#U#U",
".#.a.#.a#9.#.c.#.c.#.c.b.c.c.c.b.d.c.d.c.e.f.e.f.g.e.g.f.g.i.g.h.j.h.j.h.j.j.j.k.l.j.l.ja..la..l.n.l.m.l.n.m.n.m.o.n.o.n.o.o.o.o.o.o.o.o#W.o.q.p.t.p.r.p.r.r.r.r.u.r.u.r.u.v.u.v.y.v.w.v.y.w.y.x.A.w.A.z.A.A.A.z.B.A.B.C.B.C.E.C.E.C.D.D.E.D.E.D.F.D.F.F.F.F.H.F.H.H.H.H.H.H.J.H.K.H.K.J#Y.J.L.J.L.J.L.N.L.L.L.M.O.L.O.Oa#.Oa#.O.Q.O.P.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.W.T.X.W.X.W.X.X.0.W#0.X.Z.X.Z.0.1.0.2.0.2.3.2.3.4.1.4.4.4.4#1.4#2.4#2.4.6.6aa.6.8.6#3.7.8.7#..7#..7#..9#..9#.#.#b#.#b#b#b#b#d#b#d#b#e#c#d#c#e#d#f#c#f#f#f#f#f#f#h#f#i#f#i#h#i#h#l#j#l#m#l#m#l#l#n#k#n#n#n#nab#n#o#n#qab#o#o#q#o#q#p#r#o#r#8#r#r#t#r#t#t#t#t#w#t#w#t#4#w#x#w#z#x#z#w#z#B#z#B#z#A#C#A#C#C#C#Cac#C#F#C#F#E#F#Ead#E#G#E#G#I#G#I#G#G#J#G#J#I#J#J#J#J#M#J#5#L#M#L#5#M#6#L#N#M#N#N#N#N#Q#N#R#Q#R#Q#R#Q#T#Q#T#S#T#S#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.a.b.#.c.#.c.b.c.b.d.b.d.b.e.c.e.f.e.f.g.f.g.f.g.h.i.h.j.h.j.h.j.k.j.j.l.j.l.j.l.l.l.l.m.l.m.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.r.u.v.u.v.w.v.w.x.y.x.z.x.A.x.A.z.A.z.A.A.B.A.B.C.B.C.D.C.D.C.D.D.E.D.E.D.F.D.F.F.F.G.H.G.H.I.H.H.H.H.J.H.K.J.K.J.L.J.M.J.L.J.L.N.L.M.O.L.O.L.O.O.O.O.P.O.P.O.P.P.Q.P.Q.P.R.P.R.R.R.S.T.U.V.T.V.T.V.T.W.T.X.Y.X.W.X.W.X.W.Z.W.0.0.Z.0.1.0.2.3.2.3.2.1.4.1.4.5.4.4.4.4.6.4.6.6.6.6.6.7.7.7.8.7.9.7#..7#..7#.###..9#.#a#b#a#b#a#c#b#c#b#c#b#d#c#d#c#e#c#f#d#f#g#f#g#f#g#h#g#i#j#i#j#i#j#k#j#l#m#l#m#l#k#n#l#n#n#n#n#n#n#o#n#o#n#o#p#q#p#r#p#r#s#r#r#t#u#t#v#t#v#w#t#w#w#w#w#x#w#y#w#z#w#A#w#z#B#z#B#z#A#C#A#C#D#C#C#C#C#E#C#F#E#F#E#F#E#G#E#G#H#G#I#G#H#J#I#J#K#J#J#L#J#L#J#M#L#M#L#N#O#N#O#N#P#N#N#Q#N#Q#N#R#Q#R#Q#R#Q#S#S#T#S#U#T#U#U#U#U#U#U",
".#.a.#.#.#.#.c.#.c.#.c.b.c.b.d.c.d.c.d.d.e.f.e.f.g.f.g.f.g.h.g.i.j.h.j.i.j.k.j.j.l.j.l.j.l.l#V.l.m.l.n.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.o.o.p.o#W.p.r.p.t.q.r.r.t.r.u.s.u.t.u.v.u.v.w.v.y.u.y.x.y.w.A.w.A.z.A.z.A.A.C.A.B.C.B.C.E.B.D.C.E.D.E.D.E.D.F.D.F.F.F.F.H.F.H#X.H.H.H.H.J.H.J.H#Y.J#Y.J.L.K.L.J.L.M.L.M.L.L.O.L.O.O.O.O#Z.O.P.O.Q.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.X.T.X.W.X.W.X.W.0.X#0.W.Z.X.Z.0.2.0.2.0.2.3.2.3.4.1.4.5#1.4.4.4#2.4.6.4.6.6.6.6#3.6.8.7#3.7#..7#..7#.###.#.#.#.#b#.#b#b#b#b#c#b#d#b#d#c#e#c#e#c#f#d#f#g#f#f#f#f#i#f#i#g#i#h#i#j#l#h#l#m#l#k#l#k#n#l#n#n#n#n#n#n#q#n#o#n#q#o#q#p#q#o#r#p#r#r#r#r#t#r#t#v#t#t#w#t#x#t#x#w#4#w#z#w#z#x#z#B#z#A#z#A#C#A#C#C#C#C#C#C#F#C#F#E#F#E#F#E#G#E#G#I#G#G#G#G#J#G#J#I#J#J#J#J#M#J#M#L#5#L#5#L#6#M#N#O#N#N#N#N#R#N#R#Q#R#Q#R#Q#T#Q#T#S#T#T#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.#.c.a.c.#.c.b.c.b.d.b.d.c.e.c.e.f.e.f.i.f.g.f.g.h.g.h.j.h.j.h.j.j.j.k.l.j.l.j.l.l.l.l.m.l.n.l.m.m.n.m.o.m.o.m.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.s.u.v.u.v.w.v.y.x.w.x.A.x.A.w.A.z.A.z.A.z.C.A.B.C.B.C.D.C.D.C.E.D.D.D.E.D.F.D.F.F.F.G.H.G.H#X.H#X.H.H.J.H.J.J#Y.J.L.J.L.J.L.J.L.N.L.L.O.M.O.L.O.O.O.O.P.O.P.O.Q.P.P.P.Q.P.R.P.R.R.R.U.T.S.T.T.V.T.V.T.X.T.X.W.X.W.X.W.X.W.Z.X.Z.0.Z.0.1.0.3.3.2.3.2.1.4.1.4.5.4.5.4.4.6#7.6.6.6.6.6.7.7.7.7.7#..7.9.7#..7#.###.###.#a#b#a#b#b#c#b#c#b#d#b#d#c#e#c#d#d#f#c#f#g#f#g#f#g#h#g#h#j#i#j#i#j#l#j#l#m#l#m#l#l#n#k#n#n#n#n#n#n#o#n#o#n#q#p#o#p#r#p#r#s#r#8#t#v#t#u#t#v#w#v#w#w#x#w#x#w#z#w#y#w#A#w#A#B#z#B#z#A#C#A#C#C#C#C#C#C#E#C#E#E#F#E#F#E#G#E#G#I#G#I#G#H#J#H#J#K#J#J#L#J#M#J#M#L#5#L#N#L#N#O#N#N#N#N#Q#N#Q#N#Q#Q#R#Q#R#Q#T#S#T#S#U#S#U#U#U#U#U#U",
".#.a.#.a#9.#.c.#.c.#.c.b.c.c.c.b.d.c.d.c.e.f.e.f.g.e.g.f.g.i.g.h.j.h.j.h.j.j.j.k.l.j.l.ja..la..l.n.l.m.l.n.m.n.m.o.n.o.n.o.o.o.o.o.o.o.o#W.o.q.p.t.p.r.p.r.r.r.r.u.r.u.r.u.v.u.v.y.v.w.v.y.w.y.x.A.w.A.z.A.A.A.z.B.A.B.C.B.C.E.C.E.C.D.D.E.D.E.D.F.D.F.F.F.F.H.F.H.H.H.H.H.H.J.H.K.H.K.J#Y.J.L.J.L.J.L.N.L.L.L.M.O.L.O.Oa#.Oa#.O.Q.O.P.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.W.T.X.W.X.W.X.X.0.W#0.X.Z.X.Z.0.1.0.2.0.2.3.2.3.4.1.4.4.4.4#1.4#2.4#2.4.6.6aa.6.8.6#3.7.8.7#..7#..7#..9#..9#.#.#b#.#b#b#b#b#d#b#d#b#e#c#d#c#e#d#f#c#f#f#f#f#f#f#h#f#i#f#i#h#i#h#l#j#l#m#l#m#l#l#n#k#n#n#n#nab#n#o#n#qab#o#o#q#o#q#p#r#o#r#8#r#r#t#r#t#t#t#t#w#t#w#t#4#w#x#w#z#x#z#w#z#B#z#B#z#A#C#A#C#C#C#Cac#C#F#C#F#E#F#Ead#E#G#E#G#I#G#I#G#G#J#G#J#I#J#J#J#J#M#J#5#L#M#L#5#M#6#L#N#M#N#N#N#N#Q#N#R#Q#R#Q#R#Q#T#Q#T#S#T#S#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.a.b.#.c.#.c.b.c.b.d.b.d.b.e.c.e.f.e.f.g.f.g.f.g.h.i.h.j.h.j.h.j.k.j.j.l.j.l.j.l.l.l.l.m.l.m.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.r.u.v.u.v.w.v.w.x.y.x.z.x.A.x.A.z.A.z.A.A.B.A.B.C.B.C.D.C.D.C.D.D.E.D.E.D.F.D.F.F.F.G.H.G.H.I.H.H.H.H.J.H.K.J.K.J.L.J.M.J.L.J.L.N.L.M.O.L.O.L.O.O.O.O.P.O.P.O.P.P.Q.P.Q.P.R.P.R.R.R.S.T.U.V.T.V.T.V.T.W.T.X.Y.X.W.X.W.X.W.Z.W.0.0.Z.0.1.0.2.3.2.3.2.1.4.1.4.5.4.4.4.4.6.4.6.6.6.6.6.7.7.7.8.7.9.7#..7#..7#.###..9#.#a#b#a#b#a#c#b#c#b#c#b#d#c#d#c#e#c#f#d#f#g#f#g#f#g#h#g#i#j#i#j#i#j#k#j#l#m#l#m#l#k#n#l#n#n#n#n#n#n#o#n#o#n#o#p#q#p#r#p#r#s#r#r#t#u#t#v#t#v#w#t#w#w#w#w#x#w#y#w#z#w#A#w#z#B#z#B#z#A#C#A#C#D#C#C#C#C#E#C#F#E#F#E#F#E#G#E#G#H#G#I#G#H#J#I#J#K#J#J#L#J#L#J#M#L#M#L#N#O#N#O#N#P#N#N#Q#N#Q#N#R#Q#R#Q#R#Q#S#S#T#S#U#T#U#U#U#U#U#U",
".#.a.#.#.#.#.c.#.c.#.c.b.c.b.d.c.d.c.d.d.e.f.e.f.g.f.g.f.g.h.g.i.j.h.j.i.j.k.j.j.l.j.l.j.l.l#V.l.m.l.n.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.o.o.p.o#W.p.r.p.t.q.r.r.t.r.u.s.u.t.u.v.u.v.w.v.y.u.y.x.y.w.A.w.A.z.A.z.A.A.C.A.B.C.B.C.E.B.D.C.E.D.E.D.E.D.F.D.F.F.F.F.H.F.H#X.H.H.H.H.J.H.J.H#Y.J#Y.J.L.K.L.J.L.M.L.M.L.L.O.L.O.O.O.O#Z.O.P.O.Q.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.X.T.X.W.X.W.X.W.0.X#0.W.Z.X.Z.0.2.0.2.0.2.3.2.3.4.1.4.5#1.4.4.4#2.4.6.4.6.6.6.6#3.6.8.7#3.7#..7#..7#.###.#.#.#.#b#.#b#b#b#b#c#b#d#b#d#c#e#c#e#c#f#d#f#g#f#f#f#f#i#f#i#g#i#h#i#j#l#h#l#m#l#k#l#k#n#l#n#n#n#n#n#n#q#n#o#n#q#o#q#p#q#o#r#p#r#r#r#r#t#r#t#v#t#t#w#t#x#t#x#w#4#w#z#w#z#x#z#B#z#A#z#A#C#A#C#C#C#C#C#C#F#C#F#E#F#E#F#E#G#E#G#I#G#G#G#G#J#G#J#I#J#J#J#J#M#J#M#L#5#L#5#L#6#M#N#O#N#N#N#N#R#N#R#Q#R#Q#R#Q#T#Q#T#S#T#T#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.#.c.a.c.#.c.b.c.b.d.b.d.c.e.c.e.f.e.f.i.f.g.f.g.h.g.h.j.h.j.h.j.j.j.k.l.j.l.j.l.l.l.l.m.l.n.l.m.m.n.m.o.m.o.m.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.s.u.v.u.v.w.v.y.x.w.x.A.x.A.w.A.z.A.z.A.z.C.A.B.C.B.C.D.C.D.C.E.D.D.D.E.D.F.D.F.F.F.G.H.G.H#X.H#X.H.H.J.H.J.J#Y.J.L.J.L.J.L.J.L.N.L.L.O.M.O.L.O.O.O.O.P.O.P.O.Q.P.P.P.Q.P.R.P.R.R.R.U.T.S.T.T.V.T.V.T.X.T.X.W.X.W.X.W.X.W.Z.X.Z.0.Z.0.1.0.3.3.2.3.2.1.4.1.4.5.4.5.4.4.6#7.6.6.6.6.6.7.7.7.7.7#..7.9.7#..7#.###.###.#a#b#a#b#b#c#b#c#b#d#b#d#c#e#c#d#d#f#c#f#g#f#g#f#g#h#g#h#j#i#j#i#j#l#j#l#m#l#m#l#l#n#k#n#n#n#n#n#n#o#n#o#n#q#p#o#p#r#p#r#s#r#8#t#v#t#u#t#v#w#v#w#w#x#w#x#w#z#w#y#w#A#w#A#B#z#B#z#A#C#A#C#C#C#C#C#C#E#C#E#E#F#E#F#E#G#E#G#I#G#I#G#H#J#H#J#K#J#J#L#J#M#J#M#L#5#L#N#L#N#O#N#N#N#N#Q#N#Q#N#Q#Q#R#Q#R#Q#T#S#T#S#U#S#U#U#U#U#U#U",
".#.a.#.a#9.#.c.#.c.#.c.b.c.c.c.b.d.c.d.c.e.f.e.f.g.e.g.f.g.i.g.h.j.h.j.h.j.j.j.k.l.j.l.ja..la..l.n.l.m.l.n.m.n.m.o.n.o.n.o.o.o.o.o.o.o.o#W.o.q.p.t.p.r.p.r.r.r.r.u.r.u.r.u.v.u.v.y.v.w.v.y.w.y.x.A.w.A.z.A.A.A.z.B.A.B.C.B.C.E.C.E.C.D.D.E.D.E.D.F.D.F.F.F.F.H.F.H.H.H.H.H.H.J.H.K.H.K.J#Y.J.L.J.L.J.L.N.L.L.L.M.O.L.O.Oa#.Oa#.O.Q.O.P.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.W.T.X.W.X.W.X.X.0.W#0.X.Z.X.Z.0.1.0.2.0.2.3.2.3.4.1.4.4.4.4#1.4#2.4#2.4.6.6aa.6.8.6#3.7.8.7#..7#..7#..9#..9#.#.#b#.#b#b#b#b#d#b#d#b#e#c#d#c#e#d#f#c#f#f#f#f#f#f#h#f#i#f#i#h#i#h#l#j#l#m#l#m#l#l#n#k#n#n#n#nab#n#o#n#qab#o#o#q#o#q#p#r#o#r#8#r#r#t#r#t#t#t#t#w#t#w#t#4#w#x#w#z#x#z#w#z#B#z#B#z#A#C#A#C#C#C#Cac#C#F#C#F#E#F#Ead#E#G#E#G#I#G#I#G#G#J#G#J#I#J#J#J#J#M#J#5#L#M#L#5#M#6#L#N#M#N#N#N#N#Q#N#R#Q#R#Q#R#Q#T#Q#T#S#T#S#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.a.b.#.c.#.c.b.c.b.d.b.d.b.e.c.e.f.e.f.g.f.g.f.g.h.i.h.j.h.j.h.j.k.j.j.l.j.l.j.l.l.l.l.m.l.m.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.r.u.v.u.v.w.v.w.x.y.x.z.x.A.x.A.z.A.z.A.A.B.A.B.C.B.C.D.C.D.C.D.D.E.D.E.D.F.D.F.F.F.G.H.G.H.I.H.H.H.H.J.H.K.J.K.J.L.J.M.J.L.J.L.N.L.M.O.L.O.L.O.O.O.O.P.O.P.O.P.P.Q.P.Q.P.R.P.R.R.R.S.T.U.V.T.V.T.V.T.W.T.X.Y.X.W.X.W.X.W.Z.W.0.0.Z.0.1.0.2.3.2.3.2.1.4.1.4.5.4.4.4.4.6.4.6.6.6.6.6.7.7.7.8.7.9.7#..7#..7#.###..9#.#a#b#a#b#a#c#b#c#b#c#b#d#c#d#c#e#c#f#d#f#g#f#g#f#g#h#g#i#j#i#j#i#j#k#j#l#m#l#m#l#k#n#l#n#n#n#n#n#n#o#n#o#n#o#p#q#p#r#p#r#s#r#r#t#u#t#v#t#v#w#t#w#w#w#w#x#w#y#w#z#w#A#w#z#B#z#B#z#A#C#A#C#D#C#C#C#C#E#C#F#E#F#E#F#E#G#E#G#H#G#I#G#H#J#I#J#K#J#J#L#J#L#J#M#L#M#L#N#O#N#O#N#P#N#N#Q#N#Q#N#R#Q#R#Q#R#Q#S#S#T#S#U#T#U#U#U#U#U#U",
".#.a.#.#.#.#.c.#.c.#.c.b.c.b.d.c.d.c.d.d.e.f.e.f.g.f.g.f.g.h.g.i.j.h.j.i.j.k.j.j.l.j.l.j.l.l#V.l.m.l.n.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.o.o.p.o#W.p.r.p.t.q.r.r.t.r.u.s.u.t.u.v.u.v.w.v.y.u.y.x.y.w.A.w.A.z.A.z.A.A.C.A.B.C.B.C.E.B.D.C.E.D.E.D.E.D.F.D.F.F.F.F.H.F.H#X.H.H.H.H.J.H.J.H#Y.J#Y.J.L.K.L.J.L.M.L.M.L.L.O.L.O.O.O.O#Z.O.P.O.Q.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.X.T.X.W.X.W.X.W.0.X#0.W.Z.X.Z.0.2.0.2.0.2.3.2.3.4.1.4.5#1.4.4.4#2.4.6.4.6.6.6.6#3.6.8.7#3.7#..7#..7#.###.#.#.#.#b#.#b#b#b#b#c#b#d#b#d#c#e#c#e#c#f#d#f#g#f#f#f#f#i#f#i#g#i#h#i#j#l#h#l#m#l#k#l#k#n#l#n#n#n#n#n#n#q#n#o#n#q#o#q#p#q#o#r#p#r#r#r#r#t#r#t#v#t#t#w#t#x#t#x#w#4#w#z#w#z#x#z#B#z#A#z#A#C#A#C#C#C#C#C#C#F#C#F#E#F#E#F#E#G#E#G#I#G#G#G#G#J#G#J#I#J#J#J#J#M#J#M#L#5#L#5#L#6#M#N#O#N#N#N#N#R#N#R#Q#R#Q#R#Q#T#Q#T#S#T#T#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.#.c.a.c.#.c.b.c.b.d.b.d.c.e.c.e.f.e.f.i.f.g.f.g.h.g.h.j.h.j.h.j.j.j.k.l.j.l.j.l.l.l.l.m.l.n.l.m.m.n.m.o.m.o.m.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.s.u.v.u.v.w.v.y.x.w.x.A.x.A.w.A.z.A.z.A.z.C.A.B.C.B.C.D.C.D.C.E.D.D.D.E.D.F.D.F.F.F.G.H.G.H#X.H#X.H.H.J.H.J.J#Y.J.L.J.L.J.L.J.L.N.L.L.O.M.O.L.O.O.O.O.P.O.P.O.Q.P.P.P.Q.P.R.P.R.R.R.U.T.S.T.T.V.T.V.T.X.T.X.W.X.W.X.W.X.W.Z.X.Z.0.Z.0.1.0.3.3.2.3.2.1.4.1.4.5.4.5.4.4.6#7.6.6.6.6.6.7.7.7.7.7#..7.9.7#..7#.###.###.#a#b#a#b#b#c#b#c#b#d#b#d#c#e#c#d#d#f#c#f#g#f#g#f#g#h#g#h#j#i#j#i#j#l#j#l#m#l#m#l#l#n#k#n#n#n#n#n#n#o#n#o#n#q#p#o#p#r#p#r#s#r#8#t#v#t#u#t#v#w#v#w#w#x#w#x#w#z#w#y#w#A#w#A#B#z#B#z#A#C#A#C#C#C#C#C#C#E#C#E#E#F#E#F#E#G#E#G#I#G#I#G#H#J#H#J#K#J#J#L#J#M#J#M#L#5#L#N#L#N#O#N#N#N#N#Q#N#Q#N#Q#Q#R#Q#R#Q#T#S#T#S#U#S#U#U#U#U#U#U",
".#.a.#.a#9.#.c.#.c.#.c.b.c.c.c.b.d.c.d.c.e.f.e.f.g.e.g.f.g.i.g.h.j.h.j.h.j.j.j.k.l.j.l.ja..la..l.n.l.m.l.n.m.n.m.o.n.o.n.o.o.o.o.o.o.o.o#W.o.q.p.t.p.r.p.r.r.r.r.u.r.u.r.u.v.u.v.y.v.w.v.y.w.y.x.A.w.A.z.A.A.A.z.B.A.B.C.B.C.E.C.E.C.D.D.E.D.E.D.F.D.F.F.F.F.H.F.H.H.H.H.H.H.J.H.K.H.K.J#Y.J.L.J.L.J.L.N.L.L.L.M.O.L.O.Oa#.Oa#.O.Q.O.P.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.W.T.X.W.X.W.X.X.0.W#0.X.Z.X.Z.0.1.0.2.0.2.3.2.3.4.1.4.4.4.4#1.4#2.4#2.4.6.6aa.6.8.6#3.7.8.7#..7#..7#..9#..9#.#.#b#.#b#b#b#b#d#b#d#b#e#c#d#c#e#d#f#c#f#f#f#f#f#f#h#f#i#f#i#h#i#h#l#j#l#m#l#m#l#l#n#k#n#n#n#nab#n#o#n#qab#o#o#q#o#q#p#r#o#r#8#r#r#t#r#t#t#t#t#w#t#w#t#4#w#x#w#z#x#z#w#z#B#z#B#z#A#C#A#C#C#C#Cac#C#F#C#F#E#F#Ead#E#G#E#G#I#G#I#G#G#J#G#J#I#J#J#J#J#M#J#5#L#M#L#5#M#6#L#N#M#N#N#N#N#Q#N#R#Q#R#Q#R#Q#T#Q#T#S#T#S#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.a.b.#.c.#.c.b.c.b.d.b.d.b.e.c.e.f.e.f.g.f.g.f.g.h.i.h.j.h.j.h.j.k.j.j.l.j.l.j.l.l.l.l.m.l.m.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.r.u.v.u.v.w.v.w.x.y.x.z.x.A.x.A.z.A.z.A.A.B.A.B.C.B.C.D.C.D.C.D.D.E.D.E.D.F.D.F.F.F.G.H.G.H.I.H.H.H.H.J.H.K.J.K.J.L.J.M.J.L.J.L.N.L.M.O.L.O.L.O.O.O.O.P.O.P.O.P.P.Q.P.Q.P.R.P.R.R.R.S.T.U.V.T.V.T.V.T.W.T.X.Y.X.W.X.W.X.W.Z.W.0.0.Z.0.1.0.2.3.2.3.2.1.4.1.4.5.4.4.4.4.6.4.6.6.6.6.6.7.7.7.8.7.9.7#..7#..7#.###..9#.#a#b#a#b#a#c#b#c#b#c#b#d#c#d#c#e#c#f#d#f#g#f#g#f#g#h#g#i#j#i#j#i#j#k#j#l#m#l#m#l#k#n#l#n#n#n#n#n#n#o#n#o#n#o#p#q#p#r#p#r#s#r#r#t#u#t#v#t#v#w#t#w#w#w#w#x#w#y#w#z#w#A#w#z#B#z#B#z#A#C#A#C#D#C#C#C#C#E#C#F#E#F#E#F#E#G#E#G#H#G#I#G#H#J#I#J#K#J#J#L#J#L#J#M#L#M#L#N#O#N#O#N#P#N#N#Q#N#Q#N#R#Q#R#Q#R#Q#S#S#T#S#U#T#U#U#U#U#U#U",
".#.a.#.#.#.#.c.#.c.#.c.b.c.b.d.c.d.c.d.d.e.f.e.f.g.f.g.f.g.h.g.i.j.h.j.i.j.k.j.j.l.j.l.j.l.l#V.l.m.l.n.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.o.o.p.o#W.p.r.p.t.q.r.r.t.r.u.s.u.t.u.v.u.v.w.v.y.u.y.x.y.w.A.w.A.z.A.z.A.A.C.A.B.C.B.C.E.B.D.C.E.D.E.D.E.D.F.D.F.F.F.F.H.F.H#X.H.H.H.H.J.H.J.H#Y.J#Y.J.L.K.L.J.L.M.L.M.L.L.O.L.O.O.O.O#Z.O.P.O.Q.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.X.T.X.W.X.W.X.W.0.X#0.W.Z.X.Z.0.2.0.2.0.2.3.2.3.4.1.4.5#1.4.4.4#2.4.6.4.6.6.6.6#3.6.8.7#3.7#..7#..7#.###.#.#.#.#b#.#b#b#b#b#c#b#d#b#d#c#e#c#e#c#f#d#f#g#f#f#f#f#i#f#i#g#i#h#i#j#l#h#l#m#l#k#l#k#n#l#n#n#n#n#n#n#q#n#o#n#q#o#q#p#q#o#r#p#r#r#r#r#t#r#t#v#t#t#w#t#x#t#x#w#4#w#z#w#z#x#z#B#z#A#z#A#C#A#C#C#C#C#C#C#F#C#F#E#F#E#F#E#G#E#G#I#G#G#G#G#J#G#J#I#J#J#J#J#M#J#M#L#5#L#5#L#6#M#N#O#N#N#N#N#R#N#R#Q#R#Q#R#Q#T#Q#T#S#T#T#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.#.c.a.c.#.c.b.c.b.d.b.d.c.e.c.e.f.e.f.i.f.g.f.g.h.g.h.j.h.j.h.j.j.j.k.l.j.l.j.l.l.l.l.m.l.n.l.m.m.n.m.o.m.o.m.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.s.u.v.u.v.w.v.y.x.w.x.A.x.A.w.A.z.A.z.A.z.C.A.B.C.B.C.D.C.D.C.E.D.D.D.E.D.F.D.F.F.F.G.H.G.H#X.H#X.H.H.J.H.J.J#Y.J.L.J.L.J.L.J.L.N.L.L.O.M.O.L.O.O.O.O.P.O.P.O.Q.P.P.P.Q.P.R.P.R.R.R.U.T.S.T.T.V.T.V.T.X.T.X.W.X.W.X.W.X.W.Z.X.Z.0.Z.0.1.0.3.3.2.3.2.1.4.1.4.5.4.5.4.4.6#7.6.6.6.6.6.7.7.7.7.7#..7.9.7#..7#.###.###.#a#b#a#b#b#c#b#c#b#d#b#d#c#e#c#d#d#f#c#f#g#f#g#f#g#h#g#h#j#i#j#i#j#l#j#l#m#l#m#l#l#n#k#n#n#n#n#n#n#o#n#o#n#q#p#o#p#r#p#r#s#r#8#t#v#t#u#t#v#w#v#w#w#x#w#x#w#z#w#y#w#A#w#A#B#z#B#z#A#C#A#C#C#C#C#C#C#E#C#E#E#F#E#F#E#G#E#G#I#G#I#G#H#J#H#J#K#J#J#L#J#M#J#M#L#5#L#N#L#N#O#N#N#N#N#Q#N#Q#N#Q#Q#R#Q#R#Q#T#S#T#S#U#S#U#U#U#U#U#U",
".#.a.#.a#9.#.c.#.c.#.c.b.c.c.c.b.d.c.d.c.e.f.e.f.g.e.g.f.g.i.g.h.j.h.j.h.j.j.j.k.l.j.l.ja..la..l.n.l.m.l.n.m.n.m.o.n.o.n.o.o.o.o.o.o.o.o#W.o.q.p.t.p.r.p.r.r.r.r.u.r.u.r.u.v.u.v.y.v.w.v.y.w.y.x.A.w.A.z.A.A.A.z.B.A.B.C.B.C.E.C.E.C.D.D.E.D.E.D.F.D.F.F.F.F.H.F.H.H.H.H.H.H.J.H.K.H.K.J#Y.J.L.J.L.J.L.N.L.L.L.M.O.L.O.Oa#.Oa#.O.Q.O.P.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.W.T.X.W.X.W.X.X.0.W#0.X.Z.X.Z.0.1.0.2.0.2.3.2.3.4.1.4.4.4.4#1.4#2.4#2.4.6.6aa.6.8.6#3.7.8.7#..7#..7#..9#..9#.#.#b#.#b#b#b#b#d#b#d#b#e#c#d#c#e#d#f#c#f#f#f#f#f#f#h#f#i#f#i#h#i#h#l#j#l#m#l#m#l#l#n#k#n#n#n#nab#n#o#n#qab#o#o#q#o#q#p#r#o#r#8#r#r#t#r#t#t#t#t#w#t#w#t#4#w#x#w#z#x#z#w#z#B#z#B#z#A#C#A#C#C#C#Cac#C#F#C#F#E#F#Ead#E#G#E#G#I#G#I#G#G#J#G#J#I#J#J#J#J#M#J#5#L#M#L#5#M#6#L#N#M#N#N#N#N#Q#N#R#Q#R#Q#R#Q#T#Q#T#S#T#S#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.a.b.#.c.#.c.b.c.b.d.b.d.b.e.c.e.f.e.f.g.f.g.f.g.h.i.h.j.h.j.h.j.k.j.j.l.j.l.j.l.l.l.l.m.l.m.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.r.u.v.u.v.w.v.w.x.y.x.z.x.A.x.A.z.A.z.A.A.B.A.B.C.B.C.D.C.D.C.D.D.E.D.E.D.F.D.F.F.F.G.H.G.H.I.H.H.H.H.J.H.K.J.K.J.L.J.M.J.L.J.L.N.L.M.O.L.O.L.O.O.O.O.P.O.P.O.P.P.Q.P.Q.P.R.P.R.R.R.S.T.U.V.T.V.T.V.T.W.T.X.Y.X.W.X.W.X.W.Z.W.0.0.Z.0.1.0.2.3.2.3.2.1.4.1.4.5.4.4.4.4.6.4.6.6.6.6.6.7.7.7.8.7.9.7#..7#..7#.###..9#.#a#b#a#b#a#c#b#c#b#c#b#d#c#d#c#e#c#f#d#f#g#f#g#f#g#h#g#i#j#i#j#i#j#k#j#l#m#l#m#l#k#n#l#n#n#n#n#n#n#o#n#o#n#o#p#q#p#r#p#r#s#r#r#t#u#t#v#t#v#w#t#w#w#w#w#x#w#y#w#z#w#A#w#z#B#z#B#z#A#C#A#C#D#C#C#C#C#E#C#F#E#F#E#F#E#G#E#G#H#G#I#G#H#J#I#J#K#J#J#L#J#L#J#M#L#M#L#N#O#N#O#N#P#N#N#Q#N#Q#N#R#Q#R#Q#R#Q#S#S#T#S#U#T#U#U#U#U#U#U",
".#.a.#.#.#.#.c.#.c.#.c.b.c.b.d.c.d.c.d.d.e.f.e.f.g.f.g.f.g.h.g.i.j.h.j.i.j.k.j.j.l.j.l.j.l.l#V.l.m.l.n.l.n.m.n.m.o.m.o.n.o.o.o.o.o.o.o.o.p.o#W.p.r.p.t.q.r.r.t.r.u.s.u.t.u.v.u.v.w.v.y.u.y.x.y.w.A.w.A.z.A.z.A.A.C.A.B.C.B.C.E.B.D.C.E.D.E.D.E.D.F.D.F.F.F.F.H.F.H#X.H.H.H.H.J.H.J.H#Y.J#Y.J.L.K.L.J.L.M.L.M.L.L.O.L.O.O.O.O#Z.O.P.O.Q.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.X.T.X.W.X.W.X.W.0.X#0.W.Z.X.Z.0.2.0.2.0.2.3.2.3.4.1.4.5#1.4.4.4#2.4.6.4.6.6.6.6#3.6.8.7#3.7#..7#..7#.###.#.#.#.#b#.#b#b#b#b#c#b#d#b#d#c#e#c#e#c#f#d#f#g#f#f#f#f#i#f#i#g#i#h#i#j#l#h#l#m#l#k#l#k#n#l#n#n#n#n#n#n#q#n#o#n#q#o#q#p#q#o#r#p#r#r#r#r#t#r#t#v#t#t#w#t#x#t#x#w#4#w#z#w#z#x#z#B#z#A#z#A#C#A#C#C#C#C#C#C#F#C#F#E#F#E#F#E#G#E#G#I#G#G#G#G#J#G#J#I#J#J#J#J#M#J#M#L#5#L#5#L#6#M#N#O#N#N#N#N#R#N#R#Q#R#Q#R#Q#T#Q#T#S#T#T#U#T#U#U#U#U#U#U#U",
"Qt.#Qt.#.a.#.a.#.#.c.a.c.#.c.b.c.b.d.b.d.c.e.c.e.f.e.f.i.f.g.f.g.h.g.h.j.h.j.h.j.j.j.k.l.j.l.j.l.l.l.l.m.l.n.l.m.m.n.m.o.m.o.m.o.o.o.o.o.o.p.o.p.p.q.p.r.p.r.p.r.s.t.s.u.s.u.s.u.v.u.v.w.v.y.x.w.x.A.x.A.w.A.z.A.z.A.z.C.A.B.C.B.C.D.C.D.C.E.D.D.D.E.D.F.D.F.F.F.G.H.G.H#X.H#X.H.H.J.H.J.J#Y.J.L.J.L.J.L.J.L.N.L.L.O.M.O.L.O.O.O.O.P.O.P.O.Q.P.P.P.Q.P.R.P.R.R.R.U.T.S.T.T.V.T.V.T.X.T.X.W.X.W.X.W.X.W.Z.X.Z.0.Z.0.1.0.3.3.2.3.2.1.4.1.4.5.4.5.4.4.6#7.6.6.6.6.6.7.7.7.7.7#..7.9.7#..7#.###.###.#a#b#a#b#b#c#b#c#b#d#b#d#c#e#c#d#d#f#c#f#g#f#g#f#g#h#g#h#j#i#j#i#j#l#j#l#m#l#m#l#l#n#k#n#n#n#n#n#n#o#n#o#n#q#p#o#p#r#p#r#s#r#8#t#v#t#u#t#v#w#v#w#w#x#w#x#w#z#w#y#w#A#w#A#B#z#B#z#A#C#A#C#C#C#C#C#C#E#C#E#E#F#E#F#E#G#E#G#I#G#I#G#H#J#H#J#K#J#J#L#J#M#J#M#L#5#L#N#L#N#O#N#N#N#N#Q#N#Q#N#Q#Q#R#Q#R#Q#T#S#T#S#U#S#U#U#U#U#U#U",
".#.a.#.a#9.#.c.#.c.#.c.b.c.c.c.b.d.c.d.c.e.f.e.f.g.e.g.f.g.i.g.h.j.h.j.h.j.j.j.k.l.j.l.ja..la..l.n.l.m.l.n.m.n.m.o.n.o.n.o.o.o.o.o.o.o.o#W.o.q.p.t.p.r.p.r.r.r.r.u.r.u.r.u.v.u.v.y.v.w.v.y.w.y.x.A.w.A.z.A.A.A.z.B.A.B.C.B.C.E.C.E.C.D.D.E.D.E.D.F.D.F.F.F.F.H.F.H.H.H.H.H.H.J.H.K.H.K.J#Y.J.L.J.L.J.L.N.L.L.L.M.O.L.O.Oa#.Oa#.O.Q.O.P.P.Q.P.Q.P.R.P.R.R.R.R.V.R.V.T.V.T.V.T.W.T.X.W.X.W.X.X.0.W#0.X.Z.X.Z.0.1.0.2.0.2.3.2.3.4.1.4.4.4.4#1.4#2.4#2.4.6.6aa.6.8.6#3.7.8.7#..7#..7#..9#..9#.#.#b#.#b#b#b#b#d#b#d#b#e#c#d#c#e#d#f#c#f#f#f#f#f#f#h#f#i#f#i#h#i#h#l#j#l#m#l#m#l#l#n#k#n#n#n#nab#n#o#n#qab#o#o#q#o#q#p#r#o#r#8#r#r#t#r#t#t#t#t#w#t#w#t#4#w#x#w#z#x#z#w#z#B#z#B#z#A#C#A#C#C#C#Cac#C#F#C#F#E#F#Ead#E#G#E#G#I#G#I#G#G#J#G#J#I#J#J#J#J#M#J#5#L#M#L#5#M#6#L#N#M#N#N#N#N#Q#N#R#Q#R#Q#R#Q#T#Q#T#S#T#S#U#T#U#U#U#U#U#U#U"};

ImgProcOut::ImgProcOut( QWidget* parent,  const char* name, bool modal, WFlags fl ) : QDialog( parent, name, modal, fl ){
    QPixmap image0( ( const char** ) imgprocout_image0_data );
    QPixmap image1( ( const char** ) imgprocout_image1_data );
    if ( !name )
	setName( "ImgProcOut" );
    resize( 460, 397 );
    setCaption( tr2i18n( "KOnCD - Creating CD Image..." ) );
    setIcon( image0 );
    ImgProcOutLayout = new QVBoxLayout( this, 11, 6, "ImgProcOutLayout");

    GroupBox1 = new QGroupBox( this, "GroupBox1" );
    GroupBox1->setTitle( QString::null );
    GroupBox1->setColumnLayout(0, Qt::Vertical );
    GroupBox1->layout()->setSpacing( 6 );
    GroupBox1->layout()->setMargin( 11 );
    GroupBox1Layout = new QVBoxLayout( GroupBox1->layout() );
    GroupBox1Layout->setAlignment( Qt::AlignTop );

    Layout3 = new QHBoxLayout( 0, 0, 6, "Layout3");
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout3->addItem( spacer );

    StatusLabel = new QLabel( GroupBox1, "StatusLabel" );
    StatusLabel->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, StatusLabel->sizePolicy().hasHeightForWidth() ) );
    StatusLabel->setMinimumSize( QSize( 400, 15 ) );
    QFont StatusLabel_font(  StatusLabel->font() );
    StatusLabel_font.setPointSize( 14 );
    StatusLabel_font.setBold( TRUE );
    StatusLabel->setFont( StatusLabel_font );
    StatusLabel->setText( tr2i18n( "Creating CD image... please wait!" ) );
    Layout3->addWidget( StatusLabel );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout3->addItem( spacer_2 );
    GroupBox1Layout->addLayout( Layout3 );

    Layout2 = new QHBoxLayout( 0, 0, 6, "Layout2");
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout2->addItem( spacer_3 );

    ImgProgress = new QProgressBar( GroupBox1, "ImgProgress" );
    ImgProgress->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, ImgProgress->sizePolicy().hasHeightForWidth() ) );
    ImgProgress->setMinimumSize( QSize( 400, 25 ) );
    QPalette pal;
    QColorGroup cg;
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 228, 228, 228) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 241, 241, 241) );
    cg.setColor( QColorGroup::Dark, QColor( 114, 114, 114) );
    cg.setColor( QColorGroup::Mid, QColor( 152, 152, 152) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setBrush( QColorGroup::Highlight, QBrush( QColor( 10, 95, 137), image1 ) );
    cg.setColor( QColorGroup::HighlightedText, white );
    cg.setColor( QColorGroup::Link, QColor( 0, 0, 255) );
    cg.setColor( QColorGroup::LinkVisited, QColor( 255, 0, 255) );
    pal.setActive( cg );
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 228, 228, 228) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, white );
    cg.setColor( QColorGroup::Dark, QColor( 114, 114, 114) );
    cg.setColor( QColorGroup::Mid, QColor( 152, 152, 152) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setBrush( QColorGroup::Highlight, QBrush( QColor( 10, 95, 137), image1 ) );
    cg.setColor( QColorGroup::HighlightedText, white );
    cg.setColor( QColorGroup::Link, QColor( 0, 0, 255) );
    cg.setColor( QColorGroup::LinkVisited, QColor( 255, 0, 255) );
    pal.setInactive( cg );
    cg.setColor( QColorGroup::Foreground, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Button, QColor( 228, 228, 228) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, white );
    cg.setColor( QColorGroup::Dark, QColor( 114, 114, 114) );
    cg.setColor( QColorGroup::Mid, QColor( 152, 152, 152) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setBrush( QColorGroup::Highlight, QBrush( QColor( 10, 95, 137), image1 ) );
    cg.setColor( QColorGroup::HighlightedText, white );
    cg.setColor( QColorGroup::Link, QColor( 0, 0, 255) );
    cg.setColor( QColorGroup::LinkVisited, QColor( 255, 0, 255) );
    pal.setDisabled( cg );
    ImgProgress->setPalette( pal );
    ImgProgress->setProgress( 0 );
    ImgProgress->setCenterIndicator( TRUE );
    ImgProgress->setIndicatorFollowsStyle( FALSE );
    Layout2->addWidget( ImgProgress );
    QSpacerItem* spacer_4 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout2->addItem( spacer_4 );
    GroupBox1Layout->addLayout( Layout2 );

    Layout4 = new QHBoxLayout( 0, 0, 6, "Layout4");
    QSpacerItem* spacer_5 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout4->addItem( spacer_5 );

    Output = new QTextEdit( GroupBox1, "Output" );
    Output->setMinimumSize( QSize( 400, 250 ) );
    Output->setReadOnly( TRUE );
    Layout4->addWidget( Output );
    QSpacerItem* spacer_6 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout4->addItem( spacer_6 );
    GroupBox1Layout->addLayout( Layout4 );
    QSpacerItem* spacer_7 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    GroupBox1Layout->addItem( spacer_7 );
    ImgProcOutLayout->addWidget( GroupBox1 );

    Layout1 = new QHBoxLayout( 0, 0, 6, "Layout1");
    QSpacerItem* spacer_8 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout1->addItem( spacer_8 );

    Button = new QPushButton( this, "Button" );
    Button->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, 0, 0, Button->sizePolicy().hasHeightForWidth() ) );
    Button->setMinimumSize( QSize( 200, 25 ) );
    Button->setText( tr2i18n( "&Abort" ) );
    Layout1->addWidget( Button );
    QSpacerItem* spacer_9 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout1->addItem( spacer_9 );
    ImgProcOutLayout->addLayout( Layout1 );

    // tab order
    setTabOrder( Button, Output );
}

ImgProcOut::~ImgProcOut(){
    // no need to delete child widgets, Qt does it all for us
}

#include "imgprocout.moc"
