/*
    Copyright (C) 2000 - 2001 Kai Heitkamp, kai@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifndef AUDIOCD_H
#define AUDIOCD_H

#include <qwidget.h>
#include <qprogressdialog.h>
#include <kprocess.h>
#include <kconfig.h>
#include <audiocd_gui.h>

#include "processoutput.h"
#include "imgprocout.h"
#include "tracklistviewitem.h"

/**
  *@author Kai Heitkamp
  */

class AudioCD : public AudioCD_GUI  {
   Q_OBJECT

public:
  AudioCD(QWidget *parent=0, const char *name=0);
  ~AudioCD();

  QString cdrecord, cdrdao, mpg123, ogg123;

protected:

  /**
   * Returns whether the file f is an existing temporary file or not.
   */
  bool isTempFile(const QString &f);

  void convert( QString, QString );
  int checkMimeType( QString );
  void tracklistChanged();


protected slots:
  void abort_handler();
  void dragEnterEvent(QDragEnterEvent *);
  void dropEvent(QDropEvent *);
  void slot_start();
  void slot_exit();
  void slot_addTrack();
  void slot_deleteTrack();
  void slot_deleteAllTracks();
  void slot_BurnRecStderr(KProcess *, char *, int);
  void slot_BurnProcessExited(KProcess *);
  void slot_BlankingProcessExited(KProcess *rcproc);
  void slot_toggleTaO();
  void slot_toggleDaO();
  void slot_createTOCfile();
  void slot_writeCD();
  void slot_Down();
  void slot_Up();
  void slot_Moved();
  void slot_KListView_popupMenu(QListViewItem*,const QPoint&,int);
  void slot_setCDText();
  void slot_deleteCDText();
  void slot_blankingCDRW();
  void slot_sortTracklist();
  void slot_perform();
  void slot_cancel();

protected:  
  enum{ WAVE, MP3, OGGVORBIS };

  int labelsize, trackcount, convertcount;
  int alltracks, allmp3tracks, alloggtracks;
  QString tracklist[100], tempFile;
  
  QProgressDialog *progress;
  QTimer *timer;
  TrackListViewItem *item;

  ProcessOutput procoutdlg;
  ImgProcOut imgprocoutdlg;
  KProcess process;
  KShellProcess shellProcess;
  KConfig *config;
};

#endif
