/* 
 * Sample plugin demo
 * Alex Roberts <bse@error.fsnet.co.uk>
 *
 * Prints "Hello World" into the current document
 */

#include <config.h> 
#include <gnome.h>

#include "../../src/window.h"
#include "../../src/document.h"
#include "../../src/view.h"
#include "../../src/plugin.h"


static void destroy_plugin (PluginData *pd)
{
}


/* Gratiously ripped out of GIMP (app/general.c), with a fiew minor changes */
static char *
get_time (void)
{
	static char static_buf[21];
  	gchar *tmp, *out = NULL;
  	time_t clock;
  	struct tm *now;
  	const char *format = NULL;
  	size_t out_length = 0;
  	

  	clock = time (NULL);
  	/*now = gmtime (&clock);*/
  	now = localtime (&clock);
	  	
  	tmp = static_buf;
	
  	/* date format derived from ISO 8601:1988 */
  	/*sprintf(tmp, "%04d-%02d-%02d%c%02d:%02d:%02d%c",
	  now->tm_year + 1900, now->tm_mon + 1, now->tm_mday,
	  ' ',
	  now->tm_hour, now->tm_min, now->tm_sec,
	  '\000'); 
	
	  return tmp;
	*/
	format = "%a %b %e %H:%M:%S %Z %Y";

	do
	{
		out_length += 200;
		out = (char *) realloc (out, out_length);
	}
  	while (strftime (out, out_length, format, now) == 0);

  	
  	return out;
}

static void
insert_time (void)
{
	GeditView *view = gedit_view_active();
	static gchar *the_time;

	if (!view)
	     return;

  	the_time = get_time();

	gedit_document_insert_text (view->doc, the_time, gedit_view_get_position (view), TRUE);

	g_free (the_time);
}

gint
init_plugin (PluginData *pd)
{
	/* initialise */
	pd->destroy_plugin = destroy_plugin;
	pd->name = _("Insert Time");
	pd->desc = _("Inserts the current date and time");
	pd->long_desc = _("Inserts the current date and time");
	pd->author = "Alex Roberts <bse@error.fsnet.co.uk>";
	pd->needs_a_document = TRUE;
	pd->modifies_an_existing_doc = TRUE;

	pd->private_data = (gpointer)insert_time;
	pd->installed_by_default = TRUE;
	
	return PLUGIN_OK;
}
