/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.javax;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import openlink.util.OPLHeapBlob;
import openlink.util.OPLHeapClob;
import openlink.util.OPLHeapNClob;
import virtuoso.javax.BaseRowSet;
import virtuoso.javax.OPLMessage_x;
import virtuoso.javax.OPLRowSetMetaData;

public class OPLCachedRowSet
extends BaseRowSet
implements RowSetInternal,
Serializable,
Cloneable {
    private static final long serialVersionUID = -8262862611500365291L;
    private static final int BEFOREFIRST = 0;
    private static final int FIRSTROW = 1;
    private static final int BODYROW = 2;
    private static final int LASTROW = 3;
    private static final int AFTERLAST = 4;
    private static final int NOROWS = 5;
    private RowSetReader rowSetReader = new RowSetReader();
    private RowSetWriter rowSetWriter = new RowSetWriter();
    private transient Connection conn;
    private RowSetMetaData rowSMD;
    private int[] keyCols;
    private String tableName;
    private ArrayList<Object> rowsData = new ArrayList();
    private int curState = 5;
    private int curRow;
    private int absolutePos;
    private int countDeleted;
    private int countRows;
    private Row updateRow = null;
    private boolean onInsertRow = false;
    private boolean showDeleted;
    private InputStream objInputStream = null;
    private Reader objReader = null;
    private boolean _wasNull = false;

    public OPLCachedRowSet() throws SQLException {
        this.setType(1004);
        this.setConcurrency(1007);
        this.showDeleted = false;
        this.curRow = -1;
        this.absolutePos = 0;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public synchronized void finalize() throws Throwable {
        this.close();
    }

    @Override
    public synchronized void setCommand(String string) throws SQLException {
        this.tableName = null;
        this.keyCols = null;
        super.setCommand(string);
    }

    @Override
    public synchronized void setConcurrency(int n) throws SQLException {
        if (this.tableName == null && n == 1008) {
            throw OPLMessage_x.makeException(23);
        }
        super.setConcurrency(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void acceptChanges() throws SQLException {
        this.check_InsertMode("'acceptChanges()'");
        if (this.rowSetWriter == null) {
            throw OPLMessage_x.makeException(24);
        }
        int n = this.curRow;
        int n2 = this.absolutePos;
        int n3 = this.curState;
        boolean bl = true;
        SQLException sQLException = null;
        try {
            bl = this.rowSetWriter.writeData(this);
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
        }
        finally {
            this.curRow = n;
            this.absolutePos = n2;
            this.curState = n3;
        }
        if (!bl) {
            if (sQLException == null) {
                throw OPLMessage_x.makeException(25);
            }
            throw sQLException;
        }
        this.setOriginal();
    }

    public void acceptChanges(Connection connection) throws SQLException {
        this.conn = connection;
        this.acceptChanges();
    }

    @Override
    public synchronized void execute() throws SQLException {
        this.rowSetReader.readData(this);
        if (this.tableName == null) {
            Scanner scanner = new Scanner(this.getCommand());
            this.tableName = scanner.check_Select();
            if (this.tableName == null) {
                this.setConcurrency(1007);
            } else {
                this.setConcurrency(1008);
            }
        }
    }

    public void execute(Connection connection) throws SQLException {
        this.conn = connection;
        this.execute();
    }

    public synchronized void populate(ResultSet resultSet) throws SQLException {
        this.check_InsertMode("'populate((...)'");
        this.tableName = null;
        this.keyCols = null;
        Map<String, Class<?>> map = this.getTypeMap();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int n2 = 0;
        while (resultSet.next()) {
            Row row = new Row(n);
            for (int i = 1; i <= n; ++i) {
                Object object = map == null ? resultSet.getObject(i) : resultSet.getObject(i, map);
                if (object instanceof Blob) {
                    object = new OPLHeapBlob(((Blob)object).getBytes(0L, (int)((Blob)object).length()));
                } else if (object instanceof Clob) {
                    object = new OPLHeapClob(((Clob)object).getSubString(0L, (int)((Clob)object).length()));
                } else if (object instanceof NClob) {
                    object = new OPLHeapNClob(((NClob)object).getSubString(0L, (int)((NClob)object).length()));
                }
                row.setOrigColData(i, object);
            }
            this.rowsData.add(row);
            ++n2;
        }
        this.countRows = n2;
        this.curState = this.countRows > 0 ? 0 : 5;
        this.curRow = -1;
        this.absolutePos = 0;
        this.rowSMD = new OPLRowSetMetaData(resultSetMetaData);
        this.notifyListener(3);
    }

    public synchronized void setShowDeleted(boolean bl) throws SQLException {
        this.check_InsertMode("'setShowDeleted(...)'");
        if (this.showDeleted && !bl && this.rowDeleted()) {
            this.showDeleted = bl;
            switch (this.curState) {
                case 1: {
                    this._first();
                    this.notifyListener(2);
                    break;
                }
                case 2: {
                    int n = this.absolutePos;
                    this._next();
                    this.absolutePos = n;
                    this.notifyListener(2);
                    break;
                }
                case 3: {
                    this._last();
                    this.notifyListener(2);
                }
            }
        } else {
            this.showDeleted = bl;
            switch (this.curState) {
                case 1: 
                case 2: 
                case 3: {
                    if (this.curRow < this.countRows / 2) {
                        int n = this.curRow;
                        this._beforeFirst();
                        while (this._next() && n != this.curRow) {
                        }
                    } else {
                        int n = this.curRow;
                        this._afterLast();
                        while (this._previous() && n != this.curRow) {
                        }
                    }
                    break;
                }
                case 0: {
                    this._beforeFirst();
                    break;
                }
                case 4: {
                    this._afterLast();
                }
            }
        }
    }

    public boolean getShowDeleted() throws SQLException {
        return this.showDeleted;
    }

    public String getTableName() throws SQLException {
        return this.tableName;
    }

    public synchronized void setTableName(String string) throws SQLException {
        this.tableName = string;
    }

    public int[] getKeyCols() throws SQLException {
        return this.keyCols;
    }

    public void setKeyColumns(int[] nArray) throws SQLException {
        int n = this.rowSMD != null ? this.rowSMD.getColumnCount() : 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 1 && nArray[i] <= n) continue;
            throw OPLMessage_x.makeException(9);
        }
        if (nArray.length > n) {
            throw OPLMessage_x.makeException(26);
        }
        this.keyCols = new int[nArray.length];
        System.arraycopy(nArray, 0, this.keyCols, 0, nArray.length);
    }

    public synchronized void cancelRowDelete() throws SQLException {
        if (!this.showDeleted) {
            return;
        }
        this.check_pos("'cancelRowDelete()'");
        this.check_InsertMode("'cancelRowDelete()'");
        Row row = this.getCurRow();
        if (row.isDeleted) {
            row.isDeleted = false;
            --this.countDeleted;
            this.notifyListener(2);
        }
    }

    public synchronized void cancelRowInsert() throws SQLException {
        this.check_pos("'cancelRowInsert()'");
        this.check_InsertMode("'cancelRowInsert()'");
        Row row = this.getCurRow();
        if (row.isInserted) {
            this.rowsData.remove(this.curRow);
            this.notifyListener(2);
            --this.countRows;
            if (this.countRows == 0) {
                this.curState = 5;
                this.curRow = -1;
                this.absolutePos = 0;
            }
            switch (this.curState) {
                case 1: {
                    this._first();
                    break;
                }
                case 3: {
                    this._last();
                    break;
                }
                case 2: {
                    if (this.curRow == this.countRows - 1) {
                        this.curState = 3;
                        break;
                    }
                    boolean bl = false;
                    int n = this.curRow;
                    while (!bl && ++n < this.countRows) {
                        bl = true;
                        if (this.showDeleted || !((Row)this.rowsData.get((int)n)).isDeleted) continue;
                        bl = false;
                    }
                    if (bl) break;
                    this.curState = 3;
                }
            }
        } else {
            throw OPLMessage_x.makeException(27);
        }
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        this.check_pos("'cancelRowUpdates()'");
        this.cancelUpdates();
        Row row = this.getCurRow();
        if (row.isUpdated) {
            row.clearUpdated();
            this.notifyListener(2);
        }
    }

    public synchronized boolean columnUpdated(int n) throws SQLException {
        this.check_pos("'columnUpdated(...)'");
        this.check_InsertMode("'columnUpdated(...)'");
        return this.getCurRow().isColUpdated(n);
    }

    public synchronized void setOriginal() throws SQLException {
        if (this.countRows == 0) {
            return;
        }
        Iterator<Object> iterator = this.rowsData.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            if (row.isDeleted) {
                iterator.remove();
                --this.countRows;
                continue;
            }
            row.moveCurToOrig();
        }
        this.countDeleted = 0;
        this.curState = 0;
        this.curRow = -1;
        this.absolutePos = 0;
        this._wasNull = false;
        this.notifyListener(3);
    }

    public synchronized void setOriginalRow() throws SQLException {
        if (this.countRows == 0) {
            return;
        }
        this.check_InsertMode("'setOriginalRow()'");
        this.check_pos("'setOriginalRow()'");
        Row row = this.getCurRow();
        if (row.isDeleted) {
            this.rowsData.remove(this.curRow);
            --this.countRows;
            --this.countDeleted;
            this._next();
        } else {
            row.moveCurToOrig();
        }
        this.notifyListener(2);
    }

    public synchronized void restoreOriginal() throws SQLException {
        this.closeInputStream();
        this.cancelUpdates();
        if (this.countRows == 0) {
            return;
        }
        Iterator<Object> iterator = this.rowsData.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            if (row.isInserted) {
                iterator.remove();
                --this.countRows;
                continue;
            }
            if (row.isDeleted) {
                row.isDeleted = false;
            }
            if (!row.isUpdated) continue;
            row.clearUpdated();
        }
        this.curRow = -1;
        this.absolutePos = 0;
        this.curState = 0;
        this._wasNull = false;
        this.notifyListener(3);
    }

    public int size() {
        return this.countRows;
    }

    public synchronized Collection toCollection() throws SQLException {
        int n = this.countRows - this.countDeleted;
        if (n == 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList(n);
        int n2 = this.rowSMD.getColumnCount();
        for (Row row : this.rowsData) {
            if (row.isDeleted) continue;
            ArrayList<Object> arrayList2 = new ArrayList<Object>(n2);
            for (int i = 1; i <= n2; ++i) {
                arrayList2.add(row.getColData(i));
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public synchronized Collection toCollection(int n) throws SQLException {
        int n2 = this.countRows - this.countDeleted;
        if (n2 == 0) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        this.checkColumnIndex(n);
        for (Row row : this.rowsData) {
            if (row.isDeleted) continue;
            arrayList.add(row.getColData(n));
        }
        return arrayList;
    }

    public synchronized void release() throws SQLException {
        this.closeInputStream();
        this.cancelUpdates();
        this.rowsData.clear();
        this.curState = 5;
        this.onInsertRow = false;
        this.updateRow = null;
        this.showDeleted = false;
        this.curRow = -1;
        this.absolutePos = 0;
        this.countRows = 0;
        this.countDeleted = 0;
        this.notifyListener(3);
    }

    public RowSet createCopy() throws SQLException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            return (RowSet)objectInputStream.readObject();
        }
        catch (Exception exception) {
            throw new SQLException("createCopy failed: " + exception.getMessage());
        }
    }

    public RowSet createShared() throws SQLException {
        RowSet rowSet;
        try {
            rowSet = (RowSet)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw OPLMessage_x.makeException(cloneNotSupportedException);
        }
        return rowSet;
    }

    @Override
    public void setMetaData(RowSetMetaData rowSetMetaData) throws SQLException {
        this.rowSMD = rowSetMetaData;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public synchronized ResultSet getOriginal() throws SQLException {
        OPLCachedRowSet oPLCachedRowSet = new OPLCachedRowSet();
        oPLCachedRowSet.rowSMD = this.rowSMD;
        oPLCachedRowSet.countRows = this.countRows;
        oPLCachedRowSet.curRow = -1;
        oPLCachedRowSet.rowSetReader = null;
        oPLCachedRowSet.rowSetWriter = null;
        oPLCachedRowSet.curState = 0;
        oPLCachedRowSet._wasNull = false;
        Iterator<Object> iterator = this.rowsData.iterator();
        while (iterator.hasNext()) {
            oPLCachedRowSet.rowsData.add(new Row(((Row)iterator.next()).getOrigData()));
        }
        return oPLCachedRowSet;
    }

    @Override
    public synchronized ResultSet getOriginalRow() throws SQLException {
        OPLCachedRowSet oPLCachedRowSet = new OPLCachedRowSet();
        oPLCachedRowSet.rowSMD = this.rowSMD;
        oPLCachedRowSet.countRows = 1;
        oPLCachedRowSet.rowSetReader = null;
        oPLCachedRowSet.rowSetWriter = null;
        oPLCachedRowSet.curState = 0;
        oPLCachedRowSet._wasNull = false;
        oPLCachedRowSet.rowsData.add(new Row(this.getCurRow().getOrigData()));
        return oPLCachedRowSet;
    }

    @Override
    public synchronized void close() throws SQLException {
        this.release();
        super.close();
        this.conn = null;
    }

    @Override
    public synchronized boolean next() throws SQLException {
        this.check_move("'next()'", true);
        this.closeInputStream();
        this.cancelUpdates();
        boolean bl = this._next();
        this.notifyListener(1);
        return bl;
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        this.check_move("'previous()'", false);
        this.closeInputStream();
        this.cancelUpdates();
        boolean bl = this._previous();
        this.notifyListener(1);
        return bl;
    }

    @Override
    public synchronized boolean first() throws SQLException {
        this.check_move("'first()'", false);
        this.closeInputStream();
        this.cancelUpdates();
        boolean bl = this._first();
        this.notifyListener(1);
        return bl;
    }

    @Override
    public synchronized boolean last() throws SQLException {
        this.check_move("'last()'", false);
        this.closeInputStream();
        this.cancelUpdates();
        boolean bl = this._last();
        this.notifyListener(1);
        return bl;
    }

    @Override
    public synchronized boolean absolute(int n) throws SQLException {
        this.check_move("'absolute(...)'", false);
        this.closeInputStream();
        this.cancelUpdates();
        if (n == 0) {
            throw OPLMessage_x.makeExceptionV(28, "'absolute(...)'");
        }
        if (!this.showDeleted) {
            if (n > 0) {
                if (n == 1) {
                    this._first();
                } else {
                    boolean bl;
                    while (this.absolutePos != n && (bl = this.absolutePos >= n ? this._previous() : this._next())) {
                    }
                }
            } else {
                boolean bl = this._last();
                if (bl && n < -1) {
                    int n2 = -1;
                    while (n2 != n && bl) {
                        bl = this._previous();
                        if (!bl) continue;
                        --n2;
                    }
                }
            }
        } else if (n > 0) {
            if (n > this.countRows) {
                this._afterLast();
            } else {
                this.curRow = n - 1;
                this.absolutePos = n;
                this.curState = 2;
            }
        } else if (n * -1 > this.countRows) {
            this._beforeFirst();
        } else {
            this.curRow = this.countRows + n;
            this.absolutePos = this.curRow + 1;
            this.curState = 2;
        }
        this.notifyListener(1);
        return !this.isAfterLast() && !this.isBeforeFirst();
    }

    @Override
    public synchronized boolean relative(int n) throws SQLException {
        this.check_move("'relative(...)'", false);
        this.closeInputStream();
        this.cancelUpdates();
        if (n == 0) {
            return true;
        }
        if (n > 0) {
            if (this.curRow + n >= this.countRows) {
                this._afterLast();
            } else {
                for (int i = 0; i < n && this._next(); ++i) {
                }
            }
        } else if (this.curRow + n < 0) {
            this.beforeFirst();
        } else {
            for (int i = n; i < 0 && this._previous(); ++i) {
            }
        }
        this.notifyListener(1);
        return !this.isAfterLast() && !this.isBeforeFirst();
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        this.check_move("'beforeFirst()'", false);
        this.closeInputStream();
        this.cancelUpdates();
        this._beforeFirst();
        this.notifyListener(1);
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        this.check_move("'afterLast()'", false);
        this.closeInputStream();
        this.cancelUpdates();
        this._afterLast();
        this.notifyListener(1);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.check_InsertMode("'isBeforeFirst()'");
        return this.curState == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.check_InsertMode("'isAfterLast()'");
        return this.curState == 4;
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        this.check_InsertMode("'isFirst()'");
        if (this.curState == 1) {
            return true;
        }
        if (this.curState == 3) {
            int n = this.curRow;
            int n2 = this.absolutePos;
            boolean bl = this._previous();
            this.curRow = n;
            this.absolutePos = n2;
            this.curState = 3;
            if (!bl) {
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        this.check_InsertMode("'isLast()'");
        if (this.curState == 3) {
            return true;
        }
        if (this.curState == 1) {
            int n = this.curRow;
            int n2 = this.absolutePos;
            boolean bl = this._next();
            this.curRow = n;
            this.absolutePos = n2;
            this.curState = 1;
            if (!bl) {
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized int getRow() throws SQLException {
        this.check_InsertMode("'getRow()'");
        if (this.curState == 0 || this.curState == 4 || this.curState == 5) {
            return 0;
        }
        return this.absolutePos;
    }

    @Override
    public synchronized boolean rowUpdated() throws SQLException {
        this.check_InsertMode("'rowUpdated()'");
        if (this.curState == 0 || this.curState == 4 || this.curState == 5) {
            return false;
        }
        return ((Row)this.rowsData.get((int)this.curRow)).isUpdated;
    }

    @Override
    public synchronized boolean rowInserted() throws SQLException {
        this.check_InsertMode("'rowInserted()'");
        if (this.curState == 0 || this.curState == 4 || this.curState == 5) {
            return false;
        }
        return ((Row)this.rowsData.get((int)this.curRow)).isInserted;
    }

    @Override
    public synchronized boolean rowDeleted() throws SQLException {
        this.check_InsertMode("'rowDeleted()'");
        if (this.curState == 0 || this.curState == 4 || this.curState == 5) {
            return false;
        }
        return ((Row)this.rowsData.get((int)this.curRow)).isDeleted;
    }

    @Override
    public synchronized void refreshRow() throws SQLException {
        this.check_move("'refreshRow()'", false);
        this.closeInputStream();
        this.cancelUpdates();
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        if (!this.onInsertRow) {
            throw OPLMessage_x.makeExceptionV(14, "'insertRow()'");
        }
        this.check_Update("'insertRow()'");
        if (this.updateRow == null || !this.updateRow.isCompleted()) {
            throw OPLMessage_x.makeException(29);
        }
        Row row = new Row(this.updateRow.getCurData());
        row.isInserted = true;
        switch (this.curState) {
            case 1: 
            case 2: 
            case 3: {
                this.rowsData.add(this.curRow, row);
                break;
            }
            case 0: 
            case 5: {
                this.rowsData.add(0, row);
                this.curState = 0;
                break;
            }
            case 4: {
                this.rowsData.add(row);
            }
        }
        ++this.countRows;
        this.notifyListener(2);
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        if (this.onInsertRow) {
            throw OPLMessage_x.makeExceptionV(14, "'updateRow()'");
        }
        this.check_Update("'updateRow()'");
        this.check_pos("'updateRow()'");
        if (this.updateRow != null) {
            this.getCurRow().update(this.updateRow.getCurData(), this.updateRow.getListUpdatedCols());
            this.notifyListener(2);
            this.updateRow.clear();
            this.updateRow = null;
        }
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        if (this.onInsertRow) {
            throw OPLMessage_x.makeExceptionV(14, "'deleteRow()'");
        }
        this.check_Update("'deleteRow()'");
        this.check_pos("'deleteRow()'");
        Row row = this.getCurRow();
        if (!row.isDeleted) {
            row.isDeleted = true;
            ++this.countDeleted;
            if (!this.showDeleted) {
                int n = this.absolutePos;
                this._next();
                this.absolutePos = n;
            }
            this.notifyListener(2);
        }
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        int n;
        this.check_Update("'moveToInsertRow()'");
        if (this.updateRow != null) {
            this.updateRow.clear();
        }
        if ((n = this.rowSMD.getColumnCount()) > 0) {
            this.updateRow = new Row(n);
            this.onInsertRow = true;
        }
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        if (this.onInsertRow) {
            this.cancelUpdates();
            this.onInsertRow = false;
            if (this.curState == 4) {
                this._last();
            }
            return;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this._wasNull;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rowSMD;
    }

    @Override
    public int findColumn(String string) throws SQLException {
        if (this.rowSMD == null) {
            throw OPLMessage_x.makeException(16);
        }
        int n = this.rowSMD.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            String string2 = this.rowSMD.getColumnName(i);
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            return i;
        }
        throw OPLMessage_x.makeExceptionV(13, string);
    }

    @Override
    public synchronized String getString(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        if (object instanceof byte[]) {
            return this.Bin2Hex((byte[])object);
        }
        if (object instanceof Blob) {
            return this.Bin2Hex(((Blob)object).getBytes(0L, (int)((Blob)object).length()));
        }
        if (object instanceof Clob) {
            return ((Clob)object).getSubString(0L, (int)((Clob)object).length());
        }
        if (object instanceof NClob) {
            return ((NClob)object).getSubString(0L, (int)((NClob)object).length());
        }
        return object.toString();
    }

    @Override
    public synchronized boolean getBoolean(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            char c = ((String)object).charAt(0);
            return c == 'T' || c == 't' || c == '1';
        }
        if (object instanceof byte[]) {
            return ((byte[])object)[0] != 0;
        }
        if (object instanceof Blob) {
            return ((Blob)object).getBytes(0L, 1)[0] != 0;
        }
        if (object instanceof Clob) {
            char c = ((Clob)object).getSubString(0L, 1).charAt(0);
            return c == 'T' || c == 't' || c == '1';
        }
        if (object instanceof NClob) {
            char c = ((NClob)object).getSubString(0L, 1).charAt(0);
            return c == 'T' || c == 't' || c == '1';
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() != 0;
        }
        throw OPLMessage_x.makeExceptionV(15, "'boolean'");
    }

    @Override
    public synchronized byte getByte(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof Boolean) {
            return (byte)((Boolean)object != false ? 1 : 0);
        }
        if (object instanceof String) {
            return new BigDecimal(((String)object).toString()).byteValue();
        }
        throw OPLMessage_x.makeExceptionV(15, "'byte'");
    }

    @Override
    public synchronized short getShort(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        if (object instanceof Boolean) {
            return (short)((Boolean)object != false ? 1 : 0);
        }
        if (object instanceof String) {
            return new BigDecimal(((String)object).toString()).shortValue();
        }
        throw OPLMessage_x.makeExceptionV(15, "'short'");
    }

    @Override
    public synchronized int getInt(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof String) {
            return new BigDecimal(((String)object).toString()).intValue();
        }
        throw OPLMessage_x.makeExceptionV(15, "'int'");
    }

    @Override
    public synchronized long getLong(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return 0L;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof String) {
            return new BigDecimal(((String)object).toString()).longValue();
        }
        throw OPLMessage_x.makeExceptionV(15, "'long'");
    }

    @Override
    public synchronized float getFloat(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return 0.0f;
        }
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof String) {
            return Float.parseFloat(((String)object).toString().trim());
        }
        throw OPLMessage_x.makeExceptionV(15, "'float'");
    }

    @Override
    public synchronized double getDouble(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof String) {
            return Double.parseDouble(((String)object).toString().trim());
        }
        throw OPLMessage_x.makeExceptionV(15, "'double'");
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        if (object instanceof Boolean) {
            return new BigDecimal((Boolean)object != false ? 1L : 0L);
        }
        try {
            return new BigDecimal(object.toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw OPLMessage_x.makeExceptionV(15, "'BigDecimal'");
        }
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimal(n).setScale(n2);
    }

    @Override
    public synchronized byte[] getBytes(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof Blob) {
            return ((Blob)object).getBytes(0L, (int)((Blob)object).length());
        }
        if (object instanceof Clob) {
            return ((Clob)object).getSubString(0L, (int)((Clob)object).length()).getBytes();
        }
        if (object instanceof NClob) {
            return ((NClob)object).getSubString(0L, (int)((NClob)object).length()).getBytes();
        }
        if (object instanceof String) {
            return ((String)object).getBytes();
        }
        throw OPLMessage_x.makeExceptionV(15, "'byte[]'");
    }

    @Override
    public synchronized Date getDate(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Timestamp) {
            return new Date(((Timestamp)object).getTime());
        }
        if (object instanceof String) {
            Date date = this._getDate((String)object);
            if (date == null) {
                throw OPLMessage_x.makeExceptionV(15, "'Date'");
            }
            return date;
        }
        if (object instanceof Clob) {
            Date date = this._getDate(((Clob)object).getSubString(0L, (int)((Clob)object).length()));
            if (date == null) {
                throw OPLMessage_x.makeExceptionV(15, "'Date'");
            }
            return date;
        }
        if (object instanceof NClob) {
            Date date = this._getDate(((NClob)object).getSubString(0L, (int)((NClob)object).length()));
            if (date == null) {
                throw OPLMessage_x.makeExceptionV(15, "'Date'");
            }
            return date;
        }
        throw OPLMessage_x.makeExceptionV(15, "'Date'");
    }

    @Override
    public synchronized Time getTime(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof Timestamp) {
            return new Time(((Timestamp)object).getTime());
        }
        if (object instanceof String) {
            Time time = this._getTime((String)object);
            if (time == null) {
                throw OPLMessage_x.makeExceptionV(15, "'Time'");
            }
            return time;
        }
        if (object instanceof Clob) {
            Time time = this._getTime(((Clob)object).getSubString(0L, (int)((Clob)object).length()));
            if (time == null) {
                throw OPLMessage_x.makeExceptionV(15, "'Time'");
            }
            return time;
        }
        if (object instanceof NClob) {
            Time time = this._getTime(((NClob)object).getSubString(0L, (int)((NClob)object).length()));
            if (time == null) {
                throw OPLMessage_x.makeExceptionV(15, "'Time'");
            }
            return time;
        }
        throw OPLMessage_x.makeExceptionV(15, "'Time'");
    }

    @Override
    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof Time) {
            return new Timestamp(((Time)object).getTime());
        }
        if (object instanceof Date) {
            return new Timestamp(((Date)object).getTime());
        }
        if (object instanceof String) {
            Timestamp timestamp = this._getTimestamp((String)object);
            if (timestamp == null) {
                throw OPLMessage_x.makeExceptionV(15, "'Timestamp'");
            }
            return timestamp;
        }
        if (object instanceof Clob) {
            Timestamp timestamp = this._getTimestamp(((Clob)object).getSubString(0L, (int)((Clob)object).length()));
            if (timestamp == null) {
                throw OPLMessage_x.makeExceptionV(15, "'Timestamp'");
            }
            return timestamp;
        }
        if (object instanceof NClob) {
            Timestamp timestamp = this._getTimestamp(((NClob)object).getSubString(0L, (int)((NClob)object).length()));
            if (timestamp == null) {
                throw OPLMessage_x.makeExceptionV(15, "'Timestamp'");
            }
            return timestamp;
        }
        throw OPLMessage_x.makeExceptionV(15, "'Timestamp'");
    }

    @Override
    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this.closeInputStream();
        this._wasNull = object == null;
        if (this._wasNull) {
            this.objInputStream = null;
            return null;
        }
        if (object instanceof String) {
            this.objInputStream = new ByteArrayInputStream(((String)object).getBytes());
            return this.objInputStream;
        }
        if (object instanceof Clob) {
            this.objInputStream = ((Clob)object).getAsciiStream();
            return this.objInputStream;
        }
        if (object instanceof NClob) {
            this.objInputStream = ((NClob)object).getAsciiStream();
            return this.objInputStream;
        }
        throw OPLMessage_x.makeExceptionV(15, "'AsciiStream'");
    }

    @Override
    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this.closeInputStream();
        this._wasNull = object == null;
        if (this._wasNull) {
            this.objInputStream = null;
            return null;
        }
        if (object instanceof String) {
            this.objInputStream = new ByteArrayInputStream(((String)object).getBytes());
            return this.objInputStream;
        }
        if (object instanceof Clob) {
            this.objInputStream = ((Clob)object).getAsciiStream();
            return this.objInputStream;
        }
        if (object instanceof NClob) {
            this.objInputStream = ((NClob)object).getAsciiStream();
            return this.objInputStream;
        }
        throw OPLMessage_x.makeExceptionV(15, "'UnicodeStream'");
    }

    @Override
    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this.closeInputStream();
        this._wasNull = object == null;
        if (this._wasNull) {
            this.objInputStream = null;
            return null;
        }
        if (object instanceof byte[]) {
            this.objInputStream = new ByteArrayInputStream((byte[])object);
            return this.objInputStream;
        }
        if (object instanceof String) {
            this.objInputStream = new ByteArrayInputStream(((String)object).getBytes());
            return this.objInputStream;
        }
        if (object instanceof Blob) {
            this.objInputStream = ((Blob)object).getBinaryStream();
            return this.objInputStream;
        }
        if (object instanceof Clob) {
            this.objInputStream = ((Clob)object).getAsciiStream();
            return this.objInputStream;
        }
        if (object instanceof NClob) {
            this.objInputStream = ((NClob)object).getAsciiStream();
            return this.objInputStream;
        }
        throw OPLMessage_x.makeExceptionV(15, "'BinaryStream'");
    }

    @Override
    public synchronized Object getObject(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        Object var3_3 = null;
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        return object;
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public synchronized Reader getCharacterStream(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this.closeInputStream();
        this._wasNull = object == null;
        if (this._wasNull) {
            this.objReader = null;
            return null;
        }
        if (object instanceof String) {
            this.objReader = new StringReader((String)object);
            return this.objReader;
        }
        if (object instanceof Clob) {
            this.objReader = ((Clob)object).getCharacterStream();
            return this.objReader;
        }
        if (object instanceof NClob) {
            this.objReader = ((NClob)object).getCharacterStream();
            return this.objReader;
        }
        throw OPLMessage_x.makeExceptionV(15, "'CharacterStream'");
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public synchronized void updateNull(int n) throws SQLException {
        Row row = this.getRowForUpdate(n, "'updateNull(...)'");
        row.setColData(n, null);
    }

    @Override
    public synchronized void updateBoolean(int n, boolean bl) throws SQLException {
        Row row = this.getRowForUpdate(n, "'updateBoolean(...)'");
        switch (this.rowSMD.getColumnType(n)) {
            case 16: {
                row.setColData(n, new Boolean(bl));
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                row.setColData(n, new Integer(bl ? 1 : 0));
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                row.setColData(n, String.valueOf(bl));
                break;
            }
            default: {
                throw OPLMessage_x.makeExceptionV(17, "'boolean'");
            }
        }
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        this.updateNumber(n, new Byte(by), "'byte'", "'updateByte(...)'");
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        this.updateNumber(n, new Short(s), "'short'", "'updateShort(...)'");
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        this.updateNumber(n, new Integer(n2), "'int'", "'updateInt(...)'");
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        this.updateNumber(n, new Long(l), "'long'", "'updateLong(...)'");
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        this.updateNumber(n, new Float(f), "'float'", "'updateFloat(...)'");
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        this.updateNumber(n, new Double(d), "'double'", "'updateDouble(...)'");
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.updateNull(n);
        } else {
            this.updateNumber(n, bigDecimal, "'BigDecimal'", "'updateBigDecimal(...)'");
        }
    }

    @Override
    public synchronized void updateString(int n, String string) throws SQLException {
        Row row = this.getRowForUpdate(n, "'updateString(...)'");
        if (string == null) {
            this.updateNull(n);
        } else {
            switch (this.rowSMD.getColumnType(n)) {
                case 16: {
                    row.setColData(n, new Boolean(string));
                    break;
                }
                case -16: 
                case -15: 
                case -9: 
                case -7: 
                case -6: 
                case -5: 
                case -1: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 70: 
                case 2004: 
                case 2005: 
                case 2011: {
                    row.setColData(n, string);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    row.setColData(n, this.HexString2Bin(string));
                    break;
                }
                case 92: {
                    Time time = this._getTime(string);
                    if (time == null) {
                        throw OPLMessage_x.makeExceptionV(17, "'String'");
                    }
                    row.setColData(n, time);
                    break;
                }
                case 93: {
                    Timestamp timestamp = this._getTimestamp(string);
                    if (timestamp == null) {
                        throw OPLMessage_x.makeExceptionV(17, "'String'");
                    }
                    row.setColData(n, timestamp);
                    break;
                }
                case 91: {
                    Date date = this._getDate(string);
                    if (date == null) {
                        throw OPLMessage_x.makeExceptionV(17, "'String'");
                    }
                    row.setColData(n, date);
                    break;
                }
                default: {
                    throw OPLMessage_x.makeExceptionV(17, "'String'");
                }
            }
        }
    }

    @Override
    public synchronized void updateBytes(int n, byte[] byArray) throws SQLException {
        Row row = this.getRowForUpdate(n, "'updateBytes(...)'");
        if (byArray == null) {
            this.updateNull(n);
        } else {
            switch (this.rowSMD.getColumnType(n)) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2011: {
                    row.setColData(n, this.Bin2Hex(byArray));
                    break;
                }
                case 2004: {
                    row.setColData(n, byArray);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    row.setColData(n, byArray);
                    break;
                }
                default: {
                    throw OPLMessage_x.makeExceptionV(17, "'byte[]'");
                }
            }
        }
    }

    @Override
    public synchronized void updateDate(int n, Date date) throws SQLException {
        Row row = this.getRowForUpdate(n, "'updateDate(...)'");
        if (date == null) {
            this.updateNull(n);
        } else {
            switch (this.rowSMD.getColumnType(n)) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2011: {
                    row.setColData(n, date.toString());
                    break;
                }
                case 91: {
                    row.setColData(n, date);
                    break;
                }
                case 93: {
                    row.setColData(n, new Timestamp(date.getTime()));
                    break;
                }
                default: {
                    throw OPLMessage_x.makeExceptionV(17, "'Date'");
                }
            }
        }
    }

    @Override
    public synchronized void updateTime(int n, Time time) throws SQLException {
        Row row = this.getRowForUpdate(n, "'updateTime(...)'");
        if (time == null) {
            this.updateNull(n);
        } else {
            switch (this.rowSMD.getColumnType(n)) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2011: {
                    row.setColData(n, time.toString());
                    break;
                }
                case 92: {
                    row.setColData(n, time);
                    break;
                }
                case 93: {
                    row.setColData(n, new Timestamp(time.getTime()));
                    break;
                }
                default: {
                    throw OPLMessage_x.makeExceptionV(17, "'Time'");
                }
            }
        }
    }

    @Override
    public synchronized void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        Row row = this.getRowForUpdate(n, "'updateTimestamp(...)'");
        if (timestamp == null) {
            this.updateNull(n);
        } else {
            switch (this.rowSMD.getColumnType(n)) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2011: {
                    row.setColData(n, timestamp.toString());
                    break;
                }
                case 93: {
                    row.setColData(n, timestamp);
                    break;
                }
                case 91: {
                    row.setColData(n, new Date(timestamp.getTime()));
                    break;
                }
                default: {
                    throw OPLMessage_x.makeExceptionV(17, "'Timestamp'");
                }
            }
        }
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.updateNull(n);
        } else {
            try {
                int n3;
                byte[] byArray = new byte[n2];
                int n4 = 0;
                while ((n3 = inputStream.read(byArray, n4, n2 - n4)) > 0 && (n4 += n3) < n2) {
                }
                this.updateString(n, new String(byArray, 0, n4));
            }
            catch (IOException iOException) {
                throw OPLMessage_x.makeException(iOException);
            }
        }
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.updateNull(n);
        } else {
            try {
                int n3;
                byte[] byArray = new byte[n2];
                int n4 = 0;
                while ((n3 = inputStream.read(byArray, n4, n2 - n4)) > 0 && (n4 += n3) < n2) {
                }
                this.updateBytes(n, byArray);
            }
            catch (IOException iOException) {
                throw OPLMessage_x.makeException(iOException);
            }
        }
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (reader == null) {
            this.updateNull(n);
        } else {
            try {
                int n3;
                char[] cArray = new char[n2];
                int n4 = 0;
                while ((n3 = reader.read(cArray, n4, n2 - n4)) > 0 && (n4 += n3) < n2) {
                }
                this.updateString(n, new String(cArray, 0, n4));
            }
            catch (IOException iOException) {
                throw OPLMessage_x.makeException(iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (object == null) {
            this.updateNull(n);
        } else {
            if (object instanceof BigDecimal) {
                ((BigDecimal)object).setScale(n2);
            }
            OPLCachedRowSet oPLCachedRowSet = this;
            synchronized (oPLCachedRowSet) {
                Row row = this.getRowForUpdate(n, "'updateObject(...)'");
                row.setColData(n, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateObject(int n, Object object) throws SQLException {
        if (object == null) {
            this.updateNull(n);
        } else {
            OPLCachedRowSet oPLCachedRowSet = this;
            synchronized (oPLCachedRowSet) {
                Row row = this.getRowForUpdate(n, "'updateObject(...)'");
                row.setColData(n, object);
            }
        }
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    @Override
    public synchronized Ref getRef(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        if (object instanceof Ref) {
            return (Ref)object;
        }
        throw OPLMessage_x.makeExceptionV(15, "'Ref'");
    }

    @Override
    public synchronized Blob getBlob(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        if (object instanceof Blob) {
            return (Blob)object;
        }
        if (object instanceof byte[]) {
            return new OPLHeapBlob((byte[])object);
        }
        if (object instanceof String) {
            return new OPLHeapBlob(((String)object).getBytes());
        }
        throw OPLMessage_x.makeExceptionV(15, "'Blob'");
    }

    @Override
    public synchronized Clob getClob(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        if (object instanceof Clob) {
            return (Clob)object;
        }
        if (object instanceof byte[]) {
            return new OPLHeapClob(this.Bin2Hex((byte[])object));
        }
        return new OPLHeapClob(object.toString());
    }

    @Override
    public synchronized Array getArray(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        if (object instanceof Array) {
            return (Array)object;
        }
        throw OPLMessage_x.makeExceptionV(15, "'Array'");
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = this.getDate(n);
        if (date == null) {
            return null;
        }
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        return new Date(calendar.getTime().getTime());
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTime(n);
        if (time == null) {
            return null;
        }
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(time);
        calendar.set(11, calendar2.get(11));
        calendar.set(12, calendar2.get(12));
        calendar.set(13, calendar2.get(13));
        return new Time(calendar.getTime().getTime());
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = this.getTimestamp(n);
        if (timestamp == null) {
            return null;
        }
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(timestamp);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(11, calendar2.get(11));
        calendar.set(12, calendar2.get(12));
        calendar.set(13, calendar2.get(13));
        Timestamp timestamp2 = new Timestamp(calendar.getTime().getTime());
        timestamp2.setNanos(timestamp.getNanos());
        return timestamp2;
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public synchronized URL getURL(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        if (object instanceof URL) {
            return (URL)object;
        }
        if (object instanceof String) {
            try {
                return new URL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                throw OPLMessage_x.makeException(malformedURLException);
            }
        }
        throw OPLMessage_x.makeExceptionV(15, "'URL'");
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        if (ref == null) {
            this.updateNull(n);
        } else {
            OPLCachedRowSet oPLCachedRowSet = this;
            synchronized (oPLCachedRowSet) {
                Row row = this.getRowForUpdate(n, "'updateRef(...)'");
                row.setColData(n, ref);
            }
        }
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.findColumn(string), ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        if (blob == null) {
            this.updateNull(n);
        } else {
            OPLCachedRowSet oPLCachedRowSet = this;
            synchronized (oPLCachedRowSet) {
                Row row = this.getRowForUpdate(n, "'updateBlob(...)'");
                blob = new OPLHeapBlob(blob.getBytes(0L, (int)blob.length()));
                row.setColData(n, blob);
            }
        }
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(string), blob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        if (clob == null) {
            this.updateNull(n);
        } else {
            OPLCachedRowSet oPLCachedRowSet = this;
            synchronized (oPLCachedRowSet) {
                Row row = this.getRowForUpdate(n, "'updateClob(...)'");
                clob = new OPLHeapClob(clob.getSubString(0L, (int)clob.length()));
                row.setColData(n, clob);
            }
        }
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.findColumn(string), clob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateArray(int n, Array array) throws SQLException {
        if (array == null) {
            this.updateNull(n);
        } else {
            OPLCachedRowSet oPLCachedRowSet = this;
            synchronized (oPLCachedRowSet) {
                Row row = this.getRowForUpdate(n, "'updateArray(...)'");
                row.setColData(n, array);
            }
        }
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.findColumn(string), array);
    }

    @Override
    public synchronized RowId getRowId(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        if (object instanceof RowId) {
            return (RowId)object;
        }
        throw OPLMessage_x.makeExceptionV(15, "'RowId'");
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        return this.getRowId(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        if (rowId == null) {
            this.updateNull(n);
        } else {
            OPLCachedRowSet oPLCachedRowSet = this;
            synchronized (oPLCachedRowSet) {
                Row row = this.getRowForUpdate(n, "'updateRowId(...)'");
                row.setColData(n, rowId);
            }
        }
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        this.updateRowId(this.findColumn(string), rowId);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn == null;
    }

    @Override
    public synchronized void updateNString(int n, String string) throws SQLException {
        this.updateString(n, string);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.updateNString(this.findColumn(string), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateNClob(int n, NClob nClob) throws SQLException {
        if (nClob == null) {
            this.updateNull(n);
        } else {
            OPLCachedRowSet oPLCachedRowSet = this;
            synchronized (oPLCachedRowSet) {
                Row row = this.getRowForUpdate(n, "'updateNClob(...)'");
                nClob = new OPLHeapNClob(nClob.getSubString(0L, (int)nClob.length()));
                row.setColData(n, nClob);
            }
        }
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        this.updateNClob(this.findColumn(string), nClob);
    }

    @Override
    public synchronized NClob getNClob(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        if (object instanceof NClob) {
            return (NClob)object;
        }
        if (object instanceof byte[]) {
            return new OPLHeapNClob(this.Bin2Hex((byte[])object));
        }
        return new OPLHeapNClob(object.toString());
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return this.getNClob(this.findColumn(string));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        if (object instanceof SQLXML) {
            return (SQLXML)object;
        }
        throw OPLMessage_x.makeExceptionV(15, "'SQLXML'");
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        return this.getSQLXML(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        if (sQLXML == null) {
            this.updateNull(n);
        } else {
            OPLCachedRowSet oPLCachedRowSet = this;
            synchronized (oPLCachedRowSet) {
                Row row = this.getRowForUpdate(n, "'updateSQLXML(...)'");
                row.setColData(n, sQLXML);
            }
        }
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.updateSQLXML(this.findColumn(string), sQLXML);
    }

    @Override
    public synchronized String getNString(int n) throws SQLException {
        return this.getString(n);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getNString(this.findColumn(string));
    }

    @Override
    public synchronized Reader getNCharacterStream(int n) throws SQLException {
        this.checkColumnIndex(n);
        Object object = this.getCurRow().getColData(n);
        this.closeInputStream();
        this._wasNull = object == null;
        if (this._wasNull) {
            this.objReader = null;
            return null;
        }
        if (object instanceof String) {
            this.objReader = new StringReader((String)object);
            return this.objReader;
        }
        if (object instanceof Clob) {
            this.objReader = ((Clob)object).getCharacterStream();
            return this.objReader;
        }
        if (object instanceof NClob) {
            this.objReader = ((NClob)object).getCharacterStream();
            return this.objReader;
        }
        throw OPLMessage_x.makeExceptionV(15, "'NCharacterStream'");
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getNCharacterStream(this.findColumn(string));
    }

    @Override
    public synchronized void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, (int)l);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateNCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public synchronized void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.updateAsciiStream(n, inputStream, (int)l);
    }

    @Override
    public synchronized void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(n, inputStream, (int)l);
    }

    @Override
    public synchronized void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, (int)l);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public synchronized void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(n, inputStream, (int)l);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBlob(this.findColumn(string), inputStream, l);
    }

    @Override
    public synchronized void updateClob(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, (int)l);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.updateClob(this.findColumn(string), reader, l);
    }

    @Override
    public synchronized void updateNClob(int n, Reader reader, long l) throws SQLException {
        this.updateNCharacterStream(n, reader, (long)((int)l));
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.updateNClob(this.findColumn(string), reader, l);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateNCharacterStream(columnIndex, x)");
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateNCharacterStream(columnLabel, reader)");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateAsciiStream(columnIndex, x)");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateBinaryStream(columnIndex, x)");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateCharacterStream(columnIndex, x)");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateAsciiStream(columnLabel, x)");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateBinaryStream(columnLabel, x)");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateCharacterStream(columnLabel, reader)");
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateBlob(columnIndex, inputStream)");
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateBlob(columnLabel, inputStream)");
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateClob(columnIndex,  reader)");
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateClob(columnLabel,  reader)");
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateNClob(columnIndex,  reader)");
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "updateNClob(columnLabel,  reader)");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw OPLMessage_x.makeExceptionV(36, clazz.toString());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        if (clazz == null) {
            throw new SQLException("Type parameter can not be null", "S1009");
        }
        if (clazz.equals(String.class)) {
            return (T)this.getString(n);
        }
        if (clazz.equals(BigDecimal.class)) {
            return (T)this.getBigDecimal(n);
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(this.getBoolean(n));
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(this.getInt(n));
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return (T)Long.valueOf(this.getLong(n));
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return (T)Float.valueOf(this.getFloat(n));
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return (T)Double.valueOf(this.getDouble(n));
        }
        if (clazz.equals(byte[].class)) {
            return (T)this.getBytes(n);
        }
        if (clazz.equals(Date.class)) {
            return (T)this.getDate(n);
        }
        if (clazz.equals(Time.class)) {
            return (T)this.getTime(n);
        }
        if (clazz.equals(Timestamp.class)) {
            return (T)this.getTimestamp(n);
        }
        if (clazz.equals(Clob.class)) {
            return (T)this.getClob(n);
        }
        if (clazz.equals(Blob.class)) {
            return (T)this.getBlob(n);
        }
        if (clazz.equals(Array.class)) {
            return (T)this.getArray(n);
        }
        if (clazz.equals(Ref.class)) {
            return (T)this.getRef(n);
        }
        if (clazz.equals(URL.class)) {
            return (T)this.getURL(n);
        }
        try {
            return (T)this.getObject(n);
        }
        catch (ClassCastException classCastException) {
            throw new SQLException("Conversion not supported for type " + clazz.getName(), "S1009");
        }
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        return this.getObject(this.findColumn(string), clazz);
    }

    private Row getCurRow() {
        if (this.onInsertRow) {
            return this.updateRow;
        }
        return (Row)this.rowsData.get(this.curRow);
    }

    private void check_pos(String string) throws SQLException {
        if (this.isAfterLast() || this.isBeforeFirst()) {
            throw OPLMessage_x.makeException(30);
        }
    }

    private void check_move(String string, boolean bl) throws SQLException {
        if (this.onInsertRow) {
            throw OPLMessage_x.makeExceptionV(18, string);
        }
        if (!bl && this.getType() == 1003) {
            throw OPLMessage_x.makeExceptionV(19, string);
        }
    }

    private void check_InsertMode(String string) throws SQLException {
        if (this.onInsertRow) {
            throw OPLMessage_x.makeExceptionV(18, string);
        }
    }

    private void closeInputStream() {
        if (this.objInputStream != null) {
            try {
                this.objInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.objInputStream = null;
        }
        if (this.objReader != null) {
            try {
                this.objReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.objReader = null;
        }
    }

    private void check_Update(String string) throws SQLException {
        if (this.getConcurrency() == 1007) {
            throw OPLMessage_x.makeExceptionV(20, string);
        }
    }

    private int checkColumnIndex(int n) throws SQLException {
        if (this.rowSMD == null || (this.curState == 5 || this.countRows == 0) && !this.onInsertRow) {
            throw OPLMessage_x.makeException(21);
        }
        if (!this.onInsertRow && (this.isAfterLast() || this.isBeforeFirst())) {
            throw OPLMessage_x.makeException(30);
        }
        if (n < 1 || n > this.rowSMD.getColumnCount()) {
            throw OPLMessage_x.makeException(9);
        }
        return n;
    }

    private void cancelUpdates() {
        if (this.updateRow != null) {
            this.updateRow.clear();
        }
        this.updateRow = null;
    }

    private Row getRowForUpdate(int n, String string) throws SQLException {
        this.check_Update(string);
        this.checkColumnIndex(n);
        if (this.updateRow == null) {
            this.updateRow = new Row(this.rowSMD.getColumnCount());
        }
        return this.updateRow;
    }

    private synchronized void updateNumber(int n, Number number, String string, String string2) throws SQLException {
        Row row = this.getRowForUpdate(n, string2);
        switch (this.rowSMD.getColumnType(n)) {
            case 16: {
                row.setColData(n, new Boolean(number.intValue() != 0));
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                row.setColData(n, number);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                row.setColData(n, number.toString());
                break;
            }
            default: {
                throw OPLMessage_x.makeExceptionV(17, string);
            }
        }
    }

    private boolean _next() throws SQLException {
        if (this.countRows == 0) {
            this.curState = 5;
            return false;
        }
        if (this.curRow >= this.countRows) {
            this.curState = 4;
            return false;
        }
        boolean bl = false;
        while (!bl) {
            ++this.curRow;
            if (this.curRow >= this.countRows) break;
            bl = true;
            if (this.showDeleted || !((Row)this.rowsData.get((int)this.curRow)).isDeleted) continue;
            bl = false;
        }
        if (bl) {
            ++this.absolutePos;
            if (this.curState == 0) {
                this.curState = 1;
            } else {
                this.curState = 2;
                if (this.curRow == this.countRows - 1) {
                    this.curState = 3;
                } else {
                    boolean bl2 = false;
                    int n = this.curRow;
                    while (!bl2 && ++n < this.countRows) {
                        bl2 = true;
                        if (this.showDeleted || !((Row)this.rowsData.get((int)n)).isDeleted) continue;
                        bl2 = false;
                    }
                    if (!bl2) {
                        this.curState = 3;
                    }
                }
            }
        } else {
            if (this.curState == 3) {
                ++this.absolutePos;
            }
            this.curState = 4;
        }
        return bl;
    }

    private boolean _previous() throws SQLException {
        if (this.countRows == 0) {
            this.curState = 5;
            return false;
        }
        if (this.curRow < 0) {
            this.curState = 0;
            return false;
        }
        boolean bl = false;
        while (!bl) {
            --this.curRow;
            if (this.curRow < 0) break;
            bl = true;
            if (this.showDeleted || !((Row)this.rowsData.get((int)this.curRow)).isDeleted) continue;
            bl = false;
        }
        if (bl) {
            --this.absolutePos;
            if (this.curState == 4) {
                this.curState = 3;
            } else {
                this.curState = 2;
                if (this.curRow == 0) {
                    this.curState = 1;
                } else {
                    boolean bl2 = false;
                    int n = this.curRow;
                    while (!bl2 && --n >= 0) {
                        bl2 = true;
                        if (this.showDeleted || !((Row)this.rowsData.get((int)n)).isDeleted) continue;
                        bl2 = false;
                    }
                    if (!bl2) {
                        this.curState = 1;
                    }
                }
            }
        } else {
            if (this.curState == 1) {
                --this.absolutePos;
            }
            this.curState = 0;
        }
        return bl;
    }

    private boolean _first() throws SQLException {
        this._beforeFirst();
        return this._next();
    }

    private boolean _last() throws SQLException {
        this._afterLast();
        return this._previous();
    }

    private void _afterLast() throws SQLException {
        if (this.countRows == 0) {
            this.curState = 5;
        } else {
            this.curRow = this.countRows;
            this.absolutePos = this.countRows - (this.showDeleted ? 0 : this.countDeleted) + 1;
            this.curState = 4;
        }
    }

    private void _beforeFirst() throws SQLException {
        if (this.countRows == 0) {
            this.curState = 5;
        } else {
            this.curRow = -1;
            this.absolutePos = 0;
            this.curState = 0;
        }
    }

    private byte[] HexString2Bin(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        int n = string.length() / 2 * 2;
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = Character.digit(string.charAt(n2), 16);
            int n5 = Character.digit(string.charAt(n2 + 1), 16);
            if (n4 == -1 || n5 == -1) {
                throw OPLMessage_x.makeException(22);
            }
            byArray[n3] = (byte)(n4 * 16 + n5);
            n2 += 2;
            ++n3;
        }
        return byArray;
    }

    private String Bin2Hex(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        String string = "0123456789ABCDEF";
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            stringBuffer.append(string.charAt(by >>> 4 & 0xF));
            stringBuffer.append(string.charAt(by & 0xF));
        }
        return stringBuffer.toString();
    }

    private Date _getDate(String string) {
        Date date = null;
        if (string == null) {
            return null;
        }
        try {
            date = Date.valueOf(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (date == null) {
            try {
                DateFormat dateFormat = DateFormat.getDateInstance();
                java.util.Date date2 = dateFormat.parse(string);
                date = new Date(date2.getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return date;
    }

    private Timestamp _getTimestamp(String string) {
        Timestamp timestamp = null;
        if (string == null) {
            return null;
        }
        try {
            timestamp = Timestamp.valueOf(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (timestamp == null) {
            try {
                DateFormat dateFormat = DateFormat.getDateInstance();
                java.util.Date date = dateFormat.parse(string);
                timestamp = new Timestamp(date.getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return timestamp;
    }

    private Time _getTime(String string) {
        Time time = null;
        if (string == null) {
            return null;
        }
        try {
            time = Time.valueOf(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (time == null) {
            try {
                DateFormat dateFormat = DateFormat.getTimeInstance();
                java.util.Date date = dateFormat.parse(string);
                time = new Time(date.getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return time;
    }

    private class RowSetWriter
    implements Serializable,
    Cloneable {
        private transient Connection conn;
        private String updateSQL;
        private String deleteSQL;
        private String insertSQL;
        private int[] keyCols;
        private ResultSetMetaData rsmd;
        private int colCount;
        private LinkedList<Object> params = new LinkedList();

        private RowSetWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean writeData(RowSetInternal rowSetInternal) throws SQLException {
            OPLCachedRowSet oPLCachedRowSet = (OPLCachedRowSet)rowSetInternal;
            boolean bl = false;
            boolean bl2 = false;
            this.conn = oPLCachedRowSet.rowSetReader.connect(oPLCachedRowSet);
            if (this.conn == null) {
                throw OPLMessage_x.makeException(31);
            }
            if (this.conn.getAutoCommit()) {
                this.conn.setAutoCommit(false);
            }
            this.conn.setTransactionIsolation(oPLCachedRowSet.getTransactionIsolation());
            this.initializeStmts(oPLCachedRowSet);
            bl = oPLCachedRowSet.getShowDeleted();
            oPLCachedRowSet.setShowDeleted(true);
            try {
                oPLCachedRowSet.beforeFirst();
                while (!bl2 && oPLCachedRowSet.next()) {
                    if (!oPLCachedRowSet.rowDeleted() || oPLCachedRowSet.rowInserted()) continue;
                    bl2 = this.doDelete(oPLCachedRowSet);
                }
                oPLCachedRowSet.beforeFirst();
                while (!bl2 && oPLCachedRowSet.next()) {
                    if (!oPLCachedRowSet.rowUpdated() || oPLCachedRowSet.rowDeleted() || oPLCachedRowSet.rowInserted()) continue;
                    bl2 = this.doUpdate(oPLCachedRowSet);
                }
                PreparedStatement preparedStatement = this.conn.prepareStatement(this.insertSQL);
                try {
                    preparedStatement.setMaxFieldSize(oPLCachedRowSet.getMaxFieldSize());
                    preparedStatement.setEscapeProcessing(oPLCachedRowSet.getEscapeProcessing());
                    preparedStatement.setQueryTimeout(oPLCachedRowSet.getQueryTimeout());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                oPLCachedRowSet.beforeFirst();
                while (!bl2 && oPLCachedRowSet.next()) {
                    if (!oPLCachedRowSet.rowInserted() || oPLCachedRowSet.rowDeleted()) continue;
                    bl2 = this.doInsert(preparedStatement, oPLCachedRowSet);
                }
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                oPLCachedRowSet.setShowDeleted(bl);
            }
            try {
                if (bl2) {
                    this.conn.rollback();
                    boolean bl3 = false;
                    return bl3;
                }
                this.conn.commit();
                boolean bl4 = true;
                return bl4;
            }
            finally {
                oPLCachedRowSet.rowSetReader.close();
                this.conn = null;
                this.rsmd = null;
                this.params.clear();
            }
        }

        private boolean doUpdate(OPLCachedRowSet oPLCachedRowSet) throws SQLException {
            ResultSet resultSet = oPLCachedRowSet.getOriginalRow();
            if (!resultSet.next()) {
                return true;
            }
            StringBuffer stringBuffer = new StringBuffer(this.updateSQL);
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            boolean bl = false;
            for (int i = 1; i <= this.colCount; ++i) {
                if (!oPLCachedRowSet.columnUpdated(i)) continue;
                if (!bl) {
                    bl = true;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.rsmd.getColumnName(i));
                stringBuffer.append(" = ? ");
                linkedList.add(new Integer(i));
            }
            stringBuffer.append(" WHERE ");
            stringBuffer.append(this.createWhere(this.keyCols, resultSet));
            PreparedStatement preparedStatement = this.conn.prepareStatement(stringBuffer.toString());
            try {
                preparedStatement.setMaxFieldSize(oPLCachedRowSet.getMaxFieldSize());
                preparedStatement.setEscapeProcessing(oPLCachedRowSet.getEscapeProcessing());
                preparedStatement.setQueryTimeout(oPLCachedRowSet.getQueryTimeout());
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = 0;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                Object object = oPLCachedRowSet.getObject(n2);
                if (oPLCachedRowSet.wasNull()) {
                    preparedStatement.setNull(++n, this.rsmd.getColumnType(n2));
                    continue;
                }
                preparedStatement.setObject(++n, object);
            }
            iterator = this.params.iterator();
            while (iterator.hasNext()) {
                preparedStatement.setObject(++n, iterator.next());
            }
            if (preparedStatement.executeUpdate() != 1) {
                return true;
            }
            preparedStatement.close();
            return false;
        }

        private boolean doInsert(PreparedStatement preparedStatement, OPLCachedRowSet oPLCachedRowSet) throws SQLException {
            for (int i = 1; i <= this.colCount; ++i) {
                Object object = oPLCachedRowSet.getObject(i);
                if (oPLCachedRowSet.wasNull()) {
                    preparedStatement.setNull(i, this.rsmd.getColumnType(i));
                    continue;
                }
                preparedStatement.setObject(i, object);
            }
            return preparedStatement.executeUpdate() != 1;
        }

        private boolean doDelete(OPLCachedRowSet oPLCachedRowSet) throws SQLException {
            ResultSet resultSet = oPLCachedRowSet.getOriginalRow();
            if (!resultSet.next()) {
                return true;
            }
            String string = this.createWhere(this.keyCols, resultSet);
            PreparedStatement preparedStatement = this.conn.prepareStatement(this.deleteSQL + string);
            try {
                preparedStatement.setMaxFieldSize(oPLCachedRowSet.getMaxFieldSize());
                preparedStatement.setEscapeProcessing(oPLCachedRowSet.getEscapeProcessing());
                preparedStatement.setQueryTimeout(oPLCachedRowSet.getQueryTimeout());
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = 0;
            Iterator iterator = this.params.iterator();
            while (iterator.hasNext()) {
                preparedStatement.setObject(++n, iterator.next());
            }
            if (preparedStatement.executeUpdate() != 1) {
                return true;
            }
            preparedStatement.close();
            return false;
        }

        private String createWhere(int[] nArray, ResultSet resultSet) throws SQLException {
            StringBuffer stringBuffer = new StringBuffer();
            this.params.clear();
            for (int i = 0; i < nArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append("AND ");
                }
                stringBuffer.append(this.rsmd.getColumnName(nArray[i]));
                Object object = resultSet.getObject(nArray[i]);
                if (resultSet.wasNull()) {
                    stringBuffer.append(" IS NULL ");
                    continue;
                }
                stringBuffer.append(" = ? ");
                this.params.add(object);
            }
            return stringBuffer.toString();
        }

        private void initializeStmts(OPLCachedRowSet oPLCachedRowSet) throws SQLException {
            CharSequence charSequence;
            CharSequence charSequence2;
            this.rsmd = oPLCachedRowSet.getMetaData();
            if (this.rsmd == null) {
                throw OPLMessage_x.makeException(32);
            }
            this.colCount = this.rsmd.getColumnCount();
            if (this.colCount < 1) {
                return;
            }
            DatabaseMetaData databaseMetaData = this.conn.getMetaData();
            String string = oPLCachedRowSet.getTableName();
            if (string == null) {
                charSequence2 = this.rsmd.getSchemaName(1);
                if (charSequence2 != null && ((String)charSequence2).length() == 0) {
                    charSequence2 = null;
                }
                if ((charSequence = this.rsmd.getTableName(1)) == null || charSequence != null && ((String)charSequence).length() == 0) {
                    throw OPLMessage_x.makeExceptionV(33, "'RowSetWriter'");
                }
                string = (String)charSequence2 + "." + (String)charSequence;
            }
            charSequence2 = new StringBuffer("UPDATE ");
            charSequence = new StringBuffer("INSERT INTO ");
            StringBuffer stringBuffer = new StringBuffer("DELETE FROM ");
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            for (int i = 1; i <= this.colCount; ++i) {
                if (i > 1) {
                    stringBuffer2.append(", ");
                    stringBuffer3.append(", ");
                } else {
                    stringBuffer2.append(" ");
                    stringBuffer3.append(" ");
                }
                stringBuffer2.append(this.rsmd.getColumnName(i));
                stringBuffer3.append('?');
            }
            ((StringBuffer)charSequence2).append(string);
            ((StringBuffer)charSequence2).append(" SET ");
            stringBuffer.append(string);
            stringBuffer.append(" WHERE ");
            ((StringBuffer)charSequence).append(string);
            ((StringBuffer)charSequence).append("(");
            ((StringBuffer)charSequence).append(stringBuffer2.toString());
            ((StringBuffer)charSequence).append(") VALUES ( ");
            ((StringBuffer)charSequence).append(stringBuffer3.toString());
            ((StringBuffer)charSequence).append(")");
            this.insertSQL = ((StringBuffer)charSequence).toString();
            this.updateSQL = ((StringBuffer)charSequence2).toString();
            this.deleteSQL = stringBuffer.toString();
            this.setKeyCols(oPLCachedRowSet);
        }

        private void setKeyCols(OPLCachedRowSet oPLCachedRowSet) throws SQLException {
            this.keyCols = oPLCachedRowSet.getKeyCols();
            if (this.keyCols == null || this.keyCols.length == 0) {
                int n = 0;
                int[] nArray = new int[this.colCount];
                for (int i = 1; i <= this.colCount; ++i) {
                    switch (this.rsmd.getColumnType(i)) {
                        case -15: 
                        case -9: 
                        case -8: 
                        case -7: 
                        case -6: 
                        case -5: 
                        case -3: 
                        case -2: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 12: 
                        case 16: 
                        case 70: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 2001: {
                            nArray[n++] = i;
                        }
                    }
                }
                if (n > 0) {
                    this.keyCols = new int[n];
                    System.arraycopy(nArray, 0, this.keyCols, 0, n);
                }
            }
            if (this.keyCols == null && this.keyCols.length == 0) {
                throw OPLMessage_x.makeExceptionV(34, "'RowSetWriter'");
            }
        }
    }

    private class RowSetReader
    implements Serializable,
    Cloneable {
        private transient Connection conn;

        private RowSetReader() {
        }

        protected Connection connect(RowSet rowSet) throws SQLException {
            String string = rowSet.getDataSourceName();
            if (string != null) {
                try {
                    InitialContext initialContext = new InitialContext();
                    DataSource dataSource = (DataSource)initialContext.lookup(string);
                    return dataSource.getConnection(rowSet.getUsername(), rowSet.getPassword());
                }
                catch (NamingException namingException) {
                    throw OPLMessage_x.makeException(namingException);
                }
            }
            string = rowSet.getUrl();
            if (string != null) {
                return DriverManager.getConnection(string, rowSet.getUsername(), rowSet.getPassword());
            }
            return null;
        }

        private void setParams(PreparedStatement preparedStatement, Object[] objectArray) throws SQLException {
            if (objectArray == null) {
                return;
            }
            block14: for (int i = 0; i < objectArray.length; ++i) {
                BaseRowSet.Parameter parameter = (BaseRowSet.Parameter)objectArray[i];
                switch (parameter.jType) {
                    case 0: {
                        preparedStatement.setObject(i + 1, parameter.value);
                        continue block14;
                    }
                    case 1: {
                        preparedStatement.setObject(i + 1, parameter.value, parameter.sqlType);
                        continue block14;
                    }
                    case 2: {
                        preparedStatement.setObject(i + 1, parameter.value, parameter.sqlType, parameter.scale);
                        continue block14;
                    }
                    case 3: {
                        preparedStatement.setAsciiStream(i + 1, (InputStream)parameter.value, parameter.length);
                        continue block14;
                    }
                    case 4: {
                        preparedStatement.setBinaryStream(i + 1, (InputStream)parameter.value, parameter.length);
                        continue block14;
                    }
                    case 5: {
                        preparedStatement.setUnicodeStream(i + 1, (InputStream)parameter.value, parameter.length);
                        continue block14;
                    }
                    case 6: {
                        preparedStatement.setCharacterStream(i + 1, (Reader)parameter.value, parameter.length);
                        continue block14;
                    }
                    case 7: {
                        preparedStatement.setDate(i + 1, (Date)parameter.value, parameter.cal);
                        continue block14;
                    }
                    case 8: {
                        preparedStatement.setTime(i + 1, (Time)parameter.value, parameter.cal);
                        continue block14;
                    }
                    case 9: {
                        preparedStatement.setTimestamp(i + 1, (Timestamp)parameter.value, parameter.cal);
                        continue block14;
                    }
                    case 10: {
                        preparedStatement.setNull(i + 1, parameter.sqlType);
                        continue block14;
                    }
                    case 11: {
                        preparedStatement.setNull(i + 1, parameter.sqlType, parameter.typeName);
                        continue block14;
                    }
                    default: {
                        throw OPLMessage_x.makeException(10);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readData(RowSetInternal rowSetInternal) throws SQLException {
            boolean bl = false;
            this.close();
            try {
                OPLCachedRowSet oPLCachedRowSet = (OPLCachedRowSet)rowSetInternal;
                oPLCachedRowSet.release();
                this.conn = rowSetInternal.getConnection();
                if (this.conn == null) {
                    this.conn = this.connect(oPLCachedRowSet);
                    bl = true;
                }
                if (this.conn == null || oPLCachedRowSet.getCommand() == null) {
                    throw OPLMessage_x.makeException(11);
                }
                try {
                    this.conn.setTransactionIsolation(oPLCachedRowSet.getTransactionIsolation());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PreparedStatement preparedStatement = this.conn.prepareStatement(oPLCachedRowSet.getCommand(), oPLCachedRowSet.getType(), oPLCachedRowSet.getConcurrency());
                this.setParams(preparedStatement, rowSetInternal.getParams());
                try {
                    preparedStatement.setMaxRows(oPLCachedRowSet.getMaxRows());
                    preparedStatement.setMaxFieldSize(oPLCachedRowSet.getMaxFieldSize());
                    preparedStatement.setEscapeProcessing(oPLCachedRowSet.getEscapeProcessing());
                    preparedStatement.setQueryTimeout(oPLCachedRowSet.getQueryTimeout());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ResultSet resultSet = preparedStatement.executeQuery();
                oPLCachedRowSet.populate(resultSet);
                resultSet.close();
                preparedStatement.close();
                try {
                    this.conn.commit();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            finally {
                if (this.conn != null && bl) {
                    this.conn.close();
                } else {
                    this.conn = null;
                }
            }
        }

        private void close() throws SQLException {
            if (this.conn != null) {
                this.conn.close();
            }
            this.conn = null;
        }
    }

    private class Scanner {
        int pos = 0;
        int end;
        char[] query;
        static final String blankChars = " \t\n\r\f";
        static final String symb = "_-$#";
        HashMap<String, Integer> keywords = new HashMap();
        Token tok = null;

        private Scanner(String string) {
            this.query = string.toCharArray();
            this.end = this.query.length - 1;
            this.keywords.put("SELECT", new Integer(6));
            this.keywords.put("FROM", new Integer(7));
            this.keywords.put("WHERE", new Integer(8));
            this.keywords.put("ORDER", new Integer(9));
            this.keywords.put("BY", new Integer(10));
            this.keywords.put("GROUP", new Integer(11));
            this.keywords.put("UNION", new Integer(12));
            this.keywords.put("HAVING", new Integer(13));
        }

        private String check_Select() {
            String string = null;
            this.tok = this.nextToken();
            if (this.tok == null || this.tok.type != 6) {
                return null;
            }
            while ((this.tok = this.nextToken()) != null && this.tok.type != 7) {
            }
            string = this.table_name();
            if (string == null) {
                return null;
            }
            if (this.tok == null) {
                return string;
            }
            if (this.tok.type == 5 && (this.tok = this.nextToken()) == null) {
                return string;
            }
            if (this.tok.type == 8) {
                while ((this.tok = this.nextToken()) != null && this.tok.type != 11 && this.tok.type != 13) {
                }
            } else {
                return null;
            }
            if (this.tok != null) {
                return null;
            }
            return string;
        }

        private String table_name() {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            block27: while ((this.tok = this.nextToken()) != null) {
                switch (n) {
                    case 0: {
                        if (this.tok.type == 5) {
                            n = 1;
                            stringBuffer.append(new String(this.query, this.tok.start, this.tok.length));
                            continue block27;
                        }
                        return null;
                    }
                    case 1: {
                        switch (this.tok.type) {
                            case 1: {
                                stringBuffer.append('.');
                                n = 2;
                                continue block27;
                            }
                            case 3: {
                                stringBuffer.append('@');
                                n = 3;
                                continue block27;
                            }
                            case 2: {
                                stringBuffer.append(':');
                                n = 4;
                                continue block27;
                            }
                        }
                        return stringBuffer.toString();
                    }
                    case 2: {
                        switch (this.tok.type) {
                            case 5: {
                                stringBuffer.append(new String(this.query, this.tok.start, this.tok.length));
                                n = 5;
                                continue block27;
                            }
                            case 1: {
                                stringBuffer.append('.');
                                n = 6;
                                continue block27;
                            }
                        }
                        return null;
                    }
                    case 3: {
                        if (this.tok.type == 5) {
                            stringBuffer.append(new String(this.query, this.tok.start, this.tok.length));
                            n = 99;
                            continue block27;
                        }
                        return null;
                    }
                    case 4: {
                        if (this.tok.type == 5) {
                            stringBuffer.append(new String(this.query, this.tok.start, this.tok.length));
                            n = 7;
                            continue block27;
                        }
                        return null;
                    }
                    case 5: {
                        switch (this.tok.type) {
                            case 1: {
                                stringBuffer.append('.');
                                n = 8;
                                continue block27;
                            }
                            case 3: {
                                stringBuffer.append('@');
                                n = 9;
                                continue block27;
                            }
                        }
                        return stringBuffer.toString();
                    }
                    case 6: {
                        if (this.tok.type == 5) {
                            stringBuffer.append(new String(this.query, this.tok.start, this.tok.length));
                            n = 99;
                            continue block27;
                        }
                        return null;
                    }
                    case 7: {
                        if (this.tok.type == 1) {
                            stringBuffer.append('.');
                            n = 10;
                            continue block27;
                        }
                        return stringBuffer.toString();
                    }
                    case 8: {
                        if (this.tok.type == 5) {
                            stringBuffer.append(new String(this.query, this.tok.start, this.tok.length));
                            n = 99;
                            continue block27;
                        }
                        return null;
                    }
                    case 9: {
                        if (this.tok.type == 5) {
                            stringBuffer.append(new String(this.query, this.tok.start, this.tok.length));
                            n = 99;
                            continue block27;
                        }
                        return null;
                    }
                    case 10: {
                        if (this.tok.type == 5) {
                            stringBuffer.append(new String(this.query, this.tok.start, this.tok.length));
                            n = 99;
                            continue block27;
                        }
                        return null;
                    }
                    case 99: {
                        return stringBuffer.toString();
                    }
                }
                return null;
            }
            if (n == 1 || n == 5 || n == 7 || n == 99) {
                return stringBuffer.toString();
            }
            return null;
        }

        private Token nextToken() {
            if (this.pos <= this.end) {
                while (this.pos <= this.end && this.isBlank(this.query[this.pos])) {
                    ++this.pos;
                }
                if (this.pos > this.end) {
                    return null;
                }
                switch (this.query[this.pos++]) {
                    case '.': {
                        return new Token(1);
                    }
                    case ':': {
                        return new Token(2);
                    }
                    case '@': {
                        return new Token(3);
                    }
                    case ',': {
                        return new Token(4);
                    }
                    case '\"': 
                    case '\'': {
                        char c = this.query[this.pos - 1];
                        int n = this.pos - 1;
                        if (this.pos <= this.end && (this.query[this.pos] == '_' || Character.isLetterOrDigit(this.query[this.pos]))) {
                            while (this.pos <= this.end && this.isLetterOrDigit(this.query[this.pos])) {
                                ++this.pos;
                            }
                            if (this.pos > this.end || this.pos <= this.end && this.query[this.pos] != c) {
                                return new Token(-1);
                            }
                            ++this.pos;
                            return new Token(5, n, this.pos - 1, true);
                        }
                        return new Token(-1);
                    }
                }
                int n = this.pos - 1;
                if (this.pos <= this.end && (this.query[this.pos] == '_' || Character.isLetterOrDigit(this.query[this.pos]))) {
                    while (this.pos <= this.end && this.isLetterOrDigit(this.query[this.pos])) {
                        ++this.pos;
                    }
                    Integer n2 = this.keywords.get(new String(this.query, n, this.pos - n).toUpperCase());
                    if (n2 != null) {
                        return new Token((int)n2, n, this.pos - 1);
                    }
                    return new Token(5, n, this.pos - 1);
                }
                return new Token(this.query[n]);
            }
            return null;
        }

        private boolean isBlank(int n) {
            return blankChars.indexOf(n) != -1;
        }

        private boolean isLetterOrDigit(int n) {
            return Character.isLetterOrDigit((char)n) || symb.indexOf(n) != -1;
        }

        private class Token {
            static final int T_ERROR = -1;
            static final int T_CHAR = 0;
            static final int T_DOT = 1;
            static final int T_COLON = 2;
            static final int T_DELIM = 3;
            static final int T_COMMA = 4;
            static final int T_STRING = 5;
            static final int T_SELECT = 6;
            static final int T_FROM = 7;
            static final int T_WHERE = 8;
            static final int T_ORDER = 9;
            static final int T_BY = 10;
            static final int T_GROUP = 11;
            static final int T_UNION = 12;
            static final int T_HAVING = 13;
            private int type;
            private int start;
            private int end;
            private int length;
            private boolean quoted;
            private char symbol;

            private Token(int n, int n2, int n3) {
                this.type = n;
                this.start = n2;
                this.end = n3;
                this.length = this.end - this.start + 1;
            }

            private Token(int n, int n2, int n3, boolean bl) {
                this(n, n2, n3);
                this.quoted = bl;
            }

            private Token(int n) {
                this.type = n;
            }

            private Token(char c) {
                this.type = 0;
                this.symbol = c;
            }
        }
    }

    protected class Row
    implements Serializable,
    Cloneable {
        private Object[] origData;
        private Object[] curData;
        private BitSet colUpdated;
        private int cols;
        protected boolean isDeleted;
        protected boolean isUpdated;
        protected boolean isInserted;

        private Row(int n) {
            this.origData = new Object[n];
            this.curData = new Object[n];
            this.colUpdated = new BitSet(n);
            this.cols = n;
        }

        private Row(Object[] objectArray) {
            this.cols = objectArray.length;
            this.origData = new Object[this.cols];
            this.curData = new Object[this.cols];
            this.colUpdated = new BitSet(this.cols);
            for (int i = 0; i < this.cols; ++i) {
                this.origData[i] = objectArray[i];
            }
        }

        private void clear() {
            for (int i = 0; i < this.cols; ++i) {
                this.origData[i] = null;
                this.curData[i] = null;
                this.colUpdated.clear(i);
            }
            this.cols = 0;
        }

        private void setOrigColData(int n, Object object) {
            this.origData[n - 1] = object;
        }

        private boolean isColUpdated(int n) {
            return this.colUpdated.get(n - 1);
        }

        private Object getColData(int n) {
            if (this.colUpdated.get(--n)) {
                return this.curData[n];
            }
            return this.origData[n];
        }

        private void setColData(int n, Object object) {
            this.colUpdated.set(--n);
            this.curData[n] = object;
        }

        private Object[] getOrigData() {
            return this.origData;
        }

        private Object[] getCurData() {
            return this.curData;
        }

        private BitSet getListUpdatedCols() {
            return this.colUpdated;
        }

        private void update(Object[] objectArray, BitSet bitSet) {
            if (objectArray.length != this.cols) {
                throw new IllegalArgumentException();
            }
            this.isUpdated = true;
            for (int i = 0; i < this.cols; ++i) {
                if (!bitSet.get(i)) continue;
                this.colUpdated.set(i);
                this.curData[i] = objectArray[i];
            }
        }

        private void clearUpdated() {
            this.isUpdated = false;
            for (int i = 0; i < this.cols; ++i) {
                this.curData[i] = null;
                this.colUpdated.clear(i);
            }
        }

        private boolean isCompleted() throws SQLException {
            if (OPLCachedRowSet.this.rowSMD == null) {
                return false;
            }
            for (int i = 0; i < this.cols; ++i) {
                if (this.colUpdated.get(i) || OPLCachedRowSet.this.rowSMD.isNullable(i + 1) != 0) continue;
                return false;
            }
            return true;
        }

        private void moveCurToOrig() {
            for (int i = 0; i < this.cols; ++i) {
                if (!this.colUpdated.get(i)) continue;
                this.origData[i] = this.curData[i];
                this.colUpdated.clear(i);
                this.curData[i] = null;
            }
            this.isUpdated = false;
            this.isInserted = false;
        }
    }
}

