/* GKrellM
|  Copyright (C) 1999-2006 Bill Wilson
|
|  Author:  Bill Wilson    billw@gkrellm.net
|  Latest versions might be found at:  http://gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.  Version 2 is in the
|  COPYRIGHT file in the top level directory of this distribution.
| 
|  To get a copy of the GNU General Puplic License, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <string.h>


/* ---------------- Intercept GdkFont ------------------ */

extern int		gkrellm_gdk_text_width(void *font_desc,
						const char *text, int len);

extern void		*gkrellm_default_font(int n);
extern void		gkrellm_text_extents(void *font_desc, const char *text,
						int len, int *width, int *height,
						int *baseline, int *y_ink);

int
gdk_text_width(void *gdkfont, const char *string, int len)
	{
	void	*pfd;

	if (gdkfont == gkrellm_default_font(0))
		pfd = gdkfont;
	else if (gdkfont == gkrellm_default_font(2))
		pfd = gdkfont;
	else
		pfd = gkrellm_default_font(1);

	return gkrellm_gdk_text_width(pfd, string, len);
	}

int
gdk_string_width(void *font_desc, const char *string)
	{
	return gdk_text_width(font_desc, string, strlen(string));
	}

void
gdk_string_extents(void *font_desc, const char *string,
		int *l, int *r, int *w, int *a, int *d)
	{
	int	width, height, baseline, y_ink;

	gkrellm_text_extents(font_desc, string, strlen(string),
				&width, &height, &baseline, &y_ink);

	if (l)
		*l = 0;
	if (r)
		*r = width;
	if (w)
		*w = width;
	if (a)
		*a = baseline - y_ink;
	if (d)
		*d = y_ink + height - baseline;
	}
