/*-
 * sigToHost.c --
 *	Map a SIGNAL_ value to host specific signal number
 *
 * Copyright (c) 1982 Regents of the University of California.
 * Copyright (c) 1992 by Andreas Stolcke
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California,
 * and Andreas Stolcke make no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 */
#ifndef lint
static char *rcsid =
"$Id: sigToHost.c,v 1.1 1994/05/18 17:56:45 stolcke Exp $ ICSI (Berkeley)";
#endif /* not lint */

#include    "customs.h"

extern struct signal {
    int	signo;			/* OS specific signal number */
    char *name;			/* short signal name */
} signalList[];

/*-
 *-----------------------------------------------------------------------
 * Signal_ToHost --
 *	Map a SIGNAL_ value to host specific signal number
 *
 * Results:
 *	The host specific value.
 *
 * Side Effects:
 *	None.
 *
 *-----------------------------------------------------------------------
 */
int
Signal_ToHost (signal)
    int	    	  	signal;
{
    if (signal < 0 || signal > SIGNAL_INVAL) {
	signal = SIGNAL_INVAL;
    }
    return (signalList[signal].signo);
}

