#
#  Makefile for the parallel Make program.
#  Note that this Makefile is formatted for PMake itself, rather than make.
#
# This file is to be included by the makefiles in unix, customs and sprite.
#
# Use "make" and "makefile" to compile it the first time...
#
#  $Id: common.mk,v 1.27 1995/12/31 04:21:35 stolcke Exp $ SPRITE (Berkeley)
#

#
# Make sure variables are expanded the PMake way, even if DEF_OLD_VARS
# was used in compilation.
#
.MAKEFLAGS:	-C

#
# Path variables:
#	DESTDIR			Installation root
#	BINDIR			where pmake should be installed.
#	LIBDIR			place to store pmake's canned makefiles
#				(e.g. system.mk -- DEFSYSPATH in config.h)
#	SYSTEM_MK    	    	Actual name for the system makefile. I
#				use system.mk.
#	LIBSRC			where the pmake libraries are stored:
#		SPRITEDIR	where the Sprite->UNIX spriteibility
#				library is located.
#		LSTDIR		location of linked-list library
#		INCLUDE		where the sprite include files are
#
DESTDIR		=
BINDIR		= /usr/local/bin
LIBDIR		= /usr/local/lib/pmake
SYSTEM_MK	= system.mk

#
# The install program.  You will need something that behaves like
# BSD install, i.e., understands -m, -o and -g flags. Or, you may set this to
# /bin/cp, but then the flag macros below and in customs/Makefile have to be
# set to nothing and permissions will have to be adjusted by hand.
#
INSTALL		?= install -c

#
# Install flags for library files
#
LIBMODE		?= -m 444

LIBSRC		= $(.CURDIR)/../lib
SPRITEDIR	= $(LIBSRC)/sprite
LSTDIR		= $(LIBSRC)/lst
INCLUDE		= $(LIBSRC)/include
MKDIR		= $(LIBSRC)/mk

#ifndef DONT_MAKE_PMAKE

#if make(prof) && !defined(sun)
LISTLIB		= -llst_p
SPRITELIB	= -lsprite_p
#else
LISTLIB		= -llst
SPRITELIB	= -lsprite
#endif

#
# FLAG DEFINITIONS -- Flag variables for the various compilers, syntax
# checkers and whatnots
# CCFLAGS are for defining additional flags on the command line...
#
COFLAGS 	=
LDFLAGS		= $(.LIBS) 
LNFLAGS		= -b
XCFLAGS		=
CFLAGS		= $(.INCLUDES) $(XCFLAGS)

#
# SPECIAL TARGETS AND TRANSFORMATION RULES
# Note that the transformation rules from RCS files to standard ones includes
# the removal of any created .o file as well as the checked-out file.
# If you don't like this, nuke it.
#
.SUFFIXES	: .ln
	
# make sure MAKEOBJDIR is always defined
#ifndef MAKEOBJDIR
MAKEOBJDIR	= .
#endif

.PATH.h		: # Clear out .h path
.PATH.h		: . $(.CURDIR) $(.CURDIR)/../src $(LSTDIR) $(INCLUDE)
.PATH.a		: # Clear out .a path
.PATH.a		: $(LSTDIR)/$(MAKEOBJDIR) $(LSTDIR)
.PATH.ln	: $(LSTDIR)/$(MAKEOBJDIR) $(LSTDIR)
.PATH.c		: $(.CURDIR)/../src

.DEFAULT	:
	co $(.TARGET)

.c.o		: .EXPORTSAME
	$(CC) $(CFLAGS) -c $(.IMPSRC)

#if	!defined(VARS_ONLY)

#
# Alter egos you want to support. smake and vmake both do System V
# impersonations, while just make pretends to be Make
#
#ALIASES		= make smake vmake
ALIASES		= vmake

#
# SOURCE DEFINITIONS -- All Sources for this program:
#
HDRS		= make.h job.h nonints.h config.h
OBJS		= arch.o compat.o cond.o dir.o make.o job.o main.o parse.o \
		suff.o targ.o rmt.o str.o var.o
SRCS		= arch.c compat.c cond.c dir.c make.c job.c main.c parse.c \
		suff.c targ.c rmt.c str.c var.c

LLIBS		= llib-llst.ln
LIBS		= -llst -lsprite

MAKEFILES	= linksprite.mk po.mk makelib.mk makelint.mk shx.mk \
                  makedepend.mk sys-*.mk $(SYSTEM_MK)

.MAIN		: pmake

#
# set system makefile paths from LIBDIR definition above
#
CONFIGFLAGS	= -DDEFSYSPATH=\"$(LIBDIR)\" \
		  -DDEFSYSMK=\"$(SYSTEM_MK)\"

main.o		: main.c .EXPORTSAME
	$(CC) $(CFLAGS) $(CONFIGFLAGS) -c $<

#
# The actual installation of pmake itself is assumed to be done by the
# including makefile, but we need to set up the aliases and install the canned
# makefiles.
#

install		:: install-mk

install-mk	:: .NOEXPORT
	test -d $(DESTDIR)$(LIBDIR) || mkdir $(DESTDIR)$(LIBDIR)
	(cd $(MKDIR); for i in $(MAKEFILES); do
	    $(INSTALL) $(LIBMODE) $i $(DESTDIR)$(LIBDIR)/`basename $i`
	done)
	test -d $(DESTDIR)$(BINDIR) || mkdir $(DESTDIR)$(BINDIR)
	for i in  $(ALIASES); do
	    rm -f $(DESTDIR)$(BINDIR)/$i
	    ln -s pmake $(DESTDIR)$(BINDIR)/$i
	done

nonints		: $(SRCS) .NOTMAIN
	rm -f $(.CURDIR)/../src/nonints.h
	$(LIBSRC)/findni $(.ALLSRC) > /tmp/mni$$
	sed -e 's/(.*)/()/' /tmp/mni$$ > $(.CURDIR)/../src/nonints.h
	chmod 444 $(.CURDIR)/../src/nonints.h
	rm -f /tmp/mni$$

clean		:: .NOTMAIN .NOEXPORT
	rm -f $(OBJS)


tags		: $(HDRS) $(SRCS) .NOTMAIN
	@cd $(.CURDIR); ctags -u $(.OODATE:S@^$(.CURDIR)/@@g)

dirs		:
	test -d $(.CURDIR)/$(MAKEOBJDIR) || mkdir $(.CURDIR)/$(MAKEOBJDIR)

lint		:: $(SRCS) $(LLIBS) .NOTMAIN
	lint $(LNFLAGS) $(CFLAGS) $(.ALLSRC) > FLUFF 2>&1

co		: $(HDRS) $(SRCS) .NOTMAIN
	@chmod 664 $(.OODATE)

ci		: .NOTMAIN
	@ci $(SRCS) $(HDRS) < /dev/tty > /dev/tty 2>&1

#endif

DEPFILE		?= Makefile
#include	<makedepend.mk>

#ifdef HOST
rdist		: $(HDRS) $(SRCS) .NOTMAIN
	rdist -cyw $(SRCS) $(HDRS) $(LSTDIR) $(WILDDIR) \
		$(HOST):/sprite/src/cmds/pmake
#endif HOST

#endif DONT_MAKE_PMAKE
