/* hw_irq.h: hardware interrupt stuff
 *
 * Copyright (C) 2005 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */
#ifndef _ASM_HW_IRQ_H
#define _ASM_HW_IRQ_H

#include <asm/atomic.h>
#include <asm/irq.h>

extern int irq_vector[NR_IRQS];

/*
 * Various low-level irq details needed by irq.c, process.c,
 * time.c, io_apic.c and smp.c
 *
 * Interrupt entry/exit code at both C and assembly level
 */

extern void mask_irq(unsigned int irq);
extern void unmask_irq(unsigned int irq);

extern atomic_t irq_err_count;

#define __STR(x) #x
#define STR(x) __STR(x)

#define IRQ_NAME2(nr) nr##_interrupt(void)
#define IRQ_NAME(nr) IRQ_NAME2(IRQ##nr)

static inline void hw_resend_irq(struct hw_interrupt_type *h, unsigned int i) {}

#endif /* _ASM_HW_IRQ_H */
