Summary: Network monitoring tools including ping.
Name: iputils
Version: 20020927
Release: 16.gnupro.1
License: BSD
Group: System Environment/Daemons
Source0: http://ftp.sunet.se/pub/os/Linux/ip-routing/iputils-ss020927.tar.gz
Source1: ifenslave.c
Source2: README.bonding
Patch0: iputils-20020927-rh.patch
Patch1: iputils-20020124-ping_sparcfix.patch
Patch2: iputils-20020124-rdisc-server.patch
Patch3: iputils-20020124-countermeasures.patch
Patch4: iputils-20020927-addrcache.patch
Patch5: iputils-20020927-ping-subint.patch
Patch6: iputils-20020927-icmp_seq.patch
Patch7: iputils-glibckernheaders.patch
Patch8: iputils-20020927-headers.patch
Patch9: iputils-20020927-unaligned.patch
Patch10: iputils-20020927-inet_pton.patch
Prefix: %{_prefix}
BuildRoot: %{_tmppath}/%{name}-root
%if "%{_arch}" == %{_build_arch}
BuildPreReq: docbook-utils perl-SGMLSpm
%endif
BuildPreReq: glibc-kernheaders >= 2.4-8.19

%description
The iputils package contains basic utilities for monitoring a network,
including ping. The ping command sends a series of ICMP protocol
ECHO_REQUEST packets to a specified network host to discover whether
the target machine is alive and receiving network traffic.

%prep
%setup -q -n %{name}
cp %{SOURCE1} .
cp %{SOURCE2} .

%patch0 -p1 -b .rh
%patch1 -p1 -b .ping_sparcfix
%patch2 -p1 -b .rdisc-server
%patch3 -p1 -b .countermeasures
%patch4 -p1 -b .addrcache
%patch5 -p1 -b .ping-subint
%patch6 -p1 -b .icmp_seq
%patch7 -p1 -b .glibckernheaders
%patch8 -p1 -b .headers
%patch9 -p1 -b .unaligned
%patch10 -p1 -b .inet_pton

%build
%if "%{_arch}" == %{_build_arch}
%ifarch s390 s390x
export CFLAGS="$RPM_OPT_FLAGS -fPIE"
%else
export CFLAGS="$RPM_OPT_FLAGS -fpie"
%endif
export LDFLAGS="-pie"
%endif
make CC="%{__cc}"
%ifarch am33_2.0
%{__cc} -Wall -Wstrict-prototypes -O2 ifenslave.c -o ifenslave
%else
%{__cc} -Wall -Wstrict-prototypes -O3 ifenslave.c -o ifenslave
%endif
make -C doc man

%install
rm -rf ${RPM_BUILD_ROOT}

mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}
mkdir -p ${RPM_BUILD_ROOT}/{bin,sbin}
install -c clockdiff		${RPM_BUILD_ROOT}%{_sbindir}/
%ifos linux
install -c arping		${RPM_BUILD_ROOT}/sbin/
ln -s /sbin/arping		${RPM_BUILD_ROOT}%{_sbindir}/arping
install -c ping			${RPM_BUILD_ROOT}/bin/
install -c ifenslave		${RPM_BUILD_ROOT}/sbin/
%else
install -c arping		${RPM_BUILD_ROOT}%{_sbindir}/
install -c ping			${RPM_BUILD_ROOT}%{_sbindir}/
install -c ifenslave		${RPM_BUILD_ROOT}%{_sbindir}/
%endif
install -c rdisc		${RPM_BUILD_ROOT}/sbin/
install -c ping6		${RPM_BUILD_ROOT}/bin/
install -c tracepath		${RPM_BUILD_ROOT}/bin/
install -c tracepath6		${RPM_BUILD_ROOT}/bin/
install -c traceroute6		${RPM_BUILD_ROOT}/bin/

mkdir -p ${RPM_BUILD_ROOT}%{_bindir}
ln -sf /bin/ping6 ${RPM_BUILD_ROOT}%{_sbindir}
ln -sf /bin/tracepath ${RPM_BUILD_ROOT}%{_sbindir}
ln -sf /bin/tracepath6 ${RPM_BUILD_ROOT}%{_sbindir}
ln -sf /bin/traceroute6 ${RPM_BUILD_ROOT}%{_sbindir}

mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man8
install -c doc/clockdiff.8	${RPM_BUILD_ROOT}%{_mandir}/man8/
install -c doc/arping.8		${RPM_BUILD_ROOT}%{_mandir}/man8/
install -c doc/ping.8		${RPM_BUILD_ROOT}%{_mandir}/man8/
install -c doc/rdisc.8		${RPM_BUILD_ROOT}%{_mandir}/man8/
install -c doc/tracepath.8	${RPM_BUILD_ROOT}%{_mandir}/man8/

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%doc RELNOTES README.bonding
%{_sbindir}/clockdiff
%ifos linux
/sbin/arping
%{_sbindir}/arping
%attr(4755,root,root)	/bin/ping
/sbin/ifenslave
%else
%attr(4755,root,root)	%{_sbindir}/ping
%{_sbindir}/arping
%{_sbindir}/ifenslave
%endif
/sbin/rdisc
%attr(4755,root,root) /bin/ping6
/bin/tracepath
/bin/tracepath6
%attr(4755,root,root)/bin/traceroute6
%{_sbindir}/ping6
%{_sbindir}/tracepath
%{_sbindir}/tracepath6
%{_sbindir}/traceroute6
%{_mandir}/man8/*

%changelog
* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed May 12 2004 Phil Knirsch <pknirsch@redhat.com> 20020927-15
- Updated rh patch to enable PIE build of binaries.

* Thu Apr 22 2004 Phil Knirsch <pknirsch@redhat.com> 20020927-14
- Fixed bug with wrong return code check of inet_pton() in traceroute6 (#100684)

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Thu Oct 02 2003 Phil Knirsch <pknirsch@redhat.com> 20020927-12
- Fixed unaligned access problem on ia64 (#101417)

* Wed Sep 10 2003 Phil Knirsch <pknirsch@redhat.com> 20020927-11
- Don't use own headers, use glibc and kernheaders.

* Thu Sep 04 2003 Bill Nottingham <notting@redhat.com> 20020927-10
- fix build with new glibc-kernheaders

* Wed Sep 03 2003 Phil Knirsch <pknirsch@redhat.com> 20020927-9.1
- rebuilt

* Wed Sep 03 2003 Phil Knirsch <pknirsch@redhat.com> 20020927-9
- Start icmp_seq from 0 instead of 1 (Conform with debian and Solaris #100609).

* Thu Jul 31 2003 Phil Knirsch <pknirsch@redhat.com> 20020927-8
- One more update to ifenslave.c

* Mon Jun 16 2003 Phil Knirsch <pknirsch@redhat.com> 20020927-7
- Updated ifenslave.c and README.bonding to latest version.

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Thu May 15 2003 Phil Knirsch <pknirsch@redhat.com> 20020927-5
- Bumped release and rebuilt

* Thu May 15 2003 Phil Knirsch <pknirsch@redhat.com> 20020927-4
- Fixed DNS lookup problems (#68212).
- Added warning if binding problem failed on subinterface (#81640).

* Tue May 13 2003 Phil Knirsch <pknirsch@redhat.com> 20020927-3
- Removed bonding tarball and replaced it with ifenslave.c and README
- FHS compliance for all tools, now to be found in /bin with compat symlinks to
  old places.

* Wed Jan 22 2003 Tim Powers <timp@redhat.com> 20020927-2
- rebuilt

* Fri Nov 29 2002 Phil Knirsch <pknirsch@redhat.com> 20020927-1
- Updated to latest upstream version.

* Fri Jun 21 2002 Tim Powers <timp@redhat.com> 20020124-8
- automated rebuild

* Tue Jun 18 2002 Phil Knirsch <pknirsch@redhat.com> 20020124-7
- Added new BuildPreReqs for docbook-utils and perl-SGMLSpm (#66661)
- Fixed ipv6 error printing problem (#66659).

* Sun May 26 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Tue May 21 2002 Phil Knirsch <pknirsch@redhat.com>
- Added a patch to activate the rdisc server (#64270).
- Display the countermeasures warning only in verbose (#55236)

* Thu Apr 18 2002 Bill Nottingham <notting@redhat.com>
- quit trying to build HTML versions of the man pages

* Thu Mar 14 2002 Phil Knirsch <pknirsch@redhat.com>
- Added fix by Tom "spot" Callaway to fix buffer overflow problems in stats.

* Wed Feb 27 2002 Phil Knirsch <pknirsch@redhat.com>
- Update to iputils-ss020124.

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Mon Aug 27 2001 Philipp Knirsch <pknirsch@redhat.de> 20001110-6
- Fixed buffer overflow problem in traceroute6.c (#51135)

* Mon Jul 01 2001 Philipp Knirsch <pknirsch@redhat.de>
- Made ping6 and traceroute6 setuid (safe as they drop it VERY early) (#46769)

* Thu Jun 28 2001 Philipp Knirsch <pknirsch@redhat.de>
- Fixed ping statistics overflow bug (#43801)

* Tue Jun 26 2001 Philipp Knirsch <pknirsch@redhat.de>
- Fixed a bunch of compiler warnings (#37131)
- Fixed wrong exit code for no packets and deadline (#40323)
- Moved arping to /sbin from /usr/sbin due to ifup call (#45785). Symlink from
  /usr/sbin/ provided for backwards compatibility.

* Mon Apr 30 2001 Preston Brown <pbrown@redhat.com>
- install in.rdisc.8c as rdisc.8

* Tue Jan 16 2001 Jeff Johnson <jbj@redhat.com>
- update to ss001110
- doco fixes (#23844).

* Sun Oct  8 2000 Jeff Johnson <jbj@redhat.com>
- update to ss001007.

* Tue Aug  8 2000 Tim Waugh <twaugh@redhat.com>
- fix spelling mistake (#15714).

* Tue Aug  8 2000 Tim Waugh <twaugh@redhat.com>
- turn on -U on machines without TSC (#15223).

* Tue Aug  1 2000 Jeff Johnson <jbj@redhat.com>
- better doco patch (#15050).

* Tue Jul 25 2000 Jakub Jelinek <jakub@redhat.com>
- fix include-glibc/ to work with new glibc 2.2 resolver headers

* Thu Jul 13 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Sun Jun 18 2000 Jeff Johnson <jbj@redhat.com>
- FHS packaging.
- update to ss000418.
- perform reverse DNS lookup only once for same input.

* Sun Mar  5 2000 Jeff Johnson <jbj@redhat.com>
- include README.ifenslave doco.
- "ping -i N" was broke for N >= 3 (#9929).
- update to ss000121:
-- clockdiff: preserve raw socket errno.
-- ping: change error exit code to 1 (used to be 92,93, ...)
-- ping,ping6: if -w specified, transmit until -c limit is reached.
-- ping,ping6: exit code non-zero if some packets not received within deadline.

* Tue Feb 22 2000 Jeff Johnson <jbj@redhat.com>
- man page corrections (#9690).

* Wed Feb  9 2000 Jeff Johnson <jbj@jbj.org>
- add ifenslave.

* Thu Feb  3 2000 Elliot Lee <sopwith@redhat.com>
- List /usr/sbin/rdisc in %files list.

* Thu Jan 27 2000 Jeff Johnson <jbj@redhat.com>
- add remaining binaries.
- casts to remove compilation warnings.
- terminate if -w deadline is reached exactly (#8724).

* Fri Dec 24 1999 Jeff Johnson <jbj@redhat.com>
- create (only ping for now, traceroute et al soon).
