Summary: A security tool which acts as a wrapper for TCP daemons.
Name: tcp_wrappers
Version: 7.6
Release: 37.2.gnupro.1

%define LIB_MAJOR 0
%define LIB_MINOR 7
%define LIB_REL 6

Copyright: Distributable
Group: System Environment/Daemons
Source: ftp://ftp.porcupine.org/pub/security/%{name}_%{version}.tar.gz
URL: ftp://ftp.porcupine.org/pub/security/index.html
Patch0: tcpw7.2-config.patch
Patch1: tcpw7.2-setenv.patch
Patch2: tcpw7.6-netgroup.patch
Patch3: tcp_wrappers-7.6-bug11881.patch
Patch4: tcp_wrappers-7.6-bug17795.patch
Patch5: tcp_wrappers-7.6-bug17847.patch
Patch6: tcp_wrappers-7.6-fixgethostbyname.patch
Patch7: tcp_wrappers-7.6-docu.patch
Patch9: tcp_wrappers.usagi-ipv6.patch
Patch10: tcp_wrappers.ume-ipv6.patch
Patch11: tcp_wrappers-7.6-shared.patch
Patch12: tcp_wrappers-7.6-sig.patch
Patch13: tcp_wrappers-7.6-strerror.patch
Patch14: tcp_wrappers-7.6-ldflags.patch
Patch10000: tcp_wrappers-7.6-cross.patch
# required by sin_scope_id in ipv6 patch
BuildPreReq: glibc-devel >= 2.2		
BuildRoot: %{_tmppath}/%{name}-root

%description
The tcp_wrappers package provides small daemon programs which can
monitor and filter incoming requests for systat, finger, FTP, telnet,
rlogin, rsh, exec, tftp, talk and other network services.

Install the tcp_wrappers program if you need a security tool for
filtering incoming network services requests.

This version also supports IPv6.

%prep
%setup -q -n %{name}_%{version}
%patch0 -p1 -b .config
%patch1 -p1 -b .setenv
%patch2 -p1 -b .netgroup
%patch3 -p1 -b .bug11881
%patch4 -p1 -b .bug17795
%patch5 -p1 -b .bug17847
%patch6 -p1 -b .fixgethostbyname
%patch7 -p1 -b .docu
%patch9 -p0 -b .usagi-ipv6
%patch10 -p1 -b .ume-ipv6
%patch11 -p1 -b .shared
%patch12 -p1 -b .sig
%patch13 -p1 -b .strerror
%patch14 -p1 -b .cflags
%if "%{_arch}" != %{_build_arch}
%patch10000 -p1 -b .cross
%endif

%build
%if "%{_arch}" == %{_build_arch}
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS -fPIC -DPIC -D_REENTRANT -DHAVE_STRERROR" LDFLAGS="-pie" MAJOR=%{LIB_MAJOR} MINOR=%{LIB_MINOR} REL=%{LIB_REL} linux
%else
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS -fPIC -DPIC -D_REENTRANT -DHAVE_STRERROR" \
  MAJOR=%{LIB_MAJOR} MINOR=%{LIB_MINOR} REL=%{LIB_REL} \
  RANLIB=%{__ranlib} CC="%{__cc}" AR=%{__ar} linux
%endif


%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}%{_includedir}
mkdir -p ${RPM_BUILD_ROOT}%{_libdir}
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man{3,5,8}
mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}

cp hosts_access.3 ${RPM_BUILD_ROOT}%{_mandir}/man3
cp hosts_access.5 hosts_options.5 ${RPM_BUILD_ROOT}%{_mandir}/man5
cp tcpd.8 tcpdchk.8 tcpdmatch.8 ${RPM_BUILD_ROOT}%{_mandir}/man8
ln -sf hosts_access.5 ${RPM_BUILD_ROOT}%{_mandir}/man5/hosts.allow.5
ln -sf hosts_access.5 ${RPM_BUILD_ROOT}%{_mandir}/man5/hosts.deny.5
cp -a libwrap.a ${RPM_BUILD_ROOT}%{_libdir}
cp -a libwrap.so* ${RPM_BUILD_ROOT}%{_libdir}
cp tcpd.h ${RPM_BUILD_ROOT}%{_includedir}
install -m755 safe_finger ${RPM_BUILD_ROOT}%{_sbindir}
install -m711 tcpd ${RPM_BUILD_ROOT}%{_sbindir}
install -m755 try-from ${RPM_BUILD_ROOT}%{_sbindir}

# XXX remove utilities that expect /etc/inetd.conf (#16059).
#install -m755 tcpdchk ${RPM_BUILD_ROOT}%{_sbindir}
#install -m755 tcpdmatch ${RPM_BUILD_ROOT}%{_sbindir}
rm -f ${RPM_BUILD_ROOT}%{_mandir}/man8/tcpdmatch.*
rm -f ${RPM_BUILD_ROOT}%{_mandir}/man8/tcpdchk.*

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%doc BLURB CHANGES README* DISCLAIMER Banners.Makefile
%{_mandir}/man[358]/*
%{_includedir}/*
%{_libdir}/*.a
%{_libdir}/*.so*
%{_sbindir}/*

%changelog
* Thu Oct  7 2004 Thomas Woerner <twoerner@redhat.com> 7.6-37.2
- new URL and spec file cleanup, patch from Robert Scheck

* Mon Oct  4 2004 Thomas Woerner <twoerner@redhat.com> 7.6-37.1
- rebuilt

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Mar  5 2004 Thomas Woerner <twoerner@redhat.com> 7.6-36
- pied tcpd

* Tue Mar 02 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Sun Feb 16 2003 Florian La Roche <Florian.LaRoche@redhat.de>
- use strerror  #84312

* Tue Feb 11 2003 Harald Hoyer <harald@redhat.de> 7.6-33
- revert Nalins weak version
- link libwrap.so against libnsl, on which it depends

* Mon Feb 10 2003 Nalin Dahyabhai <nalin@redhat.com> 7.6-32
- link libwrap.so against libnsl, on which it depends
- add default (weak) versions of allow_severity and deny_severity to the shared
  library so that configure tests can find it correctly

* Mon Feb 10 2003 Harald Hoyer <harald@redhat.de> 7.6-29
- shared library generated and added #75494
- added security patch tcp_wrappers-7.6-sig.patch
- compile and link with -fPIC -DPIC

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Tue Jan  7 2003 Jeff Johnson <jbj@redhat.com> 7.6-25
- don't include -debuginfo files in package.

* Tue Nov 19 2002 Tim Powers <timp@redhat.com>
- rebuild on all arches

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Tue Jun 11 2002 Florian La Roche <Florian.LaRoche@redhat.de>
- fix #61192
- added Patch8 to fix #17847
- update IPv6 patch

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Sun Mar 11 2001 Pekka Savola <pekkas@netcore.fi>
- Add IPv6 patch from USAGI, enable it.

* Mon Feb  5 2001 Preston Brown <pbrown@redhat.com>
- fix gethostbyname to work better with dot "." notation (#16949)

* Sat Dec 30 2000 Jeff Johnson <jbj@redhat.com>
- permit hosts.{allow,deny} to be assembled from included components (#17795).
- permit '*' and '?' wildcard matches on hostnames (#17847).

* Sun Nov 19 2000 Bill Nottingham <notting@redhat.com>
- ia64 needs -fPIC too

* Mon Aug 14 2000 Jeff Johnson <jbj@redhat.com>
- remove utilities that expect /etc/inetd.conf (#16059).

* Thu Jul 27 2000 Jeff Johnson <jbj@redhat.com>
- security hardening (#11881).

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Tue Jun  6 2000 Jeff Johnson <jbj@redhat.com>
- FHS packaging.

* Tue May 16 2000 Chris Evans <chris@ferret.lmh.ox.ac.uk>
- Make tcpd mode -rwx--x--x as a security hardening measure

* Mon Feb  7 2000 Jeff Johnson <jbj@redhat.com>
- compress man pages.

* Mon Aug 23 1999 Jeff Johnson <jbj@redhat.com>
- add netgroup support (#3940).

* Wed May 26 1999 Jeff Johnson <jbj@redhat.com>
- compile on sparc with -fPIC.

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 7)

* Wed Dec 30 1998 Cristian Gafton <gafton@redhat.com>
- build for glibc 2.1

* Sat Aug 22 1998 Jeff Johnson <jbj@redhat.com>
- close setenv bug (problem #690)
- spec file cleanup

* Thu Jun 25 1998 Alan Cox <alan@redhat.com>
- Erp where did the Dec 05 patch escape to

* Thu May 07 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Fri Dec 05 1997 Erik Troan <ewt@redhat.com>
- don't build setenv.o module -- it just breaks things

* Wed Oct 29 1997 Marc Ewing <marc@redhat.com>
- upgrade to 7.6

* Thu Jul 17 1997 Erik Troan <ewt@redhat.com>
- built against glibc

* Mon Mar 03 1997 Erik Troan <ewt@redhat.com>
- Upgraded to version 7.5
- Uses a build root
