#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/syscall.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sched.h>
              
void process_file(char *filename)
{
	int fd;
	struct stat buf;
	
	if (!filename)
		return;
		
	fd = open(filename,O_RDONLY);
	if (fd<0)
		return;
	
	if (fstat(fd, &buf)<0) 	 
		return;
	
	/* don't readahead on nfs */
	if (!gnu_dev_major(buf.st_dev))
		return;
		
	readahead(fd, (loff_t)0, (size_t)buf.st_size);
	close(fd);
	/* be nice to other processes now */
	sched_yield();
}


int main(int argc, char **argv)
{
	int i;
	for (i=1; i<argc; i++)
		process_file(argv[i]);
	return 0;
}
