%if %{?WITH_SELINUX:0}%{!?WITH_SELINUX:1}
%define WITH_SELINUX 1
%endif

%define utf8_man_pages 1

Summary: Utilities for managing accounts and shadow password files.
Name: shadow-utils
Version: 4.0.3
Release: 56.gnupro.1
Epoch: 2
URL: http://shadow.pld.org.pl/
Source0: ftp://ftp.pld.org.pl/software/shadow/shadow-%{version}.tar.bz2
Source1: shadow-970616.login.defs
Source2: shadow-970616.useradd
Source3: adduser.8
Source4: pwunconv.8
Source5: grpconv.8
Source6: grpunconv.8
Patch0: shadow-4.0.3-redhat.patch
Patch1: shadow-4.0.3-noinst.patch
Patch2: shadow-4.0.3-nscd.patch
Patch3: shadow-19990827-group.patch
Patch4: shadow-4.0.3-vipw.patch
Patch5: shadow-4.0.3-mailspool.patch
Patch6: shadow-20000902-usg.patch
Patch7: shadow-4.0.3-shadow-man.patch
Patch8: shadow-utils-selinux.patch
Patch9: shadow-4.0.3-lastlog-size.patch
Patch10: shadow-4.0.3-largefile.patch
Patch11: shadow-4.0.3-fixref.patch
Patch12: shadow-4.0.3-uninitialized.patch
Patch13: shadow-4.0.3-removemalloc.patch
Patch14: shadow-4.0.3-useradd-unlock.patch
Patch15: shadow-4.0.3-chage-selinux.patch
Patch16: shadow-4.0.3-goodname.patch
Patch17: shadow-4.0.3-pl-n_useradd.8.patch
Patch18: shadow-4.0.3-skellink.patch
Patch19: shadow-4.0.3-matchpathcon.patch
Patch20: shadow-4.0.3-maxmem.patch
Patch21: shadow-4.0.3-debuginfo.patch

Patch10001: shadow-4.0.3-gcc4.patch

License: BSD
Group: System Environment/Base
%if "%{_arch}" == %{_build_arch}
BuildRequires: autoconf, automake, libtool, gettext-devel
%endif
BuildRequires: libselinux-devel
Buildroot: %{_tmppath}/%{name}-%{version}-root
Requires: coreutils
Obsoletes: adduser

%description
The shadow-utils package includes the necessary programs for
converting UNIX password files to the shadow password format, plus
programs for managing user and group accounts. The pwconv command
converts passwords to the shadow password format. The pwunconv command
unconverts shadow passwords and generates an npasswd file (a standard
UNIX password file). The pwck command checks the integrity of password
and shadow files. The lastlog command prints out the last login times
for all users. The useradd, userdel, and usermod commands are used for
managing user accounts. The groupadd, groupdel, and groupmod commands
are used for managing group accounts.

%prep
%setup -q -n shadow-%{version}
%patch0 -p1 -b .redhat
%patch1 -p1 -b .noinst
%patch2 -p1 -b .nscd
%patch3 -p1 -b .group
%patch4 -p1 -b .vipw
%patch5 -p1 -b .mailspool
%patch6 -p1 -b .usg
%patch7 -p1 -b .shadow-man
%patch8 -p1 -b .selinux
%patch9 -p1 -b .lastlog-size
%patch10 -p1 -b .largefile
%patch11 -p1 -b .fixref
%patch12 -p1 -b .uninitialized
%patch13 -p1 -b .removemalloc
%patch14 -p1 -b .useradd-unlock
%if %{WITH_SELINUX}
%patch15 -p1 -b .chage-selinux
%endif
%patch16 -p1 -b .goodname
%patch17 -p1
%patch18 -p1 -b .skellink
%patch19 -p1 -b .matchpathcon
%patch20 -p1 -b .maxmem
%patch21 -p1 -b .debuginfo
%patch10001 -p0 -b .gcc4
rm po/*.gmo

# Recode man pages from euc-jp to UTF-8.
manconv() {
flags="$-"
set +x
incode=$1
outcode=$2
shift 2
for page in $* ; do
	if ! iconv -f ${outcode} -t ${outcode} ${page} > /dev/null 2> /dev/null ; then
		if iconv -f ${incode} -t ${outcode} ${page} > /dev/null 2> /dev/null ; then
			iconv -f ${incode} -t ${outcode} ${page} > ${page}.tmp && \
			cat ${page}.tmp > ${page} && \
			rm ${page}.tmp
		fi
	fi
done
set -"$flags"
}
%if %{utf8_man_pages}
manconv euc-jp utf-8 man/ja/*.*
manconv iso-8859-1 utf-8 man/de/*
manconv iso-8859-1 utf-8 man/fr/*
manconv iso-8859-1 utf-8 man/it/*
manconv iso-8859-1 utf-8 man/pt_BR/*
manconv iso-8859-2 utf-8 man/hu/*
manconv iso-8859-2 utf-8 man/pl/*
%endif

libtoolize --force
aclocal
automake -a
autoconf

%build
%configure \
	--disable-desrpc \
	--enable-shadowgrp \
	--without-libcrack \
	--with-libcrypt \
%if %{WITH_SELINUX}
	--with-selinux \
%endif
	--without-libpam \
	--disable-shared
make 

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT gnulocaledir=$RPM_BUILD_ROOT/%{_datadir}/locale MKINSTALLDIRS=`pwd`/mkinstalldirs
install -d -m 755 $RPM_BUILD_ROOT/etc/default
install -c -m 0644 %{SOURCE1} $RPM_BUILD_ROOT/etc/login.defs
install -c -m 0600 %{SOURCE2} $RPM_BUILD_ROOT/etc/default/useradd

ln -s useradd $RPM_BUILD_ROOT%{_sbindir}/adduser
install -m644 $RPM_SOURCE_DIR/adduser.8   $RPM_BUILD_ROOT%{_mandir}/man8/
install -m644 $RPM_SOURCE_DIR/pwunconv.8  $RPM_BUILD_ROOT%{_mandir}/man8/
install -m644 $RPM_SOURCE_DIR/grpconv.8   $RPM_BUILD_ROOT%{_mandir}/man8/
install -m644 $RPM_SOURCE_DIR/grpunconv.8 $RPM_BUILD_ROOT%{_mandir}/man8/

# Convert man pages from references to hard links, so that if a referred-to
# page is removed, we don't break things.  Not a good idea for the general
# case, because when the policy script compresses them, we probably lose.
linkman() {
	flags="$-"
	#set +x
	for manpage in $1/man*/* ; do
		pushd $1 > /dev/null
		if grep -q '^\.so' $manpage && \
		   test `grep -v '^\.so' $manpage | wc -l` -eq 0 ; then
			target=`awk '/^\.so/ { print $NF }' $manpage`
			if test -n "$target" ; then
				rm "$manpage"
				ln -v "$target" "$manpage"
			fi
		fi
		popd > /dev/null
	done
	set -"$flags"
}
for subdir in $RPM_BUILD_ROOT/%{_mandir}/{??,??_??,??_??.*} ; do
	test -d $subdir && linkman $subdir
done

mkdir -p %{buildroot}/var/log
touch %{buildroot}/var/log/lastlog
chmod 0400 %{buildroot}/var/log/lastlog

# Remove binaries we don't use.
rm $RPM_BUILD_ROOT/%{_bindir}/chfn
rm $RPM_BUILD_ROOT/%{_bindir}/chsh
rm $RPM_BUILD_ROOT/%{_bindir}/expiry
rm $RPM_BUILD_ROOT/%{_bindir}/groups
rm $RPM_BUILD_ROOT/%{_bindir}/login
rm $RPM_BUILD_ROOT/%{_bindir}/newgrp
rm $RPM_BUILD_ROOT/%{_bindir}/passwd
rm $RPM_BUILD_ROOT/%{_bindir}/su
rm $RPM_BUILD_ROOT/%{_sbindir}/dpasswd
rm $RPM_BUILD_ROOT/%{_sbindir}/logoutd
rm $RPM_BUILD_ROOT/%{_sbindir}/mkpasswd
rm $RPM_BUILD_ROOT/%{_sbindir}/vipw

rm $RPM_BUILD_ROOT/%{_mandir}/man1/chfn.*
rm $RPM_BUILD_ROOT/%{_mandir}/*/man1/chfn.*
rm $RPM_BUILD_ROOT/%{_mandir}/man1/chsh.*
rm $RPM_BUILD_ROOT/%{_mandir}/*/man1/chsh.*
rm $RPM_BUILD_ROOT/%{_mandir}/man1/expiry.*
rm $RPM_BUILD_ROOT/%{_mandir}/*/man1/expiry.*
rm $RPM_BUILD_ROOT/%{_mandir}/*/man1/groups.*
rm $RPM_BUILD_ROOT/%{_mandir}/man1/login.*
rm $RPM_BUILD_ROOT/%{_mandir}/*/man1/login.*
rm $RPM_BUILD_ROOT/%{_mandir}/man1/newgrp.*
rm $RPM_BUILD_ROOT/%{_mandir}/*/man1/newgrp.*
rm $RPM_BUILD_ROOT/%{_mandir}/man1/passwd.*
rm $RPM_BUILD_ROOT/%{_mandir}/*/man1/passwd.*
rm $RPM_BUILD_ROOT/%{_mandir}/man1/su.*
rm $RPM_BUILD_ROOT/%{_mandir}/*/man1/su.*
rm $RPM_BUILD_ROOT/%{_mandir}/man3/getspnam.*
rm $RPM_BUILD_ROOT/%{_mandir}/*/man5/d_passwd.*
rm $RPM_BUILD_ROOT/%{_mandir}/man5/limits.*
rm $RPM_BUILD_ROOT/%{_mandir}/*/man5/limits.*
rm $RPM_BUILD_ROOT/%{_mandir}/man5/login.access.*
rm $RPM_BUILD_ROOT/%{_mandir}/*/man5/login.access.*
rm $RPM_BUILD_ROOT/%{_mandir}/man5/login.defs.*
rm $RPM_BUILD_ROOT/%{_mandir}/*/man5/login.defs.*
rm $RPM_BUILD_ROOT/%{_mandir}/man5/passwd.*
rm $RPM_BUILD_ROOT/%{_mandir}/*/man5/passwd.*
rm $RPM_BUILD_ROOT/%{_mandir}/man5/porttime.*
rm $RPM_BUILD_ROOT/%{_mandir}/*/man5/porttime.*
rm $RPM_BUILD_ROOT/%{_mandir}/man5/suauth.*
rm $RPM_BUILD_ROOT/%{_mandir}/*/man5/suauth.*
rm $RPM_BUILD_ROOT/%{_mandir}/man8/logoutd.*
rm $RPM_BUILD_ROOT/%{_mandir}/*/man8/logoutd.*
rm $RPM_BUILD_ROOT/%{_mandir}/man8/mkpasswd.*
rm $RPM_BUILD_ROOT/%{_mandir}/*/man8/mkpasswd.*
rm $RPM_BUILD_ROOT/%{_mandir}/man8/vipw.*
rm $RPM_BUILD_ROOT/%{_mandir}/*/man8/vipw.*
rm $RPM_BUILD_ROOT/%{_mandir}/man8/vigr.*
rm $RPM_BUILD_ROOT/%{_mandir}/*/man8/vigr.*

%find_lang shadow

%clean
rm -rf $RPM_BUILD_ROOT

%post
touch /var/log/lastlog
chmod 0400 /var/log/lastlog

%files -f shadow.lang
%defattr(-,root,root)
%doc NEWS doc/ANNOUNCE doc/HOWTO doc/LICENSE README doc/README.linux
%dir /etc/default
%attr(0644,root,root)	%config /etc/login.defs
%attr(0600,root,root)	%config /etc/default/useradd
%{_bindir}/sg
%{_bindir}/chage
%{_bindir}/faillog
%{_bindir}/gpasswd
%{_bindir}/lastlog
%{_sbindir}/adduser
%{_sbindir}/user*
%{_sbindir}/group*
%{_sbindir}/grpck
%{_sbindir}/pwck
%{_sbindir}/*conv
%{_sbindir}/chpasswd
%{_sbindir}/newusers
#%{_sbindir}/mkpasswd
%{_mandir}/man1/chage.1*
%{_mandir}/*/man1/chage.1*
%{_mandir}/man1/gpasswd.1*
%{_mandir}/*/man1/gpasswd.1*
%{_mandir}/man1/sg.1*
%{_mandir}/*/man1/sg.1*
%{_mandir}/man3/shadow.3*
%{_mandir}/man5/shadow.5*
%{_mandir}/*/man5/shadow.5*
%{_mandir}/man5/faillog.5*
%{_mandir}/*/man5/faillog.5*
%{_mandir}/man8/adduser.8*
%{_mandir}/*/man8/adduser.8*
%{_mandir}/man8/group*.8*
%{_mandir}/*/man8/group*.8*
%{_mandir}/man8/user*.8*
%{_mandir}/*/man8/user*.8*
%{_mandir}/man8/pwck.8*
%{_mandir}/*/man8/pwck.8*
%{_mandir}/man8/grpck.8*
%{_mandir}/*/man8/grpck.8*
%{_mandir}/man8/chpasswd.8*
%{_mandir}/*/man8/chpasswd.8*
%{_mandir}/man8/newusers.8*
%{_mandir}/*/man8/newusers.8*
%{_mandir}/man8/*conv.8*
%{_mandir}/*/man8/*conv.8*
%{_mandir}/man8/lastlog.8*
%{_mandir}/*/man8/lastlog.8*
%{_mandir}/man8/faillog.8*
%{_mandir}/*/man8/faillog.8*
%ghost %verify(not md5 size mtime) /var/log/lastlog

%changelog
* Fri Dec 03 2004 Adrian Havill <havill@redhat.com> 2:4.0.3-56
- tweak max allowed length of user/group names to sizeof(ut_user)-1
  to allow for '\0' termination
- add lastlog support for >4gb (#125445)

* Tue Nov 23 2004 Bill Nottingham <notting@redhat.com>
- ghost lastlog here (#139539)

* Tue Nov 16 2004 Adrian Havill <havill@redhat.com> 2:4.0.3-42
- change MAXMEM static limit on group count to dynamic (#125510)
- re-allow "$" as last char for the sake of samba (#132782)
- don't strip binaries for debuginfo

* Wed Nov 10 2004 Adrian Havill <havill@redhat.com> 2:4.0.3-40
- fix %%patch16 bad paren grouping in goodname() check (#138632)
- don't apply %%patch15 if WITH_SELINUX is false

* Wed Oct 27 2004 Adrian Havill <havill@redhat.com> 2:4.0.3-38
- conform to posix for user/group name input checking [def 3.426
  and 3.189] which is posix portable filename character set [3.276]
  while disallowing dash for first char as recommended, and disallow
  dollar sign)

* Thu Oct 21 2004 Dan Walsh <dwalsh@redhat.com> 2:4.0.3-37
- Add matchpathcon to create the files correctly when they do not exist.

* Mon Oct 18 2004 Miloslav Trmac <mitr@redhat.com> - 2:4.0.3-36
- Change symlink ownership when copying from /etc/skel (#66819, patch by
  Michael Weiser)

* Fri Oct 15 2004 Adrian Havill <havill@redhat.com> 2:4.0.3-35
- make the limit for the group name the same as the username (determined
  by the header files, rather than a constant) (#56850)

* Wed Oct 13 2004 Adrian Havill <havill@redhat.com> 2:4.0.3-33
- allow for mixed case and dots in usernames (#135401)
- all man pages to UTF-8, not just Japanese (#133883)
- add Polish blurb for useradd -n man page option (#82177)

* Tue Oct 12 2004 Adrian Havill <havill@redhat.com> 2:4.0.3-31
- check for non-standard legacy place for ncsd HUP (/var/run/nscd.pid) and
  then the std FHS place (/var/run/nscd.pid) (#125421)

* Fri Oct 1 2004 Dan Walsh <dwalsh@redhat.com> 2:4.0.3-30
- Add checkPasswdAccess for chage in SELinux

* Sun Sep 26 2004 Adrian Havill <riel@redhat.com> 2:4.0.3-29
- always unlock all files on any exit (#126709)

* Tue Aug 24 2004 Warren Togami <wtogami@redhat.com> 2:4.0.3-26
- #126596 fix Req and BuildReqs

* Sun Aug  1 2004 Alan Cox <alan@redhat.com> 4.0.3-25
- Fix build deps etc, move to current auto* (Steve Grubb)

* Sat Jul 10 2004 Alan Cox <alan@redhat.com> 4.0.3-24
- Fix nscd path. This fixes various stale data caching bugs (#125421)

* Thu Jun 17 2004 Dan Walsh <dwalsh@redhat.com> 4.0.3-23
- Add get_enforce checks
- Clean up patch for potential upstream submission
- Add removemalloc patch to get it to build on 3.4

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Mar 30 2004 Nalin Dahyabhai <nalin@redhat.com> 4.0.3-21
- rebuild

* Tue Mar 30 2004 Nalin Dahyabhai <nalin@redhat.com> 4.0.3-20
- make /etc/default world-readable, needed for #118338

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Jan 21 2004 Dan Walsh <dwalsh@redhat.com> 4.0.3-18
- Fix selinux relabel of /etc/passwd file

* Wed Jan  7 2004 Nalin Dahyabhai <nalin@redhat.com> 4.0.3-17
- fix use of uninitialized memory in useradd (#89145)

* Tue Dec 16 2003 Nalin Dahyabhai <nalin@redhat.com> 4.0.3-16
- back to UTF-8 again
- remove getspnam(3) man page, now conflicts with man-pages 1.64

* Thu Nov 13 2003 Nalin Dahyabhai <nalin@redhat.com> 4.0.3-15
- don't convert man pages to UTF-8 for RHEL 3, conditionalized using macro
- fixup dangling man page references

* Mon Nov 10 2003 Nalin Dahyabhai <nalin@redhat.com> 4.0.3-14
- lastlog: don't pass a possibly-smaller field to localtime (#109648)
- configure: call AC_SYS_LARGEFILE to get large file support

* Fri Nov 7 2003 Dan Walsh <dwalsh@redhat.com> 4.0.3-13.sel
- turn on SELinux support

* Wed Oct 22 2003 Nalin Dahyabhai <nalin@redhat.com> 4.0.3-12
- convert ja man pages to UTF-8 (#106051)
- override MKINSTALLDIRS at install-time (#107476)

* Mon Sep 8 2003 Dan Walsh <dwalsh@redhat.com>
- turn off SELinux support

* Thu Sep 4 2003 Dan Walsh <dwalsh@redhat.com> 4.0.3-11.sel
- build with SELinux support

* Fri Jul 28 2003 Dan Walsh <dwalsh@redhat.com> 4.0.3-10
- Add SELinux support

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Jun  4 2003 Nalin Dahyabhai <nalin@redhat.com> 4.0.3-8
- rebuild

* Tue Jun  3 2003 Nalin Dahyabhai <nalin@redhat.com> 4.0.3-7
- run autoconf to generate updated configure at compile-time

* Wed Feb 12 2003 Nalin Dahyabhai <nalin@redhat.com> 4.0.3-6
- adjust mailspool patch to complain if no group named "mail" exists, even
  though that should never happen

* Tue Feb 11 2003 Nalin Dahyabhai <nalin@redhat.com> 4.0.3-5
- fix perms on mailspools created by useradd to be owned by the "mail"
  group (#59810)

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Mon Dec  9 2002 Nalin Dahyabhai <nalin@redhat.com> 4.0.3-3
- install the shadow.3 man page

* Mon Nov 25 2002 Nalin Dahyabhai <nalin@redhat.com> 4.0.3-2
- disable use of cracklib at build-time
- fixup reserved-account changes for useradd

* Thu Nov 21 2002 Nalin Dahyabhai <nalin@redhat.com> 4.0.3-1
- update to 4.0.3, bumping epoch

* Mon Nov 18 2002 Nalin Dahyabhai <nalin@redhat.com> 20000902-14
- remove man pages which conflict with the man-pages package(s)

* Fri Nov 15 2002 Nalin Dahyabhai <nalin@redhat.com> 20000902-13
- prevent libshadow from being built more than once, to keep automake happy
- change how md5 and md5crypt are enabled, to keep autoconf happy
- remove unpackaged files after %%install

* Thu Aug 29 2002 Nalin Dahyabhai <nalin@redhat.com> 20000902-12
- force .mo files to be regenerated with current gettext to flush out possible
  problems
- fixup non-portable encodings in translations
- make sv translation header non-fuzzy so that it will be included (#71281)

* Fri Aug 23 2002 Nalin Dahyabhai <nalin@redhat.com> 20000902-11
- don't apply aging parameters when creating system accounts (#67408)

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Sun May 26 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Fri May 17 2002 Nalin Dahyabhai <nalin@redhat.com> 20000902-8
- rebuild in new environment

* Wed Mar 27 2002 Nalin Dahyabhai <nalin@redhat.com> 20000902-7
- rebuild with proper defines to get support for large lastlog files (#61983)

* Fri Feb 22 2002 Nalin Dahyabhai <nalin@redhat.com> 20000902-6
- rebuild

* Fri Jan 25 2002 Nalin Dahyabhai <nalin@redhat.com> 20000902-5
- fix autoheader breakage and random other things autotools complain about

* Mon Aug 27 2001 Nalin Dahyabhai <nalin@redhat.com> 20000902-4
- use -O0 instead of -O on ia64
- build in source directory
- don't leave lock files on the filesystem when useradd creates a group for
  the user (#50269)
- fix the -o option to check for duplicate UIDs instead of login names (#52187)

* Thu Jul 26 2001 Bill Nottingham <notting@redhat.com> 20000902-3
- build with -O on ia64

* Fri Jun 08 2001 Than Ngo <than@redhat.com> 20000902-2
- fixup broken specfile

* Tue May 22 2001 Bernhard Rosenkraenzer <bero@redhat.com> 20000902-1
- Create an empty mailspool when creating a user so non-setuid/non-setgid
  MDAs (postfix+procmail) can deliver mail (#41811)
- 20000902
- adapt patches

* Fri Mar  9 2001 Nalin Dahyabhai <nalin@redhat.com>
- don't overwrite user dot files in useradd (#19982)
- truncate new files when moving overwriting files with the contents of other
  files while moving directories (keeps files from looking weird later on)
- configure using %%{_prefix} as the prefix

* Fri Feb 23 2001 Trond Eivind Glomsrxd <teg@redhat.com>
- langify

* Wed Aug 30 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Fix up chage behavior (Bug #15883)

* Wed Aug 30 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- 20000826
- Fix up useradd man page (Bug #17036)

* Tue Aug  8 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- check for vipw lock before adding or deleting users (Bug #6489)

* Mon Aug  7 2000 Nalin Dahyabhai <nalin@redhat.com>
- take LOG_CONS out of the openlog() call so that we don't litter the
  screen during text-mode upgrades

* Tue Jul 18 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Remove a fixed-size buffer that caused problems when adding a huge number
  of users to a group (>8192 bytes) (Bugs #3809, #11930)

* Tue Jul 18 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- remove dependency on util-linux because it causes prereq loops

* Tue Jul 18 2000 Nalin Dahyabhai <nalin@redhat.com>
- change symlinked man pages to includers
- require /usr/bin/newgrp (util-linux) so that /usr/bin/sg isn't left dangling

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Sun Jun 18 2000 Matt Wilson <msw@redhat.com>
- use mandir for FHS
- added patches in src/ and po/ to honor DESTDIR
- use make install DESTDIR=$RPM_BUILD_ROOT

* Wed Feb 16 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Fix up usermod's symlink behavior (Bug #5458)

* Fri Feb 11 2000 Cristian Gafton <gafton@redhat.com>
- get rid of mkpasswd

* Mon Feb  7 2000 Nalin Dahyabhai <nalin@redhat.com>
- fix usermod patch to check for shadow before doing any shadow-specific stuff
  and merge it into the pwlock patch

* Sat Feb  5 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- fix man symlinks

* Wed Feb  2 2000 Nalin Dahyabhai <gafton@redhat.com>
- make -p only change shadow password (bug #8923)

* Mon Jan 31 2000 Cristian Gafton <gafton@redhat.com>
- rebuild to fix dependeencies
- man pages are compressed

* Wed Jan 19 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Fix a security bug (adduser could overwrite previously existing
  groups, Bug #8609)

* Sun Jan  9 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- unset LINGUAS before building
- Fix typo in newusers manpage (Bug #8258)
- libtoolize

* Wed Sep 22 1999 Cristian Gafton <gafton@redhat.com>
- fix segfault for userdel when the primary group for the user is not
  defined

* Tue Sep 21 1999 Cristian Gafton <gafton@redhat.com>
- Serial: 1 because now we are using 19990827 (why the heck can't they have
  a normal version just like everybody else?!)
- ported all patches to the new code base

* Thu Apr 15 1999 Bill Nottingham <notting@redhat.com>
- SIGHUP nscd from usermod, too

* Fri Apr 09 1999 Michael K. Johnson <johnsonm@redhat.com>
- added usermod password locking from Chris Adams <cadams@ro.com>

* Thu Apr 08 1999 Bill Nottingham <notting@redhat.com>
- have things that modify users/groups SIGHUP nscd on exit

* Wed Mar 31 1999 Michael K. Johnson <johnsonm@redhat.com>
- have userdel remove user private groups when it is safe to do so
- allow -f to force user removal even when user appears busy in utmp

* Tue Mar 23 1999 Preston Brown <pbrown@redhat.com>
- edit out unused CHFN fields from login.defs.

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 7)

* Wed Jan 13 1999 Bill Nottingham <notting@redhat.com>
- configure fix for arm

* Wed Dec 30 1998 Cristian Gafton <gafton@redhat.com>
- build against glibc 2.1

* Fri Aug 21 1998 Jeff Johnson <jbj@redhat.com>
- Note that /usr/sbin/mkpasswd conflicts with /usr/bin/mkpasswd;
  one of these (I think /usr/sbin/mkpasswd but other opinions are valid)
  should probably be renamed.  In any case, mkpasswd.8 from this package
  needs to be installed. (problem #823)

* Fri May 08 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Tue Apr 21 1998 Cristian Gafton <gafton@redhat.com>
- updated to 980403
- redid the patches

* Tue Dec 30 1997 Cristian Gafton <gafton@redhat.com>
- updated the spec file
- updated the patch so that new accounts created on shadowed system won't
  confuse pam_pwdb anymore ('!!' default password instead on '!')
- fixed a bug that made useradd -G segfault
- the check for the ut_user is now patched into configure

* Thu Nov 13 1997 Erik Troan <ewt@redhat.com>
- added patch for XOPEN oddities in glibc headers
- check for ut_user before checking for ut_name -- this works around some
  confusion on glibc 2.1 due to the utmpx header not defining the ut_name
  compatibility stuff. I used a gross sed hack here because I couldn't make
  automake work properly on the sparc (this could be a glibc 2.0.99 problem
  though). The utuser patch works fine, but I don't apply it.
- sleep after running autoconf

* Thu Nov 06 1997 Cristian Gafton <gafton@redhat.com>
- added forgot lastlog command to the spec file

* Mon Oct 26 1997 Cristian Gafton <gafton@redhat.com>
- obsoletes adduser

* Thu Oct 23 1997 Cristian Gafton <gafton@redhat.com>
- modified groupadd; updated the patch

* Fri Sep 12 1997 Cristian Gafton <gafton@redhat.com>
- updated to 970616
- changed useradd to meet RH specs
- fixed some bugs

* Tue Jun 17 1997 Erik Troan <ewt@redhat.com>
- built against glibc
