---
layout: page
---

# Reporting Bugs in libsndfile

Before even attempting to report a bug in libsndfile please make sure you have
read the [Frequently Asked Questions](FAQ.md). If you are having a problem
writing code using libsndfile make sure you read the
[Application Programming Interface](api.md) documentation.

That said, I am interested in finding and fixing all genuine bugs in libsndfile.
Bugs I want to fix include any of the following problems (and probably others):

- Compilation problems on new platforms.
- Errors being detected during the `make check` process.
- Segmentation faults occuring inside libsndfile.
- libsndfile hanging when opening a file.
- Supported sound file types being incorrectly read or written.
- Omissions, errors or spelling mistakes in the documentation.

When submitting a bug report you must include:

- Your system (CPU and memory size should be enough).
- The operating system you are using.
- Whether you are using a package provided by your distribution or you compiled
  it youself.
- If you compiled it yourself, the compiler you are using. (Also make sure to
  run `make check`.)
- A description of the problem.
- Information generated by the sndfile-info program (see next paragraph).
- If you are having problems with sndfile-play and ALSA on Linux, I will need
  information about your kernel, ALSA version, compiler version, whether you
  compiled the kernel/ALSA your self or installed from a package etc.

If libsndfile compiles and installs correctly but has difficulty reading a
particular file or type of file you should run the **sndfile-info** program
(from the examples directory of the libsndfile distribution) on the file. See
[here](sndfile_info.md) for an example of the use of the **sndfile-info**
program.

Please do not send me a sound file which fails to open under libsndfile unless
I specifically ask you to. The above information should usually suffice for most
problems.

Once you have the above information you should submit a ticket on the libsndfile
[GitHub issue tracker](https://github.com/libsndfile/libsndfile/issues).
