Summary: Utilities for managing the JFS filesystem.
Name: jfsutils
Version: 1.1.7
Release: 1.gnupro.1
Source0: http://www10.software.ibm.com/developer/opensource/jfs/project/pub/jfsutils-%{version}.tar.gz
URL: http://oss.software.ibm.com/jfs
Group: System Environment/Base
License: GPL
Buildroot: %{_tmppath}/%{name}-root

%description
The jfsutils package contains a number of utilities for creating,
checking, modifying, and correcting any inconsistencies in JFS
filesystems.  The following utilities are available: fsck.jfs - initiate
replay of the JFS transaction log, and check and repair a JFS formatted
device; logdump - dump a JFS formatted device's journal log; logredo -
"replay" a JFS formatted device's journal log;  mkfs.jfs - create a JFS
formatted partition; xchkdmp - dump the contents of a JFS fsck log file
created with xchklog; xchklog - extract a log from the JFS fsck workspace
into a file;  xpeek - shell-type JFS file system editor.


%prep
%setup -q

%build
%if "%{_arch}" == %{_build_arch}
CFLAGS="${RPM_OPT_FLAGS}" ./configure --mandir=%{_mandir}
%else
export CC="%{__cc}"
CFLAGS="${RPM_OPT_FLAGS}" ./configure	--mandir=%{_mandir} \
					--host=%{_target_platform} \
					--target=%{_target_platform}
%endif
make

%install
[ "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
# let brp-compress handle this policy
rm -f $RPM_BUILD_ROOT/%{_mandir}/*/*.gz

%clean
[ "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/sbin/*
%{_mandir}/*/*
%doc AUTHORS COPYING INSTALL NEWS README ChangeLog

%changelog
* Tue Oct 12 2004 Florian La Roche <laroche@redhat.com>
- 1.1.7

* Thu Jun 17 2004 Florian La Roche <Florian.LaRoche@redhat.de>
- 1.1.6

* Thu Feb 26 2004 Jeff Garzik <jgarzik@redhat.com>
- Version 1.1.4

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Sat Oct 25 2003 Florian La Roche <Florian.LaRoche@redhat.de>
- 1.1.3

* Sun Aug 10 2003 Florian La Roche <Florian.LaRoche@redhat.de>
- 1.1.2

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Wed Jan 15 2003 Matt Wilson <msw@redhat.com> 1.0.17-5
- use #include <errno.h>, not extern int errno;

* Mon Nov 18 2002 Tim Powers <timp@redhat.com>
- rebuild on all arches

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Tue Apr 09 2002 Michael K. Johnson <johnsonm@redhat.com>
- updated to jfsutils 1.0.17

* Fri Feb 08 2002 Michael K. Johnson <johnsonm@redhat.com>
- typo fixed

* Tue Jan 29 2002 Michael K. Johnson <johnsonm@redhat.com>
- Initial packaging
