#!/bin/sh
# cygwin-doc-preremove.sh

# if there are Start Menu "Cygwin" directories, remove links
for i in ASM SM; do
	if [ $i = "ASM" ]; then
		SMDIR="$(/bin/cygpath -AP)/Cygwin"
	fi
	if [ $i = "SM" ]; then
		SMDIR="$(/bin/cygpath -P)/Cygwin"
	fi
	if [ -f "$SMDIR/Cygwin FAQ.lnk" ]; then
		/bin/rm -f "$SMDIR/Cygwin FAQ.lnk"
	fi
	if [ -f "$SMDIR/User's Guide.lnk" ]; then
		/bin/rm -f "$SMDIR/User's Guide.lnk"
	fi
	if [ -f "$SMDIR/User's Guide (One file).lnk" ]; then
		/bin/rm -f "$SMDIR/User's Guide (One file).lnk"
	fi
	if [ -f "$SMDIR/User's Guide (PDF).lnk" ]; then
		/bin/rm -f "$SMDIR/User's Guide (PDF).lnk"
	fi
	if [ -f "$SMDIR/Cygwin API Reference.lnk" ]; then
		/bin/rm -f "$SMDIR/Cygwin API Reference.lnk"
	fi
done	

# Remove info 
PREFIX=/usr/share
INFODIR=${PREFIX}/info
cd ${INFODIR}
for i in cygwin.info libc.info libm.info; do
  /usr/bin/install-info --delete --dir-file=${INFODIR}/dir --info-file=${i}
done
