#include <stdio.h>
#include <unistd.h>

extern char *optarg, *suboptarg;
char *options, *value;

int
main(int argc, char **argv)
{
  char *tokens[] = {
#define ONE     0
    "one",
#define TWO     1
    "two",
    NULL
  };
  int ch, i;

  while ((ch = getopt(argc, argv, "ab:")) != -1) {
    switch(ch) {
    case 'a':
      /* process ``a'' option */
      break;
    case 'b':
      options = optarg;
      while (*options) {
        switch(getsubopt(&options, tokens, &value)) {
        case ONE:
          /* process ``one'' sub option */
          break;
        case TWO:
          /* process ``two'' sub option */
          if (!value)
		  exit(1);
          i = atoi(value);
          break;
        case -1:
          if (suboptarg)
		  exit(2);
          else
		  exit(3);
          break;
        }
        break;
      }
    }
  }
  exit(0);
}
