
#include "test.h"
#include <errno.h>

/*
 * Test pow by multiplying logs
 */

/* testsuite entry point */
void
_DEFUN_VOID (test_main)
{
	unsigned int i;
	newfunc ("pow");

	for (i = 0; i < 1000; i++) {
		double  n1;
		double  n2;
		double  res;
		double  shouldbe;

		line (i);
		n1 = fabs (randy ());
		n2 = fabs (randy () / 100.0);
		res = pow (n1, n2);
		shouldbe = exp (log (n1) * n2);
		test_mok (shouldbe, res, 64);
	}

	newfunc ("powf");

	for (i = 0; i < 1000; i++) {
		double  n1;
		double  n2;
		double  res;
		double  shouldbe;

		errno = 0;

		line (i);
		n1 = fabs (randy ());
		n2 = fabs (randy () / 100.0);
		res = powf (n1, n2);
		shouldbe = expf (logf (n1) * n2);
		if (!errno)
			test_mok (shouldbe, res, 28);
	}

}
