/*
**	idttlb.s - fetch the registers associated with and the contents
**		   of the tlb.
**
*/
#include "iregdef.h"
#include "idtcpu.h"
#include "idtmon.h"

	.text

/*
** ret_tlblo -- returns the 'entrylo' contents for the TLB
**	'c' callable - as ret_tlblo(index) - where index is the
**	tlb entry to return the lo value for - if called from assembly
**	language then index should be in register a0.
*/
FRAME(ret_tlblo,sp,0,ra)
	.set	noreorder
	mfc0	t0,C0_SR		/* save sr */
	nop
	and	t0,~SR_PE		/* dont inadvertantly clear PE */
	mtc0	zero,C0_SR		/* clear interrupts */
	mfc0	t1,C0_TLBHI		/* save pid */
	sll	a0,TLBINX_INXSHIFT	/* position index */
	mtc0	a0,C0_INX		/* write to index register */
	nop
	tlbr				/* put tlb entry in entrylo and hi */
	nop
	mfc0	v0,C0_TLBLO		/* get the requested entry lo */
	mtc0	t1,C0_TLBHI		/* restore pid */
	mtc0	t0,C0_SR		/* restore status register */
	j	ra
	nop
ENDFRAME(ret_tlblo)

/*
** ret_tlbhi -- return the tlb entry high content for tlb entry
**			index
*/
FRAME(ret_tlbhi,sp,0,ra)
	mfc0	t0,C0_SR		/* save sr */
	nop
	and	t0,~SR_PE
	mtc0	zero,C0_SR		/* disable interrupts */
	mfc0	t1,C0_TLBHI		/* save current pid */
	sll	a0,TLBINX_INXSHIFT	/* position index */
	mtc0	a0,C0_INX		/* drop it in C0 register */
	nop
	tlbr				/* read entry to entry hi/lo */
	nop
	mfc0	v0,C0_TLBHI		/* to return value */
	mtc0	t1,C0_TLBHI		/* restore current pid */
	mtc0	t0,C0_SR		/* restore sr */
	j	ra
	nop
ENDFRAME(ret_tlbhi)

/*
** ret_tlbpid() -- return tlb pid contained in the current entry hi
*/
FRAME(ret_tlbpid,sp,0,ra)
	mfc0	v0,C0_TLBHI		/* fetch tlb high  */
	nop
	and	v0,TLBHI_PIDMASK	/* isolate and position */
	srl	v0,TLBHI_PIDSHIFT
	j	ra
	nop
ENDFRAME(ret_tlbpid)

/*
** tlbprobe(address, pid) -- probe the tlb to see if address is currently
**				mapped
*/
FRAME(tlbprobe,sp,0,ra)
	mfc0	t0,C0_SR		/* fetch status reg */
	and	a0,TLBHI_VPNMASK	/* isolate just the vpn */
	and	t0,~SR_PE
	mtc0	zero,C0_SR 
	mfc0	t1,C0_TLBHI	
	sll	a1,TLBHI_PIDSHIFT	/* position the tlb */
	and	a1,TLBHI_PIDMASK
	or	a0,a1
	mtc0	a0,C0_TLBHI
	nop
	tlbp				/* do the probe */
	nop
	mfc0	v0,C0_INX
	nop
	sra	v0,TLBINX_INXSHIFT	/* get index positioned for ret */
	mtc0	t1,C0_TLBHI		/* restore tlb hi */
	mtc0	t0,C0_SR		/* restore the status reg */
	j	ra
	nop
ENDFRAME(tlbprobe)

/*
** resettlb(index) Invalidate the  TLB entry specified by index
*/
FRAME(resettlb,sp,0,ra)
	mfc0	t0,C0_TLBHI		/* fetch the current hi */
	li	t2,K0BASE&TLBHI_VPNMASK
	mtc0	t2,C0_TLBHI		/* set up tlbhi */
	mtc0	zero,C0_TLBLO
	sll	a0,TLBINX_INXSHIFT
	mtc0	a0,C0_INX
	nop
	tlbwi				/* do actual invalidate */
	nop
	mtc0	t0,C0_TLBHI
	j	ra
	nop
ENDFRAME(resettlb)

/*
** Setup TLB entry
**
** tlbmapping(index, tlbhi, phypage)
** 	a0  =  TLB entry index
**	a1  =  virtual page number and PID
**	a2  =  physical page
*/
FRAME(tlbmapping,sp,0,ra)

	sll	a0,TLBINX_INXSHIFT
	mfc0	v0,C0_SR		/* fetch the current status */
	mfc0	a3,C0_TLBHI		/* save the current hi */
	and	v0,~SR_PE		/* dont inadvertantly clear parity */

	mtc0	zero,C0_SR
	mtc0	a1,C0_TLBHI		/* set the hi entry */
	mtc0	a2,C0_TLBLO		/* set the lo entry */  
	mtc0	a0,C0_INX		/* load the index */
	nop
	tlbwi				/* put the hi/lo in tlb entry indexed */
	nop
	mtc0	a3,C0_TLBHI		/* put back the tlb hi reg  */
	mtc0	v0,C0_SR		/* restore the status register  */
	j	ra
	nop
ENDFRAME(tlbmapping)


/*
** Set current TLBPID. This assumes PID is positioned correctly in reg.
**			a0.
*/
FRAME(set_tlbpid,sp,0,ra)

	mtc0	a0,C0_TLBHI
	j	ra
	nop
	.set	reorder
ENDFRAME(set_tlbpid)

