/*
** Copyright 1990 Integrated Device Technology, Inc.
**	All Rights Reserved
**
** idtfpreg.s - capture floating point registers. 
**
** get_fpcsr()     - get control/status register from FPU
** set_fpcsr(bits) - set bits in control/status register ON (1)
** get_cp0epc()    - get Exception Program Counter register from CP0 
** get_CAUSE()     - get CAUSE Register contents from CP0
** clr_CAUSE()	   - clear Software bits (others are read-only)
** set_CAUSE()	   - set bits in CP0 CAUSE Register ON (SW Ints only)		
** get_STATUS()    - get STATUS Register contents from CP0
**
**
*/
#include "iregdef.h"
#include "fpip.h"
#include "idtcpu.h"
#include "idtmon.h"


	.text
/*--------------------------------------------------------------
** get_fpcsr program entry point 
**
**	WARNING: this reads the FPA register;if there is no FPA,
**		 an interrupt will occur  - Use fpget_fpcsr
** 
*--------------------------------------------------------------*/
FRAME(get_fpcsr,sp,0,ra)
	.set	noreorder
	cfc1	v0,FP_CSR		/* ret contents FP Control/Status Reg */
	j	ra
	nop
	.set	reorder
ENDFRAME(get_fpcsr)

/*--------------------------------------------------------------
** set_fpcsr program entry point 
**
**	WARNING: this reads the FPA register; if there is no FPA,
**		 an interrupt will occur - Use fpget_fpcsr
*--------------------------------------------------------------*/
FRAME(set_fpcsr,sp,0,ra)
	.set	noreorder
	ctc1	a0, FP_CSR	 	/* bits to be turned on */ 
	nop
	j	ra
	nop
	.set	reorder
ENDFRAME(set_fpcsr)

/*--------------------------------------------------------------
** get_cp0epc program entry point 
*--------------------------------------------------------------*/
FRAME(get_cp0epc,sp,0,ra)
	.set	noreorder
	mfc0	v0, C0_EPC 	 	/* exception program counter */
	j	ra
	nop
	.set	reorder
ENDFRAME(get_cp0epc)


/*--------------------------------------------------------------
** get_CAUSE program entry point 
*--------------------------------------------------------------*/
FRAME(get_CAUSE,sp,0,ra)
	.set	noreorder
	mfc0	v0, C0_CAUSE 	 	/* ret contents cp0 CAUSE reg */
	j	ra
	nop
	.set	reorder
ENDFRAME(get_CAUSE)


/*--------------------------------------------------------------
** clr_CAUSE program entry point 
*--------------------------------------------------------------*/
FRAME(clr_CAUSE,sp,0,ra)
	.set	noreorder
	mtc0	zero, C0_CAUSE	 	/* clear SW bits */
	nop
	j	ra
	nop
	.set	reorder
ENDFRAME(clr_CAUSE)


/*--------------------------------------------------------------
** set_CAUSE program entry point 
*--------------------------------------------------------------*/
FRAME(set_CAUSE,sp,0,ra)
	.set	noreorder
	mtc0	a0, C0_CAUSE	 	/* bits to be turned on */ 
	nop
	j	ra
	nop
	.set	reorder
ENDFRAME(set_CAUSE)

/*--------------------------------------------------------------
** get_STATUS program entry point 
*--------------------------------------------------------------*/
FRAME(get_STATUS,sp,0,ra)
	.set	noreorder
	mfc0	v0, C0_SR     	 	/* ret contents cp0 STATUS reg */
	j	ra
	nop
	.set	reorder
ENDFRAME(get_STATUS)

