;;  ip2k
;;   Copyright (C) 2000 by  Red Hat, Incorporated. All rights reserved.
;; 
;; Permission to use, copy, modify, and distribute this software
;; is freely granted, provided that this notice is preserved.
;; 

	;; Turn off C code in header file...
#define typedef	; 
#include "machine/setjmp.h"
			
	.file "setjmp.S"
#define	FP	$fd
	.section .text
	.global _setjmp
	.func	_setjmp
_setjmp:
	push	dpl
	push	dph		; Must save preserved regs
	mov	w,3(SP)		; Get address of jump buffer
	mov	dph,w
	mov	w,4(SP)
	mov	dpl,w
	pop	wreg		; Get the DP
	mov	_JBDP(dp),w
	pop	wreg
	mov	_JBDP+1(dp),w	; Save it

	mov	w,CALLH
	mov	_JBPC(dp),w
	mov	w,CALLL
	mov	_JBPC+1(dp),w	; Save PC

	mov	w,iph
	mov	_JBIP(dp),w
	mov	w,ipl
	mov	_JBIP+1(dp),w	; Save IP

	mov	w,FP
	mov	_JBFP(dp),w
	mov	w,FP+1
	mov	_JBFP+1(dp),w	; Save FP

	mov	w,sph
	mov	_JBSP(dp),w
	mov	w,spl
	mov	_JBSP+1(dp),w	; Save SP

	clr	$80	; setjmp always returns zero
	clr	$81
	ret
	.endfunc
	
	.global _longjmp
	.func	_longjmp
_longjmp:
	pop	dph
	pop	dpl		; Get address of jump buffer
	pop	$80
	pop	$81		; set return address
	mov	w,$80
	or	w,$81		; Check that return is non-zero
	snz
	inc	$81		; Force longjmp to return non-zero
	
	mov	w,_JBPC(dp)
	mov	CALLH,w
	mov	w,_JBPC+1(dp)
	mov	CALLL,w		; return to setjmp caller()

	mov	w,_JBSP(dp)
	mov	sph,w
	mov	w,_JBSP+1(dp)
	mov	spl,w		; restore SP

	mov	w,_JBIP(dp)
	mov	iph,w
	mov	w,_JBIP+1(dp)
	mov	ipl,w		; Restore IP

	mov	w,_JBFP(dp)
	mov	FP,w
	mov	w,_JBFP+1(dp)
	mov	FP+1,w		; Restore FP

	mov	w,_JBDP(dp)
	push	wreg
	mov	w,_JBDP+1(dp)
	mov	dpl,w
	pop	dph		; Restore DP
	ret
	.endfunc
	
