# setjmp/longjmp for Calmrisc32.
# 
# I was originally going to just save and restore all of the registers,
# but I can't use reg+displacement addressing as the buffer gets too big.
# I would also like to be able to use a register as a scratch.  So, we
# will save and restore the fixed registers and the call used registers only.
# 
# The jmpbuf looks like this:
#	
# Register	jmpbuf offset
# R0		0x0		 0
# R1		0x4		 4
# R2		0x8		 8
# R3		0xc		12
# R8		0x10		16
# R9		0x14		20
# R10		0x18		24
# R11		0x1c		28
# R14		0x20		32
# R15		0x24		36
#
# R0 contains the pointer to jmpbuf
	.text
	.global	setjmp
	.type	setjmp ,@function
setjmp:
# Move r0 to one of the scratch base registers.
	ld	r12, r0
	ldw	@[r12+0], r0
	ldw	@[r12+4], r1
	ldw	@[r12+8], r2
	ldw	@[r12+12], r3
	ldw	@[r12+16], r8
	ldw	@[r12+20], r9
	ldw	@[r12+24], r10
	ldw	@[r12+28], r11
	ldw	@[r12+32], r14
	ldw	@[r12+36], sp

	jmpd	r14
	 ldw	r0, #0
.Lend1:
	.size	setjmp,.Lend1-setjmp

	.global	longjmp
	.type	longjmp,@function
longjmp:
	ld	r13, r0
	ld	r12, r1
	ldw	sp, @[r13+36]
	ldw	r14, @[r13+32]
	ldw	r11, @[r13+28]
	ldw	r10, @[r13+24]
	ldw	r9, @[r13+20]
	ldw	r8, @[r13+16]
	ldw	r3, @[r13+12]
	ldw	r2, @[r13+8]
	ldw	r1, @[r13+4]
# Value to return is in r12.  If zero, return 1
	ld	r0, r12
	cmp eq	r0, #0
	brf 	.L01
	ldw	r0, #1
.L01:
	jmpd	r14
	 nop
.Lend2:
	.size	longjmp,.Lend2-longjmp2
