/*-
 * Copyright (c) 1983, 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if !defined(lint) && defined(LIBC_SCCS)
#if 0
static char sccsid[] = "@(#)gmon.c	8.1 (Berkeley) 6/4/93";
#else
static char rcsid[] = "$NetBSD: gmon.c,v 1.8 1997/01/23 14:02:00 mrg Exp $";
#endif
#endif

#include <_ansi.h>

#include <sys/types.h>
#include <sys/gmon.h>

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <limits.h>
#include <unistd.h>

/* extern char *minbrk __asm ("minbrk"); */

struct gmonparam _gmonparam = { GMON_PROF_OFF };

int _gmonversion = GMONVERSION;
int _gmonprofrate;
int _gmonerror = GMON_ERROR_NONE;

static int	s_scale;
/* see profil(2) where this is describe (incorrectly) */
#define		SCALE_1_TO_1	0x10000L

void	__attribute__ ((no_instrument_function)) moncontrol _PARAMS ((int));
static int __attribute__ ((no_instrument_function)) hertz _PARAMS ((void));

/*
FUNCTION
<<monstartup>>, <<moncontrol>>---Profiling management

INDEX
	monstartup
INDEX
	moncontrol


ANSI_SYNOPSIS
	#include <sys/gmon.h>
	void monstartup(u_long <[lowpc]>, u_long <[highpc]>);
	void moncontrol(int <[mode]>);
	

TRAD_SYNOPSIS
	#include <sys/gmon.h>
	void monstartup(<[lowpc]>, <[highpc]>)
	u_long <[lowpc]>;
	u_long <[highpc]>;

	void moncontrol(<[mode]>)
	int <[mode]>;

DESCRIPTION

These function manage the profiling on the target system. The user
does not normally use <<monstartup>> and <<moncontrol>>
directly. <<monstartup>> is starts the profiling monitoring a region
of the code and it is normally called by the profiling version crt0
when the "-pg" option is used to compile the code. <<moncontrol>>
turns on and off the profiling.


RETURNS
<<monstartup>> returns nothing.

<<moncontrol>> returns nothing.

PORTABILITY

*/


void __attribute__ ((no_instrument_function))
monstartup(lowpc, highpc)
	u_long lowpc;
	u_long highpc;
{
	register int o;
	char *cp;
	struct gmonparam *p = &_gmonparam;

	_gmonversion = GMONVERSION;

	/*
	 * round lowpc and highpc to multiples of the density we're using
	 * so the rest of the scaling (here and in gprof) stays in ints.
	 */
	p->lowpc = ROUNDDOWN(lowpc, HISTFRACTION * sizeof(HISTCOUNTER));
	p->highpc = ROUNDUP(highpc, HISTFRACTION * sizeof(HISTCOUNTER));
	p->textsize = p->highpc - p->lowpc;
	p->kcountsize = p->textsize / HISTFRACTION;
	p->hashfraction = HASHFRACTION;
	p->fromssize = p->textsize / p->hashfraction;
	p->tolimit = p->textsize * ARCDENSITY / 100;
	if (p->tolimit < MINARCS)
		p->tolimit = MINARCS;
	else if (p->tolimit > MAXARCS)
		p->tolimit = MAXARCS;
	p->tossize = p->tolimit * sizeof(struct tostruct);

	cp = sbrk(p->kcountsize + p->fromssize + p->tossize);
	if (cp == (char *)-1) {
		_gmonerror = GMON_ERROR_MEM;
		return;
	}
	
	/* Because bzero() is instrumented it can't be called until
	   after the data structures are set up.  Hence, the following
	   code is used rather than a call to bzero. */
	{
	  char *b = cp;
	  size_t length = p->kcountsize + p->fromssize + p->tossize;
	  while (length--)
	    *b++ = 0;
	}

	p->tos = (struct tostruct *)cp;
	cp += p->tossize;
	p->kcount = (u_short *)cp;
	cp += p->kcountsize;
	p->froms = (u_short *)cp;

	/*	minbrk = sbrk(0); */
	p->tos[0].link = 0;

	o = p->highpc - p->lowpc;
	if (p->kcountsize < o) {
#ifndef notdef
		s_scale = ((float)p->kcountsize / o ) * SCALE_1_TO_1;
#else /* avoid floating point */
		int quot = o / p->kcountsize;
		
		if (quot >= 0x10000)
			s_scale = 1;
		else if (quot >= 0x100)
			s_scale = 0x10000 / quot;
		else if (o >= 0x800000)
			s_scale = 0x1000000 / (o / (p->kcountsize >> 8));
		else
			s_scale = 0x1000000 / ((o << 8) / p->kcountsize);
#endif
	} else
		s_scale = SCALE_1_TO_1;

	moncontrol(1);

	/* Find out sample rate once profiling is running. */
	_gmonprofrate =	p->profrate = hertz();
}


void __attribute__ ((no_instrument_function))
_mcleanup()
{
#if 0
	int fd;
#endif
	int fromindex;
	int endfrom;
	u_long frompc;
	int toindex;
	struct rawarc rawarc;
	struct gmonparam *p = &_gmonparam;
#ifdef DEBUG
	int log, len;
	char buf[200];
#endif

	/* Read out of profiling data is handled by GDB. _mcleanup has
           been reduced to turning off the profiling and printing
           debugging information . */

	if (p->state == GMON_PROF_ERROR)
	  _gmonerror = GMON_ERROR_OFLW;
	
	/* Turn off profiling. */
	moncontrol(0);

#ifdef DEBUG
	len = snprintf(buf, sizeof buf, "[mcleanup1] kcount 0x%x ssiz %d\n",
	    p->kcount, p->kcountsize);
	puts(buf);
#endif
#if 0
	write(fd, (char *)&gmonhdr, sizeof *gmonhdr);
#endif
#ifdef DEBUG
	{
	  int bins = (p->kcountsize/sizeof(HISTCOUNTER));
	  HISTCOUNTER *q = p->kcount;
	  HISTCOUNTER *kcount_end = p->kcount + bins;

	  int addr = p->lowpc;
	  int addr_advance = (p->highpc - p->lowpc)/bins;
	  
	  printf("Values in bins\n");
	  
	  while (q < kcount_end){
	    printf("0x%x: %d\n", addr, *q);
	    addr += addr_advance;
	    ++q;
	  }
	}
#endif
#if 0
	write(fd, p->kcount, p->kcountsize);
#endif
#ifdef DEBUG
	endfrom = p->fromssize / sizeof(*p->froms);
	for (fromindex = 0; fromindex < endfrom; fromindex++) {
		if (p->froms[fromindex] == 0)
			continue;

		frompc = p->lowpc;
		frompc += fromindex * p->hashfraction * sizeof(*p->froms);
		for (toindex = p->froms[fromindex]; toindex != 0;
		     toindex = p->tos[toindex].link) {
#ifdef DEBUG
			len = snprintf(buf, sizeof buf,
			"[mcleanup2] frompc 0x%x selfpc 0x%x count %d\n" ,
				frompc, p->tos[toindex].selfpc,
				p->tos[toindex].count);
			puts(buf);
#endif
#if 0
			rawarc.raw_frompc = frompc;
			rawarc.raw_selfpc = p->tos[toindex].selfpc;
			rawarc.raw_count = p->tos[toindex].count;
			write(fd, &rawarc, sizeof rawarc);
#endif
		}
	}
#endif
}


/*
 * Control profiling
 *	profiling is what mcount checks to see if
 *	all the data structures are ready.
 */
void __attribute__ ((no_instrument_function))
moncontrol(mode)
	int mode;
{
	struct gmonparam *p = &_gmonparam;

	if (mode) {
		/* start */
		profil((char *)p->kcount, p->kcountsize, p->lowpc,
		    s_scale);
		p->state = GMON_PROF_ON;
	} else {
		/* stop */
		profil((char *)0, 0, 0, 0);
		p->state = GMON_PROF_OFF;
	}
}


/*
 * discover the tick frequency of the machine
 * if something goes wrong, we return 0, an impossible hertz.
 */
static int __attribute__ ((no_instrument_function))
hertz()
{
  return _timer_frequency(0);
}
