Summary: The shared library for the S-Lang extension language.
Name: slang
Version: 1.4.9
Release: 13.gnupro.1
License: GPL
Group: System Environment/Libraries
Source: ftp://space.mit.edu/pub/davis/slang/v1.4/slang-%{version}.tar.bz2
Source2: README.UTF-8
Patch: slang-1.4.9-debian_utf8.patch
Patch2: slang-1.4.9-rhat_utf8.patch
Patch3: slang-1.4.9-buffer.patch
Patch10000: slang-1.4.9-cross.patch
Url: http://www.s-lang.org/
Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root
%if "%{_arch}" == %{_build_arch}
BuildRequires: libtool, libtermcap-devel
Requires: libtermcap
%else
BuildRequires: libtermcap-devel
%endif

%description
S-Lang is an interpreted language and a programming library.  The
S-Lang language was designed so that it can be easily embedded into
a program to provide the program with a powerful extension language.
The S-Lang library, provided in this package, provides the S-Lang
extension language.  S-Lang's syntax resembles C, which makes it easy
to recode S-Lang procedures in C if you need to.

%package devel
Summary: The static library and header files for development using S-Lang.
Group: Development/Libraries
Requires: slang = %{version}
Requires: libtermcap-devel

%description devel
This package contains the S-Lang extension language static libraries
and header files which you'll need if you want to develop S-Lang based
applications.  Documentation which may help you write S-Lang based
applications is also included.

Install the slang-devel package if you want to develop applications
based on the S-Lang extension language.

%prep
%setup -n slang-%{version} -q
%patch -p1 -b .debian
%patch2 -p1 -b .rhat
%patch3 -p1 -b .buffer
%if "%{_arch}" != %{_build_arch}
%patch10000 -p1 -b .cross
%endif

cp %{SOURCE2} .

%build
%if "%{_arch}" != %{_build_arch}
CC="%{__cc}"; export CC
RANLIB=%{__ranlib}; export RANLIB
%endif
%if "%{_arch}" == %{_build_arch}
perl -p -i -e 's/(ELF_CFLAGS=\"[^\"]*)-O2([^\"]*\".*)/$1'"$RPM_OPT_FLAGS"' $2/gs' configue
%endif
cp /usr/share/libtool/config.{sub,guess} autoconf
%configure --includedir=%{_includedir}/slang
make elf all

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}%{_includedir}/slang

%makeinstall \
  install_lib_dir=${RPM_BUILD_ROOT}%{_libdir} \
  install_include_dir=${RPM_BUILD_ROOT}%{_includedir}/slang install-elf
ln -sf libslang-utf8.so.%{version} ${RPM_BUILD_ROOT}%{_libdir}/libslang-utf8.so.1
ln -sf libslang-utf8.so ${RPM_BUILD_ROOT}%{_libdir}/libslang.so
ln -sf libslang-utf8.a ${RPM_BUILD_ROOT}%{_libdir}/libslang.a

# remove unpackaged files from the buildroot
rm -rf ${RPM_BUILD_ROOT}%{_prefix}/doc

%if "%{_arch}" != %{_build_arch}
# We need to do this so that find-debuginfo.sh will strip the shared
# libs.  It only strips executable files.
chmod 755 ${RPM_BUILD_ROOT}%{_libdir}/lib*.so.*
%endif

%clean
rm -rf ${RPM_BUILD_ROOT}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%{_libdir}/libslang*.so.*

%files devel
%defattr(-,root,root)
%doc doc README.UTF-8
%{_libdir}/libslang*.a
%{_libdir}/libslang*.so
%{_includedir}/slang

%changelog
* Thu Nov 04 2004 Adrian Havill <havill@redhat.com> 1.4.9-13
- re-sync old debian patch to latest 1.4.9 sources
- consolidate rhat hacks, fix SLsmg_draw_hline() artifact (#138445)

* Wed Nov 03 2004 Adrian Havill <havill@redhat.com> 1.4.9-7
- fixed potentional two buffer overflows (#120291)
- fixed date-in-future in %%changelog

* Sun Aug 01 2004 Alan Cox <alan@redhat.com>
- fixed requires so slang-devel pulls in libtermcap-devel (#125299)

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Mar 02 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Dec  5 2003 Jeremy Katz <katzj@redhat.com> 1.4.9-2
- rebuild to fix libslang-utf8.so.1 symlink

* Tue Oct 28 2003 Adrian Havill <havill@redhat.com> 1.4.9-1
- big upgrade to 1.4.9
- manually redid partially rotted utf patch for sldisply.c
- no longer necessary to chmod the so files
- change copyright header to license

* Fri Jun 13 2003 Bill Nottingham <notting@redhat.com> 1.4.5-18
- fix segfault in slcurses (#97216)

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Mon Feb 24 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 21 2003 Jakub Jelinek <jakub@redhat.com> 1.4.5-15
- for ACS characters, take them as is, not through wcrtomb
  and assume wcwidth returns 1 for them

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Sat Jan  4 2003 Jeff Johnson <jbj@redhat.com> 1.4.5-13
- set execute bits on library so that requires are genereted.

* Wed Nov 27 2002 Tim Powers <timp@redhat.com> 1.4.5-12
- remove unpackaged files from the buildroot
- lib64'ize

* Wed Jul 24 2002 Bill Nottingham <notting@redhat.com> 1.4.5-11
- fix write-before-beginning-of-string in SLsmg_write_nwchars

* Tue Jul  9 2002 Bill Nottingham <notting@redhat.com> 1.4.5-10
- fix segfault in odd environments

* Mon Jul  8 2002 Bill Nottingham <notting@redhat.com> 1.4.5-9
- tweak UTF-8 linedrawing patch slightly; add README describing some of
  the changes
- fix a utee/dtee typo

* Wed Jun 26 2002 Bill Nottingham <notting@redhat.com> 1.4.5-7
- add patch to support ACS linedrawing characters in UTF-8

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Jun 12 2002 Bill Nottingham <notting@redhat.com> 1.4.5-5
- removed keymap patch (#59171)
- added Debian utf8 patch

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Tue Mar  5 2002 Bill Nottingham <notting@redhat.com>
- fix symlink & ia64 fubarness

* Mon Mar  4 2002 Bill Nottingham <notting@redhat.com>
- update to 1.4.5

* Tue Jun 26 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- add link from library major version number

* Mon Jun 25 2001 Bill Nottingham <notting@redhat.com>
- added patch to fix Alt/Meta key handling (originally from mutt,
  <jorton@btconnect.com>)

* Fri Jun  1 2001 Oliver Paukstadt <oliver.paukstadt@millenux.com>
- forced to use RPM_OPT_FLAGS for ELF_CFLAGS too

* Mon Mar 12 2001 Bill Nottingham <notting@redhat.com>
- update to 1.4.4

* Tue Feb 27 2001 Bill Nottingham <notting@redhat.com>
- have slang-devel require slang = %%{version}

* Tue Aug 29 2000 Bill Nottingham <notting@redhat.com>
- update to 1.4.2

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Sat Jun 17 2000 Matt Wilson <msw@redhat.com>
- added defattr

* Sat Jun 10 2000 Bill Nottingham <notting@redhat.com>
- rebuild, FHS stuff

* Fri Apr 28 2000 Bill Nottingham <notting@redhat.com>
- autoconf fix for ia64

* Mon Apr 24 2000 Bill Nottingham <notting@redhat.com>
- update to 1.4.1

* Wed Mar 29 2000 Bill Nottingham <notting@redhat.com>
- fix background color problem with newt

* Thu Mar  2 2000 Bill Nottingham <notting@redhat.com>
- resurrect for the devel tree

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 4)

* Wed Oct 21 1998 Bill Nottingham <notting@redhat.com>
- libslang.so goes in -devel

* Sun Jun 07 1998 Prospector System <bugs@redhat.com>

- translations modified for de

* Sat Jun  6 1998 Jeff Johnson <jbj@redhat.com>
- updated to 1.2.2 with buildroot.

* Tue May 05 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Sat Apr 18 1998 Erik Troan <ewt@redhat.com>
- rebuilt to find terminfo in /usr/share

* Tue Oct 14 1997 Donnie Barnes <djb@redhat.com>
- spec file cleanups

* Mon Sep 1 1997 Donnie Barnes <djb@redhat.com>
- upgraded to 0.99.38 (will it EVER go 1.0???)
- all patches removed (all appear to be in this version)

* Thu Jun 19 1997 Erik Troan <ewt@redhat.com>
- built against glibc

