/***********************************************************
Copyright 1993 by Ove Kalkan

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* 
 * IconButtonP.h - Private definitions for IconButton widget
 * 
 */

#ifndef _XslIconButtonP_h
#define _XslIconButtonP_h

#include "IconButton.h"

/***********************************************************************
 *
 * IconButton Widget Private Data
 *
 ***********************************************************************/

typedef enum {
	HighlightNone,		/* Do not highlight. */
	HighlightWhenUnset,	/* Highlight only when unset, this is
				   to preserve current iconButton widget 
				   functionality. */
	HighlightAlways		/* Always highlight, lets the toggle widget
				   and other subclasses do the right thing. */
} XtIconButtonHighlight;

/************************************
 *
 *  Class structure
 *
 ***********************************/


/* New fields for the IconButton widget class record */
typedef struct _IconButtonClass 
{
	int makes_compiler_happy;  /* not used */
} IconButtonClassPart;

/* Full class record declaration */
typedef struct _IconButtonClassRec {
	CoreClassPart		core_class;
	SimpleClassPart		simple_class;
	IconButtonClassPart	iconButton_class;
} IconButtonClassRec;

extern IconButtonClassRec iconButtonClassRec;

/***************************************
 *
 *  Instance (widget) structure 
 *
 **************************************/

/* New fields for the IconButton widget record */
typedef struct {
	/* resources */
	Dimension	highlight_thickness;
	Pixmap		icon;
	Pixmap		shape;
	Dimension	width;
	Dimension	height;
	XtCallbackList	callbacks;

	/* private state */
	Pixmap      	gray_pixmap;
	GC          	normal_GC;
	GC          	inverse_GC;
	Boolean     	set;
	XtIconButtonHighlight	highlighted;
} IconButtonPart;


/* XtEventsPtr eventTable;*/


/* Full widget declaration */
typedef struct _IconButtonRec {
	CorePart		core;
	SimplePart		simple;
	IconButtonPart		iconButton;
} IconButtonRec;

#endif /* _XslIconButtonP_h */


