/* xscreensaver, Copyright (c) 1992 Jamie Zawinski <jwz@lucid.com>
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or 
 * implied warranty.
 */

#include "screenhack.h"

char *progclass = "XRoger";

char *defaults [] = {
  "*background: black",
  "*foreground: red",
  "*delay:	5",
  0
};

XrmOptionDescRec options [] = {
  { "-delay",		".delay",	XrmoptionSepArg, 0 }
};
int options_size = (sizeof (options) / sizeof (options[0]));

static void
crossbones (dpy, window, draw_gc, x, y, w, h)
     Display *dpy;
     Window window;
     GC draw_gc;
     int x, y, w, h;
{
  double xscale = w / 440.0;
  double yscale = h / 216.0;
  XPoint points [6];
  points [0].x = x + xscale * 20;
  points [0].y = y + yscale * 10;
  points [1].x = x + xscale * 120;
  points [1].y = y + yscale * 10;
  points [2].x = x + xscale * 243;
  points [2].y = y + yscale * 93;
  points [3].x = x + xscale * 57;
  points [3].y = y + yscale * 210;
  points [4].x = x + xscale * 20;
  points [4].y = y + yscale * 210;
  points [5].x = x + xscale * 175;
  points [5].y = y + yscale * 113;
  XFillPolygon (dpy, window, draw_gc, points, 6, Complex, CoordModeOrigin);
  points [0].x = x + xscale * 197;
  points [0].y = y + yscale * 127;
  points [1].x = x + xscale * 384;
  points [1].y = y + yscale * 10;
  points [2].x = x + xscale * 420;
  points [2].y = y + yscale * 10;
  points [3].x = x + xscale * 265;
  points [3].y = y + yscale * 108;
  points [4].x = x + xscale * 420;
  points [4].y = y + yscale * 210;
  points [5].x = x + xscale * 320;
  points [5].y = y + yscale * 210;
  XFillPolygon (dpy, window, draw_gc, points, 6, Complex, CoordModeOrigin);
}


static void
skull (dpy, window, draw_gc, erase_gc, x, y, w, h)
     Display *dpy;
     Window window;
     GC draw_gc, erase_gc;
     int x, y, w, h;
{
  int i;
  XPoint points [3];
  crossbones (dpy, window, draw_gc, x, y+h/2, w, h/2);
  x += w/100;
  y += h/15;
  XFillArc (dpy, window, draw_gc, x + ((int) (w * 0.3)), y, w/2, h/2,
	    -40*64, 260*64);
  XFillRectangle (dpy, window, draw_gc, x + ((int) w * 0.35), y + h/5,
		  ((int) w * 0.4), h/5);
  XFillRectangle (dpy, window, draw_gc, x + ((int) (w * 0.375)),
		  y + ((int) h * 0.425), w / 20, h / 20);
  XFillRectangle (dpy, window, draw_gc, x + ((int) (w * 0.495)),
		  y + ((int) h * 0.425), w / 20, h / 20);
  XFillRectangle (dpy, window, draw_gc, x + ((int) (w * 0.555)),
		  y + ((int) h * 0.425), w / 20, h / 20);
  XFillRectangle (dpy, window, draw_gc, x + ((int) (w * 0.675)),
		  y + ((int) h * 0.425), w / 20, h / 20);
  points [0].x = x + ((int) (w * 0.435));
  points [0].y = y + ((int) h * 0.425);
  points [1].x = x + ((int) (w * 0.485));
  points [1].y = points [0].y;
  points [2].x = (points [0].x + points [1].x) / 2;
  points [2].y = points [0].y + h/10;
  XFillPolygon (dpy, window, draw_gc, points, 3, Complex, CoordModeOrigin);
  points [0].x = x + ((int) (w * 0.615));
  points [1].x = x + ((int) (w * 0.665));
  points [2].x = (points [0].x + points [1].x) / 2;
  XFillPolygon (dpy, window, draw_gc, points, 3, Complex, CoordModeOrigin);
  points [0].x = x + ((int) w * 0.52);
  points [0].y = y + ((int) h * 0.35);
  points [1].x = points [0].x - w/20;
  points [1].y = points [0].y;
  points [2].x = points [0].x;
  points [2].y = points [0].y - w/10;
  XFillPolygon (dpy, window, erase_gc, points, 3, Complex, CoordModeOrigin);
  points [0].x += w/20;
  points [1].x += w * 0.15;
  points [2].x += w/20;
  XFillPolygon (dpy, window, erase_gc, points, 3, Complex, CoordModeOrigin);
  XFillArc (dpy, window, erase_gc, x + ((int) (w * 0.375)), y + h/7,
	    w/10, h/10, 0, 360*64);
  XFillArc (dpy, window, erase_gc, x + ((int) (w * 0.615)), y + h/7,
	    w/10, h/10, 0, 360*64);
}


void
screenhack (dpy, window)
     Display *dpy;
     Window window;
{
  double delta = 0.005;
  XGCValues gcv;
  Colormap cmap;
  GC draw_gc, erase_gc;
  unsigned int fg;
  XColor color, color2;
  int delay = get_integer_resource ("delay", "Integer");
  XWindowAttributes xgwa;
  XGetWindowAttributes (dpy, window, &xgwa);
  cmap = xgwa.colormap;
  gcv.foreground = get_pixel_resource ("background", "Background", dpy, cmap);
  erase_gc = XCreateGC (dpy, window, GCForeground, &gcv);
  fg = get_pixel_resource ("foreground", "Foreground", dpy, cmap);
  if (fg == gcv.foreground)
    fg = ((gcv.foreground == WhitePixel (dpy, DefaultScreen (dpy)))
	  ? BlackPixel (dpy, DefaultScreen (dpy))
	  : WhitePixel (dpy, DefaultScreen (dpy)));
  gcv.foreground = fg;
  draw_gc = XCreateGC (dpy, window, GCForeground, &gcv);
  color.pixel = gcv.foreground;
  XQueryColor (dpy, cmap, &color);
  while (1)
    {
      int w, h, ww, hh, x, y;
      time_t start_time;
      XWindowAttributes xgwa;
      XGetWindowAttributes (dpy, window, &xgwa);
      w = xgwa.width;
      h = xgwa.height;

      ww = 100 + random () % (w - 100);
      hh = 100 + random () % (h - 100);
      if (ww < 10) ww = 50;
      if (hh < 10) hh = 50;
      if (ww < hh) hh = ww;
      else ww = hh;
      x = random () % (w - ww);
      y = random () % (h - hh);
      XClearWindow (dpy, window);
      skull (dpy, window, draw_gc, erase_gc, x, y, ww, hh);
      XSync (dpy, True);
      start_time = time ((time_t *) 0);
      if (mono_p)
	sleep (delay);
      else
	while (start_time + delay > time ((time_t *) 0))
	  {
	    int h;
	    double s, v;
	    color2 = color;
	    rgb_to_hsv (color2.red, color2.green, color2.blue, &h, &s, &v);
	    v += delta;
	    if (v >= 1.0) v = 1.0, delta = -delta;
	    if (v <= 0.7) v = 0.7, delta = -delta;
	    hsv_to_rgb (h, s, v, &color2.red, &color2.green, &color2.blue);
	    if (XAllocColor (dpy, cmap, &color2))
	      {
		XSetForeground (dpy, draw_gc, color.pixel);
		XFreeColors (dpy, cmap, &color.pixel, 1, 0);
	      }
	    color = color2;
	    usleep (20000);
	  }
    }
}
