/*
 * Initializes all pixmaps used in the program. Only called once.
 *
 *	init_pixmaps()
 */

#include <stdio.h>
#include <Xm/Xm.h>
#include <X11/StringDefs.h>
#include "cal.h"

#include "bm_recycle.h"
#include "bm_advance.h"
#include "bm_message.h"
#include "bm_script.h"
#include "bm_group.h"
#include "bm_private.h"
#include "bm_icon.h"
#include "bm_iconsub.h"


static char blank_bits[] =
	{ 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };

extern void		get_rsrc();
extern char		*mktimestring();
extern time_t		get_time();

extern struct config	config;		/* global configuration data */
extern Display		*display;	/* everybody uses the same server */
extern char		*progname;	/* argv[0] */
extern Widget		toplevel;	/* top-level shell for icon name */
extern Pixel		color[NCOLS];	/* colors: COL_* */
Pixmap			pixmap[NPICS];	/* common symbols */


static char *pics[NPICS] = {
	advance_bits, recycle_bits, message_bits, script_bits,
	/* group_bits, private_bits, blank_bits, <<< not implemented yet */
	blank_bits, private_bits, blank_bits
};

static int pix_width[NPICS] = {
	advance_width, recycle_width, message_width, script_width,
	group_width, private_width, recycle_width
};

static int pix_height[NPICS] = {
	advance_height, recycle_height, message_height, script_height,
	group_height, private_height, recycle_height
};


/*
 * intialize pixmaps for mode buttons
 */

init_pixmaps()
{
	int			p;
	Colormap		cmap;
	XColor			rgb;
	char			*c;
	BOOL			failed;

	cmap = DefaultColormap(display, DefaultScreen(display));
	get_rsrc(&c, "background", "Background", XtRString);
	if (failed = !XParseColor(display, cmap, c, &rgb))
		fprintf(stderr, "unknown color \"background\" = %s\n", c);
	if (failed |= !XAllocColor(display, cmap, &rgb))
		fprintf(stderr, "can't allocate color \"background\"\n");
	for (p=0; p < NPICS; p++)
		if (!(pixmap[p] = XCreatePixmapFromBitmapData(display,
				DefaultRootWindow(display),
				pics[p], pix_width[p], pix_height[p],
				color[COL_STD],
				failed ? color[COL_BACK] : rgb.pixel,
				DefaultDepth(display,DefaultScreen(display)))))
			fatal("no memory for pixmaps");
}


/*
 * set icon for the application or a shell.
 */

set_icon(shell, sub)
	Widget			shell;
	int			sub;		/* 0=main, 1=submenu */
{
	Pixmap			icon;

	if (!config.noicon && !sub)
		if (icon = XCreatePixmapFromBitmapData(display,
				DefaultRootWindow(display),
				sub ? iconsub_bits : icon_bits,
				icon_width, icon_height,
				WhitePixelOfScreen(XtScreen(shell)),
				BlackPixelOfScreen(XtScreen(shell)),
				DefaultDepth(display, DefaultScreen(display))))

			XtVaSetValues(shell, XmNiconPixmap, icon, NULL);

	print_icon_name();
}


/*
 * change the name below the icon. Relies on <toplevel> from main(). Changing
 * the icon title to the current time can bbe switched off because it prevents
 * the screen saver from kicking in.
 */

print_icon_name()
{
	time_t			tod;		/* current time-of-day */

	if (config.showicontime) {
		tod = get_time() % 86400;
		XtVaSetValues(toplevel, XmNiconName,
					mktimestring(tod, FALSE), NULL);
	}	
}
