/*
 * definitions common to the main program and the daemon. It excludes all
 * X and motif stuff.
 */

#define DB_FILE		".dayplan"		/* public file name, no path */
#define DB_PUB_PATH	"~/.dayplan"		/* public appts & config */
#define DB_PRIV_PATH	"~/.dayplan.priv"	/* private appointments */
#define HOLIDAY_PATH	"~/.holiday"		/* holiday database */
#define HOLIDAY_NAME	"holiday"		/* global holiday dbase (LIB)*/
#define LOCK_PATH	"/tmp/.pland%d"	/* daemon lock/pid file, %d is uid */
#define PLAN_PATH	"/tmp/.plan%d"	/* plan lock/pid file, %d is uid */
#define HELP_FN		"plan.help"	/* help text file */
#define DAEMON_FN	"pland"		/* daemon program */
#define ALARM_FN	"notifier"	/* program that shows alarm popup. */
					/* the directoy is taken from the */
					/* daemon's argv[0] */
#define PS_SPOOLER	"lp"

#if defined(XlibSpecificationRelease) && defined(sgi)
#include <X11/Xmu/Editres.h>
#define EDITRES
#endif
#ifndef _XEditResCheckMessages
#undef  EDITRES
#endif

#ifndef PID_T
#define PID_T		pid_t		/* from types.h, see -DPID_T */
#endif

#define BOOL int
#define TRUE 1
#define FALSE 0

#define TIMER_PERIOD	10*1000		/* autosave and recycle period [ms] */
#define MAXT		0x7fffffff	/* highest possible time_t value */
#define ANCIENT		3*60		/* ignore triggers older than this */
#ifdef BSD
#define HIBERNATE	5*60		/* if no alarm in sight, sleep <5 min*/
#else
#define HIBERNATE	60*60		/* if no alarm in sight, sleep <1 h */
#endif
#define EON		631152000	/* ignore schedule entries before */
					/* this date (sometime early 1990) */

#define TIME(t)		((t)%86400)	/* extract time-of-day from date/time*/
#define DATE(t)		((t)/86400)	/* extract date from date/time */


struct config {			/* global configuration data */
	time_t		tzone;		/* timezone with dst figured in */
	BOOL		showicontime;	/* print time into icontitle if nz */
	BOOL		noicon;		/* don't draw anything into the icon */
	BOOL		frame_today;	/* draw black frame into today's box */
	BOOL		sgimode;	/* use SGI desktop style */
	BOOL		smallmonth;	/* large or small month menu? */

	BOOL		sunday_first;	/* TRUE for US style, else European */
	BOOL		ampm;		/* TRUE for US style, else European */
	BOOL		mmddyy;		/* TRUE for m/d/y, FALSE for d.m.y */
	BOOL		autodel;	/* TRUE deletes old entries after 24h*/
	BOOL		julian;		/* TRUE prints julian dates */
	BOOL		weeknum;	/* TRUE prints week numbers */
	BOOL		nopast;		/* TRUE skips todays past daybox notes*/
	BOOL		bigwarning;	/* TRUE shows wide adv-warning column*/
	BOOL		weekwarn;	/* TRUE shows warnings in week view */
	BOOL		weekuser;	/* TRUE shows user names in week bars*/

	time_t		adjust_time;	/* correction constant for sys clock */
	time_t		raw_tzone;	/* tzone dst NOT figured in */
	int		dst_flag;	/* 0=dst on, 1=dst off, 2=begin..end */
	int		dst_begin;	/* if dst_flag==2, first dst day */
	int		dst_end;	/* if dst_flag==2, last dst day */
	int		dst_begin_time;	/* time of day dst_begin */
	int		dst_end_time;	/* time of day dst_end */

	int		early_time;	/* default # of secs for early warn */
	int		late_time;	/* default # of secs for late warn */

	int		calbox_xs[2];	/* main window: width of one day */
	int		calbox_ys[2];	/* main window: height of one day */
	int		calbox_marg[2];	/* main window: margin all around */
	int		calbox_arrow[2];/* main window: arrow column width */
	int		calbox_title[2];/* main window: height of wkday row */

	int		year_margin;	/* year window: margin all around */
	int		year_gap;	/* year window: gap between months */
	int		year_title;	/* year window: title line height */
	int		yearbox_xs;	/* year window: day box width */
	int		yearbox_ys;	/* year window: day box height */

	int		week_minhour;	/* week window: leftmost hour (8) */
	int		week_maxhour;	/* week window: rightmost hour (24) */
	int		week_margin;	/* week window: margin all around */
	int		week_gap;	/* week window: gap around day boxes */
	int		week_title;	/* week window: title line height */
	int		week_hour;	/* week window: hour column height */
	int		week_daywidth;	/* week window: weekday title width */
	int		week_hourwidth;	/* week window: weekday title width */
	int		week_barheight;	/* week window: height of appt bar */
	int		week_bargap;	/* week window: gap above/below bar */
	int		week_maxnote;	/* week window: max length of note */

	BOOL		ewarn_window;	/* TRUE: popup window if early warn */
	BOOL		ewarn_mail;	/* TRUE: send mail if early warn */
	BOOL		ewarn_exec;	/* TRUE: exec program if early warn */
	BOOL		lwarn_window;	/* TRUE: popup window if late warn */
	BOOL		lwarn_mail;	/* TRUE: send mail if late warn */
	BOOL		lwarn_exec;	/* TRUE: exec program if late warn */
	BOOL		alarm_window;	/* TRUE: popup window if alarm time */
	BOOL		alarm_mail;	/* TRUE: send mail if alarm time */
	BOOL		alarm_exec;	/* TRUE: exec program if alarm time */
	char		*ewarn_prog;	/* program to exec at early warn time*/
	char		*lwarn_prog;	/* program to exec at late warn time */
	char		*alarm_prog;	/* program to exec at alarm time */
	char		*mailer;	/* mail command, %s is predef subject*/
	time_t		wintimeout;	/* max lifetime of notifiers */
};

struct entry {			/* one day-schedule entry */
	long		nextrep;	/* nxt repeating entry in chain or -1*/
	char		*message;	/* message text, 0 if none */
	char		*script;	/* shell script, 0 if none */
	char		*meeting;	/* comma-sep list of meeting members */
	char		*note;		/* explicit short note, 0 if none */
	time_t		time;		/* time and date in seconds */
	time_t		length;		/* length in seconds */
	time_t		early_warn;	/* warn this many seconds in advance */
	time_t		late_warn;	/* and this many seconds, too */
	time_t		rep_every;	/* repeat every N days (in seconds) */
	time_t		rep_last;	/* stop repeating on this date (secs)*/
	long		rep_weekdays;	/* weekday bitmap, bit 0=mon..6=sun */
					/* bit 8=1st..12=5th, 13=last week */
	long		rep_days;	/* day bitmap, bit 0=last, 1..31=days*/
	BOOL		rep_yearly;	/* repeat every year on the same date*/
	BOOL		suspended;	/* not active, green radio button off*/
	BOOL		private;	/* not accessible for others */
	BOOL		noalarm;	/* no alarm, just warnings if enabled*/
	BOOL		notime;		/* no time is printed in day lists */
	char		triggered;	/* 0=none, 1=early, 2=late, 3=time */
};


struct list {			/* list of entries */
	BOOL		modified;	/* TRUE if modified */
	BOOL		locked;		/* prevents writefile while changing */
	long		nentries;	/* # of valid entries in list */
	long		size;		/* # of entries allocated */
	long		repeating;	/* first repeating entry, -1 if none */
	struct entry	entry[1];	/* first entry. The list is allocated*/
};					/* with space for <size> entries.*/

				/* subset of list, points into struct list */
struct sublist {			/* list of entries */
	long		nentries;	/* # of valid entries in list */
	long		size;		/* # of entries allocated */
	struct entry	*entry[1];	/* first entry. The list is allocated*/
};					/* with space for <size> entries.*/


/*
 * when we look up an entry, an entry and its trigger time are returned in
 * this struct, which the caller must provide. lookup_entry() also stores
 * other information in this struct that enables lookup_next_entry() to
 * continue the search exactly where lookup_entry() left off.
 */

struct lookup {
					/* the next two are return values */
	long		index;		/* the entry found when looking up */
	time_t		trigger;	/* ... that entry's trigger time */
					/* the rest is for the next lookup */
	struct list	*list;		/* in which list were we looking */
	long		regindex;	/* last regular entry found */
	time_t		regtime;	/* ... that entry's trigger time */
	long		repindex;	/* last repeating entry found */
	time_t		reptime;	/* ... that entry's trigger time */
};


/*
 * Information stored about each user in the user list. The user list is
 * an array, because it doesn't change often and it facilitates sorting.
 * Only name, home, suspended, and color are stored in the database file.
 */

struct user {
	char		*name;		/* user name */
	char		*home;		/* home directory */
	BOOL		suspended;	/* stored, but ignored */
	int		color;		/* color 0..7 in the week view */
	time_t		time;		/* time when database was read */
	struct list	*list;		/* user's database */
};
