/*
 * Create the main calendar window and everything in it. That isn't all that
 * much because the calendar itself is drawn using Xlib calls. Attempts to
 * do that with Motif were spectacularly slow.
 *
 *	create_cal_widgets(toplevel)	Create all widgets in main calendar
 *					window.
 */

#ifndef MIPS
#include <stdlib.h>
#endif
#include <stdio.h>
#include <time.h>
#include <varargs.h>
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <Xm/LabelP.h>
#include <Xm/PushBP.h>
#include <Xm/PushBG.h>
#include <Xm/Text.h>
#include <Xm/Protocols.h>
#include <X11/cursorfont.h>
#include "cal.h"

static void filemenu_callback(), configmenu_callback(), search_callback(),
	    delpast_callback(), view_callback(), help_pulldown();
extern char *mkdatestring(), *mktimestring();
extern time_t length_of_month();
extern void help_callback();
extern struct tm *time_to_tm();
extern time_t get_time();

extern Display		*display;	/* everybody uses the same server */
extern GC		gc;		/* everybody uses this context */
extern struct config	config;		/* global configuration data */
extern struct list	*mainlist;	/* list of all schedule entries */
extern struct mainmenu	mainmenu;	/* all important main window widgets */
extern Pixel		color[NCOLS];	/* colors: COL_* */
extern int		curr_month;	/* month being displayed, 0..11 */
extern int		curr_year;	/* year being displayed, since 1900 */
extern time_t		curr_week;	/* week being displayed, time in sec */
Widget			mainwindow;	/* popup menus hang off main window */

#ifdef FIXMBAR
#define FIX_MENUBAR XmVaSEPARATOR,
#else
#define FIX_MENUBAR
#endif

#ifdef NOMSEP
#define XM_VA_SEPARATOR
#else
#define XM_VA_SEPARATOR XmVaSEPARATOR,
#endif



create_cal_widgets(toplevel)
	Widget			toplevel;
{
	Widget			menubar, menu, fmenu, w;
	XmString		s[20];
	int			n;

	mainwindow = XtCreateManagedWidget("mainwindow",
			xmMainWindowWidgetClass, toplevel, NULL, 0);

	/*------------------------------------- menu bar -------------------*/
	s[0] = XmStringCreateSimple("File");
	s[1] = XmStringCreateSimple("Config");
	s[2] = XmStringCreateSimple("Search");
	s[3] = XmStringCreateSimple("View");
	s[4] = XmStringCreateSimple("Help");
	menubar = XmVaCreateSimpleMenuBar(mainwindow, "menubar",
			FIX_MENUBAR
			XmVaCASCADEBUTTON, s[0], 'F',
			XmVaCASCADEBUTTON, s[1], 'C',
			XmVaCASCADEBUTTON, s[2], 'S',
			XmVaCASCADEBUTTON, s[3], 'V',
			XmVaCASCADEBUTTON, s[4], 'H',
			NULL);
	if (w = XtNameToWidget(menubar, "button_4"))
		XtVaSetValues(menubar, XmNmenuHelpWidget, w, 0);
	for (n=0; n < 5; n++)
		XmStringFree(s[n]);

	s[0] = XmStringCreateSimple("Print...");
	s[1] = XmStringCreateSimple("Delete past entries");
	s[2] = XmStringCreateSimple("About...");
	s[3] = XmStringCreateSimple("Quit");
	fmenu = XmVaCreateSimplePulldownMenu(menubar, "file", 0,
			filemenu_callback,
			FIX_MENUBAR
			XmVaPUSHBUTTON,    s[0], 'P', NULL, NULL,
			XmVaCASCADEBUTTON, s[1], 'D',
			XmVaPUSHBUTTON,    s[2], 'A', NULL, NULL,
			XmVaPUSHBUTTON,    s[3], 'Q', NULL, NULL,
			NULL);
	XtAddCallback(fmenu, XmNhelpCallback,
					help_callback, (XtPointer)"pd_file");
	for (n=0; n < 4; n++)
		XmStringFree(s[n]);

	s[0] = XmStringCreateSimple("older than one day");
	s[1] = XmStringCreateSimple("older than one week");
	s[2] = XmStringCreateSimple("older than one month");
	s[3] = XmStringCreateSimple("older than 90 days");
	s[4] = XmStringCreateSimple("older than one year");
	fmenu = XmVaCreateSimplePulldownMenu(fmenu, "delpast", 1,
			delpast_callback,
			FIX_MENUBAR
			XmVaPUSHBUTTON,    s[0], 'd',  NULL, NULL,
			XmVaPUSHBUTTON,    s[1], 'w',  NULL, NULL,
			XmVaPUSHBUTTON,    s[2], 'm',  NULL, NULL,
			XmVaPUSHBUTTON,    s[3], '9',  NULL, NULL,
			XmVaPUSHBUTTON,    s[4], 'y',  NULL, NULL,
			NULL);
	XtAddCallback(fmenu, XmNhelpCallback,
					help_callback, (XtPointer)"pd_file");
	for (n=0; n < 4; n++)
		XmStringFree(s[n]);

	s[0]  = XmStringCreateSimple("12-hour mode");
	s[1]  = XmStringCreateSimple("Sunday first");
	s[2]  = XmStringCreateSimple("Month/Day/Year");
	s[3]  = XmStringCreateSimple("Julian Dates");
	s[4]  = XmStringCreateSimple("Week numbers");
	s[5]  = XmStringCreateSimple("Auto delete past entries");
	s[6]  = XmStringCreateSimple("Don't show today's past");
	s[7]  = XmStringCreateSimple("Fast warning entry mode");
	s[8]  = XmStringCreateSimple("Adjust time...");
	s[9]  = XmStringCreateSimple("Alarm options...");
	s[10] = XmStringCreateSimple("Define holidays...");
	s[11] = XmStringCreateSimple("Configure week view...");
	menu = XmVaCreateSimplePulldownMenu(menubar, "config", 1,
			configmenu_callback,
			FIX_MENUBAR
			XmVaCHECKBUTTON, s[0],  '1', NULL, NULL,
			XmVaCHECKBUTTON, s[1],  'S', NULL, NULL,
			XmVaCHECKBUTTON, s[2],  'M', NULL, NULL,
			XM_VA_SEPARATOR
			XmVaCHECKBUTTON, s[3],  'J', NULL, NULL,
			XmVaCHECKBUTTON, s[4],  'W', NULL, NULL,
			XM_VA_SEPARATOR
			XmVaCHECKBUTTON, s[5],  'A', NULL, NULL,
			XmVaCHECKBUTTON, s[6],  'D', NULL, NULL,
			XmVaCHECKBUTTON, s[7],  'F', NULL, NULL,
			XM_VA_SEPARATOR
			XmVaPUSHBUTTON,  s[8],  't', NULL, NULL,
			XmVaPUSHBUTTON,  s[9],  'o', NULL, NULL,
			XmVaPUSHBUTTON,  s[10], 'h', NULL, NULL,
			XmVaPUSHBUTTON,  s[11], 'C', NULL, NULL,
			NULL);
	XtAddCallback(menu, XmNhelpCallback,
					help_callback, (XtPointer)"pd_config");
	if (w = XtNameToWidget(menu, "button_0"))
		XtVaSetValues(w, XmNset,		config.ampm,
				 XmNvisibleWhenOff,	True, NULL);
	if (w = XtNameToWidget(menu, "button_1"))
		XtVaSetValues(w, XmNset,		config.sunday_first,
				 XmNvisibleWhenOff,	True, NULL);
	if (w = XtNameToWidget(menu, "button_2"))
		XtVaSetValues(w, XmNset,		config.mmddyy,
				 XmNvisibleWhenOff,	True, NULL);
	if (w = XtNameToWidget(menu, "button_3"))
		XtVaSetValues(w, XmNset,		config.julian,
				 XmNvisibleWhenOff,	True, NULL);
	if (w = XtNameToWidget(menu, "button_4"))
		XtVaSetValues(w, XmNset,		config.weeknum,
				 XmNvisibleWhenOff,	True, NULL);
	if (w = XtNameToWidget(menu, "button_5"))
		XtVaSetValues(w, XmNset,		config.autodel,
				 XmNvisibleWhenOff,	True, NULL);
	if (w = XtNameToWidget(menu, "button_6"))
		XtVaSetValues(w, XmNset,		config.nopast,
				 XmNvisibleWhenOff,	True, NULL);
	if (w = XtNameToWidget(menu, "button_7"))
		XtVaSetValues(w, XmNset,		config.bigwarning,
				 XmNvisibleWhenOff,	True, NULL);
	if (w = XtNameToWidget(menu, "button_0"))
		XtVaSetValues(w, XmNselectColor, color[COL_TOGGLE], NULL);
	if (w = XtNameToWidget(menu, "button_1"))
		XtVaSetValues(w, XmNselectColor, color[COL_TOGGLE], NULL);
	if (w = XtNameToWidget(menu, "button_2"))
		XtVaSetValues(w, XmNselectColor, color[COL_TOGGLE], NULL);
	if (w = XtNameToWidget(menu, "button_3"))
		XtVaSetValues(w, XmNselectColor, color[COL_TOGGLE], NULL);
	if (w = XtNameToWidget(menu, "button_4"))
		XtVaSetValues(w, XmNselectColor, color[COL_TOGGLE], NULL);
	if (w = XtNameToWidget(menu, "button_5"))
		XtVaSetValues(w, XmNselectColor, color[COL_TOGGLE], NULL);
	if (w = XtNameToWidget(menu, "button_6"))
		XtVaSetValues(w, XmNselectColor, color[COL_TOGGLE], NULL);
	if (w = XtNameToWidget(menu, "button_7"))
		XtVaSetValues(w, XmNselectColor, color[COL_TOGGLE], NULL);

	for (n=0; n < 12; n++)
		XmStringFree(s[n]);

	s[0] = XmStringCreateSimple("Today");
	s[1] = XmStringCreateSimple("Tomorrow");
	s[2] = XmStringCreateSimple("This week");
	s[3] = XmStringCreateSimple("Next week");
	s[4] = XmStringCreateSimple("This month");
	s[5] = XmStringCreateSimple("All");
	s[6] = XmStringCreateSimple("Search keywords...");
	menu = XmVaCreateSimplePulldownMenu(menubar, "search", 2,
			search_callback,
			FIX_MENUBAR
			XmVaPUSHBUTTON, s[0], 'T', NULL, NULL,
			XmVaPUSHBUTTON, s[1], 'o', NULL, NULL,
			XmVaPUSHBUTTON, s[2], 'w', NULL, NULL,
			XmVaPUSHBUTTON, s[3], 'N', NULL, NULL,
			XmVaPUSHBUTTON, s[4], 'm', NULL, NULL,
			XmVaPUSHBUTTON, s[5], 'A', NULL, NULL,
			XmVaPUSHBUTTON, s[6], 'S', NULL, NULL,
			NULL);
	XtAddCallback(menu, XmNhelpCallback,
					help_callback, (XtPointer)"pd_search");
	for (n=0; n < 7; n++)
		XmStringFree(s[n]);

	s[0] = XmStringCreateSimple("Week");
	s[1] = XmStringCreateSimple("Month");
	s[2] = XmStringCreateSimple("Year");
	s[3] = XmStringCreateSimple("Goto today");
	s[4] = XmStringCreateSimple("Goto...");
	menu = XmVaCreateSimplePulldownMenu(menubar, "view", 3,
			view_callback,
			FIX_MENUBAR
			XmVaPUSHBUTTON, s[0], 'W', NULL, NULL,
			XmVaPUSHBUTTON, s[1], 'M', NULL, NULL,
			XmVaPUSHBUTTON, s[2], 'Y', NULL, NULL,
			XM_VA_SEPARATOR
			XmVaPUSHBUTTON, s[3], 't', NULL, NULL,
			XmVaPUSHBUTTON, s[4], 'G', NULL, NULL,
			NULL);
	XtAddCallback(menu, XmNhelpCallback,
					help_callback, (XtPointer)"pd_view");
	for (n=0; n < 5; n++)
		XmStringFree(s[n]);

	s[0] = XmStringCreateSimple("On context");
	s[1] = XmStringCreateSimple("Introduction");
	s[2] = XmStringCreateSimple("Getting help");
	s[3] = XmStringCreateSimple("Troubleshooting");
	s[4] = XmStringCreateSimple("Files and programs");
	s[5] = XmStringCreateSimple("X resources");
	(void)XmVaCreateSimplePulldownMenu(menubar, "help", 4,
			help_pulldown,
			FIX_MENUBAR
			XmVaPUSHBUTTON, s[0], 'c', NULL, NULL,
			XM_VA_SEPARATOR
			XmVaPUSHBUTTON, s[1], 'I', NULL, NULL,
			XmVaPUSHBUTTON, s[2], 'G', NULL, NULL,
			XmVaPUSHBUTTON, s[3], 'T', NULL, NULL,
			XmVaPUSHBUTTON, s[4], 'F', NULL, NULL,
			XmVaPUSHBUTTON, s[5], 'X', NULL, NULL,
			NULL);

	for (n=0; n < 6; n++)
		XmStringFree(s[n]);

	XtManageChild(menubar);

	create_month_view(mainwindow);
}


/*-------------------------------------------------- callbacks --------------*/
/*
 * some item in one of the menu bar pulldowns was pressed. All of these
 * routines are direct X callbacks.
 */

/*ARGSUSED*/
static void filemenu_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	switch (item) {
	  case 0:						/* print */
		create_print_popup();
		break;

	  case 2:						/* about */
		create_about_popup();
		break;

	  case 3:						/* quit */
		exit(0);
	}
}

static int period[5] = {1, 7, 31, 90, 366};
/*ARGSUSED*/
static void delpast_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	if (item < 5 && recycle_all(mainlist, TRUE, period[item])) {
		draw_calendar();
		update_all_listmenus();
	}
}

/*ARGSUSED*/
static void configmenu_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	switch (item) {
	  case 0:						/* am/pm */
		config.ampm = data->set;
		update_all_listmenus();
		print_icon_name();
		if (config.smallmonth)
			print_button(mainmenu.time,
					mktimestring(get_time(), FALSE));
		else
			print_button(mainmenu.time, "%s   %s",
					mkdatestring(get_time(), FALSE),
					mktimestring(get_time(), FALSE));
		mainlist->modified = TRUE;
		break;

	  case 1:						/* sun..sat */
		curr_week += 86400 * (config.sunday_first - data->set);
		config.sunday_first = data->set;
		draw_calendar();
		draw_year_calendar();
		draw_week_calendar();
		mainlist->modified = TRUE;
		break;

	  case 2:						/* m/d/y */
		config.mmddyy = data->set;
		update_all_listmenus();
		mainlist->modified = TRUE;
		break;

	  case 3:						/* julian */
		config.julian = data->set;
		draw_calendar();
		mainlist->modified = TRUE;
		break;

	  case 4:						/* week num */
		config.weeknum = data->set;
		draw_calendar();
		mainlist->modified = TRUE;
		break;

	  case 5:						/* auto del */
		config.autodel = data->set;
		mainlist->modified = TRUE;
		break;

	  case 6:						/* no past */
		config.nopast = data->set;
		mainlist->modified = TRUE;
		break;

	  case 7:						/* wide colmn*/
		destroy_all_listmenus();
		config.bigwarning = data->set;
		mainlist->modified = TRUE;
		break;

	  case 8:						/* time adj */
		create_adjust_popup();
		break;

	  case 9:						/* alarms */
		create_config_popup();
		break;

	  case 10:						/* def hlday */
		create_holiday_popup();
		break;

	  case 11:						/* week range*/
		create_weekrange_popup();
		break;
	}
}

/*ARGSUSED*/
static void search_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	time_t				now;		/* curr date, 0:00 */
	struct tm			*tm;

	now  = get_time();
	now -= now % 86400;
	tm   = time_to_tm(now);
	switch (item) {
	  case 0:						/* Today */
		create_list_popup(mainlist, now,
				(time_t)0, (char *)0, (struct entry *)0);
		break;

	  case 1:						/* Tomorrow */
		create_list_popup(mainlist, now+86400,
				(time_t)0, (char *)0, (struct entry *)0);
		break;

	  case 2:						/* This week */
		now -= (config.sunday_first ?  tm->tm_wday
					    : (tm->tm_wday+6)%7) * 86400;
		create_list_popup(mainlist, now, 7*86400,
				(char *)0, (struct entry *)0);
		break;

	  case 3:						/* Next week */
		now -= (config.sunday_first ?  tm->tm_wday
					    : (tm->tm_wday+6)%7) * 86400;
		create_list_popup(mainlist, now+7*86400, 7*86400,
				(char *)0, (struct entry *)0);
		break;

	  case 4:						/* This month*/
		now -= (tm->tm_mday-1) * 86400;
		create_list_popup(mainlist, now, length_of_month(now),
				(char*)0, (struct entry *)0);
		break;

	  case 5:						/* All */
		create_list_popup(mainlist, (time_t)0,
				(time_t)0, (char *)0, (struct entry *)0);
		break;

	  case 6:						/* Search */
		create_keyword_popup();
		break;
	}
}

/*ARGSUSED*/
static void view_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	time_t time = get_time();
	struct tm *tm = time_to_tm(time);
	switch (item) {
	  case 0:						/* week */
		time -= (tm->tm_wday + 6 + config.sunday_first)%7 * 86400;
		curr_week = time;
		create_week_menu();
		break;

	  case 99:						/* sm month */
		if (!config.smallmonth) {
			config.smallmonth  = TRUE;
			mainlist->modified = TRUE;
			destroy_month_view();
			create_month_view(mainwindow);
		}
		XRaiseWindow(display, XtWindow(mainmenu.cal));
		break;

	  case 1:						/* lg month */
		if (config.smallmonth) {
			config.smallmonth  = FALSE;
			mainlist->modified = TRUE;
			destroy_month_view();
			create_month_view(mainwindow);
		}
		XRaiseWindow(display, XtWindow(mainmenu.cal));
		break;

	  case 2:						/* year */
		create_year_menu();
		break;

	  case 3:						/* goto today*/
		curr_month = tm->tm_mon;
		curr_year  = tm->tm_year;
		curr_week  = time - 86400 *
				(tm->tm_wday - !config.sunday_first);
		draw_month_year();
		draw_calendar();
		draw_week_calendar();
		draw_year_calendar();
		break;

	  case 4:						/* goto */
		create_goto_popup();
		break;
	}
}

/*ARGSUSED*/
static void help_pulldown(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	Cursor				cursor;
	Widget				w;

	switch (item) {
	  case 0:						/* context */
		cursor = XCreateFontCursor(display, XC_question_arrow);
		if (w = XmTrackingLocate(mainwindow, cursor, False)) {
			data->reason = XmCR_HELP;
			XtCallCallbacks(w, XmNhelpCallback, &data);
		}
		XFreeCursor(display, cursor);
		break;

	  case 1:						/* intro */
		help_callback(mainwindow, "intro");
		break;

	  case 2:						/* help */
		help_callback(mainwindow, "help");
		break;

	  case 3:						/* trouble */
		help_callback(mainwindow, "trouble");
		break;

	  case 4:						/* files */
		help_callback(mainwindow, "files");
		break;

	  case 5:						/* widgets */
		help_callback(mainwindow, "widgets");
		break;
	}
}
