
function(FUNC1)
  set(VAR1 "set")
  unset(VAR2)
  return(PROPAGATE VAR1 VAR2)
endfunction()

set(VAR1 "initial")
set(VAR2 "initial")
func1()
if((NOT DEFINED VAR1 OR NOT VAR1 STREQUAL "set")
    OR DEFINED VAR2)
  message(SEND_ERROR "erroneous propagation for FUNC1")
endif()


function(FUNC2)
  block()
    set(VAR1 "set")
    unset(VAR2)
    return(PROPAGATE VAR1 VAR2)
  endblock()
endfunction()

set(VAR1 "initial")
set(VAR2 "initial")
func2()
if((NOT DEFINED VAR1 OR NOT VAR1 STREQUAL "set")
    OR DEFINED VAR2)
  message(SEND_ERROR "erroneous propagation for FUNC2")
endif()


function(FUNC3)
  block(SCOPE_FOR POLICIES)
    set(VAR1 "set")
    unset(VAR2)
    return(PROPAGATE VAR1 VAR2)
  endblock()
endfunction()

set(VAR1 "initial")
set(VAR2 "initial")
func3()
if((NOT DEFINED VAR1 OR NOT VAR1 STREQUAL "set")
    OR DEFINED VAR2)
  message(SEND_ERROR "erroneous propagation for FUNC3")
endif()


function(FUNC4)
  while(TRUE)
    set(VAR1 "set")
    unset(VAR2)
    return(PROPAGATE VAR1 VAR2)
  endwhile()
endfunction()

set(VAR1 "initial")
set(VAR2 "initial")
func4()
if((NOT DEFINED VAR1 OR NOT VAR1 STREQUAL "set")
    OR DEFINED VAR2)
  message(SEND_ERROR "erroneous propagation for FUNC4")
endif()


function(FUNC5)
  foreach(item IN ITEMS A B)
    set(VAR1 "set")
    unset(VAR2)
    return(PROPAGATE VAR1 VAR2)
  endforeach()
endfunction()

set(VAR1 "initial")
set(VAR2 "initial")
func5()
if((NOT DEFINED VAR1 OR NOT VAR1 STREQUAL "set")
    OR DEFINED VAR2)
  message(SEND_ERROR "erroneous propagation for FUNC5")
endif()


function(FUNC6)
  if(TRUE)
    set(VAR1 "set")
    unset(VAR2)
    return(PROPAGATE VAR1 VAR2)
  endif()
endfunction()

set(VAR1 "initial")
set(VAR2 "initial")
func6()
if((NOT DEFINED VAR1 OR NOT VAR1 STREQUAL "set")
    OR DEFINED VAR2)
  message(SEND_ERROR "erroneous propagation for FUNC6")
endif()


function(FUNC7)
  if(FALSE)
  else()
    set(VAR1 "set")
    unset(VAR2)
    return(PROPAGATE VAR1 VAR2)
  endif()
endfunction()

set(VAR1 "initial")
set(VAR2 "initial")
func7()
if((NOT DEFINED VAR1 OR NOT VAR1 STREQUAL "set")
    OR DEFINED VAR2)
  message(SEND_ERROR "erroneous propagation for FUNC7")
endif()


set(VAR1 "initial")
set(VAR2 "initial")
cmake_language(CALL func7)
if((NOT DEFINED VAR1 OR NOT VAR1 STREQUAL "set")
    OR DEFINED VAR2)
  message(SEND_ERROR "erroneous propagation for cmake_language(CALL FUNC7)")
endif()


set(VAR1 "initial")
set(VAR2 "initial")
cmake_language(EVAL CODE "
  function(FUNC8)
    set(VAR1 \"set\")
    unset(VAR2)
    return(PROPAGATE VAR1 VAR2)
  endfunction()

  func8()")
if((NOT DEFINED VAR1 OR NOT VAR1 STREQUAL "set")
    OR DEFINED VAR2)
  message(SEND_ERROR "erroneous propagation for cmake_language(EVAL CODE)")
endif()
