# Boost.Parameter

Boost.Parameter, part of collection of the [Boost C++ Libraries](https://github.com/boostorg), is a header-only library that implements named parameters for functions and templates in C++.

### Directories

* **doc** - Documentation sources
* **include** - Interface headers of Boost.Parameter
* **test** - Boost.Parameter unit tests

### More information

* [Documentation](https://www.boost.org/libs/parameter)
* [Report bugs](https://github.com/boostorg/parameter/issues/new). Be sure to mention Boost version, platform and compiler you're using. A small compilable code sample to reproduce the problem is always good as well.
* Submit your patches as [pull requests](https://github.com/boostorg/parameter/compare) against **develop** branch. Note that by submitting patches you agree to license your modifications under the [Boost Software License, Version 1.0](https://www.boost.org/LICENSE_1_0.txt).

### Build status

Branch          | GitHub Actions | AppVeyor | Test Matrix | Dependencies |
:-------------: | -------------- | -------- | ----------- | ------------ |
[`master`](https://github.com/boostorg/parameter/tree/master) | [![GitHub Actions](https://github.com/boostorg/parameter/actions/workflows/ci.yml/badge.svg?branch=master)](https://github.com/boostorg/parameter/actions?query=branch%3Amaster) | [![AppVeyor](https://ci.appveyor.com/api/projects/status/e9iptg55otiv040a/branch/master?svg=true)](https://ci.appveyor.com/project/Lastique/parameter/branch/master) | [![Tests](https://img.shields.io/badge/matrix-master-brightgreen.svg)](https://regression.boost.io/master/developer/parameter.html) | [![Dependencies](https://img.shields.io/badge/deps-master-brightgreen.svg)](https://pdimov.github.io/boostdep-report/master/parameter.html)
[`develop`](https://github.com/boostorg/parameter/tree/develop) | [![GitHub Actions](https://github.com/boostorg/parameter/actions/workflows/ci.yml/badge.svg?branch=develop)](https://github.com/boostorg/parameter/actions?query=branch%3Adevelop) | [![AppVeyor](https://ci.appveyor.com/api/projects/status/e9iptg55otiv040a/branch/develop?svg=true)](https://ci.appveyor.com/project/Lastique/parameter/branch/develop) | [![Tests](https://img.shields.io/badge/matrix-develop-brightgreen.svg)](https://regression.boost.io/develop/developer/parameter.html) | [![Dependencies](https://img.shields.io/badge/deps-develop-brightgreen.svg)](https://pdimov.github.io/boostdep-report/develop/parameter.html)

### License

Distributed under the [Boost Software License, Version 1.0](https://www.boost.org/LICENSE_1_0.txt).
