// Copyright John Maddock 2012.

// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const std::array<std::array<T, 5>, 1681> jacobi_elliptic_small = {{
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.6504814008555523940913182524024344909690304914367592725655712600281923768045401283620998764707764693e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244133973696151635920379696565170086974190992e-01), SC_(9.9999999999999999999999999999999999999999999999628966995620346223342181461431515637620350243665215080e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.6504814008555523940913182524024344909690304914356038800613310054830865914687618301634103078917338168e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244133973696151826615763590211178195021758793e-01), SC_(9.9999999999999999999999999999999999999999999999418956903357324218784742231100976423667721244640328945e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.6504814008555523940913182524024344909690304914027798723391089616386590188266692256822553895004737691e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244133973696157244157188296862020758148130289e-01), SC_(9.9999999999999999999999999999999999999999999993452696204168490870911613561919090434443527881778962629e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.6504814008555523940913182524024344909690304913052218556582079673621348947108779104417637686162896722e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244133973696173345926391915144123663683144195e-01), SC_(9.9999999999999999999999999999999999999999999975720048632921041975214334983463922773663246301371558079e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.6504814008555523940913182524024344909690304912372618758507282714946015960583626600059283156291032012e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244133973696184562594659391558357034445701976e-01), SC_(9.9999999999999999999999999999999999999999999963367292684459290855251530901083881607676209352596350232e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.6504814008555523940913182524024344909690304889783532888043627371778016267672955616082803704829236507e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244133973696557391255574683748524224459833699e-01), SC_(9.9999999999999999999999999999999999999999999552776433700754495454636367587944076648284400103707184302e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6504814008555523940913182524024344909690304821439689287767962044790479566381944530155678406625631702e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244133973697685393682827041343608589118700995e-01), SC_(9.9999999999999999999999999999999999999999998310523532852882161708648652005740665368880880910156584491e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6504814008555523940913182524024344909690304762977332560523723670737117904598123506030905571007525820e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244133973698650304007112032323166148527367075e-01), SC_(9.9999999999999999999999999999999999999999997247881626734957219094542687145216261006406307420236809325e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6504814008555523940913182524024344909690303831976744007277642905699914309078508034857277902993981434e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244133973714016295563039085806793646480974079e-01), SC_(9.9999999999999999999999999999999999999999980325535429971135087765023210979692154823009643251966522036e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6504814008555523940913182524024344909690302133731854710685114641012066105734375850645869948919458138e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244133973742045511601859311127502555051080985e-01), SC_(9.9999999999999999999999999999999999999999949457361664130189602800079536313829981986427076949318817789e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6504814008555523940913182524024344909690297085106157246959147019549187034633366860135865373130072792e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244133973825372139737312017993425357327472681e-01), SC_(9.9999999999999999999999999999999999999999857690940760870814533399831245189911999724717703220387897201e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6504814008555523940913182524024344909690242677885948711088664385488861032724509329344622403207481410e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244133974723353190001720047690056131101093059e-01), SC_(9.9999999999999999999999999999999999999998868757284550027385876551628249984105649518984138605236580531e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6504814008555523940913182524024344909690134933098417362621376030351507143097515536131758800073666674e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244133976501660868597958778702500430601729980e-01), SC_(9.9999999999999999999999999999999999999996910332533889451002177040231472679603830330500099612602677035e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6504814008555523940913182524024344909689717461858586327957602950267806604551468156898254148882224748e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244133983391946035930262518846860865434979203e-01), SC_(9.9999999999999999999999999999999999999989322160265823321349052149682027615133455037665915804501555188e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.6504814008555523940913182524024344909686323523656956557466573268843129097061735969718419269903756412e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244134039408264810361040874003831061763988570e-01), SC_(9.9999999999999999999999999999999999999927632191511183545177421364285740672490570631107123629541620207e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.6504814008555523940913182524024344909663872080081406338583759571333756176566943414887198590991250826e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244134409965165248396214212813572057652287157e-01), SC_(9.9999999999999999999999999999999999999519543189770621643635884806523323694404582563651057704462697028e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6504814008555523940913182524024344909588293831710191198186747356949388380517396812042654193369934302e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244135657370097707716573801601901386768273769e-01), SC_(9.9999999999999999999999999999999999998145794021824142620974495770659414222168637044587970657748003597e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6504814008555523940913182524024344909265858679866731016390766452234122292419645132917080994605064614e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244140979102308704385651739160793286510212057e-01), SC_(9.9999999999999999999999999999999999992285046636067702713907942013032905297195860994461375719475855459e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6504814008555523940913182524024344908045794234673931872034147213497000375265822385091582975735928436e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244161116039055063020239008290949554874460617e-01), SC_(9.9999999999999999999999999999999999970108526902606423004774330258537078837146430522090471722713952519e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6504814008555523940913182524024344903093459707187946270419675021577786501184313307591933565375527000e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244242853399339366916813650688688000362016475e-01), SC_(9.9999999999999999999999999999999999880092343898322941123574529398516994582299038041465074714265274086e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.6504814008555523940913182524024344900557430873575286480834184767300136835270193965664311004583807788e-12), SC_(9.9999999999999999999999863795557271494668646082344582907244284710083558477870086857644172480108004954e-01), SC_(9.9999999999999999999999999999999999833996177671340856797365910449015966708782329210939364313955500541e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.6504814008555523940913182524024344828493076459684986213773022347093484446159289129769394585309247486e-12), SC_(9.9999999999999999999999863795557271494668646082344582907245474118849806364601873345118093854029707223e-01), SC_(9.9999999999999999999999999999999998524117356076599440004095602362538092572757468874215804799068642818e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.6504814008555523940913182524024344486247790091707702262795314936221015531815002316170628477073465482e-12), SC_(9.9999999999999999999999863795557271494668646082344582907251122813646614652970895342707489706828991315e-01), SC_(9.9999999999999999999999999999999992303290762261561334779801430374930423054200867021151405157838736656e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6504814008555523940913182524024343197792581537814943695196301355019723927496347050918189746703855313e-12), SC_(9.9999999999999999999999863795557271494668646082344582907272388527222151271310577616873634865441592576e-01), SC_(9.9999999999999999999999999999999968883665290214396116379872831911234710973570091992907537181511730001e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6504814008555523940913182524024338226614063923213889688236305211576366686595773701290696153140447922e-12), SC_(9.9999999999999999999999863795557271494668646082344582907354436904058707022213171582426154214436188544e-01), SC_(9.9999999999999999999999999999999878524964216011785539130673086897560712513367984413617815284173143395e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6504814008555523940913182524024336313257796690717232582958808272013242449790984161961450928911993045e-12), SC_(9.9999999999999999999999863795557271494668646082344582907386016493381483439646119915145634254466691917e-01), SC_(9.9999999999999999999999999999999843746815254611571572970309361929540121712190245822855953446615016498e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6504814008555523940913182524024283319260934630243189760434925456680697497307076585496917868114187467e-12), SC_(9.9999999999999999999999863795557271494668646082344582908260672555159766629352771353376223276775491667e-01), SC_(9.9999999999999999999999999999998880500634450812967602838998059802892239606075824273672160120376317752e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.6504814008555523940913182524023983889733496652467990049201795134733014294157024278163295335443966090e-12), SC_(9.9999999999999999999999863795557271494668646082344582913202701214193262835769764373707653151138993528e-01), SC_(9.9999999999999999999999999999993437915326623098964989354923292185637094772281066082197629864438805784e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.6504814008555523940913182524022897335215239222598815631537173159407561507879187519021188408054921633e-12), SC_(9.9999999999999999999999863795557271494668646082344582931136081448187790138596716838732538064810648220e-01), SC_(9.9999999999999999999999999999973688140787615310579357942740356815158976333437729811693880225910483396e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.6504814008555523940913182524021339383937035862678498638922734418890993093758754474568358080405367946e-12), SC_(9.9999999999999999999999863795557271494668646082344582956849777529325589257928675869855869325812371711e-01), SC_(9.9999999999999999999999999999945370015953325655384602961293939122003892110798898131567235383852001565e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6504814008555523940913182524015026830108588652855899753763576151678085674944079184942050235113453702e-12), SC_(9.9999999999999999999999863795557271494668646082344583061037304386841901606479684438673798033961401033e-01), SC_(9.9999999999999999999999999999830629786372277352409899163925956484160704110986924453742293611435143228e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6504814008555523940913182523995485634359548956096361882563596380999728556777930386904991178041525430e-12), SC_(9.9999999999999999999999863795557271494668646082344583383561105729517943304035449934798536740518811098e-01), SC_(9.9999999999999999999999999999475438948010023448387710436479396482580506646689917525139610249394780772e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6504814008555523940913182523793216176485233091742459375816037288445485874591232407130943066879293771e-12), SC_(9.9999999999999999999999863795557271494668646082344586721980887556457851073670867663081468527646209361e-01), SC_(9.9999999999999999999999999995798885105546853921792573713736563701186671673912571115618956789030604852e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6504814008555523940913182523458323341630628484621076023185195053425260108584252015988632975994719535e-12), SC_(9.9999999999999999999999863795557271494668646082344592249324839629607601394040473557576571083535756996e-01), SC_(9.9999999999999999999999999989711700457219261248231444833255411605055285308821920288838369150097221268e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.6504814008555523940913182517310184944314149146498437249380977482415838601451719317772802297376117288e-12), SC_(9.9999999999999999999999863795557271494668646082344693723205586196743462240184087474308021464026616215e-01), SC_(9.9999999999999999999999999877959970432339901821916749327376871033444575302441473720673604945118908285e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.6504814008555523940913182504348062354925327611584118482790885258437668123244162088962153355919384633e-12), SC_(9.9999999999999999999999863795557271494668646082344907660628080155366713763448921227275905105640351462e-01), SC_(9.9999999999999999999999999642353754282257153990023661278314609748272732997602895291002872977885608653e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6504814008555523940913182430005016718771948553497626611825365005942155373206819718971373569621408606e-12), SC_(9.9999999999999999999999863795557271494668646082346134678769134422270319489394292040634431338761493726e-01), SC_(9.9999999999999999999999998291056267422668447488821537170572606639920698929026039039668396329689525110e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6504814008555523940913182110890399621044994729072497529990014250407938875832017055810317227762413708e-12), SC_(9.9999999999999999999999863795557271494668646082351401606171743818212453168064105338597686971870965626e-01), SC_(9.9999999999999999999999992490664631401038840595223368787427491772513053330858026131682087201079470725e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6504814008555523940913180725783938699157943407471623932542265692330907017736648973684483053841462242e-12), SC_(9.9999999999999999999999863795557271494668646082374262530691308144010655408422754159519211235144184206e-01), SC_(9.9999999999999999999999967314256217397176060665540920624439249707100029834464479678568657082336199509e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6504814008555523940913178288360850237273189329790300476295811668607508963248358075259152903621041766e-12), SC_(9.9999999999999999999999863795557271494668646082414491745426530529553613532617132200983279952081834503e-01), SC_(9.9999999999999999999999923010398799826598566579537817142954225505357951815619084852564506764228635383e-01) }},
      {{ SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.6504814008555523940913161980955468855619053646604224228809082941366803177001947001331535300475487816e-12), SC_(9.9999999999999999999999863795557271494668646082683642438208352191229982656130866978272566227244051394e-01), SC_(9.9999999999999999999999626598599679973566780465171323631091118568244464679466445378789279157268571526e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(2.0654207510961697380480458244761958518053371111938858907485493371259134650336964818462808225321662810e-12), SC_(9.9999999999999999999999786701856047066702691270533506493581747534468907740366080453322916977083731853e-01), SC_(9.9999999999999999999999999999999999999999999999418956903357324218784742529732729030913526768316283907e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(2.0654207510961697380480458244761958518053371111916216466225310559360637309838772876606137663140057387e-12), SC_(9.9999999999999999999999786701856047066702691270533506493581747534468908208027760795899790911546313308e-01), SC_(9.9999999999999999999999999999999999999999999999090078035724674893085607548857313732865855991581695736e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(2.0654207510961697380480458244761958518053371111272958297207750493201776029281246532932962628938923136e-12), SC_(9.9999999999999999999999786701856047066702691270533506493581747534468921494015466805857927362867546446e-01), SC_(9.9999999999999999999999999999999999999999999989746826758576901162344444929662189951029162324313728702e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(2.0654207510961697380480458244761958518053371109361095744827973217791933728255854418529965344572555408e-12), SC_(9.9999999999999999999999786701856047066702691270533506493581747534468960982021356094655309722569652271e-01), SC_(9.9999999999999999999999999999999999999999999961977242018541177287629160975152566437551007217165825242e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(2.0654207510961697380480458244761958518053371108029271412242471030677529740341245919536555741686136116e-12), SC_(9.9999999999999999999999786701856047066702691270533506493581747534468988489797489463684271849988462705e-01), SC_(9.9999999999999999999999999999999999999999999942632646029389763516193597259190365744008535550129320277e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(2.0654207510961697380480458244761958518053371063761020747112454358519115535427693451758176455512876503e-12), SC_(9.9999999999999999999999786701856047066702691270533506493581747534469902815432874327230451479305689353e-01), SC_(9.9999999999999999999999999999999999999999999299641372096912362070986595001905902828533503356553750940e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(2.0654207510961697380480458244761958518053370929826322492173928312681368315331713439460372156836940778e-12), SC_(9.9999999999999999999999786701856047066702691270533506493581747534472669130483549867078162972791658434e-01), SC_(9.9999999999999999999999999999999999999999997354255210214069681274966261328996587764221747691079219719e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(2.0654207510961697380480458244761958518053370815256557388935725591545685774094302332635674188222511394e-12), SC_(9.9999999999999999999999786701856047066702691270533506493581747534475035478186474286933106806486423482e-01), SC_(9.9999999999999999999999999999999999999999995690142485834305377818497504610285304416048569159615162680e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(2.0654207510961697380480458244761958518053368990757431581117720570584620075429254089092563620266266525e-12), SC_(9.9999999999999999999999786701856047066702691270533506493581747534512719061734477172419102303221879573e-01), SC_(9.9999999999999999999999999999999999999999969189501517070270504152444118319908189915227860515521868138e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(2.0654207510961697380480458244761958518053365662675415280630271441036210793862881251485001873873869353e-12), SC_(9.9999999999999999999999786701856047066702691270533506493581747534581457958312647250464675012075088372e-01), SC_(9.9999999999999999999999999999999999999999920849491165171865789662072259584900206575014141851646785628e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(2.0654207510961697380480458244761958518053355768789971161340262259435245766273522435169128301026715729e-12), SC_(9.9999999999999999999999786701856047066702691270533506493581747534785808321365170499222565295999963573e-01), SC_(9.9999999999999999999999999999999999999999777141937551192327298588604323061941405918425259417590646487e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.0654207510961697380480458244761958518053249145951136693839787315177793823019658873638401178040602899e-12), SC_(9.9999999999999999999999786701856047066702691270533506493581747536988018560060087699189589713268676559e-01), SC_(9.9999999999999999999999999999999999999998228457407613936734825264218326722572912264156678273940123719e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.0654207510961697380480458244761958518053037996492072682209678812802679029284753994886432752792471804e-12), SC_(9.9999999999999999999999786701856047066702691270533506493581747541349143303395496162175696621864827328e-01), SC_(9.9999999999999999999999999999999999999995161535683041119249663352113741965058928217927693465112712484e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.0654207510961697380480458244761958518052219870358226455681956458309766033134582695172800986321144811e-12), SC_(9.9999999999999999999999786701856047066702691270533506493581747558246890241996283056042530847709994912e-01), SC_(9.9999999999999999999999999999999999999983278347232280757584649041303551151461467052268515184865088460e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.0654207510961697380480458244761958518045568706698338902533945091049812766513240487359792484352660949e-12), SC_(9.9999999999999999999999786701856047066702691270533506493581747695621404662681275710084024465601782220e-01), SC_(9.9999999999999999999999999999999999999886670956369799833973752666687742070412702559911241333905303795e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.0654207510961697380480458244761958518001570196192164095899716419200946682629207045146258868031627271e-12), SC_(9.9999999999999999999999786701856047066702691270533506493581748604375770830444120566399852472055034694e-01), SC_(9.9999999999999999999999999999999999999247597627371477649312211987845642890884162963290783037575690576e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.0654207510961697380480458244761958517853458100691075398076637889238029335303938890163904512357755314e-12), SC_(9.9999999999999999999999786701856047066702691270533506493581751663513726193306530580824067712917254446e-01), SC_(9.9999999999999999999999999999999999997096286393244262328792500983964469332580253825076590899930236247e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.0654207510961697380480458244761958517221575951634346942714052573603045409642769928595313184157302023e-12), SC_(9.9999999999999999999999786701856047066702691270533506493581764714538755283406216881679519636731796197e-01), SC_(9.9999999999999999999999999999999999987918270503919440552079168643215261844820225310973293946271706612e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.0654207510961697380480458244761958514830593023102984310635923576285762439101866652978612232275451639e-12), SC_(9.9999999999999999999999786701856047066702691270533506493581814098396316337071582025349849825144072145e-01), SC_(9.9999999999999999999999999999999999953189517140774294225099580767473551914693901870139898106420023140e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.0654207510961697380480458244761958505125411171234271682669221642653832285247971004439881839689724358e-12), SC_(9.9999999999999999999999786701856047066702691270533506493582014551236216452991440636092195497232991342e-01), SC_(9.9999999999999999999999999999999999812222861605073882109590681751804733739114917291490882326892845942e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.0654207510961697380480458244761958500155508416242521981343062800134488514716058531560401752775878397e-12), SC_(9.9999999999999999999999786701856047066702691270533506493582117200639027352820570525496433066252278173e-01), SC_(9.9999999999999999999999999999999999740035592947768588907078486302539277060621941912645107086967456481e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.0654207510961697380480458244761958358929656094960234671400620194273699373232332682164941461714940810e-12), SC_(9.9999999999999999999999786701856047066702691270533506493585034108698783548904191019832949206142103092e-01), SC_(9.9999999999999999999999999999999997688746252802470193579900534092482625340761356549614214110853144236e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.0654207510961697380480458244761957688225218882342399235144686994566452932009911592948555947416017621e-12), SC_(9.9999999999999999999999786701856047066702691270533506493598886977323495738367962505354573868365895329e-01), SC_(9.9999999999999999999999999999999987946841071642770208689671059928857458144247350900383576459793531963e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.0654207510961697380480458244761955163215642570285851431481834751897380002519390440970540253917569156e-12), SC_(9.9999999999999999999999786701856047066702691270533506493651039049079810429916381080395750162771687806e-01), SC_(9.9999999999999999999999999999999951271365990277798678611609612149117629203854723900789833994469958760e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.0654207510961697380480458244761945421104873642759006868152055122926152216322551678507069440363252121e-12), SC_(9.9999999999999999999999786701856047066702691270533506493852254626496014191921916103606473113209234262e-01), SC_(9.9999999999999999999999999999999809768322161210790975803058995488526323574569948487119033662819716161e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.0654207510961697380480458244761941671465099140139191530463092201593967440716534693535492040726628403e-12), SC_(9.9999999999999999999999786701856047066702691270533506493929700464489946927375423282985115451621235182e-01), SC_(9.9999999999999999999999999999999755305233623256572706138651695617276884316940000803942269629799882096e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.0654207510961697380480458244761837818146275634580032994942107697904143998473456783635913697076136555e-12), SC_(9.9999999999999999999999786701856047066702691270533506496074708462172695276541168658300097875496931175e-01), SC_(9.9999999999999999999999999999998246847664843800262542459122056152709160600109741619870914666925586380e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.0654207510961697380480458244761251020546178957698380133865895074812337437531286328419881045476650550e-12), SC_(9.9999999999999999999999786701856047066702691270533506508194547861503777366504292611754891553556530806e-01), SC_(9.9999999999999999999999999999989723679688751051295101919089706968738371216789626979324884526777350830e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.0654207510961697380480458244759121679498410289656408194258757878939292173516345631984713692462053699e-12), SC_(9.9999999999999999999999786701856047066702691270533506552174399723726451289486859027323042243906273467e-01), SC_(9.9999999999999999999999999999958795244695950079979759227803013629800554093652529581453176902841526086e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.0654207510961697380480458244756068533474571192179421230491370424558943899155422215559749551050540368e-12), SC_(9.9999999999999999999999786701856047066702691270533506615234711261366779963643579515054313059189726250e-01), SC_(9.9999999999999999999999999999914448648165164995532856131945301787787374469593225281348349993855018190e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.0654207510961697380480458244743697704623094015139859649007391127832205274505160552977856746614659609e-12), SC_(9.9999999999999999999999786701856047066702691270533506870744377442368358268594184911136498881854522269e-01), SC_(9.9999999999999999999999999999734763775072188568856924153428533786570011100044823102305658732115709909e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.0654207510961697380480458244705402460775003467507619037606627315524738319797560921385979886818227641e-12), SC_(9.9999999999999999999999786701856047066702691270533507661702290563709882028001689431575396334309239578e-01), SC_(9.9999999999999999999999999999178529741482185411353322217167766351977331251439132411143543996956728490e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.0654207510961697380480458244309011251567723480826908802375864103070878383745348194715413340522057767e-12), SC_(9.9999999999999999999999786701856047066702691270533515848848581051901717141566929730844487986024486793e-01), SC_(9.9999999999999999999999999993420992798993754500425450879674709536840008304484179216540467558484676674e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.0654207510961697380480458243652715549992468358708185483605485945663480821761920372820400494892170949e-12), SC_(9.9999999999999999999999786701856047066702691270533529404116189939412747597605529108522709093182050527e-01), SC_(9.9999999999999999999999999983888372853731616432309237004571058946521210740260578600318163943845095112e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.0654207510961697380480458231604094669225050933307014306319933846902014912302557734796129379690384669e-12), SC_(9.9999999999999999999999786701856047066702691270533778258832082215747438060047705886419131171892517080e-01), SC_(9.9999999999999999999999999808883533655138538474429087092199309026899200088685614346051456918753551524e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.0654207510961697380480458206201982550580442501077583674546890177282317465492533074355244710057869476e-12), SC_(9.9999999999999999999999786701856047066702691270534302919326997416374623195021620075202861044538682260e-01), SC_(9.9999999999999999999999999439920762677412847980253082401223105637037763990891117554381264545148296862e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.0654207510961697380480458060510536765532949181253394821760343634592690214377715431211581113541599548e-12), SC_(9.9999999999999999999999786701856047066702691270537312060680813813238626079890934715034528382594699249e-01), SC_(9.9999999999999999999999997323769188606239464554541194358966154085847491333180824039277721078995593831e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.0654207510961697380480457435135701254351485413099735427241500150814537351468632558950652230593180933e-12), SC_(9.9999999999999999999999786701856047066702691270550228682305595293457688600011974509323077084055760975e-01), SC_(9.9999999999999999999999988240271283698298361483065443381611314499556948991916556696606186618761994122e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.0654207510961697380480454720716872551096168077301749346087408531458444231399523478338292215455205917e-12), SC_(9.9999999999999999999999786701856047066702691270606292852065293922471543940012209214850403245548454079e-01), SC_(9.9999999999999999999999948813648491282085470433136477215347552583447865098485166452005925927508507609e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.0654207510961697380480449944053625717754355049429781504909699530126929877591829691293189783981799002e-12), SC_(9.9999999999999999999999786701856047066702691270704951045975373819196498316602002744070347123104716283e-01), SC_(9.9999999999999999999999879433161571632680273705880470644249815358050055124787445825775340002579221194e-01) }},
      {{ SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(2.0654207510961697380480417986128756132238840444072611333983557404084017448395032307821488222547123762e-12), SC_(9.9999999999999999999999786701856047066702691271365016657851516596958154111777605111743304552137860023e-01), SC_(9.9999999999999999999999415247960769936611581849099218324496306963864084736069161795169748363189495798e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(6.9332300317581641024843874457792499603783449921176599944508720491471711873940531965476747401600283514e-12), SC_(9.9999999999999999999997596516066336334339544138801238497263468303307112319146484824099086900130766145e-01), SC_(9.9999999999999999999999999999999999999999999993452696204168490870911712525703205172489638348678969365e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(6.9332300317581641024843874457792499603783449920320145100043700907784742047221050639847113879555590550e-12), SC_(9.9999999999999999999997596516066336334339544138801238497263468303307171699130969720511337839999190697e-01), SC_(9.9999999999999999999999999999999999999999999989746826758576901162344594638691075332357550385404536416e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(6.9332300317581641024843874457792499603783449895988776906738752390495330803944238117191783073524630692e-12), SC_(9.9999999999999999999997596516066336334339544138801238497263468303308858648857685593032632621412220671e-01), SC_(9.9999999999999999999999999999999999999999999884465299612412640139612049565898598719505105091338051993e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(6.9332300317581641024843874457792499603783449823672195575185938556931935494425470710246607031514664942e-12), SC_(9.9999999999999999999997596516066336334339544138801238497263468303313872523792505630759766641075765734e-01), SC_(9.9999999999999999999999999999999999999999999571552352831612969372837682257540919638063428661845902285e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(6.9332300317581641024843874457792499603783449773295675282513426542853331393247928384203883117726214027e-12), SC_(9.9999999999999999999997596516066336334339544138801238497263468303317365243826391947148148711612649558e-01), SC_(9.9999999999999999999999999999999999999999999353573776921456234944329615109404539065073738330201190427e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(6.9332300317581641024843874457792499603783448098840288494581982647292622918300245077283319348971552085e-12), SC_(9.9999999999999999999997596516066336334339544138801238497263468303433459087571565135954752631980114914e-01), SC_(9.9999999999999999999999999999999999999999992108226172191913856237102163105433165413632463103391635683e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(6.9332300317581641024843874457792499603783443032733686106224473358260455271683626251348576964048423652e-12), SC_(9.9999999999999999999997596516066336334339544138801238497263468303784703911969237903689331852564176292e-01), SC_(9.9999999999999999999999999999999999999999970187245997658451154360506577226349428361946382168339523720e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(6.9332300317581641024843874457792499603783438699109532051757237928375506259680047006318240015707952498e-12), SC_(9.9999999999999999999997596516066336334339544138801238497263468304085164043281667912825853008764686996e-01), SC_(9.9999999999999999999999999999999999999999951435708254626761127379190505087707158350549386386474649426e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(6.9332300317581641024843874457792499603783369687067188006266053515492430443795991748684641341756610648e-12), SC_(9.9999999999999999999997596516066336334339544138801238497263468308869927688608690779369017528135759059e-01), SC_(9.9999999999999999999999999999999999999999652821460517580037946502539328018929959017763993796279145613e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(6.9332300317581641024843874457792499603783243801702934026109912346385790254404968519064880222926328832e-12), SC_(9.9999999999999999999997596516066336334339544138801238497263468317597849568653799719784845108993566682e-01), SC_(9.9999999999999999999999999999999999999999108117057184560239693852183857056161227584748210475789725848e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(6.9332300317581641024843874457792499603782869563518021561748752675961869724157659073463455097096510745e-12), SC_(9.9999999999999999999997596516066336334339544138801238497263468343544643795311429445675486122791680420e-01), SC_(9.9999999999999999999999999999999999999997488793091883081043177926673101130833352569418997897988540531e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.9332300317581641024843874457792499603778836533430803156078403860638626024652133257877188454916134205e-12), SC_(9.9999999999999999999997596516066336334339544138801238497263468623163896992180410305397866726782663040e-01), SC_(9.9999999999999999999999999999999999999980037922132410433165023863214869956408509163324723801955075920e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.9332300317581641024843874457792499603770849763142055544965506992403445824402121339735883151552484990e-12), SC_(9.9999999999999999999997596516066336334339544138801238497263469176905053219168023057043203788987340326e-01), SC_(9.9999999999999999999999999999999999999945479266561354968597990517051685593364404310775185544479339623e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.9332300317581641024843874457792499603739903979396191894330308492086719358257235548161291347093583036e-12), SC_(9.9999999999999999999997596516066336334339544138801238497263471322447425450323192803186052421832573221e-01), SC_(9.9999999999999999999999999999999999999811577245696126616622972603434532084579339497288807903787588047e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(6.9332300317581641024843874457792499603488322390980738823292005111959963241123458512729383099760958276e-12), SC_(9.9999999999999999999997596516066336334339544138801238497263488765177667844733850569004184922595237450e-01), SC_(9.9999999999999999999999999999999999998722986845854788658326641917969905266950264697864225898673575346e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(6.9332300317581641024843874457792499601824069979359191397087956901173073409437545628617703959000997989e-12), SC_(9.9999999999999999999997596516066336334339544138801238497263604151625674649358430703689798014108895406e-01), SC_(9.9999999999999999999999999999999999991521787387600908626051131763435666724169688057733399935714595456e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.9332300317581641024843874457792499596221700506114994595595999412105130435404578154589258798663572154e-12), SC_(9.9999999999999999999997596516066336334339544138801238497263992576788483667675271176047557916902326723e-01), SC_(9.9999999999999999999999999999999999967280404449567108127940181240895259770771439339751426402209570165e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.9332300317581641024843874457792499572320632530627916279165429560880565712881873113627852304639025548e-12), SC_(9.9999999999999999999997596516066336334339544138801238497265649692811271070825131004312389047002071897e-01), SC_(9.9999999999999999999999999999999999863860780986881610005447014449314825708092929548028242763545908770e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.9332300317581641024843874457792499481881227669505983577701142211061639891422594680654909769817824217e-12), SC_(9.9999999999999999999997596516066336334339544138801238497271920064789645729608874233138425752377506218e-01), SC_(9.9999999999999999999999999999999999472530602497818077664277140257337688866713935863926197867544047191e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.9332300317581641024843874457792499114780793668873020056455730538901213529119081545597892591855127626e-12), SC_(9.9999999999999999999997596516066336334339544138801238497297371982326492172676472296816335410778621441e-01), SC_(9.9999999999999999999999999999999997884091596497284086106903865151310661218339369593493169675651520670e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.9332300317581641024843874457792498926793233400013346793436901821548034268522820480790496538856612183e-12), SC_(9.9999999999999999999997596516066336334339544138801238497310405592311022230083487405995877106256864635e-01), SC_(9.9999999999999999999999999999999997070671764437325064537570464220094213433950153169336825825364863472e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.9332300317581641024843874457792493584897278171770251899809448526620081457563231524456950243595237999e-12), SC_(9.9999999999999999999997596516066336334339544138801238497680771526944181432456951118463208634648887266e-01), SC_(9.9999999999999999999999999999999973956354494884892521051293738115790532916872967699741169390409965008e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.9332300317581641024843874457792468215368531062932680577371413745108409863143111729420882831662152776e-12), SC_(9.9999999999999999999997596516066336334339544138801238499439699312954252063136968093318396074907774790e-01), SC_(9.9999999999999999999999999999999864182719561808099336804571543459674386806778832075457941263831472526e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.9332300317581641024843874457792372706379058451302804516976320921162245507589267659137008612927613214e-12), SC_(9.9999999999999999999997596516066336334339544138801238506061557254098104978529648695076387320359049904e-01), SC_(9.9999999999999999999999999999999450916511596145219885686242917191702960738423502700810308148192619622e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.9332300317581641024843874457792004209101424553108116212929283089237228287080719487982097870858325437e-12), SC_(9.9999999999999999999997596516066336334339544138801238531610321173222794926279051435577350328261716979e-01), SC_(9.9999999999999999999999999999997856433380590958761691827921641987163637848714672848147499001022366131e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.9332300317581641024843874457791862378231114698366429017921229674497030520188373848519044108784934841e-12), SC_(9.9999999999999999999997596516066336334339544138801238541443781667849617374343873910950128464644278283e-01), SC_(9.9999999999999999999999999999997242732971141734671683913531474800215993950788334442318757721342597102e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.9332300317581641024843874457787934105789195005412651166749628785063926832745336557651777992277091506e-12), SC_(9.9999999999999999999997596516066336334339544138801238813799946340305553651089316592350455788699854386e-01), SC_(9.9999999999999999999999999999980245147038210234460495491790619022137983576364211388377737127159921025e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.9332300317581641024843874457765738369845870821884503966811206729874475392007802098355202953448042462e-12), SC_(9.9999999999999999999997596516066336334339544138801240352681376532599087914691690779011099044306468278e-01), SC_(9.9999999999999999999999999999884204474040249680395196934524961794772911650273467266198511346848565877e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.9332300317581641024843874457685195621167675851898313964075958710411405079206626781559934400105418979e-12), SC_(9.9999999999999999999997596516066336334339544138801245936895416292714503361080455908492424034246328749e-01), SC_(9.9999999999999999999999999999535697003600369327022486627648779630001165263542076839087362882982025969e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.9332300317581641024843874457569709765515952058261162377200277430807703163196837441033827872951037475e-12), SC_(9.9999999999999999999997596516066336334339544138801253943795442770911633983040828680081802827365259434e-01), SC_(9.9999999999999999999999999999035991144472376583098681779643797470342560959837732795882332450679405792e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.9332300317581641024843874457101780703532389270245278915844149645018779516329630950458134923948053624e-12), SC_(9.9999999999999999999997596516066336334339544138801286386393695539561309493213604576122607026338375585e-01), SC_(9.9999999999999999999999999997011267920923555724003858062927926698972361832794497495340987154504049437e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.9332300317581641024843874455653255487687285632469722742379284518645436656397408506594701577942223073e-12), SC_(9.9999999999999999999997596516066336334339544138801386815978978102055368796014408224722903932727189050e-01), SC_(9.9999999999999999999999999990743517352097646585686794383861818837729961682167671565383141549694286789e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.9332300317581641024843874440659679153410819209398176853628853546940640478743631013086579139538038004e-12), SC_(9.9999999999999999999997596516066336334339544138802426355116220742885423927622885060420125831684931579e-01), SC_(9.9999999999999999999999999925866499285782378454921467945824537542172122247690165578738203362815500199e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.9332300317581641024843874415835163697820858809662018656994376394568373433987579070000232807272894203e-12), SC_(9.9999999999999999999997596516066336334339544138804147495877026153052879455622757232065967778758652442e-01), SC_(9.9999999999999999999999999818451130077435923837884860839906033843228384260406894583900364326928636375e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(6.9332300317581641024843873960093682296608611968550335447723487861706063611182751387200207824748424525e-12), SC_(9.9999999999999999999997596516066336334339544138835745101132714548461032571387158666740727139881716190e-01), SC_(9.9999999999999999999999997846463415922610832066593222234778599319664522171954160796180405904034918485e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(6.9332300317581641024843872999253738685285128989828248724874748636710181222936220872973415252805807158e-12), SC_(9.9999999999999999999997596516066336334339544138902362344660303037634262389754713138868208537241591098e-01), SC_(9.9999999999999999999999993688920946351604464518175468434185267020480001366138226814835218988809026542e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.9332300317581641024843867488445822440778434303420012299492269064493491516923860045104355874040328984e-12), SC_(9.9999999999999999999997596516066336334339544139284439334101873470555908824828038360280256056031344955e-01), SC_(9.9999999999999999999999969843723725135012135532611302119385683997206661341181678313661649657741259565e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.9332300317581641024843843833518276181054837192775357646956029167233157496204559299253899368291103418e-12), SC_(9.9999999999999999999997596516066336334339544140924489874729787213372848629376138593829189750497316308e-01), SC_(9.9999999999999999999999867489146834248908779346678547903526312625505153362156740461456710280388785631e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.9332300317581641024843741160086156556457267379602465679983183613143966357405591434036587484626541823e-12), SC_(9.9999999999999999999997596516066336334339544148043075105084432761665863013026516843571613561202477491e-01), SC_(9.9999999999999999999999423222484761932777951603898430167753884993548018385713430343664872819604119887e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.9332300317581641024843560481848720979023452807124058100558714595577255556065235301577822640764992046e-12), SC_(9.9999999999999999999997596516066336334339544160569912923819209218395267793456855717281060071500656868e-01), SC_(9.9999999999999999999998641430001570256021353714913216172488055480015311348693512528618809799414485386e-01) }},
      {{ SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(6.9332300317581641024842351666983791319128083148947975988152496030097260416635226499482846867768092825e-12), SC_(9.9999999999999999999997596516066336334339544244379828167479276481720307447815701874367075407225798003e-01), SC_(9.9999999999999999999993410903135769198460227575650367208936665439810640143049673025017654380487916132e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.3351444949627477853936910698851542541780105962091672416282294316747308771701424136018110547055031726e-11), SC_(9.9999999999999999999991086945887853345767574383752988357399184624906544511770568779913561016111111296e-01), SC_(9.9999999999999999999999999999999999999999999975720048632921041975215755660018120344898039111872115823e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.3351444949627477853936910698851542541780105961480051329731397176907953516705339820345479663002658732e-11), SC_(9.9999999999999999999991086945887853345767574383752988357399184624907361114297280344527154911379626089e-01), SC_(9.9999999999999999999999999999999999999999999961977242018541177287631366233257075649754141156361061345e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.3351444949627477853936910698851542541780105944104263279919129476975521039127133037842556238110449523e-11), SC_(9.9999999999999999999991086945887853345767574383752988357399184624930560302057626692944802733511615332e-01), SC_(9.9999999999999999999999999999999999999999999571552352831612969372856275657721243195904776810541850156e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.3351444949627477853936910698851542541780105892460739589795186415661216090109343934511225050481714107e-11), SC_(9.9999999999999999999991086945887853345767574383752988357399184624999511868412973925763285624510104479e-01), SC_(9.9999999999999999999999999999999999999999998411149327878912344745083350779843700879425428035667683674e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.3351444949627477853936910698851542541780105856485297011378997022351246146241993788224789206366239972e-11), SC_(9.9999999999999999999991086945887853345767574383752988357399184625047544282525394741943156998095863941e-01), SC_(9.9999999999999999999999999999999999999999997602799908453265469087129188601051322960041979280935789745e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.3351444949627477853936910698851542541780104660704539080169380856103801864381006176364584794119887051e-11), SC_(9.9999999999999999999991086945887853345767574383752988357399184626644084378659631368242179408725826471e-01), SC_(9.9999999999999999999999999999999999999999970734230346671712975423341453810358018215721439563932566501e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.3351444949627477853936910698851542541780101042839984094870959484194285690577811828307607022573872457e-11), SC_(9.9999999999999999999991086945887853345767574383752988357399184631474456322769103894650634589268222345e-01), SC_(9.9999999999999999999999999999999999999999889442701932297924838485947509863202388385148187531910325360e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.3351444949627477853936910698851542541780097948063965329222820489518054104172228928439058259658454729e-11), SC_(9.9999999999999999999991086945887853345767574383752988357399184635606429487366788442127223401976803518e-01), SC_(9.9999999999999999999999999999999999999999819904699930829245792105841543659042676740680510360596059415e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.3351444949627477853936910698851542541780048664414516271096477467049001276401940295471834708039658105e-11), SC_(9.9999999999999999999991086945887853345767574383752988357399184701407222740950603678175607288893728880e-01), SC_(9.9999999999999999999999999999999999999998712526817574361102758231550388503328390584697078757632070655e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.3351444949627477853936910698851542541779958765754051610133717623515012393198821641502936155985462654e-11), SC_(9.9999999999999999999991086945887853345767574383752988357399184821434924364867905955942156622229742612e-01), SC_(9.9999999999999999999999999999999999999996692550834364335987370603103444201329523419460616183907348649e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.3351444949627477853936910698851542541779691510607134934937659849854005828223224076280773810591959574e-11), SC_(9.9999999999999999999991086945887853345767574383752988357399185178259162521127171587975559241801856343e-01), SC_(9.9999999999999999999999999999999999999990687467161586313150643358524983712472114419844961890781987768e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.3351444949627477853936910698851542541776811398176248068412284335430935297233874895310791983768896573e-11), SC_(9.9999999999999999999991086945887853345767574383752988357399189023625419493504414377518540398607731970e-01), SC_(9.9999999999999999999999999999999999999925972843948451049619956629688939388055414187962078251341647779e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.3351444949627477853936910698851542541771107796692053590542410611755363739528867552974421949229623605e-11), SC_(9.9999999999999999999991086945887853345767574383752988357399196638757542577119265221350970925780622475e-01), SC_(9.9999999999999999999999999999999999999797815895265073924770364454282644086788303661847693596864183045e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.3351444949627477853936910698851542541749008448429697813573515159323015477434956580800047114020885192e-11), SC_(9.9999999999999999999991086945887853345767574383752988357399226144580717326000952563692637529851071280e-01), SC_(9.9999999999999999999999999999999999999301255073292639173899381376274735753083083175724973328257240774e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.3351444949627477853936910698851542541569346198332933179896534654029135347139743498183305940282368810e-11), SC_(9.9999999999999999999991086945887853345767574383752988357399466019644886641702219840179217681530569345e-01), SC_(9.9999999999999999999999999999999999995264338077987705449428935553641277023744338179257802995085533160e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.3351444949627477853936910698851542540380851702833006349151849823375222381717176205112668786229194601e-11), SC_(9.9999999999999999999991086945887853345767574383752988357401052831527846897231186764177479860130034081e-01), SC_(9.9999999999999999999999999999999999968559487030391827248548234921078842764826357589746127877164151367e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.3351444949627477853936910698851542536380025124958306161907975077350488246795773877107540129888658048e-11), SC_(9.9999999999999999999991086945887853345767574383752988357406394513108596952335679755995506799916874685e-01), SC_(9.9999999999999999999999999999999999878663001826676218342500795648332479612407408024003618254929215036e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.3351444949627477853936910698851542519311527866325167160953957115243846127326059485263116955817900562e-11), SC_(9.9999999999999999999991086945887853345767574383752988357429183423260747739774489546660532710054731272e-01), SC_(9.9999999999999999999999999999999999495142776344803450875373943734272723799442422228902810140693796875e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.3351444949627477853936910698851542454725931292663523076429013496222450317168958703430551426740389972e-11), SC_(9.9999999999999999999991086945887853345767574383752988357515414526979956989362561491360156102127893377e-01), SC_(9.9999999999999999999999999999999998043938128068955292934189943686661145295433809243786105154668394454e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.3351444949627477853936910698851542192568074672654144490566152849388104319255961353268330042467189230e-11), SC_(9.9999999999999999999991086945887853345767574383752988357865433146057395857294339816305083475097556543e-01), SC_(9.9999999999999999999999999999999992153387908019763240112462203088010156792553911056152969711541931435e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.3351444949627477853936910698851542058320301292947075039637927002572019345601137082492539996297761082e-11), SC_(9.9999999999999999999991086945887853345767574383752988358044673321646318268919985310601768322552048825e-01), SC_(9.9999999999999999999999999999999989136910503075227594798607203130048108639933075350532391128786765516e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.3351444949627477853936910698851538243505977463193297717199509491864735185054872269750732419766075826e-11), SC_(9.9999999999999999999991086945887853345767574383752988363138001665412651060043421496280958506670753721e-01), SC_(9.9999999999999999999999999999999903420023569361167539361186766887212928439452389215543614649851276689e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.3351444949627477853936910698851520126335133175122252808910132600216083682881047971236465840558356853e-11), SC_(9.9999999999999999999991086945887853345767574383752988387327042582463466573473195448490641079780063468e-01), SC_(9.9999999999999999999999999999999496336649912634306267773728249425346880747177579347253333299880617908e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.3351444949627477853936910698851451920390249874513171513220500231040474589527985465130408016972943409e-11), SC_(9.9999999999999999999991086945887853345767574383752988478391834417134869722301466797056971985347108630e-01), SC_(9.9999999999999999999999999999997963784664551597238970471338183473547684519934890048620907594289551787e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.3351444949627477853936910698851188765004073881313451506555833583491352993743245835339980392137887890e-11), SC_(9.9999999999999999999991086945887853345767574383752988829742299589808170565301021562280795812051419224e-01), SC_(9.9999999999999999999999999999992050820475982578720482347830036618010964428497131549262802477293529736e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.3351444949627477853936910698851087479160966112243711457686221474159686334755890492006874811281007730e-11), SC_(9.9999999999999999999991086945887853345767574383752988964973535432806613795978854470095657823502250037e-01), SC_(9.9999999999999999999999999999989774980441666403695868588663614384634610071885751879404628057535087509e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.3351444949627477853936910698848282177428221929950240255101170837050304055370951500100992578680497581e-11), SC_(9.9999999999999999999991086945887853345767574383752992710456700615659144017226685590127895503475675454e-01), SC_(9.9999999999999999999999999999926741314572659759248359793738098545553867518378792010269699006801429605e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.3351444949627477853936910698832431510901917749600327247501371585315281136807834016020393597606199573e-11), SC_(9.9999999999999999999991086945887853345767574383753013873386854700985802601718156093641002875855647270e-01), SC_(9.9999999999999999999999999999570585110069571112007279950473897540123580519801438001918056773178946807e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.3351444949627477853936910698774913424830346175296948045385938009975490331561752369409165084457771975e-11), SC_(9.9999999999999999999991086945887853345767574383753090668342833953273146166431703139069023925079650204e-01), SC_(9.9999999999999999999999999998278183734295414141447126916670882171044059662607992004461026722621779036e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.3351444949627477853936910698692441377446355601631029850029751553963783444916961960056387537570059984e-11), SC_(9.9999999999999999999991086945887853345767574383753200780442886995172299948797865421933943698830617252e-01), SC_(9.9999999999999999999999999996425079871114860464538459291971007775143724686973009304098698598099803446e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.3351444949627477853936910698358278656354037792282677432799951491231957866427912559158299088865020632e-11), SC_(9.9999999999999999999991086945887853345767574383753646935960375175380842341652421926049143470135405118e-01), SC_(9.9999999999999999999999999988916617925167024222121354704470144899434033625354667513166000306262152112e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.3351444949627477853936910697323841672154411224031084155746506647274180307681715129715743157652364309e-11), SC_(9.9999999999999999999991086945887853345767574383755028058805215173705967213802578933390795794662411060e-01), SC_(9.9999999999999999999999999965673358755039030003559587157621389982948345376986563134585881395239392340e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.3351444949627477853936910686616461699796115636747031944647584795720537696539013719674806207866626024e-11), SC_(9.9999999999999999999991086945887853345767574383769323958230783730610311996900137243121743665918411031e-01), SC_(9.9999999999999999999999999725084118876765518031024208529656699806160284637234236891386698770472695867e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.3351444949627477853936910668888501826404796020575576611209388990544476182971060968647065685774435503e-11), SC_(9.9999999999999999999991086945887853345767574383792993346262662642210895331364635780563945913049088999e-01), SC_(9.9999999999999999999999999326746112609826926204326193458099546054362350063305591243609867835236828502e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.3351444949627477853936910343429311721596400950183551345092487833633705916657805523685395914485519064e-11), SC_(9.9999999999999999999991086945887853345767574384227528392266131968323573287352370926052828479609362600e-01), SC_(9.9999999999999999999999992013847965644337993654785105983506111444225016679942530962686387293550683308e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.3351444949627477853936909657263573841807024025938054847515890655922011379569452200412328096496701682e-11), SC_(9.9999999999999999999991086945887853345767574385143658799828384533360547066740121798207029764459332032e-01), SC_(9.9999999999999999999999976596061940193940595654557899025502587418946367803785456531646694434309656337e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3351444949627477853936905721823956342610472284719935213439417585848337745666968391830074067091919995e-11), SC_(9.9999999999999999999991086945887853345767574390398039340390738635140033846458702414619063094307320216e-01), SC_(9.9999999999999999999999888168787611155862696380426418116169668272087173639894945368463550111646951143e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3351444949627477853936888829103246515352654776051207667767015933285089545555623863822720303150223263e-11), SC_(9.9999999999999999999991086945887853345767574412952262401059803053967510775616318432273676833758619676e-01), SC_(9.9999999999999999999999508598169444499990253546788746763385897243425787497149752940545894053887572432e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3351444949627477853936815506806666897578270716446052505424386111340260273682415091627016124915793466e-11), SC_(9.9999999999999999999991086945887853345767574510848123037362385799393652137150979563643979396872834433e-01), SC_(9.9999999999999999999997861084431652466651683002238329372494811154446818895097461250499323338109729517e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3351444949627477853936686478848438140894489591460110717703421384113994847597033270916267697275150460e-11), SC_(9.9999999999999999999991086945887853345767574683119091162770245654080247727945286235966528505843443457e-01), SC_(9.9999999999999999999994961893548967741359548764239694165528138749231530016520670604061027719926200555e-01) }},
      {{ SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.3351444949627477853935823226493798267668516878426794044224298897536252643864274254323502986653174412e-11), SC_(9.9999999999999999999991086945887853345767575835685720223826628835039125279198146957899333451998170222e-01), SC_(9.9999999999999999999975565063665084071039132765921683485150420681758929784278185998284297713712228484e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.6399812063916385795891248302497936302331371247590138440529726223454421842032405514753895233112793282e-11), SC_(9.9999999999999999999986552308213411128718525192676839109840985692183330599981881408781554011357133426e-01), SC_(9.9999999999999999999999999999999999999999999963367292684459290855254781806549229348949653306382518023e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.6399812063916385795891248302497936302331371246456657412680216989333514158435218329125530856584912497e-11), SC_(9.9999999999999999999986552308213411128718525192676839109840985692185189487565356081421574206907788387e-01), SC_(9.9999999999999999999999999999999999999999999942632646029389763516198658740154922341662018258905984793e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.6399812063916385795891248302497936302331371214255141586169445284439963376055672148439291709758469509e-11), SC_(9.9999999999999999999986552308213411128718525192676839109840985692237999368338156659493074711835273749e-01), SC_(9.9999999999999999999999999999999999999999999353573776921456234944377210213199611290659870298186579087e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.6399812063916385795891248302497936302331371118547266888522130089206648845451612434575397555702760357e-11), SC_(9.9999999999999999999986552308213411128718525192676839109840985692394958484145984084931717210429722187e-01), SC_(9.9999999999999999999999999999999999999999997602799908453265469087201658160040017320615438428196131263e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.6399812063916385795891248302497936302331371051876116191151904318529690564062443079135322678190066254e-11), SC_(9.9999999999999999999986552308213411128718525192676839109840985692504297918298176043578309556133436219e-01), SC_(9.9999999999999999999999999999999999999999996383191712258204224277224321796632798684687265319893939127e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.6399812063916385795891248302497936302331368835806669949551353432400232084338447374576342868360511383e-11), SC_(9.9999999999999999999986552308213411128718525192676839109840985696138610162193126572588216112005760187e-01), SC_(9.9999999999999999999999999999999999999999955844871438744261067699711205841969396266454299741962022249e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6399812063916385795891248302497936302331362131033200593717463366140800672964878645829234472784328281e-11), SC_(9.9999999999999999999986552308213411128718525192676839109840985707134312645049959036761597704483491395e-01), SC_(9.9999999999999999999999999999999999999999833195170761234995670893967239023324630444614656147540174699e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6399812063916385795891248302497936302331356395668642618188477988820099286897812697986678897931700124e-11), SC_(9.9999999999999999999986552308213411128718525192676839109840985716540202731934514009601262308744550934e-01), SC_(9.9999999999999999999999999999999999999999728278763141026842684684122355009437729126250587248769374879e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6399812063916385795891248302497936302331265061208693378616686428152609263378966649455924189586187223e-11), SC_(9.9999999999999999999986552308213411128718525192676839109840985866327000544617223901328645508672806637e-01), SC_(9.9999999999999999999999999999999999999998057507300761933828003652154796019947118973590218915377804913e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6399812063916385795891248302497936302331098457361464350341243744524729255883523536919828103096979085e-11), SC_(9.9999999999999999999986552308213411128718525192676839109840986139554178912767267352818052747563910156e-01), SC_(9.9999999999999999999999999999999999999995009841024227015676217853322785238027566978182404420576453630e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6399812063916385795891248302497936302330603169273322255435328312301828565301198812059416866473420598e-11), SC_(9.9999999999999999999986552308213411128718525192676839109840986951817335215448293849957664204569929539e-01), SC_(9.9999999999999999999999999999999999999985949589244296250396672423568347251281941012526661794291758373e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6399812063916385795891248302497936302325265627991196874510770047841452375734112746023469955004880744e-11), SC_(9.9999999999999999999986552308213411128718525192676839109840995705284726240603831947492757425722919665e-01), SC_(9.9999999999999999999999999999999999999888310520064913104849248000309622735086815990283708457369963360e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6399812063916385795891248302497936302314695482169040442070291246176700077444545446815402533541152094e-11), SC_(9.9999999999999999999986552308213411128718525192676839109841013040125223396248322183039544834852596434e-01), SC_(9.9999999999999999999999999999999999999694951978254302679751334265375826630436321444809193019693948329e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6399812063916385795891248302497936302273740072792168379735372167497244801601051970918260998362479825e-11), SC_(9.9999999999999999999986552308213411128718525192676839109841080206226901542319972769136954923237371228e-01), SC_(9.9999999999999999999999999999999999998945759074995660686766707775996710591570728012271256671141680480e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.6399812063916385795891248302497936301940782697084537690116125169606754719455648265508382705550311928e-11), SC_(9.9999999999999999999986552308213411128718525192676839109841626250065591536555423085999843141943771256e-01), SC_(9.9999999999999999999999999999999999992855005575931753341247367346751282102829100299117622184272220412e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.6399812063916385795891248302497936299738216448184228284595531265664383333396246332663621580645816123e-11), SC_(9.9999999999999999999986552308213411128718525192676839109845238417319620572065232642357121677875422722e-01), SC_(9.9999999999999999999999999999999999952563697840524905249392883225064826569017830189514037150979503553e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6399812063916385795891248302497936292323722210730115888597568303758644260213484322514865737879093061e-11), SC_(9.9999999999999999999986552308213411128718525192676839109857398048523944419673610846234161081781123574e-01), SC_(9.9999999999999999999999999999999999816931151408462662428030955931175971314256129629315123955899280643e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6399812063916385795891248302497936260691690153653481586193792690711914566096705548817543168133996367e-11), SC_(9.9999999999999999999986552308213411128718525192676839109909273986617527943335646090447642447121450106e-01), SC_(9.9999999999999999999999999999999999238289787706346708240472146204327462934319511883312224914798208235e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6399812063916385795891248302497936140999040573142773271157909775008392239280644637782636943002722409e-11), SC_(9.9999999999999999999986552308213411128718525192676839110105567682472785548123049334381278365326617467e-01), SC_(9.9999999999999999999999999999999997048765009360917989172046096081548904785174800983408117527865093485e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6399812063916385795891248302497935655157457745791132895297318285555626775200725700557501403250351590e-11), SC_(9.9999999999999999999986552308213411128718525192676839110902338747593208888496674766598682199241006499e-01), SC_(9.9999999999999999999999999999999988161317136168716449975127071092307667806796003428373600644794286318e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.6399812063916385795891248302497935406364034001929614629564184773978133392806129945548557127366036740e-11), SC_(9.9999999999999999999986552308213411128718525192676839111310355286806973039405318856692531487916123264e-01), SC_(9.9999999999999999999999999999999983610165767344164755453545532025149015659264045057475870577786821204e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.6399812063916385795891248302497928336595257366154044177071859208766512751084807863076365580570506795e-11), SC_(9.9999999999999999999986552308213411128718525192676839122904643214024051083888074225999781520644579109e-01), SC_(9.9999999999999999999999999999999854283645150848750919510936519088202028895580126215880146486494935966e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.6399812063916385795891248302497894761118737885643856411627244986660423559366417695853071347009913181e-11), SC_(9.9999999999999999999986552308213411128718525192676839177967793701615832608239698985549798989026781142e-01), SC_(9.9999999999999999999999999999999240091060712247694006356172463577283579901833875653733521887336091146e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6399812063916385795891248302497768359092693060833951959724395619931615339013009975265467857412214191e-11), SC_(9.9999999999999999999986552308213411128718525192676839385264740864954944351474103035797371574250761956e-01), SC_(9.9999999999999999999999999999996927832379597108993069801047019523803072729583747592141873171170283592e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6399812063916385795891248302497280668847595408749116941024632921565955883533974200395687895016649968e-11), SC_(9.9999999999999999999986552308213411128718525192676840185067577365636313077246547924320983176758483966e-01), SC_(9.9999999999999999999999999999988006567126124654935542276924249176344040316437026397164979358167116403e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6399812063916385795891248302497092961811201652131025925358525336358096724640095488997148592246531512e-11), SC_(9.9999999999999999999986552308213411128718525192676840492903589358868499596808236963593577204935850126e-01), SC_(9.9999999999999999999999999999984572862477641062903774759379850519330432176746529729901946180951412927e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6399812063916385795891248302491894062751997492549923070317745621497836469572675346515581001777402796e-11), SC_(9.9999999999999999999986552308213411128718525192676849019000340380860972605424274967223186101928311837e-01), SC_(9.9999999999999999999999999999889469960585679490009187382052287459192536423634413789040093724111060452e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.6399812063916385795891248302462518964048888988896342429776711980088285306787545444571921364663538780e-11), SC_(9.9999999999999999999986552308213411128718525192676897193610149378202674642245031434039277542745158527e-01), SC_(9.9999999999999999999999999999352114436230477851610273878580820516331398719371720871759647322345815352e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.6399812063916385795891248302355924111853720083950764875413521774235820088286268368120577917732641957e-11), SC_(9.9999999999999999999986552308213411128718525192677072007164447549707286242050192399609411826426340996e-01), SC_(9.9999999999999999999999999997402186258156344454251246473879181182349955551655376934204761228303617291e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.6399812063916385795891248302203083565487305822095216008733679654432245565506796930548476948405972822e-11), SC_(9.9999999999999999999986552308213411128718525192677322662788063098940822306841526151918617822453628602e-01), SC_(9.9999999999999999999999999994606290565497140140226742001278030582454302918891720489728430282245718358e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6399812063916385795891248301583799644606351222607070462816865488033529299799312817512235785074288311e-11), SC_(9.9999999999999999999986552308213411128718525192678338276779728390922458460355496712883482293758668332e-01), SC_(9.9999999999999999999999999983277796340062728303855594109535617551100052467271277381353922240730564616e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6399812063916385795891248299666739029989091188670400795803018169869516594581671437432658556112651906e-11), SC_(9.9999999999999999999986552308213411128718525192681482220159214301157424901948815724597310710271399265e-01), SC_(9.9999999999999999999999999948209212496313734357558385087272215191727840173038308433273479465008427987e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6399812063916385795891248279823387772945796246299641737991688665436963932996312113526076985712338445e-11), SC_(9.9999999999999999999986552308213411128718525192714024943292593201891828686820981169729240062138165173e-01), SC_(9.9999999999999999999999999585216920029068800303428248597085582853376158142187331348888792667037801905e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6399812063916385795891248246969212825702107633877011692507624836267530427648869990347292637098039765e-11), SC_(9.9999999999999999999986552308213411128718525192767905172757575855128236392157072759523369906695439720e-01), SC_(9.9999999999999999999999998984219027750822352212838590247152289445299458126177886138695553722607983596e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.6399812063916385795891247643815028911920021635106594916944542561197168710446117282767206055045691123e-11), SC_(9.9999999999999999999986552308213411128718525193757066698932664448407059993520982132206164970695809272e-01), SC_(9.9999999999999999999999987950784347590015744873877691669275700816091585182623747007232474420073216830e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.6399812063916385795891246372184826897329643789840688129976891569298740258971050078369775387067472630e-11), SC_(9.9999999999999999999986552308213411128718525195842516331716595451941641176699611225357709828248148795e-01), SC_(9.9999999999999999999999964688989693019141889292636147081581768962250958441318548465566962261567129507e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6399812063916385795891239078868358954624358445231868344795530714474144326345625573990812035374933614e-11), SC_(9.9999999999999999999986552308213411128718525207803418271409277706704325249838124448577973994364250812e-01), SC_(9.9999999999999999999999831273135178628833197142382302679494402693599423911872386403757205829447638057e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6399812063916385795891207772592538203811317748885658240995330320400733096251900604919992033746530663e-11), SC_(9.9999999999999999999986552308213411128718525259145122259553581297337084142499570295799864602237547753e-01), SC_(9.9999999999999999999999258590795306595023391592338258384602311336509449189441252082339193530822761062e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6399812063916385795891071888735818957735209343119777966921636801684798400083501721497003279053426365e-11), SC_(9.9999999999999999999986552308213411128718525481992093531131325239014341846760814772749584037684142549e-01), SC_(9.9999999999999999999996772882004443852159052514112724204070584136949938063663686248859325446303313445e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6399812063916385795890832768885423995670119521000163923321735605092785065798147847682279906852057683e-11), SC_(9.9999999999999999999986552308213411128718525874144154254049347629563951182925427718555299417796096531e-01), SC_(9.9999999999999999999992398688273509255745717690899327158204278623274886619116277767394080981453352693e-01) }},
      {{ SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.6399812063916385795889232954575965444009567813391242633961117172793285529833972540960692729049181066e-11), SC_(9.9999999999999999999986552308213411128718528497809555482491110677318160732054434196223692064776110234e-01), SC_(9.9999999999999999999963133457003355812163778098258675230100700621631375312868672036496332083695666915e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(5.7301594025283009159434660863878796746423410907937194349056143358495375496145539487211138516077148504e-11), SC_(9.9999999999999999999835826366108082527372683086846903557771330751445283111893288868275440610957811023e-01), SC_(9.9999999999999999999999999999999999999999999552776433700754495455125443615976257775629686798040804759e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(5.7301594025283009159434660863878796746423410859587052570428253864087455238544128546929829548526530372e-11), SC_(9.9999999999999999999835826366108082527372683086846903557771330751722337131419669896109339591801467854e-01), SC_(9.9999999999999999999999999999999999999999999299641372096912362071752135240405729596096907297709280236e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(5.7301594025283009159434660863878796746423409485988538396409322798483594702132575220568395519307387939e-11), SC_(9.9999999999999999999835826366108082527372683086846903557771330759593275572712828091270539722667398658e-01), SC_(9.9999999999999999999999999999999999999999992108226172191913856245613186009174077100963817292592547456e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(5.7301594025283009159434660863878796746423405403441766756234916468065055558143534088239592503940252234e-11), SC_(9.9999999999999999999835826366108082527372683086846903557771330782986919342488333625502506643173773061e-01), SC_(9.9999999999999999999999999999999999999999970734230346671712975453633589570871166709358874800230424151e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(5.7301594025283009159434660863878796746423402559495101960268155412138879820470570559594391074710200225e-11), SC_(9.9999999999999999999835826366108082527372683086846903557771330799283187064057944600979438399708506513e-01), SC_(9.9999999999999999999999999999999999999999955844871438744261067744080028183150555513650047848891865574e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(5.7301594025283009159434660863878796746423308030103533447325090615763868494088232407703791143390496197e-11), SC_(9.9999999999999999999835826366108082527372683086846903557771331340951668975651876612526306839026846286e-01), SC_(9.9999999999999999999999999999999999999999460940358694452931393772531388406591893708228396090026309906e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(5.7301594025283009159434660863878796746423022029067899017739706542389820467050624141903556475694219565e-11), SC_(9.9999999999999999999835826366108082527372683086846903557771332979783192449110209297175694718016810778e-01), SC_(9.9999999999999999999999999999999999999997963594392149936493887849005987761165351952618331861347636953e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(5.7301594025283009159434660863878796746422777379459553696754605765180508034044137252046858593207293992e-11), SC_(9.9999999999999999999835826366108082527372683086846903557771334381664446033917526956640978483166006754e-01), SC_(9.9999999999999999999999999999999999999996682742022297668626236158890008293422049239493160991097591332e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(5.7301594025283009159434660863878796746418881386514529781551107797485474022585395781869665702153308331e-11), SC_(9.9999999999999999999835826366108082527372683086846903557771356706325052146630986533331375972558550540e-01), SC_(9.9999999999999999999999999999999999999976285440631493960737085320291738208193509804247227687528112418e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(5.7301594025283009159434660863878796746411774677680001434760273358812240195196865337094848254772856728e-11), SC_(9.9999999999999999999835826366108082527372683086846903557771397428899501350180372241521269329155746669e-01), SC_(9.9999999999999999999999999999999999999939078576029825069314380886509463246901349750568165375916314707e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(5.7301594025283009159434660863878796746390647505107585622010141353157650403626783874721104732071085021e-11), SC_(9.9999999999999999999835826366108082527372683086846903557771518490966066016680277383610665739783578269e-01), SC_(9.9999999999999999999999999999999999999828468184128193497364285476304028779129014844607298234243179465e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.7301594025283009159434660863878796746162967578051669184060193898398822292431341095235062512294304979e-11), SC_(9.9999999999999999999835826366108082527372683086846903557772823133240852433950930348702650836729507022e-01), SC_(9.9999999999999999999999999999999999998636459841626632833215228738764440129414357164598883828484639651e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.7301594025283009159434660863878796745712083940332866016169346514241688965440469716982406207572164283e-11), SC_(9.9999999999999999999835826366108082527372683086846903557775406768356972997994402479645779105985479144e-01), SC_(9.9999999999999999999999999999999999996275878192607264490449877787862274498758551612125115653850535834e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.7301594025283009159434660863878796743965076446320872005875348428512077712563520547619110951499203228e-11), SC_(9.9999999999999999999835826366108082527372683086846903557785417399775073229832519388158145892808630365e-01), SC_(9.9999999999999999999999999999999999987129496540949369039688212965152263891769791399937899221713687499e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(5.7301594025283009159434660863878796729762336456709684110046573528668688069134895646351641364985105833e-11), SC_(9.9999999999999999999835826366108082527372683086846903557866801363868208481023743334817468462464047252e-01), SC_(9.9999999999999999999999999999999999912771669863329078829515320504472842462076771658482721752459148944e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(5.7301594025283009159434660863878796635808941742025775981181957599491137065184382462871618743978499516e-11), SC_(9.9999999999999999999835826366108082527372683086846903558405169291992007249131110513775047278881445902e-01), SC_(9.9999999999999999999999999999999999420882763562245365255276928739018857988704025899373562870383123546e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.7301594025283009159434660863878796319533822185880633228779347167589391587550451346743875356711457656e-11), SC_(9.9999999999999999999835826366108082527372683086846903560217476142102414841105038542102245663169958746e-01), SC_(9.9999999999999999999999999999999997765038149100406689846982527094699649242559484660246796242090607065e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.7301594025283009159434660863878794970227396115892777364510767287453800845569583172373100768922888195e-11), SC_(9.9999999999999999999835826366108082527372683086846903567949217046339213484205370752395435402714567106e-01), SC_(9.9999999999999999999999999999999990700803118528809715123984057054350426602702423785880312854593333912e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.7301594025283009159434660863878789864578130810614286056179823119561527123024475637056829494808875562e-11), SC_(9.9999999999999999999835826366108082527372683086846903597205401189939966614799072845788013537019398942e-01), SC_(9.9999999999999999999999999999999963970398744162566277620114958155332191354664278821373108433115563256e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.7301594025283009159434660863878769140358814830814427116134898805719618986988798057135754883460603252e-11), SC_(9.9999999999999999999835826366108082527372683086846903715958481363460249665623006748713226970075887385e-01), SC_(9.9999999999999999999999999999999855469651067741652744610241483134713262570384177140527376007261069761e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.7301594025283009159434660863878758527744208984009514906691674495840920597222384513968767307244947974e-11), SC_(9.9999999999999999999835826366108082527372683086846903776770454732562497021903443013666957474991294451e-01), SC_(9.9999999999999999999999999999999799907769484669637109500859098550521010166819666251318633725177535737e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.7301594025283009159434660863878456957347974844344552780316250690353439789906372562256905950107991900e-11), SC_(9.9999999999999999999835826366108082527372683086846905504816896237803208140528844441671849026912294295e-01), SC_(9.9999999999999999999999999999998221049093575521261163214872716091765257805344320158582114588242226966e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.7301594025283009159434660863877024750711855119004933483034915368334140430150992420847076554436021248e-11), SC_(9.9999999999999999999835826366108082527372683086846913711589218562676238313522954413139900392118132447e-01), SC_(9.9999999999999999999999999999990722793623643233859873954552918440865396466004108386451758865512254467e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.7301594025283009159434660863871632904064039397666005193185301048139516003323037994956820068715541265e-11), SC_(9.9999999999999999999835826366108082527372683086846944607729984534632154703967746946399500996641841338e-01), SC_(9.9999999999999999999999999999962494015317214132756710022031024351465363321401356546564108889903631350e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.7301594025283009159434660863850829827598558464845271625774590924489768598862059919348838706240257979e-11), SC_(9.9999999999999999999835826366108082527372683086847063812674194725412160512042533042146680321162816313e-01), SC_(9.9999999999999999999999999999853580414468856994936283169023168053728974969024856087548541795917300549e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.7301594025283009159434660863842822934144238415014532502488211131753239012581964582472490455517572188e-11), SC_(9.9999999999999999999835826366108082527372683086847109693450007039752361084688038508879002606882869618e-01), SC_(9.9999999999999999999999999999811660672493857874861049763862966004637902038318626796609201694498317973e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.7301594025283009159434660863621056975624225149614726042593685222866690752533450154599926883138559169e-11), SC_(9.9999999999999999999835826366108082527372683086848380447742381194929269796921581623202099719205998205e-01), SC_(9.9999999999999999999999999998650614654705081483794042866491404789148175503289147266669964657635848030e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.7301594025283009159434660862368023045492088493632684482976508901080905222537128004277487015055833775e-11), SC_(9.9999999999999999999835826366108082527372683086855560531898814847863902968596975387816457339689680830e-01), SC_(9.9999999999999999999999999992090410083890187843257948148951519911682012989243661865470698722740997567e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.7301594025283009159434660857821077759353100601240385378429753640676913031981855758366980184568766813e-11), SC_(9.9999999999999999999835826366108082527372683086881615253182965904973713693359160225741079285782423104e-01), SC_(9.9999999999999999999999999968285076060550001363226100937756125381382481915833401310531901402435113742e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.7301594025283009159434660851301460840524335330602902655032928395966219237797740540810809557260883105e-11), SC_(9.9999999999999999999835826366108082527372683086918973697371275144707187227109513455986632612468139940e-01), SC_(9.9999999999999999999999999934151905615315261118738053413734637676484540933040071776897955404687091951e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.7301594025283009159434660824885080998131285018829456226490781863272435341880985550773149772082563623e-11), SC_(9.9999999999999999999835826366108082527372683087070343764705922757797550144903808658849462111795094521e-01), SC_(9.9999999999999999999999999795850099399920463196937588498215060414191071638923216700052034118664876860e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.7301594025283009159434660743110309089664554051290332978897836125302565303352049737729206520828524108e-11), SC_(9.9999999999999999999835826366108082527372683087538926242846830566556479291247711374750657485073558572e-01), SC_(9.9999999999999999999999999367721842414335583175999455018325425348693710996229262937640590871641570401e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.7301594025283009159434659896665751952763491589253628044760277675118046298697273624260974890969740118e-11), SC_(9.9999999999999999999835826366108082527372683092389188480643747825605857335047876005228194846867025258e-01), SC_(9.9999999999999999999999994936198226700816923076563675203174614312810029348537048422521023029299997146e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.7301594025283009159434658495227194368030482818903640480892108122353220561179835180416021636779122600e-11), SC_(9.9999999999999999999835826366108082527372683100419654808453605361094714839557545685890517786437268178e-01), SC_(9.9999999999999999999999987599027691969895601805028118312034717887357233050577182368542521473402030823e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.7301594025283009159434632766882749174684712780115138272799371789208152762037413626595987064384520232e-11), SC_(9.9999999999999999999835826366108082527372683247847169642565037269466038962269409144765722297110631728e-01), SC_(9.9999999999999999999999852899400834252956149813238802402629935897085461192080966356494518934537279687e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.7301594025283009159434578523804085529198720788895589075002009119029166019687595317763129254935604932e-11), SC_(9.9999999999999999999835826366108082527372683558668656869135482563441202397320453300029812982462707249e-01), SC_(9.9999999999999999999999568912124809896759414320174711536592270048808091340950697101848213974115797479e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.7301594025283009159434267417683561869240590309037752976047846710867343177507023737678392436722060891e-11), SC_(9.9999999999999999999835826366108082527372685341356318571888403526923913673562114935780743080419580398e-01), SC_(9.9999999999999999999997940129579669573727009759026368793507774538566471083014708917647329997282010824e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.7301594025283009159432932006823297255257348774274139464563220213838924185342488675250292965541699437e-11), SC_(9.9999999999999999999835826366108082527372692993473415755573208150143395193017820451099540868389755044e-01), SC_(9.9999999999999999999990948644178711645653625839887211661334743029881081715273173310819350380863088962e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.7301594025283009159427135700068814377040213555499976694115270372897088905138815490188482804899696982e-11), SC_(9.9999999999999999999835826366108082527372726207235064893937639622964804659584591451473188144714110958e-01), SC_(9.9999999999999999999960602332598310978413909555566363051822421932836975568635044654928472029836499768e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.7301594025283009159416935724608602520627081089519241733036935972976790945680503721674239433123538530e-11), SC_(9.9999999999999999999835826366108082527372784654720353784839955521839518146344959405388943450460503069e-01), SC_(9.9999999999999999999907200805291524266338915777985381357284230595153931771635737382921556431200365249e-01) }},
      {{ SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(5.7301594025283009159348693516065815628891852979624681265466716857587853638799652527661943209947984098e-11), SC_(9.9999999999999999999835826366108082527373175693453284532288193942801300591666830996975802932424992344e-01), SC_(9.9999999999999999999549921694455567826997380012458061044321175692384716032138596587603055574762991812e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.1137313293829720350890678949490938814945006083040885808079399998857879998610139848504699487446584614e-10), SC_(9.9999999999999999999379801262975418925815160757789947731174935653993142319899331634129835752087383294e-01), SC_(9.9999999999999999999999999999999999999999998310523532852882161715632525718785218207145644173748711594e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.1137313293829720350890678949490938814945006047540019467434418784846419018924252935996176340338746778e-10), SC_(9.9999999999999999999379801262975418925815160757789947731174935657946985026280705701610639130619732558e-01), SC_(9.9999999999999999999999999999999999999999997354255210214069681285901749626740356100110136656994295998e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.1137313293829720350890678949490938814945005038981709945467174997722742999410689813434966081023819532e-10), SC_(9.9999999999999999999379801262975418925815160757789947731174935770273283708695061844419093706355767190e-01), SC_(9.9999999999999999999999999999999999999999970187245997658451154483294429921108482337682175493892881654e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.1137313293829720350890678949490938814945002041390763200935701651710789666147429514349074658432754148e-10), SC_(9.9999999999999999999379801262975418925815160757789947731174936104124378715109938499619726846089139392e-01), SC_(9.9999999999999999999999999999999999999999889442701932297924838936494799531661250530432984424963007248e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1137313293829720350890678949490938814944999953236174345666570806119186963172572867879096285608753782e-10), SC_(9.9999999999999999999379801262975418925815160757789947731174936336688697335403167523443478066929130871e-01), SC_(9.9999999999999999999999999999999999999999833195170761234995671568693935632427761454699786337062637925e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1137313293829720350890678949490938814944930545470821738964244669280970471835293481505335404627883251e-10), SC_(9.9999999999999999999379801262975418925815160757789947731174944066848974901408101978191550505177065872e-01), SC_(9.9999999999999999999999999999999999999997963594392149936493894040019836692896825958936125182114983631e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1137313293829720350890678949490938814944720550542868250275326916336019741321242631026035967636340062e-10), SC_(9.9999999999999999999379801262975418925815160757789947731174967454642002233447363279873727554473071920e-01), SC_(9.9999999999999999999999999999999999999992307070531862290573462195130303788994505043849907539851496377e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1137313293829720350890678949490938814944540917707748053873742020547006350824374175542267053789346417e-10), SC_(9.9999999999999999999379801262975418925815160757789947731174987460913628158303914700382114196697907120e-01), SC_(9.9999999999999999999999999999999999999987468394532156427533296016791847579420061845471001586996730665e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1137313293829720350890678949490938814941680303039053799975698889390156843963230251022389451782794305e-10), SC_(9.9999999999999999999379801262975418925815160757789947731175306056531409886454897324817869961236575203e-01), SC_(9.9999999999999999999999999999999999999910413509034437120196750610856024038459948143581355167239051508e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1137313293829720350890678949490938814936462235187017162664043560869765441487220230363349884789296218e-10), SC_(9.9999999999999999999379801262975418925815160757789947731175887209095975817804333747961538698488840453e-01), SC_(9.9999999999999999999999999999999999999769857136567276362665826724901805006855358369950734520875490800e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1137313293829720350890678949490938814920949707155907855099174053193847941546962440000609680207656944e-10), SC_(9.9999999999999999999379801262975418925815160757789947731177614887942593616493138664357735661557177453e-01), SC_(9.9999999999999999999999999999999999999352004258897842265227095859761759631837047339457218719478702081e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1137313293829720350890678949490938814753776781461763837364216064970037856474331279702313347142988117e-10), SC_(9.9999999999999999999379801262975418925815160757789947731196233460419611598488677555771366333701841595e-01), SC_(9.9999999999999999999999999999999999994848954341461445590896939430474741794777644857000277415567004187e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1137313293829720350890678949490938814422717571105643242249014286300969089236958690822257453669448519e-10), SC_(9.9999999999999999999379801262975418925815160757789947731233104561865051515809605020981545465756629426e-01), SC_(9.9999999999999999999999999999999999985931385042063171960361094274918352996744262529529150154016448826e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1137313293829720350890678949490938813139985457826926256050492254597749994300385338421988655878996242e-10), SC_(9.9999999999999999999379801262975418925815160757789947731375966456041464970245511610216062894520969160e-01), SC_(9.9999999999999999999999999999999999951379099061492582922820839816776824359757264092021517711861345280e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1137313293829720350890678949490938802711689790139867726389123501719930141666421274662599150900539653e-10), SC_(9.9999999999999999999379801262975418925815160757789947732537398415758644536923231299801413772503242282e-01), SC_(9.9999999999999999999999999999999999670477537098666346357452831297863178258783685004074533254286730241e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1137313293829720350890678949490938733726847443923507586377681385668293512231091962619229513358809128e-10), SC_(9.9999999999999999999379801262975418925815160757789947740220456433111273573361537347330143590487574587e-01), SC_(9.9999999999999999999999999999999997812268814952852642426853604390040168248282502957536879464784073679e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1137313293829720350890678949490938501503314415994986414220380696847770995225462479025034729593704285e-10), SC_(9.9999999999999999999379801262975418925815160757789947766083918848431808077656996927130121665563928700e-01), SC_(9.9999999999999999999999999999999991556984612166224635143501521633152498303723650242482358364634621342e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1137313293829720350890678949490937510781357409080338674988812866256452962372476354858895356170647836e-10), SC_(9.9999999999999999999379801262975418925815160757789947876423727071052879768195658062679390110245354464e-01), SC_(9.9999999999999999999999999999999964870423925511397691189796709756793970973650968946411246321160180247e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1137313293829720350890678949490933761982171262025660389107617314593114770271032745947388928993398277e-10), SC_(9.9999999999999999999379801262975418925815160757789948293939237188789164744983173718738372007526730495e-01), SC_(9.9999999999999999999999999999999863890975276330644154618810351173304745041733304661631336601325009538e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1137313293829720350890678949490918545320691356624354187222592595799240553967971700188599109672947987e-10), SC_(9.9999999999999999999379801262975418925815160757789949988666499067359685281029901071037794636844840748e-01), SC_(9.9999999999999999999999999999999454007700599958307559059763600698158903544346730569205180299557413125e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1137313293829720350890678949490910753057860527010467391424561091058071494365181623660344303470594290e-10), SC_(9.9999999999999999999379801262975418925815160757789950856515223215498365383378098794073269325300508094e-01), SC_(9.9999999999999999999999999999999244111580451843059277280785733304917426123606903974726527655514563497e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1137313293829720350890678949490689326399423386835544711156617032095114804259608774069311751729254427e-10), SC_(9.9999999999999999999379801262975418925815160757789975517495889418039163593591767665011244107133352978e-01), SC_(9.9999999999999999999999999999993279657157862832815782565516873648632138151971738872154961945759936143e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1137313293829720350890678949489637735349414390749793843269684715961082647635716838296848098379083171e-10), SC_(9.9999999999999999999379801262975418925815160757790092636485698793502868570667768790868114302805896408e-01), SC_(9.9999999999999999999999999999964953497456718468629903495517866348538525966806958860531330633949800852e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1137313293829720350890678949485678797068534902565450482682903093152772439605571591511945734523293019e-10), SC_(9.9999999999999999999379801262975418925815160757790533555845149698534332201389794299291640519808868016e-01), SC_(9.9999999999999999999999999999858313641601909734132793462294359615147084346842388659846373583510436120e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1137313293829720350890678949470404235093998864289642165052806994826317485443774026830419718418801427e-10), SC_(9.9999999999999999999379801262975418925815160757792234731666513960149522054459159664032573182389636198e-01), SC_(9.9999999999999999999999999999446870731497232217541510112353116236089489656354008502067768820385476208e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1137313293829720350890678949464525210878784495762672297037011906299387432961878781001169036319272507e-10), SC_(9.9999999999999999999379801262975418925815160757792889497011982498404273763349101709709317868991935928e-01), SC_(9.9999999999999999999999999999288510522169059925311780940384660932103854475899050461336570108409084184e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1137313293829720350890678949301694589029314675366007515410062131235839253555059254625166948143083684e-10), SC_(9.9999999999999999999379801262975418925815160757811024453505649101968414103711925507010593836969513483e-01), SC_(9.9999999999999999999999999994902426978851273566033582519219675684223416812566238102539056189658849047e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1137313293829720350890678948381660263637178171242956545683704613764234594312258315475802211264305145e-10), SC_(9.9999999999999999999379801262975418925815160757913491558735344107252409978065797587873220729535345663e-01), SC_(9.9999999999999999999999999970119942160851602768906585944007502358480343319003594542865866832503909298e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1137313293829720350890678945043086871225776440978727301076068384510002208844214812900982662900946145e-10), SC_(9.9999999999999999999379801262975418925815160758285318936992641028273324780656344560710180109708090353e-01), SC_(9.9999999999999999999999999880190531781571877397310573965332443683085042189120263232056884252514364965e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1137313293829720350890678940256088523066724850725210463906749411159641241486974921387461918169228847e-10), SC_(9.9999999999999999999379801262975418925815160758818461940397568201312140437619416880549045617049338931e-01), SC_(9.9999999999999999999999999751245653734247714041691831267436412073291238982990912241380119718429413223e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1137313293829720350890678920859984696065338725063215561779181323591945127056016828400476066428803627e-10), SC_(9.9999999999999999999379801262975418925815160760978666790407208722325665348902912898561875584633673487e-01), SC_(9.9999999999999999999999999228782920165986057070319388795101792500790817322852807373716844304589415490e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1137313293829720350890678860817239405865434709938916387078392445116466305475958372018736907981230283e-10), SC_(9.9999999999999999999379801262975418925815160767665815443592960935423061479923726339405477959086134144e-01), SC_(9.9999999999999999999999997611442803044614243372301023640647932228512051487013547370692932159359032870e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1137313293829720350890678239319266860802870145571550096734160788291266498088629129943633093214365969e-10), SC_(9.9999999999999999999379801262975418925815160836883991760736399512825692111433004792380099637386951407e-01), SC_(9.9999999999999999999999980870476032646297807434660881652102876591095094967343238681312403092891547860e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1137313293829720350890677210319535169554814961880941241687558016661984703746382265315939670130640751e-10), SC_(9.9999999999999999999379801262975418925815160951486915671857923065566363427592422501042752567133378635e-01), SC_(9.9999999999999999999999953152846891478118623036348703209477086290605277055724464665531841610153804013e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1137313293829720350890658319402493047798533979977400833652787104722188450692268471472969908121042187e-10), SC_(9.9999999999999999999379801262975418925815163055427530730428477773832542701758842384389017852955149450e-01), SC_(9.9999999999999999999999444298066288664046631889229517811920967292984165959644762576836068577256757393e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1137313293829720350890618491674699406196811385524033499340855302623192308827380024000958205180167105e-10), SC_(9.9999999999999999999379801262975418925815167491166352921988958031143393557368990738802579604376241953e-01), SC_(9.9999999999999999999998371479333182532237187687882386710464509274584523019221009102090960842025869647e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1137313293829720350890390063455129033939169827198208504489891828768842425935664990712549484393420052e-10), SC_(9.9999999999999999999379801262975418925815192931932817991601323038634679164486300005841949685220881529e-01), SC_(9.9999999999999999999992218427509716478917229034977746322107453316586708328238078505811352428735615197e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1137313293829720350889409544252576135578933283072649756761144381018355343725379073730147411093840373e-10), SC_(9.9999999999999999999379801262975418925815302135428312468713123084324188639466742591204719759303354659e-01), SC_(9.9999999999999999999965806693098973333583966879056761476788772430503302066984071165252334783779069073e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1137313293829720350885153633022730845456567597715646094018479828341658277899928175615760062176064497e-10), SC_(9.9999999999999999999379801262975418925815776129595487620154848397033796140954030948183678091519610546e-01), SC_(9.9999999999999999999851167431791585730709706659090167973661845136694182232664966444022251106325796139e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1137313293829720350877664348562123499104154565886334772979871709320793682701294748822280699810285022e-10), SC_(9.9999999999999999999379801262975418925816610234669331565606000475475982556807009344632527425276386589e-01), SC_(9.9999999999999999999649432481996560662952739715697239834176051644372680428340112050914637328208215105e-01) }},
      {{ SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.1137313293829720350827557824875800396771895327484232683073915737780868393845958564034096200506580751e-10), SC_(9.9999999999999999999379801262975418925822190755192924366129145993702488286736073675202418655828042410e-01), SC_(9.9999999999999999998299739184401626722611510186405905968610071302543874737180200657276317852580481734e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.4214707189097453010569885455276606280717092168007583200158710292479880897766044575804464717451491164e-10), SC_(9.9999999999999999998989710497641105931290474652480502287028221848812590242489875208237999574340465020e-01), SC_(9.9999999999999999999999999999999999999999997247881626734957219113076430151945299005744136997935161540e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.4214707189097453010569885455276606280717092094198230650495423520155103263718495648399001331464033882e-10), SC_(9.9999999999999999998989710497641105931290474652480502287028221859304373585593146664605120571480223820e-01), SC_(9.9999999999999999999999999999999999999999995690142485834305377847519401401056815873058977777040774243e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.4214707189097453010569885455276606280717089997318815931207772693870701744660390605778082706008935630e-10), SC_(9.9999999999999999998989710497641105931290474652480502287028222157369642496400324656873649083242048299e-01), SC_(9.9999999999999999999999999999999999999999951435708254626761127705505642720277271708665874666273057049e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.4214707189097453010569885455276606280717083765069583899469526890246696164329720160375554891113986921e-10), SC_(9.9999999999999999998989710497641105931290474652480502287028223043265622124486626356567490496794816291e-01), SC_(9.9999999999999999999999999999999999999999819904699930829245793308129489853698768777709442106548791367e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.4214707189097453010569885455276606280717079423616709253492777846399096831520025302681430612067611021e-10), SC_(9.9999999999999999998989710497641105931290474652480502287028223660390436008066318137221870838616211769e-01), SC_(9.9999999999999999999999999999999999999999728278763141026842686489876286485737682361783434125895563378e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.4214707189097453010569885455276606280716935118906693498457157732436971662210065179310077784722464615e-10), SC_(9.9999999999999999998989710497641105931290474652480502287028244172882424823829683570803838370255350812e-01), SC_(9.9999999999999999999999999999999999999996682742022297668626254870787439844186013836730320006249364181e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.4214707189097453010569885455276606280716498521401656989216184988405803773964791393487916285632706275e-10), SC_(9.9999999999999999998989710497641105931290474652480502287028306233939360668623248130865044195989750334e-01), SC_(9.9999999999999999999999999999999999999987468394532156427533328606548966371157622101804889997198989710e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.4214707189097453010569885455276606280716125049297352245914338082228073254838851363764796203581267200e-10), SC_(9.9999999999999999998989710497641105931290474652480502287028359321905420548507653579024534631431971314e-01), SC_(9.9999999999999999999999999999999999999979586302428468363519600640923364597659234099492503330669177846e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.4214707189097453010569885455276606280710177585520992008928783997306635831705032362614146761285280505e-10), SC_(9.9999999999999999998989710497641105931290474652480502287029204736466407793979487730010311306989853585e-01), SC_(9.9999999999999999999999999999999999999854065663193875774579612709516583102709747531558516852992088904e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.4214707189097453010569885455276606280699328773944861917036417777999445531370915233967462779739107489e-10), SC_(9.9999999999999999998989710497641105931290474652480502287030746863265451594853211790088849402344292978e-01), SC_(9.9999999999999999999999999999999999999625102559730491839237046477992666410284955436590490525973163160e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.4214707189097453010569885455276606280667076894810470090808640505051517408805446749413585251638502422e-10), SC_(9.9999999999999999998989710497641105931290474652480502287035331373447387011174668175994682589608086110e-01), SC_(9.9999999999999999999999999999999999998944429816239960114552480648988171049817196129365050792652058442e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.4214707189097453010569885455276606280319510013176629776172076365922991986358055738150822545407017314e-10), SC_(9.9999999999999999998989710497641105931290474652480502287084736987957914345426487265309953331393997618e-01), SC_(9.9999999999999999999999999999999999991609064894328219636552995231466021863574039554549104729959085276e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.4214707189097453010569885455276606279631209459113472141328320619554348307366310725414361720561586791e-10), SC_(9.9999999999999999998989710497641105931290474652480502287182576896298927614959717197792098630128043873e-01), SC_(9.9999999999999999999999999999999999977082549260061527899895556788089987956251985938460757394009139333e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.4214707189097453010569885455276606276964299140156919642707939871999139100343032208853030303942357478e-10), SC_(9.9999999999999999998989710497641105931290474652480502287561670389134426497166519622511383717769518950e-01), SC_(9.9999999999999999999999999999999999920797668745560722410694068378465514806563473128353910247247889778e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.4214707189097453010569885455276606255282976097423074208969575161720677903898540791503288573436503320e-10), SC_(9.9999999999999999998989710497641105931290474652480502290643606974381357068239938089420484180860423686e-01), SC_(9.9999999999999999999999999999999999463215474030430395311444122056935111525476935952053336049609715441e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.4214707189097453010569885455276606111857559363710832193306089539830995309078884256150063562434472907e-10), SC_(9.9999999999999999998989710497641105931290474652480502311031109997821332507348913742720168919065320069e-01), SC_(9.9999999999999999999999999999999996436236131598708894796186224706066558007473838216473367385483932626e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.4214707189097453010569885455276605629044873748688532206814855432019638350213082888027620192802571539e-10), SC_(9.9999999999999999998989710497641105931290474652480502379661519529814391745720350564284136480598973871e-01), SC_(9.9999999999999999999999999999999986246521791538258729638254986546889236476473330007508325544538996804e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.4214707189097453010569885455276603569248769007003880614193413630062602570900587541994472137082372032e-10), SC_(9.9999999999999999998989710497641105931290474652480502672455504511279943113996383366430337188166816401e-01), SC_(9.9999999999999999999999999999999942774727177544473548174521984567189189975954959568492852591404916641e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.4214707189097453010569885455276595775173038200719219311392348145738886674934572417492119945172792484e-10), SC_(9.9999999999999999998989710497641105931290474652480503780360547741900737984970521462779070413328434428e-01), SC_(9.9999999999999999999999999999999778281523896137433618593024222717980568593827219497802737090408929613e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.4214707189097453010569885455276564138425894558653754233353920544380044457642240112829532804465173081e-10), SC_(9.9999999999999999998989710497641105931290474652480508277431518365772536660799607137188224913218166655e-01), SC_(9.9999999999999999999999999999999110591080692907326214171668989685482312494824540681928928373115296644e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.4214707189097453010569885455276547937641696178129924965716439835063111631083664242414211406295268968e-10), SC_(9.9999999999999999998989710497641105931290474652480510580325554503133030956082559368280548080723271341e-01), SC_(9.9999999999999999999999999999998768675120352766660295675698596357243501613765196001567276123118507281e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.4214707189097453010569885455276087572586385704625364331215934469494499123958053761342847156965699304e-10), SC_(9.9999999999999999998989710497641105931290474652480576019870167813476160349741383174450472021813078966e-01), SC_(9.9999999999999999999999999999989052715814552169216569906810537437262234167525390218513682182337733751e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.4214707189097453010569885455273901224405374682159029987236164782049381232498437833249539252195372335e-10), SC_(9.9999999999999999998989710497641105931290474652480886802862232688681691857817905903505215847669868735e-01), SC_(9.9999999999999999999999999999942910052052446728185270821965337229865157528948662843733980084916901670e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.4214707189097453010569885455265670251434406807530094208377169555641578466241468082770659877340624462e-10), SC_(9.9999999999999999998989710497641105931290474652482056811568869527370422921262456134705826730141701276e-01), SC_(9.9999999999999999999999999999769196175400503725686803044573496760191836013467085696736445693818614609e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.4214707189097453010569885455233913124185671370775982219140630069109777413651993498423188680546722517e-10), SC_(9.9999999999999999998989710497641105931290474652486570994218946349686920234882253691999195837060275812e-01), SC_(9.9999999999999999999999999999098965121895029017006853256633562880657477867420646385641871461283145245e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.4214707189097453010569885455221690127518912244807433441228986588351600124626688787093950957959369356e-10), SC_(9.9999999999999999998989710497641105931290474652488308457404859301217536270821109232572378458927550678e-01), SC_(9.9999999999999999999999999998840999976975250795707825504181164350176325112860316982758879361242240914e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.4214707189097453010569885454883151268814821459626941583585650300796273087255672954728061723462274823e-10), SC_(9.9999999999999999998989710497641105931290474652536430764890958162605916435334667229388309440770678639e-01), SC_(9.9999999999999999999999999991696170592862149004465013172056144831380115777125064311337818780273520746e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.4214707189097453010569885452970320826057066134321265167816693501321287788822326658076900279541677514e-10), SC_(9.9999999999999999998989710497641105931290474652808334011352889449543484469012137086271790276975948647e-01), SC_(9.9999999999999999999999999951326071849817797298930298552668164708045361225090728650043144692742330681e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.4214707189097453010569885446029139780813267958641917661373057439008671041032081447702252590541289813e-10), SC_(9.9999999999999999998989710497641105931290474653795002572399429361306092061455003918431428129028203304e-01), SC_(9.9999999999999999999999999804833127192450133372714809456376500852417687980679503179866854323193993676e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.4214707189097453010569885436076558755222780669098701628927404430877005413039201295536597124113805507e-10), SC_(9.9999999999999999998989710497641105931290474655209732822944789377606060817699967998885954053950429390e-01), SC_(9.9999999999999999999999999594784881529872781427073564149254483633308807573267103098044412832782431938e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.4214707189097453010569885395750391733829212812808914853316962554848133420426902449056712012766444686e-10), SC_(9.9999999999999999998989710497641105931290474660941979385622267099525378932911674176635866051078589406e-01), SC_(9.9999999999999999999999998743705084705284805842846930424215782385703914144627975722551034726311003810e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.4214707189097453010569885270916363385058387134164529620455066204170033020789560654445414642479712689e-10), SC_(9.9999999999999999998989710497641105931290474678686770987754946169423115451318525155952407912565460427e-01), SC_(9.9999999999999999999999996109095169324459648571749443279199257787310443551412693799114685035042103483e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.4214707189097453010569883978768658472286785008453975362014146063086476148708289654514050500525032610e-10), SC_(9.9999999999999999998989710497641105931290474862361783691748434117239784697879676060608802398879241078e-01), SC_(9.9999999999999999999999968838444686200120023491898565875741849623015846849904822252685446214355669626e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.4214707189097453010569881839389770049126167544646076219613503742747114662612588635432513484171057318e-10), SC_(9.9999999999999999998989710497641105931290475166468228346468624286221697301193399317933104154633979244e-01), SC_(9.9999999999999999999999923687063233952321126687963890581690859665411369667313923314068467607115496762e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.4214707189097453010569842563549497045948843490357979636390429539370434650279085262174168754366535621e-10), SC_(9.9999999999999999998989710497641105931290480749413919211483986396040309589548752034748305240282503082e-01), SC_(9.9999999999999999999999094774309340701994681485034382635983487986687849848310557267402000712834921153e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.4214707189097453010569759758280077260057953133837309476767651861118672346216062261510971566398440499e-10), SC_(9.9999999999999999998989710497641105931290492519940504377303835274177428163818189380126343135433035651e-01), SC_(9.9999999999999999999997347177225878509640255439600092080532287262522028425822573371596826568761414113e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.4214707189097453010569284836377361373125304065982166109927966396569237246892845857520103458114426718e-10), SC_(9.9999999999999999998989710497641105931290560028698352330895588385537563354825831358417019564189291265e-01), SC_(9.9999999999999999999987323997084394886799867798507223339671689606711723240113348193767954409571403190e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.4214707189097453010567246252676093120269505815643285666186671392419504045553027029948055103136067975e-10), SC_(9.9999999999999999998989710497641105931290849807402292278179649004724999418573090525602089685976791800e-01), SC_(9.9999999999999999999944299888163632296211375605586204921151481211382012749850613152443123799117835408e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.4214707189097453010558397847418329626945512550424343460267490344027571635183416823736975943078613016e-10), SC_(9.9999999999999999998989710497641105931292107582300588062483115407184506630692969114225793002934925145e-01), SC_(9.9999999999999999999757555163702122379870786438031296329530061090668019762179903883725147698409410858e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.4214707189097453010542826981293724523667205634130227785097397949987523265193239109565583348728672477e-10), SC_(9.9999999999999999998989710497641105931294320935327007044074507369511389709478990606328849225281964855e-01), SC_(9.9999999999999999999428933562480231335039989597248287322607857494873785499782017897184737722043805424e-01) }},
      {{ SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.4214707189097453010438651211713486033926894932748691957197365773334744376621408473931493714167204206e-10), SC_(9.9999999999999999998989710497641105931309129215934826802222775786719912069970416159735107157650408239e-01), SC_(9.9999999999999999997230314170725042867096513266938461288399716754751844839536309127270122471818874966e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(3.8006320313144215105234214339491822085503871364272867307538378152592437784819613553517473916586286948e-10), SC_(9.9999999999999999992777598081273407055059035031902744407748315815446076260679344320412837429950063769e-01), SC_(9.9999999999999999999999999999999999999999980325535429971135088712317950386439514187919850657481263087e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(3.8006320313144215105234214339491822085503869953473960935048422654416190502275278155075940130203419101e-10), SC_(9.9999999999999999992777598081273407055059035031902744407748316351638827590943430886995083826141049601e-01), SC_(9.9999999999999999999999999999999999999999969189501517070270505635905661905866762034046070148021612534e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(3.8006320313144215105234214339491822085503829873523617373156763653476961451604139647887506490829142812e-10), SC_(9.9999999999999999992777598081273407055059035031902744407748331584553136514221291874892671985102625350e-01), SC_(9.9999999999999999999999999999999999999999652821460517580037963213396072397378796564273240914459308402e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(3.8006320313144215105234214339491822085503710749725655927994729703534326504490650191100171159783136567e-10), SC_(9.9999999999999999992777598081273407055059035031902744407748376859125358923828332198776265307075842606e-01), SC_(9.9999999999999999999999999999999999999998712526817574361102820146040154617127154586582632723039912875e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(3.8006320313144215105234214339491822085503627766787098147783229791511357884919414057676062142393172375e-10), SC_(9.9999999999999999992777598081273407055059035031902744407748408397886792453432031829603697994436042513e-01), SC_(9.9999999999999999999999999999999999999998057507300761933828097007761162502314858428557047704546872429e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(3.8006320313144215105234214339491822085500869512988060382852067079655915096280189406434741286797927563e-10), SC_(9.9999999999999999992777598081273407055059035031902744407749456708660704215502300136071746080783715704e-01), SC_(9.9999999999999999999999999999999999999976285440631493960738201205449719411301449027871823277906529178e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(3.8006320313144215105234214339491822085492524347214982823995363092766787395654872355588156812623284866e-10), SC_(9.9999999999999999992777598081273407055059035031902744407752628399095082950229130839671989660069219936e-01), SC_(9.9999999999999999999999999999999999999910413509034437120200693732293959757037331824877531607352102231e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(3.8006320313144215105234214339491822085485385766288409339196605913818634917940734452508869044218275748e-10), SC_(9.9999999999999999992777598081273407055059035031902744407755341511027849487109264295898567375439559079e-01), SC_(9.9999999999999999999999999999999999999854065663193875774585656446220901169224535568176740911392780325e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(3.8006320313144215105234214339491822085371705384310620276381652739315594905485832391748025742065578681e-10), SC_(9.9999999999999999992777598081273407055059035031902744407798547241135533867123816590670849998092017382e-01), SC_(9.9999999999999999999999999999999999998956738210487488574368681689054014217881046829140726982690804878e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(3.8006320313144215105234214339491822085164340179518353536683179841461810433458829780685889266103566792e-10), SC_(9.9999999999999999992777598081273407055059035031902744407877359125086890242420982553172616266663166926e-01), SC_(9.9999999999999999999999999999999999997319916731188286638774756348647437117361762963475218256239355239e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(3.8006320313144215105234214339491822084547874728468068060188157296680221353269471635015704433970561166e-10), SC_(9.9999999999999999992777598081273407055059035031902744408111654959032930999634485677137385953468046492e-01), SC_(9.9999999999999999999999999999999999992453893559481090673321711143088467740032077955493988269722044850e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(3.8006320313144215105234214339491822077904448664401401075541329756149221341825577158454731597879046849e-10), SC_(9.9999999999999999992777598081273407055059035031902744410636576748709017871754188451305699299855044358e-01), SC_(9.9999999999999999999999999999999999940014514982473054895371863945014528515125812792072290798817060431e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(3.8006320313144215105234214339491822064748207139663740042592153233412678311073304126544044235322858732e-10), SC_(9.9999999999999999992777598081273407055059035031902744415636780043771701744801939552777907594316681493e-01), SC_(9.9999999999999999999999999999999999836166722696822591911916330069415667481734227586242274673617852892e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(3.8006320313144215105234214339491822013772632481346583690747766679601470540297106644743006934196792783e-10), SC_(9.9999999999999999992777598081273407055059035031902744435010720229877689963353443801217523372718183133e-01), SC_(9.9999999999999999999999999999999999433794899497556308046527532935417158192710991240006295746030682550e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(3.8006320313144215105234214339491821599353784723317906195476252315583905504324075758523433347810557194e-10), SC_(9.9999999999999999992777598081273407055059035031902744592516074946835542895384410310812536827248587530e-01), SC_(9.9999999999999999999999999999999996162611230490497462152016868338752388692643536293775396572639971390e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(3.8006320313144215105234214339491818857906880175678260402598758098926815184909417926306548626948869173e-10), SC_(9.9999999999999999992777598081273407055059035031902745634439166703988410969989422723414361028328592325e-01), SC_(9.9999999999999999999999999999999974523208505153287440507294126689513542968705163940800538670357804189e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.8006320313144215105234214339491809629379799002336618545447170544962924603079201479535530279427480095e-10), SC_(9.9999999999999999992777598081273407055059035031902749141862729359987084435034067303080352447446322377e-01), SC_(9.9999999999999999999999999999999901678531579286397089318988716372330750519314820733699385449595636476e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.8006320313144215105234214339491770258243330021885429204666956284914602664580747183810623973014749790e-10), SC_(9.9999999999999999992777598081273407055059035031902764105382966685834375779880978741161398215957756919e-01), SC_(9.9999999999999999999999999999999590905459011951662439833618477173226900732473411559817885851821010199e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.8006320313144215105234214339491621281546781881872723577199075498749804109768200940663533333434702553e-10), SC_(9.9999999999999999992777598081273407055059035031902820725943448712788752190274925358818026472756829751e-01), SC_(9.9999999999999999999999999999998414969230610875826723166468936452870626879383442509605559591395520871e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.8006320313144215105234214339491016573786455689518782728922491051306053800656263022485809537126909634e-10), SC_(9.9999999999999999992777598081273407055059035031903050553111796725868376976670222344488337010960238812e-01), SC_(9.9999999999999999999999999999993641754496767843277676598667024107617724066311691125475258135600362122e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(3.8006320313144215105234214339490706910473610978389980277764330574380752449620964284534229806929620965e-10), SC_(9.9999999999999999992777598081273407055059035031903168244742368780633550185175496984185131164987905357e-01), SC_(9.9999999999999999999999999999991197450678666176553688442103744137195553168979081344010683532602810861e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(3.8006320313144215105234214339481907449509268868543837905080076678538708611048656634076580956951076996e-10), SC_(9.9999999999999999992777598081273407055059035031906512596062306731766948678891442711542813943571633674e-01), SC_(9.9999999999999999999999999999921739574526691956386294103565296760403442454728303428628813435509365695e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(3.8006320313144215105234214339440117384752307327175009006720486315157682817427291854543257574953277429e-10), SC_(9.9999999999999999992777598081273407055059035031922395461932907927732821617554110421413825064456841858e-01), SC_(9.9999999999999999999999999999591872875414738633143113084221693333385132318623050279151927919588271553e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.8006320313144215105234214339282789793265719001527352503838059633296698936113855748576484698234406871e-10), SC_(9.9999999999999999992777598081273407055059035031982189890294255695370076911952625272249880467718108824e-01), SC_(9.9999999999999999999999999998350019492685305873405462962260221244506015875423234393106431776142897034e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.8006320313144215105234214338675781076289074246551989017359586785342402831407804662147534906506393398e-10), SC_(9.9999999999999999992777598081273407055059035032212891567597106308622758487740611825362318426077679283e-01), SC_(9.9999999999999999999999999993558642332449813818852937660520524266671300415478295695770502444712040654e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.8006320313144215105234214338442149568433000635925294564130683537101933100652379395897439759592286736e-10), SC_(9.9999999999999999992777598081273407055059035032301686306825314336033932419565572154739638270363782492e-01), SC_(9.9999999999999999999999999991714489786785398486254826195818012004990041592763428327427538874438589590e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.8006320313144215105234214331971285983727284270257737983241757498446986811951213925769671885610313600e-10), SC_(9.9999999999999999992777598081273407055059035034761023447855174939296675350205226446320691119054027550e-01), SC_(9.9999999999999999999999999940637220021726235708627661125020156294932075197374802908339815305572537779e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(3.8006320313144215105234214295409264999965682658009385745303224572902274547955377236476152782091472858e-10), SC_(9.9999999999999999992777598081273407055059035048656902255902610922387859873710186608894915647834332993e-01), SC_(9.9999999999999999999999999652037686976821961132511623844831476036648963588017258029808715001633830000e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(3.8006320313144215105234214162734877686049589928875056158074172470002760570854742745979326530020747908e-10), SC_(9.9999999999999999992777598081273407055059035099081554871931134460002240792893455158005390581692840720e-01), SC_(9.9999999999999999999999998604782497149632078329553234065925343484523644318701583029251087001431414923e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(3.8006320313144215105234213972500307926899081957000438920669704283253848448294468416461298195427721792e-10), SC_(9.9999999999999999992777598081273407055059035171382714800925656137751401408884797760707878130452789517e-01), SC_(9.9999999999999999999999997103180383145247097017298709415829872046107774105294223859915598246000976321e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.8006320313144215105234213201702158821119475454100653378153378925951624724891141034411718435845708097e-10), SC_(9.9999999999999999992777598081273407055059035464334728317855205964108913995675828467576218210454152953e-01), SC_(9.9999999999999999999999991018943792323236699534831516151621851476434316916029728776935540669208225713e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.8006320313144215105234210815612800375423194572096512089880613575312046512845073694935839043552700157e-10), SC_(9.9999999999999999992777598081273407055059036371199492846574353984013802735432581954329335258040877523e-01), SC_(9.9999999999999999999999972184528841446098436041515204766064992360450642294008956996079312466653546322e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.8006320313144215105234186117380042730440106632128538253797312159851491409430994431455971049571260681e-10), SC_(9.9999999999999999992777598081273407055059045758088946403038204801540378281222941827688207218031639640e-01), SC_(9.9999999999999999999999777230906226973142594358523362991422121474189581027361513531160763326915860180e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.8006320313144215105234145225090761735288146942755469292253620737755056194744441373516070742766559607e-10), SC_(9.9999999999999999992777598081273407055059061299743393915593151743907502833249578646352393441332759540e-01), SC_(9.9999999999999999999999454450729582094066659837527952782944517113060724186894219623178617291033880976e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(3.8006320313144215105233394502985907473726659278550303184732202434504260789345486431540583425838155300e-10), SC_(9.9999999999999999992777598081273407055059346621591226404618735716849364207030606380957431987769005929e-01), SC_(9.9999999999999999999993528682867798618516309365510353101724405530968451500413162143963062004806230639e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(3.8006320313144215105231811755278417303460523772333383854531860684699431374492186758830297146871285589e-10), SC_(9.9999999999999999992777598081273407055059948165754684065584387631408602026005831075909281813217032620e-01), SC_(9.9999999999999999999981035384165507871512908769087164436607266872633484100765931477060603545517266405e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.8006320313144215105222734053363702811982163494605506793060725113630544768954654647105209812023090081e-10), SC_(9.9999999999999999992777598081273407055063398266221462880712700031435448922196534984496140600407755646e-01), SC_(9.9999999999999999999909381234224754204718636446233046193132426600548930702361095690017109530701971671e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.8006320313144215105183768372769731063970448750422009268145531142617244383661811315298748743484577075e-10), SC_(9.9999999999999999992777598081273407055078207687600204458629088901006040445703139845030766108035034969e-01), SC_(9.9999999999999999999601808596782430605271883151514866997199912673140143207610222282235321803079030120e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.8006320313144215105014639122484087222150063629963864648121537921854269254718901033274751036854862537e-10), SC_(9.9999999999999999992777598081273407055142487492206985634536399002479851607558953320936609027282344482e-01), SC_(9.9999999999999999998266799717531746905928312989510972463613602860585298554374532813980178944411260906e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.8006320313144215104717016122945046499084272240523227984375638140936743365745165425538764729992347493e-10), SC_(9.9999999999999999992777598081273407055255603042737381182561354660611851019431022135385657203008623665e-01), SC_(9.9999999999999999995917535197155829884383484168722554303976941254599635340707647255863588355011746221e-01) }},
      {{ SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(3.8006320313144215102725790665501531229183158716008381067053690616140817202382403804703092034554668227e-10), SC_(9.9999999999999999992777598081273407056012394568250234745000476025502072455291846357443936178915533874e-01), SC_(9.9999999999999999980199948429713383224488491248149962173404309153772842854074994315273246306242901151e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(6.0916272026645401634466573731560627824291622069905243307814099402220104484050723280883467513325250524e-10), SC_(9.9999999999999999981446039011878694659584761713548171688915597187651543085979744512004865322717363906e-01), SC_(9.9999999999999999999999999999999999999999949457361664130189609051807908237591512322590233404735572721e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(6.0916272026645401634466573731560627824291616260955838582516869162702048574398870955836882680116365780e-10), SC_(9.9999999999999999981446039011878694659584761713548171688915600726246964358640558381736203139822188691e-01), SC_(9.9999999999999999999999999999999999999999920849491165171865799452329395949730327403827216704845423021e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(6.0916272026645401634466573731560627824291451232189061113974680535024384008717944933729324854176390969e-10), SC_(9.9999999999999999981446039011878694659584761713548171688915701255619456739590171356738909876111377185e-01), SC_(9.9999999999999999999999999999999999999999108117057184560239804157635194687686435156919609333588325067e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(6.0916272026645401634466573731560627824290960741225302136908653517475411190524384956566751139944242125e-10), SC_(9.9999999999999999981446039011878694659584761713548171688916000044429206272771459776826693117760821158e-01), SC_(9.9999999999999999999999999999999999999996692550834364335987779515125550947906736550572453781336336689e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(6.0916272026645401634466573731560627824290619059863514704108218850222868225264405583942757887763617465e-10), SC_(9.9999999999999999981446039011878694659584761713548171688916208183977017051769186770309542191004642123e-01), SC_(9.9999999999999999999999999999999999999995009841024227015676834654048392858335058710090636850060418130e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(6.0916272026645401634466573731560627824279261979352870109238430763426327094464219147825800261006623836e-10), SC_(9.9999999999999999981446039011878694659584761713548171688923126494035166441850659527215047637408228714e-01), SC_(9.9999999999999999999999999999999999999939078576029825069321849766723652380561467103777104305978827410e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(6.0916272026645401634466573731560627824244900848556066362421405740193340942839283911465517887097251275e-10), SC_(9.9999999999999999981446039011878694659584761713548171688944058013942778840878746201497917808324767716e-01), SC_(9.9999999999999999999999999999999999999769857136567276362693342240879065592487829244195684640164917324e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(6.0916272026645401634466573731560627824215507817957094664184165630701546292116051869193993844765268374e-10), SC_(9.9999999999999999981446039011878694659584761713548171688961963152419323560838922369325831964940799368e-01), SC_(9.9999999999999999999999999999999999999625102559730491839280893661545609657412039027117724537862796247e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(6.0916272026645401634466573731560627823747430061278944871868568632140745143294259558342881104847032878e-10), SC_(9.9999999999999999981446039011878694659584761713548171689247098671973604651174724665192910196114569327e-01), SC_(9.9999999999999999999999999999999999997319916731188286638977219827790346433892449840959322498813333612e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(6.0916272026645401634466573731560627822893606048871654018979657525817426716729597503865806009581719421e-10), SC_(9.9999999999999999981446039011878694659584761713548171689767216430000448532405596416682067662128168071e-01), SC_(9.9999999999999999999999999999999999993115010633025453495397502811847272997625993371440599062517507182e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(6.0916272026645401634466573731560627820355316148917067447287780779600270309784587744398260585626217297e-10), SC_(9.9999999999999999981446039011878694659584761713548171691313448010281649903669781631039422583479972221e-01), SC_(9.9999999999999999999999999999999999980614459554435257309017658074184100566997953039494594619552461228e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.0916272026645401634466573731560627793001080399313068631001041125095990418382620660494056520526569336e-10), SC_(9.9999999999999999981446039011878694659584761713548171707976628670320306728088296025553882827658718697e-01), SC_(9.9999999999999999999999999999999999845900524314082848099597440215841016896719248447583467996646220010e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.0916272026645401634466573731560627738830396662357408362382921659569390522220598263991418281011442507e-10), SC_(9.9999999999999999981446039011878694659584761713548171740975389734217977512686719518411230839047178723e-01), SC_(9.9999999999999999999999999999999999579121146974999221563838011949822177576509978087254037227586734045e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.0916272026645401634466573731560627528939013326695139210882052932306803595308815772282719679533738312e-10), SC_(9.9999999999999999981446039011878694659584761713548171868833395767459080500034861382939696805641676551e-01), SC_(9.9999999999999999999999999999999998545449635147156438286419064427141744196293675120056317104715817606e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(6.0916272026645401634466573731560625822573840999760844235380573410039179717427827088112810192922402368e-10), SC_(9.9999999999999999981446039011878694659584761713548172908287445910070958598622893079740968959868361215e-01), SC_(9.9999999999999999999999999999999990141955221139585444178076569968291098462988938815233715948433812956e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(6.0916272026645401634466573731560614534695538623618535097885534624280275535757865931001863108923961336e-10), SC_(9.9999999999999999981446039011878694659584761713548179784442098622204781693629635314582083283494416055e-01), SC_(9.9999999999999999999999999999999934551496743450527259356653077801836488691680791083469016054984773033e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.0916272026645401634466573731560576536334005644686890039637623044567672801833509961518045451653677157e-10), SC_(9.9999999999999999981446039011878694659584761713548202931627375719836534564992292492051559606515591450e-01), SC_(9.9999999999999999999999999999999747417450607018907222341252516241783484435221803859795877300709365728e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.0916272026645401634466573731560414426100774107151877171242344345697076292579156639528486529428544240e-10), SC_(9.9999999999999999981446039011878694659584761713548301683138034072553898535132847302594215911060915174e-01), SC_(9.9999999999999999999999999999998949058188763341780574656359840563760001775192007557537283347519770557e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.0916272026645401634466573731559801016146440920191708236227804895166874535999751290659551494865496514e-10), SC_(9.9999999999999999981446039011878694659584761713548675349614454198054890780839870893250937154676502771e-01), SC_(9.9999999999999999999999999999995928141442258195371591810967032041939989163960441835654799868101480052e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.0916272026645401634466573731557311138412262872610146604059954348174491373488066914253639857009276366e-10), SC_(9.9999999999999999981446039011878694659584761713550192090308136972406724598797697412194036949574515492e-01), SC_(9.9999999999999999999999999999983666010234907146975039721280750687791286949541826222771533265114762244e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.0916272026645401634466573731556036103034301209852714122641870199650075162053217513665837230521425714e-10), SC_(9.9999999999999999981446039011878694659584761713550968794327412065245348402699820587534689890468678797e-01), SC_(9.9999999999999999999999999999977386725560014619652972630276649966105036290841444219825352135201028116e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.0916272026645401634466573731519804416647366451584623892014662416464255365203635894093212944331866134e-10), SC_(9.9999999999999999981446039011878694659584761713573039786966718293415314897331360091758479091850853833e-01), SC_(9.9999999999999999999999999999798953187944219710102332298996385884957485157748505637404721400267769816e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.0916272026645401634466573731347734272066967288510835230804727814703858807777073010426960499391691618e-10), SC_(9.9999999999999999981446039011878694659584761713677858504315956287414970257960026959380393878238089180e-01), SC_(9.9999999999999999999999999998951543429324385332211054940264686736930352104906350758157116255622913386e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.0916272026645401634466573730699939597159851231403769512281542886488686642081834414221451255720934331e-10), SC_(9.9999999999999999981446039011878694659584761714072470870656498345086890096426261504455505230604929591e-01), SC_(9.9999999999999999999999999995761289068599073573328167821678227013021652468968216070740893606924592517e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.0916272026645401634466573728200587698588444559916655290002651421069025297582696039267335019895841697e-10), SC_(9.9999999999999999981446039011878694659584761715594982872093382899231630259072883204049328509700471353e-01), SC_(9.9999999999999999999999999983452499567438376122747976879847871645253951302071363655202288188117520521e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.0916272026645401634466573727238612464304213911692806681484970718576924095038024101987309543485030866e-10), SC_(9.9999999999999999981446039011878694659584761716180982322638924258918893200807059134938776343699744029e-01), SC_(9.9999999999999999999999999978714971142208482756265860740805068974897937845364113358212808389643076343e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.0916272026645401634466573700594900877452190162186397013470875860351304093457667455279909777436098588e-10), SC_(9.9999999999999999981446039011878694659584761732411338150880543249329819280203138378343494914919750493e-01), SC_(9.9999999999999999999999999847500219974255568956674821616928473454789937445898669422055563539720555116e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.0916272026645401634466573550051170605308248957970160896587248209938034099734429738378875677054839126e-10), SC_(9.9999999999999999981446039011878694659584761824116966402519068288346075327534275814446569326296562983e-01), SC_(9.9999999999999999999999999106103585231269798891035883640784786426552865214880678186779071974897853210e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.0916272026645401634466573003765800147287352196508495865159370702714378384691426909026509925823504133e-10), SC_(9.9999999999999999981446039011878694659584762156893648712494654667013785051122617159712255852505918916e-01), SC_(9.9999999999999999999999996415761486395657808665948573825930309242762211183137723981536388733212103183e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.0916272026645401634466572220476994230944260764001888675450785481033421744723697534316786471722570748e-10), SC_(9.9999999999999999981446039011878694659584762634043988478756753080005475999519196518929775460079651492e-01), SC_(9.9999999999999999999999992558226644603018852219658255838962633701226203000858182583879478071733869144e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.0916272026645401634466569046723861033385502929533411774544468297963327006527309072269447248879234986e-10), SC_(9.9999999999999999981446039011878694659584764567376080551563212947937603087359285740398496766484131933e-01), SC_(9.9999999999999999999999976928150996789278966628646745973286082491441326142593927061117418837022355405e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.0916272026645401634466559222026453233657112890069140567242962586845199491936114429913215942395057685e-10), SC_(9.9999999999999999981446039011878694659584770552215479281625059075286319423722737538854050850667135857e-01), SC_(9.9999999999999999999999928543554824346363889777456939374096682552937913702355654888767775931335267579e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.0916272026645401634466457527317287214213749670462400514929161010397007062446085128489769085113938825e-10), SC_(9.9999999999999999981446039011878694659584832500841151559924460882520627954842933540249815074622871794e-01), SC_(9.9999999999999999999999427718213174070381238712850494920145113928635008250558073308734300983522122707e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.0916272026645401634466289153753624999423641817973106335706465662610355270080476312897627726647374462e-10), SC_(9.9999999999999999981446039011878694659584935067739212991659530302317955629591430200828228990019698431e-01), SC_(9.9999999999999999999998598513348559736457764176046144337929246818995242416398959277984014571749388974e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(6.0916272026645401634463198063517866137271933047365169956031821609114634564336089489962503000557666813e-10), SC_(9.9999999999999999981446039011878694659586818044675816934800521308427954094708840585202714771063725557e-01), SC_(9.9999999999999999999983375535318616665058041150606891137264530329676532236926664392835864807544636171e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(6.0916272026645401634456681116763990602139216203258965089230925756045334476588013161351086387251661703e-10), SC_(9.9999999999999999981446039011878694659590787925688239392961033268162594173965322536703881672121511796e-01), SC_(9.9999999999999999999951280924779949972653497604892083041979920232458352789408838789601547835472942468e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.0916272026645401634419303776240427882385593654551119219864052918359257359714572314590374743866582946e-10), SC_(9.9999999999999999981446039011878694659613556808117898425923747074362671389866074580535403812632544216e-01), SC_(9.9999999999999999999767205278257062846629265039921775132535072856317376773366705992670913929737121989e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.0916272026645401634258863003236804873183807476857548939232915257696885823951494651482096142687610208e-10), SC_(9.9999999999999999981446039011878694659711291345842438076433879423410898003765140374473594828268411287e-01), SC_(9.9999999999999999998977067761633698710242550711322314380199704276341959258207520136871382406419351485e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.0916272026645401633562475124474848198182909705912034212106555878389209913958517985318588782483102548e-10), SC_(9.9999999999999999981446039011878694660135504880429657184404284978755416517073784575024455052143325841e-01), SC_(9.9999999999999999995547501954697830340665174571731845361193508497262952369089484721524193505623708914e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.0916272026645401632337015607745965322695998667462041630152395617084780395808455909241522354388006283e-10), SC_(9.9999999999999999981446039011878694660882009133216637589617434954866450850753380042473689150176202400e-01), SC_(9.9999999999999999989512368109707179936908395981761132018147528706552371122943721275671519161949360297e-01) }},
      {{ SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(6.0916272026645401624138166088198367511674428522070378155142637362154578160777079375018308048031683583e-10), SC_(9.9999999999999999981446039011878694665876442609599561825950331363560079353941910721432792479082400449e-01), SC_(9.9999999999999999949134735434017487309367125880946511702248256334455845002675756948415587794518423956e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.0221641311147777740227785579903068722949313139331809425235040808565398335447431763442803098424369528e-09), SC_(9.9999999999999999947759024453118569571484923605709968082401230337717018089137602395122971990459463759e-01), SC_(9.9999999999999999999999999999999999999999857690940760870814582962129249756177303259926399817265448283e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.0221641311147777740227785579903068722949310394855080159153142940351419249040277282424331924934495207e-09), SC_(9.9999999999999999947759024453118569571484923605709968082401258390773731439055624568017977009906326838e-01), SC_(9.9999999999999999999999999999999999999999777141937551192327376203771360411615444240254653081481685177e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.0221641311147777740227785579903068722949232425918096164164125123801927673299509499457004630400578431e-09), SC_(9.9999999999999999947759024453118569571484923605709968082402055361280993320054917875538267815562298804e-01), SC_(9.9999999999999999999999999999999999999997488793091883081044052472426665383647237080051979741863989926e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.0221641311147777740227785579903068722949000690204430490718398765889171153773949518516111640122190528e-09), SC_(9.9999999999999999947759024453118569571484923605709968082404424080625066680371723160465492244549848068e-01), SC_(9.9999999999999999999999999999999999999990687467161586313153886110506196977872437050403097690865929867e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.0221641311147777740227785579903068722948839260575608667720129149762660564683412867022897739561662990e-09), SC_(9.9999999999999999947759024453118569571484923605709968082406074156387875078295780865063077460538917618e-01), SC_(9.9999999999999999999999999999999999999985949589244296250401564545029140862917496342041371575761268668e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.0221641311147777740227785579903068722943473532454700818063470675151861568357249266329105135410325538e-09), SC_(9.9999999999999999947759024453118569571484923605709968082460920704612934092375495111471770701969609480e-01), SC_(9.9999999999999999999999999999999999999828468184128193497423837665616905164309330631214917625493344476e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.0221641311147777740227785579903068722927239387983346871047019217862724554755079343429497451866352622e-09), SC_(9.9999999999999999947759024453118569571484923605709968082626860306392466898572957075755612323035090306e-01), SC_(9.9999999999999999999999999999999999999352004258897842265450096149929574744008829514209671131364163007e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.0221641311147777740227785579903068722913352455448547406850554067107695432747561584004228423449635504e-09), SC_(9.9999999999999999947759024453118569571484923605709968082768807549675295226487053684690594102150390903e-01), SC_(9.9999999999999999999999999999999999998944429816239960114912997880202634813837898550212973117107768535e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.0221641311147777740227785579903068722692206010336584341538213340892733017219603487055569185063721556e-09), SC_(9.9999999999999999947759024453118569571484923605709968085029287188845211438288817305416844887017823261e-01), SC_(9.9999999999999999999999999999999999992453893559481090675586477465744427354548819615931556206967603507e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.0221641311147777740227785579903068722288811184581303416467565897150841950195303619731812794552677824e-09), SC_(9.9999999999999999947759024453118569571484923605709968089152644404488650496325021577106980696364365843e-01), SC_(9.9999999999999999999999999999999999980614459554435257313371264628978585428572878198925323767974620013e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.0221641311147777740227785579903068721089579262042992665342966806745496419579282920602767235563655847e-09), SC_(9.9999999999999999947759024453118569571484923605709968101410762965553419440101158433033420930847019381e-01), SC_(9.9999999999999999999999999999999999945417609478202728628706996422868471504174900062455254746213410622e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.0221641311147777740227785579903068708165888895489234358189858178312988812980330661173776273182432343e-09), SC_(9.9999999999999999947759024453118569571484923605709968233512090308801881881590738801752374644811589349e-01), SC_(9.9999999999999999999999999999999999566113837026538499163423337283644965280394473776776870452571409122e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.0221641311147777740227785579903068682572589562640602762362955358748805636343817443121041437616094100e-09), SC_(9.9999999999999999947759024453118569571484923605709968495117616058018313988361805672820408545230967757e-01), SC_(9.9999999999999999999999999999999998814963452647375052505702102335785204977243470363293385726243258962e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.0221641311147777740227785579903068583408011408523838614916881654413788994554873062618764132297003151e-09), SC_(9.9999999999999999947759024453118569571484923605709969508742364720680672915324752922303082293597506264e-01), SC_(9.9999999999999999999999999999999995904533264318402837201131691789971320634572251207081581633458087340e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.0221641311147777740227785579903067777224452076448765624133453294224583181556076872215376744021101831e-09), SC_(9.9999999999999999947759024453118569571484923605709977749261539157574795263071526724364750908804622089e-01), SC_(9.9999999999999999999999999999999972243453752963013516180184867941168417331097610439599260958484976874e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.0221641311147777740227785579903062444191374105640202252818315911439322845908738689351223806736479555e-09), SC_(9.9999999999999999947759024453118569571484923605710032261612762661579263992209747872198830522639805560e-01), SC_(9.9999999999999999999999999999999815721631602309763287689646995777089907866234666852871659219358506149e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.0221641311147777740227785579903044491613082983178088015336813445010316522065942925692885004303768590e-09), SC_(9.9999999999999999947759024453118569571484923605710215766428664813714117903635912150416810019909636334e-01), SC_(9.9999999999999999999999999999999288822543345027177175435201691477232275835414673167189256780946354535e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.0221641311147777740227785579902967901556657643847233385754180994190739771714537088727060014938699332e-09), SC_(9.9999999999999999947759024453118569571484923605710998642513445201511446119652827662281964189506952508e-01), SC_(9.9999999999999999999999999999997040943144315153243527577576070268129205240226260063439534329271184051e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.0221641311147777740227785579902678091949468060637012897235553227649084652045355768975503761858813623e-09), SC_(9.9999999999999999947759024453118569571484923605713960972366661755272302191335454679464500002902350169e-01), SC_(9.9999999999999999999999999999988535177826366206843962401903522875951551544216082029300763682210597620e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.0221641311147777740227785579901501732676204161366776517368243572780527349225853740498743422149344534e-09), SC_(9.9999999999999999947759024453118569571484923605725985294911007805579273687059282517113616120152451830e-01), SC_(9.9999999999999999999999999999954009628432034923653913680060224216629149490107498280416080699503506041e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.0221641311147777740227785579900899333743109606830790090545333549561186156974009229076970531953334323e-09), SC_(9.9999999999999999947759024453118569571484923605732142800731318450449720066983446006939347375677315747e-01), SC_(9.9999999999999999999999999999936329524579117242747108556071113255727505167004569741349579176077137234e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.0221641311147777740227785579883781432858980376862024126314980254586915881218729237518460302336062189e-09), SC_(9.9999999999999999947759024453118569571484923605907115843568666856562584941625622605585221855412845882e-01), SC_(9.9999999999999999999999999999433927795843233487615821260252844631603136242358546650111699919402800398e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.0221641311147777740227785579802485750163205912214298690901151864692650721960791975715945135743664367e-09), SC_(9.9999999999999999947759024453118569571484923606738091152229756662257850564392286820222209325693133077e-01), SC_(9.9999999999999999999999999997047940646975674911401778180907785960190531120834657549343416362251839204e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.0221641311147777740227785579496430853355382739305693788543093937734027429351004543853164188908641912e-09), SC_(9.9999999999999999947759024453118569571484923609866474528919672137113748671427803376343708669277056801e-01), SC_(9.9999999999999999999999999988065384299375078695054010954455115808598781464087503336228166537987992360e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.0221641311147777740227785578315595448196503582613758108979420835428630067915829614843595874920198153e-09), SC_(9.9999999999999999947759024453118569571484923621936550487957595037673746723527590422830105781902892646e-01), SC_(9.9999999999999999999999999953408462698994121488107222591773651582046608687188220752648103945026583013e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.0221641311147777740227785577861103859325760391822420695463887084256565464211039611805732066542529341e-09), SC_(9.9999999999999999947759024453118569571484923626582200488327975218321223101307794780394947064280125245e-01), SC_(9.9999999999999999999999999940069364553129654899878256180503000246254991478585940379894569887497477979e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.0221641311147777740227785565273105352760973235124378594775037269989494557191010093496289995153324146e-09), SC_(9.9999999999999999947759024453118569571484923755252206047697134357657510575268764867187224409902179850e-01), SC_(9.9999999999999999999999999570617978321167650102705457355036239643017932408333074348850660096985132110e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.0221641311147777740227785494147720075223479280602802330292124947149086097649139888858062409511962260e-09), SC_(9.9999999999999999947759024453118569571484924482270382471876332003554494711447044009299966766777731566e-01), SC_(9.9999999999999999999999997483123912178352766996720923162900119763966549082544858143501452499257965350e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.0221641311147777740227785236051568378505645939056690856193059139393057094426825341813357209171055769e-09), SC_(9.9999999999999999947759024453118569571484927120436668903310947835347857921185200615147603212027568609e-01), SC_(9.9999999999999999999999989908132464907450296535226411384644131371954814862894060757166143711989049252e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.0221641311147777740227784865981569424249069660342444306537403821142970009683063465097545440832895289e-09), SC_(9.9999999999999999947759024453118569571484930903159458230554877366966151610244264345871309538608388747e-01), SC_(9.9999999999999999999999979046765263027957089777786231309365197545169884881526548507696411221188188088e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.0221641311147777740227783366520821597694080392309760396557180338860653301394255166326970401543218385e-09), SC_(9.9999999999999999947759024453118569571484946230109382659009747363270396862916793745245561172647569363e-01), SC_(9.9999999999999999999999935038351090113233798238883887907338503731064453263170285859164067276687677221e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.0221641311147777740227778724777275707359096521654037539794789417941150756566574890533170670019911911e-09), SC_(9.9999999999999999947759024453118569571484993676346967085228490839022178946499104842016330126351835549e-01), SC_(9.9999999999999999999999798805526891086874855481591445556546876900397593704100712282668152972658508378e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.0221641311147777740227730678436474634235619239322916377614180424562255074417094619002647843145436132e-09), SC_(9.9999999999999999947759024453118569571485484788808948819280484389164923628203746973169058744339433454e-01), SC_(9.9999999999999999999998388669737387100202845616569557425809256940044773122692594908685579791930416367e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.0221641311147777740227651129227986322044281658037661014107617373715034102241969959766525552436017233e-09), SC_(9.9999999999999999947759024453118569571486297912284702058638817634236474686819988850060627285648508278e-01), SC_(9.9999999999999999999996053940722735938723791464898039558628335707788702770823561118156067007740790935e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.0221641311147777740226190723115101098594572399666165573233060919552582447798299343636211133048784690e-09), SC_(9.9999999999999999947759024453118569571501225659739222403576805881351656795469835186746330549451679073e-01), SC_(9.9999999999999999999953191760322436725089653169964866473326094969388955496787795926828429358073237027e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.0221641311147777740223111748335715265538817210280356053823988811347115350378470355046138286157290731e-09), SC_(9.9999999999999999947759024453118569571532697835540174749899210195630476335765608319498975918412177234e-01), SC_(9.9999999999999999999862825408608611088025037973920406095113541653179170496073278711934956287391390437e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0221641311147777740205452575545308939402689864474602896345616850202576472657356022571417141428145737e-09), SC_(9.9999999999999999947759024453118569571713203565655288830351306223687211093441296975069534179021966017e-01), SC_(9.9999999999999999999344537623324642963833293419321882859006713356912371610495552047747500748403102291e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0221641311147777740129651266693191643966950947436417946069543471603489344734473468559304762255684667e-09), SC_(9.9999999999999999947759024453118569572488017355657162713723525709519800016848807412636364162921558224e-01), SC_(9.9999999999999999997119807566436969510722402742842555855320720929262505316087415826332266431552052197e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0221641311147777739800638187968409664655891313759345670236465682379122831274410479629017911552530765e-09), SC_(9.9999999999999999947759024453118569575851071033058310203867614751862149115671003622820978088884425159e-01), SC_(9.9999999999999999987463440197158656388716618369174614375272998992497331147687893444050288599726558306e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0221641311147777739221661699795825160496607280776851726203110539011354369865178199026132081928202307e-09), SC_(9.9999999999999999947759024453118569581769161022746462708964520271183698346584973302327059519339165345e-01), SC_(9.9999999999999999970470773250183626366814259010795074887433052608752435579136683041688797055100772595e-01) }},
      {{ SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0221641311147777735348060787581154711370406874911907454974268753223670460471094725822170726226146985e-09), SC_(9.9999999999999999947759024453118569621363720129939654670640056563901072890106103717338918761264994666e-01), SC_(9.9999999999999999856782546644439786288471934899021505153116354410712951491392831149671191440380943657e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(2.8819222563924995443937678136670927577587171546075661726577694028335342498674492523990483662786651778e-09), SC_(9.9999999999999999584726205405478205084209634007503279450517312243145817357777540109405435584199863140e-01), SC_(9.9999999999999999999999999999999999999998868757284550027389008386968063566409637117078118907197067940e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(2.8819222563924995443937678136670927577587110036260124809973070790074572922732249153701069940628216436e-09), SC_(9.9999999999999999584726205405478205084209634007503279450519084908209641729055437995947093049751833578e-01), SC_(9.9999999999999999999999999999999999999998228457407613936739729763130054921218429679447511468273899815e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(2.8819222563924995443937678136670927577585362579311281415358318530955040105257936996716398908971059018e-09), SC_(9.9999999999999999584726205405478205084209634007503279450569445258939236813815709710380855906466883465e-01), SC_(9.9999999999999999999999999999999999999980037922132410433220288395518415303878188778570566577725921349e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(2.8819222563924995443937678136670927577580168867574216311108211240084231468169517151158952331439189589e-09), SC_(9.9999999999999999584726205405478205084209634007503279450719123993422585549935836368575415701910366685e-01), SC_(9.9999999999999999999999999999999999999925972843948451049824895817612405348696082954961484127800792092e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(2.8819222563924995443937678136670927577576550871259968617790226824722822218896082755881706475465921672e-09), SC_(9.9999999999999999584726205405478205084209634007503279450823391834438350142116056613704076933000348489e-01), SC_(9.9999999999999999999999999999999999999888310520064913105158449414864491183642247690373623409855141855e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(2.8819222563924995443937678136670927577456292993530924283051981846584690908873916802972242357682283464e-09), SC_(9.9999999999999999584726205405478205084209634007503279454289130377776957837621095327417907686328838402e-01), SC_(9.9999999999999999999999999999999999998636459841626632836988686327477544647527795330176194796697082810e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(2.8819222563924995443937678136670927577092449780293088985553485519654398240126970385178930711208827476e-09), SC_(9.9999999999999999584726205405478205084209634007503279464774808918451754486664496047503602982822908772e-01), SC_(9.9999999999999999999999999999999999994848954341461445605136270128735817338283756478501243733947654214e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(2.8819222563924995443937678136670927576781212796761607840035866400371391593912909393045397463739976239e-09), SC_(9.9999999999999999584726205405478205084209634007503279473744416816970168165374908585837073625858477225e-01), SC_(9.9999999999999999999999999999999999991609064894328219659726716483975822074816923788130535756497063049e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(2.8819222563924995443937678136670927571824830073443972033393198205511581451136591821861009607772994230e-09), SC_(9.9999999999999999584726205405478205084209634007503279616583513632253796250641569294341006679296995128e-01), SC_(9.9999999999999999999999999999999999940014514982473055058552935289913977188640020350600135457308165637e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(2.8819222563924995443937678136670927562783856595272313701367114315206133953274314115032024457521280443e-09), SC_(9.9999999999999999584726205405478205084209634007503279877137340494225900398176562514894948638422805498e-01), SC_(9.9999999999999999999999999999999999845900524314082848507159562568845086457067518958868870661617658564e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(2.8819222563924995443937678136670927535906407224062231205271442428646578974652485817661791126497680415e-09), SC_(9.9999999999999999584726205405478205084209634007503280651724535873755193912440886199936570843608801856e-01), SC_(9.9999999999999999999999999999999999566113837026538500213522783217109270399941056737067664778738570030e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.8819222563924995443937678136670927246257818833397991863506115497658955223989912573379239550210976487e-09), SC_(9.9999999999999999584726205405478205084209634007503288999171670031009558176981203912735999936785457305e-01), SC_(9.9999999999999999999999999999999996550953510461338422090398420440145868421890571044628665523401179963e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.8819222563924995443937678136670926672655170227378476221834251210231670359640053010203127913293236086e-09), SC_(9.9999999999999999584726205405478205084209634007503305529954063464747586214942756674643863380141265322e-01), SC_(9.9999999999999999999999999999999990579911293756602252336535574564971392011308426888653431764338370246e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.8819222563924995443937678136670924450156853877287215350072253952977259669803660096971263461564802122e-09), SC_(9.9999999999999999584726205405478205084209634007503369580627690306610541408202880105602350019285501290e-01), SC_(9.9999999999999999999999999999999967444329012656361346917078274470831538151138178797214585237081776638e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.8819222563924995443937678136670906381793768622962821939326575141819627152491808173128647013194846582e-09), SC_(9.9999999999999999584726205405478205084209634007503890296804810057484388982260656698913512036780534801e-01), SC_(9.9999999999999999999999999999999779357751952749080870950072893445742772002105971052733244750316186697e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.8819222563924995443937678136670786856684526402984504603089285514740465332136088572546286159978308679e-09), SC_(9.9999999999999999584726205405478205084209634007507334917530039043511511143464325907069992473068581529e-01), SC_(9.9999999999999999999999999999998535134987333437820991172553463396698425678396635503288748695341193063e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.8819222563924995443937678136670384499554905452127237109694299988882821077901398131880075214382265172e-09), SC_(9.9999999999999999584726205405478205084209634007518930537198767244654677472788501036883740767974829586e-01), SC_(9.9999999999999999999999999999994346710451642364336290972629054342050222070904185794081970490900393571e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.8819222563924995443937678136668667946380142528906854118590350909821953241827374244052605332981016925e-09), SC_(9.9999999999999999584726205405478205084209634007568400265185071967774742869063793362360486833142068914e-01), SC_(9.9999999999999999999999999999976477874771338645958100215641553552309309210460132717424144909609874175e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.8819222563924995443937678136662172669780065644836372959362045966473658699582041845363606731951885392e-09), SC_(9.9999999999999999584726205405478205084209634007755589087136941734753021029413188595539452684220248671e-01), SC_(9.9999999999999999999999999999908863872495571475731480763866100785218706844869651779432772488654033407e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.8819222563924995443937678136635807847250507036546506847384632202907111638309723797477345602326620238e-09), SC_(9.9999999999999999584726205405478205084209634008515402775474675257086583626502601397001417650477700807e-01), SC_(9.9999999999999999999999999999634413486426920844331804764834065091078411916109534570183717540735621628e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.8819222563924995443937678136622306749988811501426875611736628802898694589611791966838400985916221274e-09), SC_(9.9999999999999999584726205405478205084209634008904493902316677193513640356158375976695159809894555456e-01), SC_(9.9999999999999999999999999999493870861811545675747695601659494391071907783757480990771450574553740023e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.8819222563924995443937678136238656593828231343420951841560437506542165361603970158167650996120580139e-09), SC_(9.9999999999999999584726205405478205084209634019960993139393017026717323078260979025160503382515464282e-01), SC_(9.9999999999999999999999999995500180657543286201342585040918038314736099827062966990431119956965472294e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.8819222563924995443937678134416639889062073035435082384496717167143094858001198415296008304495025612e-09), SC_(9.9999999999999999584726205405478205084209634072470098069238153543797185811995795079904383089386399211e-01), SC_(9.9999999999999999999999999976533499296954794484000565463325883931610146292464865235185156931131780737e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.8819222563924995443937678127557270288266271986712107535948692653549530026073491349232711445582384099e-09), SC_(9.9999999999999999584726205405478205084209634270151797242793692332754424291330363379899928220353734607e-01), SC_(9.9999999999999999999999999905129391303609969172279880345350282749499073281466661574697777230872060598e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.8819222563924995443937678101092127707077002399382867361235872434760409435679971367967462474296110668e-09), SC_(9.9999999999999999584726205405478205084209635032856631476095689275477385200192507605025604909952321630e-01), SC_(9.9999999999999999999999999629634701717664889884434964562333416295995395342566308697308263330234355885e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.8819222563924995443937678090905962345785939656670408850332804805951243250356009883578051957699615485e-09), SC_(9.9999999999999999584726205405478205084209635326413998096086289249961774788541561690847709778556690112e-01), SC_(9.9999999999999999999999999523599585690193138384676086111155131786468700578965403724005291094635556205e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.8819222563924995443937677808780973687259985636193389265841798824465507609482183206180519564864729260e-09), SC_(9.9999999999999999584726205405478205084209643457036837090960928572445220814856920953298122987625584210e-01), SC_(9.9999999999999999999999996586757815936682626583914766280506019234838400331168951031120746694270853569e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.8819222563924995443937676214703209514204744692795009212335282028037217233717325397737065981919344088e-09), SC_(9.9999999999999999584726205405478205084209689397118706998182424933389277798398951013933984278631390991e-01), SC_(9.9999999999999999999999979992856707357104523313014372229470775460212339581033882224853277679820044880e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.8819222563924995443937670430195542765463770703080331123764598003517802505264600769642924073180362381e-09), SC_(9.9999999999999999584726205405478205084209856102132577760627083827734088481966482314373663268254246898e-01), SC_(9.9999999999999999999999919777759087170701019442593978416399571698979459234780224849424409611209652512e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.8819222563924995443937662136105405768592358666520412217666475621369621365165475299569648643998316545e-09), SC_(9.9999999999999999584726205405478205084210095131362201128621322957623963598743965897900669045962503626e-01), SC_(9.9999999999999999999999833438613901007820841630244038025252650177657065618500849256234287958408322747e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.8819222563924995443937628529861628900185965380533021378737593402628191703856782539416562543954417379e-09), SC_(9.9999999999999999584726205405478205084211063637181144218562737610591044064620159902269306483520092800e-01), SC_(9.9999999999999999999999483607069670501877676370746550685425442859453887132839460223831148833372326291e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.8819222563924995443937524498085285969231986338123534146764673006823572319904316653075123603308610749e-09), SC_(9.9999999999999999584726205405478205084214061752097291612868793873894162363683017509596379799805671993e-01), SC_(9.9999999999999999999998400665542235046114142421706256696630883181278938556965319237218674075886266184e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.8819222563924995443936447672937386777802909492236510751219878611254815402649334649323191142833576880e-09), SC_(9.9999999999999999584726205405478205084245095015697029861035698059754885235842519922498614621813165596e-01), SC_(9.9999999999999999999987191218665130933096807498027739924179257874984640654410574348286117415878749922e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.8819222563924995443934664798596334417258335185973788356139645655672101161148166957023926832399624725e-09), SC_(9.9999999999999999584726205405478205084296476068135328958062259960730216914556232839501383325392027802e-01), SC_(9.9999999999999999999968631998299997554256467627500941593572295577849190457644197015301554208192636407e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.8819222563924995443901933855879768795845276809992031369545162211815523918762408794330084088653092411e-09), SC_(9.9999999999999999584726205405478205085239756391011113405364757886223563861089868522859386398747383246e-01), SC_(9.9999999999999999999627912091883744722490870873583559566519126541217559435220146368151934003243123220e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.8819222563924995443832927196539834685489096471280805393082855645419779179513537998363502905194307959e-09), SC_(9.9999999999999999584726205405478205087228474664921628059219499032792925304756316277172477506834337829e-01), SC_(9.9999999999999999998909572179831628898197144378936152971048048898447329120508434143164034266893512121e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.8819222563924995443437145935474851626763343442080486658635403774537652994253187532574678847289744029e-09), SC_(9.9999999999999999584726205405478205098634582914184277144989291532470413766084914522835024446636835173e-01), SC_(9.9999999999999999994789600586006509138285757895621734642909056578637078558124383183961738379988162254e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.8819222563924995441738270344645041922130085321820250207535694819125184356947723497875274980160260964e-09), SC_(9.9999999999999999584726205405478205147594856674728137260112710269546609474051208170685268173434315853e-01), SC_(9.9999999999999999977104783581715672846610547876785476089129773595271783251945750612384324465931941708e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.8819222563924995434364356925817763649755397547681925012975382611448458940617764048185679572273358093e-09), SC_(9.9999999999999999584726205405478205360105308659024541402713787640535750464383516725028934072767609507e-01), SC_(9.9999999999999999900344419184609625282478583596551119103946719131052064540959650972128486199775946576e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.8819222563924995421388208646640741363019290775557520252742521038843303487105785000232956051189368799e-09), SC_(9.9999999999999999584726205405478205734067813939119484542424577899218832637001515621114858609878521067e-01), SC_(9.9999999999999999765266365808317369481200548678379498027053426819217476346417033639958675984505111686e-01) }},
      {{ SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(2.8819222563924995334572213803910885552897979640202300207439772909318563843591630206579032521264592419e-09), SC_(9.9999999999999999584726205405478208236037291420315785973511871633854189595679855251773516364868795023e-01), SC_(9.9999999999999998861536280964841276179670188840754130029217388695466972886705158646337862189871187961e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(4.7627768395841485291399634056520333905853390937959930959941057659294221005700536473639795358323599804e-09), SC_(9.9999999999999998865797838816041488988492382848663221197878562989779706730272287496519927143373368353e-01), SC_(9.9999999999999999999999999999999999999996910332533889451025539087541978773756220542621035616797826657e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(4.7627768395841485291399634056520333905853113300321985688975054957984612552806501633688919540179241043e-09), SC_(9.9999999999999998865797838816041488988492382848663221197891786250897732587665230469254364501931177229e-01), SC_(9.9999999999999999999999999999999999999995161535683041119286248656467547096995278248086300926430614447e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(4.7627768395841485291399634056520333905845225781631627239224391890934029781271695808578963068202953554e-09), SC_(9.9999999999999998865797838816041488988492382848663221198267451164299995787145432431111045394063126433e-01), SC_(9.9999999999999999999999999999999999999945479266561354969010239868089944507083420072326744698722721398e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(4.7627768395841485291399634056520333905821782858802799169390421862730770669302099399385400361729696892e-09), SC_(9.9999999999999998865797838816041488988492382848663221199383985263313004213884272440988853407530520101e-01), SC_(9.9999999999999999999999999999999999999797815895265073926299136764079516453289466584125051557187254982e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(4.7627768395841485291399634056520333905805452262750538929417081253816798196060527695825273066739289448e-09), SC_(9.9999999999999998865797838816041488988492382848663221200161775109856098204801135107340429369255305691e-01), SC_(9.9999999999999999999999999999999999999694951978254302682057881087623056815473982702463335133062447721e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(4.7627768395841485291399634056520333905262642748113571901321426273286868466275409531709674743767212763e-09), SC_(9.9999999999999998865797838816041488988492382848663221226014580956044692840014313187258652185363363918e-01), SC_(9.9999999999999999999999999999999999996275878192607264518605181786842104414784404875834776162970433210e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(4.7627768395841485291399634056520333903620359001625296434209159907742297269269750473514679322816116424e-09), SC_(9.9999999999999998865797838816041488988492382848663221304232890874043129874726105865566383851036809002e-01), SC_(9.9999999999999999999999999999999999985931385042063172066680615294440475364238048109078992947072718111e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(4.7627768395841485291399634056520333902215524664298599191264311119803018652071392881640680525560430148e-09), SC_(9.9999999999999998865797838816041488988492382848663221371142015326764517802586714904378516344633496335e-01), SC_(9.9999999999999999999999999999999999977082549260061528073028016109168236225183692356344319236878985025e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(4.7627768395841485291399634056520333879843836828090227928492319418091790829954214965125085328233416925e-09), SC_(9.9999999999999998865797838816041488988492382848663222436655582213760977609096174696820256970735529868e-01), SC_(9.9999999999999999999999999999999999836166722696822593142828246167874730693386264352805657565373684204e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(4.7627768395841485291399634056520333839035479669241100077766099659306550037103632078781982057781343620e-09), SC_(9.9999999999999998865797838816041488988492382848663224380266565590207117991060981272443226913654512737e-01), SC_(9.9999999999999999999999999999999999579121146974999224694189577802024920777670685805256806669743527972e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(4.7627768395841485291399634056520333717718394058120046039582352142231543428655188517886620760150663987e-09), SC_(9.9999999999999998865797838816041488988492382848663230158328621535154324702089259588249760727644190222e-01), SC_(9.9999999999999999999999999999999998814963452647375061053459087648547364633122509136386901424011992627e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.7627768395841485291399634056520332410327870887039583466307933849308155205731442137437206471902440094e-09), SC_(9.9999999999999998865797838816041488988492382848663292426421662045406159661262628391280510376689344030e-01), SC_(9.9999999999999999999999999999999990579911293756602297485662152612745402743728874271229173460761793036e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.7627768395841485291399634056520329821250288910768192838406327983092839128998484591796588460285686976e-09), SC_(9.9999999999999998865797838816041488988492382848663415738409095276558440284323067003536126797295273157e-01), SC_(9.9999999999999999999999999999999974271709151312756047649692862056755937082738088260853777748768594081e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.7627768395841485291399634056520319789531326618580367693135512931268016959633739213980700766560293871e-09), SC_(9.9999999999999998865797838816041488988492382848663893526796443500167867451930107221620689557450236920e-01), SC_(9.9999999999999999999999999999999911083451753335956047138007174169300842721460922930881846618711406855e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(4.7627768395841485291399634056520238234130700895833458879586645194588484245356617389260597834401605734e-09), SC_(9.9999999999999998865797838816041488988492382848667777828528875488951240210219318433349946898506981829e-01), SC_(9.9999999999999999999999999999999397378505840878009411491092391118568727790703680362181680872900105130e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(4.7627768395841485291399634056519698732122517440161093280236084419365978162625222650447674638768322629e-09), SC_(9.9999999999999998865797838816041488988492382848693473105223728493681421304402287443501584530428334177e-01), SC_(9.9999999999999999999999999999995999138195485116416392194295164838747924111411338968414496558274653483e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.7627768395841485291399634056517882607621032715920100325014740214505018695163145980556089269471929134e-09), SC_(9.9999999999999998865797838816041488988492382848779971062358456016498287528024787010316425011094362242e-01), SC_(9.9999999999999999999999999999984559648822034048749151181648388526769189191386336567281730186208246006e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.7627768395841485291399634056510134579689415801347150453092174495742110540493234143273308617799446398e-09), SC_(9.9999999999999998865797838816041488988492382849148992342210017177370500854495007543155689208463929344e-01), SC_(9.9999999999999999999999999999935756010571201682857121366624721921559931568965532615916894082992823957e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.7627768395841485291399634056480816766958141678165263160702723485089222671532571207741031634153316029e-09), SC_(9.9999999999999998865797838816041488988492382850545334336847794013560846462890139413186449147433582615e-01), SC_(9.9999999999999999999999999999751087609854148912963654136724607900591786264614614720781652763073714270e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.7627768395841485291399634056361813531652392459441884695892431860681487371901472469744347842572382131e-09), SC_(9.9999999999999998865797838816041488988492382856213192866345844351293845092164545655637136490108793259e-01), SC_(9.9999999999999999999999999999001504503314101192549208788611380347735492328882402855507248498846211137e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.7627768395841485291399634056300873456955585515004997800931057276522204380994328329780145595943153287e-09), SC_(9.9999999999999998865797838816041488988492382859115632630030645556395220404625694916597348877717828763e-01), SC_(9.9999999999999999999999999998617652329995849768393037925872280530385576078211701178186787496077345128e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.7627768395841485291399634054569186859881825280700324684723606663796913822799433843865402087126752726e-09), SC_(9.9999999999999998865797838816041488988492382941592000809642572463819329625493378581247191321760277064e-01), SC_(9.9999999999999999999999999987710024351199186180979020897038970378232714043237160209733920805865006990e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.7627768395841485291399634046345126849418975672893609811927657567481289630585209228299959374964415825e-09), SC_(9.9999999999999998865797838816041488988492383333285626261468880313144103067332952643139564625399433182e-01), SC_(9.9999999999999999999999999935907933129258276352039615791453206930401051283316718370534624928205425594e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.7627768395841485291399634015383902902721245969711480249805308133888217272756254958897883320676685654e-09), SC_(9.9999999999999998865797838816041488988492384807899629646569606968594826164721849183782723072514157099e-01), SC_(9.9999999999999999999999999740887937507957815141336736581392769708464643479196837238055570063201379650e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.7627768395841485291399633895927851701977707093856700717973844940710410678477622369236368097684964561e-09), SC_(9.9999999999999998865797838816041488988492390497324769717365102924175091482701150150500900318210755729e-01), SC_(9.9999999999999999999999998988452613174095572104687122345663360747648579133676239671837024442543978577e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.7627768395841485291399633849950427352014278838835572623270156278473115514806135802142981675207599116e-09), SC_(9.9999999999999998865797838816041488988492392687126888094746041738236925922512434838771472792614663910e-01), SC_(9.9999999999999999999999998698847876912856968817402686696679714720389910427788390589217596034321366739e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.7627768395841485291399632576519272132913485599994320858843661671610808421858913891672932554641782996e-09), SC_(9.9999999999999998865797838816041488988492453337811016918948376906836729261217949213965911993561963065e-01), SC_(9.9999999999999999999999990677700562375098806875009263977879244407925157315862364529263969447948541032e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.7627768395841485291399625381310161475394861281968708737556415048480432404601191218295730000214416098e-09), SC_(9.9999999999999998865797838816041488988492796029564098963838103304952393691985394018445307708995214345e-01), SC_(9.9999999999999999999999945356183180810654277164132742420037484734756712782035416954223292033986885736e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.7627768395841485291399599271704218850626830742743733660772535153384436434794105091284630620855417812e-09), SC_(9.9999999999999998865797838816041488988494039571828840982811721669341014274841201975654781548259130374e-01), SC_(9.9999999999999999999999780895784413285333230312662137236447309333467707070691893999248188530708166885e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.7627768395841485291399561834563911399564094449453959880212782501507374348945218605517763522514359190e-09), SC_(9.9999999999999998865797838816041488988495822619276806883943666606237143903917978163332243669235386763e-01), SC_(9.9999999999999999999999545084985996453745011186391534647771426533060833283555741214471026176163039178e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.7627768395841485291399410145633275233603693330727435148882565499689785552389149215119886118303961366e-09), SC_(9.9999999999999998865797838816041488988503047224533359060402373909730740422168328122566585712553385918e-01), SC_(9.9999999999999999999998589619703377352389884096383310428107333575542415729452708492486530576071062497e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.7627768395841485291398940576079164521698479749771413845295046698755227199537293922380496001723590563e-09), SC_(9.9999999999999998865797838816041488988525411774502282603339187778849287947943732318388831230571743912e-01), SC_(9.9999999999999999999995631873183271375629248169544454257657446928365561386211733317998956925491416114e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.7627768395841485291394080096691718364027522950639324650461725454048575275463263213469170485665173361e-09), SC_(9.9999999999999998865797838816041488988756905561060329695963450218162407043439457786492223277383281056e-01), SC_(9.9999999999999999999965016459836271856025140528459741172270247688045495858786624070651389316059110962e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.7627768395841485291386032714066974077761764310201277061452262507315070646896712213682601461452353955e-09), SC_(9.9999999999999998865797838816041488989140184436904369516788649679768748886709516527943437955996209921e-01), SC_(9.9999999999999999999914327232338598927288952010091871049103089231710195318257092179229846051600946728e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(4.7627768395841485291238294640976911538192710783149084534899778002027207333181167184678510493153798238e-09), SC_(9.9999999999999998865797838816041488996176619165285769622728537940692146017293241117737590051628027959e-01), SC_(9.9999999999999999998983747794758051056176412681764891924749292498353438533149143039388545655872842934e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(4.7627768395841485290926818403657769643397516923527842518553585309526386855039744685745811433036239091e-09), SC_(9.9999999999999998865797838816041489011011537257130018328659246225575915302639323819482058435244070880e-01), SC_(9.9999999999999999997021806802286496807650237625441881458493589844422561919158146850950531402138748111e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.7627768395841485289140375483842262671371188373324115180820058779232965534076960784350535923208009321e-09), SC_(9.9999999999999998865797838816041489096095826894493806925374235804996370151675855606777510471728229079e-01), SC_(9.9999999999999999985769277154236769915899596443318976972391034006475007197492149767871365015030342957e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.7627768395841485281472139088014026847596310324084087689299026278213506906472543755556979323927164876e-09), SC_(9.9999999999999998865797838816041489461316813959563279175249839642631511623271816240877416042972061978e-01), SC_(9.9999999999999999937468233535545381516089346945305567586522815182762523263259918568474370248381050519e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.7627768395841485248188412155238217703456887589218004254327824719886575452373885793240138720061677993e-09), SC_(9.9999999999999998865797838816041491046546451664241035303319676902535869699167930487943441100131837826e-01), SC_(9.9999999999999999727819148219497451979972376981550660324502958086097159778204490543305754095642297756e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.7627768395841485189617806368002957783660747902750390243555201154642723370366857692210046914740733156e-09), SC_(9.9999999999999998865797838816041493836133698902814972812714720652761673376946028637859929719084114031e-01), SC_(9.9999999999999999358891895736578948269198241772952829315555330238321289313236541182004083706262881760e-01) }},
      {{ SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.7627768395841484797755344521761336753630092657204359115626716439741545021919787464944285335480069360e-09), SC_(9.9999999999999998865797838816041512499668274739881593355279162520531809713143546349771725099307094919e-01), SC_(9.9999999999999996890610418073710507466044201240894392618549939258801257618214880154255704169895375792e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(8.8541334264391479089682452838710796124076239811402829583736901454739055881209977828459629139512932076e-09), SC_(9.9999999999999996080216063340647631391452331190013712049207220433871972331669378744024884163886411814e-01), SC_(9.9999999999999999999999999999999999999989322160265823321628084304441224304335345322800638613949473240e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(8.8541334264391479089682452838710796124074456053836048323782281749492463727799185860666389351005195440e-09), SC_(9.9999999999999996080216063340647631391452331190013712049365156708838989481861657988304167124297390966e-01), SC_(9.9999999999999999999999999999999999999983278347232280758021617456947576402797201977299899367543835229e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(8.8541334264391479089682452838710796124023780571753792175678266845941824275650479959136341366664944142e-09), SC_(9.9999999999999996080216063340647631391452331190013712053852031506893212401878910082689723779528026687e-01), SC_(9.9999999999999999999999999999999999999811577245696126621546812821770345625767406512521631340170837106e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(8.8541334264391479089682452838710796123873165218256100187292260562953657308380372366068611833043336594e-09), SC_(9.9999999999999996080216063340647631391452331190013712067187715866281843582288588906422297752417771847e-01), SC_(9.9999999999999999999999999999999999999301255073292639192158867453463983221028539659525333525127146106e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(8.8541334264391479089682452838710796123768244918206545804278303487455545182896078820442499007637194579e-09), SC_(9.9999999999999996080216063340647631391452331190013712076477499224089688440665691276579706732760074326e-01), SC_(9.9999999999999999999999999999999999998945759074995660714315924216622563514137898350238151612656443715e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(8.8541334264391479089682452838710796120280819415597218587174070031906904993060651059297464167459462018e-09), SC_(9.9999999999999996080216063340647631391452331190013712385258806372785600039101470791065512940159926869e-01), SC_(9.9999999999999999999999999999999999987129496540949369376004744419701616934271878571437679938453057820e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(8.8541334264391479089682452838710796109729526437885746009020134635610703028064362130879302411891652109e-09), SC_(9.9999999999999996080216063340647631391452331190013713319484364833863642518609645919505775264783700246e-01), SC_(9.9999999999999999999999999999999999951379099061492584193175985572189778751077955761691769533143188407e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(8.8541334264391479089682452838710796100703790958265353130454286839384537502982126201387774093139105838e-09), SC_(9.9999999999999996080216063340647631391452331190013714118635026916910626244969226887294653027982733630e-01), SC_(9.9999999999999999999999999999999999920797668745560724479867458467101119734226242920787262576045575517e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(8.8541334264391479089682452838710795956970874359359125239042408001738545309974029205516250350028479629e-09), SC_(9.9999999999999996080216063340647631391452331190013726844939240296569896961000297850273249502187903374e-01), SC_(9.9999999999999999999999999999999999433794899497556322815276179600826126789609977036050873720831942020e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(8.8541334264391479089682452838710795694786624382565915203169748645550281629125648187342538473048985096e-09), SC_(9.9999999999999996080216063340647631391452331190013750059082556350592311007013259279581332009562554598e-01), SC_(9.9999999999999999999999999999999998545449635147156476116655627676735966020767280837801139788477430558e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(8.8541334264391479089682452838710794915352427203058231314363107085610402142239333738643566211538870229e-09), SC_(9.9999999999999996080216063340647631391452331190013819071226345919003056268423243469580204326102606514e-01), SC_(9.9999999999999999999999999999999995904533264318402942797088665494168473098099097473981074850292901263e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(8.8541334264391479089682452838710786515670900938843996318872224347171224622601655999124970801465947886e-09), SC_(9.9999999999999996080216063340647631391452331190014562790236077312819648013936021841096093767522887263e-01), SC_(9.9999999999999999999999999999999967444329012656362107528272653614417853100088316564486519790276371157e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(8.8541334264391479089682452838710769881446658099416786494431793772812759408123085644810131337913586554e-09), SC_(9.9999999999999996080216063340647631391452331190016035606644991402861406758161331366125344117718485375e-01), SC_(9.9999999999999999999999999999999911083451753335957698366782734742280036857651229120840445266045118002e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(8.8541334264391479089682452838710705429974086721663347427606689012360968482504999906035184983684405357e-09), SC_(9.9999999999999996080216063340647631391452331190021742226021766019755166635677073282552020915042484058e-01), SC_(9.9999999999999999999999999999999692705877798146209180980202889416039697765337697847566573070366550838e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(8.8541334264391479089682452838710181455400413512864239921708286433768946879981335322103027760587063180e-09), SC_(9.9999999999999996080216063340647631391452331190068135633895407621246050028898343090605287444857610771e-01), SC_(9.9999999999999999999999999999997917350069034595233007099170449693303062076961738535139839024391567717e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(8.8541334264391479089682452838706715279861272005238531471922276780683297726262167817070902226046740195e-09), SC_(9.9999999999999996080216063340647631391452331190375035440925593210805358921401995417900921562182816958e-01), SC_(9.9999999999999999999999999999986173087681510939890725703967634438409829678474189534404127411730082082e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(8.8541334264391479089682452838695047100266764690485973105251123458538453116005753338117883318460984191e-09), SC_(9.9999999999999996080216063340647631391452331191408151630659817233526519261501640108258170968253225980e-01), SC_(9.9999999999999999999999999999946638401340557907902068705705193389311531369534416754397949971069919449e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(8.8541334264391479089682452838645267814025399252193391231391610761187865616878563625763645035454610811e-09), SC_(9.9999999999999996080216063340647631391452331195815676053199378411595122696629096424049469650269894756e-01), SC_(9.9999999999999999999999999999777973833582677083761839003282867801622797968248109465281412093970532925e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(8.8541334264391479089682452838456907652600906277764508374082763528944905521246879493056328469114465692e-09), SC_(9.9999999999999996080216063340647631391452331212493336067980148975477582910497976898386563705056079773e-01), SC_(9.9999999999999999999999999999139762890673116244667382362441412074498611806063432540267177904913471882e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(8.8541334264391479089682452837692339408111212715910642027715591669333663441661466081956482957037304491e-09), SC_(9.9999999999999996080216063340647631391452331280189228571281097872395179001384918627759255178010562392e-01), SC_(9.9999999999999999999999999996549216054525497749419450125046994409842377301546699750908551857759948389e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(8.8541334264391479089682452837300813532278511617430408256716024832631294175412502278116661296908596209e-09), SC_(9.9999999999999996080216063340647631391452331314855452016542920727232708657487746454216181190133667741e-01), SC_(9.9999999999999999999999999995222629283209491907710975058103865056437916859896142418379002215591545389e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(8.8541334264391479089682452826175127931132068008208047076488922744549354520722489181194669299931469263e-09), SC_(9.9999999999999996080216063340647631391452332299938499748177477830573433501562306992191853638161594802e-01), SC_(9.9999999999999999999999999957526047138001717817681444962935908587826610628982162599146333256723086427e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(8.8541334264391479089682452773337445757009727994440521127767195988267674664956710257796866599342197140e-09), SC_(9.9999999999999996080216063340647631391452336978257378882822866917874417712819150609767043015561919030e-01), SC_(9.9999999999999999999999999778498875434179822287521504176714593801678029034816487651111047904678329483e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(8.8541334264391479089682452574418747627839472334610236005101556400781172545186797429375294545797210105e-09), SC_(9.9999999999999996080216063340647631391452354590784321375271123498673675322951774791775873344890407079e-01), SC_(9.9999999999999999999999999104512991501654557927672706922828054197266287565841481519793604528414013684e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(8.8541334264391479089682451806941265813435034021585441597656144334603104741556337828883830192759239459e-09), SC_(9.9999999999999996080216063340647631391452422544264579097889755819457610418095005758362534702005887311e-01), SC_(9.9999999999999999999999996504108937765614607300264816901855676888980217525419793758197109697185621475e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(8.8541334264391479089682451511546955473109841197405995228975813966606873901811280520497644273636894228e-09), SC_(9.9999999999999996080216063340647631391452448698870950740015973038849528651004384903203315100960679315e-01), SC_(9.9999999999999999999999995503239752335493632100628211929463451869771304307041518445712652590272830600e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(8.8541334264391479089682443330046508675482891583751909075505481322277351280455580152733759115162079942e-09), SC_(9.9999999999999996080216063340647631391453173099836794916966822857649638245666253087015449332269808181e-01), SC_(9.9999999999999999999999967782287109922127096816194106902306760260549771017464049733742723066614406730e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(8.8541334264391479089682397102493246466854829836149473491548770490797592999602659488665787003104192883e-09), SC_(9.9999999999999996080216063340647631391457266149082409092023850924426765477362542622576700012797951739e-01), SC_(9.9999999999999999999999811151871565800763397632866039298279906159989204249934323249246980141226165404e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(8.8541334264391479089682229354317925170622589570924131846322771645243978319642169529815401236344789133e-09), SC_(9.9999999999999996080216063340647631391472118796345773727805562353032156430235833192143327694564741239e-01), SC_(9.9999999999999999999999242779449640058768654347516289896817061367090964354071394973738344691134514843e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(8.8541334264391479089681988829355977355619610992766028410873057082154824192470324431160568692000489253e-09), SC_(9.9999999999999996080216063340647631391493415197400525257836644859537210439746900732568935047738603524e-01), SC_(9.9999999999999999999998427821224943822640099962445560074142691610312817642592390164625800399454935943e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(8.8541334264391479089681014263083833246027369508056309470650375280762790683044587199823831576009957585e-09), SC_(9.9999999999999996080216063340647631391579704595465238782921358133130013803796122713538653308905133889e-01), SC_(9.9999999999999999999995125748988600589776353089229934875509268371213651978830681269042654770949272880e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(8.8541334264391479089677997387376800342425725460413079570094827148434092054513422710005508277837334638e-09), SC_(9.9999999999999996080216063340647631391846822795875761490586935023652300294861573147387398681130188056e-01), SC_(9.9999999999999999999984903825865019893319946908188088205383835539155331117110398736637615192810567710e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(8.8541334264391479089646769932231650045753227694158937720392977844970281393217115142797010924837526595e-09), SC_(9.9999999999999996080216063340647631394611743340108805550876934392529663654007202909120311016794830978e-01), SC_(9.9999999999999999999879097462979513917452949848961081265807171892953015199149554881259619812015217700e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(8.8541334264391479089595067361370197575881502627958507194172929637110373615749107194021867640111977216e-09), SC_(9.9999999999999996080216063340647631399189557949081055773150076822286524078714207058364346449326677052e-01), SC_(9.9999999999999999999703916329926793678018862111769817298986764978455514246815942735270910801895372731e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(8.8541334264391479088645884434565332021891073076062911304206133125560487627038935186362608408664153166e-09), SC_(9.9999999999999996080216063340647631483231480749364090852452304932052535761019799455169407706671838814e-01), SC_(9.9999999999999999996487849163024170372705130403489972897352338031814143951856025881392177600435144550e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(8.8541334264391479086644721698480909181809810495652198053668813883906991621689000278850873193904092910e-09), SC_(9.9999999999999996080216063340647631660417099482459208367049121416263417680999542214747742138117380380e-01), SC_(9.9999999999999999989707413496303388340721519420078257627117244044857524396603865672538099374182819728e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.8541334264391479075167239396632952533691297068103740674808287867991199350932853224972272048849116333e-09), SC_(9.9999999999999996080216063340647632676648696484016516910216440084340390416239393480240606438929099609e-01), SC_(9.9999999999999999950818856878525480855738591489530847742490060626019803498300295955884234956520046103e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.8541334264391479025900595305595164845405629143435322937765714093075402853477559942342471423954536586e-09), SC_(9.9999999999999996080216063340647637038783099033400753311777110294761812629629870595272176845473762507e-01), SC_(9.9999999999999999783891247868511027170781605082943897394954430511221748833096102402546474750582444534e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.8541334264391478812060353015667112017147811026535996080503304954066879411703136229450234610448830342e-09), SC_(9.9999999999999996080216063340647655972483470804383968335532665332967605317605638006583542394530767736e-01), SC_(9.9999999999999999059347471563816813703974585533669424697611817767234581766718197928651000679505376365e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.8541334264391478435757766532281791119567941067713974776033624931820469073329402577839965681766241044e-09), SC_(9.9999999999999996080216063340647689290816565184887672975660678196573203012985659183724804645643520171e-01), SC_(9.9999999999999997784340980155919732669734570236830603122846969557594646543331600029736926722238305013e-01) }},
      {{ SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.8541334264391475918132142611819388752102393165033692915673599538981558555025922168953731101952944236e-09), SC_(9.9999999999999996080216063340647912204748485323705100039051208845670299370846463132763015688408791668e-01), SC_(9.9999999999999989254000959293013931271700412167013185716357699584250005008723072462787133791238559647e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(2.3050326092288740033569181029838216941898535036636488497127215277826105837373292871936344335743895559e-08), SC_(9.9999999999999973434123351957641655108356126724149985082438775339749458830259718282159421188380861372e-01), SC_(9.9999999999999999999999999999999999999927632191511183557994183122593964200121186693131821253591667469e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(2.3050326092288740033569181029838216941895387803879315793299872988874079219567458382343020473787996338e-08), SC_(9.9999999999999973434123351957641655108356126724149985089693249473865841484827598087414262535851500214e-01), SC_(9.9999999999999999999999999999999999999886670956369799854044988463671964914776364482608527157520403748e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(2.3050326092288740033569181029838216941805976809826695899140126048975278964994395575472750510702021020e-08), SC_(9.9999999999999973434123351957641655108356126724149985295788506388723666309129389406167136433710403627e-01), SC_(9.9999999999999999999999999999999999998722986845854788884493114329093815800121901031481744345330812085e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(2.3050326092288740033569181029838216941540233536699932875645845363025690659646858121793240299327364662e-08), SC_(9.9999999999999973434123351957641655108356126724149985908335416629127715593029245923975961934901609806e-01), SC_(9.9999999999999999999999999999999999995264338077987706288142057272300188361878665987280080112655044046e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(2.3050326092288740033569181029838216941355113870576134170534247521407373599053140149328043222699929622e-08), SC_(9.9999999999999973434123351957641655108356126724149986335042283654045554271507060777033165528505721941e-01), SC_(9.9999999999999999999999999999999999992855005575931754606666996927182324767815907865680014421638671117e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(2.3050326092288740033569181029838216935201957194797055558913809754941638344393443727753263366345178156e-08), SC_(9.9999999999999973434123351957641655108356126724150000518269071019163603597499360428529132307964434422e-01), SC_(9.9999999999999999999999999999999999912771669863329094278066907394996830421919897947037382758720367316e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3050326092288740033569181029838216916585427959884469187807326758203851357581577783797264089925526073e-08), SC_(9.9999999999999973434123351957641655108356126724150043429976028155347428003603177928927825687293430165e-01), SC_(9.9999999999999999999999999999999999670477537098666404716444383168737808029257997045485448580331021229e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3050326092288740033569181029838216900660567492273295120730967494053065553063846796737687860849897776e-08), SC_(9.9999999999999973434123351957641655108356126724150080137298703418888305134319528833619198411296276929e-01), SC_(9.9999999999999999999999999999999999463215474030430490375505426816001070370882161171454925897672854177e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3050326092288740033569181029838216647060553774981849925239709514641198680468349184324639433206054834e-08), SC_(9.9999999999999973434123351957641655108356126724150664693600022665582320829834967885232053360597754002e-01), SC_(9.9999999999999999999999999999999996162611230490498141591227117409987770862933002305545875365444470571e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3050326092288740033569181029838216184466939424860888630100195381207733290186577598970803568872260432e-08), SC_(9.9999999999999973434123351957641655108356126724151730986965920740676914392042223558395600465768211262e-01), SC_(9.9999999999999999999999999999999990141955221139587188876048622219261656235944949583654932571973388819e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3050326092288740033569181029838214809245954742265419377173811367314349424751787432479877233923908776e-08), SC_(9.9999999999999973434123351957641655108356126724154900916180509965922682277778597602962171472564003882e-01), SC_(9.9999999999999999999999999999999972243453752963018422359883006009686408899733576960095770356938078286e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3050326092288740033569181029838199988984871292614883303374215467059746549187036360988123030153737747e-08), SC_(9.9999999999999973434123351957641655108356126724189062101255147062178168863153998649531416621923954923e-01), SC_(9.9999999999999999999999999999999779357751952749119337135415397346329586077771529539271281380108728480e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3050326092288740033569181029838170639830926741809530958568335571011493362051370422346370989158269400e-08), SC_(9.9999999999999973434123351957641655108356126724256712858150614922702979830843869958098485129944495945e-01), SC_(9.9999999999999999999999999999999397378505840878111582648947317989462397679279124007440589631192681694e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3050326092288740033569181029838056922703945924582953371350616939564370879092524701015723812374360468e-08), SC_(9.9999999999999973434123351957641655108356126724518834544069219311170530229229288816661521658881659094e-01), SC_(9.9999999999999999999999999999997917350069034595547432988650436181647644221125330940261413392968389518e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.3050326092288740033569181029837132430512349717370284170794244713523074906977632069057636054907386156e-08), SC_(9.9999999999999973434123351957641655108356126726649819192675945492171623482838879107836790373471767295e-01), SC_(9.9999999999999999999999999999985885083958419955469220831559843150294661624020909247679534989888611705e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.3050326092288740033569181029831016766925519562232750992177948644066070800320507505566217604318134441e-08), SC_(9.9999999999999973434123351957641655108356126740746623187393076181955987299017720929242370813619334563e-01), SC_(9.9999999999999999999999999999906289720808098742720907229716158920760672342355836143655331519955913417e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3050326092288740033569181029810429621160710161573712440902017379910746505443496719255786045616889151e-08), SC_(9.9999999999999973434123351957641655108356126788200665506226864446252634582417818026829258387594969086e-01), SC_(9.9999999999999999999999999999638348013401669077690243024579178299226548931177229741523212800738340787e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3050326092288740033569181029722599860432517172270613751044829511414889164834463326645861348850036552e-08), SC_(9.9999999999999973434123351957641655108356126990651128045481293169565207020284408985081102515251893284e-01), SC_(9.9999999999999999999999999998495243655009417331317688561903245427796709676759356953926808791320061855e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3050326092288740033569181029390260263829590149913456224351414409283553055449877714086385137998884119e-08), SC_(9.9999999999999973434123351957641655108356127756704735553197802007476906457230123986916422857779626781e-01), SC_(9.9999999999999999999999999994169843720028349941592538225760202828478839826995574233873092437649509806e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3050326092288740033569181028041268523604461953823383997278967298033210221445506810102503263840496936e-08), SC_(9.9999999999999973434123351957641655108356130866174686352525261339132012455099191859878573340985613311e-01), SC_(9.9999999999999999999999999976612715875189483262521423988785668767272054029719295093432855511617270359e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.3050326092288740033569181027350466654197443147635128226423474605049994344377004418410211625135308972e-08), SC_(9.9999999999999973434123351957641655108356132458495521851970115470928880056461360025195819232241699345e-01), SC_(9.9999999999999999999999999967621929367772741946225924242764288467765420502067864563128999844661065510e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.3050326092288740033569181007720488443023505691341050813424692665321294556200991184316214292802977125e-08), SC_(9.9999999999999973434123351957641655108356177706235417060187842614509154144159870398663892478488389859e-01), SC_(9.9999999999999999999999999712137757917274836580961221421196767902045034659261072139007454375760673223e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.3050326092288740033569180914494543814489619553184194488716404956513798745406664282923586874560335800e-08), SC_(9.9999999999999973434123351957641655108356392595077811996239503526868390917331556904475963601561449150e-01), SC_(9.9999999999999999999999998498802064678795413484501746926129232251926979707006267863768144179071722611e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3050326092288740033569180563525637262939040546898057842835900463712130133522736435890518017375558907e-08), SC_(9.9999999999999973434123351957641655108357201589852238721937238654545656435722777384791657321513478687e-01), SC_(9.9999999999999999999999993930941655940840769424730197440877618183673004054802495568807642620449795820e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3050326092288740033569179209400886152681773886767321934547610892932911998098818689355504267123203173e-08), SC_(9.9999999999999973434123351957641655108360322891560511798673301920802715538520216011605741403777091156e-01), SC_(9.9999999999999999999999976307007673116191718623322642009286202072493750628018743115740692728657137089e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3050326092288740033569178688211982963846204285654125432586546044098171572499388964189604648509058321e-08), SC_(9.9999999999999973434123351957641655108361524248977930295655900735364742735521391891431924510957287249e-01), SC_(9.9999999999999999999999969523733964508734122356626501843749396315139728631602016872313338809424944338e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3050326092288740033569164252906037521887384643497458231108320425650491205985670687250021963775971883e-08), SC_(9.9999999999999973434123351957641655108394798099906369460752916458830513392941920380883367319581051924e-01), SC_(9.9999999999999999999999781648223384146705773976327500723720699150992758122725248634223825439970777452e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.3050326092288740033569082689765047852855223809605531101633991750019390410944162480572206776327501281e-08), SC_(9.9999999999999973434123351957641655108582803799598688844551140409031441391091741301980621292503541198e-01), SC_(9.9999999999999999999998720103922495208031780838389231646522367516006428938271336698587564652589687208e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.3050326092288740033568786717620537323519352210844379188630264599801475349647042222091045538661626338e-08), SC_(9.9999999999999973434123351957641655109265029244118859818421708893774744014140554410141745583431432601e-01), SC_(9.9999999999999999999994868026385819352435406147723010892486651478667106240700739674518742653615294803e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.3050326092288740033568362339300715619847002109287518546008952559829009023684632406666407615330889289e-08), SC_(9.9999999999999973434123351957641655110243235109957647273988158461472423796287777163980142500206950499e-01), SC_(9.9999999999999999999989344742444552135674714342920078298901794099170363644071131460666931767933431315e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3050326092288740033566642830465632003857432938244002153335937059064773092361790347930531429952809050e-08), SC_(9.9999999999999973434123351957641655114206759046682537295416670776479532208069869669756099335381479988e-01), SC_(9.9999999999999999999966965334515149423921951965446316148261727882896036822079951144253428566846102422e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3050326092288740033561319904174350374434275012839537014584145889988215634456548289498139090640738434e-08), SC_(9.9999999999999973434123351957641655126476277724608408227811397415480911472215581814997369138591897659e-01), SC_(9.9999999999999999999897687447469607417747458765343849524801920657752153278543760846722340091981890354e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3050326092288740033506222691646023496050595575136474827988363123959999383083780132428533334549145326e-08), SC_(9.9999999999999973434123351957641655253477149280015552457234612442912479287163605988280700683247640873e-01), SC_(9.9999999999999999999180597212289475432785927605626713332501011942789496875196521271097405584603894210e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3050326092288740033414999518903535943315189771401403757641387891347279737858720104034101328215406856e-08), SC_(9.9999999999999973434123351957641655463749537168767989893157737156568318383573341780867443198579992457e-01), SC_(9.9999999999999999997993327595661291877814745490172533782687408692303257715898944820439387166718282707e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.3050326092288740031740276644326005026903627169834177521852334705309376977331819281467611299764914517e-08), SC_(9.9999999999999973434123351957641659324040374491495405099474277712778104230050133561581709096805654047e-01), SC_(9.9999999999999999976196808953725985378419049520770602512495101682175257311240184405476635363144084316e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.3050326092288740028209457752382612683862057340124611212640154211823561772456661468832408153056095505e-08), SC_(9.9999999999999973434123351957641667462693057702376953653874330001967302215221827752093921278913483386e-01), SC_(9.9999999999999999930243200169970946045905869824297953553143821833837967488024916294299766287744876219e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3050326092288740007958775180407577507671501580016958719405240241859081791549717027539220324187424553e-08), SC_(9.9999999999999973434123351957641714141176745247689728843347781219463234640014308165600987723758983090e-01), SC_(9.9999999999999999666680561304531588008921690304348624640871323159657723565850186682010014340332749633e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3050326092288739921033511900895340221098927055636402240391902735775914901465210440672386701510101990e-08), SC_(9.9999999999999973434123351957641914506743170328663917024908323424168658895394225905063251966804017362e-01), SC_(9.9999999999999998535348237438724258560143069738531915557415473639921423490384123549045359637543561592e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3050326092288739543737276207259132909466675839635171681695926324716637343993089478835737179117551674e-08), SC_(9.9999999999999973434123351957642784186869783463375142718090285347794241198075075083993573173785328090e-01), SC_(9.9999999999999993624837633167616030412372148862144576593905643833136148586888515830377842435918785023e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3050326092288738879795130231457182099436346606550290454646570058726447764611070994958731205656767954e-08), SC_(9.9999999999999973434123351957644314595166899084445635934225758419851896397848238323141742399243589266e-01), SC_(9.9999999999999984983630433093548587528244734272145492402806064054336268981211275582602980786469075297e-01) }},
      {{ SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(2.3050326092288734437737542664961997432338568416445109782736057443365003214594648131985103286226755391e-08), SC_(9.9999999999999973434123351957654553682758312401526339910151363051623876406840998050557310735110764520e-01), SC_(9.9999999999999927170249792211308460553589011877428489444219410461884118665513398622904776147812361375e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(5.9392490925347339368984284437226427168632351439412322537004869915500826033302626413620842380097984833e-08), SC_(9.9999999999999823626601084126541648835308088414680992100413858885402740815598978051202822836025045974e-01), SC_(9.9999999999999999999999999999999999999519543189770622208567888719815946857668660973679333387764133062e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(5.9392490925347339368984284437226427168578513024922390510589691504187900096033159609447605136795426745e-08), SC_(9.9999999999999823626601084126541648835308088414680992420173613288240963151385325594731494323419305776e-01), SC_(9.9999999999999999999999999999999999999247597627371478534003969670338901609540609309055070730960157091e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(5.9392490925347339368984284437226427167048995976400629811929303815966749712390724744259248202947499761e-08), SC_(9.9999999999999823626601084126541648835308088414681001504356355737528829902550807841695913510666557501e-01), SC_(9.9999999999999999999999999999999999991521787387600918594925497116812465842701664658562565457618314711e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(5.9392490925347339368984284437226427162503035257765170581127329508330559929136741335203251073169941510e-08), SC_(9.9999999999999823626601084126541648835308088414681028503949428591774637607739271355194446034258296268e-01), SC_(9.9999999999999999999999999999999999968559487030391864217013940770419594432090328042501079296134571431e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(5.9392490925347339368984284437226427159336269376755375758427881820476051996531606512660169050875581420e-08), SC_(9.9999999999999823626601084126541648835308088414681047312160813649188940901417830592595427726275565698e-01), SC_(9.9999999999999999999999999999999999952563697840524961026067589613318533082549259226886144264948095368e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(5.9392490925347339368984284437226427054076752495745864704987022746508525718124278544606049080929011772e-08), SC_(9.9999999999999823626601084126541648835308088414681672474650929830537986555372019310432905518882162786e-01), SC_(9.9999999999999999999999999999999999420882763562246046193812165493239534195003949210626103643023683236e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(5.9392490925347339368984284437226426735611454678511435123271599059929655565114684972401960712520998750e-08), SC_(9.9999999999999823626601084126541648835308088414683563919381994647244303597693233849255916439752160510e-01), SC_(9.9999999999999999999999999999999997812268814952855214801708223717456631194917908356542947276124470968e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(5.9392490925347339368984284437226426463191425814870842907745989524807541345990491597074166826129854429e-08), SC_(9.9999999999999823626601084126541648835308088414685181889791211313511627642670204706785606447565589729e-01), SC_(9.9999999999999999999999999999999996436236131598713085126492693319640612172214927113929791459634625964e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(5.9392490925347339368984284437226422124960444313061534520914195259018572154495780369382785838861226178e-08), SC_(9.9999999999999823626601084126541648835308088414710947724211302048018812402930931585017964718834260229e-01), SC_(9.9999999999999999999999999999999974523208505153317395469332722390492063381799849951914744825292875666e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(5.9392490925347339368984284437226414211562017387974101609575869682860014711255472985086021290370647973e-08), SC_(9.9999999999999823626601084126541648835308088414757947368637282747496697515088042219479532148990805723e-01), SC_(9.9999999999999999999999999999999934551496743450604207094281998390504600757088426649577276358516575873e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(5.9392490925347339368984284437226390686223060536515153410959449464728101777520425980292058461924808352e-08), SC_(9.9999999999999823626601084126541648835308088414897670216688335045784864740877437173155454529250171756e-01), SC_(9.9999999999999999999999999999999815721631602309979902191641894579086709191855492790391884856169142335e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.9392490925347339368984284437226137162120897670397156306778289726464449139486341506703739732398041215e-08), SC_(9.9999999999999823626601084126541648835308088416403413010394823470194663575292187265334593849605850200e-01), SC_(9.9999999999999999999999999999998535134987333439539357180450575111994491555475083475565473090564116931e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.9392490925347339368984284437225635098232742466688095838394461160851520440999770962153713375146325109e-08), SC_(9.9999999999999823626601084126541648835308088419385295502515082513042349962806422468192279261680845636e-01), SC_(9.9999999999999999999999999999995999138195485121090444253959869133769894446643573037593301683611069101e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.9392490925347339368984284437223689786179465084151732069815455491932531474757391423066677396886037402e-08), SC_(9.9999999999999823626601084126541648835308088430938988349639677116663274395191029452447548933912271024e-01), SC_(9.9999999999999999999999999999986173087681510955787399126128065452798448271391025515570753011617571100e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(5.9392490925347339368984284437207874879039080690082271652559893075824804788379011312028376137283129464e-08), SC_(9.9999999999999823626601084126541648835308088524867661231688939346729975156306231200118396929906210184e-01), SC_(9.9999999999999999999999999999906289720808098836310938808152269699857188043519695276972038619983794445e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(5.9392490925347339368984284437103256740988009832758607035445003678633746515650386078245120192715402045e-08), SC_(9.9999999999999823626601084126541648835308089146220842714186143066724454569626466476302138915326005392e-01), SC_(9.9999999999999999999999999999377848483097243709497185996307786336562368857646712879293577105182031021e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.9392490925347339368984284436751080917854368283069335964835850360794473232878826697099407293427500174e-08), SC_(9.9999999999999823626601084126541648835308091237880780673343365228623659605206411465654405670015077881e-01), SC_(9.9999999999999999999999999997598957830524825764772617162849790634913032266197187064723094447201427190e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.9392490925347339368984284435248613376532788683013765506771867408262318973385169261888673539264119742e-08), SC_(9.9999999999999823626601084126541648835308100161409762030443607028751790725503984329739737942958217709e-01), SC_(9.9999999999999999999999999990009778535737768855967278439827552318015738602267510070102019878823035635e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.9392490925347339368984284429563416781985734833810562581281290735062597696559023042840150341156304159e-08), SC_(9.9999999999999823626601084126541648835308133927208477075652443114529074941704841241048508650867956806e-01), SC_(9.9999999999999999999999999961293034183191607278064057295510992810669491997505850367001310758660962846e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.9392490925347339368984284406486770706727012928424364177987829744922767663711027623894421013185865602e-08), SC_(9.9999999999999823626601084126541648835308270985157738301487724758378026535495399536182610511047073616e-01), SC_(9.9999999999999999999999999844729581216058214067154024458462629402747588919132667776232897363279231815e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.9392490925347339368984284394669507655307239539978906442660921725384203494428390635432452078776987658e-08), SC_(9.9999999999999823626601084126541648835308341170826592690741516628567519783278939088954001793744355695e-01), SC_(9.9999999999999999999999999785038888669049139617375092711413805769685510679713833671393290740738826982e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.9392490925347339368984284058867555622077753195012280870779844506826479097321416004736289999909195812e-08), SC_(9.9999999999999823626601084126541648835310335582265477444739558747149358356230429870839724664424467152e-01), SC_(9.9999999999999999999999998088855010195362012690435345634310709057832163759522843259635990825384885639e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.9392490925347339368984282464089718905809962677662117363434428054995085716007719155560341104788491149e-08), SC_(9.9999999999999823626601084126541648835319807365084989061012828710793876985221050127091277732702186008e-01), SC_(9.9999999999999999999999990033403158272842244696042465354531453238548150081629227884584923708126661553e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.9392490925347339368984276460209192136207944290385180589282562511136237825947563091144781381687932028e-08), SC_(9.9999999999999823626601084126541648835355465907055292443056666506215744060695152427558905543358594571e-01), SC_(9.9999999999999999999999959706940503341716339508693977047863085570495545737367383431813155643131514033e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.9392490925347339368984253295754813857924229181780501720460682723497400700537675633625736354362590207e-08), SC_(9.9999999999999823626601084126541648835493045371700544226674322417272262841005371594705004545365747235e-01), SC_(9.9999999999999999999999842699955189013465932001281421724275293317496150518461551450070522837458881109e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.9392490925347339368984244379990915085756451594420724352506181615168724880517987268394277836820537208e-08), SC_(9.9999999999999823626601084126541648835545998314345580858987181861792397573928396836175807325108722126e-01), SC_(9.9999999999999999999999797665151496512672575460944448443980991599884804476562710089845695917435958559e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.9392490925347339368983997441157742208672016780389060803067826541408370757506077953982409354045020349e-08), SC_(9.9999999999999823626601084126541648837012629555179179722927260218085261040048161811016375459124388013e-01), SC_(9.9999999999999999999998550341646493511604466500892578790839616556665193640278310225880785724407544709e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.9392490925347339368982602174099182676126730727059206526361154099764624927060214525783872466183570735e-08), SC_(9.9999999999999823626601084126541648845299468166572505483488914483200745200132913147841657667650112251e-01), SC_(9.9999999999999999999991502647383358645162370832661156639227471616268696922080923488631959818690548795e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.9392490925347339368977539100528498712226148918365352629143987515671992532207504464108328892666288670e-08), SC_(9.9999999999999823626601084126541648875370323276693886199225526887897859846643155345138926772350687374e-01), SC_(9.9999999999999999999965928335756752839918453116980161751591672862666170368777117428701124587908609453e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.9392490925347339368970279435404897545176479134644066163392162470182976085221174518185305793741326348e-08), SC_(9.9999999999999823626601084126541648918487282774148250728064019759324529392333603084109112969178367775e-01), SC_(9.9999999999999999999929258724781556738529177456813685670953702847023445314591815883649676105202852400e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.9392490925347339368940864505997040019059290062746569925069524885409964252786317338835460948106778392e-08), SC_(9.9999999999999823626601084126541649093189875566739629519614959070420208255642580905548825940121931430e-01), SC_(9.9999999999999999999780679692569402442300265013064971570372466425859178157576733825908198131987699285e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.9392490925347339368849807398347073121861444943772659094897216278741646737071381355664421948639339186e-08), SC_(9.9999999999999823626601084126541649634000719545644057033882023054240208040243552025662346401766613673e-01), SC_(9.9999999999999999999320737166681306222758046040643977416511956004359623278698439732075372267030870083e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.9392490925347339367907282077148797204442304085965117061712515614899191872934513864347901157235423238e-08), SC_(9.9999999999999823626601084126541655231893378163522800298248387460995280333946770846116917329034538910e-01), SC_(9.9999999999999999994559906429427136229143769364723425952028855155249740194855421191953590482078085308e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.9392490925347339366346764834182389292467142661746776091236438803619195121286364687319844173893493476e-08), SC_(9.9999999999999823626601084126541664500193997336582253454645497184310844768074799817844076522836402742e-01), SC_(9.9999999999999999986677509756110898530352971832787543654029019152262997652389389609336337107369615142e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.9392490925347339337697970406192836010879858614998566044159512621383737332091547821849811607674724242e-08), SC_(9.9999999999999823626601084126541834652520305987978653327554973023832914727909864242114546104366084903e-01), SC_(9.9999999999999999841968335338762467481561993888301163770764599754707994341758623881149185074694755289e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.9392490925347339277297705900780051502593970281523194669024989333080442279491784680463520816502287630e-08), SC_(9.9999999999999823626601084126542193384736458619391694864843669367938043381671438303161409970623886827e-01), SC_(9.9999999999999999536877926276787631334960546870434288985588529648484656913003106513691288893822619646e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.9392490925347338930877620023983677944369332776237006109427317081845711966951580746538887002879820358e-08), SC_(9.9999999999999823626601084126544250859917138190473223391304725718649973288882658177747886271953932422e-01), SC_(9.9999999999999997787060329071317255432323035447851404707394977956242119494602872343353017265141932236e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.9392490925347337443882944011198960010439106903810652538579480352024950648208329839316293635588603100e-08), SC_(9.9999999999999823626601084126553082491697251118207800546230155540137508099063094596857466425927823906e-01), SC_(9.9999999999999990276036698751558068778177268463046107151131739474110135844605872775801015688710450933e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.9392490925347330989631641348363271239542502811846788991699353474581910890427060639134430047734297490e-08), SC_(9.9999999999999823626601084126591415897889582553747837641170396655247857205255500510978507287689840137e-01), SC_(9.9999999999999957674686584767796524823243854459064289959166741521393585483588057233391515425043759465e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.9392490925347319631846815642622439499734718009014549822082854549108785381251314173581414885315662542e-08), SC_(9.9999999999999823626601084126658872611108860249244876145584950016688476535246565595419186258292443884e-01), SC_(9.9999999999999900304884533620746744395368465800054953030815883351146146312303612831065517732773229011e-01) }},
      {{ SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(5.9392490925347243643397266587270805230024846048211419922110620093211563709414605666869759177741889575e-08), SC_(9.9999999999999823626601084127110186941136209015989380154898167647750026409555641358058095249233918969e-01), SC_(9.9999999999999516476314464545235306989811486638040330556636280374342959470770590625081711201982913748e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.1667648891489053215009847934842258955980974124677123114429557676509936765642358291735237156241336383e-07), SC_(9.9999999999999319329846724669022017019967341198955373940593426943124532306101349357838754575134804672e-01), SC_(9.9999999999999999999999999999999999998145794021824151034992276546952063579470128425871265144837910845e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.1667648891489053215009847934842258955940156502946425593198736008045051176468887238363950296254491813e-07), SC_(9.9999999999999319329846724669022017019967341198955378703050216337081182745017901736958240464960405068e-01), SC_(9.9999999999999999999999999999999999997096286393244275505267068708858024015226656760246899478351645257e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.1667648891489053215009847934842258954780552363250056593828209354969702513594221583492471553184767480e-07), SC_(9.9999999999999319329846724669022017019967341198955514001589767282571768416989514908478592083127154610e-01), SC_(9.9999999999999999999999999999999999967280404449567256602953779767272513642826329383296896936334511453e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.1667648891489053215009847934842258951334029898318041593648903720322908808704964940378393576207917041e-07), SC_(9.9999999999999319329846724669022017019967341198955916129729941846749927806159060404736153902129642789e-01), SC_(9.9999999999999999999999999999999999878663001826676768945647883125443218206831309977478477928220369084e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1667648891489053215009847934842258948933144711312600885957470723023745628170949373881560750953555748e-07), SC_(9.9999999999999319329846724669022017019967341198956196256583849413841704059358485934684771170311742453e-01), SC_(9.9999999999999999999999999999999999816931151408463493158022748508127895283907156125683209694551116137e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1667648891489053215009847934842258869130587665200731695908960081383342130799000295469791473072747256e-07), SC_(9.9999999999999319329846724669022017019967341198965507338746420068054527430686992535032169173552966857e-01), SC_(9.9999999999999999999999999999999997765038149100416831656707157320637967428984916652321179007384141744e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1667648891489053215009847934842258627685957770153133593133980665145035680114873452774210778978079915e-07), SC_(9.9999999999999319329846724669022017019967341198993678250429929628074446086529855441319914623154362719e-01), SC_(9.9999999999999999999999999999999991556984612166262947832446823698317069706335425591086224983764511588e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1667648891489053215009847934842258421150572295508909015353918266640073233700290594972921380352710939e-07), SC_(9.9999999999999319329846724669022017019967341199017776074043794761999080649987720644715597027248174587e-01), SC_(9.9999999999999999999999999999999986246521791538321140093089839324410262526032794132766483926112491627e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1667648891489053215009847934842255132118514777407670189754829300268747631146296790579422445972624705e-07), SC_(9.9999999999999319329846724669022017019967341199401528786443527712425345438067349656944088341653514567e-01), SC_(9.9999999999999999999999999999999901678531579286843247844742186526937887456902581105156638999354744039e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1667648891489053215009847934842249132571413424185037086397400519451069427140645236224735165905840004e-07), SC_(9.9999999999999319329846724669022017019967341200101534877308935381687120025495954319247999142062675369e-01), SC_(9.9999999999999999999999999999999747417450607020053360449274025997088596471044643048445829829136382687e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1667648891489053215009847934842231296823542231304627066474379147971418461402474089476440365802408973e-07), SC_(9.9999999999999319329846724669022017019967341202182547316090968064533441856468444880547247825676367988e-01), SC_(9.9999999999999999999999999999999288822543345030404109540689541271172844228373367259036764063881370048e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1667648891489053215009847934842039087394647668632212427575676110678745311162086883568793923335165031e-07), SC_(9.9999999999999319329846724669022017019967341224608868615845002312656511665582975901871759504874941311e-01), SC_(9.9999999999999999999999999999994346710451642389974142975213906820960636379374445956565351614059630902e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1667648891489053215009847934841658447398735556358309747060301320333509931801144888851034884058655532e-07), SC_(9.9999999999999319329846724669022017019967341269020606879448849808405947176818255397645520546374006906e-01), SC_(9.9999999999999999999999999999984559648822034118697642670018561334024590498744684299775778505269027863e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1667648891489053215009847934840183608061598476530676813261559065636727336357731287918603258445366764e-07), SC_(9.9999999999999319329846724669022017019967341441099682450169015952410920161197727026903140647299692453e-01), SC_(9.9999999999999999999999999999946638401340558148651946047567705030830845056234360242303739561838632655e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1667648891489053215009847934828193528051292206344357658886743589301111128518963598083379839657673447e-07), SC_(9.9999999999999319329846724669022017019967342840060119861328629128750878034527981781635225654422106137e-01), SC_(9.9999999999999999999999999999638348013401670654744316922732516978426177414017427009262261336925563479e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1667648891489053215009847934748877232696103813592454820116941209684051311937090005831791112343161288e-07), SC_(9.9999999999999319329846724669022017019967352094406975641213531045050215975771300008788831709701837629e-01), SC_(9.9999999999999999999999999997598957830524833837024438139658451770412376016015958092953747808829656450e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1667648891489053215009847934481874950634952364767299811340186181120306531842745078965103472502399490e-07), SC_(9.9999999999999319329846724669022017019967383247295778799837784709370916435178396458929578732180700858e-01), SC_(9.9999999999999999999999999990733762848802769686281477679050533338934285198759395857975710003602129690e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1667648891489053215009847933342778408782224192324924439168123180532060501681987615977634029368548243e-07), SC_(9.9999999999999319329846724669022017019967516153080817270720159934246950567112036678156809229825432235e-01), SC_(9.9999999999999999999999999961445174742154051714084301875704217148541187537855096059097092400694024072e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1667648891489053215009847929032543676586187857396475419534581990315658212549860689876250787385723628e-07), SC_(9.9999999999999319329846724669022017019968019056135768921138181441265103205309538697382891252120945216e-01), SC_(9.9999999999999999999999999850619897800366537386356514085909706400048252802134135093391024631081738745e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1667648891489053215009847911536972545136151913381532317733777620652078089146068788547876729151457865e-07), SC_(9.9999999999999319329846724669022017019970060377946947243956993394371848337031533829089368415074808559e-01), SC_(9.9999999999999999999999999400771656029596462132155854082381166377843035855829041461894804373462135765e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1667648891489053215009847902577708463999396380047940009733278830565248055133343959157340302720794943e-07), SC_(9.9999999999999319329846724669022017019971105713423195580638488382622549748746851072611840267878488728e-01), SC_(9.9999999999999999999999999170409973968557584343607852474403680930842114035832845519902699695157810519e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1667648891489053215009847647989285227921668367686165032980769628050768350056106529279780532603832282e-07), SC_(9.9999999999999319329846724669022017020000810196764759465041251914736143272209017293844039582768434719e-01), SC_(9.9999999999999999999999992624401632344886083373218220232239390606945954765251975780095954962027272239e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1667648891489053215009846438907645281824863768368027568300077601504182004312662800221380829275383904e-07), SC_(9.9999999999999319329846724669022017020141881597325128854724039285802370022242754874876020537873014977e-01), SC_(9.9999999999999999999999961536348215823345292093171053573582920473772803689128464496666682738204352897e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1667648891489053215009841887062525403518554932903247618543559292911594144994905529662255117354739849e-07), SC_(9.9999999999999319329846724669022017020672974903996912241211121537209790414118150553427980005002962111e-01), SC_(9.9999999999999999999999844498755752821109090697505791999572940678432515960269259338708291551374737303e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1667648891489053215009824324919483702723218122371637399225027352645759580893527121412895707111013620e-07), SC_(9.9999999999999319329846724669022017022722064091923650928573254886982625469118890732918720804524510710e-01), SC_(9.9999999999999999999999392938808970958687504761011729457076667881078317971243170715835542942940393464e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1667648891489053215009817565428482563644962904627728510989097751359644354493467083096086339187208330e-07), SC_(9.9999999999999319329846724669022017023510737768788362266311485485756227450378974832092377679991803678e-01), SC_(9.9999999999999999999999219137958499623473836014358012161493624582104854240890708263319642557884861806e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1667648891489053215009630348624671314496039615729291454236779256101880353155928839487671162988922551e-07), SC_(9.9999999999999319329846724669022017045354537103352957806206314197552896637668126811954258517244986810e-01), SC_(9.9999999999999999999994405396847011053395844238947397134045523438964312654277770156719238136098706159e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1667648891489053215008572526184149108647950811992179926661630621739828882856212499373187236131029379e-07), SC_(9.9999999999999319329846724669022017168777545358865397807517825483014819699437351674100738601228380122e-01), SC_(9.9999999999999999999967206538267357473277888107689339906705299995384756495713330006522077138572169583e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1667648891489053215004733954343562742623480940246117743770125478140100511273943447634567378369222014e-07), SC_(9.9999999999999319329846724669022017616648630166054528680304725175003972206221300424915897570541271566e-01), SC_(9.9999999999999999999868508714662472956466802703213112702699385122447798347479388747124949224353338883e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1667648891489053214999230035483505984966394051818744321371397329292681192040684349507761418891909758e-07), SC_(9.9999999999999319329846724669022018258826558029928118677654548589205851912282914450175550855676924925e-01), SC_(9.9999999999999999999726991286997891869462074871935997473736972710130995101576244882136837183815239520e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1667648891489053214976929091572358225539653352024180023743427136947963267525467591349238367985149493e-07), SC_(9.9999999999999319329846724669022020860822393070572890982308845525630962805103619176725979721250650641e-01), SC_(9.9999999999999999999153586718899809846367040941322485484013347658260480960772868024813720567027814869e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1667648891489053214907894098414400447823528115913082892997496460813005829265208945882068721687196666e-07), SC_(9.9999999999999319329846724669022028915583007004632100751723299571667464442788779878635015213124627369e-01), SC_(9.9999999999999999997378550622082170136252649509192643352698093644758233825995519161351205013162641214e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1667648891489053214193318039725492715779176538724988506211699134584676295338092625588475035025178043e-07), SC_(9.9999999999999319329846724669022112289808597467708927534009121067834442200524341778591565854415036979e-01), SC_(9.9999999999999999979005284542482638036123968859275207314080991708558300887607268773826465345205224663e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1667648891489053213010211086612203603142699170642736300252216873169606767717817746857204044770608679e-07), SC_(9.9999999999999319329846724669022250330573897521238228522914257388920916701116011959677480263339364048e-01), SC_(9.9999999999999999948585095416557507482992244136803439536457229266878604924292248879511097347183803783e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1667648891489053191290112805841512858375763263652342281052106690909645635693146065087403465219061958e-07), SC_(9.9999999999999319329846724669024784555380184212889027506580893209955368870571913432094013679863344278e-01), SC_(9.9999999999999999390115300444896021538492738163468710010013463119562771059743765776384626179676855666e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1667648891489053145497621099440080198995280341545003074145525016442341573061438113111410816225415551e-07), SC_(9.9999999999999319329846724669030127462531151412621868774107922913248712196989049461685784554160716899e-01), SC_(9.9999999999999998212693213126049470713585746227646553727652316331162865391432415860665605147328347120e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1667648891489052882859054210010913030216828310903355945261993481959874736777572120626813495993188674e-07), SC_(9.9999999999999319329846724669060771208369448838451866598956491231290480330948109563874630876180497041e-01), SC_(9.9999999999999991459698603877622232637633710878481571725729909671554344826759796002135922498494311161e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1667648891489051755493273176447072670717276116508260399488513713781207027312034969893028903572590358e-07), SC_(9.9999999999999319329846724669192308289423239242040743096928289331227490072441079427799556113222271577e-01), SC_(9.9999999999999962472733238749384422970965768757757599635025330666384174798629655968531799115371160294e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1667648891489046862199317125440755024556694521491354161201697624160772509703061122565393668811817136e-07), SC_(9.9999999999999319329846724669763240647443729014493966705852363977926545955101459747443915045664551496e-01), SC_(9.9999999999999836655766987208579146602802040142454620588271990681072331679434099761085712033180570671e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1667648891489038251288889943239167752811894722748367153838756954161625765568707773210439624545921478e-07), SC_(9.9999999999999319329846724670767931442447974375683073579915163592952031321850626688743091611773668023e-01), SC_(9.9999999999999615250996224948944509039314474257267912400087023361825188641127477992106149009746411381e-01) }},
      {{ SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.1667648891488980640606647888142365830331917649771691767589810068992566817151125814978286756205585390e-07), SC_(9.9999999999999319329846724677489743570442417244709076104730595808659584871115971636470773824443546547e-01), SC_(9.9999999999998133958163936881497442222871595788564025195624873791580406848800097877313533660170298687e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(2.3799674409019419693519798023370504567319960022721346816037962173892841336896027386566548394676180598e-07), SC_(9.9999999999997167877490123290575176505761100552377099727665957846360521005247448246132368056436772784e-01), SC_(9.9999999999999999999999999999999999992285046636067848378528499285215689535137479044898469780951150270e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(2.3799674409019419693519798023370504566973533855514004619262803179781957221390018435644578624309329898e-07), SC_(9.9999999999997167877490123290575176505761100552377182175965820841341232764665265396975447646863066386e-01), SC_(9.9999999999999999999999999999999999987918270503919668664999578736804750746011920738219984120577287869e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(2.3799674409019419693519798023370504557131774327161501320092679290556448751047635353612407596717586362e-07), SC_(9.9999999999997167877490123290575176505761100552379524482689687448744769575907381980776888264605639168e-01), SC_(9.9999999999999999999999999999999999863860780986884180425089126971830700918453063357242982975184017076e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(2.3799674409019419693519798023370504527880546129746481115845845231093346754425741629498399069682842334e-07), SC_(9.9999999999997167877490123290575176505761100552386486179761311700970498438839219570546689261009711801e-01), SC_(9.9999999999999999999999999999999999495142776344812982992059863192172714171490171558654797281540266116e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(2.3799674409019419693519798023370504507503821127817647691711484863183013760268426759018206375406192843e-07), SC_(9.9999999999997167877490123290575176505761100552391335773966992156739328266023587991784922376990606984e-01), SC_(9.9999999999999999999999999999999999238289787706361089951325456686009457169774506097102740417782505816e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(2.3799674409019419693519798023370503830205811135274536303369144651881876236709706678074901874583413829e-07), SC_(9.9999999999997167877490123290575176505761100552552530495123989796858450805764269121994562909130935259e-01), SC_(9.9999999999999999999999999999999990700803118528985291545884769305647204287216931895178545311281835943e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3799674409019419693519798023370501781023762284255805712252654321261921225003725049928132501496931467e-07), SC_(9.9999999999997167877490123290575176505761100553040229150798619337315698724480005387324464534570486263e-01), SC_(9.9999999999999999999999999999999964870423925512060966132301152865590520752530529547540624542740109577e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3799674409019419693519798023370500028122467477502029746431956342069317405965154384175030052747220173e-07), SC_(9.9999999999997167877490123290575176505761100553457413951674124184981686768032710704003190624817972589e-01), SC_(9.9999999999999999999999999999999942774727177545554007677723446780446116413610335367853367223434118752e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3799674409019419693519798023370472113542411208175994338805179561083297183475242903084573163826072386e-07), SC_(9.9999999999997167877490123290575176505761100560100993117711481853742658985968971772151230934156727122e-01), SC_(9.9999999999999999999999999999999590905459011959386459190650015723887967005434823467365714880645726672e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3799674409019419693519798023370421194355570427007050504852600406961585340823621264655921918015185573e-07), SC_(9.9999999999997167877490123290575176505761100572219593797538004858204352248822977925551689147249445861e-01), SC_(9.9999999999999999999999999999998949058188763361623084396630270966261976263242815554547294203193666512e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3799674409019419693519798023370269819299594369895711463851790004839185469944915309893679408449373544e-07), SC_(9.9999999999997167877490123290575176505761100608246364256311511246998448075211580532590509631399884636e-01), SC_(9.9999999999999999999999999999997040943144315209111907210730661920275351173608039190004893750023977774e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3799674409019419693519798023368638504859170267251222687277124769729086071054636009104631118972824270e-07), SC_(9.9999999999997167877490123290575176505761100996493889664576011305521750996529189741134548415949447363e-01), SC_(9.9999999999999999999999999999976477874771339090009915002507149429340380462764557664367999784240270741e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3799674409019419693519798023365407947828198485673634393816099817482086401304188547059217337250581480e-07), SC_(9.9999999999997167877490123290575176505761101765355944633566454827904993127059916223460462914590134398e-01), SC_(9.9999999999999999999999999999935756010571202895350340792806998362305133743977026851728049590394417363e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3799674409019419693519798023352890733028621657824020741979952007770953000928491402754748038976702936e-07), SC_(9.9999999999997167877490123290575176505761104744412312010528568123645313265276175241210460286240533889e-01), SC_(9.9999999999999999999999999999777973833582681269995232946550256442192522446093098762264164271428210916e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.3799674409019419693519798023251128864346401643001373493160239639100546160136758992213432041957207879e-07), SC_(9.9999999999997167877490123290575176505761128963405730913478723527618090611511673969599215592536522634e-01), SC_(9.9999999999999999999999999998495243655009445475845322436852759090907472060880969395846045949389765894e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.3799674409019419693519798022577957840853899834712299241316322304141140523054289108401467322215741735e-07), SC_(9.9999999999997167877490123290575176505761289175917537997074789001522245224699682658024690717948253838e-01), SC_(9.9999999999999999999999999990009778535737945732779091881378483357869054963949537905607237534027724567e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3799674409019419693519798020311863607820843920531976198224283732823895510084179735352424108138004264e-07), SC_(9.9999999999997167877490123290575176505761828498966801445450551240848256128552631331247157551568768920e-01), SC_(9.9999999999999999999999999961445174742154604706548697523030082768931474832281986625583477088037054149e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3799674409019419693519798010644155585126229003298674682724121519317625171809308161769244388202529612e-07), SC_(9.9999999999997167877490123290575176505764129381999017478232323788982899380670259452038069826029112772e-01), SC_(9.9999999999999999999999999839581641780994472943636188013250274866449982085556351662148256364053029684e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3799674409019419693519797974062453008474872890952046465426561427222832588179363112458893143429266595e-07), SC_(9.9999999999997167877490123290575176505772835708105536615270491562487683348405214292417389285256737678e-01), SC_(9.9999999999999999999999999378461435496302843351598181730493722485083138776466160205935257965033089783e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3799674409019419693519797825574535457574344681368455217143384992154076778409277616780456766943742354e-07), SC_(9.9999999999997167877490123290575176505808175349019385144592261200121151318764807011837810397122125633e-01), SC_(9.9999999999999999999999997506739390072487447425305698043480476016679559771483581735764231370837656945e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.3799674409019419693519797749535722194419092453915044420191891594303635830702357929060369172405215213e-07), SC_(9.9999999999997167877490123290575176505826272339000498882015996493359135272815639781193342522188793177e-01), SC_(9.9999999999999999999999996548253841618856054130243818997223700135205133225658176509770357052637670085e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.3799674409019419693519795588800041440490282766660183003868160995254186398022589509059605976063569752e-07), SC_(9.9999999999997167877490123290575176506340520395859457787579162612859334152853919065855293701044533236e-01), SC_(9.9999999999999999999999969311717194691945522471818711824452903409866088879160632773248980735684910378e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.3799674409019419693519785327116469311009828107868315001107307336506717159329689299241463084490112062e-07), SC_(9.9999999999997167877490123290575176508782767674910176758625863026903127194041228494595104524956652471e-01), SC_(9.9999999999999999999999839960995049005340645227591656563930031599385880092464590490415304776577046603e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3799674409019419693519746694825028994898983431970116687751626592399977858215655440787518144128520073e-07), SC_(9.9999999999997167877490123290575176517977127254449150368154929825366512986291853219552290524587142725e-01), SC_(9.9999999999999999999999352992676368864367647819262309970158003209689695660980041580737124402817504908e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3799674409019419693519597641900240191104358911316533866687425755019470219287745091827259275377502300e-07), SC_(9.9999999999997167877490123290575176553451238051306054666081039005106925921131029918712818652712133854e-01), SC_(9.9999999999999999999997474148593539917698150201844446228935130789675973760071594191468105226804499762e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3799674409019419693519540272938980107538028670800911157631961159840445305195048303061642846793577703e-07), SC_(9.9999999999997167877490123290575176567104864043042814697861026257827507343866055045758938026386816631e-01), SC_(9.9999999999999999999996751000533518437361583262287349555969600402756313222370636870700035149174127720e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3799674409019419693517951331765262398696010858370088079269447705112672248212678288735938471276511806e-07), SC_(9.9999999999997167877490123290575176945267689938719877413349889302394292875123053334706059570089926591e-01), SC_(9.9999999999999999999976722056274740317337866485011977395650652906374677086648468187895380859004493085e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.3799674409019419693508973411001681394521394392290360764785090317417205821361726771570390497849868485e-07), SC_(9.9999999999997167877490123290575179081983600370809519053207036729729697274174564177291670398492925249e-01), SC_(9.9999999999999999999863553439646370959698077510893301871327813314469116833523567847867292313918366987e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.3799674409019419693476394792407539127377560431849908899812062272159278122302296608565434794191799971e-07), SC_(9.9999999999997167877490123290575186835588752733148505008653373892823256677574574848449717256671734848e-01), SC_(9.9999999999999999999452892965461948012512571278401751905959364959400449476432342302488664696531517855e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.3799674409019419693429682087588784282163645436431890257354094024564849720599871889865344524805073483e-07), SC_(9.9999999999997167877490123290575197953060407243441558329023300608609582105195218341322188920989116641e-01), SC_(9.9999999999999999998864069303222444240802622090588956682079774106401539748816629610457811354285545331e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3799674409019419693240410145798146977148968072294894552357448042091516220592065130852858504286540922e-07), SC_(9.9999999999997167877490123290575242999166301045156389484335642831519304843728875047182897771249791095e-01), SC_(9.9999999999999999996478255885721523210095264314878691951645003774580687936694835248944576677859047951e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3799674409019419692654498300157459776195335091764111546411313651355535679164343538911436570631511110e-07), SC_(9.9999999999997167877490123290575382444277887409101784344871580266462630939097404448312473195206671603e-01), SC_(9.9999999999999999989092711416861275848747037419474868418371747978361424566152166535475015370572668484e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3799674409019419686589768541452411308004982525083572117758672534991785085946823891141640212192810373e-07), SC_(9.9999999999997167877490123290576825830214246160602012860409266394519009008181429290942452902987834603e-01), SC_(9.9999999999999999912645492167423745863298328545027488810405830261465356331208319357505213555195224762e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3799674409019419676548536598358761442524616151336799503858664528741236350684233504853282214645793356e-07), SC_(9.9999999999997167877490123290579215610723356971088732358081518312540420341561848878819627050824760541e-01), SC_(9.9999999999999999786073610083754392860445226392386491847849968111786480849442061726846806476511006677e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.3799674409019419492206331449367331588247576378918688905397486734782038777936246419227550687252701594e-07), SC_(9.9999999999997167877490123290623088455347224805764144363421326932996661725714254839299825124756603956e-01), SC_(9.9999999999999997462400580181300220492183812887515557221797210954273980698432270984487628364343391828e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.3799674409019419103557588183855114403222735929297975944320556539914505343353649289635852689966420844e-07), SC_(9.9999999999997167877490123290715585590839165120329661702014048283042612428349161688230109643371044387e-01), SC_(9.9999999999999992563399821773074211220185976163635506853655730627087860783791978784397647640883557366e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3799674409019416874498955404485243804576378311808812656691281844931668386524484909153902062933428600e-07), SC_(9.9999999999997167877490123291246094287826809959870955238304726169966744942246522779824261880220246378e-01), SC_(9.9999999999999964465637712036270052807157672101888717360010877171083471599149536724978627149845233546e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3799674409019407306351914871477819952798660381542937170711984029192719614433057379864027769491627487e-07), SC_(9.9999999999997167877490123293523282130449956855028506911294025232684179484470249345750490633565966138e-01), SC_(9.9999999999999843857092282855302421456953418311029397913695294229646075039833323326927599521059212761e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3799674409019365776125548480150038455417870652043193057735143775573346193513665512619491609103806598e-07), SC_(9.9999999999997167877490123303407340786980095472948006561215266073542124622607347419602707684254569882e-01), SC_(9.9999999999999320359682368882290826897897002608860341109323993758571716878100230648820175649841518560e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3799674409019292693849586012255812533450199613173786061778930518178261035859109435079896963457670239e-07), SC_(9.9999999999997167877490123320800684516748944185533984546000770534573667828427532374758723560675806969e-01), SC_(9.9999999999998399141920648926420907629288919194572456523347583032654330074068895656427313245182187354e-01) }},
      {{ SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(2.3799674409018803742093136530293668420315854633518442975086485262871525074775594507641085085789333598e-07), SC_(9.9999999999997167877490123437169610568908742049910067594780109958854751982372358538280958928285413963e-01), SC_(9.9999999999992235800170088861254908226957093950897252155788312361934881068715393259776272869338631818e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(4.6846594159431439031715599679832107903096194033471248804708001515271382909281253125005321108104078130e-07), SC_(9.9999999999989026983078307018885860924222169389350706796690044560554674289147189718510991235918733910e-01), SC_(9.9999999999999999999999999999999999970108526902608609669041716627051175184210503786986631058551704941e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(4.6846594159431439031715599679832107900454200753831529683443354742003521420983480814490189577116164245e-07), SC_(9.9999999999989026983078307018885860924222169389351944480559476968150264757991873185772327325232992520e-01), SC_(9.9999999999999999999999999999999999953189517140777718573236360185377321272284942988578246355129785851e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(4.6846594159431439031715599679832107825396757075869090547337565117450287041206985886287216309025631965e-07), SC_(9.9999999999989026983078307018885860924222169389387106336585739720357460048763817671401387584537951331e-01), SC_(9.9999999999999999999999999999999999472530602497856663868431799030441083432180384637564804098309622967e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(4.6846594159431439031715599679832107602314450846605632177037505843085712369883497888458681238050019733e-07), SC_(9.9999999999989026983078307018885860924222169389491612799226474280448836626651750963146099177614688505e-01), SC_(9.9999999999999999999999999999999998043938128069098385600877564230769220144983295582652469370772868662e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(4.6846594159431439031715599679832107446912880144986786208698832042000262452519724159349742004427335386e-07), SC_(9.9999999999989026983078307018885860924222169389564413142370451561488561715377812257382207711122397678e-01), SC_(9.9999999999999999999999999999999997048765009361133882181729345546396007852462514060198258749014123311e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(4.6846594159431439031715599679832102281550213869674546799957108631588534088491853756350410772923164267e-07), SC_(9.9999999999989026983078307018885860924222169391984209627503499563244190882671591089540155284123647671e-01), SC_(9.9999999999999999999999999999999963970398744165201967075761891084759796374119379603338282198026689212e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(4.6846594159431439031715599679832086653616430846835003335484508507104875752511362146811628673508318464e-07), SC_(9.9999999999989026983078307018885860924222169399305364342341693204185112114057855915306950320413517279e-01), SC_(9.9999999999999999999999999999999863890975276340600998265965621538264010542301289237624449553500293813e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(4.6846594159431439031715599679832073285245680783436365021644193666935279541363783712762854156073245830e-07), SC_(9.9999999999989026983078307018885860924222169405567990733352721367852182194896899610336624144103071116e-01), SC_(9.9999999999999999999999999999999778281523896153653087700622817569655637754909243623603598976108742037e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(4.6846594159431439031715599679831860396786627146962492032017394220016072566617379480084310072957170090e-07), SC_(9.9999999999989026983078307018885860924222169505298983158488119819379954338801420331963311429245195999e-01), SC_(9.9999999999999999999999999999998414969230610991777109874345228789090900443402294471323685818355871682e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(4.6846594159431439031715599679831472065412809344138155817751432351380491536127434654991066383295064779e-07), SC_(9.9999999999989026983078307018885860924222169687219005844678768260926654867135664068689552905145760169e-01), SC_(9.9999999999999999999999999999995928141442258493241573862539559055792130783516510381052114173510894486e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(4.6846594159431439031715599679830317614858979030052878262135934090742591817282901346167718653772398165e-07), SC_(9.9999999999989026983078307018885860924222170228039771568933931951136139788994804659330433336555186198e-01), SC_(9.9999999999999999999999999999988535177826367045531220948492289894138864954679376256783734878055398219e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.6846594159431439031715599679817876517169034195108142716083156798089771532624112401901734928150457916e-07), SC_(9.9999999999989026983078307018885860924222176056270315356430193625904251318114589670029067778281111675e-01), SC_(9.9999999999999999999999999999908863872495578142400966351592297734136819688483692248613437788350145263e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.6846594159431439031715599679793238915355855121979764704928653539732213256568458588348277616115936425e-07), SC_(9.9999999999989026983078307018885860924222187598147647394418680848426594211718773305397846785145006909e-01), SC_(9.9999999999999999999999999999751087609854167119880668260660489987908314267904343564835224785141024541e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.6846594159431439031715599679697777311958858860092096081791287862443558999908956124381385728435871621e-07), SC_(9.9999999999989026983078307018885860924222232318657568876180890242677208008871231909478528552510702782e-01), SC_(9.9999999999999999999999999999139762890673179151496807090370157112530490132094364871799064062579321941e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(4.6846594159431439031715599678921698023984371370721753262016862178540793864114810161834429944171942154e-07), SC_(9.9999999999989026983078307018885860924222595885371961729429698269862720095675149810719308765556906032e-01), SC_(9.9999999999999999999999999994169843720028775405061229361031111152097735198322542613211945817318671038e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(4.6846594159431439031715599673787809511887912046655466682780386355798635475760798841548287570164184798e-07), SC_(9.9999999999989026983078307018885860924225000937287821494857491767917405513184776157611630538853480107e-01), SC_(9.9999999999999999999999999961293034183194393313475873262734047353975162259520755684931835969019296493e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.6846594159431439031715599656505611163631129380111634514688115070578219936469336879361578207824639456e-07), SC_(9.9999999999989026983078307018885860924233097058609858201822453771548425054686217719049072082024385264e-01), SC_(9.9999999999999999999999999850619897800376787198437449318171470704599906491448911342046840782601245010e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.6846594159431439031715599582775558288639100760358368633720147351433093085355914095435617212519522758e-07), SC_(9.9999999999989026983078307018885860924267637077253743719381848528018748568724870331372967653122808821e-01), SC_(9.9999999999999999999999999378461435496336575883774824938411955559074613996402228623266120693709863383e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.6846594159431439031715599303787936930792961163336108190354395511306681258826472164838322850860910225e-07), SC_(9.9999999999989026983078307018885860924398333275986319508310709753738782581252201247055001214018942572e-01), SC_(9.9999999999999999999999997591857992724877937458454021947497086065575435326407571104820301090814880336e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.6846594159431439031715598171355928576253866111045165523521567236036949918425554181900676925660042346e-07), SC_(9.9999999999989026983078307018885860924928839103071727378210706721265561568122146029958802453314365347e-01), SC_(9.9999999999999999999999990339898515154613071635340045536877092307150732732340105787826746491305801191e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.6846594159431439031715597591451600757977135670153003542755539888806358948250499251796236656962665705e-07), SC_(9.9999999999989026983078307018885860925200504530037764160657973276121444464790389644979681885644458251e-01), SC_(9.9999999999999999999999986626260384847423952734929724100904702903791675090937310284237745250944983361e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.6846594159431439031715581112762379187408317063295029814544727284291770678947874960587448042652558769e-07), SC_(9.9999999999989026983078307018885860932920209192461747402614406665049257019666142438076407430037055667e-01), SC_(9.9999999999999999999999881098700587288247832597151103605635743964685013853453293961424138360690420160e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.6846594159431439031715502852799357604221663639557734917944748960478412362347838203865248769659623355e-07), SC_(9.9999999999989026983078307018885860969582336458507963398833294334231396300385700701892482298530142983e-01), SC_(9.9999999999999999999999379931234141933946893590481434463286919694833669390475615712244697346430866841e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.6846594159431439031715208226515248673879098484765620471112612063317466548070697192251453501986600915e-07), SC_(9.9999999999989026983078307018885861107604716062047148462747911121830087319278661020847047270179460595e-01), SC_(9.9999999999999999999997493179660871197041779835610813482278647333869848634712450964532866047092403825e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.6846594159431439031714071485521410960254282128622416553925572464808908945616414863213921142226274889e-07), SC_(9.9999999999989026983078307018885861640129156089146827698947312596345547421867782291159570669386301169e-01), SC_(9.9999999999999999999990213625954346890649753385660773651087551863142219402458725723761462436429945169e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.6846594159431439031713633965424904117003134182295298718070777031201083939082887253281125820532257935e-07), SC_(9.9999999999989026983078307018885861845092420065682944348068875191493020856025132209076481205372792059e-01), SC_(9.9999999999999999999987411799454316610847002595685274381240095884266946017684431754699992871541027766e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.6846594159431439031701516024287413559832139183003491091597646059608522180835976113410618283410169977e-07), SC_(9.9999999999989026983078307018885867521935125225296908009106072592965662408630522200326394317685221677e-01), SC_(9.9999999999999999999909809950131500266788199396969406738926245096810260679828847814956622962116221842e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.6846594159431439031633046582403936252845195678176423157074888990882280078300689736883213343980818786e-07), SC_(9.9999999999989026983078307018885899597536687609200147282322528037489151576803223974053732528543909021e-01), SC_(9.9999999999999999999471339813003960776062137781187906292929882395257589520514559667450864752218430447e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.6846594159431439031384588181932838025262970928620326102025598785801692207484223000006661430012525337e-07), SC_(9.9999999999989026983078307018886015991835211332249395737048106929646825409683659562257137396370848256e-01), SC_(9.9999999999999999997880241858525953189052350068168593222034704311324796564195872417166517536312788898e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.6846594159431439031028337228952492376351260370890844094754877521151377003410209073683185344619981636e-07), SC_(9.9999999999989026983078307018886182883273343160009262770349787543088101053380706217084800578023382578e-01), SC_(9.9999999999999999995598853257886527448520701476570658946808329977577822811789613020170952228100302744e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.6846594159431439029584868907069255500608866251391973685624687712882106286498836224160366282981110458e-07), SC_(9.9999999999989026983078307018886859099019915829661293455445895313643814104117855349533938806539603096e-01), SC_(9.9999999999999999986355054336427308757141965455350596697676936157509858239509839340232634272240400838e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.6846594159431439025116455994953671877470219084162076155892920003879502513067639677938198739662960927e-07), SC_(9.9999999999989026983078307018888952398282222478637507802970484007201720291769571087569552827586034358e-01), SC_(9.9999999999999999957739871147814405728599082832807011178440399602781138553001066913498882342830010263e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.6846594159431438978864247639862184525414192706300176636736360472797445428213678999359978854266120848e-07), SC_(9.9999999999989026983078307018910619982620109204984303928430286842469291904637844347174430900770836580e-01), SC_(9.9999999999999999661546246926051784268474501274989901776413040046259344490940284876134757630900069192e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.6846594159431438902285542495227124341383054757797663759344045758477517847541973233898978829372153982e-07), SC_(9.9999999999989026983078307018946494497831767972461149130959523573492072276579933476014729128175115955e-01), SC_(9.9999999999999999171145355343491768289508528436381720333664842021573743759210487231068504671670443189e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(4.6846594159431437496413488765217806262702881227247250623088148925302031905907088641819454540343874186e-07), SC_(9.9999999999989026983078307019605097673243601597006007403058256538443561567636716707518977114313663148e-01), SC_(9.9999999999999990168108449743606002847441553921883698265863442618033472080858632544928771045926965225e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(4.6846594159431434532412887640466749284164738824881784334311664001545197888103949173070366854399116367e-07), SC_(9.9999999999989026983078307020993631005735774244026019293853871694111540160414240205761313844201406966e-01), SC_(9.9999999999999971187002217959087323173560732681698379775362309694647468752038179673752880159163870522e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.6846594159431417532663777460721969123690587178806676168376119053300570692026523698515712030712374606e-07), SC_(9.9999999999989026983078307028957434479504108249240089304813655485420999652301749135086139637097110868e-01), SC_(9.9999999999999862322637058397128185488455532972589312411368436792120154460566668139909646852780949929e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.6846594159431344561905293841493760005304658577179168039863128255809059202769910548339222250117388680e-07), SC_(9.9999999999989026983078307063141749561387803656090429100012864572302954988689841283538618477714008249e-01), SC_(9.9999999999999395026605449673563299853397025407274751112097631438983757622453751488640801116227701705e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.6846594159431027834737001583164022151543991114270505689527168354561330683321651894276841351111778587e-07), SC_(9.9999999999989026983078307211517640683936959551904991129332313203717276340377390423336322523063125194e-01), SC_(9.9999999999997366743606597945152331833347467614778702894661312755887099262364020437917686501253171898e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.6846594159430470478219997915909792761623275101147427478131110896026055816462066094316664979251685570e-07), SC_(9.9999999999989026983078307472620186225812244609602573167006560914515309216662220933690526820457716979e-01), SC_(9.9999999999993797498966698260637402811317670813394020454897865146415487410462531350636259551443366488e-01) }},
      {{ SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.6846594159426741524183352168712899766088409942281352490753470062168070367937344186650919264314254242e-07), SC_(9.9999999999989026983078309219508150165067777566184679418777424752658635563276321058501100051835654684e-01), SC_(9.9999999999969917722196020780320284262567048631317441886654680877206003792323951839773300049769573616e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(9.3826997726850880345391257690097187188024455980722262237911102180287248979756962962416426993657215152e-07), SC_(9.9999999999955982472487817910948653715178849853463483574205866503167314031035602389320902655227834433e-01), SC_(9.9999999999999999999999999999999999880092343898358128047250264559837632328362055940615670265324671904e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(9.3826997726850880345391257690097187166797823444561476793342312805184853085502785745927702307646102420e-07), SC_(9.9999999999955982472487817910948653715178849853483399886233065839366457930504335474328766605043506174e-01), SC_(9.9999999999999999999999999999999999812222861605128985345293462203372186040620321974504758697325728818e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(9.3826997726850880345391257690097186563761930683715596611854215313824322261695474395477570588953585059e-07), SC_(9.9999999999955982472487817910948653715178849854049210359626128671650656791316218112680278929319043539e-01), SC_(9.9999999999999999999999999999999997884091596497904999815966187998941173726924884334414390040209532861e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(9.3826997726850880345391257690097184771446190844436112047118280414122885768141305166929554850247161705e-07), SC_(9.9999999999955982472487817910948653715178849855730886408103860204262946896921712420232095255551567079e-01), SC_(9.9999999999999999999999999999999992153387908022065829869570258067821558919315117575594903793021437759e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(9.3826997726850880345391257690097183522899473392035641581065588091655081181320926988617852756554907912e-07), SC_(9.9999999999955982472487817910948653715178849856902360308307110931287693651967845821839444541733892043e-01), SC_(9.9999999999999999999999999999999988161317136172190513631843512903344564348158436749001441499884379863e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(9.3826997726850880345391257690097142022697304830313504182990676907223798385612652260547381020438842490e-07), SC_(9.9999999999955982472487817910948653715178849895840754053659177429780214325347654915479068079781854750e-01), SC_(9.9999999999999999999999999999999855469651067784065201855192192422301904189056004405188164838940610448e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(9.3826997726850880345391257690097016462798925029837596991637332884704747220485179058582368718689791583e-07), SC_(9.9999999999955982472487817910948653715178850013649837052362701945085585511660558159848576263346919608e-01), SC_(9.9999999999999999999999999999999454007700600118529097204137621461115127580548255084379799335456761978e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(9.3826997726850880345391257690096909056964207141316114285599267208859624224761043105221257490877635325e-07), SC_(9.9999999999955982472487817910948653715178850114425507151665537607608681031930567242690826481802676641e-01), SC_(9.9999999999999999999999999999999110591080693168323418682454813843029453597348930186594197303585890903e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(9.3826997726850880345391257690095198641905113091329941041266102235322123206108025861308747000871272064e-07), SC_(9.9999999999955982472487817910948653715178851719256605768261366868483106921409871257558407988496522809e-01), SC_(9.9999999999999999999999999999993641754496769709105679571418148789967517605237085759187468174679338137e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(9.3826997726850880345391257690092078661457843725339408919218688013846928704563308962638958335674499504e-07), SC_(9.9999999999955982472487817910948653715178854646640589107169886355793339496698144643517107870296504088e-01), SC_(9.9999999999999999999999999999983666010234911940185311777512659635441655463297707972922679240877058854e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(9.3826997726850880345391257690082803430564499033876791174202568228972647681834473219663756424516797925e-07), SC_(9.9999999999955982472487817910948653715178863349311268569694847449616063612732974667921354770519105526e-01), SC_(9.9999999999999999999999999999954009628432048419520868389487473479298118178224999377417181362984651177e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(9.3826997726850880345391257689982847608933132131929887691426437587541071966318997079292219270117668711e-07), SC_(9.9999999999955982472487817910948653715178957134857758528720558951708775329464209195865976424566725239e-01), SC_(9.9999999999999999999999999999634413486427028124749143340101328107246586302409810188896190435444073862e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(9.3826997726850880345391257689784901109867124964172110259038345854431622434539180124742337455003748606e-07), SC_(9.9999999999955982472487817910948653715179142862114937653917491507732534120653060931102944423513870594e-01), SC_(9.9999999999999999999999999999001504503314394193685878183696615699619218247131511919200849609213633159e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(9.3826997726850880345391257689017931567500581823576510803408114673505630397567865833648371141238823496e-07), SC_(9.9999999999955982472487817910948653715179862486610019865710604191221393983502184044987512952109122061e-01), SC_(9.9999999999999999999999999996549216054526510292425657025884832694371838527372515931174870068879305255e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(9.3826997726850880345391257682782658377477100144929799932177740322433508613034066551090248006620641743e-07), SC_(9.9999999999955982472487817910948653715185712856244288715426212756187784411159104387049563143027750709e-01), SC_(9.9999999999999999999999999976612715875196342123312716180542695095723186383751542806086499801671299481e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(9.3826997726850880345391257641535329791255483641068058392341802319079291588221891803789968531674172950e-07), SC_(9.9999999999955982472487817910948653715224413986299286620185120146645031252037119131179816560918004744e-01), SC_(9.9999999999999999999999999844729581216103595629548277021523783967967007565468711892824466966548474263e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.3826997726850880345391257502684532333694616908657145773721851409588664294286537345901373811686329934e-07), SC_(9.9999999999955982472487817910948653715354693520873563920404164608810572792553088121981656131100823545e-01), SC_(9.9999999999999999999999999400771656029769586620609575747186112017891716528106870671371789835855090831e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.3826997726850880345391256910313328625492576145028198979155560663866338446380910081492576060421285075e-07), SC_(9.9999999999955982472487817910948653715910497636711622498240653888938375388592390408343871164950177997e-01), SC_(9.9999999999999999999999997506739390073172020411946742479000146457700092276455602824337077640533414788e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.3826997726850880345391254668836120360934124035648711602991972814496901787213826858569981954884663191e-07), SC_(9.9999999999955982472487817910948653718013608405958816067538274980209988751973751388697818172124007286e-01), SC_(9.9999999999999999999999990339898515156741160474147903823661893865138160657978815774383397352093913640e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.3826997726850880345391245570509376393472133910477544695632071647477319015269004042966374520404328216e-07), SC_(9.9999999999955982472487817910948653726550295233206389983689641022214030880325722164702415170963562656e-01), SC_(9.9999999999999999999999961249145434291543126718466386720234496242386032480299056743202142381584889206e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(9.3826997726850880345391240911369564195887020191572286491902745528716532485208293138698102038912139365e-07), SC_(9.9999999999955982472487817910948653730921826238889746783755010748701772922594922000504776763615717930e-01), SC_(9.9999999999999999999999946352133086857945785377171867617733972888089630697362551804055458485952522588e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(9.3826997726850880345391108516225534317309392300435295618655774255743817475277967044785983815868880376e-07), SC_(9.9999999999955982472487817910948653855144215018319548458197421974344045541600175307990897507590952785e-01), SC_(9.9999999999999999999999523035346114741730012469260346628680051430427876182017982741328862808269605395e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(9.3826997726850880345390479750251693835035126779629636221568318419655903246800206781377798482667600698e-07), SC_(9.9999999999955982472487817910948654445096451001100335278436851299798127003782766269058934467776238826e-01), SC_(9.9999999999999999999997512635389576466119510551241852132704394706695616835673123038134031682818877877e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.3826997726850880345388112626945033644945346666856242699850935784394566606338997205180362205887473077e-07), SC_(9.9999999999955982472487817910948656666097182133891913939073517699354030532519421028248157087795697536e-01), SC_(9.9999999999999999999989944056950505735129040391643032751461380845893982225223485840643787497556567176e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.3826997726850880345378979680411470249605830340924529504995954887968181527817740538488324013043941263e-07), SC_(9.9999999999955982472487817910948665235266718578697069482195571747758295023794907868513987129868148950e-01), SC_(9.9999999999999999999960742611455618963380299797379620550577721773508296643454667026533941813787825767e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.3826997726850880345375464501782021647295145243131540576860826519351575358719373783841091584271523928e-07), SC_(9.9999999999955982472487817910948668533453291327636870112427162375055612962663922895188911524321863483e-01), SC_(9.9999999999999999999949503270813975687418992467779681709402130841565640134405305787812092098281136968e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.3826997726850880345278105024904239786822615067852234034482023367257216619596737152400848064548314705e-07), SC_(9.9999999999955982472487817910948759882927448358141327899133604969857934820124452477454815739127932676e-01), SC_(9.9999999999999999999638208613935264058496397615723919183749507798187049955673351428264558024128337230e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(9.3826997726850880344727999279360942267020322377621854727044591802052962509191957289250548858270889808e-07), SC_(9.9999999999955982472487817910949276030632814771188701984275300400184584028263787051143060939198256235e-01), SC_(9.9999999999999999997879314823648393711467089337055779335504619983903504977608755691441302671332911765e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(9.3826997726850880342731803752307417385156223396344123887783564506969266171962222069933107395503799021e-07), SC_(9.9999999999955982472487817910951149000964607605365004662483533897761463774996192884626331924365844554e-01), SC_(9.9999999999999999991496731210991831891340450360052219894483091186106758372993697845286523801678682142e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(9.3826997726850880339869567830722446525428534103794048546407429919094206792468249407412787658641612750e-07), SC_(9.9999999999955982472487817910953834550997691427432222203281811980717795099762566117492556524409921271e-01), SC_(9.9999999999999999982345092585876654722304658366183440391576481599003517558539144950511192512409349935e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.3826997726850880328272274271223911968828026752137453709180468231871960685125691908414707751826176119e-07), SC_(9.9999999999955982472487817910964715943362143130717707063049217040617296796971358459216051728392945327e-01), SC_(9.9999999999999999945264208062865656210843251542096076958235906026830172416921864002480923400080284752e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.3826997726850880292371592904521896474617530844915666985654189852349027144000193065478238421022087780e-07), SC_(9.9999999999955982472487817910998400474852017435443592700464957070855861751232070767521872236986602252e-01), SC_(9.9999999999999999830476304037984503249702361979401509587808404034970629111339855965613774113444144859e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.3826997726850879920766321117700787942922689971911604797190892277160528700299866409119530209912452866e-07), SC_(9.9999999999955982472487817911347066544764449586029158925448075362718159629442395592308657131637646851e-01), SC_(9.9999999999999998642315281763658959310993262866514779382228849213767483204803532468143271233602703944e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.3826997726850879305508119392888052858183028989642845544396631553261107567896507972813230559496782474e-07), SC_(9.9999999999955982472487817911924344843711307333995567906003401772889553360164890033430931978290404720e-01), SC_(9.9999999999999996675104724149760340168377573591455751139245616658261226801932661955665838943085288217e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.3826997726850868010275195312908864100820037823148128934498700447555637626347184556418624926955437564e-07), SC_(9.9999999999955982472487817922522322782635005843255714981446042930933498973605051418609994978541640709e-01), SC_(9.9999999999999960560021013495460095922268317460242495248740846070487810482068344717640216687466282108e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.3826997726850844196531200621750366610141552894225318947058009888996747170916953421599804994599241803e-07), SC_(9.9999999999955982472487817944866043819221796535201516702937308624904937636564139106763729365961821847e-01), SC_(9.9999999999999884418575891201625416684083526806820859405778105977440346495058119815600936492205752560e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.3826997726850707615022704915335641342506134591651821613850225498202144631931340078807535026919676607e-07), SC_(9.9999999999955982472487818073016372690843162259410699717837655491508662102702379297083677229569728913e-01), SC_(9.9999999999999447716416156708883433287167918962672011359604725002478067198428354072871172053687081998e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.3826997726850121344236873112895099586871119553175124196640769661130954408970804009647936630837496025e-07), SC_(9.9999999999955982472487818623096649586678631721110968395919954828591710702252600344948172726817579576e-01), SC_(9.9999999999997573189467510257079960802806657379407871384244696251063991014219090525575515280302290091e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.3826997726847576655244902906005566334504361456219113911500940354770807551122145792885612521794419471e-07), SC_(9.9999999999955982472487821010701932238988504428000333669975847229758775993925147918181329733927608364e-01), SC_(9.9999999999989436867128671076133682580771078984890129182749663656713197714085563766001898243149552750e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.3826997726843098671871802005320286077286220695108885668328565798214645957321054950003417480994503413e-07), SC_(9.9999999999955982472487825212259289928732187777989320320666315870563872575749953499548413781890275177e-01), SC_(9.9999999999975119079663688278376715846251426563796308445212698563593673321841853261039113087313521082e-01) }},
      {{ SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.3826997726813139043401097512248917876292813572713935482541830510369495864397672970818960106228432686e-07), SC_(9.9999999999955982472487853322479214115160234863039083300485613119635570612487484190177023996176048437e-01), SC_(9.9999999999879326943509256523758084292288115832825796517407920013962322002165712947366819431214661411e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.1039855962733358235856122053156941659704656507914831235628369455928415009712322152040828670146040529e-06), SC_(9.9999999999939060790161031790048854092626781629036776887146727588412807536192754578343529277325609624e-01), SC_(9.9999999999999999999999999999999999833996177671408297742452135308707385067738603599494870829073693395e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.1039855962733358235856122053156941656246952102842271499023117633576848543175013395946585110335619340e-06), SC_(9.9999999999939060790161031790048854092626781629074949445740460548121768467634848621165987434589495111e-01), SC_(9.9999999999999999999999999999999999740035592947874202410758236047782881518649225518053889474598983870e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.1039855962733358235856122053156941558015644839953572073947408240926358477325432885149552783773554354e-06), SC_(9.9999999999939060790161031790048854092626781630159408928954415857052363578801535612682831034961757373e-01), SC_(9.9999999999999999999999999999999997070671764438515137524417910053253229401795788033562340475781078446e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.1039855962733358235856122053156941266057039612972413310616646054898103022484543966302862137135129080e-06), SC_(9.9999999999939060790161031790048854092626781633382589877742782594561533907495048184638065533648975314e-01), SC_(9.9999999999999999999999999999999989136910503079640848733645380910779967035016691223993670221580339693e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1039855962733358235856122053156941062675486862218707412661013696462361966404619738353912504869475077e-06), SC_(9.9999999999939060790161031790048854092626781635627892925589528201279493601284535490102169284463479537e-01), SC_(9.9999999999999999999999999999999983610165767350823312435607213040683186235728896471229754457381529630e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1039855962733358235856122053156934302515503634310646027099796003355806348963396605689125594028046089e-06), SC_(9.9999999999939060790161031790048854092626781710259085425505067675962761729505880671662676705618276340e-01), SC_(9.9999999999999999999999999999999799907769484750926858765327788494626681071264887159765393606938022358e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1039855962733358235856122053156913849482598452514751410841835924935597884086381400750454950757943329e-06), SC_(9.9999999999939060790161031790048854092626781936057622699895497750703479221610047122182442694065357957e-01), SC_(9.9999999999999999999999999999999244111580452150147560913367902997619946481068395418451549994202594722e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1039855962733358235856122053156896353649135378457569963945851507839152937615780489685381185566291192e-06), SC_(9.9999999999939060790161031790048854092626782129209104080321153322686899957714314973254452093750134556e-01), SC_(9.9999999999999999999999999999998768675120353266900055520804305511284636422401089664721825815569492186e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1039855962733358235856122053156617736224809738754216306780029593003319301601683963609080744685347808e-06), SC_(9.9999999999939060790161031790048854092626785205105337345019271497716169494708402249844007351214356316e-01), SC_(9.9999999999999999999999999999991197450678669752689266009085582761297903813480200346020251172249133371e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1039855962733358235856122053156109508171307346588766762340355308923834875916265302734118430180518737e-06), SC_(9.9999999999939060790161031790048854092626790815869844235190784783489044951809317926858733324195684128e-01), SC_(9.9999999999999999999999999999977386725560023806550683820607840585443760566501797732128625456697789154e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1039855962733358235856122053154598622887767989387627576510124601384981920141124731912502327882659594e-06), SC_(9.9999999999939060790161031790048854092626807495825750733408642875871006789309621686282177872896657239e-01), SC_(9.9999999999999999999999999999936329524579143109581348636445340976076387923067724635449570980891937857e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1039855962733358235856122053138316356533053229478415262572711135845684398611493252405363212304990351e-06), SC_(9.9999999999939060790161031790048854092626987249701053753432356889705935014135641483640028143697162126e-01), SC_(9.9999999999999999999999999999493870861811751295078199019704019601124597266959944607475070804974318574e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1039855962733358235856122053106071935255997591191564792694270708428704520816473789402301001877080017e-06), SC_(9.9999999999939060790161031790048854092627343223467554359414008173944063439805827663075409308808783829e-01), SC_(9.9999999999999999999999999998617652329996411352438845070758389393858340852356196253883916954722091674e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1039855962733358235856122052981136717167140310883125486786112237433494695456481225555966092773698101e-06), SC_(9.9999999999939060790161031790048854092628722490279928863491219379204958899043329090871897778757566427e-01), SC_(9.9999999999999999999999999995222629283211432644179828563867900337544515782988634897975424746561283139e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1039855962733358235856122051965444212044305321460286196536143115127312423369032070778979193664670865e-06), SC_(9.9999999999939060790161031790048854092639935589238919608529174556490625377664741915894861725361935304e-01), SC_(9.9999999999999999999999999967621929367785890172149974867646689369285472496812509540461573285898772428e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1039855962733358235856122045246475976876026404457468587472484922549735882270429659528080136631029502e-06), SC_(9.9999999999939060790161031790048854092714112030773403363833401125073880134690513913818137831040006305e-01), SC_(9.9999999999999999999999999785038888669136217263033583812998980166090206229504750831331372446466897028e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1039855962733358235856122022628427014142084926408548712749986410927708704548777668790279701690148468e-06), SC_(9.9999999999939060790161031790048854092963812033480188881174033936785654517947747931986168148529303685e-01), SC_(9.9999999999999999999999999170409973968890850233650971193207199632888312755769529020050609368485603166e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1039855962733358235856121926134340304406903742504701589700038901878747507946954840904874523529894907e-06), SC_(9.9999999999939060790161031790048854094029092852011817691521683367128323569475176047474154589578137872e-01), SC_(9.9999999999999999999999996548253841620193193566663153859810260394599508415051679063020920893582640450e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1039855962733358235856121561009744884812438837438157745571134492169161711653868841754495766600571325e-06), SC_(9.9999999999939060790161031790048854098060015793897889078280679065277191252339725290514843851205638812e-01), SC_(9.9999999999999999999999986626260384851878851759170528230197527994587744267591148822617641325425585707e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1039855962733358235856120078941196903260965031492689068814604994950147495077178616107827554419849813e-06), SC_(9.9999999999939060790161031790048854114421839090521561123984936806123423835324128228699761719236470536e-01), SC_(9.9999999999999999999999946352133086863997866453265606964291902721075788956617650840192217286669480434e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1039855962733358235856119319992351624089039003894437206266992184997868488146121044090313989986981146e-06), SC_(9.9999999999939060790161031790048854122800525025491530157246372471675618192957937544032583120124753041e-01), SC_(9.9999999999999999999999925728254084059089171594717779716549198756776781947738509101413785094625002233e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1039855962733358235856097753534650786845235099906115144947522397478403943554791086939141797700992042e-06), SC_(9.9999999999939060790161031790048854360891111669261418452776441858828979839869050657863437644162286981e-01), SC_(9.9999999999999999999999339675561721679908336122257394570169189108177098828101755126616956979737756025e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1039855962733358235855995330935408806668462537517472271545340047744854478415433189166314745783526759e-06), SC_(9.9999999999939060790161031790048855491621854630174468753219353471168979319241999967181393215875699168e-01), SC_(9.9999999999999999999996556416443457432313835771620716336953193819653896202472963626655283033214806662e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1039855962733358235855609739265564540729776223890814603207590870228666564670837732271193746300381017e-06), SC_(9.9999999999939060790161031790048859748498350143300337130715674691237781851410398813792941216896341628e-01), SC_(9.9999999999999999999986078245229648644250269864900670760384459117732252998869740564579675468166528786e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1039855962733358235854122031339844451615266041666260510285189332449090652213256739742133530446398594e-06), SC_(9.9999999999939060790161031790048876172579564719910856316111425509873477955697488661074239224447665653e-01), SC_(9.9999999999999999999945650871971996736226665587649713758342525396292396251341489218147485387172444718e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1039855962733358235853549427625573921171507616996223830229632056498891619477584892812210651224385107e-06), SC_(9.9999999999939060790161031790048882494042093996546755801459371932890203613039054997642565795173033812e-01), SC_(9.9999999999999999999930090785421857569807094436050124428992380746214037672012348614899975744108817841e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1039855962733358235837690091882969420598866893480056987878026010097586828431188199875743536166275951e-06), SC_(9.9999999999939060790161031790049057578824357085809575440788048788367589764980527906302531308706754890e-01), SC_(9.9999999999999999999499124952276646324781319738535804573491063735590335873266675333408400091205322615e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1039855962733358235748080821247109357956421358027911839103705913128181211791262234090542438145233117e-06), SC_(9.9999999999939060790161031790050046852265103175605178475598074675610700982878749332961263832259234569e-01), SC_(9.9999999999999999997064058654173544703003236892543391984681430351462177662719045911103529899439969321e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1039855962733358235422911293978913257243371577207703658003257569482681051163819755260988563458049211e-06), SC_(9.9999999999939060790161031790053636677009616345262238074897278822289868626977773056067565369095115482e-01), SC_(9.9999999999999999988227814910615681354635879482529172561120099837241513658474840803780269817224906292e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1039855962733358234956668439038942747771256342243211185542655230450205244904998123252154495716123994e-06), SC_(9.9999999999939060790161031790058783930971810339576499575723339420743103138020498795040026277888925490e-01), SC_(9.9999999999999999975558006812196059991103747411512730964497542483718867699293518004533600635414229289e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1039855962733358233067531621916159000849328309047826153485081846473111038760396932048162382973789172e-06), SC_(9.9999999999939060790161031790079639729326755130809727838218305929044271604594182231757273320697884721e-01), SC_(9.9999999999999999924222097444348307711296069945283467844667849825817671734597422369341677101234829059e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1039855962733358227219503495208701616534925878668911249966705887524754013341793455820256791308285489e-06), SC_(9.9999999999939060790161031790144201117511658188400464759469548984550114042931557935345826553613394704e-01), SC_(9.9999999999999999765306216301068352140601845514306705236951892545835403088877659883403948846180082969e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1039855962733358166687001082658132625361092595998367455484759772839441455849505852771999601680844672e-06), SC_(9.9999999999939060790161031790812471225210433216453725663089519717662872416490122591928323907174373364e-01), SC_(9.9999999999999998120379798323290310257684416946582475528653414090722406476728113325643085742132642311e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1039855962733358066464745351006346839205172285172655467548123054854800401761594167225065465988133569e-06), SC_(9.9999999999939060790161031791918910492748770915922301555461424332325351941234742812640588889883619696e-01), SC_(9.9999999999999995396913403381425936213819346760916376568416003688323187463660497318580682668638157194e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1039855962733356226531982988510117404821522104067854208163952587539563852882609635812048055882635022e-06), SC_(9.9999999999939060790161031812231503170357210293476557495301194476235431068374841349394346143739355941e-01), SC_(9.9999999999999945398088185718106422190434560824671367149512609953634318581279705332823298219821336664e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1039855962733352347401019966400653228711083081293356178649177469381848327319081113522975556580368798e-06), SC_(9.9999999999939060790161031855056550262726521566125828908815956646862340493529985638179331291212970287e-01), SC_(9.9999999999999839985545410224675056732447529327275559590299805673816710200026990342417421939613233172e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1039855962733330099007037899778001666848213428146517030369808050254457861665100803445755650781480781e-06), SC_(9.9999999999939060790161032100675615227034989501712313656065469536793879609673107320704069166791371876e-01), SC_(9.9999999999999235401734067720030575848540093525528817491608989232391701624221959671025772890213261809e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1039855962733234598645627176520740117528640537364656284404942476065752732079115387717350241126821650e-06), SC_(9.9999999999939060790161033154985849591034089567778947301651849370898037880128614025829826217631350619e-01), SC_(9.9999999999996640249358897564192328291975542959572115868732031466661459379360753829743283926367640724e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1039855962732820082479575601365281476959116845896157284637161522161600574313997856996779066344716727e-06), SC_(9.9999999999939060790161037731184617027538451239456933996750170255571230436505776275526884895273344666e-01), SC_(9.9999999999985376076145471657550793317637601711415122337074116484291418184121457387702054604233843148e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1039855962732090643045005122499195426827193831280793202837534889090012654146811429399079674775130682e-06), SC_(9.9999999999939060790161045784090908227537673318906188110385593289743147588469486309713564441659776460e-01), SC_(9.9999999999965554093765457954537053229700993914073576598931540255465494117388470127500914558074800536e-01) }},
      {{ SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.1039855962727210380518152957925065662608065472771441817054591321342841959937888564558380879270419229e-06), SC_(9.9999999999939060790161099661486265015310348988940031375489898642725009840308203538615785015679551469e-01), SC_(9.9999999999832936533989495237312511095807646852011530453288996916599066999901455462304650969540492773e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(3.2917760108770958943021985341581923246385058008006577363897435558570089666555799076898078031863963742e-06), SC_(9.9999999999458210534709235993504687597229374788071604701246613387423215672804708404919520828035931005e-01), SC_(9.9999999999999999999999999999999998524117356081930224460645895661490437219406452637053801236289074905e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(3.2917760108770958943021985341581923154723239410612576648578988378930817599357373966180580998463309886e-06), SC_(9.9999999999458210534709235993504687597229374791088906456985657058758395954605133766128816671662146443e-01), SC_(9.9999999999999999999999999999999997688746252810818279792195553431116640549556040555326215783349623542e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(3.2917760108770958943021985341581920550665977110648548007642099389226543724014160862865971463879267979e-06), SC_(9.9999999999458210534709235993504687597229374876808638727343147004217747165874912610506085124099096442e-01), SC_(9.9999999999999999999999999999999973956354494978960339533748960307398057546452264842693577320252130477e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(3.2917760108770958943021985341581912811005909291136027281071025516972871162622351369765263288996490770e-06), SC_(9.9999999999458210534709235993504687597229375131580912164640160286198045063494158235494433399782332612e-01), SC_(9.9999999999999999999999999999999903420023569710007631276261642234982344215967632765456349568306056912e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(3.2917760108770958943021985341581907419474184674353205305512718401442993737127965162022461137910535840e-06), SC_(9.9999999999458210534709235993504687597229375309058060095365137541191973778424190364699116869699202417e-01), SC_(9.9999999999999999999999999999999854283645151375068159349860255705330720083781422832629456182697123316e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(3.2917760108770958943021985341581728211396952000877110971828011443613399470682047427073603172950540183e-06), SC_(9.9999999999458210534709235993504687597229381208186556026570049648166008276209012341017166447271313476e-01), SC_(9.9999999999999999999999999999998221049093581946706897065934523327198208379885809760072003735983674166e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(3.2917760108770958943021985341581186012882477782134634036468994649050771788527044677226251544324689332e-06), SC_(9.9999999999458210534709235993504687597229399056147186917579529315898651811464599269703595875035251736e-01), SC_(9.9999999999999999999999999999993279657157887106222121513438678485851360015901269706987556276379743396e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(3.2917760108770958943021985341580722208078703974192875042733816383031329956535608039793055938013268274e-06), SC_(9.9999999999458210534709235993504687597229414323562454922094158633906391093435706843061301543922367984e-01), SC_(9.9999999999999999999999999999989052715814591710038130951327361567730263020726237509040354327900832336e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(3.2917760108770958943021985341573336215288474697402558730041527120867191916288482129163612508092986823e-06), SC_(9.9999999999458210534709235993504687597229657453901290118545618056506171546187813651419320776898134222e-01), SC_(9.9999999999999999999999999999921739574526974627542996503780330377495906801806264605736523857688620072e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(3.2917760108770958943021985341559863372561403776060450901936227943750677945869117345983990341558882701e-06), SC_(9.9999999999458210534709235993504687597230100949706165441473998284413045447682224320847000995676401983e-01), SC_(9.9999999999999999999999999999798953187944945877042811233715654155310597472853003083913623907258755323e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(3.2917760108770958943021985341519810644925667503689385278568279129803073026384631542929087866306231777e-06), SC_(9.9999999999458210534709235993504687597231419395786187692306393465253179241329092495179845555633184238e-01), SC_(9.9999999999999999999999999999433927795845278100464046116182400680488280124700349380899730407811304415e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(3.2917760108770958943021985341088176829504422214472563122320920467980915882556929073819786321485320573e-06), SC_(9.9999999999458210534709235993504687597245627814177134747367594192799920268189489147538223490312033423e-01), SC_(9.9999999999999999999999999995500180657559539220321226948063990358601368266595072534769707560389136975e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(3.2917760108770958943021985340233395174502480951586737343327750184309891479312498150699946421909580097e-06), SC_(9.9999999999458210534709235993504687597273765311642019315691892449931706213182958641103971152107798438e-01), SC_(9.9999999999999999999999999987710024351243576616951552591065980711903253212212904944060298658282942916e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(3.2917760108770958943021985336921432104412810156856557930357164766329440053453545897142223479477191017e-06), SC_(9.9999999999458210534709235993504687597382787717472930348418956808180256641375152170364188394204942080e-01), SC_(9.9999999999999999999999999957526047138155129642489155249119192049431911063373371946076018628099964015e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(3.2917760108770958943021985309995989311003095731214928639699391772410330310153243764605713875799101067e-06), SC_(9.9999999999458210534709235993504687598269112984173629159078615704610575608458560078245186853021748667e-01), SC_(9.9999999999999999999999999712137757918314523800311227167947700338217352859763285746447293022659992385e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(3.2917760108770958943021985131879882384643889399307381389104801185143102583754739722116703407239740747e-06), SC_(9.9999999999458210534709235993504687604132296263515485049818923488718361186738407206939044034446095531e-01), SC_(9.9999999999999999999999998088855010202262687003642977535624651948480964743894631062499871507728928173e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.2917760108770958943021984532287997662621835816597342105198622742764506625128615812978806702983579394e-06), SC_(9.9999999999458210534709235993504687623869518088067792188616438316986946494540113142291140550702413472e-01), SC_(9.9999999999999999999999992624401632371492757680803153760020065455145870549797014996780778113132179658e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.2917760108770958943021981974283484976886521464289293137484591271409608884167832950798029229505935258e-06), SC_(9.9999999999458210534709235993504687708073296994266593718885853539078318775085051863837361401145467741e-01), SC_(9.9999999999999999999999969311717194802210024840142226239766631290179504113997530058982845816874993047e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.2917760108770958943021972295033754520121093526914996592147536958240964687744107031965496363351919475e-06), SC_(9.9999999999458210534709235993504688026692517656054608854732107594504149714918761883027914786414035085e-01), SC_(9.9999999999999999999999881098700587709012935668437053038543664415536903800342375347288135111845267689e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.2917760108770958943021933006221733835746857401287387867993702176320272200067335792474893484250783024e-06), SC_(9.9999999999458210534709235993504689319992206718546596401645066277904371438834998306444743296682915711e-01), SC_(9.9999999999999999999999523035346116324527479244501868824341843169457082765923898955344237158601889912e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(3.2917760108770958943021912886910413115359435002085999337045509792245383894627620294484599967071534342e-06), SC_(9.9999999999458210534709235993504689982274870331288300009054944423951097970300981345710537827167324100e-01), SC_(9.9999999999999999999999339675561723796689501636466733791799662917286547366633542416343793943228919272e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(3.2917760108770958943021341172124538863953592359085399884730106064473283724623779962504139289433980767e-06), SC_(9.9999999999458210534709235993504708801845042479214207252075885175590795305756452998882900074089317815e-01), SC_(9.9999999999999999999994129283506009562785328978365983263636577206917335333765887162833435907868019045e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(3.2917760108770958943018626006045501243179231245559137437641467618296303176064924330843605787167536774e-06), SC_(9.9999999999458210534709235993504798179030688196100111368828236524895729901907684462639742851791958159e-01), SC_(9.9999999999999999999969384288068242393708348952162177073808481885159581222687327650606229318697890138e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.2917760108770958943008404185567706626578761463718418152190785605521021397781201860840724141563175675e-06), SC_(9.9999999999458210534709235993505134658465052984844298960404610785794527021400238637944233992612605114e-01), SC_(9.9999999999999999999876226487136096119803043308281959786507589105613373691027361501850995642846173195e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.2917760108770958942968965876783067043224272309794753163106123793996813062387916352086283667716862703e-06), SC_(9.9999999999458210534709235993506432879252728418624720811680333183223534491963865041896362373277123988e-01), SC_(9.9999999999999999999516800675770972078933983146618486657200754194162477819172233872688174537493686724e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.2917760108770958942953786471132121014968898974755905062755665179043623935383449689055283962273802298e-06), SC_(9.9999999999458210534709235993506932551286542689435062225998634262288635406531202025683560190872268770e-01), SC_(9.9999999999999999999378461320959272466181886950344833665380562106876079286602692750735959745457959405e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.2917760108770958942533364310758561007254481723268987400861827813031949172743051506726479185179351947e-06), SC_(9.9999999999458210534709235993520771907106205749831110650901855701696508567037293819428989738633032771e-01), SC_(9.9999999999999999995546892961035086436933161876438125086376809884756813043826195296366505268295996768e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(3.2917760108770958940157872438862523394119314723129106101509014596736488169357160231418016777560025860e-06), SC_(9.9999999999458210534709235993598967778686038446789282906517258587406624478796679591563677091839748099e-01), SC_(9.9999999999999999973897559615888364568173453837286527884595453421634772303032792400487426539402674720e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(3.2917760108770958931537809318911619590830694775273517902415304968002273063727528718185249115726481137e-06), SC_(9.9999999999458210534709235993882720948592583386395603350300289634053075073598344351502607514069817586e-01), SC_(9.9999999999999999895337568673435721901670054994782604394475694931528167629240024841680851414882364629e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(3.2917760108770958919177970829206529966602810562828350952542730155997112168967311112453591838739864823e-06), SC_(9.9999999999458210534709235994289579146982053796969742778055931365417609646320922357273320988485624802e-01), SC_(9.9999999999999999782694681227045453634283229700387561617568796487222841776773805278310845484714623826e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.2917760108770958869098005641108532525692716625548167703484646492245129160067135026079887413667876225e-06), SC_(9.9999999999458210534709235995938099427308395877316694028162399809853740485660278830021258721616230868e-01), SC_(9.9999999999999999326284843290994433240171322687885706212969405815150148187663984877029482206915147973e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.2917760108770958714070036067906098247226639744032365274443636123709225921999751782925376482163632306e-06), SC_(9.9999999999458210534709236001041272939896565386787468261904151304949622299906864186978156324146730460e-01), SC_(9.9999999999999997913418636161994494750057633434216837342783690293914094711975092156721954431725321885e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.2917760108770957109387100405252339244274609469889693210386475069708108813201357024699341179619807134e-06), SC_(9.9999999999458210534709236053863840866964329953700947446502504079832216325886912942127028213198935573e-01), SC_(9.9999999999999983288946038113965299749578085446939138059299771834553987401586182801256223666288207500e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.2917760108770954452550902718909820406133956396304655013821211820776010219597058368695093003529002052e-06), SC_(9.9999999999458210534709236141320937471176354178480106323382777539465901886894896095672494070701227000e-01), SC_(9.9999999999999959075547050032290457424907038480449488891799548772314496124374485722335908241000146183e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(3.2917760108770905676957810476558239989956850911892343991035233895298164732847900220782058127814470233e-06), SC_(9.9999999999458210534709237746904210053333451468769843160130438237282019342565233664703001192582256401e-01), SC_(9.9999999999999514553262442777832862544633648939158146331107716792049359008550980986421190062325555739e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(3.2917760108770802843355803770403217392212205119325787806085118182700667262705446469082997885744989489e-06), SC_(9.9999999999458210534709241131956052049243644218405432753941827606845563884959360464212043728335532585e-01), SC_(9.9999999999998577366755823251193593662349229695961061916269979363957002656949632551705688360491916829e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.2917760108770213050818802698141190778218955858049735325503982661624086238023565734773930983936302247e-06), SC_(9.9999999999458210534709260546605299098880465619175980853138274504201817123443233523778866887607021395e-01), SC_(9.9999999999993202220922205034333786645157933437023469049728294337944004199321146637059433060337321152e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.2917760108767681389410507358371261443578113006448589619829073611802061535305224195609556159045836889e-06), SC_(9.9999999999458210534709343883228214444539272369556330246269666626261160866651663921492550826836768155e-01), SC_(9.9999999999970129617562176887676799370926737061206249481153783781566858450469101790428749723219951138e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.2917760108756692796642843052992808031780500181557227688810465326079687221961131040112810446127619063e-06), SC_(9.9999999999458210534709705603088875257046871716790470580158521260356116011846378924628202571937178443e-01), SC_(9.9999999999869983744349263197051738076255137502144014124667766353918111996160835747148730628753137175e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.2917760108737355763369764319228817860151633610847085929457262467134771200816090810207304816857952642e-06), SC_(9.9999999999458210534710342134911376770755226956219169654209950175936147353096872984576409489279496337e-01), SC_(9.9999999999693753345842021045590833789775102117090706787073631977392622693555322919414109285481856221e-01) }},
      {{ SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(3.2917760108607982721016282913185459267438918935319392886518735858016300126801901746111037405959888722e-06), SC_(9.9999999999458210534714600805684120893713968904749701182230070504859075669369334986111941085580438890e-01), SC_(9.9999999998514696430127372590670197107227463715756210343178265554928839637020716488139626665648674413e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(7.5172138166837221887933892809101279994144029457266103832670794717071307575490225414545112901616218762e-06), SC_(9.9999999997174574821673052181594664246834506373262751933474970817389807110157028185244016730440056865e-01), SC_(9.9999999999999999999999999999999992303290762406537841916503452443452506184408937354733701417835726066e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(7.5172138166837221887933892809101278902531902623261514636877853343673302974268585564301258279835161902e-06), SC_(9.9999999997174574821673052181594664246834506455321569558754312003435556011254957420324358067286694467e-01), SC_(9.9999999999999999999999999999999987946841071869805533452724244144505546874185285697413650970326865987e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(7.5172138166837221887933892809101247890486429442823671625537659260844189330168559253465653032599482663e-06), SC_(9.9999999997174574821673052181594664246834508786563336770780488104889579234190221705230375452792858955e-01), SC_(9.9999999999999999999999999999999864182719564366376428808229975077676326409447444780297771412820669779e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(7.5172138166837221887933892809101155717901192901641260429928149443455849790960175243744758434451427715e-06), SC_(9.9999999997174574821673052181594664246834515715373649562403301231908286994951082554505894219256001717e-01), SC_(9.9999999999999999999999999999999496336649922121393672632616431087173659837651779518457133264713856369e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(7.5172138166837221887933892809101091509471741456498823302723817256769100205438500589557250206522874475e-06), SC_(9.9999999997174574821673052181594664246834520542058579898432210712020188642821955139844954848596981091e-01), SC_(9.9999999999999999999999999999999240091060726561466341576531977941613294052389655641440670200914273257e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(7.5172138166837221887933892809098957297939314442199294518702801897550679986546345940031136890869843648e-06), SC_(9.9999999997174574821673052181594664246834680975302777292270330136235229188914252496367477310263916613e-01), SC_(9.9999999999999999999999999999990722793623817980876398598422734569322474687087313218862022795467472255e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(7.5172138166837221887933892809092500187633101654841069069803172470777175855128671460292114955833396788e-06), SC_(9.9999999997174574821673052181594664246835166370090888142990457373397494449047247558622202621783202295e-01), SC_(9.9999999999999999999999999999964953497457378610434410638699327995786294834869745249815210598812773612e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(7.5172138166837221887933892809086976677887924627470781957711229388817513329779325449951137698014785151e-06), SC_(9.9999999997174574821673052181594664246835581584128630193909288950059387442096159738387723302066828215e-01), SC_(9.9999999999999999999999999999942910052053522084027285880271300425411370652963271126034562337712670170e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(7.5172138166837221887933892808999015960744221455152373803891718831326201832174357789308783964324340353e-06), SC_(9.9999999997174574821673052181594664246842193779311197558920900284470551079562493576566490817681502208e-01), SC_(9.9999999999999999999999999999591872875422426184148516153081533375541351971981066676230812920540806807e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(7.5172138166837221887933892808838566182103062453848273736181421133806137804970613362697731495627871684e-06), SC_(9.9999999997174574821673052181594664246854255132240389995670407473222428441323743413430354358377280584e-01), SC_(9.9999999999999999999999999998951543429344134236035773717426100944710168141434392951840581113915652285e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(7.5172138166837221887933892808361573210885794592897306879911657472314882201472542205456367882004424079e-06), SC_(9.9999999997174574821673052181594664246890111713778357766357599621217942533810962843276827782175684423e-01), SC_(9.9999999999999999999999999997047940647031280395866501254740189775580694021238832032823176689897000829e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(7.5172138166837221887933892803221191812443220283225032808753380597911174551883889392204275489310143574e-06), SC_(9.9999999997174574821673052181594664247276525174503240722611875588743086351220037441309089042359167172e-01), SC_(9.9999999999999999999999999976533499297396813365256570928682723233208766886108992539496399180091009946e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(7.5172138166837221887933892793041489569203113372428151427105501440051652190642292279939910332733444155e-06), SC_(9.9999999997174574821673052181594664248041755158050969848980865258160917876275443396335659471617908957e-01), SC_(9.9999999999999999999999999935907933130465524797197853738582182237488113890368262113426371319056481843e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(7.5172138166837221887933892753598904791171529627537935697704243299375800329305888173331598424968555902e-06), SC_(9.9999999997174574821673052181594664251006738590726124087496434910501348276418319871373432219964019196e-01), SC_(9.9999999999999999999999999778498875438352048861772728840017224628792086074990256413667217652563196121e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(7.5172138166837221887933892432940419901619755108095194771664869188520795290988622205620155001552328031e-06), SC_(9.9999999997174574821673052181594664275111322521893252617105862642007953606485394554357608301065258383e-01), SC_(9.9999999999999999999999998498802064707071963907553766618600101371966945599648132060355953519130358066e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(7.5172138166837221887933890311733299199742108867189098118628780289486509721423060797815823939555557874e-06), SC_(9.9999999997174574821673052181594664434566997284279059749254543175203033820406010680176160431911764100e-01), SC_(9.9999999999999999999999990033403158460563016804106595269389153919687425650488735802777226248394349430e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(7.5172138166837221887933883171118127809020493162090026383183113208281874969019070982250938336233186540e-06), SC_(9.9999999997174574821673052181594664971342307559442619497839167770496406876412023079669685083559163555e-01), SC_(9.9999999999999999999999961536348216547678553035510529781251433375163756024066360150480453657178259792e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(7.5172138166837221887933852707520642266167513011819748676872520547120655826017758203833581445136395125e-06), SC_(9.9999999997174574821673052181594667261356066866287567178230825584380878837134883351760374590271125643e-01), SC_(9.9999999999999999999999839960995052016840538782807140196506622681344681926427598176411932890254571078e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(7.5172138166837221887933737436118153184715364320978388218932379474634694258780909446489047637292846003e-06), SC_(9.9999999997174574821673052181594675926553861705451215991438655671079373761433543879145751069442793922e-01), SC_(9.9999999999999999999999379931234153568306082152485447614369704871187401926120000775003011947107612503e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(7.5172138166837221887933269540714080326724387281037972971267432127285156834999071927373965201157471174e-06), SC_(9.9999999997174574821673052181594711099251825292241781928024856069527737990699712980659644736977722506e-01), SC_(9.9999999999999999999997512635389622588619229085139412464808578679153248089094924644930041115919597382e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(7.5172138166837221887933029937304969355253312858419925368936092632404137664290917772511705738187032206e-06), SC_(9.9999999997174574821673052181594729110752400736315122803000696388460975937728751657799893545861644332e-01), SC_(9.9999999999999999999996556416443520897236658133297962812444524882524114033200623342813410608845059153e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(7.5172138166837221887926221314010118184055225553117248675937450520082025980442095023871556655045356882e-06), SC_(9.9999999997174574821673052181595240929523461696097706418511196533226056477586686158492386248810026605e-01), SC_(9.9999999999999999999969384288068708494595998330769107554038172278863700824198372748418567827835201006e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(7.5172138166837221887893886059663221908668368062198433275119200584917698333997637163131149275081287470e-06), SC_(9.9999999997174574821673052181597671639730955084685263096586636982567917228475882547627976554122279682e-01), SC_(9.9999999999999999999840339451235026398845559588673184720381511162768834292102066559472771151094056041e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(7.5172138166837221887772153113899935488595266918773617402863470993320371779425240039152089963233788058e-06), SC_(9.9999999997174574821673052181606822565549587505834022846595107607574888201868919759720441509904141157e-01), SC_(9.9999999999999999999354522702902734104863931549408826747805219202307177749141499970496157216627363702e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(7.5172138166837221887302477334061539428318548238325737152958121742428032519364379163285972286271228711e-06), SC_(9.9999999997174574821673052181642129098166213994134045650839109471614582866294430771692141120291679807e-01), SC_(9.9999999999999999997480121662980317685005527861815219525043013751083235684359908521478254250941864620e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(7.5172138166837221887121703882909694211998874824254191207049082315421949574838571355991653139981342818e-06), SC_(9.9999999997174574821673052181655718225013480452682462942750820585595402121189927883586751791877819763e-01), SC_(9.9999999999999999996758683685177906755210533777467732010829886942239989608105974191610545102390663711e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(7.5172138166837221882114843494623914772516678382289174509585731308894402138776046862592973706717482532e-06), SC_(9.9999999997174574821673052182032094625914397559286857136211215648291370743491594848193907857268094924e-01), SC_(9.9999999999999999976777103366562540330262363752795590025457474443605920158714875703881383869786537739e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(7.5172138166837221853824812004554305853565831617974635868692726765812487620965512471267523337245066234e-06), SC_(9.9999999997174574821673052184158716781890172208751676325695157793934482981362527581954489871995383915e-01), SC_(9.9999999999999999863876105016871975423472590745980569694746216193719109314274336302466104962944539096e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(7.5172138166837221751167396083717486838102935788344417912316859444734726848852477531761703912304063783e-06), SC_(9.9999999997174574821673052191875694235559830136900620760593899284304323445844037193048401134566308083e-01), SC_(9.9999999999999999454186750322082358909831141978037163281303765421692728381989832686794429845936911345e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(7.5172138166837221603972524898220914871060146221667472818535962943112992083287465987696569357938484864e-06), SC_(9.9999999997174574821673052202940647430078417370638159516362441581612470219115422984947706219956429387e-01), SC_(9.9999999999999998866755523367453992485439548484896946413050090871910396962598290503139686021944795220e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(7.5172138166837221007563920451147399490166704532636156655461353022101256873953962329651110651890449897e-06), SC_(9.9999999997174574821673052247773957448731127323340981409612297634106756338208721370943545562554620461e-01), SC_(9.9999999999999996486584017017016257312457741560052955533038684677046754407018741960632518250824946903e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(7.5172138166837219161316331497329959999867756479357267189497397613110197432901711919680715818749384581e-06), SC_(9.9999999997174574821673052386560336299678888132310276552167314070872054658530921110313841524562744259e-01), SC_(9.9999999999999989118504696682465397719850280164267909987134203540807245047281634018094783507632379851e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(7.5172138166837200050945414824887947561618756702997475737696161600578502566283163785416334328846274627e-06), SC_(9.9999999997174574821673053823127779307876296402504872395533889432587658537704133837488944462610307832e-01), SC_(9.9999999999999912852065895348314652358905412150858908129740242395128839896450115204654087372768756774e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(7.5172138166837168410348961631530872640592517556712141861176979773712940203947438109360635972318325174e-06), SC_(9.9999999997174574821673056201619067635668386475453074557799791883906182278496574218891824217398113920e-01), SC_(9.9999999999999786579497793077250830014655181069057279515050098918370886407865508449809298293274877944e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(7.5172138166836587535675867088577429248818507199324638525753612362543530570440089422014466215554866541e-06), SC_(9.9999999997174574821673099867210252348593889935594794890173756867420001985291992416360583825331645619e-01), SC_(9.9999999999997468401431026190294097293122084391697268166678684686078469990387581320017168279984577241e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(7.5172138166835362877375232710546615190752471996590689740798059220264290277420603635416155639454858768e-06), SC_(9.9999999997174574821673191927393237399700236834434761854032600230024667143088977599944601887582109873e-01), SC_(9.9999999999992580985705547418802312879591706428938747051059777414919884746154671346234026834130834341e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5172138166828338963868405934097532574077843536616954677632125309343526289938580130664423389658227966e-06), SC_(9.9999999997174574821673719929989859376890919864926985106846913308637293456496545806214767384490322909e-01), SC_(9.9999999999964549668472091583476623325692488165715222809896128726240554794087634817556440769840322623e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5172138166798189089726469691343498618134406783430491249066201771810752404672146124160916793740112971e-06), SC_(9.9999999997174574821675986360494633074932172246614808474370905053006981099249157029190873212203965583e-01), SC_(9.9999999999844226335076844363893776941067155723352946363123051839251379553609078509633316389453006581e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5172138166667324556319146020107269718904382915808611945932476119315173571925693864073499038052966946e-06), SC_(9.9999999997174574821685823727281331372020445291832255099738391786372744765348762197405587275839274938e-01), SC_(9.9999999999321966878581318602282185018385397721934306734478657715117969474107727867331605641847943940e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5172138166437037394872332848154728844871986805194786372163417623433723784052983391967529631323126795e-06), SC_(9.9999999997174574821703134905600083434823204672369115492326500305511024592434012869489200004637134058e-01), SC_(9.9999999998402927589298499544907370693374144035737976275964821543459157841998352873995286790001393899e-01) }},
      {{ SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(7.5172138164896317561048107757051043871652735250514052455752176914197183379076911239211493105045117396e-06), SC_(9.9999999997174574821818954109826173471866207759928049187583886372512274404380030281765846710358981786e-01), SC_(9.9999999992254160753323058553001265377532843228811113779902149783857676792550151228365811304309474381e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.5114666893502755809122441897204361549566045204711575522576181651460783722368167807911214893635142969e-05), SC_(9.9999999988577342234270202117031785546445257276087247262434106801237120149823932756676887785846244310e-01), SC_(9.9999999999999999999999999999999968883665292583937731777979346978721327199336385381336468802761846427e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.5114666893502755809122441897204360662219254822115894810326672355313574979379329878478781141704251614e-05), SC_(9.9999999988577342234270202117031785546445258617282362980809084064154833901250400983837579384615164489e-01), SC_(9.9999999999999999999999999999999951271365993988535409799543460607160684286457411284284221834085123890e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.5114666893502755809122441897204335453229415512329733725793534839735028163730380942002443669666763678e-05), SC_(9.9999999988577342234270202117031785546445296719830781619430884314292273325810411457348994890557160239e-01), SC_(9.9999999999999999999999999999999450916511637958505037535154164649246826110224567950853477558914884801e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.5114666893502755809122441897204260528221108648540705512040170722468537719124750673878955326386931178e-05), SC_(9.9999999988577342234270202117031785546445409966485049672516618503438227716432697885114490889219819899e-01), SC_(9.9999999999999999999999999999997963784664706657178396297836887080342699786913280604368312708358511776e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.5114666893502755809122441897204208334642099507439101497044859586637140776507613604341327679168060251e-05), SC_(9.9999999988577342234270202117031785546445488855341128972258446290121874058740749300061978181551134373e-01), SC_(9.9999999999999999999999999999996927832379831057788578978085000202468600597117957849163645057591740032e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.5114666893502755809122441897202473482393078450462730379291220408334110696606434891915689269716087635e-05), SC_(9.9999999988577342234270202117031785546448111026726768230780537526166722610638077042533834561672038617e-01), SC_(9.9999999999999999999999999999962494015320070252937957459832464170745113590997215591476185002276985132e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.5114666893502755809122441897197224643575226457519335838252609338459144006722707165438049165095307422e-05), SC_(9.9999999988577342234270202117031785546456044471758626406987800734230007611647497307486080044818990231e-01), SC_(9.9999999999999999999999999999858313641612699299345777199719867999286071752971230397629341137961685557e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.5114666893502755809122441897192734707522349378251394442778305321141557181846284009884354077116255431e-05), SC_(9.9999999988577342234270202117031785546462830860540638155837308087654158513152954010701670053898863292e-01), SC_(9.9999999999999999999999999999769196175418079679681191584428534415248885451904364651626260545766153354e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.5114666893502755809122441897121233431456839661891667351825489610746811718805437382531913683793648170e-05), SC_(9.9999999988577342234270202117031785546570902657572038896446858126174096141088251368285940859333188347e-01), SC_(9.9999999999999999999999999998350019492810953624359122131427365799139182044705717534746814410871322319e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.5114666893502755809122441896990807438015599236457140726234787085948568510281013766699792689002662886e-05), SC_(9.9999999988577342234270202117031785546768037202106409323310211842270477446263041318122980397708468513e-01), SC_(9.9999999999999999999999999995761289068921855868381852120549068281563465216874496399304773789099661635e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.5114666893502755809122441896603070647959708800886642578762414575271680449768067546217042481464721950e-05), SC_(9.9999999988577342234270202117031785547354088444578431522045982803097713289958223184597209835007462262e-01), SC_(9.9999999999999999999999999988065384300283912228978750080240170255054958048474918016232906460053805674e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.5114666893502755809122441892424570956425933080819654249882912902398619720462175815330606666042418707e-05), SC_(9.9999999988577342234270202117031785553669751540513551829203014949610421901996466689409499340017247964e-01), SC_(9.9999999999999999999999999905129391310834465543984389503722161481899959828100687812804675188145209095e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.5114666893502755809122441884149721410014467439826029826707193592950226178636468217786975440141359822e-05), SC_(9.9999999988577342234270202117031785566176910990728369385275778736448714862618652793227701602482558071e-01), SC_(9.9999999999999999999999999740887937527689469267334875982203312775971624799518999813747466254916049411e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.5114666893502755809122441852087736986400700457149433548535502900463016994440892479543508815940684458e-05), SC_(9.9999999988577342234270202117031785614637532447023464340678543239441693874737582583894206001567482835e-01), SC_(9.9999999999999999999999999104512991569846812071014969506927768799084751026369737867205989545775659261e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.5114666893502755809122441591431712395573186829084130777124856038097362349544116229950307261100223793e-05), SC_(9.9999999988577342234270202117031786008610431039527722461968562508339897443674843119624764379759365271e-01), SC_(9.9999999999999999999999993930941656403004870716646089239377460357922222639040202872364612687767255604e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.5114666893502755809122439867150455324359709690093121398234624645526656391599029358433952955591255479e-05), SC_(9.9999999988577342234270202117031788614804114471382798112618513699755182636890471053318715484828286065e-01), SC_(9.9999999999999999999999959706940506410027821744717970289771042487964553393819216799978284385483309410e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.5114666893502755809122434062706003000740255217285205854679103771838474445613382041361724998278946496e-05), SC_(9.9999999988577342234270202117031797388028555344672806771443250951647711417516234024062833157828284127e-01), SC_(9.9999999999999999999999844498755764661986758061815733935601060088958819710241952801421566624225909679e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.5114666893502755809122409299537119283918732612460379145762190096713186311928725736622573336578788904e-05), SC_(9.9999999988577342234270202117031834816733450113249279393137348772890348338621262383740977554063888346e-01), SC_(9.9999999999999999999999352992676418122439818950282586757844422976457157733269851102813585086234101282e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.5114666893502755809122315598023085864978316610157840858399097251295568933631409349886520289780643717e-05), SC_(9.9999999988577342234270202117031976443450669490897973075718078292891740351960605707900202113534036145e-01), SC_(9.9999999999999999999997493179661061910664657923160555874767326386743418470657193146307583851124981297e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.5114666893502755809121935256439447564867654069049508876876529686670439729251004260668637391409756614e-05), SC_(9.9999999988577342234270202117032551317084979179156811105493664030880342177771624730591039563839278304e-01), SC_(9.9999999999999999999989944056951268554850473203152174958049623554443358907841369389849269405422605522e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.5114666893502755809121740488251358647508601441407332530425187831851710694497323044535876109269356346e-05), SC_(9.9999999988577342234270202117032845702713454313518171271181998636965451967367204996533681506761272770e-01), SC_(9.9999999999999999999986078245230703144646957268344184051228969247631998319177757229917176179749808200e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.5114666893502755809116205912481178444725669610940649438051489686255698634584062873798461553619960664e-05), SC_(9.9999999988577342234270202117041211029630722378959582618518615302113150946345670503613207100841266795e-01), SC_(9.9999999999999999999876226487145074541753333880585422871628794796124397742096930538519701955357787722e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.5114666893502755809089921316097900625524796192485416442010956519818848215114321495050054788009786369e-05), SC_(9.9999999988577342234270202117080939321511601558399136012309864043128463227470310535881800780770986404e-01), SC_(9.9999999999999999999354522702939729561217656790590957089710329189621133962778687825713512629515338592e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.5114666893502755808990967359787284531956895197443755253577240618768166199306047139272015913064382553e-05), SC_(9.9999999988577342234270202117230504930271604643047665550910691121800456340054627122700341646651013827e-01), SC_(9.9999999999999999997390457791439614529227147174918094963157152231693239261824184934552361599808555529e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.5114666893502755808609178548986157752223081169059178449881438156244703845554023298784769933408349418e-05), SC_(9.9999999988577342234270202117807566000230078182878632667523671132038332465105806908426474698468783435e-01), SC_(9.9999999999999999989812610125156845693720707957979138062382147370921219418534092642057413699539018638e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.5114666893502755808462231902166460717216997035778382694551171599749657395406717299646426315983183326e-05), SC_(9.9999999988577342234270202118029670962035140152099346720281549862712881257975319911735361963940826487e-01), SC_(9.9999999999999999986895973300902820110636488217683722870106837581718429863674863090276176773185855115e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.5114666893502755804392268417678038203596516818744016937094574360493332212069484148490109241904485783e-05), SC_(9.9999999988577342234270202124181285196414045651379243600147326504081536384921163978198258731356783094e-01), SC_(9.9999999999999999906114236329433525919616472639418634360455830698827599550189187081031356595778086002e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.5114666893502755781395942135244650742549055365947538634860831427766891550835513319892285208620372957e-05), SC_(9.9999999988577342234270202158939466353712676249481021233203473988060907917103172682404590275526444903e-01), SC_(9.9999999999999999449676927214085711768956571199446463168800949020732874788307405821436198425905736769e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.5114666893502755697948052278504633086011119628710718550203220338256145926381467084180089171991676893e-05), SC_(9.9999999988577342234270202285068172183153202997772308000159941316738785128872620985324122823117463567e-01), SC_(9.9999999999999997793380620153081090156255159417801924472583701501218983881087143374660425240452031647e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.5114666893502755578296673096738197101020203310470608614019457999612631707921528011243094578359289469e-05), SC_(9.9999999988577342234270202465917246171869972265364472975269527516099310431039559472167611260515512267e-01), SC_(9.9999999999999995418507656753527487987209517783611452864297085683225218063681314185946953898131260374e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.5114666893502755093489617638705983780577014641249410573574746137152373854191896427608181037729832225e-05), SC_(9.9999999988577342234270203198686961342379127001423352909433072004259029691612346973077427532154839473e-01), SC_(9.9999999999999985795925983678398909111831237154483921200204212331839853169597247562006760770296168469e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.5114666893502753592716740498530117317263168765787658531646976799002011275869825229035806615069553340e-05), SC_(9.9999999988577342234270205467055173679236341865697111412366257953067036403359746319487567729192725542e-01), SC_(9.9999999999999956008179661848284202838019198188852481403130145385752930827347747482031897689987879454e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.5114666893502738058328765978688303601701267591617316134424400481389638044779013898593400521543973767e-05), SC_(9.9999999988577342234270228946765139291466189583970723255596303536720049333292208996130378130800726641e-01), SC_(9.9999999999999647677442014418938352805843083365840328037695035234416660674114461604583194017188524782e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.5114666893502712338404061623118262055861537508004879394682987345895787095207856380078767219540154657e-05), SC_(9.9999999988577342234270267821574586962602795477212879686385086809046349413263599340130751601951861721e-01), SC_(9.9999999999999137181414147868337059048823417333689317623861305814746922136980845470371008468120323600e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.5114666893502240158529805464745454001262047817294456522335960746216983941027123463012188267617996511e-05), SC_(9.9999999988577342234270981505725988256214004744587127219101133573405705553756236809556874649256616395e-01), SC_(9.9999999999989765227451721438932922533771197136140050841199046401588066739762309016487774591747133203e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.5114666893501244661516104247116536267022879123834886566400946068895759698040167501607913259999534492e-05), SC_(9.9999999988577342234272486166301717092898147680246721764131595117020508597120413937312796398245131776e-01), SC_(9.9999999999970006333244639633785300718535565183275160062468662121016874101025024365191191436203941066e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.5114666893495535081205482933123219717518524068204214288221987475384369077512215203491044560270360063e-05), SC_(9.9999999988577342234281116006752374672825701635271430920520716441014966448685478812796774163767980801e-01), SC_(9.9999999999856681037666954047730479509989479949175010692399509231756452825208490939750476167140496153e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.5114666893471026930926992105399435543812989935853594238286069610750097018560874523788301785784034920e-05), SC_(9.9999999988577342234318159259520087833547066715583809346803113494916201976538958323936446676900575703e-01), SC_(9.9999999999370236636630240174257407349267153551373084057956516308716325920188727686403070490600039577e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.5114666893364650113704927591500397151248929696632299082797966987888291983686656535893529986179741623e-05), SC_(9.9999999988577342234478944275287803662582248852922667847170242859506362652018960538009554090391239751e-01), SC_(9.9999999997258840772410168063184673300925303868576074440684814162315282229985907317364551809594001317e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.5114666893177454892479790702111233397731335623327199061218812012644422824336122810658936873010769850e-05), SC_(9.9999999988577342234761883616603135572696658229725244787700472671470976532364174802054521416923627992e-01), SC_(9.9999999993543339348167524011710982921878869972135141676171007260783776232387358028135220652464671552e-01) }},
      {{ SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.5114666891925038612212723569174311052026018730405792256741035456345672847973087368310497107662687692e-05), SC_(9.9999999988577342236654869105523847118546359982732842042936475093201613348384627678340757336108325726e-01), SC_(9.9999999968685041991357330794203132754100574867412552489415580426373234824203192418460551010028951787e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(2.9863993399994057138552685209895810722593458640969216721474810122028678824043007145416412787153149711e-05), SC_(9.9999999955407094900312933831355486804500936926719975374042043770210426165651296057623789875689036230e-01), SC_(9.9999999999999999999999999999999878524964252124617155496699368100666391343787137608513976727532822660e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(2.9863993399994057138552685209895803878100446795502280530629461145046795244699453004970923532554360160e-05), SC_(9.9999999955407094900312933831355486804500957367109397694852553739714253046341697903029332901313864862e-01), SC_(9.9999999999999999999999999999999809768322217764012018743385196688596950935275265858439048467017348141e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(2.9863993399994057138552685209895609430161195846873541428330583215889786691053468471413080223227009622e-05), SC_(9.9999999955407094900312933831355486804501538066307099923016223930206082378528221663283998749110396764e-01), SC_(9.9999999999999999999999999999997856433381228211180557805968193920256139462090600914305171222864080014e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(2.9863993399994057138552685209895031500876583593397648314684185063863332862068406173820103110314455823e-05), SC_(9.9999999955407094900312933831355486804503263993942001926769498475072658079334740856030108204352073677e-01), SC_(9.9999999999999999999999999999992050820478345758774609057560758063059918535580169437649870477954066220e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(2.9863993399994057138552685209894628909025614886318531436515327536178709846071094858445737535388887931e-05), SC_(9.9999999955407094900312933831355486804504466293980560153211675206237939033254204553952479092539530402e-01), SC_(9.9999999999999999999999999999988006567129690135028476809120819063028357554905165994848458562976275088e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(2.9863993399994057138552685209881247236579502531301458766794216368752450412890149948705440837255726505e-05), SC_(9.9999999955407094900312933831355486804544429311759538993851129760606091554865311420695272477821649698e-01), SC_(9.9999999999999999999999999999853580414512385492816353675128101153496791904644499746357717861949434894e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(2.9863993399994057138552685209840760652305499359286436254452576656722977622920494911465915160173486166e-05), SC_(9.9999999955407094900312933831355486804665338420368169269357341981737351764760244166799126931449913432e-01), SC_(9.9999999999999999999999999999446870731661669824053245360941460106789736595477513100248333269915512545e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(2.9863993399994057138552685209806127816225369048030378780169732678870774664641842909510089690940874160e-05), SC_(9.9999999955407094900312933831355486804768765899226299353685996268594057236696134872542885418685802504e-01), SC_(9.9999999999999999999999999999098965122162894102394460164353137196274270280916074297382882079326649253e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(2.9863993399994057138552685209254607272428275446435507724366305452885746463303459084632555734246040776e-05), SC_(9.9999999955407094900312933831355486806415826487952525183654461726798337183020409083581348067747493608e-01), SC_(9.9999999999999999999999999993558642334364739493005445622744674487402549265716028074658345867820468244e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(2.9863993399994057138552685208248574670127804998082578339376688427479562467614758176897264399876338360e-05), SC_(9.9999999955407094900312933831355486809420241588820290715799088934193100889857551323291683583068997154e-01), SC_(9.9999999999999999999999999983452499572357716896656805805890533620655639176046497908014534282321232901e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(2.9863993399994057138552685205257791609055736049179845992546143841711522124248924177377124978375537761e-05), SC_(9.9999999955407094900312933831355486818351914152470212006424806078824827084178010717016959082725944468e-01), SC_(9.9999999999999999999999999953408462712845134813344884645836514986290164209798608921200857544273740756e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.9863993399994057138552685173027200087594231674319340851435491422242721614933756554448795507103706310e-05), SC_(9.9999999955407094900312933831355486914605331442875485340453832142246134294411004300875016827255326623e-01), SC_(9.9999999999999999999999999629634701827769319510981488014027483272665333442018597878933878803290848923e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.9863993399994057138552685109199674583089084554873974901435465561110944770069194389162530513544586219e-05), SC_(9.9999999955407094900312933831355487105219811568325426139112307081237565153066661475038313266408868322e-01), SC_(9.9999999999999999999999998988452613474814475273042306083594318658257311833771276716725412020985662925e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.9863993399994057138552684861891597615003543656143979491060071103459293631309387354220591401519551789e-05), SC_(9.9999999955407094900312933831355487843780489731683977095991942603927371918452482753548569949474113823e-01), SC_(9.9999999999999999999999996504108938804894105080083875513419982656237894761279416701176530996046613485e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.9863993399994057138552682851337935682998408044044355995399952797014242900592907705751461811441953820e-05), SC_(9.9999999955407094900312933831355493848096621436311389276297131120454320519238046780845206537299549474e-01), SC_(9.9999999999999999999999976307007680159783244544108984142450273935179201345218966782616354564483402415e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.9863993399994057138552669551204163416279517958506667892731417133935566411170180376223132748169012719e-05), SC_(9.9999999955407094900312933831355533567607358549530630430246662642456616548978526892293555067340352295e-01), SC_(9.9999999999999999999999842699955235776387442511317054159282051502648650933674629874243838099195172411e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.9863993399994057138552624778991177279769541589483695268882381677525109023666931327692406251153123128e-05), SC_(9.9999999955407094900312933831355667275314730284576727160411081389814784863486763939001126189303481493e-01), SC_(9.9999999999999999999999392938809151426746648894748550683422957872116739435147202132682175083810492762e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.9863993399994057138552433769863502777639527442336672513026022687204300246435889009278812464015538392e-05), SC_(9.9999999955407094900312933831356237704847805651058896792680255665961608161442659349862038105111672444e-01), SC_(9.9999999999999999999997474148594290770355073802615519023328157725903608316414002336245959787647921196e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.9863993399994057138551711009196588604455051778646667921856324711102021882239376212436865068632511659e-05), SC_(9.9999999955407094900312933831358396156827418184609901198608910806867123655569323026586276114275101069e-01), SC_(9.9999999999999999999990213625957255527069889493417722472189197087009727005830266886889517335099460313e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.9863993399994057138548777268589712518490674854622826131179467211059804111266803397556003326222669902e-05), SC_(9.9999999955407094900312933831367157477843429311280452869683446572542933228127158124660394569903528005e-01), SC_(9.9999999999999999999960742611467278116637388236871490944775616489806196911686791367016840758814707889e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.9863993399994057138547274936562648316647680942448194446486637303191219771320853035478193007308350230e-05), SC_(9.9999999955407094900312933831371644041219514501935422487249927101608568250994114016072066849226371430e-01), SC_(9.9999999999999999999945650871988131892995858503053883533560821838625129595767996006205129093041400534e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.9863993399994057138504584338486337697947143635710582433133105114793637595071333938960271708122169338e-05), SC_(9.9999999955407094900312933831499135215195640451048288262995008844387794450581793780913861773892316186e-01), SC_(9.9999999999999999999516800675912875207635258001628949607526814216134668863251471506064420336472907400e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.9863993399994057138301839776591935088685678966544201804383240136602042294643530069151352653029550966e-05), SC_(9.9999999955407094900312933832104611441295552503659820727144048424457419297816816809789114030879375559e-01), SC_(9.9999999999999999997480121663681977470623738951197798674453831080462776470792412560881614942967873485e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.9863993399994057137538564730349363162661956796680770734028095726533523630836405424033973131545511201e-05), SC_(9.9999999955407094900312933834384055536648855521848035127184054687421494476107676413571355523309399172e-01), SC_(9.9999999999999999989812610127409633972672731672325743343110027737524226484828390383087518568680868165e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.9863993399994057134593661028829920088392155622953675908051235103852759984957680581870708988852991195e-05), SC_(9.9999999955407094900312933843178714011150120907191222785574695567693988356194867909659124767882528997e-01), SC_(9.9999999999999999960229456301317678552650052920274420663209875493223754414497818748670169885106281494e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.9863993399994057133460197417790225018767336688332384491273044291298339386018981852437037073972200467e-05), SC_(9.9999999955407094900312933846563688992581868055805468821064996318674604815494777586873532988049656825e-01), SC_(9.9999999999999999948843199988636149828231056948818481492600057138866436228407735833264253609763552057e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.9863993399994057102066793023961005858643158897925420487421126492143187397021542504303319972549726368e-05), SC_(9.9999999955407094900312933940316931196455185821637109261888068802472414554084279030316718040439774196e-01), SC_(9.9999999999999999633479437557904175690780457587558772740189679415056887685318174564500370502756468497e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.9863993399994056924686093342421079127712042382733470415120307301631766060972535110105445449887278256e-05), SC_(9.9999999955407094900312934470046535890260635988045803981616965770229306326854221969195350132548821039e-01), SC_(9.9999999999999997851594168524712108328468155330774746245438493198138188885804005457475918003945741960e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.9863993399994056281016104147506752993442830825246459736261396118206528462543469298348809436686896886e-05), SC_(9.9999999955407094900312936392302167656566981921049716882718663628837634394956823922489952350487205298e-01), SC_(9.9999999999999991385580256501932837690972595883682188061941531260305710021962107151460579523353072110e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.9863993399994055358092803422920742970967525566663890616576280305256606807005860681307456469916288177e-05), SC_(9.9999999955407094900312939148519705039621032547869818957317429430898384963089523620694426192939978330e-01), SC_(9.9999999999999982114315474250209818744659363038290122294142068009581630772501414086022907492883927185e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.9863993399994051618564426084505355656322250952339246460526460060201236198386518508980403600666854710e-05), SC_(9.9999999955407094900312950316244788012125034999915079088741308393768201340535196077814977589967998509e-01), SC_(9.9999999999999944548726091222301388082444194143060410381335541195702673824195023146161803012545826850e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.9863993399994040042448322115531201876781269185119015711454639556037221098544036767318314397464947556e-05), SC_(9.9999999955407094900312984887150296077719297902269976796413442173007235163100896717324574417619045239e-01), SC_(9.9999999999999828260365546284664807449602627748095163055167823489918146541836789953659791723383916123e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.9863993399993920218935026875872103308359044794983837825451913007930345791178622671746915791941526377e-05), SC_(9.9999999955407094900313342728011476962165816975738940019583917289294712702733798947668309290191659746e-01), SC_(9.9999999999998624568229885989873182565281977345353903818799719644953099371310190306815702146287514167e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.9863993399993721829932201667151189529482117917018031591897015821318630828245999881692335106752288024e-05), SC_(9.9999999955407094900313935196798841500085330750487050862348748072905188551563654140959497819781580417e-01), SC_(9.9999999999996631643169227814061221330108990142822491416135783410098383514079305891195968772975986891e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.9863993399990079700513683367057994884394688139798348371364104916265613444579543968933035807065298169e-05), SC_(9.9999999955407094900324812049695346490105414609928508018163325063169352814325563517330878958753312568e-01), SC_(9.9999999999960044479118000436677502021205466394666575090722424624839485697249481669839686805663158925e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.9863993399982400997635125164813301081707471769255027117718372502906419569199788029921626901113291069e-05), SC_(9.9999999955407094900347743722914144139089661104802777149595306299424879617022359863673551977755336191e-01), SC_(9.9999999999882907746828922958366274205899875071561352544445849015188592724408154291499958059425749238e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9863993399938360513170478950147743305716569719765281719006480214780956313031992917708536250882794335e-05), SC_(9.9999999955407094900479266196711119054752676315167633638971616248581919080476821534247890325519073382e-01), SC_(9.9999999999440497210341622306749013732077773129623446587734137009229437663992031752845287807300342127e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9863993399749318455282732775644220401228556094381569116234969057348365192085940271108762069400260129e-05), SC_(9.9999999955407094901043821273868125443640816820577376202473869425077056300810262741934717713489795903e-01), SC_(9.9999999997541467277648931839061027543928744753987920241028299907860921409514515266589225697656096197e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9863993398928787643673300635388045453140590552846482919493020780242479984729738420755119999090988337e-05), SC_(9.9999999955407094903494253949146684308673144578696205772346829079482777169546998329492337862489316980e-01), SC_(9.9999999989298790545587142154545469986260455225561259439969475023714925202984934931532808943048426336e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9863993397484869214735661787946792358602504845851960498126868884273239662463974836894369365191956712e-05), SC_(9.9999999955407094907806370994003864777468631986489043216751730907819600997639777962629751930090305521e-01), SC_(9.9999999974793847320269036649402369448899701124006544966809498424893845718193097177115619145298445636e-01) }},
      {{ SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(2.9863993387824435920585628113288869370331518277223092565749324368221899838310474388050091725129987678e-05), SC_(9.9999999955407094936656282613536641018716177033104837953707482427496569021596469017488516861384178103e-01), SC_(9.9999999877749558913828655922417450074657350084634062745063310681289359901757327758115529259085362156e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(3.3870281179478834302359274626899094241397136552586916679856368942968284424941265110261908141439431656e-05), SC_(9.9999999942640202624701361477356059511791237775031554025398343517231445185366213880053203696426086474e-01), SC_(9.9999999999999999999999999999999843746815314362578344480091441003838119750151774247492957437563065459e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(3.3870281179478834302359274626899084256259683289124513637477052298237601274199827239508145308057321294e-05), SC_(9.9999999942640202624701361477356059511791271594972889202315074273108521167060929139814383320958454806e-01), SC_(9.9999999999999999999999999999999755305233716827520821878034354506554823835095721911381890529025514682e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(3.3870281179478834302359274626898800584496476822093551617053714697619110195656901148971325590185900887e-05), SC_(9.9999999942640202624701361477356059511792232399211688475353693909047823608901146595275180705821574226e-01), SC_(9.9999999999999999999999999999997242732972196109858856069290583585312929804042018639882140159302184438e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(3.3870281179478834302359274626897957468237152359985139869572977238896029412481448747152650945883275569e-05), SC_(9.9999999942640202624701361477356059511795088057690357467789856824638856202390788704724655794731933082e-01), SC_(9.9999999999999999999999999999989774980445576437362473573426361902207281255444611520231754256057069509e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(3.3870281179478834302359274626897370144243610519522033802755482432389639111177424564201319951416658153e-05), SC_(9.9999999942640202624701361477356059511797077340571970171166098226103127442510524818416536351164570922e-01), SC_(9.9999999999999999999999999999984572862483540379452524161391447576257209467807266594533278662523067569e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(3.3870281179478834302359274626877848195941854118460932410509543118458764644123256869203254611008220177e-05), SC_(9.9999999942640202624701361477356059511863198728425071127460208607940121852683977254436529205342154769e-01), SC_(9.9999999999999999999999999999811660672565878579280394680134611188519425847692014145299706211888332550e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(3.3870281179478834302359274626818784053676033372411874056668817122048839765371125002844198207571560105e-05), SC_(9.9999999942640202624701361477356059512063250639156629374826190030462925051502955829613709052083346372e-01), SC_(9.9999999999999999999999999999288510522441132540513498180177233672775033804509672689682399073789909097e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(3.3870281179478834302359274626768259693718625468727324904905938584131256881241360627824988269224163344e-05), SC_(9.9999999942640202624701361477356059512234378067071848416576418329212076563645737337664047935272776555e-01), SC_(9.9999999999999999999999999998840999977418450838865704609285834024114030983607149187038155974110906199e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(3.3870281179478834302359274625963670014310398937266617738212229164627939507805173967656064159684611598e-05), SC_(9.9999999942640202624701361477356059514959545936201335592858530941647394330375999178777021669854859204e-01), SC_(9.9999999999999999999999999991714489789953766398880527107036480563107709826145349483969915503691752822e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(3.3870281179478834302359274624496012176242708488048913433095225453177374287627602069100577702939088352e-05), SC_(9.9999999942640202624701361477356059519930544304114559230935931272759020788517834581952916385059372968e-01), SC_(9.9999999999999999999999999978714971150347849035901548698443365423494193668913537978028060830804430740e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(3.3870281179478834302359274620132886973833500740661890562571312505588159381469334406692356305613164557e-05), SC_(9.9999999942640202624701361477356059534708572055278242868571367198609515287826345762232161411579815722e-01), SC_(9.9999999999999999999999999940069364576047048916393974499215148592191469807577939377016778163578527004e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(3.3870281179478834302359274573113058626458574987846328474233758403701534707773202062162648350245780928e-05), SC_(9.9999999942640202624701361477356059693966052860269844011907618170757476670508280031238910416898493827e-01), SC_(9.9999999999999999999999999523599585872368011950774811215718811073219096877018381692548453803925622387e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(3.3870281179478834302359274479997817751616609199448584832607782964745050035761581006543562341379465757e-05), SC_(9.9999999942640202624701361477356060009349992093753242495013756547717212355159002733753380603281645061e-01), SC_(9.9999999999999999999999998698847877410415773181853536688026959427932785882608259544488628978937941063e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(3.3870281179478834302359274119210665576152083442967628232218928936269651541849193705832250607101414769e-05), SC_(9.9999999942640202624701361477356061231346221807328033454911708072023852300472638960539373390752599897e-01), SC_(9.9999999999999999999999995503239754055048558835363076445211566841209413810920965866721688972914299552e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(3.3870281179478834302359271186100114245439047104626880398575595262248939361091997565461234491840239180e-05), SC_(9.9999999942640202624701361477356071165874137912496826718265773556332385658362298725908048945299249165e-01), SC_(9.9999999999999999999999969523733976162811687839824492463619979395065658180611601002653868808228235364e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(3.3870281179478834302359251783105088457972150988098874641514216574107673691665862100671314900459986584e-05), SC_(9.9999999942640202624701361477356136884363900353557317808272573424290070901500921370081827934313845344e-01), SC_(9.9999999999999999999999797665151573885007408601829487908319345995920873036034335405983021390715366669e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.3870281179478834302359186466842805823041398033590668631591090785623476036438001228239982949108743174e-05), SC_(9.9999999942640202624701361477356358112380937792813677132645222080750559464484570869750991062025693815e-01), SC_(9.9999999999999999999999219137958798220520279142437419504183975924208697388694493307172602148743812790e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.3870281179478834302358907811814397282801865901227812280809062135464716292332100047527953252457366963e-05), SC_(9.9999999942640202624701361477357301924797906453742054883094712425742410915645082720044739744540301913e-01), SC_(9.9999999999999999999996751000534760789024880769276860270187838800296360091234474504992575806312430317e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.3870281179478834302357853407259894783555356695937533219941203224200705087049466595430435590582015766e-05), SC_(9.9999999942640202624701361477360873222673747219467981602736416478801377754348327724322527565993762583e-01), SC_(9.9999999999999999999987411799459129400860609644324506532315200393819950737702893028661500435628249782e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(3.3870281179478834302353573498848682912629606240928265071895272818090203048832682015815445205211839104e-05), SC_(9.9999999942640202624701361477375369392813078452422685737181631829004383120524701876870446686862292358e-01), SC_(9.9999999999999999999949503270833270750171620269619328194025581552089607715144642007303947650828741759e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(3.3870281179478834302351381811054610449678017395787741738909030479202935625231734701621201448970630210e-05), SC_(9.9999999942640202624701361477382792701001623049454901227680554642030370105740410820918405910035686438e-01), SC_(9.9999999999999999999930090785448562357609383000637243641278119018859679920469179054927545939308464697e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(3.3870281179478834302289102327531688194438519788173634642063618071736825414503408742106106681909545963e-05), SC_(9.9999999942640202624701361477593735062986028743843840662868531493482619529715614218568663197132736175e-01), SC_(9.9999999999999999999378461321194703063383184854256439461067820394762528716223083484657920255844722438e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(3.3870281179478834301993326977200597993690397798620369244612163983198127489593901994484175553371222765e-05), SC_(9.9999999942640202624701361478595534491727947189118785233853615775760488887843837984022916301127030710e-01), SC_(9.9999999999999999996758683686356327757299305192752900853759281927010163565728756875424962159763105835e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.3870281179478834300879817731418906174387842945546133456502034165537180583231564364278367756710112928e-05), SC_(9.9999999942640202624701361482367021618948795362522998678251747309548430147163886773088894491683354633e-01), SC_(9.9999999999999999986895973304915896803492356892542289014022761323914632973665577649349706427433539931e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.3870281179478834296583623959958321119688017427851787698265730213071704300634734168554514336702722715e-05), SC_(9.9999999942640202624701361496918350731384972881859342096594795575320919591174745639545747818989706408e-01), SC_(9.9999999999999999948843199992990238861815469901429376137211984815704149483597103190354481901597078771e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.3870281179478834294930062485804355181408672653950187650472433809505679938938616536260646690450219987e-05), SC_(9.9999999942640202624701361502519009942312334598075989233800616172074869729591389081435515499732049945e-01), SC_(9.9999999999999999934197072913875143606612320286922527826383903102837201300259187730032269803430990528e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.3870281179478834249131570551373951335777226449305640590857828024123720459927868558263583869905913221e-05), SC_(9.9999999942640202624701361657639789972814429410913924059412910086042523355085332758000521737665113206e-01), SC_(9.9999999999999999528545064574305648378599020242693600380275823388368614496667938830557798607809258266e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(3.3870281179478833990358471534261295825835608824804385135633005211668633697979036043174430978639305331e-05), SC_(9.9999999942640202624701362534111553015029213135899589342119024694258801360856695759811751504293166587e-01), SC_(9.9999999999999997236508299022419123794678213931635201213697331661350360578252291801600993411284900310e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(3.3870281179478833051335916389758036340730852288750726193769957564811694427001597727322274505936144388e-05), SC_(9.9999999942640202624701365714607352501054544378694883209316234585552058326833580738140965001323984694e-01), SC_(9.9999999999999988919282790464648121803217314964980858706168436279711156975638971291665255616464874976e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(3.3870281179478831704922675758829229346977631708312436940974266623852146442821347302006764390452937610e-05), SC_(9.9999999942640202624701370274946859511141276301925495265829200274878701056934887136210466029480045496e-01), SC_(9.9999999999999976993666639197437300408036982981613410176254754026994374975474563436555733531622531784e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.3870281179478826249485027786781335282766438766704165510251737947100188417126114825215221598680706345e-05), SC_(9.9999999942640202624701388752667579502714734221409471198993529160462016494979246523426269138082777481e-01), SC_(9.9999999999999928673096576770082901263021814219306329037191675013847993533799976389120282798488774521e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.3870281179478809361585475106713746912657565373495178872243835889406526693925765422563500031613783897e-05), SC_(9.9999999942640202624701445952458250319242687170116048202509519724061931032222932736732679294163818182e-01), SC_(9.9999999999999779091525637936800099035269455994094097109923915691079839357621870072945021329002983984e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.3870281179478634556198382847580106603440439634086952891712496919394336261367979769680808714276014011e-05), SC_(9.9999999942640202624702038023219840173556659683701760916713939349177461031822158570117386235550637188e-01), SC_(9.9999999999998230783855506077644688176850325033752738580924892792941700018056647747713787051579587759e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.3870281179478345134986468794871103531994025841847790873250998195826361361662101047235950248255033536e-05), SC_(9.9999999942640202624703018301003085898421480551482696630859704720700570808274858410338108394193764327e-01), SC_(9.9999999999995667286873179790482572489741634337432864779411172374198914143058932438955294588112221706e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(3.3870281179473031788504334875961710947770221439595346913927565452837264138353659587744911527150308272e-05), SC_(9.9999999942640202624721014754948794011040387591988711402409885475492109402281965719308195907591290699e-01), SC_(9.9999999999948605264076285769000739375718614201236091402997275280567636554249920244705305675774048308e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(3.3870281179461829658036457189199102278594080015439634994412929788391314394934678371892668323824388528e-05), SC_(9.9999999942640202624758956685846167055521023069496250247150803063471019952280510632938183942690542828e-01), SC_(9.9999999999849384382993962664405304198988314579198768837438237895023214714873194141916730906544796716e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.3870281179397580883126954810840916733233815886391121401804131730010748764819966584111601288974705489e-05), SC_(9.9999999942640202624976569093132862478520621027873971393567763672388955450969885416646269400627265153e-01), SC_(9.9999999999280312270036721863531174208124921074044956505474977399895180143740278051609420216594172271e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.3870281179121795528508505122397136809574054798492391172376458057490872607625672545588337472742089806e-05), SC_(9.9999999942640202625910661844273529729124071439732218619499757745791225995357372030381307595033883783e-01), SC_(9.9999999996837592471937406711038799246309775563163292837421520162733426234618338082599813684128362034e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.3870281177924758301010767353409635297264210179970739498784674887632595239419649848073308156020225340e-05), SC_(9.9999999942640202629965060594249955990943422755978132361438498399449039972346312697011029365198615023e-01), SC_(9.9999999986235047827423515115586801940492636716675222006085632124954787396374649957510198236559193778e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.3870281175818287601261025729198180606465640974746511365683806989050131347696901491148237047108016333e-05), SC_(9.9999999942640202637099736087478897317226575564342058557104919025344735493261225933749339975629792159e-01), SC_(9.9999999967577357721404154589758084646517678947504772832338094576392732395221773208149849009379619517e-01) }},
      {{ SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(3.3870281161725095581171569962121416160959168747821727136628042515984455602601081931261145334591631217e-05), SC_(9.9999999942640202684833773743450981490258857534043058519837623239690379471911392550676957111153329735e-01), SC_(9.9999999842749412418609012889232052082488825016877152744267973498406813728561193099095190901177565436e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(9.0660119770698834722385625681158688676863227899690818988299942059202356755447679219611816390722994886e-05), SC_(9.9999999589037133313674724416672224088661989910221004339730240846039367913758804825082287638590107897e-01), SC_(9.9999999999999999999999999999998880500637517964089806461278799190933436583838500986284439211627458919e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(9.0660119770698834722385625681158497186683675214259752961807923292716568438067980439520440257983937790e-05), SC_(9.9999999589037133313674724416672224088663725962489454778519042480099407081594947707449493500175667812e-01), SC_(9.9999999999999999999999999999998246847669647003656525966133964222110509826304609072583449298770518364e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(9.0660119770698834722385625681153057065591233005986259553391677175175236336743011456998690842224830948e-05), SC_(9.9999999589037133313674724416672224088713046165672934058316547023353073598282026981359173302194631656e-01), SC_(9.9999999999999999999999999999980245147092333641132545567803030138319018982573925220680155577955082383e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(9.0660119770698834722385625681136888186130383600130339875844428888371530102624848704510829931880640067e-05), SC_(9.9999999589037133313674724416672224088859633421123213199033853436935647703860747577027347988518311835e-01), SC_(9.9999999999999999999999999999926741314773370421651813928504108280928608275862745726145134661605613045e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(9.0660119770698834722385625681125624768124838814402340718756122139875935751620024303101444627000957252e-05), SC_(9.9999999589037133313674724416672224088961747704083878590164630552148321448802018569289265682770036973e-01), SC_(9.9999999999999999999999999999889469960888504435569138851675728293605427306545030971352450192984943064e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(9.0660119770698834722385625680751242201733647851255524276728129552559768953390439662768541081024857236e-05), SC_(9.9999999589037133313674724416672224092355904548941300952489027499333531247272157437414671718639223397e-01), SC_(9.9999999999999999999999999998650614658402063280719354389045428684418020628181805241565108195055728218e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(9.0660119770698834722385625679618538394645760955581024206520009511152823468264437721571944516320565442e-05), SC_(9.9999999589037133313674724416672224102625010872674952046435058122194810368396049674999706716568959050e-01), SC_(9.9999999999999999999999999994902426992817361706367311748528489034415588183949752240687220996559848857e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(9.0660119770698834722385625678649606438995368130333258721437967295941306134647380881706302052856859160e-05), SC_(9.9999999589037133313674724416672224111409359623667570001113590335129514035405035973542947323091991140e-01), SC_(9.9999999999999999999999999991696170615612585912603367307619084575257190393008940034286780154678791775e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(9.0660119770698834722385625663219571259483285731205870124587525029893132547428844053450488582686938225e-05), SC_(9.9999999589037133313674724416672224251298243942625127655626197162792181420636951454966572993970485891e-01), SC_(9.9999999999999999999999999940637220184365557201203861808633450306761084633294703282500856362042756703e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(9.0660119770698834722385625635073532784906791566791744908244275346777160467372783616972310368929989568e-05), SC_(9.9999999589037133313674724416672224506470566908868870103402489154107895802214610278161891069305029697e-01), SC_(9.9999999999999999999999999847500220392067213888866175198396876858536294373483942821597637311432014016e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(9.0660119770698834722385625551399609182871703677879111301303063671621711926832057184130773374313950462e-05), SC_(9.9999999589037133313674724416672225265059363570867647919115653943045746354143354887105573370034589179e-01), SC_(9.9999999999999999999999999570617979497568093021058377064092978957475275094187938462424356401549336679e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(9.0660119770698834722385624649675880799690426005218323314632430591731376293784537674438863112826787245e-05), SC_(9.9999999589037133313674724416672233440097518697270696809285213039662901887506488829580950521354006686e-01), SC_(9.9999999999999999999999996586757825288121231006985983926100395269972367872729664345601960547259799166e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(9.0660119770698834722385622863956427494877544433975357928008217091251786091974137908321814408332840051e-05), SC_(9.9999999589037133313674724416672249629451536577622158597817586184504140170901854804073018518660475708e-01), SC_(9.9999999999999999999999990677700587915891399187193336792496247706524732555607566844520618247605304549e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(9.0660119770698834722385615944953371828193874522571733846235743057283633992470356092452790604540219095e-05), SC_(9.9999999589037133313674724416672312357216366422718540832061584066531873856066570536233711390271078909e-01), SC_(9.9999999999999999999999967782287198190683867853782427557766876034960393757019371458440342789151944668e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(9.0660119770698834722385559695165249119344409958826206048773473228974767057067782670114692096163377168e-05), SC_(9.9999999589037133313674724416672822318471290295816201863141582631942177406646844013670468459839189792e-01), SC_(9.9999999999999999999999781648223982376480617438398406206248740167076955243138036027413249730910272070e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(9.0660119770698834722385187593827762416485183559466186322025772140165381472529005082346653804789789482e-05), SC_(9.9999999589037133313674724416676195793667492197122940189009825050237921698607854493014120073893405437e-01), SC_(9.9999999999999999999998550341650465214916111840381536808305661553668058782272136043000221516438281920e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.0660119770698834722383934989860039945914458313296433554470564916231337151432039524007702439202269369e-05), SC_(9.9999999589037133313674724416687551916288058820109664248767360625790890078111837367921489809128429979e-01), SC_(9.9999999999999999999994405396862338855667180512862294495213915480180246719032876303984110757555367109e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.0660119770698834722378591077302705006837040718982512360274149081834075803729200168990659307791586820e-05), SC_(9.9999999589037133313674724416735999891736374716904827039013464036516432893139326839539618656746861888e-01), SC_(9.9999999999999999999976722056338515681031039995365568437106923946314925008756355706369606435290038776e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.0660119770698834722358370212201157221997214038890806699196741484691730124467253373232139166686369552e-05), SC_(9.9999999589037133313674724416919322497687109196464658157615744302340724347443897909999211763034486316e-01), SC_(9.9999999999999999999909809950378592078577321928071265819398942293185317632617803535664531802393250863e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.0660119770698834722276292180329482663872693377800535292020457334503112725792071140581496677199079500e-05), SC_(9.9999999589037133313674724417663442920748092987538715063232249828001602494297901682744081009862760239e-01), SC_(9.9999999999999999999638208614926376724737955274065935040407129463759509904684014971700713311713822040e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(9.0660119770698834722234261042433308991819922575472651733929986697914196677949054103992645747207829629e-05), SC_(9.9999999589037133313674724418044497721890673097120403287859135324603377216060975602532481262072139772e-01), SC_(9.9999999999999999999499124953648716474447277595719745817032699120791419102631934053399947201161605721e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(9.0660119770698834721039894962038979752271593104188793846634708373044513612974210484763388657618569532e-05), SC_(9.9999999589037133313674724428872634956251296501537171676704044421219687851766215139269442406099760722e-01), SC_(9.9999999999999999995546892973219413018046937878617494945262369645104531558409164059878440414154507147e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(9.0660119770698834715367657077757500609985633433343963394707415086379463915660560418544073047651948393e-05), SC_(9.9999999589037133313674724480297211763272637148568091451936015827892412916170602465134253811218924504e-01), SC_(9.9999999999999999976777103429750097747812120239592429682742795002132716950417801830271424976385640773e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.0660119770698834694013310539581164157894005955642740193975287851924098313810186578243964802135385317e-05), SC_(9.9999999589037133313674724673895974036499130314194529769366549156688051616520546490198644990201816209e-01), SC_(9.9999999999999999906114236579507776710417359338281271487543061974341533619499928479425791671746663991e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.0660119770698834611622965835689437815026995350104909561341062183860240425009251644347834405198893477e-05), SC_(9.9999999589037133313674725420847828986592518513090376997949600185426292582971714872448970550748332711e-01), SC_(9.9999999999999999633479438453118338099919667296437047056855345815525303244493483033808738110341057894e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.0660119770698834579911756543957774400509237644649667927297121153916146173462155944615624847578537097e-05), SC_(9.9999999589037133313674725708342033414295979185043660032134119871967028687091176859161799270083618445e-01), SC_(9.9999999999999999528545065685691729672153511401458437352172023623085532573776354186620066098409263269e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.0660119770698833701610232422225276782802829333071634878836963502758741972407906577385158057744830021e-05), SC_(9.9999999589037133313674733671034203304363924458943041238552674882426435092067815315533011354824562055e-01), SC_(9.9999999999999996622190448726333795380030648073821628745698570665778255938454358047399054855176573465e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(9.0660119770698828738983786253835032968727546176009412691204096682023144068342859732642032720085191062e-05), SC_(9.9999999589037133313674778662265186887992070814149895789174477434658567177204904606559141485213800564e-01), SC_(9.9999999999999980200549488363997000066959530567028271852942735301345865686855301064319114678087805807e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(9.0660119770698810730859358294805452503931722828808383606561749736055238658426062176310306501208826115e-05), SC_(9.9999999589037133313674941924137606274942287006800205829236558951284104747302583786849152340219687127e-01), SC_(9.9999999999999920610540662735136770796691800166656169445695658156644202013985477324485402191460224701e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(9.0660119770698784909991652936966103956329712991155588405713799350818372233723460901915638509196052492e-05), SC_(9.9999999589037133313675176016434443418391272967064755459556013892028162168381852830722536552071818121e-01), SC_(9.9999999999999835167676215465484410122943904782478111092096162233457869886644089765104794021462726070e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.0660119770698680288223586317359157553213835271383790395934238491611771556511094350199365068758139286e-05), SC_(9.9999999589037133313676124518640695610003141571913456058559856937484417797383695750384140863587667452e-01), SC_(9.9999999999999488967709229267825737712119524213159331875781306828996560531244099829871546097974733896e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.0660119770698356420181433979725459131104318517006252056722091143253940428947650596648922291687785316e-05), SC_(9.9999999589037133313679060710201905523637327755526507707514163961611022177707833314564479724366301051e-01), SC_(9.9999999999998417268123444907449218475397820196184606120397588279101160116453225151055645802780613716e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.0660119770695004086263373316938919402490546840607473450149753474231578071666621562940992662322402606e-05), SC_(9.9999999589037133313709453009779081445151199331422411585665704375572551088702709686313217643768771563e-01), SC_(9.9999999999987324185744830498957705226464109567501900081363959863934513614070031739488446097100926946e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.0660119770689453704999702056428663778252495665372268969459865986099515933685793246733534073691640087e-05), SC_(9.9999999589037133313759772832999621489375704861645576517651340449094220261730144786169419042596483714e-01), SC_(9.9999999999968957627372196494219405782836744138114001988618734439483488410510456015497156056264617169e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.0660119770587556893198020981496233685777578066789536883352426823484546545153092543290123452359600770e-05), SC_(9.9999999589037133314683570553014748821429043302056439295286387221381430266473951157923335704964286712e-01), SC_(9.9999999999631774710913850877742179647937743050592267424655054022097326051830659924487882196424428490e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.0660119770372727804995259355782196359543985965415726440771576229649119519351712041130760206679828689e-05), SC_(9.9999999589037133316631213647683379873564744127627841022397350307040885765467474168505561875475111197e-01), SC_(9.9999999998920891836175578885843287439214978056512356549529129573764798955276431279708292435308055479e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0660119769140595598405188140208368205682054701748463658139903031256079172358465336088200747668046193e-05), SC_(9.9999999589037133327801739035753132705577880373423140570047559917064965930182893998843851229187344650e-01), SC_(9.9999999994843689384667410035972197472638580924641617276624479665574689722685579725185494953535288107e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0660119763851716269521833039192105403784298738875946285685197544925127156657932903537278672944730085e-05), SC_(9.9999999589037133375750782571516975087066168939843571003227540960788638921618783106451204844137356481e-01), SC_(9.9999999977342457252425821863699065463158883929503731593661343789049129823351224262437389499780511130e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0660119740895510140786533092705590247175980844681715546849843918052861643262021445490162845831113496e-05), SC_(9.9999999589037133583872023095949527304454932458888382629993113246619747237593188990793417458560878512e-01), SC_(9.9999999901378936943790973918204440670904008741583247398407767423763055223380427991862102877118492116e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0660119700498624840938808789674791750189273754722825602357550808930366397164013668738195162096802289e-05), SC_(9.9999999589037133950110670363800583225109840256108311617920168810990551456284008282593744515305413636e-01), SC_(9.9999999767703119640056201397243208956148131339050273760643933707291971385012568071922771911319942497e-01) }},
      {{ SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.0660119430226144379504222210945051399123874255488159914640723166005035631943024549365082611122583868e-05), SC_(9.9999999589037136400404219819670008498781037243495018174937127686635463387748704552485811354660463461e-01), SC_(9.9999998873354596790815127769107251813856812780319355930933082438101152882766471658192291491634188746e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(2.1949532498377359466040146241713311994861856416416840124789392935958352038513972908762349683239595833e-04), SC_(9.9999997591090086499145904533065024491606043256476010675283380270136619946243080705736584631184664511e-01), SC_(9.9999999999999999999999999999993437915432006237530661734571043862574067738413255096654299941311063358e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(2.1949532498377359466040146241713040242416038760059317066761602428623235700657520751485204255787989367e-04), SC_(9.9999997591090086499145904533065024491665691649322768531407839819289695414898535314941771753465307203e-01), SC_(9.9999999999999999999999999999989723679853782583378074309638158065769147447810631983274683797881115191e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(2.1949532498377359466040146241705319918502463640542048768101478106229882195805019144994129190325192354e-04), SC_(9.9999997591090086499145904533065024493360266696533724500566319435804341058113862033884338524628373355e-01), SC_(9.9999999999999999999999999999884204475899856278738823940267179583503884178433664179906719818335224102e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(2.1949532498377359466040146241682373924353412381700079202218399706762266394288003702684629895258922448e-04), SC_(9.9999997591090086499145904533065024498396805260681174768802493907872986988301731969058654470458392096e-01), SC_(9.9999999999999999999999999999570585116965716331116983351829078028058964317460835752284970993861163055e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(2.1949532498377359466040146241666389494246221021384308525639469447328233903501207505411170152239192155e-04), SC_(9.9999997591090086499145904533065024501905313026256348777350584668119727613883799052404512890685442249e-01), SC_(9.9999999999999999999999999999352114446635130875736288469993936855281955489428433431772186879137967027e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(2.1949532498377359466040146241135086122313743883174137544262503210718270604911781524698886097374318733e-04), SC_(9.9999997591090086499145904533065024618523922122787387925735148614308541420672022552290568568804987735e-01), SC_(9.9999999999999999999999999992090410210913451274883794136783197113574093642655990548820445076099173158e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(2.1949532498377359466040146239527614498013481908714385013381685286323222132307338991874651496407720631e-04), SC_(9.9999997591090086499145904533065024971356437200185235200953791920823624971799839825148872051247606605e-01), SC_(9.9999999999999999999999999970119942640707385244210238840640414785180451800056830790679228417689579667e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(2.1949532498377359466040146238152558976137835037191174989095616949973788262660009052845523051573190128e-04), SC_(9.9999997591090086499145904533065025273174703115542874980186090855820757883658385361046161924449464213e-01), SC_(9.9999999999999999999999999951326072631491849082301400944677457004679227187074908841364564566357096215e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(2.1949532498377359466040146216255092438271796865058880982796125712126238056476670001875141109087648122e-04), SC_(9.9999997591090086499145904533065030079566352947401496557959709127115482417082569438278098183670046705e-01), SC_(9.9999999999999999999999999652037692564887716762749924761980916189209807427822430790587988652839528664e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(2.1949532498377359466040146176311765770495664027756182054289266352062552157791524493137196501888560017e-04), SC_(9.9999997591090086499145904533065038846940032022087900696234011833089300875071377749001410433281887846e-01), SC_(9.9999999999999999999999999106103599586709332061276111021095590564757265479706346323840866986839621477e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(2.1949532498377359466040146057566285228729286539875039337857106971751170963247865852577349595451087942e-04), SC_(9.9999997591090086499145904533065064911018501751632821911993010834554994092254688409967934028762126702e-01), SC_(9.9999999999999999999999997483123952597871062131930430116657972566356823569652511115369205676940924175e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.1949532498377359466040144777889023384994891993322269389015233157103321091066050386635483703015038576e-04), SC_(9.9999997591090086499145904533065345794201730710497171200299319890928883321550359345210668326069018538e-01), SC_(9.9999999999999999999999979992857028659809150464729838387779926195120172412024534834896245862626202070e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.1949532498377359466040142243693117812532410224559078505159874337124801221109556407837671041573083427e-04), SC_(9.9999997591090086499145904533065902038368996307459214809674827718609312559771073924522119440848732370e-01), SC_(9.9999999999999999999999945356184058357532065184675591095369543222122538262067669293977626887434771268e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.1949532498377359466040132424620372727256910319168070251547608794987778355968221622706050540141856836e-04), SC_(9.9999997591090086499145904533068057278984135918741255207735179176401039885254825623756115707822694207e-01), SC_(9.9999999999999999999999811151874598588276031795716648243043914832353214248542271450453611813702302915e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.1949532498377359466040052597981039166102516241663957293412965888438611591231956859273246828098945701e-04), SC_(9.9999997591090086499145904533085578853549097355022434268326561943117600370484638573466953502058167210e-01), SC_(9.9999999999999999999998720103943049570084604498454619892405771074092191618350496264177529047400925430e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.1949532498377359466039524532005069827697635520239927225930265152639602620508736709729375341565495114e-04), SC_(9.9999997591090086499145904533201486869349480548822145820571178829540015419764170653157424522934139505e-01), SC_(9.9999999999999999999991502647519821014553864210033802739055628834829601413426101978642191656264785794e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.1949532498377359466037746904595326723924813032892883066227820507185118673955048293824893859347124634e-04), SC_(9.9999997591090086499145904533591667784750213526729882254143196182124155368349087026208674360810736730e-01), SC_(9.9999999999999999999967206538794000623637539921133114141105094600552790874584621967802630353386722687e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.1949532498377359466030163114601062808109724066453194141208252043654703212039200302802364848319593521e-04), SC_(9.9999997591090086499145904535256274274248732960186075747202770772894774506834470960781185618278095126e-01), SC_(9.9999999999999999999863553441837618190856759655421402975430609981385349456259084369657387453699390933e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.1949532498377359466001466762857433975917757380952104642918840408678156850274838539358406902619649760e-04), SC_(9.9999997591090086499145904541554989477795596487791363062717113947087655713709304202224180332496120744e-01), SC_(9.9999999999999999999471339821493887184483174151974043645498294791393991840657851184125852236036763772e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.1949532498377359465884986085043403950080615920782319617175232799563285584004870839403326582975334568e-04), SC_(9.9999997591090086499145904567121954324801494656922153557551457652404698677265261414035918600811862959e-01), SC_(9.9999999999999999997879314857704701612167650610568091024364022054992269149557563280810495402167038061e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.1949532498377359465825337780621391634776351605284898179555159363232572269390208067219532012184665676e-04), SC_(9.9999997591090086499145904580214478604029262682976391551202609106781632130072403262733891609954880291e-01), SC_(9.9999999999999999997064058701321806585927864788723964815578795027763526958386572913293562211584077437e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.1949532498377359464130358412452248343755838930986722205517407427118468536586601910700069777885405987e-04), SC_(9.9999997591090086499145904952254534823216398487068305956554994273945535751627567638543678152718266319e-01), SC_(9.9999999999999999973897560034983599430784588816940013917656117433575992370567082898736740075276991006e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.1949532498377359456080626974976851222191881291530923937067995166323038898428377634406834921417309363e-04), SC_(9.9999997591090086499145906719132995286488057142724846238020023043494396559422937497417289571300446905e-01), SC_(9.9999999999999999863876107200375918258227882289304901359718325453282245860379140193849534801288673193e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.1949532498377359425775700037506439914441651796070049972432366928609087720746406248454632783275520967e-04), SC_(9.9999997591090086499145913370922942271698087316486094132319297755909167002268046118360024103188989870e-01), SC_(9.9999999999999999449676936010036048091136982373720631127335195866605288076709027178210443358060591214e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.1949532498377359308851804841710349890026882822506931901022099623306731140632975980269136069730290731e-04), SC_(9.9999997591090086499145939035171934870283076438579743400488487600725984369087917762431482235731353741e-01), SC_(9.9999999999999997851594202388128357346764130339383283989697939341752511517202964822619052138703931059e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.1949532498377359263848981694361028369717588758562581895775361562611024309721408555973262566461211603e-04), SC_(9.9999997591090086499145948913081464734953072943384465864007503871537103023451975376462328733837149030e-01), SC_(9.9999999999999997236508342345680569153513564399494028582104933359000221360887192242782740302589354797e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.1949532498377358017411237978177428507089028635335501344205771024617465556347690890040536911083905236e-04), SC_(9.9999997591090086499146222500345684230895595337686251613638816215403254132598789791990768798619838988e-01), SC_(9.9999999999999980200549752085688167427883885539402647234983232013067330800438077933334325225467733048e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.1949532498377350974721750841335976339712690677087317685882251774272026459574621611484052961977892323e-04), SC_(9.9999997591090086499147768337800660969044837194748931490027218706068265761583125803731213177894841601e-01), SC_(9.9999999999999883943061504648550917472521711080290035932327983716883682790684240565694552571344503517e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.1949532498377325418571198796389432112292153913359813912302320818371927079088782434396642196092931827e-04), SC_(9.9999997591090086499153377793506543048700186932548386795274278268487731347671516744932888282023448778e-01), SC_(9.9999999999999534648823002975718661593728740850402386845670782225644647636763814777330225273077311416e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.1949532498377288775000398161475283653389998086494468122512190223226967500421693458213541569225162313e-04), SC_(9.9999997591090086499161420886181745163569687715814407726252609084107767527800797121875893408396059356e-01), SC_(9.9999999999999033814860050534109048662879867084624777645766437808888313532242793625586989507072964282e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.1949532498377140301478548186030732189435274941993938018287756801369450248793755854397038802974222301e-04), SC_(9.9999997591090086499194010130896736264960848973432051101603158349924630841899300721284446045898069209e-01), SC_(9.9999999999997004520751509655263683975771110137734194239599820637422457603132929555276613084555954985e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.1949532498376680685571441797736730472120020969367141823459779566164781831245966221611052848672720245e-04), SC_(9.9999997591090086499294893676224956520073143833090849748564625713723230677558610098023496200306402334e-01), SC_(9.9999999999990722620511916095017541922611441252377709556891244021325457445076822425676998318013310780e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.1949532498371923235640805744099006519332150419763003710782293944507474095356304006533048412818663537e-04), SC_(9.9999997591090086500339131719998556556757931064507494107554644090820969496981591122802367106451031197e-01), SC_(9.9999999999925699140260180956297842479583873504118144266362417137668010293659066606172558032047456915e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.1949532498364046436490341497415839377924360934172029820183699307410873546132502434678857181512649856e-04), SC_(9.9999997591090086502068052351009020203728645080442447923303584604671979504558717592987486432099233145e-01), SC_(9.9999999999818041277019450869640457192613482370403990987757966853522466125029870431213702957663553968e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.1949532498219440024335112085696284217809210420220716691707654789040647780773903164606251102825868255e-04), SC_(9.9999997591090086533808484546233219286579955199735991845141199940867857339824508722241446466603143463e-01), SC_(9.9999999997841601730176219353705229218739261651127331045483365004919077039134794209856785731065491453e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.1949532497914566268992455961292159153360280722660846617924435497393954715219117340070630587508389042e-04), SC_(9.9999997591090086600726850165249954882137682437595345210748277636356867891776791496868797966332869199e-01), SC_(9.9999999993674673460048503099966162644575765093104151723778508476266913963472670883559262326010871521e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1949532496165991269044309812180317168464575879469002410870411102515175450450090057057792999888066675e-04), SC_(9.9999997591090086984530897259484069259930626127732813573610914956968635129868924174163202784303767506e-01), SC_(9.9999999969775644855907020193163460340798082171818173664710592535609269447482218273864724923957695664e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1949532488660301439824068369878410182942728611585163591919562023200659129820275883752134662090610325e-04), SC_(9.9999997591090088631994764789850163499737306768527037412778878960803868085734353394392621860529854598e-01), SC_(9.9999999867189998879873941105845141379381853759555907793831875773303156096747863480599346882449650847e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1949532456082102531281805196803441103186305932536371679098013020808230757915831335453617358451282217e-04), SC_(9.9999997591090095782757285389441563168550421729619723790991159248953530675229625086630466130925947406e-01), SC_(9.9999999421920389478086980705886754536511240889426706687434334889739457515603848009221381672378545863e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1949532398753040583396233529729797437290650548303014077652929235114447084365354300106431451633928469e-04), SC_(9.9999997591090108366218631099138672302569825987444789349916472582460612097489753819295696541972104749e-01), SC_(9.9999998638362984366277246011141025300416048049687521845037167436742349261038641619678750489717689658e-01) }},
      {{ SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(2.1949532015197041581626982465907062512586693749895051676233797903326108242222227125319227773986336102e-04), SC_(9.9999997591090192554968191808427881056365867461130048038066729521407959884195869238505001124006765621e-01), SC_(9.9999993396028086949761507288374412480751168290962668987793281688251367855508185814004991297330196911e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(4.3952149320897568052270634568423253267729905676177785584143353001614380033344243031758625321347619384e-04), SC_(9.9999990341042383890306088396061192715670697837219455740677936131718353318213465919088214608415344554e-01), SC_(9.9999999999999999999999999999973688142481916180437304757252411988405420245137613199627838491668357719e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(4.3952149320897568052270634568421071351978567763236428985213434746066145425917517600757913894895359733e-04), SC_(9.9999990341042383890306088396061192716629696798932982563987649090092816159354172908007447640757493140e-01), SC_(9.9999999999999999999999999999958795247349249954778242940390886170692373734001510565621879790767344031e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(4.3952149320897568052270634568359084434798204155311880226117396510294984327442737778206412891712872212e-04), SC_(9.9999990341042383890306088396061192743874281829010424743269716705640044374075170787777652327952165941e-01), SC_(9.9999999999999999999999999999535697033498255459951822859686557815524626811857962661407907708787000050e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(4.3952149320897568052270634568174849750494694500221526141761541444600595036372660482208532269021015366e-04), SC_(9.9999990341042383890306088396061192824849393196324908583237927515885150911858907425196336245999193732e-01), SC_(9.9999999999999999999999999998278183845168415291655135119082109011987327990988515937074887045161495669e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(4.3952149320897568052270634568046509857464098717441244136225447983164310858821291795694460332135408372e-04), SC_(9.9999990341042383890306088396061192881257540067851576548278390199892230307847860446242065015359799250e-01), SC_(9.9999999999999999999999999997402186425437495018590771225053604616408334590527787302388433596152799806e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(4.3952149320897568052270634563780645046310675688268267412264928203680938838716249697181100483922098626e-04), SC_(9.9999990341042383890306088396061194756196992793236186783571245045948636694054010587409296312115309157e-01), SC_(9.9999999999999999999999999968285078102770689166069486492860667740143329699595040039657425755209698531e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(4.3952149320897568052270634550874164494364158542238952818338149906452801149106149160304138818016737658e-04), SC_(9.9999990341042383890306088396061200428873144978759254214483779890013713326331613762740878783204962427e-01), SC_(9.9999999999999999999999999880190539496468973081874203349131743704972977034165097990936201582711727789e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(4.3952149320897568052270634539833765968722941278720825369300000052651396942728252573162383430561887543e-04), SC_(9.9999990341042383890306088396061205281366059290994561495998288737455803706724275632761060083870084754e-01), SC_(9.9999999999999999999999999804833139759840362095480189673873879648238413744134111600987499677007083781e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(4.3952149320897568052270634364017769135252992639730022477753159548427567567996311004120404270833260444e-04), SC_(9.9999990341042383890306088396061282556282981513719744461509881606801351102848865894599554929609181461e-01), SC_(9.9999999999999999999999998604782586991942712386688914829513817017650185254798919136574931157233847789e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(4.3952149320897568052270634043310541073227087213407078939385787524073632541304409357070269174879851988e-04), SC_(9.9999990341042383890306088396061423514016357294576930509475424846612943128206575235856337125503414196e-01), SC_(9.9999999999999999999999996415761717195708171816995412220652610735603699835666895880890704082082372328e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(4.3952149320897568052270633089896364377578427721561786092428100089213423305101327234880825275562914264e-04), SC_(9.9999990341042383890306088396061842560079420653882014957424088457731279820894036538977886004539092398e-01), SC_(9.9999999999999999999999989908133114753582608533129443418441593433977483846071694873691263712360924801e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.3952149320897568052270622815295280863051128033814768377153480380371707621274638897656446849322151880e-04), SC_(9.9999990341042383890306088396066358468525963201195352097086875133108720766515834076136262017880986932e-01), SC_(9.9999999999999999999999919777764252925483210602298496842071455244671366106233745896364253635558513933e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.3952149320897568052270602468093081053651375356900351662597680191708261174168243195074487437738573274e-04), SC_(9.9999990341042383890306088396075301502083252204209532600780634520259010776279171478465504744037077508e-01), SC_(9.9999999999999999999999780895798522074074384314552858680706462800770080496280597447851597750367166906e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.3952149320897568052270523630202877077528676191338998750659971410879066277402968275549291466709923214e-04), SC_(9.9999990341042383890306088396109952452654069695165352795437530494027614856905090864234099802536828905e-01), SC_(9.9999999999999999999999242779498399799624391320411435168539127113334492331262094725905521786063625045e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(4.3952149320897568052269882697602567979795246499647650741963919683168954633522029204330158290009597866e-04), SC_(9.9999990341042383890306088396391656133397875044829189635613897563365620350242562557523570432733935682e-01), SC_(9.9999999999999999999994868026716282785843665714490690845988905218940382975226281485878385627289072205e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(4.3952149320897568052265642826026632869674401331906181721660774805511586016828014319811680813395847970e-04), SC_(9.9999990341042383890306088398255170999463278647332928628331458754732838352132042192761910556504254440e-01), SC_(9.9999999999999999999965928337950731184236972858424297829761136494225450412791329227412693186900764402e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.3952149320897568052251370155053393412225888665351704404826168166235404583366213968693523658370826941e-04), SC_(9.9999990341042383890306088404528317263622428012821744087980006810345753815800681219269233939346113203e-01), SC_(9.9999999999999999999868508723129597291088348432787795997070951006375122385798566290142035661055004811e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.3952149320897568052190479476430297131118292317230358203436961643044003076991977849069845828224721137e-04), SC_(9.9999990341042383890306088431291081839557648059503032445245456686532093955011793213206927844113822463e-01), SC_(9.9999999999999999999452893000691828396258268317147943905888267553515654325455181179115754831557814595e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.3952149320897568051960074845896190545537462422360826291357235612356457661124625267793044653963201830e-04), SC_(9.9999990341042383890306088532558878875584120913905068097798135955055466245184130566633457742302480765e-01), SC_(9.9999999999999999997880241995023490435699010966304715622567791004101852541162521147871769277813799489e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.3952149320897568051024844898345021398745980751440032202539424265223741821462546238364318937492238535e-04), SC_(9.9999990341042383890306088943612581620528920518423724808095583524722796800035571379331106025846168027e-01), SC_(9.9999999999999999991496731758540750193061386160604339171696636950668335984615214346584028165890576639e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.3952149320897568050545925289848413785000894450169762655235285696560689713542002819948971252593524626e-04), SC_(9.9999990341042383890306089154108063405685304895120971206766222513754658765528101631159112190427932697e-01), SC_(9.9999999999999999988227815668657803631028916930401145619282526146015898870717045182056436890650807311e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.3952149320897568036936840115017761464304680354756199569903036663427983338963149397016572387164912060e-04), SC_(9.9999990341042383890306095135594078404586471864984613064444970329957947151453142223784957401397854306e-01), SC_(9.9999999999999999895337575412590878026287806827225143035544574311879095075991410909489540420787568727e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.3952149320897567972305091301788173932378715725913785559941313268224139092338630028141505625844896323e-04), SC_(9.9999990341042383890306123542639569327180553705009905655055841991306765476080604110055642051609959330e-01), SC_(9.9999999999999999454186785458381289771029061441455217111451806412713710394477781718850653371093431098e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.3952149320897567728985119593496137731409402032321931650603269296931037306092471098890005966067013367e-04), SC_(9.9999990341042383890306230487007191832554441008199850777865547742449698738495388962261063348190907259e-01), SC_(9.9999999999999997793380762075997107398101998921430399007098938448701697879303767918711353248114399047e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.3952149320897566790196554626272477383400745761686844548980571402657679530629446245952428289148256156e-04), SC_(9.9999990341042383890306643104798928315785846143939522205398881362138543739450758019945355931426446952e-01), SC_(9.9999999999999991385580808649748895480413763901680989203898946351498370749876316327306683714456860056e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.3952149320897566428866343284726060227037165390021505273088849564257999641327309059055262075329336906e-04), SC_(9.9999990341042383890306801917208298290331807430656754258138188596097835882538154165720182524883835796e-01), SC_(9.9999999999999988919283499748576095319899822081463628425306444430622684810227983814430346242600503999e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.3952149320897556421147230054468380574803110433738062686092639378029604050135513944009142665060596958e-04), SC_(9.9999990341042383890311200525281420947970569000029033198405223025556558996782836213180103830717002788e-01), SC_(9.9999999999999920610545557357121629628736189622424415766317054007948629076317390800796289834107312217e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.3952149320897499874995170482473845548211600749639448165868565240357946224921302498779605114585951546e-04), SC_(9.9999990341042383890336053776870430841200462174622508193767893742993183986634190112651777257960071620e-01), SC_(9.9999999999999534648845495097353063523589732658983034063430366194483498874580770270447683883494171790e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.3952149320897294683217538846044368235361839213698339415773828422739943027546087515195622267714313199e-04), SC_(9.9999990341042383890426239982080338766475914899665689164955230109613134303065242094595371096115822629e-01), SC_(9.9999999999998134090815479731620374161484125441667286273500692958637116366070815687254962493120449459e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.3952149320897000469915889966249613607360114804890301912455654669302163444001523825155947929422558433e-04), SC_(9.9999990341042383890555553064233291760718057972064665627916237193104624608221283836868741578943467810e-01), SC_(9.9999999999996125907023137854960982476478479982826892098717375952288503209246788908816444987925674105e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.3952149320895808367614818337186704862807048704415317798474006344417929636961487570309783252791192886e-04), SC_(9.9999990341042383891079507698266692213233363263209204379183646955348680080233808205415607531574267390e-01), SC_(9.9999999999987989087557774296391921480103334017155648114919026348051360138026808658991876195079808816e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.3952149320892118085511695136402174278279897022304200769539501636010403481556413817835963498891027722e-04), SC_(9.9999990341042383892701466155257907482234586876944113245501493554184981477035493977225256170557863211e-01), SC_(9.9999999999962800679463618003054257665915983069613736507911856454551680645518977351479636356447479570e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.3952149320853920251050183838952306068728109657830215858880991463047288758065545698717761922184761532e-04), SC_(9.9999990341042383909490237016741507057450973103053973898760291958231856716377142961125782982651229383e-01), SC_(9.9999999999702077348335328743295416427846895845360096087934606420943205752661907582980157361646500418e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.3952149320790676985346360943645414865946708295930728418937452011516839765123667833450290677353237291e-04), SC_(9.9999990341042383937287014279129077860305130961973480299683410529161045946789811438432135574869221806e-01), SC_(9.9999999999270403795680422609294992528953432940301898089267499751978681369267253802173989211143517788e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(4.3952149319629623926653945330989432506828138055318299079469962778806428433915562345281837685401166590e-04), SC_(9.9999990341042384447594837612903151706456058005329977817383934946163479356779464756241208563096754966e-01), SC_(9.9999999991345514195402995986559631767492539647822683761489484622118018380939591771444032830969775386e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(4.3952149317181775308647219989266967360868074098272096479204853881209865820666454185456925133196224872e-04), SC_(9.9999990341042385523477021206753522488485467367412942414284300539014713934174979454240999254108068796e-01), SC_(9.9999999974637466350092995449108961932515530012198238294797496238518684257274846251971946054107030128e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.3952149303142367777710553727734920717562979117694221241779811070211661226729103511463283014512844477e-04), SC_(9.9999990341042391694098977483934519744087412631870476010770623271686290524900739491764274853962932980e-01), SC_(9.9999999878810015663985043686502667679745060726018205416759091127801505360863460585602363568930884671e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.3952149242878759824811667397313866226047460967328437085651983523661469656642769253922747322577274040e-04), SC_(9.9999990341042418181252460626841774069073246463628265152865816052978689828473245937613363603005714389e-01), SC_(9.9999999467474430127667913921370613033606171818694870009306938378512529181078207345556508125574666258e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.3952148981306559498126535060760750095546822191079410541536384239279160490668057780833508759538560553e-04), SC_(9.9999990341042533147867088569688260099862598892698647859976574528085751319958821123542772020432392375e-01), SC_(9.9999997682085906627313749244845682717104868431939058921072042663960478738899502957680319196918471548e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.3952148521008282634772549917898861368691507039096643360008725929221707667063116914239842956487615623e-04), SC_(9.9999990341042735458869975698970255162648729631493676413796641336794548983578465010093511130441153449e-01), SC_(9.9999994540271687941425203922253616893788932781792721598221196362087292276541672787564019187102498291e-01) }},
      {{ SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3952145441415555656355693218005129946833020978925531292467339511142670835363523633444955516738971707e-04), SC_(9.9999990341044089006122498506549950420071765288120901610285751338198102856669430786550410481765368309e-01), SC_(9.9999973520188520429855120090470826998135117761251424498677884548819815659217897633358835384684988319e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(6.3331514088642853122641562829611341447301548396579227570617204776392440891130698708435198743167830546e-04), SC_(9.9999979945594605304280351343129488353454227678160405306035521675700138534873287244861988588780980048e-01), SC_(9.9999999999999999999999999999945370023257137820762768536157602042904846062815467256821930064739042206e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(6.3331514088642853122641562829604813791898849970561226896532495965433637482397590999664215987724084642e-04), SC_(9.9999979945594605304280351343129488357588291508240335108085334601776716376081624528493139965191667848e-01), SC_(9.9999999999999999999999999999914448659603041377886549777573721265986237898754766146002104557105603010e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(6.3331514088642853122641562829419367018997142490824991909583899694050813197236872954609549082952234147e-04), SC_(9.9999979945594605304280351343129488475034564168570364662494915364518262961681008191773811641780757596e-01), SC_(9.9999999999999999999999999999035991273356536617254171775822733807341270433956602359158215999330077258e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(6.3331514088642853122641562828868190589925205305752948741190191890310720237854664263790624078630255489e-04), SC_(9.9999979945594605304280351343129488824103012003144479283904992827758609424763972167638956888669694337e-01), SC_(9.9999999999999999999999999996425080349067501001618317687345639161323185414997402364529655166798074564e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(6.3331514088642853122641562828484235070281879217406955508459067071514482898222349800274177596024881526e-04), SC_(9.9999979945594605304280351343129489067267904785452794465410159306876709067724494926827756736594542186e-01), SC_(9.9999999999999999999999999994606291286614696216744324920436687154496289585658092321137223595590695113e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(6.3331514088642853122641562815722012026320626685286913226816629571910303018825575913659200309762820611e-04), SC_(9.9999979945594605304280351343129497149778610795261277352987132454971291745574750390407083331241741697e-01), SC_(9.9999999999999999999999999934151914418944279624811922994126810172757716840525966095973392642785071184e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(6.3331514088642853122641562777109587393024962786430860278449305941765653218110713822972362669794369074e-04), SC_(9.9999979945594605304280351343129521603616661469325420167028539185389961112023496661065281859197969700e-01), SC_(9.9999999999999999999999999751245686991717071787933129948865967450088233478725441143295584006637231498e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(6.3331514088642853122641562744079935794582249935850955352443379581862242345375743492755519084598372861e-04), SC_(9.9999979945594605304280351343129542521799311983871381532826116960987291403760348535672150516838762830e-01), SC_(9.9999999999999999999999999594784935705526747361011155271486474245128161745880551256261839109181680272e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(6.3331514088642853122641562218089763668513489997096220812820060574247608609194270317664239042390178774e-04), SC_(9.9999979945594605304280351343129875639406081637204143644107368997885938184934581950949375099829240432e-01), SC_(9.9999999999999999999999997103180770438539008023176522456899125095944338788228722151597893810012881098e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(6.3331514088642853122641561258627296494956301420021366546660342940113421117894048305973250730538799586e-04), SC_(9.9999979945594605304280351343130483281635513934924588925987880198548879210790682526537723398301080196e-01), SC_(9.9999999999999999999999992558227639538597062297652548804390812889751125877050961679999915338845671558e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(6.3331514088642853122641558406290217164352423881103336860411317384002311299595598177249951303886019634e-04), SC_(9.9999979945594605304280351343132289710257034299318878180735927567991334928306131197281571895568958396e-01), SC_(9.9999999999999999999999979046768064392325872501023597694467182055919197424795482596292779380209406124e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.3331514088642853122641527667681161223891322510090279521256631111122850157143437737806345221955611610e-04), SC_(9.9999979945594605304280351343151756940685987389692173053913475800306134267542263724427575887309793035e-01), SC_(9.9999999999999999999999833438636169604440007863654808501592168672487401419709884172822626273715851219e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.3331514088642853122641466794788022274554911427911763139471575018734709199483502536007414888407575540e-04), SC_(9.9999979945594605304280351343190308673311766344843810630147047534991998792671761806351601710747504096e-01), SC_(9.9999999999999999999999545085046816786594927744064285682206286856237220064773438291842993406447528916e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.3331514088642853122641230934819729837072386013922402118473399033545309192763017431966879210358078602e-04), SC_(9.9999979945594605304280351343339682392316371117616299530986820934873413197123522652854388230976538898e-01), SC_(9.9999999999999999999998427821435137888436450224908503464626295978445122378201266762861930432260172466e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(6.3331514088642853122639313451457410367639193749402407493913031226615762887588209464055816492335257326e-04), SC_(9.9999979945594605304280351344554053881606090046700236937549434873984154972218110659331573797393888525e-01), SC_(9.9999999999999999999989344743869117802564427682722945462846068505635284285672020546986878288503112395e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(6.3331514088642853122626628992590275094551327034123924004688209844407219540127250925071894216196811952e-04), SC_(9.9999979945594605304280351352587315347136793877678190501160285687834535506614248533770623460726179691e-01), SC_(9.9999999999999999999929258734239384541468227859541715411065804339627650420780653254990824829663474159e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.3331514088642853122583929324772085914496227982595167753461966182238382534627012118792731542888539283e-04), SC_(9.9999979945594605304280351379629666910399783574271524497981677022898422452789617534599911392681408491e-01), SC_(9.9999999999999999999726991323498072610802971609172631165564628019877509333131199726419589284720946709e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.3331514088642853122401762177830548775787358155565912345824823868872451743582932884867649364163145943e-04), SC_(9.9999979945594605304280351494998902377172286159333598029908363486929285523868762154088553197965076086e-01), SC_(9.9999999999999999998864069455091851037563548162222424068477467207320989386151690538652724316205131876e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.3331514088642853121712458738689753538624358336420936049375523905963419345340512062960435233112552141e-04), SC_(9.9999979945594605304280351931545294596907968281623469160487862741937852455156713953168141448362783535e-01), SC_(9.9999999999999999995598853846302066808434729606129327629111137827643745992149576866407717263898913105e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.3331514088642853118914523568115747091860891224798365451449511684043478132258841653561506639374566100e-04), SC_(9.9999979945594605304280353703520356699140752021040291477616243049803419515405526741481963583206787252e-01), SC_(9.9999999999999999982345094946262563141928282061010401312645566475523652454178723531667488904338956420e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.3331514088642853117481735813618741226893307009476640342225965762477543715974173605769943867183262319e-04), SC_(9.9999979945594605304280354610926717273711722566971538471334058841886816244488093371427851922634689700e-01), SC_(9.9999999999999999975558010079983664904423400019747067468180308257165711732230372342310167713283616594e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.3331514088642853076767323117897551457217517227375146747894864268193432090630668397181420440968401289e-04), SC_(9.9999979945594605304280380395985900812871386902230209241702357269514516254537870169523470349445756956e-01), SC_(9.9999999999999999782694710279119693527716059064427172640669240963884463638986223134771694096439502199e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.3331514088642852883407985541353754700675303553547061045398179770822802075620019726156901708723158742e-04), SC_(9.9999979945594605304280502853406577915778551307372375130633201187067925914151488790640302023135050552e-01), SC_(9.9999999999999998866755674856399278299271401237658831592904348149954808052705862000388545693045735282e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.3331514088642852155465613370413079174259788631637593289741120504797870180025663409543883917482256368e-04), SC_(9.9999979945594605304280963870425020777876864686149735980282859127681616951979610366840323276068047829e-01), SC_(9.9999999999999995418508268931994884510135841485073137876414985261709162956687608701110707487512038248e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.3331514088642849346884097634912196309463159665934799857251191990655520226623035104258678397895722437e-04), SC_(9.9999979945594605304282742587980061054857081919418166276432014028293485235697925922711965880366724792e-01), SC_(9.9999999999999982114317860178119962102523025843241453100904175278711494266089115378353035395739646556e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.3331514088642848265889515339269999084537237064293299144853466080903131577372629528351317158682188655e-04), SC_(9.9999979945594605304283427198353539625081329772360816409032744434518025603234814831633458129668355541e-01), SC_(9.9999999999999976993669706255358410114443390530442982175364229254065754770395682656710689180136613197e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.3331514088642818325713457620984017114484594502826743738372315316910506356937276062874644268602345468e-04), SC_(9.9999979945594605304302388768974328191294332362935070606871492800895819074239680021434666745379215993e-01), SC_(9.9999999999999835167697801293628586257252109827821986346452896319421932505369450513325476406144206180e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.3331514088642649156122575325249902385658277359020466879842091492244734757323968005279571590874981872e-04), SC_(9.9999979945594605304409526453743474221778633261168860231029415868552746386875438367470204304695673891e-01), SC_(9.9999999999999033814973709303521026315686280900190583201945180013005509064449413599295557331559278334e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.3331514088642035282184030662224399182025958657159536928865405495982904825658234714499214400877983984e-04), SC_(9.9999979945594605304798302191586053662596055145416325563251461737105814241991134653461653991554573675e-01), SC_(9.9999999999996125907291624072474376828309816103509005693543889644751242249749966970886959327890035789e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.3331514088641155081815672530799741764156774355649673178909732752081712523969981539533580923588944427e-04), SC_(9.9999979945594605305355746523673205089758630896382935489325241814182457746527344537335024034372170037e-01), SC_(9.9999999999991956417023001720185383367817930417962901981778272663552785861156924828591470558638612623e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.3331514088637588659500151067838600651164226137100092674659992916334912719968592519748457019301246411e-04), SC_(9.9999979945594605307614416227850837919638980565989496808468055229143953181529732836402367633525334910e-01), SC_(9.9999999999975062350997896591500748424570156075336788029544986483912772263953906564384683712459219920e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.3331514088626548412005186468081597987785199117738469538005961064003060173262500331015747349488035739e-04), SC_(9.9999979945594605314606373527739654379289260650048846557706165397783159212683131256401340013788881285e-01), SC_(9.9999999999922764935377292030166988584374674895018660820228067930903239516123104708081171350716612554e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.3331514088512271634663493951937501691458740227565613531997296900073511713959958805789900337986856448e-04), SC_(9.9999979945594605386979601383877257026278360047148426083071959408460792381616896690441269434155904822e-01), SC_(9.9999999999381438291826482978599509648317735378533471760929500147196023098453192014414119741958109466e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.3331514088323066233491494204702525532544494215285715290071102292142424904481512503108855827731411334e-04), SC_(9.9999979945594605506806270713695484432393834313789300232717213661425536566847966867148004254257706740e-01), SC_(9.9999999998485176364070340690153475810324558129569782731943874852919948648959295839170156268373789571e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(6.3331514084849534193279010460824564020695809753983617695001368601780783031146680076860111348065148219e-04), SC_(9.9999979945594607706647145227960121439132637673931882528937653499577678651863103072697296655336337310e-01), SC_(9.9999999982031129581243751053897141057090247052332368795256403196183360112642100116547892861966773527e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(6.3331514077526285233764137275934075842339631314060185179661194300176569001686433503677852675472733996e-04), SC_(9.9999979945594612344572521331925726341326676845761338715426678239018730945438982584414425158836653096e-01), SC_(9.9999999947341056312000404087036305759205847749151788907329980746022350366479316859541747592500776156e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3331514035524473592157834492249221835541620672420342940564756056871336165791863197731575236744427326e-04), SC_(9.9999979945594638944961099680891245198819740484712067128983204387619322339203180664826257449990792775e-01), SC_(9.9999999748379375353684128849578453411181346090762111892996945382866355756054055234630536157299760334e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3331513855233339288800833001998768258517394479095160637173436952160580671878669596785713989069639754e-04), SC_(9.9999979945594753126088861639385987277348906663404943385524223095576509419086384458917662241292763589e-01), SC_(9.9999998894344139355367853990571040423295989641751496584371001697615552251165959807569261245208969339e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3331513072685626173328781683414740217169105769228744748341920827745011093600645473334546180188762576e-04), SC_(9.9999979945595248725498544784385952681088756545071294164131917726768161256535977957914136317503899062e-01), SC_(9.9999995187432419038209161996117782969898836164865108166455784557416515307354403847928100504196734022e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3331511695607475091489790457965520825587678006502900733521662566942498661199724249311225503378676058e-04), SC_(9.9999979945596120850093235947945166397647154138807560758951691656184949500033551982425205747607702414e-01), SC_(9.9999988664242819645386502098302490967258819147380573761319913282361225129748441593527683998263084609e-01) }},
      {{ SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(6.3331502482364755236926266569636344016619771716121528921700492969057476015135174142279705422789047062e-04), SC_(9.9999979945601955736729637699735207103924394744234222511740651732262174825441149809041834943384254016e-01), SC_(9.9999945021311567239089047842516510282600847389924749144087423040551687983659655635215622851227225661e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.1151230445581593378237622508278008933010852137095845241788942929625411898937306861340507759316017723e-03), SC_(9.9999937825010446120439076154486450381604714704341298230943890213040101981248413403682981653260541105e-01), SC_(9.9999999999999999999999999999830629856576214741093749971721798927088147827358250657747933859691178585e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.1151230445581593378237622508274445522094420591803480296500292474109367492484727443829424237315808859e-03), SC_(9.9999937825010446120439076154486450421341155711898598578762178313178027179328782659073648536649699737e-01), SC_(9.9999999999999999999999999999734763885012578494627802614396416996406253811276732535072105688970250530e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.1151230445581593378237622508173211156275757329720118410697428414503482047480702192092618526907319115e-03), SC_(9.9999937825010446120439076154486451550229599854393173285484919176144096347014458610967541468493391217e-01), SC_(9.9999999999999999999999999997011269159752717339290229415315430892066663675233543392867689111044313954e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.1151230445581593378237622507872326997558864176093375532708068116425310315522099513253758144625939394e-03), SC_(9.9999937825010446120439076154486454905460277245739654778530887245316853626827566618180317236831307633e-01), SC_(9.9999999999999999999999999988916622519227836749050252081284595586832979861032405031394809644325463203e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1151230445581593378237622507662727806775051216699658405658218417552015911762546407367429037331672218e-03), SC_(9.9999937825010446120439076154486457242750608093478690617902085023798253212824945112316517553681945236e-01), SC_(9.9999999999999999999999999983277803271414549843392717482079201248755207195035795055189576469364630424e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1151230445581593378237622500695900958962851203861965274469631115356583910192276915231169695714891650e-03), SC_(9.9999937825010446120439076154486534931490565478078522750037282061259690143142877270866599842603654591e-01), SC_(9.9999999999999999999999999795850184020034783511428134431310969965864376257749562416680672397039539136e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1151230445581593378237622479617592292225048324719266578690585318389879081196264751925259382071443000e-03), SC_(9.9999937825010446120439076154486769980714053201179532939561941652926124759543194135744505247805716594e-01), SC_(9.9999999999999999999999999228783239835392064645239645631523035272227787783081677512770080376824490159e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1151230445581593378237622461586888492639230425614762668073195877317301626969017515000413859248026437e-03), SC_(9.9999937825010446120439076154486971045372230336486591986259029128775671954683458757306393082752749960e-01), SC_(9.9999999999999999999999998743705605439407329465299605373749042580256525735908641389950189513289913042e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1151230445581593378237622174451767892534015031663498272315896514692963601966976406590712526925951340e-03), SC_(9.9999937825010446120439076154490172957261850355215171082247480949197828300902291473673540786407671818e-01), SC_(9.9999999999999999999999991018947514970177877597142776500046170603078268216637991998568434512093965684e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1151230445581593378237621650686523174000757353501882081958129212358005096933164643841826730884017175e-03), SC_(9.9999937825010446120439076154496013587836504606803992830050389209011976937143195078642256472064000960e-01), SC_(9.9999999999999999999999976928160560068489455683635593557315319368383725300109901511740476153537026185e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1151230445581593378237620093611515564454953755320101956345345200716775345039747883222167557064871014e-03), SC_(9.9999937825010446120439076154513376900863052425619059251517245414178788236509519387288993114665503500e-01), SC_(9.9999999999999999999999935038378016710508781215051327857224818102971180989804948461738129556836156041e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1151230445581593378237603313575145908650352954918088468500890013757711857757686344282925490670768251e-03), SC_(9.9999937825010446120439076154700495069647026560940297943182674112107347183137405968932425667397471803e-01), SC_(9.9999999999999999999999483607283715322227569597098399013386647944102386165372817977126391581047288411e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1151230445581593378237570083400060925792407831363656163396641855515183288429683867829763478364753601e-03), SC_(9.9999937825010446120439076155071052640160825076612286660785043850196704187758630306141677620084657809e-01), SC_(9.9999999999999999999998589620287979850761632944978448237882879093020237866833559226340947176695495731e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1151230445581593378237441328750203791028930656493554143352379554450121044256278113296453137834280568e-03), SC_(9.9999937825010446120439076156506826304350029730332831032965044627509002507508448258632630052758955696e-01), SC_(9.9999999999999999999995125751008977168810375698460688014237778906129045344741129499565286591045608967e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1151230445581593378236394585206949270981124466309531981969214456860841347306201358055132066928013763e-03), SC_(9.9999937825010446120439076168179312029972567768657045067249264812131266630299789520491355581584810090e-01), SC_(9.9999999999999999999966965348208015109627389180444292592486575239634767439049280268790630349655034100e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1151230445581593378229470209392396954321785496713107978696697315802015561428139879990125334828348030e-03), SC_(9.9999937825010446120439076245394670438498230959192621035469692164416269252306365352540266997506976167e-01), SC_(9.9999999999999999999780679783477648688539113407871020706602611473461380338664584601508710118346674604e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1151230445581593378206160697317290006374834036649886851420989045374489041335085044912863382368847480e-03), SC_(9.9999937825010446120439076505324572773472237588071935462884310391667056360129376334614417193720628220e-01), SC_(9.9999999999999999999153587069738030263276750059237716741739516148280513800164511417628462668118082119e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1151230445581593378106716661138799264657707576536413511194954999556984813847630875096103058324301870e-03), SC_(9.9999937825010446120439077614248626111989967394492500934229035801696213276258546967640268909641096530e-01), SC_(9.9999999999999999996478257345484056067324840610667908620571187529332697405377108662749482053120633715e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1151230445581593377730429732948206571007242024014476426768731739506278496857275488120140438036144282e-03), SC_(9.9999937825010446120439081810313484928189604040362793873167230905993801950761308787414799061520007879e-01), SC_(9.9999999999999999986355059992254986237542000062337535937178145075457032719481159893820043383748879963e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1151230445581593376203052425903221070645354509381511312328361140973780251918354470218166967279694641e-03), SC_(9.9999937825010446120439098842460402874224460532822022600660790966785024553818205484948959876874975793e-01), SC_(9.9999999999999999945264230750830129461907700459376129320699708090806289389609015868002522970421199408e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1151230445581593375420901529397027549865052540176984506806695942401970137747300907232613511948967951e-03), SC_(9.9999937825010446120439107564410715904723582091757741519686705259259101522127773271388812987333048124e-01), SC_(9.9999999999999999924222128854250901258526804710286754711784957439030254449319028000572100573241648553e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1151230445581593353195129225905427040370141027329790018609049604108687708996127052758615834328127095e-03), SC_(9.9999937825010446120439355409273600682009111078400786029239906704344578371741488856381152941041981875e-01), SC_(9.9999999999999999326285122543429197566807458354609709679092331484272641596776103676931414157712661641e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1151230445581593247641338192543070810164008633098546698373093010796714616617362636240951795724505581e-03), SC_(9.9999937825010446120440532464653652529294934443134236633868843091052872954125040143880052518946675567e-01), SC_(9.9999999999999996486585473261426714772752127811107287866941955149092126587349829934599973143717382831e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1151230445581592850261630548247853921844583863947673781214197078625703734082351601975256660747279487e-03), SC_(9.9999937825010446120444963740103136954444398377613350127319915111841707650362693438532800238526625221e-01), SC_(9.9999999999999985795931870184068703070440653066791569813357909259119255761751837199917744422656094487e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1151230445581591317072542668004980109488776009511023798765908569198029326640575261683254693353666899e-03), SC_(9.9999937825010446120462060695568770864718446812761518004160562339991834005533862289043785011450532553e-01), SC_(9.9999999999999944548749059285163369378691416656815673626983380890748788247814006808289198782222438141e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1151230445581590726963589679572995043367616201108039791859563709873125420261888987577630855028684182e-03), SC_(9.9999937825010446120468641140582936743428620233604451790799289371944620551142688845137041439534784831e-01), SC_(9.9999999999999928673126114489446142127871497573108138203652707212933306195861930320431495896072490618e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1151230445581574382787369860717988387556597811522331276347862388649295029229504252031340611207760026e-03), SC_(9.9999937825010446120650898929372092400316321685514573336559470642205978385027517278372798942505059472e-01), SC_(9.9999999999999488967919652002200608056691778184042071480629920308727105411253121886837453719143614791e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1151230445581482034045028309822151288668526598678529510782427290875756773602110826859068766081422840e-03), SC_(9.9999937825010446121680701676862109414650680959806061109709042561502384960583155386278359458032026327e-01), SC_(9.9999999999997004521945029939524519807988304497712631558296840717696846076904593251895547134897490670e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1151230445581146923663279514232273808032356391767560423881910690954665520922118940006830225658549636e-03), SC_(9.9999937825010446125417597091863989572206128893835645017737249842899149881765860525191996331637277638e-01), SC_(9.9999999999987989091762877341219765634460361336670010525905832865194036426086080836499888450035925068e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1151230445580666427159135350913924957840117224862438385546094095412452776119993686475924570660804358e-03), SC_(9.9999937825010446130775727669288702660230805914165215524385558215492568955562302038223425982698303816e-01), SC_(9.9999999999975062358000485908734719478810153042293069619369992773337097442840999078729107368595272485e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1151230445578719536977634680603887244600999377531918928830051179470898168115590680307075643341561455e-03), SC_(9.9999937825010446152485962233775224372148605275355048722386444423496721237699005025333392613238461503e-01), SC_(9.9999999999922685429502955838664631272727816444661190329305795554925270211388492267551620893770235725e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1151230445572692727041039140715569515503010607476039881350590256326043245738973412315767507983989750e-03), SC_(9.9999937825010446219692350474002467719831197521259665789639250794720864073902083250171465269903551282e-01), SC_(9.9999999999760546960617203485641240380859736312346123150565622680104957888504411723581542656995183881e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1151230445510309667465762999573965381712560589793232301379844337809796876777192164154276360108768642e-03), SC_(9.9999937825010446915340656215112466713751764274192085276047213707405141135632233604708262487148944625e-01), SC_(9.9999999998082263777583032021219768261310135692904762976524857274444378442933476629140399852481195524e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1151230445407023487300311454636906348300411783216388334416692480105207270177624088648477227941928851e-03), SC_(9.9999937825010448067109369183301747572091052641346887644579571292911780294877550349552046798435521115e-01), SC_(9.9999999995303569362926590345271032984704183502101239455443249812626633881912233012322514970006671323e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1151230443510841592489399498105643873291638437965025889530959670338470771703346790914063535842034970e-03), SC_(9.9999937825010469211883789591852787022934618160105491247732637228975543229542112221473226791791147328e-01), SC_(9.9999999944290839183006430414574351609543313909930722699101778024497620786081837377752421214481585096e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1151230439513120562144774691674826317615718688043008204472276855189036913960902175414802633387251349e-03), SC_(9.9999937825010513791419957165410295232978602320881221435745283859696357953070184445656355277151315324e-01), SC_(9.9999999836740680207175934992549794219452505164862710738365313509599510981077592517033331057428426492e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1151230416584564321862938354346369798065582961885236726743202520638761750161472946379071965280387958e-03), SC_(9.9999937825010769473192945140536193542795148817947626966411005419120237352880851215134145295569139202e-01), SC_(9.9999999219896771185062162408524680126448574501279458185414108815118448066991300137713031385864278401e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1151230318164633328662179168110027718988650834868120062903092502616445710608484995042009978407195649e-03), SC_(9.9999937825011866977198564424578905995940598671698845890554849364786285677431525123559707851986388136e-01), SC_(9.9999996572118420416273131005618585978176284109456206628626510695818936673319746185154756172750060072e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1151229890976177925564895900948422765637907727698485365068768615096517552776827256615551082758592858e-03), SC_(9.9999937825016630656924597566050811399144105105030486176230624289059760108235845273637295753943335644e-01), SC_(9.9999985079524168038508969654208018027440236033412971365077938504746336884462151189000156212795999234e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1151229139236870748805690148597370202630092110899108038504772702984873664112710635494348151770769836e-03), SC_(9.9999937825025013479686471079877253922057100838073212611579865064021307329698416536498385807829416717e-01), SC_(9.9999964855581903217136902723931494530188563891222406297234242400831410721726506681703129294737096044e-01) }},
      {{ SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.1151224109779418471898048796855432229831639422254703372124185126775430234801866145134926816233992132e-03), SC_(9.9999937825081098134405736549022368179422369363383013639251113732102069607604783535167092329931781497e-01), SC_(9.9999829548773252198091360340235253794163035959046324971915422100225138233261560209018774762683058322e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.9624658370787769973453890669810924570623356830794558727594473870475439221681405710695652755615592347e-03), SC_(9.9999807436206510861940309466192915924303502444511020819759017888186690770708981239790015744050491215e-01), SC_(9.9999999999999999999999999999475439621419667692983603247388410783559642760230420680770628446682991576e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.9624658370787769973453890669791502138033209497009513957064670917842959466350371394300567087029101833e-03), SC_(9.9999807436206510861940309466192916305462840730688125482791059829004675816117139378021381034464536975e-01), SC_(9.9999999999999999999999999999178530796051510464041683223804309449682405009122504948288998135233899544e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.9624658370787769973453890669239722483081626388175831464693565820526371671449293712421748005670335475e-03), SC_(9.9999807436206510861940309466192927133970916892590706182672232284488170501085125986137636801387228091e-01), SC_(9.9999999999999999999999999990743529235184778642353926065861306184985952783620720427690493504415247500e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.9624658370787769973453890667599748192388757727792670887165502613326323265844008828433451577973123870e-03), SC_(9.9999807436206510861940309466192959317968083340971414630486279372669191437536984941265706256114627584e-01), SC_(9.9999999999999999999999999965673402822152250073017666308299552129361272540539331184293437411253928588e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.9624658370787769973453890666457324192064729475899417947167294837447207282228006411998303875282393784e-03), SC_(9.9999807436206510861940309466192981737691976559581057099176919579563618254803036468096394829994500004e-01), SC_(9.9999999999999999999999999948209278983170994723232491783417814606625997527662509226469121396498102545e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.9624658370787769973453890628484514434169800972714770333272872501890640188136078668656261010816188855e-03), SC_(9.9999807436206510861940309466193726942545848899684388663657164278406845388863107153586232426766601443e-01), SC_(9.9999999999999999999999999367722654106716380685931388593210826594719074233983614590601566365730457802e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.9624658370787769973453890513596829910824175341165892657129343439110132414596963014341000884783731182e-03), SC_(9.9999807436206510861940309466195981578447242820037184064719827645545319708283144837154262624883622715e-01), SC_(9.9999999999999999999999997611445869374922522389384064842125666939591009837650092270319075088584543049e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.9624658370787769973453890415320168219765327161707730462216417700031466886650252484743645149023522536e-03), SC_(9.9999807436206510861940309466197910228072632217583317420549165767303627658429394886399198585971494043e-01), SC_(9.9999999999999999999999996109100164306126462920833984614664194149516909979989223336952509543091646785e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.9624658370787769973453888850285246649697053777251263722485130445994850485243799951783798059018732620e-03), SC_(9.9999807436206510861940309466228623562889560069481170483010672133166856768306332591311472987027541452e-01), SC_(9.9999999999999999999999972184564549790182157336599370225662347129407776808689884925651724052635139730e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.9624658370787769973453885995493756928683298866852754367950027405467779314808057355403936183988160358e-03), SC_(9.9999807436206510861940309466284647978477907187088646903382168935378151460703603300008130135537054043e-01), SC_(9.9999999999999999999999928543646557156381274042332096397500553385727257667954737167452048022533381913e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.9624658370787769973453877508629602798364668862115378010648484846679951754451447473869627846054864676e-03), SC_(9.9999807436206510861940309466451200108861099814262158558851066548402770114806155149444985549349052989e-01), SC_(9.9999999999999999999999798805785176176944417591770339510787545289854407530996996391418430272072302834e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.9624658370787769973453786048752284964113207529733751419543576859094070445375840280047253055337600366e-03), SC_(9.9999807436206510861940309468246072412131953716825137218409075860194080867944440740349940631465856999e-01), SC_(9.9999999999999999999998400667595394052379591169251452495435597287372796713674194021969323501321703217e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.9624658370787769973453604927110497662921879261176404006735639221107185747503024479208341566804628888e-03), SC_(9.9999807436206510861940309471800529600361537594118271451726410946519836836014704476169419604060262130e-01), SC_(9.9999999999999999999995631878790890764244062981462149977903273428940585461248247458263859480115628379e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.9624658370787769973452903147673277301280130395855429393052376095802201147116639650494995110181898414e-03), SC_(9.9999807436206510861940309485572737827741447855853026496947730551020239468064217854948353712411401927e-01), SC_(9.9999999999999999999984903845244859885097952462558877456793721722784919555467634958959337325833920096e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.9624658370787769973447197853957560684531420929733010038372853652847243611313069344074657637202603585e-03), SC_(9.9999807436206510861940309597537393507070753528623549705493835871912640337645857269266792693301697184e-01), SC_(9.9999999999999999999897687578814203686133032097081942465864883298685310964418821651297063063808566438e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.9624658370787769973409456424287791505000459180915346158940527193420406190481980802164825339675198976e-03), SC_(9.9999807436206510861940310338201483452272993910059830130060542320010098199309428777453347676389676696e-01), SC_(9.9999999999999999999320738038690657240103204057254801709891970216714599039697906604641103607261123127e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.9624658370787769973282407527148149179585274510276540221759749038032497615685300908320307807877341324e-03), SC_(9.9999807436206510861940312831497487388477213132594193087514118479816860834115235047634588285995177539e-01), SC_(9.9999999999999999997378553987389754548040720750604412386992374537917179128907297492016368928665248761e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.9624658370787769972740386094743971657091072354658497512456940096157589507693145848195516948791972746e-03), SC_(9.9999807436206510861940323468503410987617208921413577857501905965678107178663714203874041842954577253e-01), SC_(9.9999999999999999989092725419184148568919670109528006139959127909029893360414651355968361258052977864e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.9624658370787769970689427710002267732330720966105566745568783527589265448767116875740222736611303602e-03), SC_(9.9999807436206510861940363717938550085422649634115392116074347791735274677458763855337483743687350761e-01), SC_(9.9999999999999999957739925399605701434766641830104837062850645797969386378731319182296081633498319680e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.9624658370787769962364431384428519537461090660411599162366440185673636337776855709637937513086352824e-03), SC_(9.9999807436206510861940527093461979639255975498359583359693267053802319235467270645300692722562157354e-01), SC_(9.9999999999999999830476521665399387670406132618632749203436027004443955231085504145358385553303802114e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.9624658370787769958101304448193048044993975037776366363324396297278827856448976808066389911326597319e-03), SC_(9.9999807436206510861940610756032798383620338843782305155667411631074871782543021126783866599677485591e-01), SC_(9.9999999999999999765306517591083636889943877189180682363246522930518779893089627870467161046492741548e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.9624658370787769836959349604315873738601604850371693926762302981159485904670868252103149884650294852e-03), SC_(9.9999807436206510861942988130088940539771623371653624596128636950008909838239973201183455168816245916e-01), SC_(9.9999999999999997913421314820761067346858749417980167642044404993722649826595080043641016696833569328e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.9624658370787769261636593105328766935826211328153410642779802902773757816435154558970746839751929386e-03), SC_(9.9999807436206510861954278664379654216132452003943579474961361064627190368991762885091992164152383996e-01), SC_(9.9999999999999989118518665688239630820530688097759602411677092418968344950559986972166594591746816146e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.9624658370787767095711650566626613741979579989487919617701038311449537729267197184943027998868120618e-03), SC_(9.9999807436206510861996784283284176581723653527303957199167037539034471582758835339476553366522446606e-01), SC_(9.9999999999999956008236133366102144326224585845440274197116529927176051787350153668466653305864493062e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.9624658370787758739038113425448285956253736571446685340044137947249938845113090646569188408970460889e-03), SC_(9.9999807436206510862160781462365964045455769060925229184128353763264786438593033566892201989723088449e-01), SC_(9.9999999999999828260585967423166190525208367025900613393473236416456818854260998742808568394839861625e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.9624658370787755522639098815644759983264374739887504336805485042232979066184199586228131437024797688e-03), SC_(9.9999807436206510862223902315759729597517322580266361252080502442395322382510158627243703880069673014e-01), SC_(9.9999999999999779091809146566110262299965875738331652408405999737114231455615349848612829129564163120e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.9624658370787666438425036629019904816738082178712708647865905580285901608340711236933228676591051962e-03), SC_(9.9999807436206510863972152949458004606365691023823925760918144103255510258590008002887007535143992663e-01), SC_(9.9999999999998417270150953923055531748767900744142155509708917075362968373144956360575368930621039418e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.9624658370787163090013927808615357208265504841941734342078335406393612864178093247477853351085540050e-03), SC_(9.9999807436206510873850212580513610588892651008810255761064220374526555743042353741197157598130162163e-01), SC_(9.9999999999990722632272840767121005911847006184581194371212452850140344371707554136942191348572353074e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.9624658370785336565104953182606692447047730915912569163527620115387859584119495605474126454792181837e-03), SC_(9.9999807436206510909695208949356881779869114372827922191268997647125210216415699406172870045677063979e-01), SC_(9.9999999999962800724823182533114577491777411293965648035383161570767244124693660421008538922382747661e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.9624658370782717610631163121267949137096961121939515970590788941936975035522239970567204778521519711e-03), SC_(9.9999807436206510961091394756568384958088089883014289944907724500971716425477676973213620711663551570e-01), SC_(9.9999999999922765024202443269838081848095543526718888189745886795339039411757654688793826438202724088e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.9624658370772106052156039170591142783248956365853630899661281052884487309409515474387667674568926253e-03), SC_(9.9999807436206511169340005623828585509563179335244305427164070425580419319962473861304269387084967009e-01), SC_(9.9999999999760547168763872764340189699312409571226072302043979301902010300909675517769954203858448870e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.9624658370739256820767283075184932827441804024765371255975612517766586750955396829433133942535903014e-03), SC_(9.9999807436206511813996190744476198093922023167009506126030291559938704579804338224581759568838821190e-01), SC_(9.9999999999258384184770629936531785440235746196136128925264246827063599922303130648660594534561711918e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.9624658370399236879823786571268274225729747919848773849228434109921515230021682526124519885771267265e-03), SC_(9.9999807436206518486784220315486786053813573986830201742414177495015694807851347459982418136945864883e-01), SC_(9.9999999994060532638716261190197619709437925527424462511817091133673274045204718467074380656618950263e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.9624658369836273775434361219093566575803355305959403042625598300122599309750527200456894301598309557e-03), SC_(9.9999807436206529534764093348044643171248610592994893092350124001158099316814472175887936787067571379e-01), SC_(9.9999999985454570781374841662642261300214828341476300944016258957257855682627132078948768875538710286e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.9624658359501101691817895280368659662068245113166185530832826867195175379135219466492245658673317254e-03), SC_(9.9999807436206732359375941148693275408464117868348749705262604696109529639400545520045548124669545364e-01), SC_(9.9999999827461807068643029571329445606319534815750100995765199253620822270053490333248080308648046372e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.9624658337711454353535767772728066582669228119001601047882922756743058306764879044751778961867430088e-03), SC_(9.9999807436207159974583923617777229930876857872064350222231345069639920684624814714766829147514078129e-01), SC_(9.9999999494365601768765415475668023804444223181604563050710128324480789045560389975585646479412395317e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.9624658212738963801918504008823362171627136403766184093621722517683529120839540062283835038967984095e-03), SC_(9.9999807436209612521727520688591812145033425285256748768572695176452944134483824461593899785539705143e-01), SC_(9.9999997583923378400608885393307106595874343694130412653298758924906083860745008171815249422686381232e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.9624657676299439087207816643138208463868773855470548068963777321873312078097892969217406130702617720e-03), SC_(9.9999807436220139984180047516259348815078134696833389325198424665820109430651275389263373029825937202e-01), SC_(9.9999989383424957772865940170081958963355926303854127590036620690924793609178659985538262112806380760e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.9624655347901492939542296762780516148645280109201716440218920370836624752898813702873305305725479817e-03), SC_(9.9999807436265834082086947313286570924187910566506765075997238768947196302437721598689092922444008039e-01), SC_(9.9999953789434875380492677983026255522089087872960980582650861374506246924654164939652235191361176896e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.9624651250533878459738450862401170129639001739087156526537714454150144984899822359388231503597733792e-03), SC_(9.9999807436346243655800201534976679599271297248145667027387344805098722207499839613048919499163188694e-01), SC_(9.9999891153383798172240789163670400252102607241937044624392509946162354380574048805996987827696949115e-01) }},
      {{ SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.9624623837401207074153602083095768745838878923085107541018685572146516933122678721831106187717101768e-03), SC_(9.9999807436884217484361451794698183961840294153310589324067653972421076181985911507570974867726950252e-01), SC_(9.9999472091686546413311133075262073217491130037676293611255909588368444716912889922906840983209874849e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(5.5537254964347380102237759277924645663409833083110060828686044805014495259993105616586613289956572234e-03), SC_(9.9998457794763527579127266624472645019677027774298372151487550728711986088537049236506526212835705964e-01), SC_(9.9999999999999999999999999995798928298689502715887260812799152582389840633279664671780871105720101403e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(5.5537254964347380102237759277484447533840826218133224475305854228878966132690851808232289168878893707e-03), SC_(9.9998457794763527579127266624472669467449819309248067631481373290166014234298700244759596619742267511e-01), SC_(9.9999999999999999999999999993421060440085145669369368592371804798053328454692981046528999718155916368e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(5.5537254964347380102237759264978682825091933087379826856694482960528913555117776546458987084669391567e-03), SC_(9.9998457794763527579127266624473364014004306567022411400661584571632459810070533338616358062949945077e-01), SC_(9.9999999999999999999999999925867261478426914659318773215738878856874740852538131751715428482104642124e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(5.5537254964347380102237759227809620095510166057308337410340825352816743148848391867911188095736415174e-03), SC_(9.9998457794763527579127266624475428313553640917506795477386175979427266717496386473639008661449658544e-01), SC_(9.9999999999999999999999999725086945383816170944216072821709475895003488544769844313746589712400623402e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(5.5537254964347380102237759201917245091336453154126690878309457705764059350226690718625246163562407508e-03), SC_(9.9998457794763527579127266624476866327163001392803634727108919288406400442243146273944120295598170843e-01), SC_(9.9999999999999999999999999585221184560078210526995689316466947228671099428294716648561636069088784500e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(5.5537254964347380102237758341285614510489637367621905905641013912338649221939741277261177159977337310e-03), SC_(9.9998457794763527579127266624524664182601981409598467423403558793373498976748774983740846464782666431e-01), SC_(9.9999999999999999999999994936250289431266907305183470014194191313955656869423887236105324469419734738e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(5.5537254964347380102237755737423116702369017144078972068410127750521857627613611356041438104537400504e-03), SC_(9.9998457794763527579127266624669277788273452742662904551466907189608390285410618486488612385995546718e-01), SC_(9.9999999999999999999999980870672710023204679073530024478593216968872292176136768162021421573145212016e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(5.5537254964347380102237753510039782720000573286356070776501503243657758282047226072286425730335354079e-03), SC_(9.9998457794763527579127266624792982452175974118353545034347936731665402798467840658370314113401145577e-01), SC_(9.9999999999999999999999968838765069131232991214009415564769820169864463816961159631415306547004890702e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(5.5537254964347380102237718039434234844321624939287503269851189604016568004601716115368449999840078346e-03), SC_(9.9998457794763527579127266626762952897215500749897709352667907502527463384216112311476754796002738358e-01), SC_(9.9999999999999999999999777233196594527190027464758804977310154509022099539163846527313343675766532174e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(5.5537254964347380102237653337246789889666516694368500378991089073198527965354242134254649198676413435e-03), SC_(9.9998457794763527579127266630356390196275138849418005486256695821720017252156880106722435722989908822e-01), SC_(9.9999999999999999999999427724097004785488698209317403926334314031428479037883815216667730819876016113e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(5.5537254964347380102237460987410629326721321082957802284879608984699936588724571379119868371694473940e-03), SC_(9.9998457794763527579127266641039136839352897111212656923422262207896877372584170817936175519314507528e-01), SC_(9.9999999999999999999998388686304041342210909817121681790288540975679471110596189553641717360274428229e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.5537254964347380102235388102526665568404409659275061038171588938241275458358238830096061373391636601e-03), SC_(9.9998457794763527579127266756163248601869820554325817136325289857973519300210310712879418536792560490e-01), SC_(9.9999999999999999999987191350356725486851076843741346870681991259323750829691166140152529006519093245e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.5537254964347380102231283085939830662039902031568843613051085009808200049638741055558630201333875240e-03), SC_(9.9998457794763527579127266984148117412380222647102839049195227872028632849869808640975829574062599162e-01), SC_(9.9999999999999999999965016819514376029204947047435701979214717945104953335814544497198327007142384361e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.5537254964347380102215377663475339561608454294615156476150859241354828580612973115152927598288307222e-03), SC_(9.9998457794763527579127267867505243318333404984823654937480376254668326036849883378239022455573017780e-01), SC_(9.9999999999999999999879098706021101522843488607975143368761967480247872231121439780393565390910713709e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(5.5537254964347380102086070502251143361968288295835249437928844999740398304964923952830138239432490872e-03), SC_(9.9998457794763527579127275048980778034243219783733966752677919634984394999800828024474443519569840467e-01), SC_(9.9999999999999999999180605636858282755913669969780148807764860787559631309258004589379277307174365765e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(5.5537254964347380101230682966689791426075267208929885935361217962726166144766619780003886862361683710e-03), SC_(9.9998457794763527579127322555589083230760339750699794008832424815714944992924834313592343616203212373e-01), SC_(9.9999999999999999994559962360946147983085915547672257244297291824616628049279239454002393299116547589e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.5537254964347380098351193663529777113066822518572616498600727962539097026566998640975805403388654964e-03), SC_(9.9998457794763527579127482476986996112295768490008991914564918245677880817100135759022539035727726213e-01), SC_(9.9999999999999999979005500396550429532457380403996765854572913897630166698490702769384411866939872557e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.5537254964347380086066593388913872447465128553196066825532666460303209525660778096410358753496457864e-03), SC_(9.9998457794763527579128164740486485963308398454128365187019597053698897598604686996398193992800716910e-01), SC_(9.9999999999999999912646390289899729676806277336338481405792946928323628885468307454607522461346431815e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.5537254964347380039582815386504495293404969060684848179656106788934850278866042661567399694242991320e-03), SC_(9.9998457794763527579130746361731009913964278583075330125538298309521651446659245883739390688810810180e-01), SC_(9.9999999999999999661549726688329133533909586540291357295380451684104834832041077954613275126634848068e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.5537254964347379850901619342841473017054288982641687949780084182067107694765699125839102689932150548e-03), SC_(9.9998457794763527579141225359030309918980727259508234319637056287418578944064209406772189903505266697e-01), SC_(9.9999999999999998642329240598279392293692719991321290335443031643952373029583686438237062599744209719e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.5537254964347379754280328743121092593461882232034595171597243486489624894213502341249287904054876225e-03), SC_(9.9998457794763527579146591523038593223943754802192239740793250173218029117146405967711712726925537564e-01), SC_(9.9999999999999998120399123360174152705378635895906876409290512119347018035818522267204244194631778974e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.5537254964347377008668434501849797842400645807040661740165505269589722637224156606362354153587183735e-03), SC_(9.9998457794763527579299077622490826122266910184603458216479425418385886933917192799806179890829668430e-01), SC_(9.9999999999999983289117850288149663395001153387597862050609377515338024534547255637283294269495473119e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.5537254964347363969313032758213099629937673479747176493665142238021127284018469490008434923128620191e-03), SC_(9.9998457794763527580023258796368187695115701028257919876106012563512759241160721683010678760558807089e-01), SC_(9.9999999999999912852961892327140814451369257402816245087717183021777027298556759749614281762345356855e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.5537254964347314879884915702641877473999241874433089239538631256955239889467494484422373313463425377e-03), SC_(9.9998457794763527582749592927426837006055114787169620427235236906731352977726291707673776236436369492e-01), SC_(9.9999999999999647681064339962074095159793349405097761224425697410162680753085295873954897576479940421e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.5537254964347125480743310008807122705554476799158605973080557907103137295140367177251530473532614541e-03), SC_(9.9998457794763527593268463567384586252576527097744554618096549806470086932755375206035340246957747847e-01), SC_(9.9999999999998624582370775810450142888165636379317950198841500432744483541640885661890897769882837189e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.5537254964347052582931791946635775024026760591352580399822498773184440760982179690226168248416954226e-03), SC_(9.9998457794763527597317070349831926064551592693583443358161085084226847463705025337560245697784290155e-01), SC_(9.9999999999998230802044764169320342246795292814085027756254139818807004535951739000864725046854378585e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.5537254964345033541072730892610094430409152592905053456192104751099761684556627411665472852265465705e-03), SC_(9.9998457794763527709450842193094133302123520391969520386944161833109519797893608513326002913824660177e-01), SC_(9.9999999999987324316034615414339491585870902184581716005260589836832709086745628103874657673801703216e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.5537254964333625442315625792182579419766179049313009731080300497295034544926159006704929506713162845e-03), SC_(9.9998457794763528343035102694445620716223416471825651649700646737927148289589108483366105191186054222e-01), SC_(9.9999999999925699902980287677202004888539735933802407644670910240320635524719853605590160165225332105e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.5537254964292228318406984140076942569184468898928569230219314981698130593717511634192761472297234976e-03), SC_(9.9998457794763530642153185117391336443166827678970480674592875112757164952400118861400101961030458739e-01), SC_(9.9999999999702080392199142371562274814143032220486476906560635650411253500604853950519418168006623715e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.5537254964232871239656062459477341319341895477286662904423703719137332143058912816539911821665150739e-03), SC_(9.9998457794763533938733241671396075850835508783923336335575699067360826362173335326348332752747805358e-01), SC_(9.9999999999381444568778970368263840524055180090854392548220673498508627088921404089506710815236761539e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.5537254963992366443417461949798354191253964148667972675916088741750142996050414711839727232896302001e-03), SC_(9.9998457794763547295915425629590554977738122306015762280573923956488837877005231348010508907944462152e-01), SC_(9.9999999998082282699611282056745986006058571743443530707820439430226965985587632768633640683449514618e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.5537254963247857734330943235458167599650180670542535414587350880275473594428715907345000681601060818e-03), SC_(9.9998457794763588644523105196080080938987915265696457773213571656414418904026082670877475208199882960e-01), SC_(9.9999999994060586079700823704950468513291152353820180366728216336814846231885317798850011238474514234e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.5537254955541503686362139267722863109937833811915979175499724142102025357032290329680398848566398691e-03), SC_(9.9998457794764016640873256725581869138879728883409450080336402131961808153710634842867772555715533078e-01), SC_(9.9999999952432304707904880691357305755107800515991597413244556301638800629532066011282862298059316248e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.5537254942782272607412634647283510929141250650150399598419252566216318776635011834925961653324965251e-03), SC_(9.9998457794764725264471073840573817750024466907544273016591224856790887522617929643346679891896072055e-01), SC_(9.9999999883509327889428413947562786616117783071277934206194263399214734963270919125207605840735706896e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.5537254708541613364517621078222712842834167109781610907563512645226820793444184991921588871646226517e-03), SC_(9.9998457794777734548283832732383563700079869478495104372070461700623668764861877125499934181361441360e-01), SC_(9.9999998618185154929094056830342475409459909648462534593493359982648637681042214836161808970638649494e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.5537254214691941745202827650452332660990516871937401306137512414744690530845500134155526715740705369e-03), SC_(9.9998457794805162026150332734912781066831587949509486498394209782906276770099417370370649912201711319e-01), SC_(9.9999995950501723326502014448284283813659974006628561079385603066546909648996306418959488503768520926e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.5537251382263243299318588892345129087310035616393315157411535693000979302434480926033705363808394024e-03), SC_(9.9998457794962469760817516855002411215532550917559521569173690590004894865829917592804040225517511794e-01), SC_(9.9999980650252571090429882750221261796564181593861322747980066733118377030413887355307284494642597198e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.5537239224174767908198646875550575461611770436210365025572195285327139024705828500975438603233699440e-03), SC_(9.9998457795637706916432702898815058718652446435905992265462968726343926572140311773233364920039879763e-01), SC_(9.9999914974540081702466516093039745522360463756143634017126015687468875151256681056082870805800882912e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.5537186452411610368316744850490907686559870419864125239699201974991808498737666844087719619609026340e-03), SC_(9.9998457798568548758292782259837382457259529409239790897625208948830965062172453663191469089859973206e-01), SC_(9.9999629911444737711550040042616889438982286552020161256422052047005880101103938767400036503450328154e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.5537093588060469212128397758741108481247590432805890985135415338491592730258017285815457903019944376e-03), SC_(9.9998457803726048769413539529167115551812956069869656198321409457377731122031386553918459182742160224e-01), SC_(9.9999128276026189256286874155943874218513475608466529102358023265822413028953116800268626933409363941e-01) }},
      {{ SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(5.5536472288137223971024342089743453282116861258363403122396560409908747967657227402367855282219546293e-03), SC_(9.9998457838231579883203954217448265517990158878865251928646060037032208535948644957372724530619404940e-01), SC_(9.9995772141604153494012210243229024015996026686657858761682386056455248943232833281153738340373195916e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(8.6910189286625615131318849332128238728105945027150538680085371439664372657822634626392993371599392181e-03), SC_(9.9996223238179432206582851700418320549666457586509452370885940272537783669308934052381014776965366380e-01), SC_(9.9999999999999999999999999989711959499286993278419381669168833460933147205190803845109672625329271976e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(8.6910189286625615131318849330441285009375596017709085290237885838112313967826301685993782454705393980e-03), SC_(9.9996223238179432206582851700418467168670920800392478977228529980066889040721418288500532120211905823e-01), SC_(9.9999999999999999999999999983888778517388000296324766882455960080496403171516027244459684961852727305e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(8.6910189286625615131318849282515942160585668118397764066435048205405211607624879290359016330564342755e-03), SC_(9.9996223238179432206582851700422632526605183713554949154428835824046605006316597555975943068341532748e-01), SC_(9.9999999999999999999999999818455701172441818598269041423736247316895053404032700556660441952126402226e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(8.6910189286625615131318849140074426893855902944102517094756568889773911255990722224213776871779575481e-03), SC_(9.9996223238179432206582851700435012613225673805683149585231029346198459372928684467816671724221839530e-01), SC_(9.9999999999999999999999999326763064009654758241129036172060229927529811636890019702119562500474858263e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(8.6910189286625615131318849040848111818829478939862395969502932023578137365387752625464987662932298177e-03), SC_(9.9996223238179432206582851700443636716762908465484153080036032588230765256495311772422026457237969056e-01), SC_(9.9999999999999999999999998984244603406188929898624368761470292036644296838334171279067706520789226734e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(8.6910189286625615131318845742683871350998231704142395039633347522734180865272087666989081473865410296e-03), SC_(9.9996223238179432206582851700730291621473345370599992861644902434304604942485419019276230330485126325e-01), SC_(9.9999999999999999999999987599339927582321357366194967756715617631118777222914048280260493063905096330e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(8.6910189286625615131318835764005570194548132114859235708110062997682672478338827936714821045552322372e-03), SC_(9.9996223238179432206582851701597573196616603003123138644733168873891953305888203999410832405747328841e-01), SC_(9.9999999999999999999999953154026423951694964896082960273143436420047042780804143873953807775296895400e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(8.6910189286625615131318827228093339085163416644837865247995446667856775400111646582252095514535238598e-03), SC_(9.9996223238179432206582851702339458963614742614642530908485340602416201542354834078908274494424042976e-01), SC_(9.9999999999999999999999923688984665268777301309704320217896475734946874093739310061942464032936646090e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(8.6910189286625615131318691295507725438334759516834294777388127053793711671946128562755907503419954811e-03), SC_(9.9996223238179432206582851714153831910244018225076380785938761340783361680724448504975364622225327167e-01), SC_(9.9999999999999999999999454464465594587785161083774790412826307782562959352837357039243175648852918347e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(8.6910189286625615131318443339897766074082193640679399860469424053679643662371275019083375654867686887e-03), SC_(9.9996223238179432206582851735704514824457452604986400314705677212519711580427885862514535137583505733e-01), SC_(9.9999999999999999999998598548635634979389407165889631216353141877236154417796922768065026100466956188e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(8.6910189286625615131317706205299475220440611214471766169076711595033083387576386574254252860168722029e-03), SC_(9.9996223238179432206582851799771441946879447862317222636807155423274956917482126904504401504330847308e-01), SC_(9.9999999999999999999996054040077867496192835446042161060543203440703697860873332445527832699242661002e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(8.6910189286625615131309762371310615867479211255498002605844592040800415010626837342358696830415937399e-03), SC_(9.9996223238179432206582852490197633332971481960345888955079801020320000927573341215616768639650920524e-01), SC_(9.9999999999999999999968632788093489394344244379388261094750687947650479338043207239877573254890300951e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(8.6910189286625615131294030880121884387298357710755086746208786488844968025122592637579227998518708235e-03), SC_(9.9996223238179432206582853857476149159473994952656810255904206154553991489209596981080441123719817850e-01), SC_(9.9999999999999999999914329389434705144483796756765541854764822141651352980427843314674631022024581269e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(8.6910189286625615131233077164574021593452076357720085643458124584699570987753363797820471721727787831e-03), SC_(9.9996223238179432206582859155175186621979639039618712990534850417887805227421660027752397420620009916e-01), SC_(9.9999999999999999999703923784815310331947206443554026009775790065863043418232145248045611644903452940e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(8.6910189286625615130737538492705523802760080837595003197356272576015239760079178322308313300253024583e-03), SC_(9.9996223238179432206582902224161570590437681856766035410835108364474809639393939563708802265259806887e-01), SC_(9.9999999999999999997993378120295291458214587466587187187013214874569039924018965870313768738004056284e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(8.6910189286625615127459470988230582268580554671474040205657989392795429209422189694493592037998815815e-03), SC_(9.9996223238179432206583187132389184008227036614519238222464812499748644725916735466029626210763530668e-01), SC_(9.9999999999999999986677845193994059434696078473628247784660489838948747289809241523221846935329305796e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(8.6910189286625615116424519084263984386264757436929158573634457789417101931248201212361764081869444787e-03), SC_(9.9996223238179432206584146218370319716927466793451952799753389154041162282439069715905444932510802598e-01), SC_(9.9999999999999999948586389957325664383957586182394235238887395074939552676984361802939964757447555121e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(8.6910189286625615069346735867262657245452110527338409601470812675312430820224744582208048996472590313e-03), SC_(9.9996223238179432206588237911954425127969427654084606847267739827525154593418435129094488452427291127e-01), SC_(9.9999999999999999786078996390219748787256385140451378600609409173707601812243251218072922324488358521e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(8.6910189286625614891208809114650790319689725445811315119541784934518457653057752144159063131865384539e-03), SC_(9.9996223238179432206603720497628006230884389418080702813186363585859782201423512531413766603188239811e-01), SC_(9.9999999999999999171166224508457710432062821503285117745586451598898248300422756428655402045232807469e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(8.6910189286625614168133393887448690020371234518380491332032523099829734345735990469389124366232661272e-03), SC_(9.9996223238179432206666565492339674186727545624219523895879691131337014119120965956481824907858647484e-01), SC_(9.9999999999999996675188439416178211671116673627117170787599699243512545593252181222459031716920044524e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(8.6910189286625613797855479155481864236197979334807728730121523833753112002878397037963450463688838435e-03), SC_(9.9996223238179432206698747631440429041881307483156495634329758522042581364249872331269273789839732636e-01), SC_(9.9999999999999995397029301353266691055100154555910694799610720091728690571868073635090394290851556741e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(8.6910189286625603275956624847635586286581566434549006067542331208891545934478429201411875983295597244e-03), SC_(9.9996223238179432207613242390811976126058637255031779800433402568673955975611477415679466200683724505e-01), SC_(9.9999999999999959076577458735705497458534051721248125220862613660992374088102706786502446579633313709e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(8.6910189286625553305755464849744957645764927583387379485070143677656993064307336468186661915050257654e-03), SC_(9.9996223238179432211956326060244012268745939676207038364961106396539558050207157032757980572873963213e-01), SC_(9.9999999999999786584871358125588561160074686817588425266823007129047824082550775366412804535178975203e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(8.6910189286625365182299798436724310535303914152218303155373222473361554386348316490919157125424061459e-03), SC_(9.9996223238179432228306788719497261588259101665236379622038146388123338388174878378971157903976150305e-01), SC_(9.9999999999999137203138402071510693297107715691410087312466821018823209790379031158868317457902383286e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(8.6910189286624639355530455080506225392715290641923190432485049483753484066549378508209347813431744602e-03), SC_(9.9996223238179432291390913169554925022946963720035073613868370359535506673493601408894964670258340535e-01), SC_(9.9999999999996631727977782676417868378185586082993079853697168602316638021811687365708385208506740258e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(8.6910189286624359992157539111544091700130612247636683726100356957871526528944027075392472442538189545e-03), SC_(9.9996223238179432315671353803843397041401094686049131690160953714687199742980083717387181391453713568e-01), SC_(9.9999999999995667395961947776436292734456558443969391993788615328418216864771510280532715647152623566e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(8.6910189286616622498643538909823801626589405977825669384369961740402239042927209244119768810875088751e-03), SC_(9.9996223238179432988163778146728056407350384739500334415312865515105007899294394951655719721501743719e-01), SC_(9.9999999999968958408881850040565443909175319044793846510590104834642827986976299666276509890707610147e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(8.6910189286572903697201148410982181151791067771486718458381388402348904709741151833227966515327436009e-03), SC_(9.9996223238179436787916594501582402556148120655383544583147154434223650485272404801979129589436150375e-01), SC_(9.9999999999818045855511792719061853153241340743712745370565789556178053837056135760973698091036324750e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(8.6910189286414259151867070931864360818131283833511842139233092332652094854377014966107024457447899799e-03), SC_(9.9996223238179450576264811827125528344597324310907511325131541007026893299703323359833044148730577904e-01), SC_(9.9999999999270422118705223908980806355589563045559935634630971320605888074847408673210925813705833707e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(8.6910189286186787388573248345808333265713449085739742325322988905156149682638956316586842703378445293e-03), SC_(9.9996223238179470346625496415912383808065512708550272469968023095760567556596952759789432346759805694e-01), SC_(9.9999999998485214302259272521630080698800635647001556555488693042991920048462152278276234566438693241e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(8.6910189285265110459180254769936332708386129470427532527119106639577961138590493924204779601533275605e-03), SC_(9.9996223238179550452767308427477899581411224539953637133715896853578315830785957154907142060069819480e-01), SC_(9.9999999995303685664524298788123065470534205945266437644063528136842577466298979746097877248933975772e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(8.6910189282411959455026674986815067600418060066180315311048115107833922911963228376385172382952965224e-03), SC_(9.9996223238179798430026645242805445366249278345036069899309049270424994334753104042939288114462641787e-01), SC_(9.9999999985454918338432807536748583562055706874741584694714433083224501827199232403011563972387052484e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(8.6910189252879206485825216315817715969152686478412879254388741498626383224457340513564200111691307981e-03), SC_(9.9996223238182365224118492394773475840361233450169855894306387011810475431376254551224620004884741565e-01), SC_(9.9999999883511063264694559387963723173897282543175692986022475106586730112502951593777433019446651828e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(8.6910189203982514596805592910711077688968761076536563115986065578430828470304693266885291252302690114e-03), SC_(9.9996223238186615005367326819351842888684927287838491995804623023661637892636107334822020511835284775e-01), SC_(9.9999999714724994596526287605585017988521115368615934701353384249003975411653488968977910396109025319e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(8.6910188306311389285804505579486882984258534953491448697472090282999013679606445475797463864643583679e-03), SC_(9.9996223238264634718926869290220575115269386801405938550293013550274467935637717648042744624008059440e-01), SC_(9.9999996616061792349840092442398390233963722003813970601617204160065453274313296267130979662117600534e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(8.6910186413751022677491712940356999687931157794000735835339309127798808408198361984311689090019262670e-03), SC_(9.9996223238429123707336004944497632756961387556116102131143743282295961702594404977114461867222489422e-01), SC_(9.9999990083149055128108477427499768036470209141146863344906580747823125553790925146919416010799027368e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.6910175559147963365478381441657872849358450446468701385293448462958949194161818107452328429925864311e-03), SC_(9.9996223239372534854142078196248459702818203071730855035799586600902916656123321007658554627089518221e-01), SC_(9.9999952614239870280465343867739413354043788673937040457009250746521614982644945644706659821813324432e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.6910128966197908661160257711343981644859485519304106351417945409047254780834142121923298361247754882e-03), SC_(9.9996223243422088179617136124628118099768210729140985584059017502943452647527211256230105620309655879e-01), SC_(9.9999791780465120891365104939308345132868078401502702705775979579247784644821682943289518384809928926e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.6909926731209996366392322834006361836311329624733696453059914511288299939074309534213608308411566575e-03), SC_(9.9996223260999000446702483326848698279204899286047542184398304790540882008437315753205675338882327550e-01), SC_(9.9999093687774547943702055510865612279624570283833789429033263808087317080475760779047317126334088093e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.6909570851504547898253217502559022792923156049766357449641093472270183171786584257972102089843860004e-03), SC_(9.9996223291929584409815335868368294079459193551204785031998588050949243462706684850731617703751206846e-01), SC_(9.9997865232181650440608750816621679636389306786120835780656069052627334323849703122094430126876967918e-01) }},
      {{ SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.6907189886200367752688979790497355412545807211450345874557141668364473911075614840477003375635549736e-03), SC_(9.9996223498863237776423337493248307203162603688300722808997953553827897151001214194398019764856998953e-01), SC_(9.9989646467031748905006320310363555009585697531863464632472299438741313369848639696844867267750716337e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(2.9928893319493426255247731858288905196315747638296340454600397352610939452818097282002983157449782830e-02), SC_(9.9955203033392432890623267156670467825011285955746521911431757142184169444090939509041660563764011944e-01), SC_(9.9999999999999999999999999877996415620448635739865936966350408746581405472516664982778525986437265371e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(2.9928893319493426255247731851400926952705412801801256631953868438245379346804948012101825697820645133e-02), SC_(9.9955203033392432890623267156691092020629310582961626040246253055870362524039788016707321039328022795e-01), SC_(9.9999999999999999999999999808940607351296186314756022740378346424324326281040378958331272751082384612e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(2.9928893319493426255247731655717598361758234641589629913875509445575864512969985871213622288960030859e-02), SC_(9.9955203033392432890623267157277013042053808429026708289949007618886513471102614421956372876237387916e-01), SC_(9.9999999999999999999999997847106533153766756606943673170004428638186668485258080894587831595414391414e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(2.9928893319493426255247731074116545973341594802576974525215828474641978523759578123729831398262585756e-02), SC_(9.9955203033392432890623267159018460742942666755486039569630192193819729762973538865004324770895478301e-01), SC_(9.9999999999999999999999992016232894705631572137795688414168037129708839982258282969665322630078928534e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(2.9928893319493426255247730668966901474021930335653108844605926761072952899566463672243880895966009783e-02), SC_(9.9955203033392432890623267160231572228955050772079793889087816123836957894288463132955225202348944946e-01), SC_(9.9999999999999999999999987954382641793732911429698115515198120341718694122830398475869328220599096997e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(2.9928893319493426255247717202276452316932325581899785545497317581385904763060884449412193563668627770e-02), SC_(9.9955203033392432890623267200553949612833438654894897139930129152683032018431323620733937412313269537e-01), SC_(9.9999999999999999999999852943329937076803559846567509142507541207489652924442440835430548326589099129e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(2.9928893319493426255247676458468086262538334531544187108030524190824774578186662708274042389647573142e-02), SC_(9.9955203033392432890623267322550309683269211452104751144314481017741731868417518777044222251195388607e-01), SC_(9.9999999999999999999999444464017260474230975464379353078796984202500767259040878239958569572944606288e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(2.9928893319493426255247641605598630247008461060837594958882589435101876935170123279235987054295644218e-02), SC_(9.9955203033392432890623267426907839873953181640061750416360751104180224982952519513088724621033184104e-01), SC_(9.9999999999999999999999095044639663415052685182723173837872786422692085884380524025169253338977320792e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(2.9928893319493426255247086581070151074506645794063325148339898697242797979673456836778926243072411104e-02), SC_(9.9955203033392432890623269088779298131699072128020084616095241507562253727082051066132874198404715350e-01), SC_(9.9999999999999999999993530615417069786918941333027540439961281630455497153968266438140283692532875946e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(2.9928893319493426255246074156824116241684265890004833560304349728755117353269444216226898977874477105e-02), SC_(9.9955203033392432890623272120211012949224778468140223939600179240050437192913437443719341760262596896e-01), SC_(9.9999999999999999999983380499933462027024640067389900073182216358559810289893705127953151139627149388e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(2.9928893319493426255243064372371071958047477749070687243860677592943261738448549507200212914003005887e-02), SC_(9.9955203033392432890623281132199891581086797285990242858535738904821060931997392041243270991819361235e-01), SC_(9.9999999999999999999953205738810528959681933756856065695203454463800502730852725179336998638758045357e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.9928893319493426255210629009694200706027766468021901267011554011238823035393988391906047631624909515e-02), SC_(9.9955203033392432890623378251157171959438247309118399252350774260334032449596663026964605946938832511e-01), SC_(9.9999999999999999999628023209636274959807731533932147019382525489471364383404772497292994508002995937e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.9928893319493426255146395967705897870580506425025761684719391438657385047943132394052838562672953056e-02), SC_(9.9955203033392432890623570579700650804224268743294462028433293237764615499007160110566038793966591323e-01), SC_(9.9999999999999999998984051281269134074506922309220976779650109422628308607216041183469403976814682321e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.9928893319493426254897516664202016460368173855534260393521885235552536311709240273701194314451986955e-02), SC_(9.9955203033392432890624315781740959709634550932948354885580475436083520881098479076922272247015580279e-01), SC_(9.9999999999999999996488898007394114213735784420078816591377588207232238242897498049367039894201724688e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.9928893319493426252874189318110570025930175174875834671392258288824030135008217770995154195763551528e-02), SC_(9.9955203033392432890630374090508673831318822355196077580860293644667961480496432176193390018137082383e-01), SC_(9.9999999999999999976203917373630031015078377837713466942378279033462838688190069739540812525716850149e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.9928893319493426239489555583817471163830177095650457263367924167007051477342709916004277401651275835e-02), SC_(9.9955203033392432890670450771161338334474734100674777504794023225486147804579870699475340706919114900e-01), SC_(9.9999999999999999842015528819181114662849173680705190910437045874830265778653825604720745759442800535e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.9928893319493426194432890549156883962087571950993458842780612890671631275676828272958860523880151162e-02), SC_(9.9955203033392432890805360818885818351790010628996395211505529692215376086937551149139530290265507936e-01), SC_(9.9999999999999999390297432182149196597693940097175959361343436504111665684565786687507723063353876798e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.9928893319493426002210221393677857816016062981896969986642150610794217071898587097541637274517362521e-02), SC_(9.9955203033392432891380919827737081424281108539236325246436992489841727658961362513017179278364870417e-01), SC_(9.9999999999999997463158391274280885189723263543693342692564788731612812195606464372636977460876345112e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.9928893319493425274857627063273883710976884733769519928236883999876175624700338836580413381672191117e-02), SC_(9.9955203033392432893558781263734468174863373481316336901076461802285535144096955154245756906370852401e-01), SC_(9.9999999999999990171044577653402662086561484530600067793084852167875567968856742382356142244563447126e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.9928893319493422322478036991906347423289704416881206752457506421650446369307515908923863543737554469e-02), SC_(9.9955203033392432902398886741823129756954639772771639936267739923803118789533716963685027450129039338e-01), SC_(9.9999999999999960571799095300649558414135197671484083085875351249636324569432418256561497218683802667e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.9928893319493420810601218769088792055000915890155144771980052383817993413442295356018664569763381999e-02), SC_(9.9955203033392432906925794659732056171004790789206331632926551899706506803490537722005736402428924569e-01), SC_(9.9999999999999945414394121987634937279635969496138069457560427392351623755238033145455702298891140868e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.9928893319493377848776252706924813272104343838970284436640740334152512829879920219487458256057343573e-02), SC_(9.9955203033392433035563408030440767420134149250828121525577099766693641872227700488341876073203182539e-01), SC_(9.9999999999999514698232888260348569000312947417841767122390969117671490904792128202435480649589773701e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.9928893319493173816113947100396169349666623792714688473692512820028134588800567189780910753318263097e-02), SC_(9.9955203033392433646484260424355806409963772152059817884065607876624800704695506156225874149905227149e-01), SC_(9.9999999999997469157450019065762266491499742313013660433979105969700483469920728143158430886721980774e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.9928893319492405691739605472925545070308291627541601424959136306159897603060941493948269704939494002e-02), SC_(9.9955203033392435946425810049606272603198350789240019237237263941187840395013251099126389877919508069e-01), SC_(9.9999999999989768283892440154779543352702088120475495484520987803722565462362792132301485197109363561e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.9928893319489442078132215259439864073220418980662066128808852221423621120875513308123183990613895309e-02), SC_(9.9955203033392444820168527188779673840940773710513169593049660055151696904619596325760656715084119277e-01), SC_(9.9999999999960056411145799021031659330176000860491309129472490216726603948074556894330265440198641267e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.9928893319488301413267885205036702633337966159911666362408385135126404116959624613027880348923932194e-02), SC_(9.9955203033392448235582232708295602186899985554861190692535759820234762543266688997212425445757922636e-01), SC_(9.9999999999948620612224163176351655291162500486164573885085682627228114480130223294695253842940059144e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.9928893319456708556633619660197891096304672046134237268602280658288004031761612391067712226586895448e-02), SC_(9.9955203033392542831882092000464874338370577012222645338498014443565238638447730428880788140263240572e-01), SC_(9.9999999999631884674152075304392631626757970092124143372783840091678836679275554788351456670400127300e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.9928893319278200901190734544054236049018212805391910237080068829566474537216511063822155093400902902e-02), SC_(9.9955203033393077324976429039546475024854008232932364713134547876989098440046229476264554469401910325e-01), SC_(9.9999999997842246264615254944421182153261571784484715493817643115748041513999484865441496954275767219e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.9928893318630441472710257684895808829877336550585352215160944948745592337714322730617489396361844454e-02), SC_(9.9955203033395016866115159166531171950061839146491334035581358664254450201698565172906207314887456417e-01), SC_(9.9999999991348098153904207338577310518714231490203039345087019637926134537450869117118310893487004657e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.9928893317701654547989725899123657249326365114763656328690312674210014818134123781232668668482665528e-02), SC_(9.9955203033397797868398350044297446940094575362625188052694016706354179470520643444796257179814710393e-01), SC_(9.9999999982036493278445218952873159715067111860267542703755418980787104518628176474330284497444235282e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.9928893313938367762832802196521223139996341142688443540103796030109357639233974931897402186601075726e-02), SC_(9.9955203033409066017058120896694785726355094823183859926336927200831239196737675168908474261072910954e-01), SC_(9.9999999944307452695900984134811133277012656853345044392327099641979379946597934784739018233271442362e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.9928893302288704929735991050166908873215429922444380448896304428089570114985146029421173973144477603e-02), SC_(9.9955203033443947794637088200105156402014250600567650413745952439080930128340050194819604649307068154e-01), SC_(9.9999999827513111246526453850235072104966849540419896871086753799245357396231787466708609290525619018e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.9928893181703915093266226036212949915928865784268926859825767362649090147971582789467985293876976918e-02), SC_(9.9955203033805006468132076186650868209306390687245490563621726135554419151164124810004455558943695637e-01), SC_(9.9999998618583607699995562541284071855894183775540316895772854576720101990885981250478493415267284164e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.9928892982054485052386426662488491901973910690181407978176174216690158250981871979766128677088907246e-02), SC_(9.9955203034402802907354243890063976250509551280117037552506262005868998330758337466060101471700562948e-01), SC_(9.9999996616987169601941569531949031848963939953929882317547983007702815075368482670917146042259644801e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.9928889316785624043364632203105810771971898788541546730880945494729527303520886222734117327210276156e-02), SC_(9.9955203045377462498683348959335789301880060727806002672812749760676444568350625820260041086960621104e-01), SC_(9.9999959870631792400114498613316200707570432178574663870494430063087760754618921405686655752317608886e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.9928881589298730722855360318305730331845330028604951736626899063087234886963715215775799725608354990e-02), SC_(9.9955203068515334565064168535269071463668515860787680194308949107676389719393597331813390980318374887e-01), SC_(9.9999882398291105864492372802479487573670567283564794839842343498249921144431559941164490735081886201e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9928837269041179038269118264389453566192997515582603133819187831090463651083117512389321825738789696e-02), SC_(9.9955203201220258023547272155010615914746868359649021081926230913632308077152144878030444302163095286e-01), SC_(9.9999438063290096123056008534702571332494238559018107620820080126088388693972971610737520221753747151e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9928647026514757750260096350528905822148444043658540695930217727741067034628713739322705458846031724e-02), SC_(9.9955203770847382998598486307857571893875732756503542276613183052919919705359995577624749448910795686e-01), SC_(9.9997530780138697531345378649773901808159672082367352339942210160865768974789387898550172504062003625e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9927821293503493906981635537409489284232776059121163668324989798862228548270192967809097523519792495e-02), SC_(9.9955206243227977187142475417047446690813294912847999227878665452024480269387544994545098067757375899e-01), SC_(9.9989252421020861691844877517069965168475711644767914803800769497974529495609692479625458945557620076e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9926368253704020448544727770280339353076125932355996010290857353846237006191819415614157271680554530e-02), SC_(9.9955210593702602442099361613099970218601289464661311688781431112431563351221766936992077017624655316e-01), SC_(9.9974685240486099968392521473326258959379322660955821867063416895641450127968071718129444640368985100e-01) }},
      {{ SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(2.9916647881498095894704323639021926156094895317811812491107959631272131859755054100439359561717934022e-02), SC_(9.9955239691550660374421268887408231509665209686732570675003787443882925292679338025418330398115990457e-01), SC_(9.9877242742188721598830505718937302026641387834722334458442185199760923808019116845880905504320009844e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(5.1220182284943163616793098920542574601424633729567878776500653124724415215896568827574287718584502278e-02), SC_(9.9868738498425882265366942993762580591034814900633753606941987849403600003458742025840898126644217610e-01), SC_(9.9999999999999999999999999642666681086499392624413833595338859051030686157715872350759604626584049295e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(5.1220182284943163616793098886028778925270101800643261573675947614676279691394336011749301584788635451e-02), SC_(9.9868738498425882265366942993939593231071895391793162368583514361775096787871023979604119224966912394e-01), SC_(9.9999999999999999999999999440410810617119468250139759130203208502496290682711839814282926368824943785e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(5.1220182284943163616793097905512554664119223025915408432850295402582612675117267452825987859074172766e-02), SC_(9.9868738498425882265366942998968416113498907763359515528637070987679789744673794563360244150525730375e-01), SC_(9.9999999999999999999999993694442899463722227096309815206459910608316421877058811262864837430090998114e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(5.1220182284943163616793094991267013050901608089656507802960573072547936533843543899428323855904355662e-02), SC_(9.9868738498425882265366943013914853818513542477319695864172183971070345846327816044372323141981144771e-01), SC_(9.9999999999999999999999976616539492052595766697548099051064843733822871209090568611945945788543060331e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(5.1220182284943163616793092961171743588081542075278911767157319131097521992871040540085926192897466022e-02), SC_(9.9868738498425882265366943024326705547202936364514978761008675469727165450847978950234635695784336381e-01), SC_(9.9999999999999999999999964719885478288054864693004262460237060223947411175222561501698976755672193402e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(5.1220182284943163616793025483228846862042703491860617255139100316150388688543912402136658796010267805e-02), SC_(9.9868738498425882265366943370404225635010004538360240138549908486521957898654412531039907324418771359e-01), SC_(9.9999999999999999999999569289310234729316784616266351067604465017459210143262000828499348748340452950e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(5.1220182284943163616792821327026942640472458473419106488144463792104740707951755331908132512928681891e-02), SC_(9.9868738498425882265366944417470408042101287018052354533857373965792109340906397947751344618512457331e-01), SC_(9.9999999999999999999998372904226562544999878819315968972302928108111914720059841585668613684699736995e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(5.1220182284943163616792646688726328307462052911013287560336761842576572740789679540254409466866851236e-02), SC_(9.9868738498425882265366945313146645260200167103412352194196439350856874566677575263675458920725752370e-01), SC_(9.9999999999999999999997349498344477870027154674650906796132518038689904695914956510509046527563732202e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(5.1220182284943163616789865610956671539526995951660510801257735954991778462047993448559913649046153729e-02), SC_(9.9868738498425882265366959576600099482821054584778915256767663334251681858544658108677577375831841106e-01), SC_(9.9999999999999999999981051977479985029365602687269077105438632245655427556320415150967947332036876269e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(5.1220182284943163616784792626935903806360216082211923397094081062810837257328542671334139954654671564e-02), SC_(9.9868738498425882265366985594668433891865248477128496460705236818177300846950065328517225994017957362e-01), SC_(9.9999999999999999999951323552109879445366885018832863123772050090929262735581697315016556664541786777e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(5.1220182284943163616769711411234039351719906149244999365715503719180962306385807870032314003156450706e-02), SC_(9.9868738498425882265367062942458036763425703658687097021936016623492069307625339017373611765173466052e-01), SC_(9.9999999999999999999862945431136517670416811014747536781172682372937909000630589634413001906836343358e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.1220182284943163616607186583117751043936004776684428799858159240483471716437133085604189638114346736e-02), SC_(9.9868738498425882265367896491719508265185625695196458781593800460250266873878411046272653997823586972e-01), SC_(9.9999999999999999998910526262523975721945185660846712744650643095856758845974569645974853090882427922e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.1220182284943163616285332185726371253901968415486669557419351231952137809434617258013346937404035930e-02), SC_(9.9868738498425882265369547202557700824272946545975563019010971408792301014291067775644064738748244002e-01), SC_(9.9999999999999999997024412607578556155180813715117758491794451051969023059655843488396312666575227028e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(5.1220182284943163615038265321494482402813851037106900585699220382826330527539629441895707430630806839e-02), SC_(9.9868738498425882265375943097115683711359905630236145817579023854960450532620381434021631411120998523e-01), SC_(9.9999999999999999989716419116355472940392459451501322621948022851864325537775205269293528937558617403e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(5.1220182284943163604899919330962815971558897904549517726330318903772185379147183663322056110864080090e-02), SC_(9.9868738498425882265427940142188105404036661262920981989898127885363883728365088423866097607213469084e-01), SC_(9.9999999999999999930304234705371045133325260182194106715075421206726619138172309492781935770808811898e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(5.1220182284943163537833140434834405247752471919515284286717386820807302907671939344192875550010090881e-02), SC_(9.9868738498425882265771908904783201283291846445918835907810823517985088765928291519144825152403589127e-01), SC_(9.9999999999999999537283140401748482414235841054039782083722249432160865032920225878782283487491106013e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.1220182284943163312066380457364142900414878934044351776839207480601170128350721446300135112921700443e-02), SC_(9.9868738498425882266929810243459798747702872898191536689636741667921482937690656122871916730541702317e-01), SC_(9.9999999999999998214257038296062388869811858200096930943100542188606308533212371989017383057078842832e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.1220182284943162348890584466483086594139417864955606249629717656260956265950846142336252123681985203e-02), SC_(9.9868738498425882271869698399138840620157151897462205459236401409230684899638425883137125565824753173e-01), SC_(9.9999999999999992569906562878323266257837628700203729220574121275946989655741154771144943169688793652e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.1220182284943158704323494184506546544658596749596307701905179444119378296230140135397799285128441916e-02), SC_(9.9868738498425882290561772968288433686788766538233007291438630865831095770081765516858200027851018486e-01), SC_(9.9999999999999971212212490466562137983191157784894900658242428533508558243486980889290927858084259179e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(5.1220182284943143910748031791308878259830912760398956851741337885955750368061427580048808449022363320e-02), SC_(9.9868738498425882366434327605772413160041433821585005520395687604849807276622572953698252325623991562e-01), SC_(9.9999999999999884519705222480997352166131344006951878141003715591172628371454875037934803727548611850e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.1220182284943136335142281284979019453824187335798013168035739187200463202410111137115550509797249450e-02), SC_(9.9868738498425882405287717895258614991374456471460625139453280779725155509516746336260213198829622105e-01), SC_(9.9999999999999840125551945966788205039837470385892355818841486054944115319723665969452187346222517855e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.1220182284942921065059201553077440076147968317870681487235604953617488148417410226923149465658581843e-02), SC_(9.9868738498425883509354221750465613661922768987705596691320032690093529342429350088694250270225247324e-01), SC_(9.9999999999998578611505567455678836672172267811949314733451575112534883712610565493707709188615621530e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(5.1220182284941898712582317644549878066459378079372259114218786964253696147522269051587839585925123473e-02), SC_(9.9868738498425888752744797499205601475527286840254349549862740150193054699820579011047501534506525447e-01), SC_(9.9999999999992587477059536597362358622041744656336594824144770266010416207660113873301403110235296076e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.1220182284938049849131784352232427320179118130204784476852093767264060901247547991718256035178369751e-02), SC_(9.9868738498425908492604386219807712735555312249075984008853895059090047438383776237774131940525229898e-01), SC_(9.9999999999970032576555121635757918128722250725944357908788990721303091648802316394157983707156114977e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.1220182284923199983047579900291301754431612354934975954303737526815609290658495543991985328331960966e-02), SC_(9.9868738498425984653859567364322259478161540757973413359661489054582592692660914712918917120770539080e-01), SC_(9.9999999999883010198043178140238088169716774283162101172694349637200428116627085027936810325683865220e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.1220182284917484419979567936086130868440515659212002802692327668440767320335742410863121249614634806e-02), SC_(9.9868738498426013967555385114673408744436307164957726314339738958277749210751931602840480218932312703e-01), SC_(9.9999999999849516165848339784539203251808270122125458687865145915762832098272699805423884178870396575e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(5.1220182284759181161732242098694411856967719028965863671178331268287920667516233524297913634688358304e-02), SC_(9.9868738498426825865439109722368638775026947094620450465387398589391084457156541224504821911417907486e-01), SC_(9.9999999998921836011647085476102043530329668872431940586942396440649772848081617104696806362277808755e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.1220182283864727589340284529910514846775404056252428097144615349519703073962285094082338763544430782e-02), SC_(9.9868738498431413294469615671486896983493932750238216738297672414801228560621209824046700396011271225e-01), SC_(9.9999999993680207777674669378916934524342032755746392040169065635871380806709312580560065949487744625e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.1220182280618980322040988112094550465206515222130185736059348106549178667713122183539287400911116072e-02), SC_(9.9868738498448059921749858692630198221006913033858807697179830941475989955434198680633532655631275548e-01), SC_(9.9999999974659655966536667181615544433605642340174099478668412810443569406153761335944616334683983005e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(5.1220182275965080293452455277721244536693487593294550314118975737360052819238696107044774297150950665e-02), SC_(9.9868738498471928612929223988690235303349408205639118987956076603088775749104896262915324001697385029e-01), SC_(9.9999999947387123842204384900213708958264240796407301217448278586822420670668679764861099536325772535e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.1220182257108268241838336594002859938907775162928663517097680473844182083631909501722983430060808748e-02), SC_(9.9868738498568640493420616310685210736043457497845148416867827755970243963686585546365388985161452755e-01), SC_(9.9999999836883458264170875674096471041634058175038072186708199294270859383249739319457109913488954426e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.1220182198734959221157684459363867619055254851231485939363305788840246199636636698863668925850895163e-02), SC_(9.9868738498868022619422379557089152444909410639616007386273380502493990082280081716627017601126745018e-01), SC_(9.9999999494807364007315404206627316783547236156022454304738961582977527009579123592757127376877962867e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.1220181594517199162111924809116656584473233325206510714779209652371916513266950607715103443700887247e-02), SC_(9.9868738501966904615940932620354170093160986814812700382249113345939700022071171693465994844079132530e-01), SC_(9.9999995954003281244459679426770051684411410629043192506784553101608142627485055693901672031233020607e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(5.1220180594127922548796762326280800878028888504224171789906421467376408188887764028430271431856485070e-02), SC_(9.9868738507097651302065034512663928613367289363132232592476683982260182334497878567488179360596235473e-01), SC_(9.9999990091576443015001729874323532057825508337798517603693954408090465512151467597826217329671378083e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.1220162228458700420721442889738773591692395875963623098743503203589825511931760611277447282076453056e-02), SC_(9.9868738601290562843652579488640955586200752818649762285648406555386486095370022792480350847435028078e-01), SC_(9.9999882466088551809391022065862138161177971886108584036408556925312179997525010188176904548011935964e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.1220123508123970200825872919878400335466813760955963582427656761619728891346929874566061119219882088e-02), SC_(9.9868738799877338104320751394539888592190700102182842773115520925200396017775473460705232787654442816e-01), SC_(9.9999655559356554021240407140950008886019950453085539309374934226174191119837638228952791983003849658e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1219901431591527872361358929969096650680075027414463353164713280818907441647195066893217361627107973e-02), SC_(9.9868739938848635107424887475554260611754439933031261408945556221028855619240998549167557487303094564e-01), SC_(9.9998354160257927227636274903813901700712942802222032889019275258824256709645420782660040629460285925e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1218948183285674182749082935046423712265700194380943925696650889314129123268961188008606992991124532e-02), SC_(9.9868744827748681240018203124125260342920879848177396847508655111089111650153677008837793412684130134e-01), SC_(9.9992768019493903528483793917364313081411321472807333950340787276242601285744005565332324113025568665e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1214810763209344116637693123912562590043568077900434368143128736134922208880499186647766807823307230e-02), SC_(9.9868766046171245177196676003156582582195076219117359204104679021239714065695407527887460378597344234e-01), SC_(9.9968522762944795917197407923921054571801360692218589154030052050945391772938973164546030760803996615e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1207530476407959527026716792074219414362468463785026712205537168751433251170894668179838339685798697e-02), SC_(9.9868803378357735783522899566244881474723841124284334406748814826618983948057826596988673283714046901e-01), SC_(9.9925862236102063916068016531174810578663167094242063803561892174116448489984844824259234045579601030e-01) }},
      {{ SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(5.1158838126202303702002255451616253390259305838512824448236816896129550947530570385463957941069848715e-02), SC_(9.9869052928401049775188963886853070011659034917728663682718204496501990541132896143407072247621221121e-01), SC_(9.9640600767148190982447151229686775858840788433188891046173152093702292354977235119100403173920282098e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(1.1177886355444717243885671473829761146571437019346499202463429859070171863430898355983564936880586773e-01), SC_(9.9373310585009508459133300129992478045875327939194868125614924058086119664094847279575168055082785829e-01), SC_(9.9999999999999999999999998298191637494261970769797177791523947294864963393947143237271075087477579287e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(1.1177886355444717243885671438029824335556665475190761869173853927814817699485525570787719973428379361e-01), SC_(9.9373310585009508459133300134019390532234522209002302430282795860249986068418305583501114252549342689e-01), SC_(9.9999999999999999999999997334943282212876908368728411382468967196799341791082628436279791412317278832e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(1.1177886355444717243885670420975102215377450766921301799916046161445129642514318942665123380768599216e-01), SC_(9.9373310585009508459133300248421557816401810564136365640600338345588805696058383634182418951308667490e-01), SC_(9.9999999999999999999999969969635530831423793483906336810060534159568190745342398060247645952620251291e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(1.1177886355444717243885667398131505977255487793152780363125636641647311644753464865990305535766787652e-01), SC_(9.9373310585009508459133300588442454676112790864919156782464029190301700485216146882445334521758132965e-01), SC_(9.9999999999999999999999888635717604658892719851261877231616030298230967903977906467543949274148927969e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1177886355444717243885665292385645711835315654594976644029292166278114861892320122743461204642080415e-01), SC_(9.9373310585009508459133300825304724645064798086366049784886319254706395420168068829929569869812377701e-01), SC_(9.9999999999999999999999831977622165865400293837336343935098458128617168576801999133334695698434007511e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(1.1177886355444717243885595299907434772589157717736867502352159935639959409373303530498982004954627368e-01), SC_(9.9373310585009508459133308698323773442256614875442347627965124839942540694919016404778154167067961367e-01), SC_(9.9999999999999999999997948730177494067282723185504774225327902360475942467558445909191180922194704890e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1177886355444717243885383535916121654939662958434432317554723584482304510209537962193107508377139582e-01), SC_(9.9373310585009508459133332518339581897018419380068955424512237949981858129987396105871246514147825343e-01), SC_(9.9999999999999999999992250917988132269578658325572803425234861545240367197973177984387947021885898737e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1177886355444717243885202389797466973388094908455449190994472076058178536459491601918182915945184507e-01), SC_(9.9373310585009508459133352894341107173574449432541278410427543238765069771338127992726873337959933860e-01), SC_(9.9999999999999999999987376923327727095572699452940239458343183061996774361695736492972748282486969429e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1177886355444717243882317676410552606070087414641545746880587218032343382835533649651167762612362716e-01), SC_(9.9373310585009508459133677377828847824440541883481040268618271371271987904733153100195410107834722944e-01), SC_(9.9999999999999999999909759595675111771141150600215309152204694241534368691840345996710829427842311391e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(1.1177886355444717243877055649912776008878033798589755673685339444954539782510185716587353806925900158e-01), SC_(9.9373310585009508459134269270499477621688988158901041506867834948809389239264316312708025498263700947e-01), SC_(9.9999999999999999999768177268416062613609487464163631491343160212633349730320524786872113241649655416e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1177886355444717243861412439463655486931298595120397890460603033757024689495242919929014135945079213e-01), SC_(9.9373310585009508459136028878060151482258836297691367319147762170321466442294465376769740070871583872e-01), SC_(9.9999999999999999999347274382023263993517748380406771201592552500767197976671920665999178510445149452e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1177886355444717243692831196433232815418675074652642160149397138200572823390995782901877708096006100e-01), SC_(9.9373310585009508459154991534785184963842022621221825819991728576265562326586179738108957510150171282e-01), SC_(9.9999999999999999994811355619440867815498016026453389989673253834469535973920047386553558364073397636e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1177886355444717243358983039102933743682547098859144745782018430252162795796429254560994919447769104e-01), SC_(9.9373310585009508459192544039986472297886716266503936579981606441866962391418680083169743463569917814e-01), SC_(9.9999999999999999985828694835436642961892977572808327953837933190129536404935581747061328914408744901e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(1.1177886355444717242065444786819167020372706576570417157081637630334025099817406717542805992364412194e-01), SC_(9.9373310585009508459338046121937133103767397153202765845046272623477890034222491094847417886028230751e-01), SC_(9.9999999999999999951024203403414558794933380454002389157301241927448369620689542094275480727102377809e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1177886355444717231549297874586008414762396942694029685593243797183859886939811794207464655667423425e-01), SC_(9.9373310585009508460520942157000247031656074746659179617764652596395037436151390278787195638508686772e-01), SC_(9.9999999999999999668072273332148198679482876538747372419731910937290944587909868780957326757757408062e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(1.1177886355444717161983305506539112850177216380844057239709172128839667803920984893929850367411298141e-01), SC_(9.9373310585009508468345988462854769055208330813953963702793794285499723375229728110428292807559518715e-01), SC_(9.9999999999999997796300038487828189871013383343346169651130750559393627919899619256984623691385749618e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1177886355444716927803448354371339548993644505487436141139510463166539359397015206948176533205716692e-01), SC_(9.9373310585009508494687425761976814993340202144454904404313697679667823230370789669913378756696948104e-01), SC_(9.9999999999999991495357010776900598652803940306356564790242702476945755966195291406353180838264955643e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1177886355444715928735337796028951345970819387123935955547520089907810514931501089739526436642798249e-01), SC_(9.9373310585009508607066390852575746186540931185520096860934275790719324189734804081773477079120394710e-01), SC_(9.9999999999999964614004694721630455700014603071730391016170248729771157702443768068083282652894546560e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1177886355444712148355087537328846805809571133315599128911743321015736142910379924133997125536265503e-01), SC_(9.9373310585009509032297879760361275583719363524499903639320230759736842402705565970262302862820640747e-01), SC_(9.9999999999999862897482746014194308771364438263862966231027815714334040073506884474671614631279422815e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(1.1177886355444696803503662558881920564504646245728359651091241583822599729797786886743466809326123733e-01), SC_(9.9373310585009510758344887350617635268443529745746445595448256239559011053106686600699088738521172148e-01), SC_(9.9999999999999450022371396656309945870166969028211164067418790159993882555462980754500429937809072971e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1177886355444688945596357374771158643841652274874301369637161613818055963590195731205461579625600934e-01), SC_(9.9373310585009511642232063211864917151071633054737653069795384012828208297203959285833502758272258502e-01), SC_(9.9999999999999238594168949568880192881773242703942454506231733932746608052254650949468728409489320613e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1177886355444465653570065385078999354792835955645481797621689133128249911500684232988951377573757902e-01), SC_(9.9373310585009536758964909036115515688394614052557839152238272113379169977006874526476424829878006793e-01), SC_(9.9999999999993230603757999203113924802203512118938823348534016306339815730390609036401060685105746760e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(1.1177886355443405203586109719622702795480337069469759131901801158343155399051914477403961207330200199e-01), SC_(9.9373310585009656042395605938749610412817468649167272595641279163125694800466051967773485773327493573e-01), SC_(9.9999999999964697684599629257847961495538161430177408016925606756829241122375808181968498445896013888e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1177886355439412913963253331686501472347207111779790359381697427918959149925259598306425172690904958e-01), SC_(9.9373310585010105110253359571126415754208493180859338110917240110766222377344116057545369274360307103e-01), SC_(9.9999999999857279438770778924040178329519604178687593995289120668594308133692288072786114584307642350e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1177886355424009674271666351732065016697633195034451326787396657772971801679636952356758112576805572e-01), SC_(9.9373310585011837724994324077907613536634353945525464204210606201300493469372962067166366041937507248e-01), SC_(9.9999999999442833307839228127474113766670532732267874030267519155278341133380557918127436855652691353e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1177886355418081123306309387298343399078796458966922422307417500526335209180125653939852473113151717e-01), SC_(9.9373310585012504590861557012291024064815172334005890478610953088334744903880675357496293648132896989e-01), SC_(9.9999999999283317189229208616005980061620938884156848164841162372305972930310760934202294719023666613e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(1.1177886355253878765055629541995647429511889005121485599563057417001296210016283821737338766566914201e-01), SC_(9.9373310585030974694041161804744188754391793995695593530077708399963228426565769134127120068479658197e-01), SC_(9.9999999994865218566524353762158771361231676678148350793490292751817875394535363714799804588622386010e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1177886354326093780998360764178195556595915116625553191389319004324512573368124600115555402241536301e-01), SC_(9.9373310585135335463068711170049005982657792648858812246787242448187081491529617060706647269610200103e-01), SC_(9.9999999969901840428615598033630123752925930790737406043589756281957058610497809496061063701508172478e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1177886350959395196155712265091085269920583046238423253119251150505359349607800843493474406376459667e-01), SC_(9.9373310585514034471316624055163619836932071842786895210187000996615777105178043845540789324485040505e-01), SC_(9.9999999879316013661210969765437027602675286583024465686340312236758811092798878137770759856258938657e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(1.1177886346132069669160162093641788693008646994182446680342394554328311607047833571271237947569090266e-01), SC_(9.9373310586057030329964290875077385151767864294355379380222176981800351384683304121908082159425913084e-01), SC_(9.9999999749429935993993850663668373450450890891276037420554665410224145626929462650620210246891549171e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1177886326572566979003540398221899105506027810395915727394994015882558551898256291406675322847590482e-01), SC_(9.9373310588257157271235825190754582683141864118812724065669192620038223234617110890637634670385805896e-01), SC_(9.9999999223153622078657931099495853531031480224407053870569098616502023721821587238487925754464637836e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1177886266024002894115591876563081044474751546496168248692977073140363705133714328078038302110532404e-01), SC_(9.9373310595067889053394965851950099003245544680732498431710185094178850256909430607223244251842302072e-01), SC_(9.9999997594008158734525573288581211280961650111636341271145767225533741893140447982284180253760316524e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1177885639290349050454377687568330922379755100470190117601796895012140773764932797858733190060420940e-01), SC_(9.9373310665565261646910300344990163290558253532940844609286973588798302715170492933368867467347426921e-01), SC_(9.9999980730845645699033758701703391792985744353695452759955472729983613685882092742825558500358222700e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(1.1177884601622066852554511869250754141485720370354214649575544456757157054509089883390264872153270568e-01), SC_(9.9373310782286107184329153913392298122796755422529654101165715038343239715570137546695340345285215372e-01), SC_(9.9999952810901919706364189428845979441086828009396329481942542419165759115365959748030177742274702345e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1177865551573238866133048486075591631665399166547041166713472922959706703944856415086846313286237388e-01), SC_(9.9373312925105562732124110912053035351475060849298052569387419209006033366294656034513723092551321038e-01), SC_(9.9999440242381085261001180572852207057071006623807062356216291088918445487798200290420684001565592578e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.1177825388410067663399056802952056427479418533998889037736972049229324670918932091167291583061604916e-01), SC_(9.9373317442793542475351964731264463439894297359521475007803724563721059755961913198650204731264378903e-01), SC_(9.9998359596808620201551999894486933560987710666625845484311646730216090831861869266235611289792585720e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1177595037962689661183770305756459433397971414843670194038911424746422318064426254914981534690014851e-01), SC_(9.9373343353070856907837977162306529701670374512729823499633777194182551802445826712533628460647617410e-01), SC_(9.9992161729307946687113297407122444361332677565276836541813541043295251681757970248430771643872338916e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1176606299214234121243754070303782397758245616370159903888165484253385762478591314807028811884738366e-01), SC_(9.9373454562233895913661675916860126797015369704608803255038779390480280727293822154572500687477197018e-01), SC_(9.9965559065162939515996661830432378013552714747998758143339811959781981049832536047020819336995518537e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1172315304277228444894540977824224315048428740047703190495221155256844161379511004575981227679920371e-01), SC_(9.9373937079808872894002721005775677814487555804682178768714957069998193285948338901419025563531899391e-01), SC_(9.9850118145958128951247015036274721240557653890633673492626039617706792243641779829512373842232865787e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1164766621846254819434879315354889355589884171987659631005138728925398497672251245616673784383489950e-01), SC_(9.9374785465326705112909514804069553711799019433675617526558044675410894042468447737963941543260069309e-01), SC_(9.9647079298316476405478643161712672116171347821587448488171076886157190875158204029754262128075419375e-01) }},
      {{ SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.1114339425340482521813084626816879020275224816030214113103590000646236237272393901452922463430012807e-01), SC_(9.9380438010396805620012307284531367247346620188964906655341143561935030205174197330912585876713039503e-01), SC_(9.8292162953415785371670378063105205371799540429610282334861254085939296453406861068461655180109429325e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(2.3265216964765519779180868578651316855857921518564260421135004763718242552838061800624725899836705833e-01), SC_(9.7256000738167239606331680287466122523038520560330626967301599645024495964843666399794960250804735257e-01), SC_(9.9999999999999999999999992627657764203945327156926378779310252257702210555899777086822494891568615787e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(2.3265216964765519779180868258659139385255208455253731639340199353892218676599494968447402577544290615e-01), SC_(9.7256000738167239606331680364013455123357184575886130285353387686774916922822616343618278296053355721e-01), SC_(9.9999999999999999999999988454804527811357789073363638827609991653526626995381080255949456975420201424e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(2.3265216964765519779180859167873397052269134591816207199843240079028891647108005591920849037545141435e-01), SC_(9.7256000738167239606331682538677240085810232396930190473498466309944974339077497531017583404202926266e-01), SC_(9.9999999999999999999999869906548110728195087607419374108555613708869724823074756607301016025182133314e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(2.3265216964765519779180832148655189502429576736807229207442867721644514519566940734205119834668035530e-01), SC_(9.7256000738167239606331689002113624945283699637244829482009381869975489912557055300514642594146576185e-01), SC_(9.9999999999999999999999517562834481885423650776168696416333608658737882187326530593503617065296902973e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(2.3265216964765519779180813326772721298726542633714968156853782646158637068521110603633625732921077913e-01), SC_(9.7256000738167239606331693504613994942787568806403523868293742847436766900180053000011514355560324523e-01), SC_(9.9999999999999999999999272116355779573438616885114472391747311545578999877100614894900789366611648549e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(2.3265216964765519779180187709872124112825961132538210419689286106425597767803384584334913531960781536e-01), SC_(9.7256000738167239606331843162350471306559839697978297923049976686928157421103924158431768083146533528e-01), SC_(9.9999999999999999999991113768457919788379943964194455719262569243279278619088144656374910615612755578e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3265216964765519779178294890310797363804502123405176180591675938070194537635004787294964043024449022e-01), SC_(9.7256000738167239606332295955570788633911772002977648947400870357700705067291418864807091395091704100e-01), SC_(9.9999999999999999999966430483088810588509867797017055058990313729202050138260675453211401512064708854e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3265216964765519779176675743850996206069594112332592872856159702815584390335618122545050060784697271e-01), SC_(9.7256000738167239606332683281734717794502239288920304388765051224927094102057244999492697804596539852e-01), SC_(9.9999999999999999999945316027734365027428383215498285854652190389906239561041614265469797921955969849e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3265216964765519779150891181075641960510644290150741626122702456813641335453599147288464855363908738e-01), SC_(9.7256000738167239606338851368462088378882570614063357156097301379948589312100492238520634757760977762e-01), SC_(9.9999999999999999999609072819926607162135119696493916072868517145919149801206485633662255913244074390e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(2.3265216964765519779103857374121729228945397075767197929466783083224353253097527680377251044594573552e-01), SC_(9.7256000738167239606350102619954606801414333788375460774237003262811709820338995472706103703392448826e-01), SC_(9.9999999999999999998995729159094368315169979804979698186889347428299054944255953818340177782508467254e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3265216964765519778964032966032136542288130672040431216500162138078693414586760540360961606392470602e-01), SC_(9.7256000738167239606383550892210137258712455499186446458934284000531556430396935426490744595119609145e-01), SC_(9.9999999999999999997172351042681078461369489200000150494630508512184607058029432232099406974804374503e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3265216964765519777457195696380633974583568556571605011341865172976673052378920602029584860009831846e-01), SC_(9.7256000738167239606744010871470618316532685724941066554245050522240776792335972901512058426768730279e-01), SC_(9.9999999999999999977522462013878503930205033261237251019375374888259672211571594198249959608748382783e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3265216964765519774473145769906961306132383275934679388561902256231168459739114426019913519828168911e-01), SC_(9.7256000738167239607457844140843965537306528525678988006827991810981715789224983823904544023233598650e-01), SC_(9.9999999999999999938609003279760923856351396739672896211110044024444973389862595633630018701752026857e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(2.3265216964765519762911054915532979363225797377497477153485117417407764915342453524949387325082630727e-01), SC_(9.7256000738167239610223684297252713932873354305680303043835493960129159894989769795154089890717413598e-01), SC_(9.9999999999999999787833729263657851861565033873061970145684792029445883310823731093123166543450870773e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.3265216964765519668914108306094028474064077197507490849490653262093857802402364066494455813468106292e-01), SC_(9.7256000738167239632709282515315824802629295457577994201253224326427577946957289749290758521077803626e-01), SC_(9.9999999999999998562067943453932011676580693605871377506038094607251950736578814450972113514155528520e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(2.3265216964765519047109285206361129948627002964597138273422620294516331830706244229203842314154940871e-01), SC_(9.7256000738167239781455108061849026476512336441681913302650893464962833141594308937366512165482925336e-01), SC_(9.9999999999999990453431385566160845172988636048509458726007425926459809420461029889686734988584320858e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3265216964765516953928986999215772232475261369139207766942136770107122524002209255454337435910517838e-01), SC_(9.7256000738167240282177874930162357465692521852823966883438491887625664978376797046459745365626400321e-01), SC_(9.9999999999999963157344803795521767518168062660316399498850003207888594300022602391650101127611430634e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3265216964765508023913779803578694503469148455444374000551381277621682519759390932531190352279168247e-01), SC_(9.7256000738167242418382733418949696295176852805796007521021378353217512451988026722654943570957984049e-01), SC_(9.9999999999999846705614161709131318051117992293640491008007674064612615328538547024784619516619766913e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3265216964765474233571793083926870885273742473261426177337907221560252526965402168192501195348922959e-01), SC_(9.7256000738167250501582039044358301690061363924815594437146843981688672533377475284698161360392132293e-01), SC_(9.9999999999999406063161484724386663280401940964212063393814439293979271289521079617537237430254707952e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(2.3265216964765337075999522426587019486479563773203600843139007104898916868486382032905824558440566446e-01), SC_(9.7256000738167283311903798296525618837596266110626033296015794467213247970150411166113993708653538294e-01), SC_(9.9999999999997617461877948843235597203075422621093077813253614437130546935177468724655402175782923565e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.3265216964765266839314965643539020469020892304041764873501941324426925996965120375374619383916490272e-01), SC_(9.7256000738167300113660941267966923455335325635026532701621777225365366055747805490959642264436017919e-01), SC_(9.9999999999996701541436446232441507338116761147669058989614539629274845028416648204987355642113131764e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.3265216964763270978202635093911670029948157664017331667490052945232638060321997066568376736708380114e-01), SC_(9.7256000738167777556095932152644346745616796232275602526505502994835829287520305673538723129645424452e-01), SC_(9.9999999999970674544252292965114241915283099983072934934687535962072658695050857207100079175697247445e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(2.3265216964753792310649227754214463980168967785661343343524125110804944577332748851143599485460874299e-01), SC_(9.7256000738170045007517881199873178781076048220382934768413499870731813421635964839537614792748174530e-01), SC_(9.9999999999847068120840415138602679859768367613882361881992168968498110516828507655860545919092278901e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3265216964718107849633156692653999334715321878693573305368425741509711326677430869632885201300009228e-01), SC_(9.7256000738178581310897696072330169769819316261609167168530260017195428493225078202005714311314151997e-01), SC_(9.9999999999381725437101107363140758167056915088625265966803632989722913638515358305810631423105259944e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3265216964580428382906101655554894905202376000260645800176070995751797101080356259665739918331838149e-01), SC_(9.7256000738211516478297852029654969538108570198308748307464433079397694506202490556495747955509246334e-01), SC_(9.9999999997586318396663903119690031361707261515322449935226039708824539567307332172584902099880514868e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3265216964527436950472637165026045785669689835828848277964927106097372903419086451594223535515557840e-01), SC_(9.7256000738224192890688543581761479277009257391128651869667659784244190936511724801238867667082660723e-01), SC_(9.9999999996895284409276810584545431217477370151297038538713570621970723470099908607599384860583027453e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(2.3265216963059739662654867690764218126872861834785202216790515537696802567384013909955817831628081368e-01), SC_(9.7256000738575289949780032367893412969042971752412317972931946477758712842746131098398381118692203234e-01), SC_(9.9999999977755799732447097952538848254368456890124742451859083652520326951751807376569157713664820544e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.3265216954766877616258710926867824013550545674638105201347588944401253932599270266618311717175151339e-01), SC_(9.7256000740559077410220522276429160130637044249538057026158403525469558061313605786991274543096761017e-01), SC_(9.9999999869612855429806302746065642015503564665064527981031860177098271540901463237587036463606680092e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.3265216924674164987214564229358191571737660151380622161528609386682965259714658920801952391511537031e-01), SC_(9.7256000747757743634026061581104880572419547942274890354690736090249353688143307884567356460832098354e-01), SC_(9.9999999477189283641664150237176763926361652847210877536671498296430531055011451676576752568653623659e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(2.3265216881525865221323861886608697572919921569090431911237261122393760906615080997639485024755678197e-01), SC_(9.7256000758079518591683893703755621266664690255169741604441861024375775748178339959357401164693046609e-01), SC_(9.9999998914514522217589561814400309629446661827894669080627155632631136342888809020140008215073969717e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3265216706696287422689245514244138579099817227760680680480350657970993773624803987614406769120141784e-01), SC_(9.7256000799901596375359341652996520090832029883850464492926092622383949104619972193705090646677146253e-01), SC_(9.9999996634652017519190814616799048467404032313414466788263591243226249186398656814876958092906603509e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3265216165492352002420038210011091252328929023939991618364015992695496191021702559962893328650051531e-01), SC_(9.7256000929366375737855513558145226030262023421984210682792820845491585348481825512137800629378047509e-01), SC_(9.9999989577090207574407754403417830508828848219437458044972685627820712767527002369890608833157960263e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3265210563531226814102362879745065370255484466256378561264425645202067170219054352651900577734820880e-01), SC_(9.7256002269446357372657432680668624636458284836043991593489788433019682302875225491598422997351722380e-01), SC_(9.9999916524804284813111691615493196543784989762088851254262960206276846094055901863832455495668325326e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(2.3265201288496120311253334928881164011914757858387405067876377729984747598965673716725791013473191514e-01), SC_(9.7256004488184473551488530983286923715032823970391550258267081799568577654925222449470423045232470795e-01), SC_(9.9999795573871674778341007209445990928863768726852711971385857332191655743007607421221423684470158343e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.3265031012884219076662433320097415202616145292098856525909999420657399592539398250665150804442153967e-01), SC_(9.7256045220693276385389663344893257946068650906164096654774922525652171402066247393108491316596896248e-01), SC_(9.9997575101459716064095060635819022524145364912389155027277388894226388925547515887840754081043137896e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.3264672022918036776638897942775852201741243432018851141333484703268712144442471235674728241086414991e-01), SC_(9.7256131095505000982244892774552789258427126760107321763387956214764180046086166856372132878540419626e-01), SC_(9.9992893730049188788776649342859321437593124953698652324976374080526607580284662556565085380165984323e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3262613126374186123379718182803010864311757171811920379411084445474163298129977246337659170726722887e-01), SC_(9.7256623581803637555756933572902186271073094228886225543600238639746504648589789244192037819625242507e-01), SC_(9.9966045508716813321715893356740514022197650509591976099132141173614575514407728490094082616417097397e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3253776494893134979210038521798080214091821748534437252370968741870412451151143203662332419891264862e-01), SC_(9.7258736773235727367969624274686322574428678603636565510448726541236453109359236569444904512157563470e-01), SC_(9.9850826642172387447295046378704123003950151516740562749106551898484882921975043705744859716032544420e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3215442094185699270875453692573225507074318811250652553492682811264435748185693299952442702033848541e-01), SC_(9.7267894232226034727837430501960984379172517679278195249337410485240766001088551526683292136105487421e-01), SC_(9.9351213009850409801151415368115363877408815033359895020465910512230920888348790844638880791288730900e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3148065351683773639676247895547287168189992505716746144533408452331799675539774451525293317868172117e-01), SC_(9.7283950734302403602061176033190101015208700248369168680073487912025143952368911662292022222473998956e-01), SC_(9.8473957366550379249821580704735549506228193135233007003246360461067091741416056719062249791140424825e-01) }},
      {{ SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(2.2699965679635514462717659148437725522751696842456063730944331730647866964044251569110669250019206837e-01), SC_(9.7389483817008547465393319288810244764534129402040733501378434791816811684949516460224320501162080839e-01), SC_(9.2667946921833680473937848187103740444416763203227850860566682904788393286343391571670819071509088988e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(4.7051387367278268582047381441199883116292118198032760608433983609415262088990471836645433856378824814e-01), SC_(8.8239259668326359783681122325687575504836449885328377893146443832357258408448929799232614548731048249e-01), SC_(9.9999999999999999999999969846610269689989943958292610768116133891735646771995654691535023931319203332e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(4.7051387367278268582047378900561657557505693025639735386987606098548024136827329741985097281060296033e-01), SC_(8.8239259668326359783681123680419627430587766223045902296452622608141303769433189172013912386194873969e-01), SC_(9.9999999999999999999999952779351873384047564488271055052388097372309911717991978626525162393763320236e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(4.7051387367278268582047306722554245304965991385538462432521306522463029525594066398002792227995485124e-01), SC_(8.8239259668326359783681162167544280531045708210343983149303740518949909364964546608879599780014616740e-01), SC_(9.9999999999999999999999467908782485465541107839385903693790987082309399249345249965333724055587978597e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(4.7051387367278268582047092198376981248230978412230413333332304159793305837969211438043434629363556103e-01), SC_(8.8239259668326359783681276557218469070735012658612182221865793380282113011926543284939031098298516836e-01), SC_(9.9999999999999999999998026798620169725423863676245305295741032667589822046702453211621432032711940119e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(4.7051387367278268582046942758492376299678440965693968860323045514917936158457345034570262833066501138e-01), SC_(8.8239259668326359783681356242314707391913994523427827647387167157066144744401591022182379294266205327e-01), SC_(9.9999999999999999999997022905543379606084188044855987883708960911461154029146878553926329932592894504e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(4.7051387367278268582041975555153917051374866104061049925312556093242379071693073032257277746960621825e-01), SC_(8.8239259668326359783684004879772550614361247733368536029361475940336322883325222749237066067422301876e-01), SC_(9.9999999999999999999963654698282846945212257363510064102823883170998815275727442150295271980064746183e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(4.7051387367278268582026947157367430704292215525745782186031081649542386907216742391929744243935458133e-01), SC_(8.8239259668326359783692018398567012278646349742803430382091516832991435211201794891454177770084925413e-01), SC_(9.9999999999999999999862698353643097336058675615427348659478480200310362644145785404425412457986251577e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(4.7051387367278268582014091638769864607003487813915477682794290634868246870965493731845752162209289986e-01), SC_(8.8239259668326359783698873283655746216402564721669172900208970419127279217371115953666916466155711235e-01), SC_(9.9999999999999999999776338770639137532061466094457353751541446347642675259445988963374037218600216528e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(4.7051387367278268581809370241096312410526926540931817018304091289333528778018083208299706467218061846e-01), SC_(8.8239259668326359783808035869793881065450309956963436506447985983809096292439640090141207547378647138e-01), SC_(9.9999999999999999998401080790893144355959559189356906074740971074498474930246997820774740438716361545e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(4.7051387367278268581435936462854526197145064354311411701605343865231444981580251469695194006030616202e-01), SC_(8.8239259668326359784007160130606186638259821653844553649259232644808639146043442554979097482429499072e-01), SC_(9.9999999999999999995892462789697954355216950791757112161167303162985711200901697106927981699634886031e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(4.7051387367278268580325774211806416923319700331272997058149074876088698767662149754615456455787575544e-01), SC_(8.8239259668326359784599126499215055919706873970638292530034419666847794643120506748593768073454036358e-01), SC_(9.9999999999999999988434720160364939757936069269548790328603562015778182776414978885406018718206065414e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.7051387367278268568361955604631421616464527749573591233038515636884953414303844860677377562099644960e-01), SC_(8.8239259668326359790978534778408737177311064709301229916481785033413850585000591265005855251897659087e-01), SC_(9.9999999999999999908065314740480976996005494678050848613080077061754968721159942384161261987979629682e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.7051387367278268544669528589376050559112001792993369270195022643697279577539999578403784562338974349e-01), SC_(8.8239259668326359803611931356710884892087591820631769813947971131250317926808734068735675765272922142e-01), SC_(9.9999999999999999748906576657632826962719151816028174824858404937796395034432230828047923855945756851e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(4.7051387367278268452870128290895817585121000400419273278884974612969771503400675877224521678072760892e-01), SC_(8.8239259668326359852561675039545185827164004574821635631930435395493416218678401545775502976604300001e-01), SC_(9.9999999999999999132225275967726908478936517803491539095793403506410092678466691205036346808369759909e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(4.7051387367278267706563648146741832405179915462036054799613152499335912942441611505253222107037030256e-01), SC_(8.8239259668326360250511016681370639550904870679816948917026215380682545296675227922309142826549172423e-01), SC_(9.9999999999999994118758418971041017269667786034878537634913125522488731477369377037262385677040161289e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(4.7051387367278262769627017721977740744292679785694472184664594937063495508786891329598008569995651522e-01), SC_(8.8239259668326362883009506344038063435469087322570505404241505489120336629055800113702694519108730443e-01), SC_(9.9999999999999960953873977733709213223121197236952498394095086941172182720061709569069411855618949479e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.7051387367278246150427384005392990089801962619116394285757877020591162461333040867099790813419838386e-01), SC_(8.8239259668326371744783762376384311102697305548040112678989616473721106962768070924195153971806619047e-01), SC_(9.9999999999999849310991636211256789328422158291082836331959926685363536044288508022156787224511675715e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.7051387367278175248887947758358020971321166667268003901003809749426242139963256446983571670764567844e-01), SC_(8.8239259668326409551263661353588504760504333592097722425050240029542661437380295576531633519567866429e-01), SC_(9.9999999999999373015357696374855280567654057403781045531540281825924122240044108848667663456979163127e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.7051387367277906964096785790765661318446088894885281639844828805475238847076489187531218430940695854e-01), SC_(8.8239259668326552607446149273102736026207114652470490717272869461334065611008910769549835007559875263e-01), SC_(9.9999999999997570757244559000637320499492391719531863055405229654963691922944237689221978055752834683e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(4.7051387367276817975691537395895916394159345134358160142467702256356533439279625560300793772924028685e-01), SC_(8.8239259668327133283388880552473578881276679357917618113294850391285259562637832228856384325624470211e-01), SC_(9.9999999999990255254267401567469157649152628207859403414090032782979105091498530044164135035961991536e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.7051387367276260318291809647050664182176527038957520091373539112534082677892259835217566762998250009e-01), SC_(8.8239259668327430640307234623696483818422389769904504697308746019868031041686838381157033446978880719e-01), SC_(9.9999999999986509076302346331527800386431974695369381115170986865500598598553708770151528220870726149e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.7051387367260413802683286753253703361220970214493325613906727903996596616009517880334646658234542428e-01), SC_(8.8239259668335880400052733310292311353835802845761310489698111979490110741639510190194726126080182117e-01), SC_(9.9999999999880056857387062261336613384934020388670650886430628888631296085426310846525494578331289428e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(4.7051387367185156134499322674589025665870281787454864636430791560123028610138243179985033512900342818e-01), SC_(8.8239259668376009677104538229375251592500647434867902391601733509309575500684589920292532748234622040e-01), SC_(9.9999999999374498035089251738607016504230070086290632992352856281097858281124629375896634237628606657e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.7051387366901832628179664476656371978346462574294704552909276002321776464817691255121017988198936426e-01), SC_(8.8239259668527084879867163200381695729211418842901347702506482583706083449665021939670332926541978534e-01), SC_(9.9999999997471214268260283354286013090839590040663791449823941481395882348301307208500574548907315948e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.7051387365808700543497545530035685021883946083028529089648233928254284042205153468619366438887138522e-01), SC_(8.8239259669109970336431630202661063602659220041222261828894572132457606930820199105613972787187084068e-01), SC_(9.9999999990127875274669753045780315770416499011190240324075921621256171238505463958743787053831331236e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.7051387365387965074489659054814688987176497315181073892990299695162100157199511549439249979062615334e-01), SC_(8.8239259669334317045650924224008360381691429817117862848123917845816732102224021042830584070231930388e-01), SC_(9.9999999987301498463653206044465444664659308070500080402124802597664293440100901837848699771797923256e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(4.7051387353734905732932409287527503916147214694607343566251564204904116038230419794857684340443293851e-01), SC_(8.8239259675548020685492414128088007590339346013556637019670240962732950505791705302714412700728046115e-01), SC_(9.9999999909019682158460504774425174910061388367830209518796023119778717942072221569606519187662817270e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.7051387287892163956587446519204091059265812086669233784152202840755886046538069436103824542268253005e-01), SC_(8.8239259710657022691606032981655991805870739616547088821143357883709718366368823922558145225021059905e-01), SC_(9.9999999466707559370988409890777240846016131588760833726110151285526804626395856415546201370889834640e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.7051387048965398376496691282814599885832394579082017452757329168358111648474306797507561029298634957e-01), SC_(8.8239259838058768591973642346663834037482105195967445955277280515465706505875167956715921831446124386e-01), SC_(9.9999997861668008660499646396203107180426916589509850656611380996051963046598526029159108071834687187e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(4.7051386706381337506918899376637874526722226971038376708471521806270370978214047726519200024609626802e-01), SC_(8.8239260020733183574561388605645450595879373193125456282691813345137316812878751051909206350326595602e-01), SC_(9.9999995560289325298499180544974804344623446964945923934982042222039132590657417423770657414087860663e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.7051385318288946758464303509192295452931003481213287046829000359794392894256972946284486192469547507e-01), SC_(8.8239260760898849159495874131347573380609909468671365858222286562249260109558365650549942900959748220e-01), SC_(9.9999986235494129590612229995403843014351318693690313542470335326534167850541592658117226072273572761e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.7051381021298310834752628577029455763306767533755810806195003067289577081776560143966134559043062759e-01), SC_(8.8239263052161814414410845298675138589758602116363374543135360220521171849829656805455039810455829298e-01), SC_(9.9999957369579643551267360484013536516060679735595809837082125828838358685041682806015506057169724569e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.7051336543475265270592127942497500546998683495773620399864389976157381538024512085967188841678405488e-01), SC_(8.8239286768834600982925395095165060544867056244750955462908677716676521521663053033483942069189086508e-01), SC_(9.9999658580784454771444666415728937228237247571865685982821238680986230603680782398707394032690295689e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(4.7051262902603170241319249225911144592025231407420185507150017108805659018436767735549570503779097858e-01), SC_(8.8239326035901468093199007532819266930047778151047815846191736935926626472310845428618633805471041952e-01), SC_(9.9999163883649806172979936982656266768025932051208547439663970335257100283299035939546478893111301616e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(4.7049910970276607529203653745488566463287165029784248824721575643559765627228294049780280138132633583e-01), SC_(8.8240046904390553705810186729305195460074695720074629082581530995854676536500188641144855274841814679e-01), SC_(9.9990082089523978623025098625908691975513667970296544627957804553321787598630968974163339655039564517e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(4.7047060724674389603484765954939237338225792488557764737214130917164939022402993383204540712251300029e-01), SC_(8.8241566606496739477241859410991296577297232107732461593787871782850235007492236546690849382927783362e-01), SC_(9.9970935657001518433926155923531887763234884883293888734785775476669449665473769470563224338522995803e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.7030714294117295949566692012015064206500601174395342309823425612324471431204341085857910254324918465e-01), SC_(8.8250279959811521591574799505702484524533710111822141030634263289739288560573090679774604281898437724e-01), SC_(9.9861141881860161280136841791176756077174364494790261743116196204939699608262355042160177527903561087e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.6960565078773129378065351613604165616104623078742560387337932523263170949626259176518610105546756347e-01), SC_(8.8287628394256426922765264917321163082607172804071263861233318990054891995488277454860357083717864069e-01), SC_(9.9390220244227977098135026260125720202209497321600683853602123888494161670980666255028747391518814627e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.6656410765595645395988059640243216174324986864012803900877592653146106358473274802112219289882455144e-01), SC_(8.8448738456079806103253025973984789189640894819712624630718371775328928356319216177706529585439913985e-01), SC_(9.7353048950997821397909951203106407460287179465020831438017365263095023156880420885181813783373896914e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.6122490611777375702622699502341994977352892150949310727277904474411130481478278966751836991597612491e-01), SC_(8.8728326140903322236315939838881891037906599454601969240867727827265976227440521704632184613923993250e-01), SC_(9.3795266489382511959159547530186667451624997604630860555382919913246428424846744137026312538976617168e-01) }},
      {{ SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.2597083127750212082281753972563686831975436106004318942382650377760703425485319916847376865429837003e-01), SC_(9.0473689595415186698574440547704567397044650589123527073704981066915313018615475960883500570660960929e-01), SC_(7.0891168500646815511002559463276252978300479674519277853261130369655790384240672552166978491540352927e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(6.8297755307246338865707342340965533586718217745202134776937604214119786382710896531138953190521258348e-01), SC_(7.3043936230131413644283241868934594432073213337388168407375071889647415062191960169679322378186097046e-01), SC_(9.9999999999999999999999936466302016529506144703496904217398962208792444824888948483995552889113690755e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(6.8297755307246338865707335218656563468106934650069414315835430181161050346493542829931475780983313299e-01), SC_(7.3043936230131413644283248528456799412940214598872276228888701459176258274220236349051462931651520009e-01), SC_(9.9999999999999999999999900505302273048777596381973894901665224482302012225992690759543655365325210434e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(6.8297755307246338865707132878132648651884146054945515512979185060407462965948546217487557319060675520e-01), SC_(7.3043936230131413644283437721486423869172582969061435337923242015794815029720016272938439822234519549e-01), SC_(9.9999999999999999999998878874878891502397903903344733870962105064384275514593395161304094946705390318e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(6.8297755307246338865706531490868352469262264985068414818579301374803637023087482083871350016156835819e-01), SC_(7.3043936230131413644284000032368635769214620235544460123116050451010261439954503832379225352127940358e-01), SC_(9.9999999999999999999995842431592336434016248688052216880748688913115228156623177522708924186844041634e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(6.8297755307246338865706112557932561809338218883070064315812245018081610415856291449502912243602564499e-01), SC_(7.3043936230131413644284391744269930787324630746689561048860506995747628846117773767875629853947869855e-01), SC_(9.9999999999999999999993727212039280079996932274110752834692931582241556016415600775412865202946183554e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(6.8297755307246338865692187727337631116195511628005974500503821400315633328586800497327169471875317189e-01), SC_(7.3043936230131413644297411780179155540387896780887710554599698687675081766292344093145442674338873295e-01), SC_(9.9999999999999999999923419839591216231238056869512254287422465704458630418246706979047469722477893696e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(6.8297755307246338865650057804515714680931613194761467163155746196707808183561343539336977724987691825e-01), SC_(7.3043936230131413644336804224076743193232862646869509485903608484215897666097861605404057249358768243e-01), SC_(9.9999999999999999999710703127897287960414804632915966784340086675595912735336250498259360162202869922e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(6.8297755307246338865614019231805177044574541021775938143177489872140052738869390338100869922449468938e-01), SC_(7.3043936230131413644370501115942646908620388174368116851372144389134943124088318728758060475490108953e-01), SC_(9.9999999999999999999528742037829964907059037586148126124138768889106995619853722785686067900307745115e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(6.8297755307246338865040112631346597787098928218168185576853536975866129946283289531770543188613423980e-01), SC_(7.3043936230131413644907116947321742851058804357577838717112293883737007035734944475579456197941792052e-01), SC_(9.9999999999999999996631050404616646624912638821681343447771543858919410746126111380822116647955212411e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(6.8297755307246338863993245461609441261164222777860795750477501582029622494136711070193837302013605448e-01), SC_(7.3043936230131413645885961756186299333621315653730324634376507302111750399704532792628560353992821776e-01), SC_(9.9999999999999999991345350194148335748358370802434208714420842033011455591077862630545839250625325284e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(6.8297755307246338860881067395726812302521360568192124615732246698883852373582225344125111004317496265e-01), SC_(7.3043936230131413648795919611504477328645530949268681843690780760260979956434776717667635841853183792e-01), SC_(9.9999999999999999975631761370858665831646230014954494642034776502529300644687941275815403880380320237e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.8297755307246338827342245643954821619737705221675962062607360847030282187031620164120570026993310474e-01), SC_(7.3043936230131413680155487010488191054829631145698211203433286821422197567813488434238229724854838576e-01), SC_(9.9999999999999999806292075958133185867118045635520732216577231307539811972788912029010677795553082661e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.8297755307246338760923979651944007105842074517849797555727134324650542864830247771714680301602958723e-01), SC_(7.3043936230131413742258088715333287253379082196109193340529006124051846910947818533769591187413299037e-01), SC_(9.9999999999999999470941944937159044436885183142075812805428428954823689701410911511563241395913852283e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(6.8297755307246338503577740577085837720186539138441310702411517755711614552949155324442835111119823114e-01), SC_(7.3043936230131413982882723321544708512061554672134631422227811796693060750147940253380461520831251195e-01), SC_(9.9999999999999998171584099583451180888156378549363048179692622576995337541929168446558459609580280417e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(6.8297755307246336411416296844071139459726346964431811582407064673998270652257003485209995740900381608e-01), SC_(7.3043936230131415939101647465298890149779481859661832079965939313197965897343998360149596718858270684e-01), SC_(9.9999999999999987608125331218581246233334739521797776778148786650008141602961709511294295383859689060e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(6.8297755307246322571434006548546280616289084175122338731622850751389815579228992898367418880658671524e-01), SC_(7.3043936230131428879802446244331163645766956345010446794602070732943714958780568583929109023330358868e-01), SC_(9.9999999999999917729157474140808935400031106232916259083590979885755607451173721192425349030980461878e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.8297755307246275981930063546970047914027858440154469545821160411726540077066703888096102957669130355e-01), SC_(7.3043936230131472442056952355056990724130722806197595092203230322442603387510837674582756099547583813e-01), SC_(9.9999999999999682495731576405316295803944572999245278020523367678634519755245697269663744533011316620e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.8297755307246077219798075654125271533343373907895944328196534402886641854539925509351977682497530751e-01), SC_(7.3043936230131658289208070914409808859931710097618439629954019893363191508504396539880486989049034806e-01), SC_(9.9999999999998678932841028110682117839450268418758887191448107210647439681523447247905103516759529039e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.8297755307245325122488267199160498560584680871014101180835990075472953971628140390492575347793046795e-01), SC_(7.3043936230132361517438689542262511166682751143071225391039298162680733172235610903593934085327010571e-01), SC_(9.9999999999994881544763851821159759507941093966838018085179951323490036288033737958639651564360662251e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(6.8297755307242272302213019200164488231104117625066924353445930254446744681817422434794134059936145271e-01), SC_(7.3043936230135215974398661873200598195577172019606025749298098618062126265019041030486703734018239543e-01), SC_(9.9999999999979467657273759703998978764310172998014428340962738434668758827074791353522694693720590222e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.8297755307240708990970836908387340219460324818207999573083159288881728789827065911468290893654500418e-01), SC_(7.3043936230136677706257569762010839639964941906125136746574600326366391631692157892718684559840117878e-01), SC_(9.9999999999971574397459427629755935681621290087635171656263686185293611559923923910484486164202434917e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.8297755307196285594074606555385175090810990995357626976035930329129735221816213248817938748040705489e-01), SC_(7.3043936230178214601005056599190052468262080292930282622361058093163098104747089858369867497517750013e-01), SC_(9.9999999999747277786473924138367624884484354954195004167802357149201157581872322341052720652599043742e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(6.8297755306985311690043214419322617098661903112736858552128005121018829877313869256980737179596189516e-01), SC_(7.3043936230375480039005166751407140735205717446239281998218379867284584854422475097825463623675782556e-01), SC_(9.9999999998682056867167040948018065189598632367755490102376248986993928718336552992523532770882968269e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.8297755306191055534162230088894578415562876678165890136791055931290639555789136469122825242485678988e-01), SC_(7.3043936231118127757410528172078145128471595414131161184994691768700047269187002971671321446826788181e-01), SC_(9.9999999994671806042966450061438167098862660453274597822540475445899914855134541794546977323839232242e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.8297755303126619057495007730766822039604008897290771249287886202979660998369701262434828758543536824e-01), SC_(7.3043936233983446131871575565066895257296546975026404482378706946155416175676547808820500965516556819e-01), SC_(9.9999999979199267599370468849321696681308752446667083191888867809877475106106193237279971292738666505e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.8297755301947148491820114420678503454178465287968309794479592616744039382590160549602031538101399341e-01), SC_(7.3043936235086278156454096221307768344503737714731469611044705856468335250814463515355833852934954805e-01), SC_(9.9999999973244044246267402711680413099333111841660756441722912606304408422918709671145853213055075399e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(6.8297755269279495042719200162842131093832857513938510367931028612807809535799047372635699549309751761e-01), SC_(7.3043936265631283198004787167301892169580298817659484888593301503517828648627663051352218041719142637e-01), SC_(9.9999999808302944123522057260511289041177926818523921919279414017771156404415170118393398558664923180e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.8297755084698964787382618692735981368912813319944705400517582040581084623737654054009153127547314753e-01), SC_(7.3043936438218310888847959947016765771757390143599331603946448140424283556306166522722700906385443226e-01), SC_(9.9999998876343881853133948491185639791400998708538213948255514616825086338765829064460705503568556637e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.8297754414902597804097566640966766594050618010094044067590317626476306172170321152205576622800808663e-01), SC_(7.3043937064493263185732046057295922833821117166892422673696006693298038204595679876373934466486290870e-01), SC_(9.9999995494498627273545094326827711349145469219063880479316475565970656073213204479290399411641603961e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(6.8297753454518103838887208773315055234455024475014600650381287343933891963843124016724927319496815742e-01), SC_(7.3043937962474753291449102749952539224910104468433562867573017673235572142638154867749995810941294457e-01), SC_(9.9999990645455147316606311012229540739033610685670281649860400667530060385144296305524137477701076581e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.8297749563203280812885280820483080846676861330721717050681286763115212340623009077997511916279586407e-01), SC_(7.3043941600942963248654050943016465483630963797101587740728269689302337557377639534584936888815177898e-01), SC_(9.9999970997955374862800370412747175905977884271085030485848898451083833768963162957487873424667908393e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.8297737517215178208394193168296902805955943332059641647871227744549292753822619247307862734294512687e-01), SC_(7.3043952864214422285446823509900943294225414059415917006430188994106789554581538458593984693659971567e-01), SC_(9.9999910176990555029360034456256604780145929913368306223490409793976365692405796943605639319793121867e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.8297612830040754822235792443268641742853637213417867331125748796629641376600271445843782080416141100e-01), SC_(7.3044069449325264691009844994267796932968841392235756183588912669094133037884183513946239786197957560e-01), SC_(9.9999280624073389474421169532342806297751801185630050122729538130873809685315825619047599643079769976e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(6.8297406388182243074566215500457748116477235816761727099148314708657419500310600621214860677180395779e-01), SC_(7.3044262475895280510394875108016377425076237343533136661085855857546046666913103296709043411975566561e-01), SC_(9.9998238289351112019556027055011999109931764139494508408187008986667107006250518695577851722680613026e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(6.8293616374769314932326647773859187666421243772825641876950993878561058452747703935117253733802550652e-01), SC_(7.3047806007133715243646787644154156817404916707765438762280945547482731156135552587844171309469242998e-01), SC_(9.9979102870401142290803206324377099622650295277799624209948206753527252814919901040219874336796101127e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(6.8285625605696772454997090274650503387180222940800198512619718030696422906370937367721654523654407671e-01), SC_(7.3055275891879357805018936645811152649342163620058549466146381368810785769710007505371603596647167626e-01), SC_(9.9938761578974577875647511878076372307983311316721758721733344616839254396926187289530451142537237671e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.8239787911432095324311750991801903499286911528230106698097674411084700167182629170699170327366639383e-01), SC_(7.3098093995690243780388459892723167174338671680306048062563539509518761452754744434311766552025067534e-01), SC_(9.9707438222428227648058746204329533864955354824960381250994886291044921684319938121164844544980590542e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.8042889743765273444003542454582889616483381919692648366213655709394554991719852685664907702297430454e-01), SC_(7.3281410707749087114279639256275957059345299411906761449090136807843044019248981723085897030322354573e-01), SC_(9.8715470607043151184443791005302416665464075493283076763267975613371142811673309925251799891834138763e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.7185692611503996186617609538342425699105734963733744309566945726302705043261286852441942564207287558e-01), SC_(7.4068095076844640941766042004249855715429500655777791454794069579124632137032106732830467810154032569e-01), SC_(9.4428650097385968656958460588682029261083343529168586821925726627120905685399310930905995246457260682e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.5667995905666129098692950647934290658273855362628017312717162571600886467718877970917700191822590604e-01), SC_(7.5416936517823478250184160205759978811645182275710277240769550212298806053152663178026801128000065057e-01), SC_(8.6962516356601579316416867204312945728616227887058957587434430167579412064062432265794170619096233727e-01) }},
      {{ SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(5.5344647700234853016339001600876193757116457607348930565684083433751018336465945900940222793429921060e-01), SC_(8.3288474418354482158469750131566068073259609865278321257684769615582215416360872049763287049329126335e-01), SC_(4.0034640335377408017926226850022873956331883174414451073929599448368626956854408016799842701273567931e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.6504814008555523940913190017454326152801513671875000000000000000000000000000000000000000000000000000e-12), SC_(9.9639439232989392384330837514488488441547770471695289736437922515542171467129008679945940159825957100e-01), SC_(-8.4842294485365166522345274492522109929779701429900364897284359575932820462545768947961965255638439592e-02), SC_(9.9999999999999999999999864775986125157683415636252520314986667472794931396109906400368840427385197564e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(2.0654207510961697380480472929775714874267578125000000000000000000000000000000000000000000000000000000e-12), SC_(9.9639439232989392384330843205896453848072629756615218892399690546013633964889946402799401084842633021e-01), SC_(-8.4842294485365166522344606089219772208423230592070442750441095612133643429016148514491951540124677315e-02), SC_(9.9999999999999999999999788237221932165375651964488872648881404614130467739765594227820343378603532970e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(6.9332300317581641024844429921358823776245117187500000000000000000000000000000000000000000000000000000e-12), SC_(9.9639439232989392384331004895381474060034540890066234734857506069056592947714171217203968745449432276e-01), SC_(-8.4842294485365166522325617152493097804674240498833972582632448401258837928645892244738562123707292134e-02), SC_(9.9999999999999999999997613816860280159024299448992201460214642212816798972143186838027912746312656231e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.3351444949627477853937307372689247131347656250000000000000000000000000000000000000000000000000000000e-11), SC_(9.9639439232989392384331485461484498980084333194189500398761332981581665151469287358129024967230862219e-01), SC_(-8.4842294485365166522269179101978038177383774004629837096087237919077481288293766577372469430998228532e-02), SC_(9.9999999999999999999991151103967066862617035954628703863875447951972376051738424732228532618790132634e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.6399812063916385795891983434557914733886718750000000000000000000000000000000000000000000000000000000e-11), SC_(9.9639439232989392384331820229079914093745579054143137700138862399950873750615589387502091425501242036e-01), SC_(-8.4842294485365166522229863739654483934304302545430321768866840560582359838821644569937180132355924131e-02), SC_(9.9999999999999999999986649107589251015091340353724280951995958994005094291050805937337908495141463128e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(5.7301594025283009159466018900275230407714843750000000000000000000000000000000000000000000000000000000e-11), SC_(9.9639439232989392384342947504251129420140979303067149470497256202933826373292083411249281168959356486e-01), SC_(-8.4842294485365166520923068037138083312629901905246460486842801237127245782561718384627785208951905881e-02), SC_(9.9999999999999999999837008123211257090267208675664841044343815749541512763523341425226486650754148733e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.1137313293829720350913703441619873046875000000000000000000000000000000000000000000000000000000000000e-10), SC_(9.9639439232989392384376613353252710179648007124357643202423541818910182837068547105567652387687414290e-01), SC_(-8.4842294485365166516969324994039895528373024818442421608697844524896765263513900991442374993445660885e-02), SC_(9.9999999999999999999384265586786032796108247223000942939578132228705167546799855219661054628969169731e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.4214707189097453010617755353450775146484375000000000000000000000000000000000000000000000000000000000e-10), SC_(9.9639439232989392384405411629295938379871096571951606227589620957226559975779984998142624449704518716e-01), SC_(-8.4842294485365166513587233440258244887801544149202752175655552037801597695719695580186903857009388787e-02), SC_(9.9999999999999999998996982778624185856828627188147753064163045209011786480486596399837187222976203855e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(3.8006320313144215106149204075336456298828125000000000000000000000000000000000000000000000000000000000e-10), SC_(9.9639439232989392384864018046253295123366531321280654764992973629236633971340543499567767826711429087e-01), SC_(-8.4842294485365166459728145244377673594892527149933394242650385248146875328260621607358033052042364779e-02), SC_(9.9999999999999999992829586482620823054002701474013125399391371913058626472483332846728857921665797938e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(6.0916272026645401638234034180641174316406250000000000000000000000000000000000000000000000000000000000e-10), SC_(9.9639439232989392385700565319554949317671563639609076651630845357728147687684559855771047557075305439e-01), SC_(-8.4842294485365166361483393956986337824392500463638478647982493282160829707630345309482541950969135090e-02), SC_(9.9999999999999999981579594410939734442442277082555409893566916609328387693510499355779173364112634081e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.0221641311147777742007747292518615722656250000000000000000000000000000000000000000000000000000000000e-09), SC_(9.9639439232989392388187494082157182942318205245312495135101112071350580399185692315980399296394374624e-01), SC_(-8.4842294485365166069416578907774941570466196515282748446774378575879582383083697138208072742660149228e-02), SC_(9.9999999999999999948135066223442903850088108602179111875339521803849547558149550399237088271541777499e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(2.8819222563924995483830571174621582031250000000000000000000000000000000000000000000000000000000000000e-09), SC_(9.9639439232989392414988229359049537613055280123374018742798807447555101508526357614351188811987695539e-01), SC_(-8.4842294485365162921917739773972179472558810834447100120810036583401463089726782446655405302908145962e-02), SC_(9.9999999999999999587715435435236904585317096941142380990419684706107557763821121747972577398325722789e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.7627768395841485471464693546295166015625000000000000000000000000000000000000000000000000000000000000e-09), SC_(9.9639439232989392468062794040441670620543891806999755338751939424992569122700438434854794391966968176e-01), SC_(-8.4842294485365156688800289961080533761648222791341579674658715133426521059651050734084635499987839930e-02), SC_(9.9999999999999998873962069750330806632308636752090210201932688470646854317990417102180074104808233431e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.8541334264391480246558785438537597656250000000000000000000000000000000000000000000000000000000000000e-09), SC_(9.9639439232989392673707121053352422625356658217303075116649624713930772691991989043739141933452360793e-01), SC_(-8.4842294485365132537773317739828555475213130005169271016524515948944002612718272119860347367172180994e-02), SC_(9.9999999999999996108431510609764651236371494824054117662546816297658586763352566792845768236493829823e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(2.3050326092288742074742913246154785156250000000000000000000000000000000000000000000000000000000000000e-08), SC_(9.9639439232989394345544773103454087558254312545678397195804342554904076873425142388506643460318002065e-01), SC_(-8.4842294485364936195881400136941483329506206563433540673929711896384660751069875919692598075783059576e-02), SC_(9.9999999999999973625350241968193877721855808037349566015638459946943206969335817353968027492126502282e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(5.9392490925347374286502599716186523437500000000000000000000000000000000000000000000000000000000000000e-08), SC_(9.9639439232989405405018011142524532736501430629105088193275242338258777437455697418975131684191221919e-01), SC_(-8.4842294485363637362889748125521896587673154302812261260150894089801952279281901044542974306036982431e-02), SC_(9.9999999999999824896174718081990331034461280315280962795240206768660204276304322993495136227955875483e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.1667648891489079687744379043579101562500000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.9639439232989442634500045409108731549010046464738105516502928086111610280466324094451263332286349668e-01), SC_(-8.4842294485359265104059019529370046157498710478206515609612241056089073719873849031215963836157014509e-02), SC_(9.9999999999999324229456786787708285791330553826966224546894562447049868987754673200814836010122411685e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(2.3799674409019644372165203094482421875000000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.9639439232989601464506713603381888542259911240503341675783382339161277310613605184904978207815355032e-01), SC_(-8.4842294485340611986655972919139731689757639273427541000107716774717614400759544871959901034018042843e-02), SC_(9.9999999999997188263716667439324205731591559804198846266833701690218952604787767494000497709598522931e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.6846594159433152526617050170898437500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.9639439232990202462390652698782609254008348156336889962480221504612347767144033019437727795000288797e-01), SC_(-8.4842294485270030335724459320249478221757594901193169180860648559415124811781045436362107593672631223e-02), SC_(9.9999999999989105969212577782282360468512833476252007017681875725911844408283469933768767175294955914e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.3826997726864647120237350463867187500000000000000000000000000000000000000000000000000000000000000000e-07), SC_(9.9639439232992641958585545262463099799848333149274561871563771543583526269224291176910216375332908961e-01), SC_(-8.4842294484983534037686783527835454992921912092660968995212001703740264338631718205138843401870012274e-02), SC_(9.9999999999956299320111678065381414005117728640827006034551068145838423608076432341954064670386808729e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.1039855962735600769519805908203125000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(9.9639439232993891194204703088677522512244399512487298590549937155560273073731965241606747269890480607e-01), SC_(-8.4842294484836822851575585886567413907326892374168197022264779245842189375666044735899310645141599057e-02), SC_(9.9999999999939499443691302955871808429687868700747141390968336493895645754611108621555597704991416291e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(3.2917760108830407261848449707031250000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(9.9639439233029389748956932327129091158075264859718512367948708207416066779749862612144734336172739459e-01), SC_(-8.4842294480667845443953102163404296318391883798145226147266545577967646060269205478578768927922719434e-02), SC_(9.9999999999462110451726763223295498660227375746905159152874896311796553700194885004383959875991323374e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(7.5172138167545199394226074218750000000000000000000000000000000000000000000000000000000000000000000000e-06), SC_(9.9639439233197978132686693916203190106576896483533805609341298516578495517691112332138923484292414188e-01), SC_(-8.4842294460868696775433694073450150907679394654211248232058407564229451823414329968769544117088087361e-02), SC_(9.9999999997194912839320992947154918460071662296190735712959073259087663139642400252423085776091530486e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.5114666894078254699707031250000000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.9639439233832664977629705536669831435426827137573865519655076721199119234036829353543026053815720129e-01), SC_(-8.4842294386330588454991996610694144597747353486819290842374731164755639767707663806305724394100907510e-02), SC_(9.9999999988659564978929333754573013725483609109446164465889782429126367311703263380098309270395970454e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(2.9863993404433131217956542968750000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.9639439236281443624753158687038454096577564270991214083469840809539610364509563625849219075623699280e-01), SC_(-8.4842294098744151302953238350800256832596089936119182803734993418583767146069333200039628065940693344e-02), SC_(9.9999999955728084199715672255718504172741717470542761906819535951864276950458540373205623386616537109e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(3.3870281185954809188842773437500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.9639439237223953724581982941629132748498983887981035908604585745857826395065250770878869942510011341e-01), SC_(-8.4842293988055044082583610914447143938044232971226932593724715633534115772196868151866529219226744951e-02), SC_(9.9999999943053090748253932656368900765792555269780716890189615989575800344105114676634210224581246448e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.0660119894891977310180664062500000000000000000000000000000000000000000000000000000000000000000000000e-05), SC_(9.9639439263328541366719031725241577314079198743209947847909476415592779981710088614620793535022214474e-01), SC_(-8.4842290922312241463028290901886236468697679576893295365022598381737118235652753487965129582714048961e-02), SC_(9.9999999591995330997524068647525151887288634403876011421441510310561160493295521892857438617062912841e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(2.1949532674625515937805175781250000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(9.9639439410826067431307822604787492127597668642195114647761391647693455985378034591691491702705577906e-01), SC_(-8.4842273600087509888806940837110422629864742105524848164093163940289071489404486929406333024041952399e-02), SC_(9.9999997608429891075272698981098375011760545789757386788033103243299232149774232751941797398008621709e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.3952150736004114151000976562500000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(9.9639439946057283654855935236752624035880191284049054750658244297828725656065644035418378639820004094e-01), SC_(-8.4842210742085271589035996870541465107472441820952998743617829037111050036348887366217833042583183538e-02), SC_(9.9999990410568885432730450661406780382747893720931957290008095471902273911676718477882188550504429360e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(6.3331518322229385375976562500000000000000000000000000000000000000000000000000000000000000000000000000e-04), SC_(9.9639440713495471434923143724675451317717484796503726041028796498492176802332554253832509916871965935e-01), SC_(-8.4842120613419993829653470484176332143015609165075405322937128639532532687627013454703366335136057687e-02), SC_(9.9999980089947286502621224734144392936772145074199619421807467791812848947570762271107897628498946539e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.1151232756674289703369140625000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.9639443823016524654104629623362614491579693467989253808727772715845343535280963682357379812867245026e-01), SC_(-8.4841755427344930663007460100028833354954911466256337396719760700291713295727386906732582556927571057e-02), SC_(9.9999938272528249391312307608807398374816383372852435374472406644589615977465186408873728224171642189e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.9624670967459678649902343750000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.9639453448794504753671533455904797532119598152365059838083231543209853813817276459987896643847885629e-01), SC_(-8.4840624953799622786068044598030741055063642230082296390150800205369862431346329264619378174286838014e-02), SC_(9.9999808822023431586330507223399599331299259546946802809286583619824066393501989056548364182611503082e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(5.5537540465593338012695312500000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.9639553077217003511353530043413808033920247930882092573188708783469515876938649937674371540560702420e-01), SC_(-8.4828923470981032069634272050225777540758810269842969047296062581637761984301166734820582381456553004e-02), SC_(9.9998468876732348097939012173864087757227234405891503826150435694363062945422284532826470182539791518e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.6911283433437347412109375000000000000000000000000000000000000000000000000000000000000000000000000000e-03), SC_(9.9639718000461594989260420944042571499940208837940453162707360749418854616064045702840166901838974039e-01), SC_(-8.4809549455523940355185466702194582862099119856342307034787941990006897379697771484768623427437519652e-02), SC_(9.9996250309238530117640656410289279207641184807525627009919430951232501378233250614276839898342947194e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(2.9933363199234008789062500000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.9642739273361037624425236003709998424423669985681772457419514437854858892669295864838396904074334791e-01), SC_(-8.4453839522542653735176696295242418341771308961936320935099661751459635173562095780038126996050284763e-02), SC_(9.9955509327307226870482882280431162855249849172060889261100838598526189994716425561466757382237089590e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(5.1242604851722717285156250000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.9649068766424200577985721184356752955601723188930074293915835068113130632428255591007970917819025182e-01), SC_(-8.3703700028410244770061826214701529976799484885620218724844567694731485856500558608813841851268272143e-02), SC_(9.9869544539219827767678663556107790796001205357457841120474538750514167458555525624218345986227679244e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.1201295256614685058593750000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9684313604934398930539235390129770939609825850290918420113575774717084081891501166979587762444196098e-01), SC_(-7.9396234868594807401272204725688142828934281134460946403103848657930854463427457876250364818746217174e-02), SC_(9.9374654270592187744997687020550454797638290050151265651320047733411371840069209832488090292039717367e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(2.3480379581451416015625000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9814934866490320978806688580871390672680066453416779059422743215014552518552147816785137038565167474e-01), SC_(-6.0810178094045119247364122651955570809342076623943187762098707626057061856818089052462136539473338148e-02), SC_(9.7214764923305873458032862854350162073206678556449933567459172269681798829001261625830288160524321418e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.8987305164337158203125000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9976967292952005755481095245256024937692734652402590999991494952154282866789560889911025306718779168e-01), SC_(2.1461619006973565646536174052546379410807514047370718515791347175325100002601713407336650423975813432e-02), SC_(8.7185717081396898541065289390703478456116878515433892820948672390341209634334005744800539221410270970e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(7.5183129310607910156250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.8539034324839560936682949899637621959818856082648192169501428326661400191997487509531927187367953439e-01), SC_(1.7031110190709553832350904690514019306839852576492774590778059270526592192267334810770243087477878657e-01), SC_(6.7167349511579774208520897966660216379314520347464078477957664271219777907511857160535742769433089892e-01) }},
      {{ SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.6557407379150390625000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(4.0815375315288640577475196367102453532926947422123146010409415723479279392954356853433706994064428463e-01), SC_(9.1291320167210457006284950226993895289063450955873095160130726593569036267152905012436288527918734100e-01), SC_(-7.3708797978087103688004545584461400336979146221355035197387826317949437602283858594803646637152865976e-01) }}
   }};
//#undef SC_

