// Copyright John Maddock 2025.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const std::array<std::array<T, 7>, 216> ibeta_large_asym_data = {{
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(1.9028755000000000000000000000000000000000e+06), SC_(4.4999998807907104492187500000000000000000e-01), SC_(6.7345257302164224681015863169909954819429e-1153957), SC_(1.5954073231380415067243088463626848362274e-1145648), SC_(4.2211951973306332397251065526138530932813e-8309), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(2.3812680000000000000000000000000000000000e+06), SC_(4.3972539901733398437500000000000000000000e-01), SC_(6.8182153543183326515176359239213424241007e-1278111), SC_(8.7872964934870212072663237910183403621465e-1278035), SC_(7.7591729826936709829482073357324976283268e-77), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(7.9934700000000000000000000000000000000000e+06), SC_(1.9226138293743133544921875000000000000000e-01), SC_(9.9067809076337205020226204324704297621190e-2103896), SC_(1.2658599881338445200823176947439963560657e-2103895), SC_(4.3902564730816430949562878362500765540572e-01), SC_(5.6097435269183569050437121637499234459428e-01) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(1.5393168000000000000000000000000000000000e+07), SC_(1.1001686006784439086914062500000000000000e-01), SC_(3.0709384592321328069793224227070303132484e-2603162), SC_(3.1427207567895459654869249145913055789048e-2603162), SC_(4.9422383051098736680545332614875134887372e-01), SC_(5.0577616948901263319454667385124865112628e-01) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(1.8907696000000000000000000000000000000000e+07), SC_(9.1437831521034240722656250000000000000000e-02), SC_(2.0420460469102022545138913384686152410490e-2764269), SC_(2.0462559304440475118318579715281013896173e-2764269), SC_(4.9948513055577052930631242831720019446330e-01), SC_(5.0051486944422947069368757168279980553670e-01) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(6.6064240000000000000000000000000000000000e+07), SC_(2.7997003868222236633300781250000000000000e-02), SC_(1.5774679601689457701293713337946112843357e-3769687), SC_(1.5767088254989601689348312809270469665752e-3769687), SC_(5.0012033800284039124664276046170731990251e-01), SC_(4.9987966199715960875335723953829268009749e-01) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(1.2840448000000000000000000000000000000000e+08), SC_(1.4617582783102989196777343750000000000000e-02), SC_(1.2272989543515196592379719361127742228658e-4313187), SC_(1.1011430443339915966266513371237709561213e-4313188), SC_(9.1766620847363110463334708486842706468688e-01), SC_(8.2333791526368895366652915131572935313120e-02) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(1.6388441600000000000000000000000000000000e+08), SC_(1.2625593692064285278320312500000000000000e-02), SC_(2.2379905591363438077718248053802504138894e-4513497), SC_(1.2306617078599706585561478539321573698236e-4517423), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.4989584421432573401578165749458187966298e-3927) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(4.3818304000000000000000000000000000000000e+08), SC_(4.3239160440862178802490234375000000000000e-03), SC_(2.1351052162080738377752158329364831082938e-5323262), SC_(2.0876657782441229043598198786249387838491e-5323262), SC_(5.0561709811238592429363082896628831418203e-01), SC_(4.9438290188761407570636917103371168581797e-01) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(7.0231680000000000000000000000000000000000e+08), SC_(2.7021053247153759002685546875000000000000e-03), SC_(1.7171753658340205536597508835090813960451e-5712445), SC_(1.7160489432345209932774457020612746553550e-5712445), SC_(5.0016404733540482924881125749617034624668e-01), SC_(4.9983595266459517075118874250382965375332e-01) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(1.1784750080000000000000000000000000000000e+09), SC_(1.6120901564136147499084472656250000000000e-03), SC_(4.4528130280243712434575052875990444930800e-6139736), SC_(4.4507560572119092841812213188918101812581e-6139736), SC_(5.0011551383455162868187758358483146394170e-01), SC_(4.9988448616544837131812241641516853605830e-01) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(3.3226301440000000000000000000000000000000e+09), SC_(5.1513640210032463073730468750000000000000e-04), SC_(6.1227243528801362601263162508127393370932e-7000342), SC_(4.6306591220351569534527518404998617242648e-6995907), SC_(1.3222144389218661275155255990656824473730e-4435), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(5.4911078400000000000000000000000000000000e+09), SC_(3.4295339719392359256744384765625000000000e-04), SC_(2.6149108484367269736237820382089470752852e-7411022), SC_(3.7248296633465956938312661632485346466848e-7410979), SC_(7.0202159152892498671644211451960469438267e-44), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(1.0208120832000000000000000000000000000000e+10), SC_(1.8635463493410497903823852539062500000000e-04), SC_(9.2748555649264491893525898280981783335603e-7923331), SC_(1.1556342762635367611762646503508689369005e-7923330), SC_(4.4523869530130975886731984520101623889977e-01), SC_(5.5476130469869024113268015479898376110023e-01) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(2.6575216640000000000000000000000000000000e+10), SC_(7.1597540227230638265609741210937500000000e-05), SC_(4.6276736624195611675530268686084230968335e-8713987), SC_(4.7293318011006872829167186573859413979977e-8713987), SC_(4.9456780595686000753719434572816230736847e-01), SC_(5.0543219404313999246280565427183769263153e-01) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(6.8474880000000000000000000000000000000000e+10), SC_(2.7788595616584643721580505371093750000000e-05), SC_(1.9961080344733652118397772544625551064161e-9496154), SC_(1.9996632325188685070655211837751330538841e-9496154), SC_(4.9955512993513021760290705811696850552580e-01), SC_(5.0044487006486978239709294188303149447420e-01) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(1.3451883315200000000000000000000000000000e+11), SC_(1.4145593013381585478782653808593750000000e-05), SC_(1.7802207917710567492358760459317641530120e-10054170), SC_(1.7793621662538154355941990724670419045647e-10054170), SC_(5.0012060760029564593906902888483559886994e-01), SC_(4.9987939239970435406093097111516440113006e-01) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(2.7439156428800000000000000000000000000000e+11), SC_(6.9417778831848409026861190795898437500000e-06), SC_(5.1498173848455335180334842326780925784369e-10643274), SC_(4.7162291027388222554886517100796076759608e-10643275), SC_(9.1610283387989561791260098861862134587185e-01), SC_(8.3897166120104382087399011381378654128150e-02) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(5.4010445824000000000000000000000000000000e+11), SC_(3.8754646993766073137521743774414062500000e-06), SC_(1.3881076254193924371200087146474294833952e-11202921), SC_(7.5711059271845288998190054758937238577325e-11206800), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.4542643441621118418855248447818265689195e-3879) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(1.0817516339200000000000000000000000000000e+12), SC_(1.7590832612768281251192092895507812500000e-06), SC_(3.6772333809533645557755250995091540910167e-11776923), SC_(3.5957399673152117619500596891305185785393e-11776923), SC_(5.0560248262545560791996817742161318129120e-01), SC_(4.9439751737454439208003182257838681870880e-01) }, 
      { SC_(1.9028755000000000000000000000000000000000e+06), SC_(1.2728087347200000000000000000000000000000e+12), SC_(1.4950186368878348730504512786865234375000e-06), SC_(8.7426884581369101298023785104687130896670e-11911334), SC_(8.7380599673087001814241395987917522701361e-11911334), SC_(5.0013238823406074964018234911849650065137e-01), SC_(4.9986761176593925035981765088150349934863e-01) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(1.9028755000000000000000000000000000000000e+06), SC_(5.5583292245864868164062500000000000000000e-01), SC_(4.3935276310388312510238078544989597454643e-1278035), SC_(4.3937688624481899562425159365193806166822e-1278035), SC_(4.9998627385513067065623722003879892278745e-01), SC_(5.0001372614486932934376277996120107721255e-01) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(2.3812680000000000000000000000000000000000e+06), SC_(4.4999998807907104492187500000000000000000e-01), SC_(4.5221069700471147968135939224937236509789e-1444066), SC_(1.4783295654065370262831934073840562017973e-1433669), SC_(3.0589302114130054654341777662643761052713e-10397), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(7.9934700000000000000000000000000000000000e+06), SC_(2.2723035514354705810546875000000000000000e-01), SC_(9.8761355384028798154568169931415324504496e-2427300), SC_(1.1724212308990434807444743750283216404172e-2427230), SC_(8.4237092250791116712910030639025307589294e-70), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(1.5393168000000000000000000000000000000000e+07), SC_(1.3395811617374420166015625000000000000000e-01), SC_(8.1371310060783079316903184433500805998719e-3040399), SC_(1.0601714062504520983057644616907686491967e-3040398), SC_(4.3423866179036072297694471386694200205101e-01), SC_(5.6576133820963927702305528613305799794899e-01) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(1.8907696000000000000000000000000000000000e+07), SC_(1.1185345798730850219726562500000000000000e-01), SC_(1.7987736724254806309946776808865846376324e-3239461), SC_(1.8457633578563132960515199026525442649307e-3239461), SC_(4.9355340815028027796029154913140179427153e-01), SC_(5.0644659184971972203970845086859820572847e-01) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(6.6064240000000000000000000000000000000000e+07), SC_(3.4790679812431335449218750000000000000000e-02), SC_(5.8610359800492490130189506957543215537233e-4489140), SC_(5.8729944316146225646673601843131502231818e-4489140), SC_(4.9949043716669224750127278155856984273401e-01), SC_(5.0050956283330775249872721844143015726599e-01) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(1.2840448000000000000000000000000000000000e+08), SC_(1.8207397311925888061523437500000000000000e-02), SC_(5.0425212280790481304249820816925099781849e-5167519), SC_(5.0404283496123721648252818294024846307457e-5167519), SC_(5.0010378304733896866680889921830851784316e-01), SC_(4.9989621695266103133319110078169148215684e-01) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(1.6388441600000000000000000000000000000000e+08), SC_(1.4336388558149337768554687500000000000000e-02), SC_(1.7767528734811402715695898442966249753902e-5417778), SC_(1.1356498789439435786130694695684836764265e-5417779), SC_(9.3992280863719073113829860025252510538100e-01), SC_(6.0077191362809268861701399747474894618996e-02) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(4.3818304000000000000000000000000000000000e+08), SC_(5.9455446898937225341796875000000000000000e-03), SC_(2.0215895435885787524042639988473788050187e-6430188), SC_(3.3753558983745556558331505265830332115858e-6435069), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.6696544108468573265421915616738322032613e-4881) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(7.0231680000000000000000000000000000000000e+08), SC_(3.3791661262512207031250000000000000000000e-03), SC_(3.3520344438456633828467421979624992000583e-6917003), SC_(3.2691459369742232752241099942413668122531e-6917003), SC_(5.0625934516989976645497385646209642949456e-01), SC_(4.9374065483010023354502614353790357050544e-01) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(1.1784750080000000000000000000000000000000e+09), SC_(2.0165606401860713958740234375000000000000e-03), SC_(5.9920171229818680094886805586423618536004e-7451575), SC_(5.9881734124623081927969516648284114160395e-7451575), SC_(5.0016041942355540790700260390555165757828e-01), SC_(4.9983958057644459209299739609444834242172e-01) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(3.3226301440000000000000000000000000000000e+09), SC_(7.1616837522014975547790527343750000000000e-04), SC_(8.8819564650817643342391378836560938066335e-8522857), SC_(8.8787101678759960636552750577340026375339e-8522857), SC_(5.0009139007202984842895622828391707248490e-01), SC_(4.9990860992797015157104377171608292751510e-01) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(5.4911078400000000000000000000000000000000e+09), SC_(3.9012386696413159370422363281250000000000e-04), SC_(6.2373533252747285577975132944828287365672e-9047799), SC_(2.0751769262857731407929352105792930760024e-9042250), SC_(3.0056971269618776830758360910905914351216e-5549), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(1.0208120832000000000000000000000000000000e+10), SC_(2.3088535817805677652359008789062500000000e-04), SC_(3.3619885012555639714367949531494576428820e-9683442), SC_(1.5254321698391257193206675986893539457331e-9683388), SC_(2.2039580439752520339260591785785338494540e-54), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(2.6575216640000000000000000000000000000000e+10), SC_(8.9587847469374537467956542968750000000000e-05), SC_(2.5418690846106363159758961355260460229203e-10672805), SC_(3.2517002227559251464769756767308102968499e-10672805), SC_(4.3873973879601872788757449315770199186918e-01), SC_(5.6126026120398127211242550684229800813082e-01) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(6.8474880000000000000000000000000000000000e+10), SC_(3.4774231608025729656219482421875000000000e-05), SC_(9.1185403896314100854266750249388393915614e-11651608), SC_(9.3430833578967426828189807343601207192371e-11651608), SC_(4.9391865603654183170439854078431146530582e-01), SC_(5.0608134396345816829560145921568853469418e-01) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(1.3451883315200000000000000000000000000000e+11), SC_(1.7701784599921666085720062255859375000000e-05), SC_(4.3465633482871862897395924306595349404646e-12349910), SC_(4.3560348604756843683598920081032647295298e-12349910), SC_(4.9945582273470002506616382454194075763648e-01), SC_(5.0054417726529997493383617545805924236352e-01) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(2.7439156428800000000000000000000000000000e+11), SC_(8.6782820289954543113708496093750000000000e-06), SC_(1.2794420684801693738026258657203155971247e-13087116), SC_(1.2789395114151201798734998430218277750293e-13087116), SC_(5.0009821776958497386893052497996457304866e-01), SC_(4.9990178223041502613106947502003542695134e-01) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(5.4010445824000000000000000000000000000000e+11), SC_(4.4132925722806248813867568969726562500000e-06), SC_(9.6562267341232990060948595996263940358052e-13787462), SC_(6.3185489329805070259310926326000045068521e-13787463), SC_(9.3858379859526623835344662271415830046270e-01), SC_(6.1416201404733761646553377285841699537296e-02) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(1.0817516339200000000000000000000000000000e+12), SC_(2.4214330096583580598235130310058593750000e-06), SC_(1.3910953068816099436510223376105936614661e-14505769), SC_(2.9016239420783003724394405060556720852007e-14510622), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.0858556043746648445685453921827416337628e-4853) }, 
      { SC_(2.3812680000000000000000000000000000000000e+06), SC_(1.2728087347200000000000000000000000000000e+12), SC_(1.8708918787524453364312648773193359375000e-06), SC_(5.6914049465129517904232404905099031907665e-14673972), SC_(5.5500903406721815785554958996048715352383e-14673972), SC_(5.0628540075099543726005914130829581503654e-01), SC_(4.9371459924900456273994085869170418496346e-01) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(1.9028755000000000000000000000000000000000e+06), SC_(8.0771946907043457031250000000000000000000e-01), SC_(1.1287975577146258460653183024413332901643e-2103895), SC_(1.1277405211825907242192614355497060421133e-2103895), SC_(5.0023421641804327578988334988033403307113e-01), SC_(4.9976578358195672421011665011966596692887e-01) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(2.3812680000000000000000000000000000000000e+06), SC_(7.7047437429428100585937500000000000000000e-01), SC_(5.8606858930176395256522811899834777507781e-2427231), SC_(5.8635264159727952817924625602997386533937e-2427231), SC_(4.9987886081894910891708900535396525433826e-01), SC_(5.0012113918105089108291099464603474566174e-01) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(7.9934700000000000000000000000000000000000e+06), SC_(4.4999998807907104492187500000000000000000e-01), SC_(4.5774172462565559973937395297460772023279e-4847445), SC_(4.1625257831471455911507096888411282427630e-4812552), SC_(1.0996730073815242389935501346897215803348e-34893), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(1.5393168000000000000000000000000000000000e+07), SC_(3.3837848901748657226562500000000000000000e-01), SC_(5.8207355032448255546093595063834288675262e-6523097), SC_(1.8788777516948984417548866616957635705465e-6522830), SC_(3.0979852190990367703160734857520933897284e-267), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(1.8907696000000000000000000000000000000000e+07), SC_(2.9711243510246276855468750000000000000000e-01), SC_(2.8930188036834442051532352134659923128136e-7108231), SC_(4.9677237746601350139852178853319619177242e-7108231), SC_(3.6803377986880509273551965181215474818851e-01), SC_(6.3196622013119490726448034818784525181149e-01) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(6.6064240000000000000000000000000000000000e+07), SC_(1.0793460905551910400390625000000000000000e-01), SC_(9.2337468991475783694429632422604668441705e-11005410), SC_(9.6845536325241441109318719603031170535757e-11005410), SC_(4.8808543260474544218555839433440876364428e-01), SC_(5.1191456739525455781444160566559123635572e-01) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(1.2840448000000000000000000000000000000000e+08), SC_(5.8603972196578979492187500000000000000000e-02), SC_(1.7315979303231350198394090504700815795010e-13216288), SC_(1.7397119004851874331960703602806768692184e-13216288), SC_(4.9883128119391131818790016942024697681123e-01), SC_(5.0116871880608868181209983057975302318877e-01) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(1.6388441600000000000000000000000000000000e+08), SC_(4.6506680548191070556640625000000000000000e-02), SC_(2.6129889364943266749555607254199189597462e-14040694), SC_(2.6126267325017473829308405855403250475932e-14040694), SC_(5.0003465658551281071491839332541651442302e-01), SC_(4.9996534341448718928508160667458348557698e-01) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(4.3818304000000000000000000000000000000000e+08), SC_(1.7933404073119163513183593750000000000000e-02), SC_(1.0185002217751470220559665710211030478435e-17403003), SC_(2.2159528500223049281154355139732497620226e-17403006), SC_(9.9782902151929153640271991960722465226262e-01), SC_(2.1709784807084635972800803927753477373791e-03) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(7.0231680000000000000000000000000000000000e+08), SC_(1.2378840707242488861083984375000000000000e-02), SC_(1.6666596116953296261714618077559101793824e-19028893), SC_(6.7690676109408279316023834198199076051630e-19045375), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.0614577586453410651302662790325700153016e-16482) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(1.1784750080000000000000000000000000000000e+09), SC_(6.7372629418969154357910156250000000000000e-03), SC_(2.7626841189845732154448967922823168921349e-20817790), SC_(2.6396517219688270181302191829236085864277e-20817790), SC_(5.1138696303209034954088168176549195263597e-01), SC_(4.8861303696790965045911831823450804736403e-01) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(3.3226301440000000000000000000000000000000e+09), SC_(2.3999924305826425552368164062500000000000e-03), SC_(2.8308510653386571573660779769862329107008e-24408569), SC_(2.8279819162774867094688687750746352128795e-24408569), SC_(5.0025351066823243018509507766755659691314e-01), SC_(4.9974648933176756981490492233244340308686e-01) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(5.4911078400000000000000000000000000000000e+09), SC_(1.4535957016050815582275390625000000000000e-03), SC_(2.1051858588354566837526161416424553322276e-26150921), SC_(2.1047587023813609384786285314871742671735e-26150921), SC_(5.0005073183837512132037453009624396966810e-01), SC_(4.9994926816162487867962546990375603033190e-01) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(1.0208120832000000000000000000000000000000e+10), SC_(7.0419360417872667312622070312500000000000e-04), SC_(3.3556063100083385892093945383675646602616e-28320908), SC_(1.3669375717679248839558329499636845058523e-28302282), SC_(2.4548350848739745712401962248453838612832e-18626), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(2.6575216640000000000000000000000000000000e+10), SC_(2.9768922831863164901733398437500000000000e-04), SC_(4.0504803328129121912015097220741738820084e-31623157), SC_(1.7892681512623346133463025077541767376451e-31622980), SC_(2.2637637237075308618933264820354925212450e-177), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(6.8474880000000000000000000000000000000000e+10), SC_(1.1671050015138462185859680175781250000000e-04), SC_(5.2635689021721350921670906596852089766261e-34908413), SC_(8.2780438105554161632691978264086421030346e-34908413), SC_(3.8869586760703830456044817379946141031984e-01), SC_(6.1130413239296169543955182620053858968016e-01) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(1.3451883315200000000000000000000000000000e+11), SC_(5.9418554883450269699096679687500000000000e-05), SC_(5.4681192671870616308758111492364269230261e-37252413), SC_(5.7208171960290676023740706131098855974643e-37252413), SC_(4.8870768773811720706002629430841993169794e-01), SC_(5.1129231226188279293997370569158006830206e-01) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(2.7439156428800000000000000000000000000000e+11), SC_(2.9130738766980357468128204345703125000000e-05), SC_(4.1492151437283326985477572099117265926446e-39727040), SC_(4.1675974627698964675533002158299242792885e-39727040), SC_(4.9889486995130796909046306202052191924303e-01), SC_(5.0110513004869203090953693797947808075697e-01) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(5.4010445824000000000000000000000000000000e+11), SC_(1.4799640666751656681299209594726562500000e-05), SC_(9.1495200721650000378484606628413839884212e-42077951), SC_(9.1467407563939493550838450844552467645400e-42077951), SC_(5.0007595310859124834937936803182074447546e-01), SC_(4.9992404689140875165062063196817925552454e-01) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(1.0817516339200000000000000000000000000000e+12), SC_(7.3967112257378175854682922363281250000000e-06), SC_(3.2777070324570827494818913917777752172960e-44489166), SC_(7.7306485278634049430731269045637306575103e-44489169), SC_(9.9764699584088722615940502241452864910598e-01), SC_(2.3530041591127738405949775854713508940195e-03) }, 
      { SC_(7.9934700000000000000000000000000000000000e+06), SC_(1.2728087347200000000000000000000000000000e+12), SC_(6.9081565925444010645151138305664062500000e-06), SC_(9.8830085864725315646649020107298097777291e-45053788), SC_(1.6614377104921221485358172076003563816451e-45070071), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.6811051978303771773998420682310189946361e-16284) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(1.9028755000000000000000000000000000000000e+06), SC_(8.8999092578887939453125000000000000000000e-01), SC_(3.3985683020080401758864207812563938843774e-2603162), SC_(2.8150909140136385965798265560419420077758e-2603162), SC_(5.4695118992766193334955429035783492673978e-01), SC_(4.5304881007233806665044570964216507326022e-01) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(2.3812680000000000000000000000000000000000e+06), SC_(8.6602860689163208007812500000000000000000e-01), SC_(9.3788102858471976330191934883922428916665e-3040399), SC_(9.3600347827356312817287695718655242001721e-3040399), SC_(5.0050097812973129764848473647714595635709e-01), SC_(4.9949902187026870235151526352285404364291e-01) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(7.9934700000000000000000000000000000000000e+06), SC_(6.5820354223251342773437500000000000000000e-01), SC_(9.3939542679948083573103056846968247171284e-6522831), SC_(9.3948232489541760602385609322608109883366e-6522831), SC_(4.9997687500002105479189219928858215441442e-01), SC_(5.0002312499997894520810780071141784558558e-01) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(1.5393168000000000000000000000000000000000e+07), SC_(4.4999998807907104492187500000000000000000e-01), SC_(1.0116587413863319660658543376128435000268e-9334805), SC_(2.3086126058554727189057784152551903396425e-9267614), SC_(4.3821069798388918906902431179501915625354e-67192), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(1.8907696000000000000000000000000000000000e+07), SC_(4.4428139925003051757812500000000000000000e-01), SC_(7.5287646710784410915367924857184568724156e-10247869), SC_(1.4633075597385418432376021824028689527526e-10247259), SC_(5.1450323077833697211356019942885946069726e-610), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(6.6064240000000000000000000000000000000000e+07), SC_(1.8895308673381805419921875000000000000000e-01), SC_(2.1721082452169325556795465984046879697896e-17148017), SC_(4.3790862253642763049248973263932203342662e-17148017), SC_(3.3155911566524256451216810431302483254984e-01), SC_(6.6844088433475743548783189568697516745016e-01) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(1.2840448000000000000000000000000000000000e+08), SC_(1.0704635083675384521484375000000000000000e-01), SC_(6.4780764372034207022001867816351736716246e-21251755), SC_(6.9228384172985039213078357621997327247031e-21251755), SC_(4.8340553667701018289015127432241952408324e-01), SC_(5.1659446332298981710984872567758047591676e-01) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(1.6388441600000000000000000000000000000000e+08), SC_(8.5862115025520324707031250000000000000000e-02), SC_(4.8119807411066392428579415532730405220585e-22801749), SC_(4.8431655367888748793403654310749659789216e-22801749), SC_(4.9838506870923177578866741660897463300111e-01), SC_(5.0161493129076822421133258339102536699889e-01) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(4.3818304000000000000000000000000000000000e+08), SC_(3.3937335014343261718750000000000000000000e-02), SC_(1.3688855426791688467782278033647774388919e-29187952), SC_(1.3688650709722251891506952282392661977036e-29187952), SC_(5.0000373878227651168214339144828192380375e-01), SC_(4.9999626121772348831785660855171807619625e-01) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(7.0231680000000000000000000000000000000000e+08), SC_(2.1469065919518470764160156250000000000000e-02), SC_(3.5015390129095138350092061494692135279376e-32298326), SC_(1.2832209311035240799929427080030485160111e-32298330), SC_(9.9996335400229837759787274745969513039370e-01), SC_(3.6645997701622402127252540304869606302947e-05) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(1.1784750080000000000000000000000000000000e+09), SC_(1.4182876795530319213867187500000000000000e-02), SC_(1.2635519358016564168359106442573420214371e-35729254), SC_(7.3388350151803745424128113745545132024592e-35761047), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.8080992219162519279779253706069931863032e-31793) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(3.3226301440000000000000000000000000000000e+09), SC_(4.6115079894661903381347656250000000000000e-03), SC_(2.0689550391155581412891748270807377705614e-42630658), SC_(1.9434426394885190275054073730172209200649e-42630658), SC_(5.1564057325328544955924849502417938203942e-01), SC_(4.8435942674671455044075150497582061796058e-01) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(5.4911078400000000000000000000000000000000e+09), SC_(2.7954536490142345428466796875000000000000e-03), SC_(2.4355508010798376422654260477192790590727e-45983008), SC_(2.4348886487615905964585986004269690480476e-45983008), SC_(5.0006797665026598412604678654764823835972e-01), SC_(4.9993202334973401587395321345235176164028e-01) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(1.0208120832000000000000000000000000000000e+10), SC_(1.5056631527841091156005859375000000000000e-03), SC_(1.0085888133516399605656207562548957736766e-50123846), SC_(1.0083203190431839685146619210222214205530e-50123846), SC_(5.0006656083413564325882735005831605838830e-01), SC_(4.9993343916586435674117264994168394161170e-01) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(2.6575216640000000000000000000000000000000e+10), SC_(5.2100542234256863594055175781250000000000e-04), SC_(3.0164725749639068550095623218842806787844e-56552941), SC_(5.5812536843500838761662354359006164097132e-56517083), SC_(5.4046505419062738913949588512381556906795e-35859), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(6.8474880000000000000000000000000000000000e+10), SC_(2.2250220354180783033370971679687500000000e-04), SC_(1.3014251292351578664705540085701954236318e-62843667), SC_(4.8372889346947431259740676135378632877247e-62843329), SC_(2.6904018899943677512657575424755035629207e-339), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(1.3451883315200000000000000000000000000000e+11), SC_(1.1440678645158186554908752441406250000000e-04), SC_(4.9890926560185791420378682231910113240525e-67357035), SC_(9.3719703265408603547197397632643831073282e-67357035), SC_(3.4740413450435402789735081249505969015580e-01), SC_(6.5259586549564597210264918750494030984420e-01) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(2.7439156428800000000000000000000000000000e+11), SC_(5.6095566833391785621643066406250000000000e-05), SC_(7.7076580412535150630286967756379699186643e-72122375), SC_(8.2054138408454450628480326749400185312019e-72122375), SC_(4.8436015989622126943118234542011985403043e-01), SC_(5.1563984010377873056881765457988014596957e-01) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(5.4010445824000000000000000000000000000000e+11), SC_(2.8499511245172470808029174804687500000000e-05), SC_(3.8591086905497970246166471931066256355972e-76649521), SC_(3.8841274579695978021278284936387788944616e-76649521), SC_(4.9838447601623355605350178802779059422807e-01), SC_(5.0161552398376644394649821197220940577193e-01) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(1.0817516339200000000000000000000000000000e+12), SC_(1.4229651242203544825315475463867187500000e-05), SC_(1.8803592672888027075451929200531771486128e-81292819), SC_(1.8804708543587510201392113276154097150069e-81292819), SC_(4.9998516456921225834903889356046875751064e-01), SC_(5.0001483543078774165096110643953124248936e-01) }, 
      { SC_(1.5393168000000000000000000000000000000000e+07), SC_(1.2728087347200000000000000000000000000000e+12), SC_(1.2105806490581016987562179565429687500000e-05), SC_(1.7981779928259559975950938291909266918009e-82380117), SC_(7.8770054595318877022479035517206989752698e-82380122), SC_(9.9995619643633696643851528879965589462494e-01), SC_(4.3803563663033561484711200344105375061408e-05) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(1.9028755000000000000000000000000000000000e+06), SC_(9.9941831827163696289062500000000000000000e-01), SC_(4.0883019773542497663457493099967166306663e-2764269), SC_(1.0099358145896921267860756601863121428727e-6161185), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4703063036534142587846081105713055378831e-3396917) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(2.3812680000000000000000000000000000000000e+06), SC_(8.8815432786941528320312500000000000000000e-01), SC_(2.0109529996662423875478190434146410918104e-3239461), SC_(1.6335840306155515394983785401244878107528e-3239461), SC_(5.5177186648334217267038382803775114265435e-01), SC_(4.4822813351665782732961617196224885734565e-01) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(7.9934700000000000000000000000000000000000e+06), SC_(7.0285791158676147460937500000000000000000e-01), SC_(3.9319837680605021998072150882919170615096e-7108231), SC_(3.9287588102830770193312380105060371690282e-7108231), SC_(5.0020513060600088660282259615709495257329e-01), SC_(4.9979486939399911339717740384290504742671e-01) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(1.5393168000000000000000000000000000000000e+07), SC_(5.5123090744018554687500000000000000000000e-01), SC_(7.3172483419184734326395241069802961389439e-10247260), SC_(7.3158272554669449997364977170483933885823e-10247260), SC_(5.0004855733991363876896967900470529932326e-01), SC_(4.9995144266008636123103032099529470067674e-01) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(1.8907696000000000000000000000000000000000e+07), SC_(4.4999998807907104492187500000000000000000e-01), SC_(9.5580363687643366173861264122021155674189e-11466103), SC_(4.1830579409122766118536031217576311708286e-11383571), SC_(2.2849399897816952794154400129001786985683e-82532), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(6.6064240000000000000000000000000000000000e+07), SC_(2.2029179334640502929687500000000000000000e-01), SC_(2.1194143997287339003136906036084816522717e-19561817), SC_(1.0691259161705949042232425463065188483300e-19561284), SC_(1.9823805294329334017949841544686677645366e-533), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(1.2840448000000000000000000000000000000000e+08), SC_(1.2833838164806365966796875000000000000000e-01), SC_(2.0586979784947911312087952798334228059483e-24518521), SC_(4.3585453256296390770607275296334352585615e-24518521), SC_(3.2080721907047596992988962184671444789065e-01), SC_(6.7919278092952403007011037815328555210935e-01) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(1.6388441600000000000000000000000000000000e+08), SC_(1.0343721508979797363281250000000000000000e-01), SC_(2.0745380665532377817622073996984901789761e-26401478), SC_(2.2319900015678860254939119461173864617490e-26401478), SC_(4.8171938827240219798924232573972242240952e-01), SC_(5.1828061172759780201075767426027757759048e-01) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(4.3818304000000000000000000000000000000000e+08), SC_(4.1365258395671844482421875000000000000000e-02), SC_(1.8820829948228717803052822009215625701098e-34195507), SC_(1.8957398815254320788282878074635454395191e-34195507), SC_(4.9819249245536873407182611125195041879706e-01), SC_(5.0180750754463126592817388874804958120294e-01) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(7.0231680000000000000000000000000000000000e+08), SC_(2.6216102764010429382324218750000000000000e-02), SC_(4.1706681316088765233196056723014040671285e-38004155), SC_(4.1709490147370449585087947019285622493772e-38004155), SC_(4.9998316374851299204261853167869298403522e-01), SC_(5.0001683625148700795738146832130701596478e-01) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(1.1784750080000000000000000000000000000000e+09), SC_(1.5806647017598152160644531250000000000000e-02), SC_(2.5983531445195627673900027144672125161694e-42210333), SC_(1.5266863748307097131423278621733785682320e-42210338), SC_(9.9999412444221480533894792293677583138851e-01), SC_(5.8755577851946610520770632241686114866716e-06) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(3.3226301440000000000000000000000000000000e+09), SC_(6.2242196872830390930175781250000000000000e-03), SC_(2.5669745110408335821152649850223033506656e-50679648), SC_(1.3938970613485564458499658551502009699326e-50718395), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.4301164867561216508870306615028293544151e-38748) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(5.4911078400000000000000000000000000000000e+09), SC_(3.4315485972911119461059570312500000000000e-03), SC_(1.0438006144217442902258348158210545188305e-54795692), SC_(9.7322757558274507073012908697208006211711e-54795693), SC_(5.1749431147981182725509846549083760078565e-01), SC_(4.8250568852018817274490153450916239921435e-01) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(1.0208120832000000000000000000000000000000e+10), SC_(1.8487968482077121734619140625000000000000e-03), SC_(4.0026218527756392325342857561392112471387e-59880746), SC_(3.9990342416645752573409294561685294335100e-59880746), SC_(5.0022417928668271263825582379673917903897e-01), SC_(4.9977582071331728736174417620326082096103e-01) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(2.6575216640000000000000000000000000000000e+10), SC_(7.1097270119935274124145507812500000000000e-04), SC_(1.4729340008570018729590833320431021057465e-67732800), SC_(1.4725295522244738598063413400543238097214e-67732800), SC_(5.0006865619370928700901825312641168059735e-01), SC_(4.9993134380629071299098174687358831940265e-01) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(6.8474880000000000000000000000000000000000e+10), SC_(2.4844481959007680416107177734375000000000e-04), SC_(1.4701455468790505965210780144929707687217e-75547138), SC_(2.7752362689743463542103618548610813474511e-75503106), SC_(5.2973707619581426125972987790173692150651e-44033), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(1.3451883315200000000000000000000000000000e+11), SC_(1.3913285511080175638198852539062500000000e-04), SC_(2.7829278613238336022924514416009753557398e-81047681), SC_(7.3945346291298428836344605116360174846515e-81047266), SC_(3.7634929050989062927260299653818539193049e-416), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(2.7439156428800000000000000000000000000000e+11), SC_(6.8896079028490930795669555664062500000000e-05), SC_(1.2874033156678136109777744877606661420347e-86900561), SC_(2.5916265579829862149364658945708081865176e-86900561), SC_(3.3188796106284097794444734581663422753601e-01), SC_(6.6811203893715902205555265418336577246399e-01) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(5.4010445824000000000000000000000000000000e+11), SC_(3.5005905374418944120407104492187500000000e-05), SC_(3.8207509858206101211297067882655422892658e-92461308), SC_(4.0940375217382417593055737482363558895223e-92461308), SC_(4.8273570192958187737373421052762599858798e-01), SC_(5.1726429807041812262626578947237400141202e-01) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(1.0817516339200000000000000000000000000000e+12), SC_(1.7478452718933112919330596923828125000000e-05), SC_(7.7538584668710206647812168853404960071679e-98164739), SC_(7.8121330554594245703060717047439167933588e-98164739), SC_(4.9812814402138131866872006042040867705646e-01), SC_(5.0187185597861868133127993957959132294354e-01) }, 
      { SC_(1.8907696000000000000000000000000000000000e+07), SC_(1.2728087347200000000000000000000000000000e+12), SC_(1.4854876098979730159044265747070312500000e-05), SC_(2.8463788631086554005188152206898006210555e-99500284), SC_(2.8450663544032633982268628701405456254799e-99500284), SC_(5.0011530539741940805989143177061107175202e-01), SC_(4.9988469460258059194010856822938892824798e-01) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(1.9028755000000000000000000000000000000000e+06), SC_(9.7297507524490356445312500000000000000000e-01), SC_(3.1541767856679059390642026147216582509108e-3769687), SC_(1.2724733397428529319593420705595573733349e-3770213), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.0342486366800238482806442390815941154651e-527) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(7.9934700000000000000000000000000000000000e+06), SC_(9.8127073049545288085937500000000000000000e-01), SC_(1.8918300531671722480374835202563583897746e-11005409), SC_(4.0265420446512730722423420557173386671794e-14351024), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1283846495145334419182768117476790258718e-3345615) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(1.5393168000000000000000000000000000000000e+07), SC_(8.1103610992431640625000000000000000000000e-01), SC_(3.7603192757483992096237397774804069777765e-17148017), SC_(2.7908751948328096509807041473175013262794e-17148017), SC_(5.7398987202020751646354109509972426485700e-01), SC_(4.2601012797979248353645890490027573514300e-01) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(1.8907696000000000000000000000000000000000e+07), SC_(7.7748316526412963867187500000000000000000e-01), SC_(5.3562810266290404551739304666392051418351e-19561285), SC_(5.3349781350769085870584949964259833414646e-19561285), SC_(5.0099627608076487202391769793378980776735e-01), SC_(4.9900372391923512797608230206621019223265e-01) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(6.6064240000000000000000000000000000000000e+07), SC_(5.0000000000000000000000000000000000000000e-01), SC_(3.7766200065509031104845739434243912016640e-39774640), SC_(3.7766200065509031104845739434243912016640e-39774640), SC_(5.0000000000000000000000000000000000000000e-01), SC_(5.0000000000000000000000000000000000000000e-01) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(1.2840448000000000000000000000000000000000e+08), SC_(3.0574485659599304199218750000000000000000e-01), SC_(2.5499948403492126832621112261886711266039e-54349020), SC_(2.0556139774808650984718445332228235716136e-54123845), SC_(1.2405027735188911857254575182239206769170e-225175), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(1.6388441600000000000000000000000000000000e+08), SC_(2.8442695736885070800781250000000000000000e-01), SC_(1.2279015016272387603468635389808927170274e-59892962), SC_(2.6707150622781810026344885223539760519881e-59890939), SC_(4.5976507152350828048542180202795447137325e-2024), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(4.3818304000000000000000000000000000000000e+08), SC_(1.3100245594978332519531250000000000000000e-01), SC_(2.0918510258168925892479858886438330071787e-85037305), SC_(8.8274237375468343467612244390103556744560e-85037305), SC_(1.9157417238326635764211881274088377284328e-01), SC_(8.0842582761673364235788118725911622715672e-01) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(7.0231680000000000000000000000000000000000e+08), SC_(8.5977621376514434814453125000000000000000e-02), SC_(1.9134679678448973785409649973448200830725e-97819696), SC_(2.1938269235411869466181455339632742703704e-97819696), SC_(4.6587060789276842778348755932559549040009e-01), SC_(5.3412939210723157221651244067440450959991e-01) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(1.1784750080000000000000000000000000000000e+09), SC_(5.3083237260580062866210937500000000000000e-02), SC_(5.3092409412997425293241490447022832646172e-112150671), SC_(5.3820627193644723012531758142665664159743e-112150671), SC_(4.9659434525591776152248322370623280574653e-01), SC_(5.0340565474408223847751677629376719425347e-01) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(3.3226301440000000000000000000000000000000e+09), SC_(1.9495485350489616394042968750000000000000e-02), SC_(2.9805222764839134445421624419393517120926e-141384036), SC_(2.9793164435120491508007096766454662361607e-141384036), SC_(5.0010116322173438869627481180033980614479e-01), SC_(4.9989883677826561130372518819966019385521e-01) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(5.4911078400000000000000000000000000000000e+09), SC_(1.1899991892278194427490234375000000000000e-02), SC_(9.2019309890140905585185409212318788596910e-155686340), SC_(1.3737723776314673548450155498608152869093e-155686355), SC_(9.9999999999999985070825033663338793627127e-01), SC_(1.4929174966336661206372872798454540948113e-16) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(1.0208120832000000000000000000000000000000e+10), SC_(7.0731318555772304534912109375000000000000e-03), SC_(1.5349949874122546472219873459503901279923e-173397238), SC_(6.1829211363395777380749449865656442552157e-173532728), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.0279748058089432740845336004790061387206e-135490) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(2.6575216640000000000000000000000000000000e+10), SC_(2.4797946680337190628051757812500000000000e-03), SC_(1.8873663417864832930165856149827076147600e-200791970), SC_(1.6555030435143801367769442694867758918106e-200791970), SC_(5.3272252982767146680016439580013119126126e-01), SC_(4.6727747017232853319983560419986880873874e-01) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(6.8474880000000000000000000000000000000000e+10), SC_(9.6386543009430170059204101562500000000000e-04), SC_(1.0529835742952932449379547657205437654148e-227926174), SC_(1.0515302080688825811408791977887648136150e-227926174), SC_(5.0034529738854405988243696227743743533566e-01), SC_(4.9965470261145594011756303772256256466434e-01) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(1.3451883315200000000000000000000000000000e+11), SC_(4.9087411025539040565490722656250000000000e-04), SC_(8.2836292085501397763213887394666128932729e-247292841), SC_(8.2802233565776076785541733903814863319029e-247292841), SC_(5.0010280977686623807474566761109989683738e-01), SC_(4.9989719022313376192525433238890010316262e-01) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(2.7439156428800000000000000000000000000000e+11), SC_(2.1663750521838665008544921875000000000000e-04), SC_(6.6384405992890906993947247254128735337663e-267895762), SC_(1.0551502961799982687781053904354429784300e-267741923), SC_(6.2914644703436997250805860476949436864647e-153839), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(5.4010445824000000000000000000000000000000e+11), SC_(1.2107953807571902871131896972656250000000e-04), SC_(3.0813838488000332359945766917518245855248e-287171627), SC_(1.5043048287042177859799313615954981151956e-287170180), SC_(2.0483772902958000183795842080915891902638e-1447), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(1.0817516339200000000000000000000000000000e+12), SC_(6.1061706219334155321121215820312500000000e-05), SC_(2.6594450167064185852180435922569441141400e-307097567), SC_(1.0114375222181193207153180601320345102674e-307097566), SC_(2.0819496180243821918812279184918031864014e-01), SC_(7.9180503819756178081187720815081968135986e-01) }, 
      { SC_(6.6064240000000000000000000000000000000000e+07), SC_(1.2728087347200000000000000000000000000000e+12), SC_(5.1901082770200446248054504394531250000000e-05), SC_(7.9088689974186556183340685648818166737646e-311763922), SC_(9.0023125746899417586950102909464295129156e-311763922), SC_(4.6767098819769373449567984631567275946148e-01), SC_(5.3232901180230626550432015368432724053852e-01) }, 
      { SC_(1.2840448000000000000000000000000000000000e+08), SC_(1.9028755000000000000000000000000000000000e+06), SC_(9.8539602756500244140625000000000000000000e-01), SC_(6.1818802421655899053804858706609231905094e-4313188), SC_(7.1922523456835982836258848275905899942700e-4313188), SC_(4.6222663051673487272131699134580493142992e-01), SC_(5.3777336948326512727868300865419506857008e-01) }, 
      { SC_(1.2840448000000000000000000000000000000000e+08), SC_(2.3812680000000000000000000000000000000000e+06), SC_(9.8179262876510620117187500000000000000000e-01), SC_(5.0494006161637979408497153134845013307651e-5167519), SC_(5.0335489615276223544005485976104932781655e-5167519), SC_(5.0078606237758281846690920144038162652983e-01), SC_(4.9921393762241718153309079855961837347017e-01) }, 
      { SC_(1.2840448000000000000000000000000000000000e+08), SC_(7.9934700000000000000000000000000000000000e+06), SC_(9.4233739376068115234375000000000000000000e-01), SC_(3.4713098308083224530354794107507584487194e-13216288), SC_(6.6304822357502311243565072697939020416744e-13216771), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.9100807933950021199759931591006127749350e-483) }, 
      { SC_(1.2840448000000000000000000000000000000000e+08), SC_(1.5393168000000000000000000000000000000000e+07), SC_(9.8224782943725585937500000000000000000000e-01), SC_(1.3400914854501924623508022543834906396328e-21251754), SC_(1.1411311846631746057240988292038122343193e-27948422), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.5153229988609410712518358630794051423316e-6696669) }, 
      { SC_(1.2840448000000000000000000000000000000000e+08), SC_(1.8907696000000000000000000000000000000000e+07), SC_(8.7165749073028564453125000000000000000000e-01), SC_(4.0035174591376072573426759622387433117729e-24518521), SC_(2.4137258449868229509268468472281147527369e-24518521), SC_(6.2386873450232192423909199729185048846601e-01), SC_(3.7613126549767807576090800270814951153399e-01) }, 
      { SC_(1.2840448000000000000000000000000000000000e+08), SC_(6.6064240000000000000000000000000000000000e+07), SC_(6.6028350591659545898437500000000000000000e-01), SC_(1.0288159448521634304507343629724393228059e-54123845), SC_(1.0267980326287016680211101702503842488077e-54123845), SC_(5.0049082956371378010353155766716694866116e-01), SC_(4.9950917043628621989646844233283305133884e-01) }, 
      { SC_(1.2840448000000000000000000000000000000000e+08), SC_(1.2840448000000000000000000000000000000000e+08), SC_(5.0000000000000000000000000000000000000000e-01), SC_(1.1995361159573694057587703112574074369495e-77307204), SC_(1.1995361159573694057587703112574074369495e-77307204), SC_(5.0000000000000000000000000000000000000000e-01), SC_(5.0000000000000000000000000000000000000000e-01) }, 
      { SC_(1.2840448000000000000000000000000000000000e+08), SC_(1.6388441600000000000000000000000000000000e+08), SC_(3.9537605643272399902343750000000000000000e-01), SC_(1.6778285927334469868610345472792764099270e-87556829), SC_(3.0139312248152564424336636060035612998418e-87050212), SC_(5.5669106810368311415198686979608078881933e-506618), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.2840448000000000000000000000000000000000e+08), SC_(4.3818304000000000000000000000000000000000e+08), SC_(2.2436152398586273193359375000000000000000e-01), SC_(2.4308703695517336039388400302492537696892e-131690546), SC_(2.2116269792617020401350503649090851180806e-131686921), SC_(1.0991321738909247008482582348637507193045e-3625), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.2840448000000000000000000000000000000000e+08), SC_(7.0231680000000000000000000000000000000000e+08), SC_(1.5455441176891326904296875000000000000000e-01), SC_(1.1040287082738167591384780534320424755135e-155334549), SC_(9.0354637950766571623647007812878959117876e-155334549), SC_(1.0888402036975752863579558268376075434693e-01), SC_(8.9111597963024247136420441731623924565307e-01) }, 
      { SC_(1.2840448000000000000000000000000000000000e+08), SC_(1.1784750080000000000000000000000000000000e+09), SC_(9.8251745104789733886718750000000000000000e-02), SC_(5.0963631464490743983204348367041211167513e-182318867), SC_(6.1710462893254421530122012535490566558712e-182318867), SC_(4.5231010513098947624791614749646421623030e-01), SC_(5.4768989486901052375208385250353578376970e-01) }, 
      { SC_(1.2840448000000000000000000000000000000000e+08), SC_(3.3226301440000000000000000000000000000000e+09), SC_(3.7207495421171188354492187500000000000000e-02), SC_(1.5626067924507935351145976759592533332703e-238252205), SC_(1.5908294045929854116754804883909521585977e-238252205), SC_(4.9552510176539334245844025026860406383719e-01), SC_(5.0447489823460665754155974973139593616281e-01) }, 
      { SC_(1.2840448000000000000000000000000000000000e+08), SC_(5.4911078400000000000000000000000000000000e+09), SC_(2.2849755361676216125488281250000000000000e-02), SC_(6.1501535662756039594478152451029592573216e-265850302), SC_(6.1483296414347920428605292133946238505526e-265850302), SC_(5.0007415243042607186636839766453070610669e-01), SC_(4.9992584756957392813363160233546929389331e-01) }, 
      { SC_(1.2840448000000000000000000000000000000000e+08), SC_(1.0208120832000000000000000000000000000000e+10), SC_(1.2434825301170349121093750000000000000000e-02), SC_(8.0572302855350165620450660805854367508260e-300130087), SC_(1.7025217642731057373262290775534145983106e-300130116), SC_(9.9999999999999999999999999999788696400135e-01), SC_(2.1130359986478341195616284492865304235992e-30) }, 
      { SC_(1.6388441600000000000000000000000000000000e+08), SC_(1.9028755000000000000000000000000000000000e+06), SC_(9.8851227760314941406250000000000000000000e-01), SC_(2.5849878135176152030939011376132123089588e-4513498), SC_(1.9794917777845822874624346916189291829936e-4513497), SC_(1.1550485782724570831269542060323292825776e-01), SC_(8.8449514217275429168730457939676707174224e-01) }, 
      { SC_(1.6388441600000000000000000000000000000000e+08), SC_(2.3812680000000000000000000000000000000000e+06), SC_(9.8567694425582885742187500000000000000000e-01), SC_(8.6410638450642360655081071877899970667255e-5417779), SC_(1.0262114768691110228800860724744736363603e-5417778), SC_(4.5712226613445640279722027752136733371092e-01), SC_(5.4287773386554359720277972247863266628908e-01) }, 
      { SC_(1.6388441600000000000000000000000000000000e+08), SC_(7.9934700000000000000000000000000000000000e+06), SC_(9.5349329710006713867187500000000000000000e-01), SC_(2.6097257028320969990247635413618882111566e-14040694), SC_(2.6158899661639770588616377695983557961829e-14040694), SC_(4.9941018783983167333716217246608918649972e-01), SC_(5.0058981216016832666283782753391081350028e-01) }, 
      { SC_(1.6388441600000000000000000000000000000000e+08), SC_(1.5393168000000000000000000000000000000000e+07), SC_(9.1505193710327148437500000000000000000000e-01), SC_(9.6551462778955141221983069843480065009801e-22801749), SC_(6.1719699670473188990335171910161259107206e-22802168), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.3924147697041349847087439184820795018349e-420) }, 
      { SC_(1.6388441600000000000000000000000000000000e+08), SC_(1.8907696000000000000000000000000000000000e+07), SC_(9.8621791601181030273437500000000000000000e-01), SC_(4.3065280681211238072561193458158766407252e-26401478), SC_(4.5330622673791771775444538483461821861584e-36169026), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0526025131323216894511385507829437447750e-9767548) }, 
      { SC_(1.6388441600000000000000000000000000000000e+08), SC_(6.6064240000000000000000000000000000000000e+07), SC_(7.1270716190338134765625000000000000000000e-01), SC_(1.5872826264300720006195342820991678025714e-59890939), SC_(1.0834324358481090020149542402548082494167e-59890939), SC_(5.9432870576469645317612437392079761317247e-01), SC_(4.0567129423530354682387562607920238682753e-01) }, 
      { SC_(1.6388441600000000000000000000000000000000e+08), SC_(1.2840448000000000000000000000000000000000e+08), SC_(5.6069332361221313476562500000000000000000e-01), SC_(1.5093055757436118169109782447954545361356e-87050212), SC_(1.5046256490716446255226853612081067637062e-87050212), SC_(5.0077638245913425823168178147204387248552e-01), SC_(4.9922361754086574176831821852795612751448e-01) }, 
      { SC_(1.6388441600000000000000000000000000000000e+08), SC_(1.6388441600000000000000000000000000000000e+08), SC_(5.0000000000000000000000000000000000000000e-01), SC_(1.1629416557591887187302901378630907823382e-98668254), SC_(1.1629416557591887187302901378630907823382e-98668254), SC_(5.0000000000000000000000000000000000000000e-01), SC_(5.0000000000000000000000000000000000000000e-01) }, 
      { SC_(1.6388441600000000000000000000000000000000e+08), SC_(4.3818304000000000000000000000000000000000e+08), SC_(2.4498248100280761718750000000000000000000e-01), SC_(3.8242563151912213176522795414368878126556e-153588417), SC_(1.6327982754268810032616653064179763776345e-153077013), SC_(2.3421486736880601751250267914314874522681e-511404), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.6388441600000000000000000000000000000000e+08), SC_(7.0231680000000000000000000000000000000000e+08), SC_(1.8730702996253967285156250000000000000000e-01), SC_(2.8335598826427938308503877311130256739789e-182477187), SC_(5.1614840636817263413325229011158102523416e-182472773), SC_(5.4898161995323371002741545458726610988458e-4415), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.6388441600000000000000000000000000000000e+08), SC_(1.1784750080000000000000000000000000000000e+09), SC_(1.2207462638616561889648437500000000000000e-01), SC_(2.3239018964207651880354867832101682268705e-216321671), SC_(2.4732918164720718516784108104050513920668e-216321670), SC_(8.5889690332025052692370201806248599559326e-02), SC_(9.1411030966797494730762979819375140044067e-01) }, 
      { SC_(1.6388441600000000000000000000000000000000e+08), SC_(3.3226301440000000000000000000000000000000e+09), SC_(4.7004759311676025390625000000000000000000e-02), SC_(6.2451721923899295803122810451513665433267e-287089030), SC_(7.6992641521283472053898388836114048527856e-287089030), SC_(4.4786121418561179741748287088226763544008e-01), SC_(5.5213878581438820258251712911773236455992e-01) }, 
      { SC_(1.6388441600000000000000000000000000000000e+08), SC_(5.4911078400000000000000000000000000000000e+09), SC_(2.8980454429984092712402343750000000000000e-02), SC_(3.9462868871928841565636043533851129840528e-322169581), SC_(4.0322286123645297545689710347244763437017e-322169581), SC_(4.9461417821545793966288079726148121857368e-01), SC_(5.0538582178454206033711920273851878142632e-01) }, 
      { SC_(4.3818304000000000000000000000000000000000e+08), SC_(1.9028755000000000000000000000000000000000e+06), SC_(9.9557650089263916015625000000000000000000e-01), SC_(5.2197595739748872709995661470797045496677e-5323481), SC_(4.2227709944521967421350357115614218921429e-5323262), SC_(1.2360981878563902292192085477769040099994e-219), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(4.3818304000000000000000000000000000000000e+08), SC_(2.3812680000000000000000000000000000000000e+06), SC_(9.9458497762680053710937500000000000000000e-01), SC_(4.3368548708402849801063449102280932236089e-6430191), SC_(2.0172526887177384674241576539371507117951e-6430188), SC_(2.1452697381595155956194986714368837557427e-03), SC_(9.9785473026184048440438050132856311624426e-01) }, 
      { SC_(4.3818304000000000000000000000000000000000e+08), SC_(7.9934700000000000000000000000000000000000e+06), SC_(9.8208349943161010742187500000000000000000e-01), SC_(4.4494892805873048074564465632924980792566e-17403004), SC_(5.7576724656643884623843735020582648967991e-17403004), SC_(4.3591836704471353718384505691010425817447e-01), SC_(5.6408163295528646281615494308989574182553e-01) }, 
      { SC_(4.3818304000000000000000000000000000000000e+08), SC_(1.5393168000000000000000000000000000000000e+07), SC_(9.6606272459030151367187500000000000000000e-01), SC_(1.3765221719262277822546284488047552306000e-29187952), SC_(1.3612284417251662536742945827992884059955e-29187952), SC_(5.0279311967364769714074650202585375865871e-01), SC_(4.9720688032635230285925349797414624134129e-01) }, 
      { SC_(4.3818304000000000000000000000000000000000e+08), SC_(1.8907696000000000000000000000000000000000e+07), SC_(9.5959335565567016601562500000000000000000e-01), SC_(3.7778228763483038591335700083851080096289e-34195507), SC_(1.6042257292403925526001793771710266121318e-34197844), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.2464291782548033508382650013845980369338e-2338) }, 
      { SC_(4.3818304000000000000000000000000000000000e+08), SC_(6.6064240000000000000000000000000000000000e+07), SC_(9.5588284730911254882812500000000000000000e-01), SC_(1.0919274763363726936009210327654188681635e-85037304), SC_(2.5985171085074895194038033291516078294048e-98129327), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.3797524696658569759067541736767817170936e-13092023) }, 
      { SC_(4.3818304000000000000000000000000000000000e+08), SC_(1.2840448000000000000000000000000000000000e+08), SC_(7.7337998151779174804687500000000000000000e-01), SC_(1.4835408324792446532740385459022881895156e-131686921), SC_(7.2808614678245738686101181900679692856492e-131686922), SC_(6.7079161467567588359028133217939217246753e-01), SC_(3.2920838532432411640971866782060782753247e-01) }, 
      { SC_(4.3818304000000000000000000000000000000000e+08), SC_(1.6388441600000000000000000000000000000000e+08), SC_(7.2779732942581176757812500000000000000000e-01), SC_(8.1917014922760272225904061918310176343654e-153077014), SC_(8.1362812619927828100262468723487461419792e-153077014), SC_(5.0169709360664149624164435504346540676281e-01), SC_(4.9830290639335850375835564495653459323719e-01) }, 
      { SC_(4.3818304000000000000000000000000000000000e+08), SC_(4.3818304000000000000000000000000000000000e+08), SC_(5.0000000000000000000000000000000000000000e-01), SC_(4.6268663754868876170021739676869641930874e-263812482), SC_(4.6268663754868876170021739676869641930874e-263812482), SC_(5.0000000000000000000000000000000000000000e-01), SC_(5.0000000000000000000000000000000000000000e-01) }, 
      { SC_(7.0231680000000000000000000000000000000000e+08), SC_(1.9028755000000000000000000000000000000000e+06), SC_(9.8732495307922363281250000000000000000000e-01), SC_(7.0991148056804135011746472703897852591226e-7500614), SC_(3.4332243090685415469371965855703560514001e-5712445), SC_(2.0677690027210760422876175267607362846576e-1788169), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(7.0231680000000000000000000000000000000000e+08), SC_(2.3812680000000000000000000000000000000000e+06), SC_(9.9652123451232910156250000000000000000000e-01), SC_(2.2505502990460006943676220317225844201205e-6917447), SC_(6.6211803808198866580708521922038660123114e-6917003), SC_(3.3990167456626817442704952253287571269894e-445), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(7.0231680000000000000000000000000000000000e+08), SC_(7.9934700000000000000000000000000000000000e+06), SC_(9.8873662948608398437500000000000000000000e-01), SC_(1.0477395563962802361853363886100366795490e-19028895), SC_(1.6561822161313668238096084438698098125869e-19028893), SC_(6.2864639488714637930613399689161994073662e-03), SC_(9.9371353605112853620693866003108380059263e-01) }, 
      { SC_(7.0231680000000000000000000000000000000000e+08), SC_(1.5393168000000000000000000000000000000000e+07), SC_(9.7855138778686523437500000000000000000000e-01), SC_(1.4948926071145156048176223031779482116314e-32298326), SC_(2.0067747278881085825995831405620656211578e-32298326), SC_(4.2690880203598646988864383879616853582810e-01), SC_(5.7309119796401353011135616120383146417190e-01) }, 
      { SC_(7.0231680000000000000000000000000000000000e+08), SC_(1.8907696000000000000000000000000000000000e+07), SC_(9.7378385066986083984375000000000000000000e-01), SC_(4.1449027340574414496146949981250996983343e-38004155), SC_(4.1967144122884800322137053761048666181714e-38004155), SC_(4.9689438646475552441238747270567456741447e-01), SC_(5.0310561353524447558761252729432543258553e-01) }, 
      { SC_(7.0231680000000000000000000000000000000000e+08), SC_(6.6064240000000000000000000000000000000000e+07), SC_(9.1493552923202514648437500000000000000000e-01), SC_(4.1072948913860843251591105313080943534430e-97819696), SC_(1.0546904053602130054520141139821643677408e-97821483), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.5678468024590457034901905878733344963975e-1788) }, 
      { SC_(7.0231680000000000000000000000000000000000e+08), SC_(1.2840448000000000000000000000000000000000e+08), SC_(9.2997318506240844726562500000000000000000e-01), SC_(1.0139492503350473921503178834719938387301e-155334548), SC_(1.4463885988401215760599485841510054765047e-170416985), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.4264901309036717348254932768109262017739e-15082437) }, 
      { SC_(7.0231680000000000000000000000000000000000e+08), SC_(1.6388441600000000000000000000000000000000e+08), SC_(8.1080907583236694335937500000000000000000e-01), SC_(3.7594683115176890098298184165620557931421e-182472773), SC_(1.4020157521640373315027044845537544591995e-182472773), SC_(7.2836964429878163843210512538762248147681e-01), SC_(2.7163035570121836156789487461237751852319e-01) }, 
      { SC_(1.1784750080000000000000000000000000000000e+09), SC_(1.9028755000000000000000000000000000000000e+06), SC_(8.9854913949966430664062500000000000000000e-01), SC_(1.3735235000843630423045813617867074336888e-56640769), SC_(8.9035690852362805276387266064908546743381e-6139736), SC_(1.5426661903055395275376803016741131904154e-50501034), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.1784750080000000000000000000000000000000e+09), SC_(2.3812680000000000000000000000000000000000e+06), SC_(9.8800355195999145507812500000000000000000e-01), SC_(5.7354300955816316636308506259387594128589e-10751268), SC_(1.1980190535444176202285632223470773269640e-7451574), SC_(4.7874281119427834708331945673586755448982e-3299694), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.1784750080000000000000000000000000000000e+09), SC_(7.9934700000000000000000000000000000000000e+06), SC_(9.9316346645355224609375000000000000000000e-01), SC_(2.8472249112517147389172193821893959698511e-20818168), SC_(5.4023358409534002335751159752059254785626e-20817790), SC_(5.2703589615214269841159966957745812772393e-379), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.1784750080000000000000000000000000000000e+09), SC_(1.5393168000000000000000000000000000000000e+07), SC_(9.8709660768508911132812500000000000000000e-01), SC_(1.5878849769900175356113473801836227052262e-35729257), SC_(1.2619640508246663993002992968771583987319e-35729254), SC_(1.2566835853744223623570983219049227922042e-03), SC_(9.9874331641462557763764290167809507720780e-01) }, 
      { SC_(1.1784750080000000000000000000000000000000e+09), SC_(1.8907696000000000000000000000000000000000e+07), SC_(9.8420816659927368164062500000000000000000e-01), SC_(1.0208724904057665385312662679315939740113e-42210333), SC_(1.5774959209775445359558678698142402759437e-42210333), SC_(3.9288981729202815516756416638887695009260e-01), SC_(6.0711018270797184483243583361112304990740e-01) }, 
      { SC_(1.1784750080000000000000000000000000000000e+09), SC_(6.6064240000000000000000000000000000000000e+07), SC_(9.4691669940948486328125000000000000000000e-01), SC_(5.3395601841124837175192612668006049112725e-112150671), SC_(5.3517434765517311130580635921682447693190e-112150671), SC_(4.9943022418846484767927026742910378335104e-01), SC_(5.0056977581153515232072973257089621664896e-01) }, 
      { SC_(1.1784750080000000000000000000000000000000e+09), SC_(1.2840448000000000000000000000000000000000e+08), SC_(9.0264910459518432617187500000000000000000e-01), SC_(1.1267409435774516551332636090253177772622e-182318866), SC_(1.8184844856739359787505613764070074738906e-182321488), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.6139330837665030587738764757813416237350e-2622) }, 
      { SC_(1.1784750080000000000000000000000000000000e+09), SC_(1.6388441600000000000000000000000000000000e+08), SC_(9.6570450067520141601562500000000000000000e-01), SC_(2.7056820061141483704819594887260682147539e-216321670), SC_(1.8594711231644185034858100520246501810046e-257912482), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.8724673445086673227821868608873966487133e-41590813) }, 
      { SC_(3.3226301440000000000000000000000000000000e+09), SC_(1.9028755000000000000000000000000000000000e+06), SC_(9.9942761659622192382812500000000000000000e-01), SC_(2.2719864760919393957051033594727721576839e-6995907), SC_(2.3586726459432175577476484810270895665808e-6995907), SC_(4.9063997504817630342954777760718050835451e-01), SC_(5.0936002495182369657045222239281949164549e-01) }, 
      { SC_(3.3226301440000000000000000000000000000000e+09), SC_(2.3812680000000000000000000000000000000000e+06), SC_(8.9935541152954101562500000000000000000000e-01), SC_(2.3734500369890445595449056590120521595736e-155443710), SC_(1.7760666632957760397894412941390096444167e-8522856), SC_(1.3363518870314969087585327150388928879007e-146920854), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(3.3226301440000000000000000000000000000000e+09), SC_(7.9934700000000000000000000000000000000000e+06), SC_(9.8762404918670654296875000000000000000000e-01), SC_(1.1238548668176231327906316943317462103848e-33216848), SC_(5.6588329816161438668349467520608681235803e-24408569), SC_(1.9860187965764169329486764553953334883788e-8808280), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(3.3226301440000000000000000000000000000000e+09), SC_(1.5393168000000000000000000000000000000000e+07), SC_(9.9528896808624267578125000000000000000000e-01), SC_(6.2550820102953353054869658433897905713534e-42632204), SC_(4.0123976786040771687945822000979586906263e-42630658), SC_(1.5589386973405620714929456291454390803183e-1546), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(3.3226301440000000000000000000000000000000e+09), SC_(1.8907696000000000000000000000000000000000e+07), SC_(9.9433165788650512695312500000000000000000e-01), SC_(2.1774368057179847381549522021672777587789e-50679662), SC_(2.5669745110408118077472078051749218011436e-50679648), SC_(8.4825026362848354802412891887927340926122e-15), SC_(9.9999999999999151749736371516451975871081e-01) }, 
      { SC_(3.3226301440000000000000000000000000000000e+09), SC_(6.6064240000000000000000000000000000000000e+07), SC_(9.8050355911254882812500000000000000000000e-01), SC_(2.0479988211775693973818484005597330403671e-141384036), SC_(3.9118398988183931979610237180250849078861e-141384036), SC_(3.4363326213950916844856407472851673003374e-01), SC_(6.5636673786049083155143592527148326996626e-01) }, 
      { SC_(3.3226301440000000000000000000000000000000e+09), SC_(1.2840448000000000000000000000000000000000e+08), SC_(9.6279245615005493164062500000000000000000e-01), SC_(1.5719197541658875680623878177745840364222e-238252205), SC_(1.5815164428778913787276903465756214554458e-238252205), SC_(4.9847837595049484039573435683638852457723e-01), SC_(5.0152162404950515960426564316361147542277e-01) }, 
      { SC_(3.3226301440000000000000000000000000000000e+09), SC_(1.6388441600000000000000000000000000000000e+08), SC_(9.5394778251647949218750000000000000000000e-01), SC_(1.3944436344518276785702119928762771396112e-287089029), SC_(1.3213070066302671195264205502007786162321e-287104582), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.4755139181347302406442457690868626999544e-15554) }, 
      { SC_(5.4911078400000000000000000000000000000000e+09), SC_(1.9028755000000000000000000000000000000000e+06), SC_(9.9965363740921020507812500000000000000000e-01), SC_(2.1849630191637532822564113959425763358119e-7410979), SC_(1.5398666441828424115748547673059583108728e-7410979), SC_(5.8659407721765726849717856619696733685370e-01), SC_(4.1340592278234273150282143380303266314630e-01) }, 
      { SC_(5.4911078400000000000000000000000000000000e+09), SC_(2.3812680000000000000000000000000000000000e+06), SC_(9.9956649541854858398437500000000000000000e-01), SC_(9.3854063552475142458864103586137247427397e-9042251), SC_(1.1366362907610217162042941747179206017284e-9042250), SC_(4.5227017688780178526929011547716989958895e-01), SC_(5.4772982311219821473070988452283010041105e-01) }, 
      { SC_(5.4911078400000000000000000000000000000000e+09), SC_(7.9934700000000000000000000000000000000000e+06), SC_(8.9869177341461181640625000000000000000000e-01), SC_(4.7008172934117010744268608837489606361011e-262676644), SC_(4.2099445612168176222312446731296295994010e-26150921), SC_(1.1165983839114984649414055074581842219116e-236525723), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(5.4911078400000000000000000000000000000000e+09), SC_(1.5393168000000000000000000000000000000000e+07), SC_(9.8723250627517700195312500000000000000000e-01), SC_(8.7696664459171685513222307445519816724999e-59796462), SC_(4.8704394498414282387240246481462481071204e-45983008), SC_(1.8005903853712197038127909088061405658382e-13813454), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(5.4911078400000000000000000000000000000000e+09), SC_(1.8907696000000000000000000000000000000000e+07), SC_(9.9646884202957153320312500000000000000000e-01), SC_(3.2393581388032644259773207088889754299989e-54799103), SC_(2.0170281900044893609559639027931345809476e-54795692), SC_(1.6060053869629132392532509459281957661979e-3411), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(5.4911078400000000000000000000000000000000e+09), SC_(6.6064240000000000000000000000000000000000e+07), SC_(9.8810195922851562500000000000000000000000e-01), SC_(3.8337503525777798567498581452972813212339e-155686351), SC_(9.2019309889757544287651407541317351232536e-155686340), SC_(4.1662454947279857412631515454515646519085e-12), SC_(9.9999999999583375450527201425873684845455e-01) }, 
      { SC_(5.4911078400000000000000000000000000000000e+09), SC_(1.2840448000000000000000000000000000000000e+08), SC_(9.7714924812316894531250000000000000000000e-01), SC_(3.7940599521723360006713238961938756799799e-265850302), SC_(8.5044232555380600016370205623037074278942e-265850302), SC_(3.0849820161511402481070471077236571081517e-01), SC_(6.9150179838488597518929528922763428918483e-01) }, 
      { SC_(5.4911078400000000000000000000000000000000e+09), SC_(1.6388441600000000000000000000000000000000e+08), SC_(9.7101950645446777343750000000000000000000e-01), SC_(3.9764175280848910737775000867174136318920e-322169581), SC_(4.0020979714725228373550753013921756958625e-322169581), SC_(4.9839065027892367225614105030689706564896e-01), SC_(5.0160934972107632774385894969310293435104e-01) }, 
      { SC_(1.0208120832000000000000000000000000000000e+10), SC_(1.9028755000000000000000000000000000000000e+06), SC_(9.9982368946075439453125000000000000000000e-01), SC_(2.0831198327561816801115236331606867702565e-7923330), SC_(1.1690566962073294390040411611762303251245e-7924582), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.6120472659537173757780473685839358681957e-1253) }, 
      { SC_(1.0208120832000000000000000000000000000000e+10), SC_(2.3812680000000000000000000000000000000000e+06), SC_(9.9976694583892822265625000000000000000000e-01), SC_(1.3121290802946075554175857984811456035977e-9683388), SC_(2.1330308954451816390308180020820834213545e-9683389), SC_(8.6016874839671604937946808127838684560430e-01), SC_(1.3983125160328395062053191872161315439570e-01) }, 
      { SC_(1.0208120832000000000000000000000000000000e+10), SC_(7.9934700000000000000000000000000000000000e+06), SC_(9.9921756982803344726562500000000000000000e-01), SC_(6.9766830624800081791017804293838607464749e-28302283), SC_(6.6926926551992406604565490702529843120478e-28302283), SC_(5.1038783383916609007798460281959528100871e-01), SC_(4.8961216616083390992201539718040471899129e-01) }, 
      { SC_(1.0208120832000000000000000000000000000000e+10), SC_(1.8907696000000000000000000000000000000000e+07), SC_(9.8816967010498046875000000000000000000000e-01), SC_(3.4137381383370857347172608963535683079741e-89195667), SC_(8.0016560944402144898752152123077406806487e-59880746), SC_(4.2662895006310645985871232086823001047668e-29314922), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0208120832000000000000000000000000000000e+10), SC_(6.6064240000000000000000000000000000000000e+07), SC_(9.9347048997879028320312500000000000000000e-01), SC_(9.3580886115766235922264720015954794750574e-173400656), SC_(1.5349949874122546472219873459503901279923e-173397238), SC_(6.0964945738049601672163298413239264409616e-3418), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0208120832000000000000000000000000000000e+10), SC_(1.2840448000000000000000000000000000000000e+08), SC_(9.8756772279739379882812500000000000000000e-01), SC_(5.1820196848058693175449285859650984576576e-300130106), SC_(8.0572302855350165615268641121218750367142e-300130087), SC_(6.4315149265486987592915343059237609231928e-20), SC_(9.9999999999999999993568485073451301240708e-01) }, 
      { SC_(1.3451883315200000000000000000000000000000e+11), SC_(1.9028755000000000000000000000000000000000e+06), SC_(9.9998486042022705078125000000000000000000e-01), SC_(4.9051680773388075190719347586453139472071e-10056122), SC_(3.5595829580248721848300751183988060575767e-10054170), SC_(1.3780176316105773450102617650129773815088e-1952), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.3451883315200000000000000000000000000000e+11), SC_(2.3812680000000000000000000000000000000000e+06), SC_(9.9998229742050170898437500000000000000000e-01), SC_(4.1156386876989822922772865888407071090856e-12349910), SC_(4.5869595210638883658221978499220925609089e-12349910), SC_(4.7292068287776856303434958063406477318607e-01), SC_(5.2707931712223143696565041936593522681393e-01) }, 
      { SC_(2.7439156428800000000000000000000000000000e+11), SC_(1.9028755000000000000000000000000000000000e+06), SC_(9.9998307228088378906250000000000000000000e-01), SC_(1.6829996164229106165276721752391297776754e-11096628), SC_(5.6214402951194157435823494036860533460330e-10643274), SC_(2.9938939632323513081891806297480617610184e-453355), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.7439156428800000000000000000000000000000e+11), SC_(2.3812680000000000000000000000000000000000e+06), SC_(9.9999034404754638671875000000000000000000e-01), SC_(5.2631814242827204795656447953582228243431e-13093227), SC_(2.5583815798952895536761257087421433721540e-13087116), SC_(2.0572308156229509893753815776204759364258e-6111), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.7439156428800000000000000000000000000000e+11), SC_(7.9934700000000000000000000000000000000000e+06), SC_(9.9997085332870483398437500000000000000000e-01), SC_(5.1048234014001975179816586694675258925023e-39727041), SC_(7.8063302663582094143028915587948982826828e-39727040), SC_(6.1379565020036795368260014426378256132886e-02), SC_(9.3862043497996320463173998557362174386711e-01) }, 
      { SC_(5.4010445824000000000000000000000000000000e+11), SC_(1.9028755000000000000000000000000000000000e+06), SC_(9.9989646673202514648437500000000000000000e-01), SC_(6.4969552030046504582592323046747707632721e-31869290), SC_(1.3881076254193924371200087146474294833952e-11202921), SC_(4.6804405393578247174189149262151496011253e-20666369), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(5.4010445824000000000000000000000000000000e+11), SC_(2.3812680000000000000000000000000000000000e+06), SC_(9.9998557567596435546875000000000000000000e-01), SC_(1.2810764791330623823942182869157436560355e-14910955), SC_(1.0288081627421349708687968862886394486490e-13787461), SC_(1.2452044273429399863007391374119654114562e-1123494), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(5.4010445824000000000000000000000000000000e+11), SC_(7.9934700000000000000000000000000000000000e+06), SC_(9.9998420476913452148437500000000000000000e-01), SC_(6.7651429999074967322095576365358877350799e-42085473), SC_(1.8296260828558949392932305747296630752961e-42077950), SC_(3.6975549612561645549999484238750497415660e-7523), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(5.4010445824000000000000000000000000000000e+11), SC_(1.5393168000000000000000000000000000000000e+07), SC_(9.9997150897979736328125000000000000000000e-01), SC_(6.8111367048550008031889878844483519560298e-76649521), SC_(9.3209944366439402355548780229705257402903e-76649522), SC_(8.7962404532339837203786730721507019671755e-01), SC_(1.2037595467660162796213269278492980328245e-01) }, 
      { SC_(1.0817516339200000000000000000000000000000e+12), SC_(1.9028755000000000000000000000000000000000e+06), SC_(9.9989825487136840820312500000000000000000e-01), SC_(6.0589317120723252541113349946179268351405e-55399381), SC_(7.2729733482685763177255847886396726695559e-11776923), SC_(8.3307492299758404929371656193733935608539e-43622459), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0817516339200000000000000000000000000000e+12), SC_(2.3812680000000000000000000000000000000000e+06), SC_(9.9998778104782104492187500000000000000000e-01), SC_(2.7642009221596932108111810135428562127092e-17439580), SC_(1.3910953068816099436510223376105936614661e-14505769), SC_(1.9870679661454298179818292548319975722198e-2933811), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0817516339200000000000000000000000000000e+12), SC_(7.9934700000000000000000000000000000000000e+06), SC_(9.9999159574508666992187500000000000000000e-01), SC_(3.4634825991925741776506724573595062163831e-44519195), SC_(3.2854376809849461544249645186823389479535e-44489166), SC_(1.0541921459165378773841716614592790604618e-30029), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0817516339200000000000000000000000000000e+12), SC_(1.5393168000000000000000000000000000000000e+07), SC_(9.9998575448989868164062500000000000000000e-01), SC_(2.3257807249496668414319408874823334548697e-81292824), SC_(3.7608068638403042310159899282597120402851e-81292819), SC_(6.1842217003164798358762899509760774024875e-06), SC_(9.9999381577829968352016412371004902392260e-01) }, 
      { SC_(1.2728087347200000000000000000000000000000e+12), SC_(2.3812680000000000000000000000000000000000e+06), SC_(9.9989813566207885742187500000000000000000e-01), SC_(3.6948900225630247813534401741275619090862e-65816784), SC_(1.1241495287185133368978736390114774726005e-14673971), SC_(3.2868314473921057860079183641046716367451e-51142813), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.2728087347200000000000000000000000000000e+12), SC_(7.9934700000000000000000000000000000000000e+06), SC_(9.9998372793197631835937500000000000000000e-01), SC_(9.1736557910826772467040055287472354213489e-47272043), SC_(9.8830085864725315646649020107298097777291e-45053788), SC_(9.2822501476313719233238340353518419973114e-2218256), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.2728087347200000000000000000000000000000e+12), SC_(1.5393168000000000000000000000000000000000e+07), SC_(9.9998694658279418945312500000000000000000e-01), SC_(9.9871617076394215343482999901350101596173e-82400119), SC_(1.7982567628805513164721163082264438987906e-82380117), SC_(5.5538018339724802981269582109648165246413e-20002), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.2728087347200000000000000000000000000000e+12), SC_(1.8907696000000000000000000000000000000000e+07), SC_(9.9998515844345092773437500000000000000000e-01), SC_(5.6911712371451191546793733229095185848466e-99500284), SC_(2.7398036679964406630476792082766168887765e-99500288), SC_(9.9995186102012250980477933663466132120549e-01), SC_(4.8138979877490195220663365338678794509716e-05) }
   }};
//#undef SC_

