# Asciidoctor Tabs

An Asciidoctor.js extension that adds a tabs block to the AsciiDoc syntax.

## Install

This package depends on the `asciidoctor` package (>= 2.2.0, &lt; 3.0.0), but doesn’t declare it as a dependency.
Therefore, you must install that package when installing this one.

```console
$ npm i asciidoctor @asciidoctor/tabs
```

## Syntax

A tabset is defined using a description list (dlist) enclosed in an example block annotated with the tabs style.

```asciidoc
[tabs]
====
Tab A:: Contents of Tab A.

Tab B::
+
Contents of Tab B.

Tab C::
+
--
Contents of Tab C.

Contains more than one block.
--
====
```

You may choose to extend the block delimiter length from the typical 4 characters to 6 in order to avoid conflicts with any example blocks inside the tabs block (or just as a matter of style).

```asciidoc
[tabs]
======
Tab A::
+
====
Example block in Tab A.
====

Tab B:: Just text.
======
```

Using this technique, you can also create nested tabsets.

```asciidoc
[tabs]
======
Tab A::
+
Selecting Tab A reveals a tabset with Tab Y and Tab Z.
+
[tabs]
====
Tab Y:: Contents of Tab Y, nested inside Tab A.
Tab Z:: Contents of Tab Z, nested inside Tab A.
====

Tab B:: Just text.
======
```

## Usage

### CLI

```console
$ npx asciidoctor -r @asciidoctor/tabs tabs.adoc
```

The `asciidoctor` command automatically registers the tabs extension when the package is required.

### API

There are two ways to use the extension with the Asciidoctor.js API.
In either case, you must require the Asciidoctor.js module (`asciidoctor`) before requiring this one.

You can call the exported `register` method with no arguments to register the extension as a global extension.

```js
const Asciidoctor = require('asciidoctor')()

require('@asciidoctor/tabs').register()

Asciidoctor.convertFile('tabs.adoc', { safe: 'safe' })
```

Or you can pass a registry instance to the `register` method to register the extension with a scoped registry.

```js
const Asciidoctor = require('asciidoctor')()

const registry = Asciidoctor.Extensions.create()
require('@asciidoctor/tabs').register(registry)

Asciidoctor.convertFile('tabs.adoc', { extension_registry: registry, safe: 'safe' })
```

You can also require `@asciidoctor/tabs/extensions` to access the `Extensions` class.
Attached to that object are the `Block`, `Docinfo.Style`, and `Docinfo.Behavior` extension classes.
You can use these classes to register a bespoke tabs extension.

## Copyright and License

Copyright (C) 2018-present Dan Allen (OpenDevise Inc.) and the individual contributors to this project.
Use of this software is granted under the terms of the MIT License.
