(*^

::[paletteColors = 128; 
	fontset = title, "Helvetica-Bold", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Helvetica-Bold", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Helvetica-Bold", 14, L2, center, bold, nohscroll;
	fontset = section, "Helvetica-Bold", 16, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Helvetica-Bold", 13, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Helvetica-Bold", 12, L2, bold, nohscroll, whiteBox;
	fontset = text, "Times-Roman", 12, L2, nohscroll;
	fontset = smalltext, "Times-Roman", 10, L2, nohscroll;
	fontset = input, "Courier-Bold", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R21845, G21845, B21845, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Times-Italic", 11, L2, italic, R21845, G21845, B21845, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Times-Roman", 13, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "Courier", 16, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
Display Evaluation Timings
:[font = text; inactive; ]
This example comes from subsection 8.2.2.
This is another way of printing evaluation timings. See PrintTime.m.
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

:[font = section; inactive; startGroup; Cclosed; ]
Implementation
:[font = input; initialization; ]
*)
ShowTime::usage = "On[ShowTime] turns timing info on. Off[ShowTime] turns it off again.
	The time taken for each command is printed before the result (if any)."
(*
:[font = input; initialization; ]
*)
Begin["ShowTime`"]
(*
:[font = input; initialization; ]
*)
`oldPre =.        (* user's value of $Pre *)
`ison = False     (* whether ShowTime is currently turned on *)
(*
:[font = input; initialization; ]
*)
Attributes[ShowTime] = HoldFirst
(*
:[font = input; initialization; ]
*)
ShowTime::twice = "ShowTime is already on."
ShowTime::off = "ShowTime is not in effect."
(*
:[font = input; initialization; ]
*)
ShowTime[expr_] :=
	Block[{`timing},
		Block[{$Pre = oldPre},
			timing = Timing[ oldPre[expr] ];
			Print[ timing[[1]] ];
			oldPre = If[ ValueQ[$Pre], $Pre, Identity ];
		];
		If[ !ison, $Pre = oldPre ];  (* turn it off again *)
		timing[[2]]
	]
(*
:[font = input; initialization; ]
*)
ShowTime/: On[ShowTime] := (
	If[ ison,
		Message[ShowTime::twice],
	(* else *)
		oldPre = If[ ValueQ[$Pre], $Pre, Identity ];
		$Pre = ShowTime;
		ison = True
	]; )
(*
:[font = input; initialization; ]
*)
ShowTime/: Off[ShowTime] := (
	If[ ison,
		ison = False,
	(* else *)
		Message[ShowTime::off]
	]; )
(*
:[font = input; initialization; ]
*)
End[]
(*
:[font = input; initialization; endGroup; ]
*)
On[ShowTime]
(*
^*)