(*^

::[paletteColors = 128; 
	fontset = title, "Helvetica-Bold", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Helvetica-Bold", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Helvetica-Bold", 14, L2, center, bold, nohscroll;
	fontset = section, "Helvetica-Bold", 16, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Helvetica-Bold", 13, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Helvetica-Bold", 12, L2, bold, nohscroll, whiteBox;
	fontset = text, "Times-Roman", 12, L2, nohscroll;
	fontset = smalltext, "Times-Roman", 10, L2, nohscroll;
	fontset = input, "Courier-Bold", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R21845, G21845, B21845, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Times-Italic", 11, L2, italic, R21845, G21845, B21845, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Times-Roman", 13, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "Courier", 16, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
Polyhedra
:[font = text; inactive; ]
Some polyhedra from section 4.5.
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

:[font = subsection; inactive; startGroup; Cclosed; ]
Initialization
:[font = input; initialization; ]
*)
Needs["Graphics`Polyhedra`"]
(*
:[font = input; initialization; endGroup; ]
*)
icosa = Polyhedron[Icosahedron];
dodeca = Polyhedron[Dodecahedron];
(*
:[font = subsection; inactive; startGroup; Cclosed; ]
Intersection of icosahedron and dodecahedron
:[font = input; endGroup; ]
Show[ {icosa, dodeca}, Boxed -> False ];
:[font = subsection; inactive; startGroup; Cclosed; ]
WRI's Stellated Icosahedron
:[font = input; endGroup; ]
Show[ Stellate[ icosa ] ];
:[font = subsection; inactive; startGroup; Cclosed; ]
Great Dodecahedron
:[font = input; endGroup; ]
Show[ Stellate[ icosa, 1/Sqrt[2.0] ], Boxed -> False ];
:[font = subsection; inactive; startGroup; Cclosed; ]
Small Stellated Dodecahedron
:[font = input; endGroup; ]
Show[ Stellate[ dodeca, Sqrt[5.0] ], Boxed -> False ];
:[font = subsection; inactive; startGroup; Cclosed; ]
Great Stellated Dodecahedron
:[font = input; endGroup; ]
Show[ Stellate[icosa, 3], Boxed -> False ];
:[font = subsection; inactive; startGroup; Cclosed; ]
Great Icosahedron
:[font = text; inactive; endGroup; ]
See file BookPictures for the Great Icosahedron!
^*)