#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: server.c,v 1.7 1993/10/28 16:18:59 gbourhis Exp $";
#endif

/* $Log: server.c,v $
 * Revision 1.7  1993/10/28  16:18:59  gbourhis
 * Fix a bug in AltPollAndService() that can make the server hang.
 *
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <dtm/dtm.h>
#include <dtm/srv.h>

#include "collab.h"
#include "client.h"
#include "list.h"

#define MAXBUFFSIZE	524288

extern List conList;
extern CLIENT *GetClientByAddress();
extern CLIENT *RecvAddress();
extern int debug;



static void
DEFUN(ToAll, (client, header),
      CLIENT *client AND
      char *header)
{
	CLIENT *cc;

	for (cc = (CLIENT *) ListHead(conList);
	     cc;
	     cc = (CLIENT *) ListNext(conList))
	{
		if ((cc->isAClient)&&(cc != client))
		{
			DTMwriteMsg(cc->outPort, header, strlen(header)+1,
				    (VOIDPTR)NULL, 0, 0);
			cc->timeOut = 0;
		}
	}
}


static void
DEFUN(UpdateUsers, (client), CLIENT *client)
{
	char header[DTM_MAX_HEADER];
	CLIENT *cc;

	for (cc = (CLIENT *) ListHead(conList);
	     cc;
	     cc = (CLIENT *) ListNext(conList))
	{
		if ((cc->isAClient)&&(cc != client))
		{
			SRVsetClass(header);
			SRVsetID(header, cc->name);
			SRVsetFunction(header, SRV_FUNC_ADD_USER);
			SRVsetInPort(header, cc->inPortAddress);
			DTMbeginWrite(client->outPort, header,strlen(header)+1);
			DTMendWrite(client->outPort);
		}
	}
}


static void
DEFUN(NotifyAddUser, (client), CLIENT *client)
{
	char header[DTM_MAX_HEADER];

	SRVsetClass(header);
	SRVsetID(header, client->name);
	SRVsetFunction(header, SRV_FUNC_ADD_USER);
	SRVsetInPort(header, client->inPortAddress);
	ToAll(client, header);
	UpdateUsers(client);
}


static void
DEFUN(NotifyRemoveUser, (client), CLIENT *client)
{
	char header[DTM_MAX_HEADER];

	SRVsetClass(header);
	SRVsetID(header, client->name);
	SRVsetFunction(header, SRV_FUNC_REMOVE_USER);
	SRVsetInPort(header, client->inPortAddress);
	ToAll(client, header);
}


RecvDTMSpecialMessage(header)
char *header;
{
	header += 4;
	RecvAddress(header,(char *)0,(char *) 0,0);
}

DEFUN(RecvSRVMessage,(header,client),
      char *header AND
      CLIENT *client)
{
int	func;
char 	inport[80];
char	buff[100];
char	*id;
char	versionString[128];
int	versionNumber;


	SRVgetFunction(header,&func);


	if (func == SRV_FUNC_CONNECT) {
		CLIENT *c;

		SRVgetID(header,buff,100);
		if (!(id = (char *) MALLOC(strlen(buff)+1))) {
			ErrMesg("Can't allocate memory\n");
			return(0);
			}
		strcpy(id,buff);

		SRVgetInPort(header,inport,80);
		if (DTMERROR == SRVgetVersionString(header,versionString,128)){
			strcpy(versionString,"Unknown");
			}
		if (DTMERROR == SRVgetVersionNumber(header,&versionNumber)) {
			versionNumber = 0;
			}

		c = RecvAddress(inport,id,versionString,versionNumber);
		if (c != NULL)
			NotifyAddUser(c);
		}
	else if (func == SRV_FUNC_DISCONNECT &&
		 (client->isAClient || SRVgetInPort(header,inport,80) !=
		  DTMERROR && (client = GetClientByAddress(inport)))) {
		NotifyRemoveUser(client);
		DTMdestroyPort(client->outPort);
		DTMdestroyPort(client->inPort);
		RemoveClient(client);
		}

}


static
int DEFUN(DistributeData,(header, databuff, blen, client, conList, isLast),
	  char *header AND
	  char *databuff AND
	  int blen AND
	  CLIENT *client AND	/* from client */
	  List conList AND
	  int isLast)
{
CLIENT *cc;			/* current client */
CLIENT *nc;			/* next client */
	
	for (cc = (CLIENT *) ListHead(conList); cc; cc = nc) {
		nc = (CLIENT *) ListNext(conList);
		if ((cc->isAClient) && (cc != client)) {
			if ((nc)&&(nc->isAClient)&&(nc != client)) {
				DTMavailWrite(nc->outPort);
				}
			if (debug) {
				fprintf(stderr, "DistributeData(): sending %d \
bytes to %s ...", blen, cc->outPortAddress);
				fflush(stderr);
				}
			
			if (header != NULL && isLast)
				DTMwriteMsg(cc->outPort, header,
					    strlen(header)+1, databuff, blen,
					    DTM_CHAR);
			else {
				if (header != NULL)
					DTMbeginWrite(cc->outPort, header,
						      strlen(header)+1);
				if (blen) {
					DTMwriteDataset(cc->outPort, databuff,
							blen, DTM_CHAR);
					}
				if (isLast)
					DTMendWrite(cc->outPort);
				}
			if (debug) {
				if (isLast)
					fputs(" message sent.\n", stderr);
				else
					fputs(" sent.\n", stderr);
				}
			cc->timeOut = 0;
			}
		}
}


int ReadDataAndDistribute(client,conList)
CLIENT *client;
List conList;
{
char header[DTM_MAX_HEADER];
int length;
int blen;
int beginWrite_called = 0;
static char buff[MAXBUFFSIZE];
char *tbuff;			/* current pointer */
char *databuff;			/* previous pointer */

	if (debug) {
		fprintf(stderr, "ReadDataAndDistribute(): reading from port \
%s\n", client->inPortAddress);
		}

	if ((length = DTMbeginRead(client->inPort,header,DTM_MAX_HEADER)) 
			== DTMERROR) {
                ErrMesg("Error reading DTM header\n");
                return(0);
		}

	if (debug) {
		fprintf(stderr, "ReadDataAndDistribute(): length = %d, head\
er \"%s\"\n", length, header);
		}

        if (DTMcompareClass(header)) {
                DTMendRead(client->inPort);
                RecvDTMSpecialMessage(header);
                return(0);
		}

        if (SRVcompareClass(header)) {
                DTMendRead(client->inPort);
		RecvSRVMessage(header,client);
                return(0);
		}

	if (0 > (length = DTMreadDataset(client->inPort,buff,
					 MAXBUFFSIZE, DTM_CHAR))) {
		ErrMesg("Error reading DTM data\n");
		return(0);
		}

	if (debug) {
		fprintf(stderr, "ReadDataAndDistribute(): Just read %d bytes \
of DataSet\n",length);
		}

	databuff = buff;
	blen = length;
	while (length == MAXBUFFSIZE) {
		if (databuff == buff) {
			tbuff = (char *)MALLOC(blen + MAXBUFFSIZE);
			if (tbuff != NULL)
				bcopy(databuff, tbuff, blen);
			}
		else {
			tbuff = (char *)realloc(databuff, blen + MAXBUFFSIZE);
			}

		if (tbuff == NULL) { /* we have to flush our buffer */
			DistributeData(beginWrite_called ? NULL : header,
				       databuff, blen, client, conList,
				       0 /* ! isLast */);
			if (databuff != buff)
				FREE(databuff);
			databuff = buff;
			beginWrite_called = 1; blen = 0;
			}
		else
			databuff = tbuff;

		if ((length = DTMreadDataset(client->inPort,&databuff[blen],
					     MAXBUFFSIZE, DTM_CHAR)) < 0) {
			ErrMesg("Error reading more DTM data\n");
			return(0);
			}

		if (debug) {
			fprintf(stderr, "ReadDataAndDistribute(): Just read \
%d more bytes of DataSet\n",length);
			}
		blen += length;
		}

	DTMendRead(client->inPort);

	/* done reading in data...now distribute it. */
	DistributeData(beginWrite_called ? NULL : header,
		       databuff, blen, client, conList,
		       1 /* isLast */);
	if (databuff != buff)
		FREE(databuff);

	return(1);
} /* ReadDataAndDistribute() */


void AltPollAndService(conList)
List conList;
{
CLIENT *client;
int ret, num, cnt;
Dtm_set s[64];

	if (debug) {
		fputs("AltPollAndService called\n", stderr);
		}
	/* build client mask for DTMselectRead */
	client = (CLIENT *) ListHead(conList);
        num = 0;
        while (client) {
		s[num++].port = client->inPort;
		client = (CLIENT *) ListNext(conList);
		}

	/* find out which ones are ready to read from */
        if (DTMERROR == DTMselectRead(s,num,0,0,-1)) {
                ErrMesg("Error checking for DTM input\n");
                return;
		}

	/* this should do a round robin servicing */
	client = (CLIENT *)ListHead(conList);
        cnt = 0;
        while (client && cnt < num) {
		if (s[cnt++].status == DTM_PORT_READY) {
			ReadDataAndDistribute(client, conList);

			/* ReadDataAndDistribute() is destructive on 
				List current pointer.... so put it back */
			ret = ListMakeEntryCurrent(conList, client);
			if (!ret) {
				break;
				}
			}
		client = (CLIENT *) ListNext(conList);
		}
} /* AltPollAndService() */




int
Init(conList,dtmInPort)
	List *conList;
	char *dtmInPort;
{
	CLIENT *s;
	char buff[256];

	*conList = (List) ListCreate();
	if (!(s = (CLIENT *) MALLOC(sizeof(CLIENT))))
	{
		ErrMesg("Out Of Memory");
		return(0);
	}

	if (DTMERROR ==
	    (s->inPort = DTMmakeInPort(dtmInPort, DTM_DEFAULT)))
	{
		sprintf(buff, "Can't make DTM in port \"%s\" because: %s\n",
			dtmInPort, DTMerrmsg(1));
		ErrMesg(buff);
		return(0);
	}

	s->inPortAddress = dtmInPort;
	s->outPortAddress = "SERVER (no outPort)";
	s->isAClient = FALSE;
	s->versionName = "Collage Server Version 1.2.1";
	s->versionNumber = 1; /* lowest protocol ver. server will work with */

	ListAddEntry(*conList, s);

	return(1);
}

