/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: sheet.c,v 1.4 1993/09/01 20:27:25 davet Exp $";
#endif


#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/MenuShell.h>
#include <Xm/RowColumn.h>
#include <Xm/DrawingA.h>
#include <Xm/ScrollBar.h>
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleBG.h>
#include <Xm/Label.h>
#include <Xm/DialogS.h>
#include <Xm/Separator.h>


#include <netdb.h>
#include <sys/socket.h>


#include "list.h"
#include "view.h"
#include "viewer.h"
#include "doodle.h"
#include "mode.h"

#define DEF_WHITE	WhitePixel(myDpy, DefaultScreen(myDpy))
#define DEF_BLACK	BlackPixel(myDpy, DefaultScreen(myDpy))
#define DEF_DEPTH	DefaultDepth(myDpy, DefaultScreen(myDpy))
#define DEF_ROOT	DefaultRootWindow(myDpy)

extern void MakeCurrentSheet();
extern void CBPublish();
extern void CBViewOverlay();
extern void SetDoodleMode();
extern void SetEraseMode();
extern void SetEraseBlockMode();
extern void SetLineMode();
extern void SetAreaMode();
extern void CBSelection();
extern void CBClearDrawArea();
extern void CBDrawAreaPress();
extern void CBDrawAreaMove();
extern void CBDrawAreaRelease();
extern void CBDrawAreaKeyPress();
extern void CBGetMagnification();
extern void CBDone();
extern void CBSetLine();
extern void CBSetLineSelect();
extern void CBSetArrow();
extern void CBSetOval();
extern void CBSetBox();
extern void CBSetFreehand();
extern void CBSetText();
extern void CBSetErase();
extern void CBSetEraseBlock();
extern void CBGrabProc();
extern void CBSetPaste();
extern void CBSetPasteNoBack();
extern void CBDrawAreaRowsExposed();
extern void CBDrawAreaColsExposed();
extern void CBDrawAreaExposed();
extern void CBDrawAreaResize();
extern Cdata *CopyCdata();
extern Dptr *InitDHash();
extern Widget InitOptions();
extern Widget InitOverlayTools();
extern void InitSelMenu();
extern void RegisterData();
extern int InitCdata();



extern List *objectList;
extern Display *myDpy;
extern Pixmap drawPix;
extern Pixmap doodlePix;
extern Pixmap scratchPix;
extern Pixmap row_arrow, col_arrow;
extern int Swidth, Sheight, Sascent;
extern Widget	rootWidget;
extern XFontStruct *drawFont;

extern charRec *fontTable;




extern void ScrollYChanged();
extern void ScrollXChanged();
extern void RowsExposed();
extern void ColsExposed();
extern void SheetExposed();


XtCallbackRec ScrollYList[] = {
	{ScrollYChanged, NULL},
	{NULL, NULL}
};
XtCallbackRec ScrollXList[] = {
	{ScrollXChanged, NULL},
	{NULL, NULL}
};



View *
InitSheet(vroot, data, ispub)
	Widget vroot;
	Cdata *data;
	Boolean ispub;
{
	View *V;
	Widget  viewshell;
	Widget  b;
	Widget	mainWindow;
	Widget	toolform, overlayform, paletteform;
	Widget	mainForm, vscroll, hscroll, rframe, cframe, rowwin, colwin;
	Widget	menuBar;
	Widget	vertScroll,horizScroll;
	Widget	drawArea;
	Widget	pulldown;
	Widget pubPulldown, priPulldown;
	Arg     argList[30];
	Cardinal i=0;
	XmString label;
	char tlab[256];
	int cnt, theight, twidth;
	Pixmap *dptr;

	if (!(V = (View *)MALLOC(sizeof(View))))
	{
		fprintf(stderr,"Out of Memory\n");
		exit(1);
	}
        V->type = V_SHEET;
        V->cData = data;


	if (ispub == True)
	{
		sprintf(tlab, "Public %s", data->name);
	}
	else
	{
		sprintf(tlab, "Private %s", data->name);
	}

	/*
	 * theight is height of column tracking window.
	 * twidth is width of row tracking window.
	 * these values are used to calculate the layout of all children
	 * inside the mainForm widget.
	 */
	theight = Sheight + (Sheight / 2);
	twidth = Swidth * S_INDEX;

	/*
	 * Set some necessary resources on the top level shell widget.
	 */
	i = 0;
	if (data->hasPalette)
	  {
	    XtSetArg(argList[i], XtNbackground, 0); i++;
	    XtSetArg(argList[i], XtNcolormap, data->pal->Rcmap); i++;
	  }
        XtSetArg(argList[i], XmNallowShellResize, True); i++;
        XtSetArg(argList[i], XmNkeyboardFocusPolicy, XmPOINTER); i++;
        XtSetArg(argList[i], XmNdeleteResponse, XmUNMAP); i++;
	viewshell = XtCreatePopupShell(tlab, topLevelShellWidgetClass,
					vroot, argList, i);

	/*
	 * Create the main window area, which is a form widget containing
	 * a menubar, and another form widget.
	 */
	i = 0;
	if (data->hasPalette)
	  {
	    XtSetArg(argList[i], XtNcolormap,
		     DefaultColormapOfScreen(XtScreen(viewshell))); i++;
	  }
        XtSetArg(argList[i], XmNresizePolicy, XmRESIZE_GROW); i++;
	mainWindow = XmCreateForm(viewshell, tlab, argList,i);
	XtManageChild(mainWindow);

	/*
	 * Create the menubar to hang all our menus off of
	 */
	i = 0;
        XtSetArg(argList[i], XmNtopAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
	menuBar = XmCreateMenuBar(mainWindow, tlab, argList, i);
	XtManageChild(menuBar);

	/*
	 * InitOverlayTools sets up the toolbox and sets V->colorpal
	 */
	toolform = InitOverlayTools(V, mainWindow, menuBar,
		&overlayform, &paletteform);

	i = 0;
        XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
        XtSetArg(argList[i], XmNtopWidget, menuBar); i++;
        XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
/*
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
*/
	XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
	XtSetArg(argList[i], XmNleftWidget, toolform); i++;
        XtSetArg(argList[i], XmNresizePolicy, XmRESIZE_ANY); i++;
	mainForm = XmCreateForm(mainWindow, "form1", argList, i);

	/*
	 * set up the main number display area.
	 * This consists of a drawing area in the center, with horizontal
	 * and vertical scrollbars to the right and bottom.  To the
	 * top and left are two smaller drawing areas that contain the row
	 * and column indecies.
	 * Due to a Motif bug in the Drawing Area widget, I have to put the
	 * row and column index windows inside of frame widgets to get their
	 * 3D borders to behave properly.
	 */
	ScrollYList[0].closure = (caddr_t)V;
	i = 0;
        XtSetArg(argList[i], XmNwidth, 15); i++;
        XtSetArg(argList[i], XmNheight, (279 - (theight + 4))); i++;
        XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
        XtSetArg(argList[i], XmNtopAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNtopOffset, (theight + 8)); i++;
        XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNbottomOffset, 17); i++;
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_NONE); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNdragCallback, ScrollYList); i++;
        XtSetArg(argList[i], XmNvalueChangedCallback, ScrollYList); i++;
	XtSetArg(argList[i], XmNrepeatDelay, 1); i++;
	vscroll = XmCreateScrollBar(mainForm, "ScrollBar", argList, i);

	ScrollXList[0].closure = (caddr_t)V;
	i = 0;
        XtSetArg(argList[i], XmNwidth, (279 - (twidth + 4))); i++;
        XtSetArg(argList[i], XmNheight, 15); i++;
        XtSetArg(argList[i], XmNorientation, XmHORIZONTAL); i++;
        XtSetArg(argList[i], XmNtopAttachment, XmATTACH_NONE); i++;
        XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNleftOffset, (twidth + 8)); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNrightOffset, 17); i++;
        XtSetArg(argList[i], XmNdragCallback, ScrollXList); i++;
        XtSetArg(argList[i], XmNvalueChangedCallback, ScrollXList); i++;
	XtSetArg(argList[i], XmNrepeatDelay, 1); i++;
	hscroll = XmCreateScrollBar(mainForm, "ScrollBar", argList, i);

	i = 0;
        XtSetArg(argList[i], XmNshadowType, XmSHADOW_IN); i++;
        XtSetArg(argList[i], XmNtopAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNtopOffset, (theight + 8)); i++;
        XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNbottomOffset, 17); i++;
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNleftOffset, 2); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_NONE); i++;
/*
        XtSetArg(argList[i], XmNshadowThickness, 2); i++;
*/
	rframe = XmCreateFrame(mainForm, "viewer", argList, i);

	i = 0;
        XtSetArg(argList[i], XmNwidth, twidth); i++;
        XtSetArg(argList[i], XmNheight, (279 - (theight + 4))); i++;
	rowwin = XmCreateDrawingArea(rframe, "viewer", argList, i);
	XtAddEventHandler(rowwin, ExposureMask, 0, CBDrawAreaRowsExposed,
					(caddr_t)V);

	i = 0;
        XtSetArg(argList[i], XmNshadowType, XmSHADOW_IN); i++;
        XtSetArg(argList[i], XmNtopAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNtopOffset, 2); i++;
        XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_NONE); i++;
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNleftOffset, (twidth + 8)); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNrightOffset, 17); i++;
/*
        XtSetArg(argList[i], XmNshadowThickness, 2); i++;
*/
	cframe = XmCreateFrame(mainForm, "viewer", argList, i);

	i = 0;
        XtSetArg(argList[i], XmNwidth, (279 - (twidth + 4))); i++;
        XtSetArg(argList[i], XmNheight, theight); i++;
	colwin = XmCreateDrawingArea(cframe, "viewer", argList, i);
	XtAddEventHandler(colwin, ExposureMask, 0, CBDrawAreaColsExposed,
					(caddr_t)V);

	i = 0;
        XtSetArg(argList[i], XmNwidth, (275 - (twidth + 4))); i++;
        XtSetArg(argList[i], XmNheight, (275 - (theight + 4))); i++;
        XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
        XtSetArg(argList[i], XmNtopWidget, cframe); i++;
        XtSetArg(argList[i], XmNtopOffset, 4); i++;
        XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_WIDGET); i++;
        XtSetArg(argList[i], XmNbottomWidget, hscroll); i++;
        XtSetArg(argList[i], XmNbottomOffset, 4); i++;
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_WIDGET); i++;
        XtSetArg(argList[i], XmNleftWidget, rframe); i++;
        XtSetArg(argList[i], XmNleftOffset, 4); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_WIDGET); i++;
        XtSetArg(argList[i], XmNrightWidget, vscroll); i++;
        XtSetArg(argList[i], XmNrightOffset, 4); i++;
	drawArea = XmCreateDrawingArea(mainForm, "viewer", argList, i);
	XtAddEventHandler(drawArea, ExposureMask, 0, CBDrawAreaExposed,
				(caddr_t)V);
	XtAddEventHandler(drawArea, StructureNotifyMask, 0, CBDrawAreaResize,
				(caddr_t)V);
	XtAddEventHandler(drawArea, ButtonPressMask, 0, CBDrawAreaPress,
				(caddr_t)V);
	XtAddEventHandler(drawArea, ButtonMotionMask, 0, CBDrawAreaMove,
				(caddr_t)V);
	XtAddEventHandler(drawArea, ButtonReleaseMask, 0, CBDrawAreaRelease,
				(caddr_t)V);
	XtAddEventHandler(drawArea, KeyPressMask, 0, CBDrawAreaKeyPress,
				(caddr_t)V);

	XtManageChild(rowwin);
	XtManageChild(rframe);
	XtManageChild(colwin);
	XtManageChild(cframe);
	XtManageChild(vscroll);
	XtManageChild(hscroll);
	XtManageChild(drawArea);
	XtManageChild(mainForm);

	/*
	 * File menu
	 */
	i = 0;
	XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
	pulldown = XmCreatePulldownMenu(menuBar, "pulldown", argList, i);

	i = 0;
	label = XmStringCreateLtoR("File", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i], XmNsubMenuId, pulldown); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNmnemonic, 'F'); i++;
	b = XmCreateCascadeButton(menuBar, "viewer", argList, i);
	XtManageChild(b);

	i = 0;
	label = XmStringCreateSimple("Publish");
        XtSetArg(argList[i], XmNmnemonic, 'u'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(pulldown, "menuButton", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBPublish, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateLtoR("Make Image", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i], XmNmnemonic, 'M'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(pulldown, "menuButton", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBGetMagnification, (caddr_t)V);
	XtManageChild(b);

	i = 0;
	b = XmCreateSeparator(pulldown, "separator", argList, i);
	XtManageChild(b);

	i = 0;
	label = XmStringCreateSimple("Close Window");
        XtSetArg(argList[i], XmNmnemonic, 'C'); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
	b = XmCreatePushButtonGadget(pulldown, "menuButton", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBDone, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);
	
	/*
	 * Edit menu
	 */
	i = 0;
	XtSetArg(argList[i], XmNorientation, XmVERTICAL); i++;
	pulldown = XmCreatePulldownMenu(menuBar, "pulldown", argList, i);

	i = 0;
	label = XmStringCreateSimple("Edit");
        XtSetArg(argList[i], XmNsubMenuId, pulldown); i++;
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNmnemonic, 'E'); i++;
	b = XmCreateCascadeButton(menuBar, "viewer", argList, i);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Show Overlay");
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNmnemonic, 'S'); i++;
	XtSetArg(argList[i], XmNset, True); i++;
	XtSetArg(argList[i], XmNvisibleWhenOff, True); i++;
	b = XmCreateToggleButtonGadget(pulldown, "viewer", argList, i);
	XtAddCallback(b, XmNvalueChangedCallback, CBViewOverlay, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Clear Overlay");
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'l'); i++;
	b = XmCreatePushButtonGadget(pulldown, "viewer", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBClearDrawArea, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	b = XmCreateSeparator(pulldown, "separator", argList, i);
	XtManageChild(b);

	i = 0;
	label = XmStringCreateSimple("Copy");
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'C'); i++;
	b = XmCreatePushButtonGadget(pulldown, "viewer", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBGrabProc, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Paste");
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'P'); i++;
	b = XmCreatePushButtonGadget(pulldown, "viewer", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetPaste, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	i = 0;
	label = XmStringCreateSimple("Paste (No Back)");
	XtSetArg(argList[i], XmNlabelString, label); i++;
	XtSetArg(argList[i], XmNmnemonic, 'N'); i++;
	b = XmCreatePushButtonGadget(pulldown, "viewer", argList, i);
	XtAddCallback(b, XmNactivateCallback, CBSetPasteNoBack, (caddr_t)V);
	XtManageChild(b);
	XmStringFree(label);

	/*
	 * Operations menu
	 */
        V->optionMenu = (Widget) 0;
        V->operationMenu = (Widget) 0;
/*
	InitSelMenu(V, menuBar);
*/

	/*
	 * Now is only Width menu
	 */
	V->optionMenu = InitOptions(V, menuBar);

        V->shell = viewshell;
        V->drawArea = drawArea;
/*
        V->colorpal = (Widget)NULL;
*/
	V->toolform = overlayform;
	V->palform = paletteform;
        V->rowwin = rowwin;
        V->colwin = colwin;
        V->vscroll = vscroll;
        V->hscroll = hscroll;
	V->lastToggle = (Widget)NULL;
	V->dialog = (Widget)NULL;
	V->cutbuffer = (XImage *)NULL;
        V->drawPix = (Pixmap)NULL;
        V->doodlePix = (Pixmap)NULL;
        V->isUp = False;
        V->ispub = ispub;
	V->viewEntirePal = False;
	V->viewOverlay = True;
	V->areaSelect = False;
	V->area_x1 = -1;
	V->area_y1 = -1;
	V->area_x2 = -1;
	V->area_y2 = -1;
	V->lineSelect = False;
	V->pointSelect = False;
	V->Mode = NONE;
#ifdef MAC_COMPAT
	V->doodleWidth = 5;
#else
	V->doodleWidth = 5;
#endif /* MAC_COMPAT */
        V->next = NULL;
        V->text_x = 0;
        V->text_y = 0;
        V->ret_x = 0;
        V->Scroll_x = 0;
        V->Scroll_y = 0;
        data->V = V;
	V->doodleColor = DEF_BLACK;
#ifdef MAC_COMPAT
	/*
	 * On the Mac White = Transparent.  So for a Mac pick a default
	 * doodle color that is real unlikely to be white.
	 */
	V->doodleColor = 128;
#endif /* MAC_COMPAT */

	V->Doodles = InitDHash();

	return(V);
}


void
CBMakeSheet(w, client_data, call_data)
	Widget w;
	caddr_t client_data;
	caddr_t call_data;
{
	View *V = (View *)client_data;
	View *newV;
	int new;
	Cdata *newData;

/* Can't make spreadsheet of Whiteboard
	if (strcmp(V->cData->name, "Whiteboard") == 0)
	{
		if (V->cData->type == D_CHAR)
		{
			if (V->cData->buff != NULL)
			{
				FREE(V->cData->buff);
			}
			V->cData->buff = (char *)
				MALLOC(V->cData->xdim * V->cData->ydim);
		}
		else if (V->cData->type == D_FLOAT)
		{
			if (V->cData->fbuff != NULL)
			{
				FREE(V->cData->fbuff);
			}
			V->cData->fbuff = (float *)
				MALLOC(V->cData->xdim * V->cData->ydim *
					sizeof(float));
		}
	}
*/

	newData = CopyCdata(V->cData, &new);
	if (newData == NULL)
	{
		return;
	}
/*
	newData->hasPalette = False;
*/
	if (new)
	  {
		ListAddEntry(objectList, newData);
		newV = InitSheet(rootWidget, newData, V->ispub);
		RegisterData(newData);
		XtPopup(newV->shell, XtGrabNone);
		newV->cmap = DefaultColormap(myDpy, XDefaultScreen(myDpy));
	  }
	else
		newV = newData->V;

	newV->next = V;
	V->next = newV;

	MakeCurrentSheet(newV);
}


View *
NewSheet(data, ispub)
	Cdata *data;
	Boolean ispub;
{
	View *V;

	V = InitSheet(rootWidget, data, ispub);
	XtPopup(V->shell, XtGrabNone);
	V->cmap = DefaultColormap(myDpy, XDefaultScreen(myDpy));
	return(V);
}

