/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: profUI.c,v 1.7 1993/07/21 21:56:46 gbourhis Exp $";
#endif


#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleB.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <Xm/FileSB.h>
#include <Xm/Text.h>

#include "dtm/dtm.h"
#include "dtm/col.h"
#include "dtm/dol.h"

#include "list.h"
#include "netdata.h"
#include "net.h"
#include "view.h"
#include "profUI.h"

#define	MALLOC	malloc
#define FREE	free

#define        ABS(x)  ((x)>0) ? (x): (-1.0*(x))
#define ROUND(x)        ((int) (x + 0.5))


extern Cdata *CdataSearchByName();
extern void CBInitProfBox();
extern void CBProfBox();
extern void CBDoneProfBox();


static Display	*myDpy;
static List	profileList;


/*ARGSUSED*/
static void CBProfDone(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Profile *profile;

        profile = (Profile *) client_data;

	/*
        XtUnmanageChild(profile->mainWindow);
	*/
	XtPopdown(profile->top);
	profile->amIShowing = FALSE;
}

/*ARGSUSED*/
static void CBMapChange(w,client_data,event)
Widget w;
caddr_t client_data;
XEvent *event;
{
Profile *profile;

        profile = (Profile *) client_data;
	if (event->type == UnmapNotify) {
		profile->amIShowing = FALSE;
		}
	else if (event->type == MapNotify) {
		profile->amIShowing = TRUE;
		}
}


/*ARGSUSED*/
static void CBProfPrint(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
/*Profile *profile;*/

        WriteMesg("Sorry, don't know how to print yet\n");
}




/*ARGSUSED*/
static void CBProfileExpose(w,client_data,event)
Widget w;
caddr_t client_data;
XEvent *event;
{
	Profile *profile;
	Window win;
	XWindowAttributes winAttrib;
	int	width;
	int	height;
	char	buff[256];
	int	textPlace;
	int	x1,y1,x2,y2;
	int     gwidth; /* graph width */
	int     gheight; /* graph height */
	int     dwidth; /* data width */
	/* int     dheight;  data height */
	double  dXInc;  /*data X Increment */
	double  dYInc;  /*data Y Increment */
	double  dX,dY; /*data X and Y location */
	int     value;
	double  fvalue;
	int     lvalue; /* last value */
	double  flvalue;
	double  frange;
	int     plotY1,plotY2;
	double  realTick;
	register int x,y;
	Cdata	*data;

	if ((event)&&(!((event->type == Expose) || 
		(event->type == ConfigureNotify))))
		return;

	profile = (Profile *) client_data;
        data = profile->data;

	win = XtWindow(profile->profileWin);
	XSetForeground(myDpy,profile->profileGC,profile->foreground);
	XSetBackground(myDpy,profile->profileGC,profile->background);

        XGetWindowAttributes(myDpy,win,&winAttrib);
        width = winAttrib.width;
        height = winAttrib.height;

        XClearWindow(myDpy,win);

	if ((profile->selBegX == profile->selEndX)
                && (profile->selBegY == profile->selEndY)) {
                sprintf(buff,"No Line Selected");
                textPlace = (width - profile->fontWidth*strlen(buff))/2;
                textPlace =(textPlace > 0)? textPlace:0;
                XDrawString(myDpy,win,profile->profileGC,textPlace,height/2,
                        buff,strlen(buff));
                return;
                }
		
	if (profile->minValue.i == profile->maxValue.i) {
		sprintf(buff,"Minimum value equals maximum value: no plot");
                textPlace = (width - profile->fontWidth*strlen(buff))/2;
                textPlace =(textPlace > 0)? textPlace:0;
                XDrawString(myDpy,win,profile->profileGC,
				textPlace,height/2,buff,strlen(buff));
		return;
		}

	XDrawLine(myDpy,win,profile->profileGC,
				60,20,60,height-40); /*vert*/
	XDrawLine(myDpy,win,profile->profileGC,
				60,height-40,width-60,height-40);/*hor*/

	if (profile->selBegX <= profile->selEndX) {
	        x1 = profile->selBegX / data->xmag;
	        y1 = profile->selBegY / data->ymag;
	        x2 = profile->selEndX / data->xmag;
	        y2 = profile->selEndY / data->ymag;
	        }
	else {
	        x1 = profile->selEndX / data->xmag;
	        y1 = profile->selEndY / data->ymag;
	        x2 = profile->selBegX / data->xmag;
	        y2 = profile->selBegY / data->ymag;
	        }
	sprintf(buff,"Selected Line (%d,%d) to (%d,%d)",
	                x1,y1,x2,y2);
	textPlace = (width - profile->fontWidth*strlen(buff))/2;
	textPlace =(textPlace > 0)? textPlace:0;
	XDrawString(myDpy,win,profile->profileGC,textPlace,height-20,
	        buff,strlen(buff));
	gwidth = width - 60 /*left*/ - 70 /*right */;
	gheight = height - 40 /*bottom*/ - 20 /*top*/;
	dwidth = ABS(x2 - x1);
/*	dheight = ABS(y2 - y1); */
	dX = x1;
	dY = y1;
	dXInc = ((double)dwidth) / ((double)gwidth);
	dYInc = ((double)(y2 - y1)) / ((double) (gwidth));

	if (data->type == D_FLOAT) {
		flvalue=(double)(data->fbuff[data->xdim/data->xmag
					     *ROUND(dY)+ROUND(dX)]
				 - profile->minValue.f);
		frange = (double)(profile->maxValue.f - profile->minValue.f);
	      }
	else {
	  if (data->type == D_INT)
		lvalue = (int) (((int *)data->fbuff)[data->xdim/data->xmag
						*ROUND(dY)+ROUND(dX)]
				- profile->minValue.i);
	  else			/* must be D_CHAR */
		lvalue = (int) (((unsigned char *)data->buff)[data->xdim
						*ROUND(dY)+ROUND(dX)]
				- profile->minValue.i);
	  frange = (double) (profile->maxValue.i - profile->minValue.i);
	}

        dX = dX + dXInc;
        dY = dY + dYInc;

	for(x = 70; x < 70 + gwidth-1; x++) {

		if (data->type == D_FLOAT) {
		    fvalue = (double)(data->fbuff[data->xdim/data->xmag
						*ROUND(dY)+ROUND(dX)]
				    - profile->minValue.f);
		    plotY1 = gheight - (int)(((double)gheight)*((double)
	                ((double)flvalue) / frange));
		    plotY2 = gheight - (int)(((double)gheight)*((double)
	                ((double)fvalue) / frange));
		    flvalue = fvalue;
		}
		else {
		    if (data->type == D_INT)
			value = ((int *)data->fbuff)[data->xdim/data->xmag
						*ROUND(dY)+ROUND(dX)]
				- profile->minValue.i;
		    else	/* must be D_CHAR */
			value = (int) (((unsigned char *)data->buff)[data->xdim
					*ROUND(dY)+ROUND(dX)]
			       - profile->minValue.i);
		    plotY1 = gheight - (int)(((double)gheight)*((double)
				((double)lvalue) / ((double)frange)));
		    plotY2 = gheight- (int)(((double)gheight)*((double)
				((double)value) / (((double)frange))));
		    lvalue = value;
		}

		XDrawLine(myDpy,win,profile->profileGC,
			  x-1,plotY1+20,x,plotY2+20);
	                        /* 20 == distance from top */

		dX += dXInc;
		dY += dYInc;
	}

        if (data->type == D_FLOAT)
	  realTick= (double) profile->minValue.f;
        else
	  realTick= (double) profile->minValue.i;

	for(y=0; y <= gheight; y = y + gheight/10) {
	        if (data->type == D_FLOAT)
	                sprintf(buff,profile->format,(float) realTick);
	        else
	                sprintf(buff,profile->format,(int) realTick);
	        XDrawString(myDpy,win,profile->profileGC,
				55- profile->fontWidth*strlen(buff),
	                        gheight + 20 - y + (profile->fontHeight/2),
	                        buff,strlen(buff));
	        if (data->type == D_FLOAT)
		  realTick += ( (double)profile->maxValue.f
			       - (double)profile->minValue.f)
		    / (double)10.0;
		else
		  realTick += ( (double)profile->maxValue.i -
			       (double)profile->minValue.i ) / 10.;
	        XDrawLine(myDpy,win,profile->profileGC,57,
	                gheight + 20 - y,
	                63,gheight + 20 - y);
	        }

} /* CBProfileExpose() */


Profile *ProfileSearchByName(name)
char *name;
{
Profile *profile;

	profile = (Profile *) ListHead(profileList);
	while(profile) {
		if (!strcmp(profile->data->name,name))
			return(profile);
		profile = (Profile *) ListNext(profileList);
		}
	return(0);

}


Profile *ProfileCreate(rootWidget,data)
Widget 	rootWidget;
Cdata 	*data;
{
Arg argList[15];
Cardinal i=0;
XmString label;
Profile *profile;
XGCValues gcval;
char buff[1024];
Widget b;
XFontStruct *fontStruct;

	if (!(profile = (Profile *) MALLOC (sizeof(Profile)))) {
		ErrMesg("Out of Memory making Profile plot\n");
		return(0);
		}

	profile->data = data;
	if (data->type == D_FLOAT || data->type == D_INT) {
		profile->minValue = data->min;
		profile->maxValue = data->max;
		}
	else if (data->type == D_CHAR) {
		profile->minValue.i = 0;
		profile->maxValue.i = 255;
		}
	else {
		ErrMesg("Profile can only handle Float, Int and Char data\n");
		return(0);
	      }

	sprintf(buff,"Profile of %s",data->name);
	i = 0;
        XtSetArg(argList[i], XmNallowShellResize, True); i++;
        XtSetArg(argList[i], XtNtitle, buff); i++;
        XtSetArg(argList[i], XmNkeyboardFocusPolicy, XmPOINTER); i++;
        XtSetArg(argList[i], XmNdeleteResponse, XmUNMAP); i++;
        XtSetArg(argList[i], XmNcolormap,
		 DefaultColormapOfScreen(XtScreen(rootWidget))); i++;
        profile->top = XtCreatePopupShell("Profile", transientShellWidgetClass,
                                        rootWidget, argList, i);

	profile->mainWindow = XmCreateForm(profile->top,"Profile",argList,i);
	XtManageChild(profile->mainWindow);

	        i=0;
        XtSetArg(argList[i],XmNwidth,400); i++;
        XtSetArg(argList[i],XmNheight,300); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
        profile->menuBar= XmCreateMenuBar(profile->mainWindow,0,argList,i);
        XtManageChild(profile->menuBar);

        i=0;
        XtSetArg(argList[i],XmNorientation,XmVERTICAL); i++;
        profile->pulldown[0] = XmCreatePulldownMenu(profile->menuBar,"pulldown",
                                                        argList,i);

        i=0;
        label = XmStringCreateLtoR("File",XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNsubMenuId,profile->pulldown[0]); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNmnemonic,'F'); i++;
        b = XmCreateCascadeButton(profile->menuBar,0,argList,i);
        XtManageChild(b);

        i=0;
        label = XmStringCreateLtoR("Print",XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNmnemonic,'P'); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        profile->button[0]= XmCreatePushButtonGadget(profile->pulldown[0],
                                "menuButton",argList,i);
        XtAddCallback(profile->button[0],XmNactivateCallback,
					CBProfPrint,(caddr_t)profile);
        i=0;
        label = XmStringCreateLtoR("Done",XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNmnemonic,'D'); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        profile->button[1]= XmCreatePushButtonGadget(profile->pulldown[0],
                                "menuButton", argList,i);
        XtAddCallback(profile->button[1],XmNactivateCallback,
					CBProfDone,(caddr_t)profile);
	/*XtManageChildren(profile->button, 2);*/
	XtManageChild(profile->button[1]);

        i=0;
        XtSetArg(argList[i],XmNtopWidget,profile->menuBar); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_WIDGET); i++;
        XtSetArg(argList[i],XmNbottomAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNx,0); i++;
        XtSetArg(argList[i],XmNy,30); i++;
        XtSetArg(argList[i],XmNwidth,400); i++;
        XtSetArg(argList[i],XmNheight,300); i++;

        profile->profileWin = XmCreateForm(profile->mainWindow,"Profile", 
					argList,i);
        XtManageChild(profile->profileWin);
        XtAddEventHandler(profile->profileWin,ExposureMask,0,
                                CBProfileExpose,(caddr_t)profile);
        XtAddEventHandler(profile->profileWin,StructureNotifyMask,0,
                                CBProfileExpose,(caddr_t)profile);
        XtAddEventHandler(profile->top,StructureNotifyMask,0,
                                CBMapChange,(caddr_t)profile);

	XtAddEventHandler(profile->profileWin, ButtonPressMask, 0,
				CBInitProfBox, (caddr_t)profile);
	XtAddEventHandler(profile->profileWin, ButtonMotionMask, 0,
				CBProfBox, (caddr_t)profile);
	XtAddEventHandler(profile->profileWin, ButtonReleaseMask, 0,
				CBDoneProfBox, (caddr_t)profile);

	profile->profileGC = XtGetGC(profile->profileWin,0,&gcval);
	fontStruct = XQueryFont(myDpy,XGContextFromGC(profile->profileGC));
	if (!fontStruct) {
		profile->fontWidth = 13;
		profile->fontHeight = 13;
		}
	else {
		profile->fontWidth = fontStruct->max_bounds.width;
		profile->fontHeight = fontStruct->max_bounds.ascent +
				      fontStruct->max_bounds.descent;
		}
	profile->selBegX = 0;
	profile->selBegY = 0;
	profile->selEndX = 0;
	profile->selEndY = 0;
	
        XtSetArg(argList[0], XmNforeground, &(profile->foreground));
        XtSetArg(argList[1], XmNbackground, &(profile->background));
        XtGetValues(profile->profileWin, argList, 2);

	
	if (profile->data->type == D_FLOAT) {
		profile->format = "% 6.3g";
	      }
	else {
		profile->format = "%3d";
	      }

	ListAddEntry(profileList,profile);
	profile->amIShowing = FALSE;

	return(profile);

}

static void UpdateProfile(profile, d)
    Profile *profile;
    Cdata *d;
{
	if (d->type == D_FLOAT || d->type == D_INT) {
		profile->minValue = d->min;
		profile->maxValue = d->max;
	}
	else if (d->type == D_CHAR) {
		profile->minValue.i = 0;
		profile->maxValue.i = 255;
	}
	if (d->type == D_FLOAT)
		profile->format = "% 6.3g";
	else
		profile->format = "%3d";
	
/*
	if (!profile->amIShowing) {
	  XtPopup(profile->top, XtGrabNone);
	  profile->amIShowing = TRUE;
	}
	else {
	  CBProfileExpose(profile->profileWin,(caddr_t)profile,(XEvent *)0);
	}
*/
/****************/
	XtPopup(profile->top, XtGrabNone);
	profile->amIShowing = TRUE;
	CBProfileExpose(profile->profileWin,(caddr_t)profile,(XEvent *)0);
/****************/
}

static void ProfileChange(col)
Col *col;
{
  Profile *profile;
  Cdata *d;

  if (col->selType != COL_LINE)
    return;

  if (col->dim != 2) {
    ErrMesg("DTM COLclass protocol error, COL_LINE but dim !=2\n");
    return;
  }

	/*
	if ((strcmp(col->func,"PROFILE")) 
		return;
	*/

  d = CdataSearchByName(col->title);
  if ((d != NULL)&&(d->V->type == V_RASTER))
    {
	View *V = d->V;
	profile = ProfileSearchByName(col->title);
	if (profile == NULL) {
	  profile = ProfileCreate(V->shell, d);
	}
	profile->selBegX = col->data[0].x;
	profile->selBegY = col->data[0].y;
	profile->selEndX = col->data[1].x;
	profile->selEndY = col->data[1].y;

	UpdateProfile(profile, d);
    }
}

void ProfileInternalChange(title,x1,y1,x2,y2)
char *title;
int x1,y1,x2,y2;
{
  Profile *profile;
  Cdata *d;

  d = CdataSearchByName(title);
  if ((d != NULL)&&(d->V->type == V_RASTER))
    {
	View *V = d->V;
	profile = ProfileSearchByName(title);
	if (profile == NULL) {
	  profile = ProfileCreate(V->shell, d);
	}
	profile->selBegX = x1;
	profile->selBegY = y1;
	profile->selEndX = x2;
	profile->selEndY = y2;

	if (d->type == D_FLOAT || d->type == D_INT) {
		profile->minValue = d->min;
		profile->maxValue = d->max;
	}
	else if (profile->data->type == D_CHAR) {
		profile->minValue.i = 0;
		profile->maxValue.i = 255;
	}
	if (d->type == D_FLOAT)
	  profile->format = "% 6.3g";
	else
	  profile->format = "%3d";

	if (!profile->amIShowing) {
	  XtPopup(profile->top, XtGrabNone);
	  profile->amIShowing = TRUE;
	}
	else {
	  CBProfileExpose(profile->profileWin,(caddr_t)profile,(XEvent *)0);
	}
    }
}

/*ARGSUSED*/
void ProfNew(col,garbage)
Col *col;
caddr_t garbage;
{
	ProfileChange(col);
}

/*ARGSUSED*/
void ProfChange(col,garbage)
Col *col;
caddr_t garbage;
{
	ProfileChange(col);
}


/*ARGSUSED*/
void ProfDestroy(col,garbage)
Col *col;
caddr_t garbage;
{
}


/*ARGSUSED*/
void ProfChangeDOL(dol,garbage)
Dol *dol;
caddr_t garbage;
{
	Profile *profile;
	Cdata *d;

	if (dol->selType != DOL_LINE)
		return;

	if (dol->dim != 4) {
		ErrMesg("DTM DOLclass protocol error, DOL_LINE but dim !=4\n");
		return;
	}

	/*
	if ((strcmp(dol->func,"PROFILE")) 
		return;
	*/

	d = CdataSearchByName(dol->title);
	if ((d != NULL)&&(d->V->type == V_RASTER)) {
		View *V = d->V;
		profile = ProfileSearchByName(dol->title);
		if (profile == NULL) {
			profile = ProfileCreate(V->shell, d);
		}
		profile->selBegX = dol->data[0];
		profile->selBegY = dol->data[1];
		profile->selEndX = dol->data[2];
		profile->selEndY = dol->data[3];

		UpdateProfile(profile, d);
	}
}

void ProfNewDOL(dol,garbage)
Dol *dol;
caddr_t garbage;
{
	ProfChangeDOL(dol, garbage);
}


ProfileInit(rootWindow)
Widget rootWindow;
{
	myDpy = XtDisplay(rootWindow);

	profileList = ListCreate();
}

