#include <stdio.h>
#include <math.h>
#include <string.h>

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/ScrollBar.h>
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/RowColumn.h>
#include <Xm/ScrolledW.h>


#include "collage.h"
#include "net.h"

#define MODULE_NAME	"CHAT"

typedef struct {
	Widget shell;
	Widget mainWindow;
	Widget mainForm;
	Widget menuBar;
	Widget textOut;
	Widget textIn;
	} ChatStuff;

static void ChatIncoming();
extern char *UserID;
static	ChatStuff *theChatBox;  /* only have one for now */


static void CBChatInput(w,client_data,call_data)
/* called when user presses return on keyboard  */
Widget w;
caddr_t client_data;
caddr_t call_data;
{
ChatStuff *c;
char *toSend;
char *p,*o;

	c = (ChatStuff *) client_data;
	toSend = XmTextFieldGetString(c->textIn);

	/* a '\'' conflicts with DTM string terminator...must be removed */
	while(p = strchr(toSend,'\'')) {
		o = p;
		while(*p++) {
			*o++ = *p; 
			}
		}

#ifdef DEBUG
	printf("CBChatTry(): I've been called\n");
	printf("CBChatTry(): string = \"%s\"\n", toSend);
#endif
	XmTextFieldSetString(c->textIn,"");
	NetSendMessage(0,toSend,0,0,0,0);

	{/* temprorary...should be handled in a call back from net module*/
	char myMessage[1024];
	sprintf(myMessage,"%s: %s",UserID,toSend);
	ChatIncoming(myMessage,0);
	}

	XtFree(toSend);
}


void CBChatBoxOpen(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
        XtManageChild(theChatBox->shell);
}

static void CBChatBoxClose(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
        XtUnmanageChild(theChatBox->shell);
}


ChatStuff *CreateChatBox(rootWidget)
Widget rootWidget;
{
Arg argList[20];
Cardinal i=0;
Widget separator,labelWidget1, labelWidget2;
ChatStuff *c;
XmString label;
Widget pulldown;
Widget b;


	if (!(c = (ChatStuff *) MALLOC(sizeof(ChatStuff)))) {
		ErrMesg("Out of Memory making chat box");
		return(0);
		}
        i = 0;
        XtSetArg(argList[i], XmNallowShellResize, True); i++;
        XtSetArg(argList[i], XtNtitle, "Chat Box"); i++;
        XtSetArg(argList[i], XmNkeyboardFocusPolicy, XmPOINTER); i++;
        XtSetArg(argList[i], XmNdeleteResponse, XmUNMAP); i++;
        c->shell = XtCreatePopupShell("Chat Box", 
			transientShellWidgetClass, rootWidget, argList, i);

        c->mainWindow = XmCreateForm(c->shell, "ChatBox", argList, i);
        XtManageChild(c->mainWindow);

	/* menus */
        i = 0;
        XtSetArg(argList[i], XmNtopAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
        c->menuBar = XmCreateMenuBar(c->mainWindow, "menuBar" ,argList, i);
	XtManageChild(c->menuBar);

        i=0;
        XtSetArg(argList[i],XmNorientation,XmVERTICAL); i++;
        pulldown = XmCreatePulldownMenu(c->menuBar,"pulldown", argList,i);

        i=0;
        label = XmStringCreateSimple("File");
        XtSetArg(argList[i],XmNsubMenuId,pulldown); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNmnemonic,'F'); i++;
        b = XmCreateCascadeButton(c->menuBar,0,argList,i);
        XtManageChild(b);
        XmStringFree(label);

        i=0;
        label = XmStringCreateSimple("Close");
        XtSetArg(argList[i],XmNmnemonic,'C'); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        b = XmCreatePushButtonGadget(pulldown,"menuButton",argList,i);
	XtAddCallback(b,XmNactivateCallback,CBChatBoxClose,(caddr_t)c);
        XtManageChild(b);
        XmStringFree(label);

	/*---------------------------------------*/

	i=0;
        XtSetArg(argList[i],XmNtopWidget,c->menuBar); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_WIDGET); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNbottomAttachment,XmATTACH_FORM); i++;
        c->mainForm = XmCreateForm(c->mainWindow,"ChatBox",argList,i);
        XtManageChild(c->mainForm);

	/* output window label */
	i=0;
	label = XmStringCreateSimple("Chat Session:");
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNresizable,True); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNalignment,XmALIGNMENT_BEGINNING); i++;
	labelWidget1 = XmCreateLabel(c->mainForm,"label",argList,i);
	XtManageChild(labelWidget1);
        XmStringFree(label);

	/* input window */
        i=0;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNbottomAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNeditable,True); i++;
        c->textIn = XmCreateTextField(c->mainForm,"Text",argList,i);
        XtManageChild(c->textIn);
	XtAddCallback(c->textIn,XmNactivateCallback,CBChatInput,c);

	/* input window label */
	i=0;
	label = XmStringCreateSimple("Input:");
	XtSetArg(argList[i],XmNbottomWidget,c->textIn); i++;
        XtSetArg(argList[i],XmNbottomAttachment,XmATTACH_WIDGET); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNresizable,False); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNalignment,XmALIGNMENT_BEGINNING); i++;
	labelWidget2 = XmCreateLabel(c->mainForm,"label",argList,i);
	XtManageChild(labelWidget2);
        XmStringFree(label);

	/* separator */
        i=0;
	XtSetArg(argList[i],XmNbottomWidget,labelWidget2); i++;
        XtSetArg(argList[i],XmNbottomAttachment,XmATTACH_WIDGET); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
        separator = XmCreateSeparator(c->mainForm,0, argList,i);
        XtManageChild(separator);

	/* output window */
        i=0;
	XtSetArg(argList[i],XmNbottomWidget,separator); i++;
        XtSetArg(argList[i],XmNwidth,600); i++;
        XtSetArg(argList[i],XmNheight,150); i++;
        XtSetArg(argList[i],XmNtopWidget,labelWidget1); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_WIDGET); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNbottomAttachment,XmATTACH_WIDGET); i++;
        XtSetArg(argList[i],XmNeditable,False); i++;
        XtSetArg(argList[i],XmNscrollVertical,True); i++;
        XtSetArg(argList[i],XmNscrollLeftSide,False); i++;
        XtSetArg(argList[i],XmNscrollBarDisplayPolicy,XmSTATIC); i++;
/***/
        XtSetArg(argList[i],XmNeditMode,XmMULTI_LINE_EDIT); i++;
/***/
        c->textOut = XmCreateScrolledText(c->mainForm,"Text",argList,i);
        XtManageChild(c->textOut);
	
	return(c);

}

static void ChatIncoming(mesg,client_data)
/* This routine called when chat messages come in throught the network*/
char *mesg; 		/* contains incoming network text */
caddr_t client_data; 	/* ignored */
{
#ifdef DEBUG
	printf("incoming text:%s\n",mesg);
#endif
	XmTextInsert(theChatBox->textOut,
			XmTextGetLastPosition(theChatBox->textOut),"\n");
	XmTextInsert(theChatBox->textOut,
			XmTextGetLastPosition(theChatBox->textOut),mesg);

	XmTextShowPosition(theChatBox->textOut,
			XmTextGetLastPosition(theChatBox->textOut));

        XtManageChild(theChatBox->shell);
/*
        XRaiseWindow(XtWindow(theChatBox->shell));
*/

}



void InitChatBox(rootWidget)
Widget rootWidget;
{
	theChatBox = CreateChatBox(rootWidget);
	NetRegisterModule(MODULE_NAME,NETMSG,ChatIncoming,0,
					ChatIncoming,0,
					0,0);
}

